<?php
if (!defined('ABSPATH')) exit;

class ACE_BLP_Calculator {

    public static function get_settings() {
        $settings = get_option('ace_backyard_lp_settings', array());
        $defaults = ace_blp_get_defaults();

        return array(
            'sizes' => $settings['calc_sizes'] ?? $defaults['calc_sizes'],
            'features' => $settings['calc_features'] ?? $defaults['calc_features'],
            'finishes' => $settings['calc_finishes'] ?? $defaults['calc_finishes'],
            'low_mult' => floatval($settings['calc_low_mult'] ?? $defaults['calc_low_mult']),
            'high_mult' => floatval($settings['calc_high_mult'] ?? $defaults['calc_high_mult']),
            'default_features' => $settings['calc_default_features'] ?? $defaults['calc_default_features'],
            'default_size' => intval($settings['calc_default_size'] ?? $defaults['calc_default_size']),
            'default_finish' => intval($settings['calc_default_finish'] ?? $defaults['calc_default_finish']),
        );
    }

    public static function calculate($size_index, $feature_indices, $finish_index) {
        $calc = self::get_settings();

        $size = $calc['sizes'][$size_index] ?? $calc['sizes'][1];
        $finish = $calc['finishes'][$finish_index] ?? $calc['finishes'][1];
        $finish_key = $finish['key'];

        $total = 0;
        foreach ($feature_indices as $fi) {
            if (isset($calc['features'][$fi])) {
                $total += floatval($calc['features'][$fi][$finish_key] ?? 0);
            }
        }

        $total *= floatval($size['multiplier']);

        $low = round($total * $calc['low_mult'] / 1000) * 1000;
        $high = round($total * $calc['high_mult'] / 1000) * 1000;

        return array('low' => $low, 'high' => $high);
    }
}
