/* Mapbox GL JS is Copyright © 2020 Mapbox and subject to the Mapbox Terms of Service ((https://www.mapbox.com/legal/tos/). */
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
    typeof define === 'function' && define.amd ? define(factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.mapboxgl = factory());
    })(this, (function () { 'use strict';
    
    /* eslint-disable */
    
    var shared, worker, mapboxgl;
    // define gets called three times: one for each chunk. we rely on the order
    // they're imported to know which is which
    function define(_, chunk) {
    if (!shared) {
        shared = chunk;
    } else if (!worker) {
        worker = chunk;
    } else {
        var workerBundleString = "self.onerror = function() { console.error('An error occurred while parsing the WebWorker bundle. This is most likely due to improper transpilation by Babel; please see https://docs.mapbox.com/mapbox-gl-js/guides/install/#transpiling'); }; var sharedChunk = {}; (" + shared + ")(sharedChunk); (" + worker + ")(sharedChunk); self.onerror = null;"
    
        var sharedChunk = {};
        shared(sharedChunk);
        mapboxgl = chunk(sharedChunk);
        if (typeof window !== 'undefined' && window && window.URL && window.URL.createObjectURL) {
            mapboxgl.workerUrl = window.URL.createObjectURL(new Blob([workerBundleString], { type: 'text/javascript' }));
        }
    }
    }
    
    
    define(["exports"],(function(t){var e=1e-6,r="undefined"!=typeof Float32Array?Float32Array:Array;function n(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],o=r*s-i*n;return o?(t[0]=s*(o=1/o),t[1]=-n*o,t[2]=-i*o,t[3]=r*o,t):null}function i(){var t=new r(9);return r!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t}function s(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],o=e[4],a=e[5],l=e[6],u=e[7],c=e[8];return t[0]=o*c-a*u,t[1]=i*u-n*c,t[2]=n*a-i*o,t[3]=a*l-s*c,t[4]=r*c-i*l,t[5]=i*s-r*a,t[6]=s*u-o*l,t[7]=n*l-r*u,t[8]=r*o-n*s,t}function o(t,e,r){var n=e[0],i=e[1],s=e[2],o=e[3],a=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=r[0],f=r[1],d=r[2],m=r[3],y=r[4],g=r[5],x=r[6],v=r[7],b=r[8];return t[0]=p*n+f*o+d*u,t[1]=p*i+f*a+d*c,t[2]=p*s+f*l+d*h,t[3]=m*n+y*o+g*u,t[4]=m*i+y*a+g*c,t[5]=m*s+y*l+g*h,t[6]=x*n+v*o+b*u,t[7]=x*i+v*a+b*c,t[8]=x*s+v*l+b*h,t}function a(){var t=new r(16);return r!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t}function l(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function u(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],o=e[4],a=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],m=e[13],y=e[14],g=e[15],x=r*a-n*o,v=r*l-i*o,b=r*u-s*o,w=n*l-i*a,_=n*u-s*a,A=i*u-s*l,M=c*m-h*d,I=c*y-p*d,S=c*g-f*d,z=h*y-p*m,k=h*g-f*m,P=p*g-f*y,E=x*P-v*k+b*z+w*S-_*I+A*M;return E?(t[0]=(a*P-l*k+u*z)*(E=1/E),t[1]=(i*k-n*P-s*z)*E,t[2]=(m*A-y*_+g*w)*E,t[3]=(p*_-h*A-f*w)*E,t[4]=(l*S-o*P-u*I)*E,t[5]=(r*P-i*S+s*I)*E,t[6]=(y*b-d*A-g*v)*E,t[7]=(c*A-p*b+f*v)*E,t[8]=(o*k-a*S+u*M)*E,t[9]=(n*S-r*k-s*M)*E,t[10]=(d*_-m*b+g*x)*E,t[11]=(h*b-c*_-f*x)*E,t[12]=(a*I-o*z-l*M)*E,t[13]=(r*z-n*I+i*M)*E,t[14]=(m*v-d*w-y*x)*E,t[15]=(c*w-h*v+p*x)*E,t):null}function c(t,e,r){var n=e[0],i=e[1],s=e[2],o=e[3],a=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],m=e[12],y=e[13],g=e[14],x=e[15],v=r[0],b=r[1],w=r[2],_=r[3];return t[0]=v*n+b*a+w*h+_*m,t[1]=v*i+b*l+w*p+_*y,t[2]=v*s+b*u+w*f+_*g,t[3]=v*o+b*c+w*d+_*x,t[4]=(v=r[4])*n+(b=r[5])*a+(w=r[6])*h+(_=r[7])*m,t[5]=v*i+b*l+w*p+_*y,t[6]=v*s+b*u+w*f+_*g,t[7]=v*o+b*c+w*d+_*x,t[8]=(v=r[8])*n+(b=r[9])*a+(w=r[10])*h+(_=r[11])*m,t[9]=v*i+b*l+w*p+_*y,t[10]=v*s+b*u+w*f+_*g,t[11]=v*o+b*c+w*d+_*x,t[12]=(v=r[12])*n+(b=r[13])*a+(w=r[14])*h+(_=r[15])*m,t[13]=v*i+b*l+w*p+_*y,t[14]=v*s+b*u+w*f+_*g,t[15]=v*o+b*c+w*d+_*x,t}function h(t,e,r){var n,i,s,o,a,l,u,c,h,p,f,d,m=r[0],y=r[1],g=r[2];return e===t?(t[12]=e[0]*m+e[4]*y+e[8]*g+e[12],t[13]=e[1]*m+e[5]*y+e[9]*g+e[13],t[14]=e[2]*m+e[6]*y+e[10]*g+e[14],t[15]=e[3]*m+e[7]*y+e[11]*g+e[15]):(i=e[1],s=e[2],o=e[3],a=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],t[0]=n=e[0],t[1]=i,t[2]=s,t[3]=o,t[4]=a,t[5]=l,t[6]=u,t[7]=c,t[8]=h,t[9]=p,t[10]=f,t[11]=d,t[12]=n*m+a*y+h*g+e[12],t[13]=i*m+l*y+p*g+e[13],t[14]=s*m+u*y+f*g+e[14],t[15]=o*m+c*y+d*g+e[15]),t}function p(t,e,r){var n=r[0],i=r[1],s=r[2];return t[0]=e[0]*n,t[1]=e[1]*n,t[2]=e[2]*n,t[3]=e[3]*n,t[4]=e[4]*i,t[5]=e[5]*i,t[6]=e[6]*i,t[7]=e[7]*i,t[8]=e[8]*s,t[9]=e[9]*s,t[10]=e[10]*s,t[11]=e[11]*s,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t}function f(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[4],o=e[5],a=e[6],l=e[7],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=s*i+u*n,t[5]=o*i+c*n,t[6]=a*i+h*n,t[7]=l*i+p*n,t[8]=u*i-s*n,t[9]=c*i-o*n,t[10]=h*i-a*n,t[11]=p*i-l*n,t}function d(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],o=e[1],a=e[2],l=e[3],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i-u*n,t[1]=o*i-c*n,t[2]=a*i-h*n,t[3]=l*i-p*n,t[8]=s*n+u*i,t[9]=o*n+c*i,t[10]=a*n+h*i,t[11]=l*n+p*i,t}function m(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],o=e[1],a=e[2],l=e[3],u=e[4],c=e[5],h=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i+u*n,t[1]=o*i+c*n,t[2]=a*i+h*n,t[3]=l*i+p*n,t[4]=u*i-s*n,t[5]=c*i-o*n,t[6]=h*i-a*n,t[7]=p*i-l*n,t}function y(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function g(t,r,n){var i,s,o,a=n[0],l=n[1],u=n[2],c=Math.hypot(a,l,u);return c<e?null:(a*=c=1/c,l*=c,u*=c,i=Math.sin(r),s=Math.cos(r),t[0]=a*a*(o=1-s)+s,t[1]=l*a*o+u*i,t[2]=u*a*o-l*i,t[3]=0,t[4]=a*l*o-u*i,t[5]=l*l*o+s,t[6]=u*l*o+a*i,t[7]=0,t[8]=a*u*o+l*i,t[9]=l*u*o-a*i,t[10]=u*u*o+s,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t)}function x(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],o=r+r,a=n+n,l=i+i,u=r*o,c=n*o,h=n*a,p=i*o,f=i*a,d=i*l,m=s*o,y=s*a,g=s*l;return t[0]=1-h-d,t[1]=c+g,t[2]=p-y,t[3]=0,t[4]=c-g,t[5]=1-u-d,t[6]=f+m,t[7]=0,t[8]=p+y,t[9]=f-m,t[10]=1-u-h,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)});var v=c;function b(){var t=new r(3);return r!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function w(t){var e=new r(3);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e}function _(t){return Math.hypot(t[0],t[1],t[2])}function A(t,e,n){var i=new r(3);return i[0]=t,i[1]=e,i[2]=n,i}function M(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t}function I(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t}function S(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t}function z(t,e,r){return t[0]=Math.min(e[0],r[0]),t[1]=Math.min(e[1],r[1]),t[2]=Math.min(e[2],r[2]),t}function k(t,e,r){return t[0]=Math.max(e[0],r[0]),t[1]=Math.max(e[1],r[1]),t[2]=Math.max(e[2],r[2]),t}function P(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t}function E(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t}function T(t,e){var r=e[0]-t[0],n=e[1]-t[1],i=e[2]-t[2];return r*r+n*n+i*i}function B(t){var e=t[0],r=t[1],n=t[2];return e*e+r*r+n*n}function V(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t}function C(t,e){var r=e[0],n=e[1],i=e[2],s=r*r+n*n+i*i;return s>0&&(s=1/Math.sqrt(s)),t[0]=e[0]*s,t[1]=e[1]*s,t[2]=e[2]*s,t}function F(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}function D(t,e,r){var n=e[0],i=e[1],s=e[2],o=r[0],a=r[1],l=r[2];return t[0]=i*l-s*a,t[1]=s*o-n*l,t[2]=n*a-i*o,t}function L(t,e,r,n){var i=e[0],s=e[1],o=e[2];return t[0]=i+n*(r[0]-i),t[1]=s+n*(r[1]-s),t[2]=o+n*(r[2]-o),t}function R(t,e,r){var n=e[0],i=e[1],s=e[2],o=r[3]*n+r[7]*i+r[11]*s+r[15];return t[0]=(r[0]*n+r[4]*i+r[8]*s+r[12])/(o=o||1),t[1]=(r[1]*n+r[5]*i+r[9]*s+r[13])/o,t[2]=(r[2]*n+r[6]*i+r[10]*s+r[14])/o,t}function O(t,e,r){var n=e[0],i=e[1],s=e[2];return t[0]=n*r[0]+i*r[3]+s*r[6],t[1]=n*r[1]+i*r[4]+s*r[7],t[2]=n*r[2]+i*r[5]+s*r[8],t}function U(t,e,r){var n=r[0],i=r[1],s=r[2],o=e[0],a=e[1],l=e[2],u=i*l-s*a,c=s*o-n*l,h=n*a-i*o,p=i*h-s*c,f=s*u-n*h,d=n*c-i*u,m=2*r[3];return c*=m,h*=m,f*=2,d*=2,t[0]=o+(u*=m)+(p*=2),t[1]=a+c+f,t[2]=l+h+d,t}function N(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]}var j=I,$=S,G=_;function q(){var t=new r(4);return r!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[3]=0),t}function H(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t}function X(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],o=r*r+n*n+i*i+s*s;return o>0&&(o=1/Math.sqrt(o)),t[0]=r*o,t[1]=n*o,t[2]=i*o,t[3]=s*o,t}function Z(t,e,r){var n=e[0],i=e[1],s=e[2],o=e[3];return t[0]=r[0]*n+r[4]*i+r[8]*s+r[12]*o,t[1]=r[1]*n+r[5]*i+r[9]*s+r[13]*o,t[2]=r[2]*n+r[6]*i+r[10]*s+r[14]*o,t[3]=r[3]*n+r[7]*i+r[11]*s+r[15]*o,t}function W(){var t=new r(4);return r!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function Y(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t}function K(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],o=e[3],a=Math.sin(r),l=Math.cos(r);return t[0]=n*l+o*a,t[1]=i*l+s*a,t[2]=s*l-i*a,t[3]=o*l-n*a,t}function J(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],o=e[3],a=Math.sin(r),l=Math.cos(r);return t[0]=n*l-s*a,t[1]=i*l+o*a,t[2]=s*l+n*a,t[3]=o*l-i*a,t}b(),q();var Q,tt,et,rt,nt,it=X,st=(Q=b(),tt=A(1,0,0),et=A(0,1,0),function(t,e,r){var n=F(e,r);return n<-.999999?(D(Q,tt,e),G(Q)<1e-6&&D(Q,et,e),C(Q,Q),function(t,e,r){r*=.5;var n=Math.sin(r);t[0]=n*e[0],t[1]=n*e[1],t[2]=n*e[2],t[3]=Math.cos(r);}(t,Q,Math.PI),t):n>.999999?(t[0]=0,t[1]=0,t[2]=0,t[3]=1,t):(D(Q,e,r),t[0]=Q[0],t[1]=Q[1],t[2]=Q[2],t[3]=1+n,it(t,t))});function ot(){var t=new r(2);return r!=Float32Array&&(t[0]=0,t[1]=0),t}function at(t,e){var n=new r(2);return n[0]=t,n[1]=e,n}function lt(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t}function ut(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t}function ct(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t}function ht(t){return Math.hypot(t[0],t[1])}function pt(t,e){var r=e[0],n=e[1],i=r*r+n*n;return i>0&&(i=1/Math.sqrt(i)),t[0]=e[0]*i,t[1]=e[1]*i,t}function ft(t,e){return t[0]*e[0]+t[1]*e[1]}function dt(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}W(),W(),i(),ot();var mt,yt,gt=function(){if(nt)return rt;function t(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}return nt=1,rt=t,t.prototype={sampleCurveX:function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return ((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var o=0,a=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?o=r:a=r,r=.5*(a-o)+o;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},rt}(),xt=dt(gt);function vt(){if(yt)return mt;function t(t,e){this.x=t,this.y=e;}return yt=1,mt=t,t.prototype={clone:function(){return new t(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=n,this},_rotateAround:function(t,e){var r=Math.cos(t),n=Math.sin(t),i=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y),this.y=i,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},t.convert=function(e){return e instanceof t?e:Array.isArray(e)?new t(e[0],e[1]):e},mt}var bt=dt(vt());function wt(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return !1;for(let r=0;r<t.length;r++)if(!wt(t[r],e[r]))return !1;return !0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return !1;if(Object.keys(t).length!==Object.keys(e).length)return !1;for(const r in t)if(!wt(t[r],e[r]))return !1;return !0}return t===e}const _t=Math.PI/180,At=180/Math.PI;function Mt(t){return t*_t}function It(t){return t*At}const St=[[0,0],[1,0],[1,1],[0,1]];function zt(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}function kt(t,e,r,n){const i=new xt(t,e,r,n);return function(t){return i.solve(t)}}const Pt=kt(.25,.1,.25,1);function Et(t,e,r){return Math.min(r,Math.max(e,t))}function Tt(t,e,r){return (r=Et((r-t)/(e-t),0,1))*r*(3-2*r)}function Bt(t,e,r){const n=r-e,i=((t-e)%n+n)%n+e;return i===e?r:i}function Vt(t,e,r){if(!t.length)return r(null,[]);let n=t.length;const i=new Array(t.length);let s=null;t.forEach(((t,o)=>{e(t,((t,e)=>{t&&(s=t),i[o]=e,0==--n&&r(s,i);}));}));}function Ct(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}let Ft=1;function Dt(){return Ft++}function Lt(t){return t<=1?1:Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))}function Rt(t,e){t.forEach((t=>{e[t]&&(e[t]=e[t].bind(e));}));}function Ot(t,e,r){const n={};for(const r in t)n[r]=e.call(this,t[r],r,t);return n}function Ut(t,e,r){const n={};for(const r in t)e.call(this,t[r],r,t)&&(n[r]=t[r]);return n}function Nt(t){return Array.isArray(t)?t.map(Nt):"object"==typeof t&&t?Ot(t,Nt):t}function jt(t,e){for(let r=0;r<t.length;r++)if(e.indexOf(t[r])>=0)return !0;return !1}const $t={};function Gt(t){$t[t]||("undefined"!=typeof console&&console.warn(t),$t[t]=!0);}function qt(t,e,r){return (r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function Ht(t){let e=0;for(let r,n,i=0,s=t.length,o=s-1;i<s;o=i++)r=t[i],n=t[o],e+=(n.x-r.x)*(r.y+n.y);return e}function Xt([t,e,r]){const n=Mt(e+90),i=Mt(r);return {x:t*Math.cos(n)*Math.sin(i),y:t*Math.sin(n)*Math.sin(i),z:t*Math.cos(i),azimuthal:e,polar:r}}function Zt(t){return ("undefined"!=typeof self||void 0!==t)&&"undefined"!=typeof WorkerGlobalScope&&(void 0!==t?t:self)instanceof WorkerGlobalScope}function Wt(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,r,n,i)=>{const s=n||i;return e[r]=!s||s.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t;}return e}let Yt=null;function Kt(t,e){return [t[4*e],t[4*e+1],t[4*e+2],t[4*e+3]]}function Jt(t,e,r,n){for(;e<r;){const i=e+r>>1;t[i]<n?e=i+1:r=i;}return e}function Qt(t,e,r,n){for(;e<r;){const i=e+r>>1;t[i]<=n?e=i+1:r=i;}return e}function te(t){return t>0?1/(1.001-t):1+t}function ee(t){return t>0?1-1/(1.001-t):-t}function re(t,e,r){return (t-e.min)*(r.max-r.min)/(e.max-e.min)+r.min}const ne={API_URL:"https://api.mapbox.com",get API_URL_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/|\?|$)/i},get API_TILEJSON_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/v[0-9]*\/.*\.json.*$)/i},get API_SPRITE_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*\/sprite.*\..*$)/i},get API_FONTS_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/fonts\/v[0-9]*\/)(.*\.pbf.*$)/i},get API_STYLE_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*$)/i},get API_CDN_URL_REGEX(){return /^((https?:)?\/\/)?api\.mapbox\.c(n|om)(\/mapbox-gl-js\/)(.*$)/i},get EVENTS_URL(){if(!ne.API_URL)return null;try{const t=new URL(ne.API_URL);return "api.mapbox.cn"===t.hostname?"https://events.mapbox.cn/events/v2":"api.mapbox.com"===t.hostname?"https://events.mapbox.com/events/v2":null}catch(t){return null}},SESSION_PATH:"/map-sessions/v1",FEEDBACK_URL:"https://apps.mapbox.com/feedback",TILE_URL_VERSION:"v4",RASTER_URL_PREFIX:"raster/v1",RASTERARRAYS_URL_PREFIX:"rasterarrays/v1",REQUIRE_ACCESS_TOKEN:!0,ACCESS_TOKEN:null,DEFAULT_STYLE:"mapbox://styles/mapbox/standard",MAX_PARALLEL_IMAGE_REQUESTS:16,DRACO_URL:"https://api.mapbox.com/mapbox-gl-js/draco_decoder_gltf_v1.5.6.wasm",MESHOPT_URL:"https://api.mapbox.com/mapbox-gl-js/meshopt_base_v0.20.wasm",MESHOPT_SIMD_URL:"https://api.mapbox.com/mapbox-gl-js/meshopt_simd_v0.20.wasm",BUILDING_GEN_URL:"https://api.mapbox.com/mapbox-gl-js/building-gen/building_gen_v0.3.0.wasm",GLYPHS_URL:"mapbox://fonts/mapbox/{fontstack}/{range}.pbf",TILES3D_URL_PREFIX:"3dtiles/v1"};function ie(t){return ne.API_URL_REGEX.test(t)}function se(t){return ne.API_SPRITE_REGEX.test(t)}let oe,ae,le,ue,ce,he;function pe(){return null==oe&&(oe=self.OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof self.createImageBitmap),oe}const fe={now:()=>void 0!==ue?ue:performance.now(),setNow(t){ue=t;},restoreNow(){ue=void 0;},frame(t){const e=requestAnimationFrame(t);return {cancel:()=>cancelAnimationFrame(e)}},getImageData(t,e=0){const{width:r,height:n}=t;ce||(ce=document.createElement("canvas"));const i=ce.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return (r>ce.width||n>ce.height)&&(ce.width=r,ce.height=n),i.clearRect(-e,-e,r+2*e,n+2*e),i.drawImage(t,0,0,r,n),i.getImageData(-e,-e,r+2*e,n+2*e)},resolveURL:t=>(ae||(ae=document.createElement("a")),ae.href=t,ae.href),get devicePixelRatio(){return window.devicePixelRatio},get prefersReducedMotion(){return !!window.matchMedia&&(null==le&&(le=window.matchMedia("(prefers-reduced-motion: reduce)")),le.matches)},hasCanvasFingerprintNoise(){if(void 0!==he)return he;if(!pe())return he=!1,!1;const t=new OffscreenCanvas(85,1),e=t.getContext("2d",{willReadFrequently:!0});let r=0;for(let n=0;n<t.width;++n)e.fillStyle=`rgba(${r++},${r++},${r++}, 255)`,e.fillRect(n,0,1,1);const n=e.getImageData(0,0,t.width,t.height);r=0;for(let t=0;t<n.data.length;++t)if(t%4!=3&&r++!==n.data[t])return he=!0,!0;return he=!1,!1}};function de(t,e){const r=t.indexOf("?");if(r<0)return `${t}?${new URLSearchParams(e).toString()}`;const n=new URLSearchParams(t.slice(r));for(const t in e)n.set(t,e[t]);return `${t.slice(0,r)}?${n.toString()}`}function me(t,e={persistentParams:[]}){const r=t.indexOf("?");if(r<0)return t;const n=new URLSearchParams,i=new URLSearchParams(t.slice(r));for(const t of e.persistentParams){const e=i.get(t);e&&n.set(t,e);}const s=n.toString();return `${t.slice(0,r)}${s.length>0?`?${s}`:""}`}const ye="mapbox-tiles";let ge=500,xe=50;const ve=["language","worldview","jobid"];let be,we;function _e(){try{return caches}catch(t){}}function Ae(){const t=_e();t&&null==be&&(be=t.open(ye));}let Me=1/0;const Ie={supported:!1,testSupport:function(t){!ke&&ze&&(Pe?Te(t):Se=t);}};let Se,ze,ke=!1,Pe=!1;const Ee="undefined"!=typeof self?self:{};function Te(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,ze),t.isContextLost())return;Ie.supported=!0;}catch(t){}t.deleteTexture(e),ke=!0;}Ee.document&&(ze=Ee.document.createElement("img"),ze.onload=function(){Se&&Te(Se),Se=null,Pe=!0;},ze.onerror=function(){ke=!0,Se=null;},ze.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA=");const Be={Unknown:"Unknown",Style:"Style",Source:"Source",Tile:"Tile",Glyphs:"Glyphs",SpriteImage:"SpriteImage",SpriteJSON:"SpriteJSON",Iconset:"Iconset",Image:"Image",Model:"Model"};"function"==typeof Object.freeze&&Object.freeze(Be);class Ve extends Error{constructor(t,e,r){401===e&&ie(r)&&(t+=": you may have provided an invalid Mapbox access token. See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes"),super(t),this.status=e,this.url=r;}toString(){return `${this.name}: ${this.message} (${this.status}): ${this.url}`}}const Ce=Zt()?()=>self.worker.referrer:()=>("blob:"===location.protocol?parent:self).location.href;const Fe=function(t,e){if(!(/^file:/.test(r=t.url)||/^file:/.test(Ce())&&!/^\w+:/.test(r))){if(self.fetch&&self.Request&&self.AbortController&&Request.prototype.hasOwnProperty("signal"))return function(t,e){const r=new AbortController,n=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,referrer:Ce(),referrerPolicy:t.referrerPolicy,signal:r.signal});let i=!1,s=!1;const o=(a=n.url).indexOf("sku=")>0&&ie(a);var a;"json"===t.type&&n.headers.set("Accept","application/json");const l=(r,i,a)=>{if(s)return;if(r&&"SecurityError"!==r.message&&Gt(r.toString()),i&&a)return u(i);const l=Date.now();fetch(n).then((r=>{if(r.ok){const t=o?r.clone():null;return u(r,t,l)}return e(new Ve(r.statusText,r.status,t.url))})).catch((r=>{"AbortError"!==r.name&&e(new Error(`${r.message} ${t.url}`));}));},u=(r,o,a)=>{("arrayBuffer"===t.type?r.arrayBuffer():"json"===t.type?r.json():r.text()).then((t=>{s||(o&&a&&function(t,e,r){if(Ae(),null==be)return;const n=Wt(e.headers.get("Cache-Control")||"");if(n["no-store"])return;const i={status:e.status,statusText:e.statusText,headers:new Headers};e.headers.forEach(((t,e)=>i.headers.set(e,t))),n["max-age"]&&i.headers.set("Expires",new Date(r+1e3*n["max-age"]).toUTCString());const s=i.headers.get("Expires");if(!s)return;if(new Date(s).getTime()-r<42e4)return;let o=me(t.url,{persistentParams:ve});if(206===e.status){const e=t.headers.get("Range");if(!e)return;i.status=200,o=de(o,{range:e});}!function(t,e){if(void 0===we)try{new Response(new ReadableStream),we=!0;}catch(t){we=!1;}we?e(t.body):t.blob().then(e).catch((t=>Gt(t.message)));}(e,(t=>{const r=new Response(200!==(n=e.status)&&404!==n&&[101,103,204,205,304].includes(n)?null:t,i);var n;Ae(),null!=be&&be.then((t=>t.put(o,r))).catch((t=>Gt(t.message)));}));}(n,o,a),i=!0,e(null,t,r.headers.get("Cache-Control"),r.headers.get("Expires")));})).catch((t=>{s||e(new Error(t.message));}));};return o?function(t,e){if(Ae(),null==be)return e(null);be.then((r=>{let n=me(t.url,{persistentParams:ve});const i=t.headers.get("Range");i&&(n=de(n,{range:i})),r.match(n).then((t=>{const i=function(t){if(!t)return !1;const e=new Date(t.headers.get("Expires")||0),r=Wt(t.headers.get("Cache-Control")||"");return Number(e)>Date.now()&&!r["no-cache"]}(t);r.delete(n).catch(e),i&&r.put(n,t.clone()).catch(e),e(null,t,i);})).catch(e);})).catch(e);}(n,l):l(null,null),{cancel:()=>{s=!0,i||r.abort();}}}(t,e);if(Zt(self)&&self.worker.actor)return self.worker.actor.send("getResource",t,e,void 0,!0)}var r;return function(t,e){const r=new XMLHttpRequest;r.open(t.method||"GET",t.url,!0),"arrayBuffer"===t.type&&(r.responseType="arraybuffer");for(const e in t.headers)r.setRequestHeader(e,t.headers[e]);return "json"===t.type&&(r.responseType="text",r.setRequestHeader("Accept","application/json")),r.withCredentials="include"===t.credentials,r.onerror=()=>{e(new Error(r.statusText));},r.onload=()=>{if((r.status>=200&&r.status<300||0===r.status)&&null!==r.response){let n=r.response;if("json"===t.type)try{n=JSON.parse(r.response);}catch(t){return e(t)}e(null,n,r.getResponseHeader("Cache-Control"),r.getResponseHeader("Expires"));}else e(new Ve(r.statusText,r.status,t.url));},r.send(t.body),{cancel:()=>r.abort()}}(t,e)},De=function(t,e){return Fe(Ct(t,{type:"arrayBuffer"}),e)};function Le(t){const e=document.createElement("a");return e.href=t,e.protocol===location.protocol&&e.host===location.host}const Re="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";let Oe,Ue;Oe=[],Ue=0;const Ne=function(t,e){if(Ie.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),Ue>=ne.MAX_PARALLEL_IMAGE_REQUESTS){const r={requestParameters:t,callback:e,cancelled:!1,cancel(){this.cancelled=!0;}};return Oe.push(r),r}Ue++;let r=!1;const n=()=>{if(!r)for(r=!0,Ue--;Oe.length&&Ue<ne.MAX_PARALLEL_IMAGE_REQUESTS;){const t=Oe.shift(),{requestParameters:e,callback:r,cancelled:n}=t;n||(t.cancel=Ne(e,r).cancel);}},i=De(t,((t,r,i,s)=>{n(),t?e(t):r&&(self.createImageBitmap?function(t,e){const r=new Blob([new Uint8Array(t)],{type:"image/png"});createImageBitmap(r).then((t=>{e(null,t);})).catch((t=>{e(new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`));}));}(r,((t,r)=>e(t,r,i,s))):function(t,e){const r=new Image;r.onload=()=>{e(null,r),URL.revokeObjectURL(r.src),r.onload=null,requestAnimationFrame((()=>{r.src=Re;}));},r.onerror=()=>e(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const n=new Blob([new Uint8Array(t)],{type:"image/png"});r.src=t.byteLength?URL.createObjectURL(n):Re;}(r,((t,r)=>e(t,r,i,s))));}));return {cancel:()=>{i.cancel(),n();}}};var je,$e,Ge,qe={exports:{}},He={exports:{}},Xe={exports:{}},Ze=function(){if(Ge)return qe.exports;Ge=1;var t=(je||(je=1,He.exports=function(t,e){var r,n,i,s,o,a,l,u;for(n=t.length-(r=3&t.length),i=e,o=3432918353,a=461845907,u=0;u<n;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,i=27492+(65535&(s=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*o+(((l>>>16)*o&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295;}return i^=t.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0}),He.exports),e=($e||($e=1,Xe.exports=function(t,e){for(var r,n=t.length,i=e^n,s=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++s;switch(n){case 3:i^=(255&t.charCodeAt(s+2))<<16;case 2:i^=(255&t.charCodeAt(s+1))<<8;case 1:i=1540483477*(65535&(i^=255&t.charCodeAt(s)))+((1540483477*(i>>>16)&65535)<<16);}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0}),Xe.exports);return qe.exports=t,qe.exports.murmur3=t,qe.exports.murmur2=e,qe.exports}(),We=dt(Ze);class Ye{constructor(t,...e){Ct(this,e[0]||{}),this.type=t;}}class Ke extends Ye{constructor(t,e={}){super("error",Ct({error:t},e));}}function Je(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e));}function Qe(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1);}}class tr{on(t,e){return this._listeners=this._listeners||{},Je(t,e,this._listeners),this}off(t,e){return Qe(t,e,this._listeners),Qe(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},Je(t,e,this._oneTimeListeners),this):new Promise((e=>{this.once(t,e);}))}fire(t,e){const r="string"==typeof t?new Ye(t,e):t,n=r.type;if(this.listens(n)){r.target=this;const t=this._listeners&&this._listeners[n]?this._listeners[n].slice():[];for(const e of t)e.call(this,r);const e=this._oneTimeListeners&&this._oneTimeListeners[n]?this._oneTimeListeners[n].slice():[];for(const t of e)Qe(n,t,this._oneTimeListeners),t.call(this,r);const i=this._eventedParent;i&&(Ct(r,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),i.fire(r));}else r instanceof Ke&&console.error(r.error);return this}listens(t){return !!(this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t))}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}class er{constructor(t){"string"==typeof t?this.name=t:(this.name=t.name,this.iconsetId=t.iconsetId);}static from(t){return new er(t)}static toString(t){return t.iconsetId?`${t.name}${t.iconsetId}`:t.name}static parse(t){const[e,r]=t.split("");return new er({name:e,iconsetId:r})}static isEqual(t,e){return t.name===e.name&&t.iconsetId===e.iconsetId}toString(){return er.toString(this)}serialize(){return {name:this.name,iconsetId:this.iconsetId}}}var rr,nr={},ir=function(){if(rr)return nr;rr=1;var t={transparent:[0,0,0,0],aliceblue:[240,248,255,1],antiquewhite:[250,235,215,1],aqua:[0,255,255,1],aquamarine:[127,255,212,1],azure:[240,255,255,1],beige:[245,245,220,1],bisque:[255,228,196,1],black:[0,0,0,1],blanchedalmond:[255,235,205,1],blue:[0,0,255,1],blueviolet:[138,43,226,1],brown:[165,42,42,1],burlywood:[222,184,135,1],cadetblue:[95,158,160,1],chartreuse:[127,255,0,1],chocolate:[210,105,30,1],coral:[255,127,80,1],cornflowerblue:[100,149,237,1],cornsilk:[255,248,220,1],crimson:[220,20,60,1],cyan:[0,255,255,1],darkblue:[0,0,139,1],darkcyan:[0,139,139,1],darkgoldenrod:[184,134,11,1],darkgray:[169,169,169,1],darkgreen:[0,100,0,1],darkgrey:[169,169,169,1],darkkhaki:[189,183,107,1],darkmagenta:[139,0,139,1],darkolivegreen:[85,107,47,1],darkorange:[255,140,0,1],darkorchid:[153,50,204,1],darkred:[139,0,0,1],darksalmon:[233,150,122,1],darkseagreen:[143,188,143,1],darkslateblue:[72,61,139,1],darkslategray:[47,79,79,1],darkslategrey:[47,79,79,1],darkturquoise:[0,206,209,1],darkviolet:[148,0,211,1],deeppink:[255,20,147,1],deepskyblue:[0,191,255,1],dimgray:[105,105,105,1],dimgrey:[105,105,105,1],dodgerblue:[30,144,255,1],firebrick:[178,34,34,1],floralwhite:[255,250,240,1],forestgreen:[34,139,34,1],fuchsia:[255,0,255,1],gainsboro:[220,220,220,1],ghostwhite:[248,248,255,1],gold:[255,215,0,1],goldenrod:[218,165,32,1],gray:[128,128,128,1],green:[0,128,0,1],greenyellow:[173,255,47,1],grey:[128,128,128,1],honeydew:[240,255,240,1],hotpink:[255,105,180,1],indianred:[205,92,92,1],indigo:[75,0,130,1],ivory:[255,255,240,1],khaki:[240,230,140,1],lavender:[230,230,250,1],lavenderblush:[255,240,245,1],lawngreen:[124,252,0,1],lemonchiffon:[255,250,205,1],lightblue:[173,216,230,1],lightcoral:[240,128,128,1],lightcyan:[224,255,255,1],lightgoldenrodyellow:[250,250,210,1],lightgray:[211,211,211,1],lightgreen:[144,238,144,1],lightgrey:[211,211,211,1],lightpink:[255,182,193,1],lightsalmon:[255,160,122,1],lightseagreen:[32,178,170,1],lightskyblue:[135,206,250,1],lightslategray:[119,136,153,1],lightslategrey:[119,136,153,1],lightsteelblue:[176,196,222,1],lightyellow:[255,255,224,1],lime:[0,255,0,1],limegreen:[50,205,50,1],linen:[250,240,230,1],magenta:[255,0,255,1],maroon:[128,0,0,1],mediumaquamarine:[102,205,170,1],mediumblue:[0,0,205,1],mediumorchid:[186,85,211,1],mediumpurple:[147,112,219,1],mediumseagreen:[60,179,113,1],mediumslateblue:[123,104,238,1],mediumspringgreen:[0,250,154,1],mediumturquoise:[72,209,204,1],mediumvioletred:[199,21,133,1],midnightblue:[25,25,112,1],mintcream:[245,255,250,1],mistyrose:[255,228,225,1],moccasin:[255,228,181,1],navajowhite:[255,222,173,1],navy:[0,0,128,1],oldlace:[253,245,230,1],olive:[128,128,0,1],olivedrab:[107,142,35,1],orange:[255,165,0,1],orangered:[255,69,0,1],orchid:[218,112,214,1],palegoldenrod:[238,232,170,1],palegreen:[152,251,152,1],paleturquoise:[175,238,238,1],palevioletred:[219,112,147,1],papayawhip:[255,239,213,1],peachpuff:[255,218,185,1],peru:[205,133,63,1],pink:[255,192,203,1],plum:[221,160,221,1],powderblue:[176,224,230,1],purple:[128,0,128,1],rebeccapurple:[102,51,153,1],red:[255,0,0,1],rosybrown:[188,143,143,1],royalblue:[65,105,225,1],saddlebrown:[139,69,19,1],salmon:[250,128,114,1],sandybrown:[244,164,96,1],seagreen:[46,139,87,1],seashell:[255,245,238,1],sienna:[160,82,45,1],silver:[192,192,192,1],skyblue:[135,206,235,1],slateblue:[106,90,205,1],slategray:[112,128,144,1],slategrey:[112,128,144,1],snow:[255,250,250,1],springgreen:[0,255,127,1],steelblue:[70,130,180,1],tan:[210,180,140,1],teal:[0,128,128,1],thistle:[216,191,216,1],tomato:[255,99,71,1],turquoise:[64,224,208,1],violet:[238,130,238,1],wheat:[245,222,179,1],white:[255,255,255,1],whitesmoke:[245,245,245,1],yellow:[255,255,0,1],yellowgreen:[154,205,50,1]};function e(t){return (t=Math.round(t))<0?0:t>255?255:t}function r(t){return e("%"===t[t.length-1]?parseFloat(t)/100*255:parseInt(t))}function n(t){return (e="%"===t[t.length-1]?parseFloat(t)/100:parseFloat(t))<0?0:e>1?1:e;var e;}function i(t,e,r){return r<0?r+=1:r>1&&(r-=1),6*r<1?t+(e-t)*r*6:2*r<1?e:3*r<2?t+(e-t)*(2/3-r)*6:t}try{nr.parseCSSColor=function(s){var o,a=s.replace(/ /g,"").toLowerCase();if(a in t)return t[a].slice();if("#"===a[0])return 4===a.length?(o=parseInt(a.substr(1),16))>=0&&o<=4095?[(3840&o)>>4|(3840&o)>>8,240&o|(240&o)>>4,15&o|(15&o)<<4,1]:null:7===a.length&&(o=parseInt(a.substr(1),16))>=0&&o<=16777215?[(16711680&o)>>16,(65280&o)>>8,255&o,1]:null;var l=a.indexOf("("),u=a.indexOf(")");if(-1!==l&&u+1===a.length){var c=a.substr(0,l),h=a.substr(l+1,u-(l+1)).split(","),p=1;switch(c){case "rgba":if(4!==h.length)return null;p=n(h.pop());case "rgb":return 3!==h.length?null:[r(h[0]),r(h[1]),r(h[2]),p];case "hsla":if(4!==h.length)return null;p=n(h.pop());case "hsl":if(3!==h.length)return null;var f=(parseFloat(h[0])%360+360)%360/360,d=n(h[1]),m=n(h[2]),y=m<=.5?m*(d+1):m+d-m*d,g=2*m-y;return [e(255*i(g,y,f+1/3)),e(255*i(g,y,f)),e(255*i(g,y,f-1/3)),p];default:return null}}return null};}catch(t){}return nr}();class sr{constructor(t,e,r,n=1){this.r=t,this.g=e,this.b=r,this.a=n;}static parse(t){if(!t)return;if(t instanceof sr)return t;if("string"!=typeof t)return;const e=ir.parseCSSColor(t);return e?new sr(e[0]/255,e[1]/255,e[2]/255,e[3]):void 0}toString(){const[t,e,r,n]=[this.r,this.g,this.b,this.a];return `rgba(${Math.round(255*t)},${Math.round(255*e)},${Math.round(255*r)},${n})`}toNonPremultipliedRenderColor(t){const{r:e,g:r,b:n,a:i}=this;return new ar(t,e,r,n,i)}toPremultipliedRenderColor(t){const{r:e,g:r,b:n,a:i}=this;return new lr(t,e*i,r*i,n*i,i)}clone(){return new sr(this.r,this.g,this.b,this.a)}}class or{constructor(t,e,r,n,i,s=!1){if(this.premultiplied=!1,this.premultiplied=s,t){const s=t.image.height,o=s*s;this.premultiplied?(e=0===i?0:e/i*(s-1),r=0===i?0:r/i*(s-1),n=0===i?0:n/i*(s-1)):(e*=s-1,r*=s-1,n*=s-1);const a=Math.floor(e),l=Math.floor(r),u=Math.floor(n),c=Math.ceil(e),h=Math.ceil(r),p=Math.ceil(n),f=e-a,d=r-l,m=n-u,y=t.image.data,g=4*(a+l*o+u*s),x=4*(a+l*o+p*s),v=4*(a+h*o+u*s),b=4*(a+h*o+p*s),w=4*(c+l*o+u*s),_=4*(c+l*o+p*s),A=4*(c+h*o+u*s),M=4*(c+h*o+p*s);if(g<0||M>=y.length)throw new Error("out of range");this.r=ur(ur(ur(y[g],y[x],m),ur(y[v],y[b],m),d),ur(ur(y[w],y[_],m),ur(y[A],y[M],m),d),f)/255*(this.premultiplied?i:1),this.g=ur(ur(ur(y[g+1],y[x+1],m),ur(y[v+1],y[b+1],m),d),ur(ur(y[w+1],y[_+1],m),ur(y[A+1],y[M+1],m),d),f)/255*(this.premultiplied?i:1),this.b=ur(ur(ur(y[g+2],y[x+2],m),ur(y[v+2],y[b+2],m),d),ur(ur(y[w+2],y[_+2],m),ur(y[A+2],y[M+2],m),d),f)/255*(this.premultiplied?i:1),this.a=i;}else this.r=e,this.g=r,this.b=n,this.a=i;}toArray(){const{r:t,g:e,b:r,a:n}=this;return [255*t,255*e,255*r,n]}toHslaArray(){let{r:t,g:e,b:r,a:n}=this;if(this.premultiplied){if(0===n)return [0,0,0,0];t/=n,e/=n,r/=n;}const i=Math.min(Math.max(t,0),1),s=Math.min(Math.max(e,0),1),o=Math.min(Math.max(r,0),1),a=Math.min(i,s,o),l=Math.max(i,s,o),u=(a+l)/2;if(a===l)return [0,0,100*u,n];const c=l-a,h=u>.5?c/(2-l-a):c/(l+a);let p=0;return l===i?p=(s-o)/c+(s<o?6:0):l===s?p=(o-i)/c+2:l===o&&(p=(i-s)/c+4),p*=60,[Math.min(Math.max(p,0),360),Math.min(Math.max(100*h,0),100),Math.min(Math.max(100*u,0),100),n]}toArray01(){const{r:t,g:e,b:r,a:n}=this;return [t,e,r,n]}toArray01Scaled(t){const{r:e,g:r,b:n}=this;return [e*t,r*t,n*t]}toArray01Linear(){const{r:t,g:e,b:r,a:n}=this;return [Math.pow(t,2.2),Math.pow(e,2.2),Math.pow(r,2.2),n]}}class ar extends or{constructor(t,e,r,n,i){super(t,e,r,n,i,!1);}}class lr extends or{constructor(t,e,r,n,i){super(t,e,r,n,i,!0);}}function ur(t,e,r){return t*(1-r)+e*r}function cr(t,e,r){return t.map(((t,n)=>ur(t,e[n],r)))}sr.black=new sr(0,0,0,1),sr.white=new sr(1,1,1,1),sr.transparent=new sr(0,0,0,0),sr.red=new sr(1,0,0,1),sr.blue=new sr(0,0,1,1);var hr=Object.freeze({__proto__:null,array:cr,color:function(t,e,r){return new sr(ur(t.r,e.r,r),ur(t.g,e.g,r),ur(t.b,e.b,r),ur(t.a,e.a,r))},number:ur});function pr(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}class fr extends Error{constructor(t,e){super(e),this.message=e,this.key=t;}}class dr{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r;}concat(t){return new dr(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return !!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const mr={kind:"null"},yr={kind:"number"},gr={kind:"string"},xr={kind:"boolean"},vr={kind:"color"},br={kind:"object"},wr={kind:"value"},_r={kind:"collator"},Ar={kind:"formatted"},Mr={kind:"resolvedImage"};function Ir(t,e){return {kind:"array",itemType:t,N:e}}function Sr(t){if("array"===t.kind){const e=Sr(t.itemType);return "number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const zr=[mr,yr,gr,xr,vr,Ar,br,Ir(wr),Mr];function kr(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!kr(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else {if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of zr)if(!kr(t,e))return null}return `Expected ${Sr(t)} but found ${Sr(e)} instead.`}function Pr(t,e){return e.some((e=>e.kind===t.kind))}function Er(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}function Tr(t,e){return "array"===t.kind&&"array"===e.kind?t.N===e.N&&Tr(t.itemType,e.itemType):t.kind===e.kind}class Br{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}class Vr{constructor(t,e,r,n,i){this.text=t.normalize?t.normalize():t,this.image=e,this.scale=r,this.fontStack=n,this.textColor=i;}}class Cr{constructor(t){this.sections=t;}static fromString(t){return new Cr([new Vr(t,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||!!t.image&&t.image.hasPrimary()))}static factory(t){return t instanceof Cr?t:Cr.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}serialize(){const t=["format"];for(const e of this.sections){if(e.image){const r=e.image.getPrimary().id.toString();t.push(["image",r]);continue}t.push(e.text);const r={};e.fontStack&&(r["text-font"]=["literal",e.fontStack.split(",")]),e.scale&&(r["font-scale"]=e.scale),e.textColor&&(r["text-color"]=["rgba"].concat(e.textColor.toNonPremultipliedRenderColor(null).toArray())),t.push(r);}return t}}class Fr{constructor(t,e={}){if(this.id=er.from(t),this.options=Object.assign({},e),e.transform){const{a:t,b:r,c:n,d:i,e:s,f:o}=e.transform;this.options.transform=new DOMMatrix([t,r,n,i,s,o]);}else this.options.transform=new DOMMatrix([1,0,0,1,0,0]);}toString(){const{a:t,b:e,c:r,d:n,e:i,f:s}=this.options.transform;return JSON.stringify({name:this.id.name,iconsetId:this.id.iconsetId,params:this.options.params,transform:{a:t,b:e,c:r,d:n,e:i,f:s}})}static parse(t){let e,r,n,i;try{({name:e,iconsetId:r,params:n,transform:i}=JSON.parse(t)||{});}catch(t){return null}if(!e)return null;const{a:s,b:o,c:a,d:l,e:u,f:c}=i||{};return new Fr({name:e,iconsetId:r},{params:n,transform:new DOMMatrix([s,o,a,l,u,c])})}scaleSelf(t,e){return this.options.transform.scaleSelf(t,e),this}}class Dr{constructor(t,e,r,n,i=!1){this.primaryId=er.from(t),this.primaryOptions=e,r&&(this.secondaryId=er.from(r)),this.secondaryOptions=n,this.available=i;}toString(){return this.primaryId&&this.secondaryId?`[${this.primaryId.name},${this.secondaryId.name}]`:this.primaryId.name}hasPrimary(){return !!this.primaryId}getPrimary(){return new Fr(this.primaryId,this.primaryOptions)}hasSecondary(){return !!this.secondaryId}getSecondary(){return this.secondaryId?new Fr(this.secondaryId,this.secondaryOptions):null}static from(t){return "string"==typeof t?Dr.build({name:t}):t}static build(t,e,r,n){return !t||"object"==typeof t&&!("name"in t)?null:new Dr(t,r,e,n)}}function Lr(t,e,r,n){return "number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function Rr(t){if(null===t)return !0;if("string"==typeof t)return !0;if("boolean"==typeof t)return !0;if("number"==typeof t)return !0;if(t instanceof sr)return !0;if(t instanceof Br)return !0;if(t instanceof Cr)return !0;if(t instanceof Dr)return !0;if(Array.isArray(t)){for(const e of t)if(!Rr(e))return !1;return !0}if("object"==typeof t){for(const e in t)if(!Rr(t[e]))return !1;return !0}return !1}function Or(t){if(null===t)return mr;if("string"==typeof t)return gr;if("boolean"==typeof t)return xr;if("number"==typeof t)return yr;if(t instanceof sr)return vr;if(t instanceof Br)return _r;if(t instanceof Cr)return Ar;if(t instanceof Dr)return Mr;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=Or(e);if(r){if(r===t)continue;r=wr;break}r=t;}return Ir(r||wr,e)}return br}function Ur(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof Cr||t instanceof Dr||t instanceof sr?t.toString():JSON.stringify(t)}class Nr{constructor(t,e){this.type=t,this.value=e;}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!Rr(t[1]))return e.error("invalid value");const r=t[1];let n=Or(r);const i=e.expectedType;return "array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new Nr(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return !0}serialize(){return "array"===this.type.kind||"object"===this.type.kind?["literal",this.value]:this.value instanceof sr?["rgba"].concat(this.value.toNonPremultipliedRenderColor(null).toArray()):this.value instanceof Cr?this.value.serialize():this.value}}class jr{constructor(t){this.name="ExpressionEvaluationError",this.message=t;}toJSON(){return this.message}}const $r={string:gr,number:yr,boolean:xr,object:br};class Gr{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const i=t[0];if("array"===i){let i,s;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in $r)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);i=$r[r],n++;}else i=wr;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],n++;}r=Ir(i,s);}else r=$r[i];const s=[];for(;n<t.length;n++){const r=e.parse(t[n],n,wr);if(!r)return null;s.push(r);}return new Gr(r,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!kr(this.type,Or(r)))return r;if(e===this.args.length-1)throw new jr(`The expression ${JSON.stringify(this.args[e].serialize())} evaluated to ${Sr(Or(r))} but was expected to be of type ${Sr(this.type)}.`)}return null}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){const t=this.type,e=[t.kind];if("array"===t.kind){const r=t.itemType;if("string"===r.kind||"number"===r.kind||"boolean"===r.kind){e.push(r.kind);const n=t.N;("number"==typeof n||this.args.length>1)&&e.push(n);}}return e.concat(this.args.map((t=>t.serialize())))}}class qr{constructor(t){this.type=Ar,this.sections=t;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=t.length-1;++r){const s=t[r];if(i&&"object"==typeof s&&!Array.isArray(s)){i=!1;let t=null;if(s["font-scale"]&&(t=e.parseObjectValue(s["font-scale"],r,"font-scale",yr),!t))return null;let o=null;if(s["text-font"]&&(o=e.parseObjectValue(s["text-font"],r,"text-font",Ir(gr)),!o))return null;let a=null;if(s["text-color"]&&(a=e.parseObjectValue(s["text-color"],r,"text-color",vr),!a))return null;const l=n[n.length-1];l.scale=t,l.font=o,l.textColor=a;}else {const s=e.parse(t[r],r,wr);if(!s)return null;const o=s.type.kind;if("string"!==o&&"value"!==o&&"null"!==o&&"resolvedImage"!==o)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:s,scale:null,font:null,textColor:null});}}return new qr(n)}evaluate(t){return new Cr(this.sections.map((e=>{const r=e.content.evaluate(t);return Tr(Or(r),Mr)?new Vr("",r,null,null,null):new Vr(Ur(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor);}outputDefined(){return !1}serialize(){const t=["format"];for(const e of this.sections){t.push(e.content.serialize());const r={};e.scale&&(r["font-scale"]=e.scale.serialize()),e.font&&(r["text-font"]=e.font.serialize()),e.textColor&&(r["text-color"]=e.textColor.serialize()),t.push(r);}return t}}class Hr{constructor(t,e,r,n){this._imageWarnHistory={},this.type=Mr,this.namePrimary=t,this.nameSecondary=e,r&&(this.paramsPrimary=r.params,this.iconsetIdPrimary=r.iconset?r.iconset.id:void 0),n&&(this.paramsSecondary=n.params,this.iconsetIdSecondary=n.iconset?n.iconset.id:void 0);}static parse(t,e){if(t.length<2)return e.error("Expected two or more arguments.");let r=1;const n=[];function i(){if(r<t.length){const i=e.parse(t[r],r++,gr);return i?(n.push({image:i,options:{}}),!0):(e.error(n.length?"Secondary image variant is not a string.":"No image name provided."),!1)}return !0}function s(){if(r<t.length){const s=t[r];if(null===(i=s)||"object"!=typeof i||Array.isArray(i))return !0;const o=s.params,a=s.iconset,l=e.concat(r);if(!o&&!a)return r++,!0;if(o){if("object"!=typeof o||o.constructor!==Object)return l.error('Image options "params" should be an object'),!1;const t={},e=l.concat(void 0,"params");for(const r in o){if(!r)return e.error("Image parameter name should be non-empty"),!1;const n=e.concat(void 0,r).parse(o[r],void 0,vr,void 0,{typeAnnotation:"coerce"});if(!n)return !1;t[r]=n;}n[n.length-1].options.params=t;}if(a){if("object"!=typeof a||a.constructor!==Object)return l.error('Image options "iconset" should be an object'),!1;if(!a.id)return l.error('Image options "iconset" should have an "id" property'),!1;n[n.length-1].options.iconset=a;}return r++,!0}var i;return !0}for(let t=0;t<2;t++)if(!i()||!s())return;return new Hr(n[0].image,n[1]?n[1].image:void 0,n[0].options,n[1]?n[1].options:void 0)}evaluateParams(t,e){const r={};if(e){for(const n in e)if(e[n])try{r[n]=e[n].evaluate(t);}catch(t){continue}if(0!==Object.keys(r).length)return {params:r}}}evaluate(t){const e={name:this.namePrimary.evaluate(t),iconsetId:this.iconsetIdPrimary},r=this.nameSecondary?{name:this.nameSecondary.evaluate(t),iconsetId:this.iconsetIdSecondary}:void 0,n=Dr.build(e,r,this.paramsPrimary?this.evaluateParams(t,this.paramsPrimary):void 0,this.paramsSecondary?this.evaluateParams(t,this.paramsSecondary):void 0);if(n&&t.availableImages){const e=n.getPrimary().id;if(n.available=t.availableImages.some((t=>er.isEqual(t,e))),n.available){const e=n.getSecondary()?n.getSecondary().id:null;e&&(n.available=t.availableImages.some((t=>er.isEqual(t,e))));}}return n}eachChild(t){if(t(this.namePrimary),this.paramsPrimary)for(const e in this.paramsPrimary)this.paramsPrimary[e]&&t(this.paramsPrimary[e]);if(this.nameSecondary&&(t(this.nameSecondary),this.paramsSecondary))for(const e in this.paramsSecondary)this.paramsSecondary[e]&&t(this.paramsSecondary[e]);}outputDefined(){return !1}serializeOptions(t,e){const r={};if(e&&(r.iconset={id:e}),t){r.params={};for(const e in t)t[e]&&(r.params[e]=t[e].serialize());}return Object.keys(r).length>0?r:void 0}serialize(){const t=["image",this.namePrimary.serialize()];if(this.paramsPrimary||this.iconsetIdPrimary){const e=this.serializeOptions(this.paramsPrimary,this.iconsetIdPrimary);e&&t.push(e);}if(this.nameSecondary&&(t.push(this.nameSecondary.serialize()),this.paramsSecondary||this.iconsetIdSecondary)){const e=this.serializeOptions(this.paramsSecondary,this.iconsetIdSecondary);e&&t.push(e);}return t}}function Xr(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}const Zr={"to-boolean":xr,"to-color":vr,"to-number":yr,"to-string":gr};class Wr{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0],n=[];let i=mr;if("to-array"===r){if(!Array.isArray(t[1]))return null;const r=t[1].length;if(e.expectedType){if("array"!==e.expectedType.kind)return e.error(`Expected ${e.expectedType.kind} but found array.`);i=Ir(e.expectedType.itemType,r);}else {if(!(r>0&&Rr(t[1][0])))return null;i=Ir(Or(t[1][0]),r);}for(let s=0;s<r;s++){const r=t[1][s];let o;if("array"===Xr(r))o=e.parse(r,void 0,i.itemType);else {const t=Xr(r);if(t!==i.itemType.kind)return e.error(`Expected ${i.itemType.kind} but found ${t}.`);o=e.registry.literal.parse(["literal",void 0===r?null:r],e);}if(!o)return null;n.push(o);}}else {if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");i=Zr[r];for(let r=1;r<t.length;r++){const i=e.parse(t[r],r,wr);if(!i)return null;n.push(i);}}return new Wr(i,n)}evaluate(t){if("boolean"===this.type.kind)return Boolean(this.args[0].evaluate(t));if("color"===this.type.kind){let e,r;for(const n of this.args){if(e=n.evaluate(t),r=null,e instanceof sr)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rbga value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:Lr(e[0],e[1],e[2],e[3]),!r))return new sr(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new jr(r||`Could not parse color from value '${"string"==typeof e?e:String(JSON.stringify(e))}'`)}if("number"===this.type.kind){let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const n=Number(e);if(!isNaN(n))return n}throw new jr(`Could not convert ${JSON.stringify(e)} to number.`)}return "formatted"===this.type.kind?Cr.fromString(Ur(this.args[0].evaluate(t))):"resolvedImage"===this.type.kind?Dr.build(Ur(this.args[0].evaluate(t))):"array"===this.type.kind?this.args.map((e=>e.evaluate(t))):Ur(this.args[0].evaluate(t))}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){if("formatted"===this.type.kind)return new qr([{content:this.args[0],scale:null,font:null,textColor:null}]).serialize();if("resolvedImage"===this.type.kind)return new Hr(this.args[0]).serialize();const t="array"===this.type.kind?[]:[`to-${this.type.kind}`];return this.eachChild((e=>{t.push(e.serialize());})),t}}const Yr=["Unknown","Point","LineString","Polygon"];class Kr{constructor(t,e){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null,this.featureTileCoord=null,this.featureDistanceData=null,this.scope=t,this.options=e;}id(){return this.feature&&void 0!==this.feature.id?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?Yr[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}measureLight(t){return this.globals.brightness||0}distanceFromCenter(){if(this.featureTileCoord&&this.featureDistanceData){const t=this.featureDistanceData.center,e=this.featureDistanceData.scale,{x:r,y:n}=this.featureTileCoord;return this.featureDistanceData.bearing[0]*(r*e-t[0])+this.featureDistanceData.bearing[1]*(n*e-t[1])}return 0}parseColor(t){let e=this._parseColorCache[t];return e||(e=this._parseColorCache[t]=sr.parse(t)),e}getConfig(t){return this.options?this.options.get(t):null}}class Jr{constructor(t,e,r,n,i){this.name=t,this.type=e,this._evaluate=r,this.args=n,this._overloadIndex=i;}evaluate(t){if(!this._evaluate){const t=Jr.definitions[this.name];this._evaluate=Array.isArray(t)?t[2]:t.overloads[this._overloadIndex][1];}return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t);}outputDefined(){return !1}serialize(){return [this.name].concat(this.args.map((t=>t.serialize())))}static parse(t,e){const r=t[0],n=Jr.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,s=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,o=[];let a=null,l=-1;for(const[n,u]of s){if(Array.isArray(n)&&n.length!==t.length-1)continue;o.push(n),l++,a=new bi(e.registry,e.path,null,e.scope,void 0,e._scope,e.options);const s=[];let c=!1;for(let e=1;e<t.length;e++){const r=t[e],i=Array.isArray(n)?n[e-1]:n.type,o=a.parse(r,1+s.length,i);if(!o){c=!0;break}s.push(o);}if(!c)if(Array.isArray(n)&&n.length!==s.length)a.error(`Expected ${n.length} arguments, but found ${s.length} instead.`);else {for(let t=0;t<s.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=s[t];a.concat(t+1).checkSubtype(e,r.type);}if(0===a.errors.length)return new Jr(r,i,u,s,l)}}if(1===o.length)e.errors.push(...a.errors);else {const r=(o.length?o:s.map((([t])=>t))).map(Qr).join(" | "),n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],1+n.length);if(!i)return null;n.push(Sr(i.type));}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`);}return null}static register(t,e){Jr.definitions=e;for(const r in e)t[r]=Jr;}}function Qr(t){return Array.isArray(t)?`(${t.map(Sr).join(", ")})`:`(${Sr(t.type)}...)`}class tn{constructor(t,e,r){this.type=_r,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e;}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=void 0===r["case-sensitive"]?e.parse(!1,1,xr):e.parseObjectValue(r["case-sensitive"],1,"case-sensitive",xr);if(!n)return null;const i=void 0===r["diacritic-sensitive"]?e.parse(!1,1,xr):e.parseObjectValue(r["diacritic-sensitive"],1,"diacritic-sensitive",xr);if(!i)return null;let s=null;return r.locale&&(s=e.parseObjectValue(r.locale,1,"locale",gr),!s)?null:new tn(n,i,s)}evaluate(t){return new Br(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale);}outputDefined(){return !1}serialize(){const t={};return t["case-sensitive"]=this.caseSensitive.serialize(),t["diacritic-sensitive"]=this.diacriticSensitive.serialize(),this.locale&&(t.locale=this.locale.serialize()),["collator",t]}}function en(t,e,r=0,n=t.length-1,i=nn){for(;n>r;){if(n-r>600){const s=n-r+1,o=e-r+1,a=Math.log(s),l=.5*Math.exp(2*a/3),u=.5*Math.sqrt(a*l*(s-l)/s)*(o-s/2<0?-1:1);en(t,e,Math.max(r,Math.floor(e-o*l/s+u)),Math.min(n,Math.floor(e+(s-o)*l/s+u)),i);}const s=t[e];let o=r,a=n;for(rn(t,r,e),i(t[n],s)>0&&rn(t,r,n);o<a;){for(rn(t,o,a),o++,a--;i(t[o],s)<0;)o++;for(;i(t[a],s)>0;)a--;}0===i(t[r],s)?rn(t,r,a):(a++,rn(t,a,n)),a<=e&&(r=a+1),e<=a&&(n=a-1);}}function rn(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function nn(t,e){return t<e?-1:t>e?1:0}function sn(t){let e=0;for(let r,n,i=0,s=t.length,o=s-1;i<s;o=i++)r=t[i],n=t[o],e+=(n.x-r.x)*(r.y+n.y);return e}function on(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1]);}function an(t,e){return !(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function ln(t,e,r){const n=t[0]-e[0],i=t[1]-e[1],s=t[0]-r[0],o=t[1]-r[1];return n*o-s*i==0&&n*s<=0&&i*o<=0}function un(t,e,r=!1){let n=!1;for(let a=0,l=e.length;a<l;a++){const l=e[a];for(let e=0,a=l.length,u=a-1;e<a;u=e++){const a=l[u],c=l[e];if(ln(t,a,c))return r;(s=a)[1]>(i=t)[1]!=(o=c)[1]>i[1]&&i[0]<(o[0]-s[0])*(i[1]-s[1])/(o[1]-s[1])+s[0]&&(n=!n);}}var i,s,o;return n}function cn(t,e,r,n){const i=n[0]-r[0],s=n[1]-r[1],o=(t[0]-r[0])*s-i*(t[1]-r[1]),a=(e[0]-r[0])*s-i*(e[1]-r[1]);return o>0&&a<0||o<0&&a>0}function hn(t,e,r,n){return 0!=(i=[n[0]-r[0],n[1]-r[1]])[0]*(s=[e[0]-t[0],e[1]-t[1]])[1]-i[1]*s[0]&&!(!cn(t,e,r,n)||!cn(r,n,t,e));var i,s;}function pn(t){const e=new bt(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY),r=new bt(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY);for(const n of t[0])e.x>n.x&&(e.x=n.x),e.y>n.y&&(e.y=n.y),r.x<n.x&&(r.x=n.x),r.y<n.y&&(r.y=n.y);return {min:e,max:r}}const fn=8192;function dn(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,i=Math.pow(2,e.z);return [Math.round(r*i*fn),Math.round(n*i*fn)]}function mn(t,e){for(let r=0;r<e.length;r++)if(un(t,e[r]))return !0;return !1}function yn(t,e,r){for(const n of r)for(let r=0,i=n.length,s=i-1;r<i;s=r++)if(hn(t,e,n[s],n[r]))return !0;return !1}function gn(t,e){for(let r=0;r<t.length;++r)if(!un(t[r],e))return !1;for(let r=0;r<t.length-1;++r)if(yn(t[r],t[r+1],e))return !1;return !0}function xn(t,e){for(let r=0;r<e.length;r++)if(gn(t,e[r]))return !0;return !1}function vn(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=[];for(let n=0;n<t[i].length;n++){const o=dn(t[i][n],r);on(e,o),s.push(o);}n.push(s);}return n}function bn(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=vn(t[i],e,r);n.push(s);}return n}function wn(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let i=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===i&&(i=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0),t[0]+=i;}on(e,t);}function _n(t,e,r,n){const i=Math.pow(2,n.z)*fn,s=[n.x*fn,n.y*fn],o=[];if(!t)return o;for(const n of t)for(const t of n){const n=[t.x+s[0],t.y+s[1]];wn(n,e,r,i),o.push(n);}return o}function An(t,e,r,n){const i=Math.pow(2,n.z)*fn,s=[n.x*fn,n.y*fn],o=[];if(!t)return o;for(const r of t){const t=[];for(const n of r){const r=[n.x+s[0],n.y+s[1]];on(e,r),t.push(r);}o.push(t);}if(e[2]-e[0]<=i/2){(a=e)[0]=a[1]=1/0,a[2]=a[3]=-1/0;for(const t of o)for(const n of t)wn(n,e,r,i);}var a;return o}class Mn{constructor(t,e){this.type=xr,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Rr(t[1])){const e=t[1];if("FeatureCollection"===e.type)for(let t=0;t<e.features.length;++t){const r=e.features[t].geometry.type;if("Polygon"===r||"MultiPolygon"===r)return new Mn(e,e.features[t].geometry)}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new Mn(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new Mn(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if(!i)return !1;if("Polygon"===e.type){const s=vn(e.coordinates,n,i),o=_n(t.geometry(),r,n,i);if(!an(r,n))return !1;for(const t of o)if(!un(t,s))return !1}if("MultiPolygon"===e.type){const s=bn(e.coordinates,n,i),o=_n(t.geometry(),r,n,i);if(!an(r,n))return !1;for(const t of o)if(!mn(t,s))return !1}return !0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if(!i)return !1;if("Polygon"===e.type){const s=vn(e.coordinates,n,i),o=An(t.geometry(),r,n,i);if(!an(r,n))return !1;for(const t of o)if(!gn(t,s))return !1}if("MultiPolygon"===e.type){const s=bn(e.coordinates,n,i),o=An(t.geometry(),r,n,i);if(!an(r,n))return !1;for(const t of o)if(!xn(t,s))return !1}return !0}(t,this.geometries)}return !1}eachChild(){}outputDefined(){return !0}serialize(){return ["within",this.geojson]}}const In={kilometers:1,miles:1e3/1609.344,nauticalmiles:1e3/1852,meters:1e3,metres:1e3,yards:1e3/.9144,feet:1e3/.3048,inches:1e3/.0254},Sn=1/298.257223563,zn=Sn*(2-Sn),kn=Math.PI/180;class Pn{static fromTile(t,e,r){const n=Math.PI*(1-2*(t+.5)/Math.pow(2,e)),i=Math.atan(.5*(Math.exp(n)-Math.exp(-n)))/kn;return new Pn(i,r)}static get units(){return In}constructor(t,e){if(void 0===t)throw new Error("No latitude given.");if(e&&!In[e])throw new Error(`Unknown unit ${e}. Use one of: ${Object.keys(In).join(", ")}`);const r=6378.137*kn*(e?In[e]:1),n=Math.cos(t*kn),i=1/(1-zn*(1-n*n)),s=Math.sqrt(i);this.kx=r*s*n,this.ky=r*s*i*(1-zn);}distance(t,e){const r=Bn(t[0]-e[0])*this.kx,n=(t[1]-e[1])*this.ky;return Math.sqrt(r*r+n*n)}bearing(t,e){const r=Bn(e[0]-t[0])*this.kx;return Math.atan2(r,(e[1]-t[1])*this.ky)/kn}destination(t,e,r){const n=r*kn;return this.offset(t,Math.sin(n)*e,Math.cos(n)*e)}offset(t,e,r){return [t[0]+e/this.kx,t[1]+r/this.ky]}lineDistance(t){let e=0;for(let r=0;r<t.length-1;r++)e+=this.distance(t[r],t[r+1]);return e}area(t){let e=0;for(let r=0;r<t.length;r++){const n=t[r];for(let t=0,i=n.length,s=i-1;t<i;s=t++)e+=Bn(n[t][0]-n[s][0])*(n[t][1]+n[s][1])*(r?-1:1);}return Math.abs(e)/2*this.kx*this.ky}along(t,e){let r=0;if(e<=0)return t[0];for(let n=0;n<t.length-1;n++){const i=t[n],s=t[n+1],o=this.distance(i,s);if(r+=o,r>e)return Tn(i,s,(e-(r-o))/o)}return t[t.length-1]}pointToSegmentDistance(t,e,r){let[n,i]=e,s=Bn(r[0]-n)*this.kx,o=(r[1]-i)*this.ky;if(0!==s||0!==o){const e=(Bn(t[0]-n)*this.kx*s+(t[1]-i)*this.ky*o)/(s*s+o*o);e>1?(n=r[0],i=r[1]):e>0&&(n+=s/this.kx*e,i+=o/this.ky*e);}return s=Bn(t[0]-n)*this.kx,o=(t[1]-i)*this.ky,Math.sqrt(s*s+o*o)}pointOnLine(t,e){let r=1/0,n=t[0][0],i=t[0][1],s=0,o=0;for(let a=0;a<t.length-1;a++){let l=t[a][0],u=t[a][1],c=Bn(t[a+1][0]-l)*this.kx,h=(t[a+1][1]-u)*this.ky,p=0;0===c&&0===h||(p=(Bn(e[0]-l)*this.kx*c+(e[1]-u)*this.ky*h)/(c*c+h*h),p>1?(l=t[a+1][0],u=t[a+1][1]):p>0&&(l+=c/this.kx*p,u+=h/this.ky*p)),c=Bn(e[0]-l)*this.kx,h=(e[1]-u)*this.ky;const f=c*c+h*h;f<r&&(r=f,n=l,i=u,s=a,o=p);}return {point:[n,i],index:s,t:Math.max(0,Math.min(1,o))}}lineSlice(t,e,r){let n=this.pointOnLine(r,t),i=this.pointOnLine(r,e);if(n.index>i.index||n.index===i.index&&n.t>i.t){const t=n;n=i,i=t;}const s=[n.point],o=n.index+1,a=i.index;!En(r[o],s[0])&&o<=a&&s.push(r[o]);for(let t=o+1;t<=a;t++)s.push(r[t]);return En(r[a],i.point)||s.push(i.point),s}lineSliceAlong(t,e,r){let n=0;const i=[];for(let s=0;s<r.length-1;s++){const o=r[s],a=r[s+1],l=this.distance(o,a);if(n+=l,n>t&&0===i.length&&i.push(Tn(o,a,(t-(n-l))/l)),n>=e)return i.push(Tn(o,a,(e-(n-l))/l)),i;n>t&&i.push(a);}return i}bufferPoint(t,e){const r=e/this.ky,n=e/this.kx;return [t[0]-n,t[1]-r,t[0]+n,t[1]+r]}bufferBBox(t,e){const r=e/this.ky,n=e/this.kx;return [t[0]-n,t[1]-r,t[2]+n,t[3]+r]}insideBBox(t,e){return Bn(t[0]-e[0])>=0&&Bn(t[0]-e[2])<=0&&t[1]>=e[1]&&t[1]<=e[3]}}function En(t,e){return t[0]===e[0]&&t[1]===e[1]}function Tn(t,e,r){const n=Bn(e[0]-t[0]);return [t[0]+n*r,t[1]+(e[1]-t[1])*r]}function Bn(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t}class Vn{constructor(t=[],e=((t,e)=>t<e?-1:t>e?1:0)){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this._up(this.length++);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return --this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const s=n+1;if(s<this.length&&r(e[s],e[n])<0&&(n=s),r(e[n],i)>=0)break;e[t]=e[n],t=n;}e[t]=i;}}var Cn=8192;function Fn(t,e){return e.dist-t.dist}const Dn=100,Ln=50;function Rn(t){const e=[1/0,1/0,-1/0,-1/0];if(e.length!==t.length)return !1;for(let r=0;r<e.length;r++)if(e[r]!==t[r])return !1;return !0}function On(t){return t[1]-t[0]+1}function Un(t,e){const r=t[1]>=t[0]&&t[1]<e;return r||console.warn("Distance Expression: Index is out of range"),r}function Nn(t,e){if(t[0]>t[1])return [null,null];const r=On(t);if(e){if(2===r)return [t,null];const e=Math.floor(r/2);return [[t[0],t[0]+e],[t[0]+e,t[1]]]}{if(1===r)return [t,null];const e=Math.floor(r/2)-1;return [[t[0],t[0]+e],[t[0]+e+1,t[1]]]}}function jn(t,e){const r=[1/0,1/0,-1/0,-1/0];if(!Un(e,t.length))return r;for(let n=e[0];n<=e[1];++n)on(r,t[n]);return r}function $n(t){const e=[1/0,1/0,-1/0,-1/0];for(let r=0;r<t.length;++r)for(let n=0;n<t[r].length;++n)on(e,t[r][n]);return e}function Gn(t,e,r){if(Rn(t)||Rn(e))return NaN;let n=0,i=0;return t[2]<e[0]&&(n=e[0]-t[2]),t[0]>e[2]&&(n=t[0]-e[2]),t[1]>e[3]&&(i=t[1]-e[3]),t[3]<e[1]&&(i=e[1]-t[3]),r.distance([0,0],[n,i])}function qn(t){return 360*t-180}function Hn(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function Xn(t,e){const r=Math.pow(2,e.z),n=(t.y/Cn+e.y)/r;return [qn((t.x/Cn+e.x)/r),Hn(n)]}function Zn(t,e){const r=[];for(let n=0;n<t.length;++n)r.push(Xn(t[n],e));return r}function Wn(t,e,r){const n=r.pointOnLine(e,t).point;return r.distance(t,n)}function Yn(t,e,r,n,i){const s=r.slice(n[0],n[1]+1);let o=1/0;for(let r=e[0];r<=e[1];++r)if(0===(o=Math.min(o,Wn(t[r],s,i))))return 0;return o}function Kn(t,e,r,n,i){const s=Math.min(i.pointToSegmentDistance(t,r,n),i.pointToSegmentDistance(e,r,n)),o=Math.min(i.pointToSegmentDistance(r,t,e),i.pointToSegmentDistance(n,t,e));return Math.min(s,o)}function Jn(t,e,r,n,i){if(!Un(e,t.length)||!Un(n,r.length))return NaN;let s=1/0;for(let o=e[0];o<e[1];++o)for(let e=n[0];e<n[1];++e){if(hn(t[o],t[o+1],r[e],r[e+1]))return 0;s=Math.min(s,Kn(t[o],t[o+1],r[e],r[e+1],i));}return s}function Qn(t,e,r,n,i){if(!Un(e,t.length)||!Un(n,r.length))return NaN;let s=1/0;for(let o=e[0];o<=e[1];++o)for(let e=n[0];e<=n[1];++e)if(0===(s=Math.min(s,i.distance(t[o],r[e]))))return s;return s}function ti(t,e,r){if(un(t,e,!0))return 0;let n=1/0;for(const i of e){const e=i.length;if(e<2)return console.warn("Distance Expression: Invalid polygon!"),NaN;if(i[0]!==i[e-1]&&0===(n=Math.min(n,r.pointToSegmentDistance(t,i[e-1],i[0]))))return n;if(0===(n=Math.min(n,Wn(t,i,r))))return n}return n}function ei(t,e,r,n){if(!Un(e,t.length))return NaN;for(let n=e[0];n<=e[1];++n)if(un(t[n],r,!0))return 0;let i=1/0;for(let s=e[0];s<e[1];++s)for(const e of r)for(let r=0,o=e.length,a=o-1;r<o;a=r++){if(hn(t[s],t[s+1],e[a],e[r]))return 0;i=Math.min(i,Kn(t[s],t[s+1],e[a],e[r],n));}return i}function ri(t,e){for(const r of t)for(let t=0;t<=r.length-1;++t)if(un(r[t],e,!0))return !0;return !1}function ni(t,e,r,n=1/0){const i=$n(t),s=$n(e);if(n!==1/0&&Gn(i,s,r)>=n)return n;if(an(i,s)){if(ri(t,e))return 0}else if(ri(e,t))return 0;let o=n;for(const n of t)for(let t=0,i=n.length,s=i-1;t<i;s=t++)for(const i of e)for(let e=0,a=i.length,l=a-1;e<a;l=e++){if(hn(n[s],n[t],i[l],i[e]))return 0;o=Math.min(o,Kn(n[s],n[t],i[l],i[e],r));}return o}function ii(t,e,r,n,i,s,o){if(null===s||null===o)return;const a=Gn(jn(n,s),jn(i,o),r);a<e&&t.push({dist:a,range1:s,range2:o});}function si(t,e,r,n,i=1/0){let s=Math.min(n.distance(t[0],r[0][0]),i);if(0===s)return s;const o=new Vn([{dist:0,range1:[0,t.length-1],range2:[0,0]}],Fn),a=e?Ln:Dn,l=$n(r);for(;o.length;){const i=o.pop();if(i.dist>=s)continue;const u=i.range1;if(On(u)<=a){if(!Un(u,t.length))return NaN;if(e){const e=ei(t,u,r,n);if(0===(s=Math.min(s,e)))return s}else for(let e=u[0];e<=u[1];++e){const i=ti(t[e],r,n);if(0===(s=Math.min(s,i)))return s}}else {const r=Nn(u,e);if(null!==r[0]){const e=Gn(jn(t,r[0]),l,n);e<s&&o.push({dist:e,range1:r[0],range2:[0,0]});}if(null!==r[1]){const e=Gn(jn(t,r[1]),l,n);e<s&&o.push({dist:e,range1:r[1],range2:[0,0]});}}}return s}function oi(t,e,r,n,i,s=1/0){let o=Math.min(s,i.distance(t[0],r[0]));if(0===o)return o;const a=new Vn([{dist:0,range1:[0,t.length-1],range2:[0,r.length-1]}],Fn),l=e?Ln:Dn,u=n?Ln:Dn;for(;a.length;){const s=a.pop();if(s.dist>=o)continue;const c=s.range1,h=s.range2;if(On(c)<=l&&On(h)<=u){if(!Un(c,t.length)||!Un(h,r.length))return NaN;if(e&&n?o=Math.min(o,Jn(t,c,r,h,i)):e||n?e&&!n?o=Math.min(o,Yn(r,h,t,c,i)):!e&&n&&(o=Math.min(o,Yn(t,c,r,h,i))):o=Math.min(o,Qn(t,c,r,h,i)),0===o)return o}else {const s=Nn(c,e),l=Nn(h,n);ii(a,o,i,t,r,s[0],l[0]),ii(a,o,i,t,r,s[0],l[1]),ii(a,o,i,t,r,s[1],l[0]),ii(a,o,i,t,r,s[1],l[1]);}}return o}function ai(t,e,r,n,i=1/0){let s=i;const o=jn(t,[0,t.length-1]);for(const i of r)if(!(s!==1/0&&Gn(o,jn(i,[0,i.length-1]),n)>=s)&&(s=Math.min(s,oi(t,e,i,!0,n,s)),0===s))return s;return s}function li(t,e,r,n,i=1/0){let s=i;const o=jn(t,[0,t.length-1]);for(const i of r){if(s!==1/0&&Gn(o,$n(i),n)>=s)continue;const r=si(t,e,i,n,s);if(isNaN(r))return r;if(0===(s=Math.min(s,r)))return s}return s}function ui(t){return "Point"===t||"MultiPoint"===t||"LineString"===t||"MultiLineString"===t||"Polygon"===t||"MultiPolygon"===t}class ci{constructor(t,e){this.type=yr,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires either one argument, but found ' ${t.length-1} instead.`);if(Rr(t[1])){const e=t[1];if("FeatureCollection"===e.type){for(let t=0;t<e.features.length;++t)if(ui(e.features[t].geometry.type))return new ci(e,e.features[t].geometry)}else if("Feature"===e.type){if(ui(e.geometry.type))return new ci(e,e.geometry)}else if(ui(e.type))return new ci(e,e)}return e.error("'distance' expression needs to be an array with format ['Distance', GeoJSONObj].")}evaluate(t){const e=t.geometry(),r=t.canonicalID();if(null!=e&&null!=r){if("Point"===t.geometryType())return function(t,e,r){const n=[];for(const r of t)for(const t of r)n.push(Xn(t,e));const i=new Pn(n[0][1],"meters");return "Point"===r.type||"MultiPoint"===r.type||"LineString"===r.type?oi(n,!1,"Point"===r.type?[r.coordinates]:r.coordinates,"LineString"===r.type,i):"MultiLineString"===r.type?ai(n,!1,r.coordinates,i):"Polygon"===r.type||"MultiPolygon"===r.type?li(n,!1,"Polygon"===r.type?[r.coordinates]:r.coordinates,i):null}(e,r,this.geometries);if("LineString"===t.geometryType())return function(t,e,r){const n=[];for(const r of t){const t=[];for(const n of r)t.push(Xn(n,e));n.push(t);}const i=new Pn(n[0][0][1],"meters");if("Point"===r.type||"MultiPoint"===r.type||"LineString"===r.type)return ai("Point"===r.type?[r.coordinates]:r.coordinates,"LineString"===r.type,n,i);if("MultiLineString"===r.type){let t=1/0;for(let e=0;e<r.coordinates.length;e++){const s=ai(r.coordinates[e],!0,n,i,t);if(isNaN(s))return s;if(0===(t=Math.min(t,s)))return t}return t}if("Polygon"===r.type||"MultiPolygon"===r.type){let t=1/0;for(let e=0;e<n.length;e++){const s=li(n[e],!0,"Polygon"===r.type?[r.coordinates]:r.coordinates,i,t);if(isNaN(s))return s;if(0===(t=Math.min(t,s)))return t}return t}return null}(e,r,this.geometries);if("Polygon"===t.geometryType())return function(t,e,r){const n=[];for(const r of function(t,e){const r=t.length;if(r<=1)return [t];const n=[];let i,s;for(let e=0;e<r;e++){const r=sn(t[e]);0!==r&&(t[e].area=Math.abs(r),void 0===s&&(s=r<0),s===r<0?(i&&n.push(i),i=[t[e]]):i.push(t[e]));}return i&&n.push(i),n}(t)){const t=[];for(let n=0;n<r.length;++n)t.push(Zn(r[n],e));n.push(t);}const i=new Pn(n[0][0][0][1],"meters");if("Point"===r.type||"MultiPoint"===r.type||"LineString"===r.type)return li("Point"===r.type?[r.coordinates]:r.coordinates,"LineString"===r.type,n,i);if("MultiLineString"===r.type){let t=1/0;for(let e=0;e<r.coordinates.length;e++){const s=li(r.coordinates[e],!0,n,i,t);if(isNaN(s))return s;if(0===(t=Math.min(t,s)))return t}return t}return "Polygon"===r.type||"MultiPolygon"===r.type?function(t,e,r){let n=1/0;for(const i of t)for(const t of e){const e=ni(i,t,r,n);if(isNaN(e))return e;if(0===(n=Math.min(n,e)))return n}return n}("Polygon"===r.type?[r.coordinates]:r.coordinates,n,i):null}(e,r,this.geometries);console.warn("Distance Expression: currently only evaluates valid Point/LineString/Polygon geometries.");}else console.warn("Distance Expression: requirs valid feature and canonical information.");return null}eachChild(){}outputDefined(){return !0}serialize(){return ["distance",this.geojson]}}function hi(t){if(t instanceof Jr){if("get"===t.name&&1===t.args.length)return !1;if("feature-state"===t.name)return !1;if("has"===t.name&&1===t.args.length)return !1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return !1;if(/^filter-/.test(t.name))return !1}if(t instanceof Mn)return !1;if(t instanceof ci)return !1;if(t instanceof xi)return t.featureConstant;let e=!0;return t.eachChild((t=>{e&&!hi(t)&&(e=!1);})),e}function pi(t){if(t instanceof Jr&&"feature-state"===t.name)return !1;let e=!0;return t.eachChild((t=>{e&&!pi(t)&&(e=!1);})),e}function fi(t){if(t instanceof xi)return new Set([t.key]);let e=new Set;return t.eachChild((t=>{e=new Set([...e,...fi(t)]);})),e}function di(t,e){if(t instanceof Jr&&e.indexOf(t.name)>=0)return !1;let r=!0;return t.eachChild((t=>{r&&!di(t,e)&&(r=!1);})),r}function mi(t,e,r){return [t,e,r].filter(Boolean).join("")}function yi(t,e){switch(t){case "string":return Ur(e);case "number":return +e;case "boolean":return !!e;case "color":return sr.parse(e);case "formatted":return Cr.fromString(Ur(e));case "resolvedImage":return Dr.build(Ur(e))}return e}function gi(t,e,r,n){return void 0!==n&&(t=n*Math.round(t/n)),void 0!==e&&t<e&&(t=e),void 0!==r&&t>r&&(t=r),t}class xi{constructor(t,e,r,n=!1){this.type=t,this.key=e,this.scope=r,this.featureConstant=n;}static parse(t,e){let r=e.expectedType;if(null==r&&(r=wr),t.length<2||t.length>3)return e.error("Invalid number of arguments for 'config' expression.");const n=e.parse(t[1],1);if(!(n instanceof Nr))return e.error("Key name of 'config' expression must be a string literal.");let i,s=!0;const o=Ur(n.value);if(t.length>=3){const r=e.parse(t[2],2);if(!(r instanceof Nr))return e.error("Scope of 'config' expression must be a string literal.");i=Ur(r.value);}if(e.options){const t=mi(o,i,e._scope),r=e.options.get(t);r&&(s=hi(r.value||r.default));}return new xi(r,o,i,s)}evaluate(t){const e=mi(this.key,this.scope,t.scope),r=t.getConfig(e);if(!r)return null;const{type:n,value:i,values:s,minValue:o,maxValue:a,stepValue:l}=r,u=r.default.evaluate(t);let c=u;if(i){const e=t.scope;t.scope=(e||"").split("").slice(1).join(""),c=i.evaluate(t),t.scope=e;}return n&&(c=yi(n,c)),void 0===c||void 0===o&&void 0===a&&void 0===l||("number"==typeof c?c=gi(c,o,a,l):Array.isArray(c)&&(c=c.map((t=>"number"==typeof t?gi(t,o,a,l):t)))),void 0!==i&&void 0!==c&&s&&!s.includes(c)&&(c=u,n&&(c=yi(n,c))),(n&&n!==this.type||void 0!==c&&!Tr(Or(c),this.type))&&(c=yi(this.type.kind,c)),c}eachChild(){}outputDefined(){return !1}serialize(){const t=["config",this.key];return this.scope&&t.concat(this.scope),t}}class vi{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e;}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new vi(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return !1}serialize(){return ["var",this.name]}}class bi{constructor(t,e=[],r,n=new dr,i=[],s,o){this.registry=t,this.path=e,this.key=e.map((t=>"string"==typeof t?`['${t}']`:`[${t}]`)).join(""),this.scope=n,this.errors=i,this.expectedType=r,this._scope=s,this.options=o;}parse(t,e,r,n,i={}){return e||r?this.concat(e,null,r,n)._parse(t,i):this._parse(t,i)}parseObjectValue(t,e,r,n,i,s={}){return this.concat(e,r,n,i)._parse(t,s)}_parse(t,e){function r(t,e,r){return "assert"===r?new Gr(e,[t]):"coerce"===r?new Wr(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n="string"==typeof t[0]?this.registry[t[0]]:void 0;if(n){let i=n.parse(t,this);if(!i)return null;if(this.expectedType){const t=this.expectedType,n=i.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==n.kind)if("color"!==t.kind&&"formatted"!==t.kind&&"resolvedImage"!==t.kind||"value"!==n.kind&&"string"!==n.kind){if(this.checkSubtype(t,n))return null}else i=r(i,t,e.typeAnnotation||"coerce");else i=r(i,t,e.typeAnnotation||"assert");}if(!(i instanceof Nr)&&"resolvedImage"!==i.type.kind&&wi(i)){const t=new Kr(this._scope,this.options);try{i=new Nr(i.type,i.evaluate(t));}catch(t){return this.error(t.message),null}}return i}return Wr.parse(["to-array",t],this)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r,n){let i="number"==typeof t?this.path.concat(t):this.path;i="string"==typeof e?i.concat(e):i;const s=n?this.scope.concat(n):this.scope;return new bi(this.registry,i,r||null,s,this.errors,this._scope,this.options)}error(t,...e){const r=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new fr(r,t));}checkSubtype(t,e){const r=kr(t,e);return r&&this.error(r),r}}function wi(t){if(t instanceof vi)return wi(t.boundExpression);if(t instanceof Jr&&"error"===t.name)return !1;if(t instanceof tn)return !1;if(t instanceof Mn)return !1;if(t instanceof ci)return !1;if(t instanceof xi)return !1;const e=t instanceof Wr||t instanceof Gr;let r=!0;return t.eachChild((t=>{r=e?r&&wi(t):r&&t instanceof Nr;})),!!r&&hi(t)&&di(t,["zoom","heatmap-density","worldview","line-progress","raster-value","sky-radial-progress","accumulated","is-supported-script","pitch","distance-from-center","measure-light","raster-particle-speed"])}function _i(t,e){const r=t.length-1;let n,i,s=0,o=r,a=0;for(;s<=o;)if(a=Math.floor((s+o)/2),n=t[a],i=t[a+1],n<=e){if(a===r||e<i)return a;s=a+1;}else {if(!(n>e))throw new jr("Input is not a number.");o=a-1;}return 0}class Ai{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e);}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,yr);if(!r)return null;const n=[];let i=null;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);for(let r=1;r<t.length;r+=2){const s=1===r?-1/0:t[r],o=t[r+1],a=r,l=r+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',a);if(n.length&&n[n.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',a);const u=e.parse(o,l,i);if(!u)return null;i=i||u.type,n.push([s,u]);}return new Ai(i,r,n)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;return n>=e[i-1]?r[i-1].evaluate(t):r[_i(e,n)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}serialize(){const t=["step",this.input.serialize()];for(let e=0;e<this.labels.length;e++)e>0&&t.push(this.labels[e]),t.push(this.outputs[e].serialize());return t}}const Mi=.95047,Ii=1.08883,Si=4/29,zi=6/29,ki=3*zi*zi,Pi=zi*zi*zi,Ei=Math.PI/180,Ti=180/Math.PI;function Bi(t){return t>Pi?Math.pow(t,1/3):t/ki+Si}function Vi(t){return t>zi?t*t*t:ki*(t-Si)}function Ci(t){return 255*(t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055)}function Fi(t){return (t/=255)<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function Di(t){const e=Fi(t.r),r=Fi(t.g),n=Fi(t.b),i=Bi((.4124564*e+.3575761*r+.1804375*n)/Mi),s=Bi((.2126729*e+.7151522*r+.072175*n)/1);return {l:116*s-16,a:500*(i-s),b:200*(s-Bi((.0193339*e+.119192*r+.9503041*n)/Ii)),alpha:t.a}}function Li(t){let e=(t.l+16)/116,r=isNaN(t.a)?e:e+t.a/500,n=isNaN(t.b)?e:e-t.b/200;return e=1*Vi(e),r=Mi*Vi(r),n=Ii*Vi(n),new sr(Ci(3.2404542*r-1.5371385*e-.4985314*n),Ci(-.969266*r+1.8760108*e+.041556*n),Ci(.0556434*r-.2040259*e+1.0572252*n),t.alpha)}function Ri(t,e,r){const n=e-t;return t+r*(n>180||n<-180?n-360*Math.round(n/360):n)}const Oi={forward:Di,reverse:Li,interpolate:function(t,e,r){return {l:ur(t.l,e.l,r),a:ur(t.a,e.a,r),b:ur(t.b,e.b,r),alpha:ur(t.alpha,e.alpha,r)}}},Ui={forward:function(t){const{l:e,a:r,b:n}=Di(t),i=Math.atan2(n,r)*Ti;return {h:i<0?i+360:i,c:Math.sqrt(r*r+n*n),l:e,alpha:t.a}},reverse:function(t){const e=t.h*Ei,r=t.c;return Li({l:t.l,a:Math.cos(e)*r,b:Math.sin(e)*r,alpha:t.alpha})},interpolate:function(t,e,r){return {h:Ri(t.h,e.h,r),c:ur(t.c,e.c,r),l:ur(t.l,e.l,r),alpha:ur(t.alpha,e.alpha,r)}}};var Ni=Object.freeze({__proto__:null,hcl:Ui,lab:Oi});class ji{constructor(t,e,r,n,i){this.type=t,this.operator=e,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e);}static interpolationFactor(t,e,r,n){let i=0;if("exponential"===t.name)i=$i(e,t.base,r,n);else if("linear"===t.name)i=$i(e,1,r,n);else if("cubic-bezier"===t.name){const s=t.controlPoints;i=new xt(s[0],s[1],s[2],s[3]).solve($i(e,1,r,n));}return i}static parse(t,e){let[r,n,i,...s]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t};}else {if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t};}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length-1>3&&(t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(i=e.parse(i,2,yr),!i)return null;const o=[];let a=null;"interpolate-hcl"===r||"interpolate-lab"===r?a=vr:e.expectedType&&"value"!==e.expectedType.kind&&(a=e.expectedType);for(let t=0;t<s.length;t+=2){const r=s[t],n=s[t+1],i=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(o.length&&o[o.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=e.parse(n,l,a);if(!u)return null;a=a||u.type,o.push([r,u]);}return "number"===a.kind||"color"===a.kind||"array"===a.kind&&"number"===a.itemType.kind&&"number"==typeof a.N?new ji(a,r,n,i,o):e.error(`Type ${Sr(a)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;if(n>=e[i-1])return r[i-1].evaluate(t);const s=_i(e,n),o=ji.interpolationFactor(this.interpolation,n,e[s],e[s+1]),a=r[s].evaluate(t),l=r[s+1].evaluate(t);return "interpolate"===this.operator?hr[this.type.kind.toLowerCase()](a,l,o):"interpolate-hcl"===this.operator?Ui.reverse(Ui.interpolate(Ui.forward(a),Ui.forward(l),o)):Oi.reverse(Oi.interpolate(Oi.forward(a),Oi.forward(l),o))}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}serialize(){let t;t="linear"===this.interpolation.name?["linear"]:"exponential"===this.interpolation.name?1===this.interpolation.base?["linear"]:["exponential",this.interpolation.base]:["cubic-bezier",...this.interpolation.controlPoints];const e=[this.operator,t,this.input.serialize()];for(let t=0;t<this.labels.length;t++)e.push(this.labels[t],this.outputs[t].serialize());return e}}function $i(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}class Gi{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expectected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of t.slice(1)){const t=e.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,i.push(t);}const s=n&&i.some((t=>kr(n,t.type)));return new Gi(s?wr:r,i)}evaluate(t){let e,r=null,n=0;for(const i of this.args){if(n++,r=i.evaluate(t),r&&r instanceof Dr&&!r.available&&(e||(e=r),r=null,n===this.args.length))return e;if(null!==r)break}return r}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){const t=["coalesce"];return this.eachChild((e=>{t.push(e.serialize());})),t}}class qi{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e;}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result);}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const i=t[n];if("string"!=typeof i)return e.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const s=e.parse(t[n+1],n+1);if(!s)return null;r.push([i,s]);}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new qi(r,n):null}outputDefined(){return this.result.outputDefined()}serialize(){const t=["let"];for(const[e,r]of this.bindings)t.push(e,r.serialize());return t.push(this.result.serialize()),t}}class Hi{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,yr),n=e.parse(t[2],2,Ir(e.expectedType||wr));return r&&n?new Hi(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new jr(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new jr(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new jr(`Array index must be an integer, but found ${e} instead. Use at-interpolated to retrieve interpolated result with a fractional index.`);return r[e]}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}serialize(){return ["at",this.index.serialize(),this.input.serialize()]}}class Xi{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,yr),n=e.parse(t[2],2,Ir(e.expectedType||wr));return r&&n?new Xi(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new jr(`Array index out of bounds: ${e} < 0.`);if(e>r.length-1)throw new jr(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e===Math.floor(e))return r[e];const n=Math.floor(e),i=Math.ceil(e),s=r[n],o=r[i];if("number"!=typeof s||"number"!=typeof o)throw new jr(`Cannot interpolate between non-number values at index ${e}.`);const a=e-n;return s*(1-a)+o*a}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}serialize(){return ["at-interpolated",this.index.serialize(),this.input.serialize()]}}class Zi{constructor(t,e){this.type=xr,this.needle=t,this.haystack=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,wr),n=e.parse(t[2],2,wr);return r&&n?Pr(r.type,[xr,gr,yr,mr,wr])?new Zi(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${Sr(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(null==r)return !1;if(!Er(e,["boolean","string","number","null"]))throw new jr(`Expected first argument to be of type boolean, string, number or null, but found ${Sr(Or(e))} instead.`);if(!Er(r,["string","array"]))throw new jr(`Expected second argument to be of type array or string, but found ${Sr(Or(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack);}outputDefined(){return !0}serialize(){return ["in",this.needle.serialize(),this.haystack.serialize()]}}class Wi{constructor(t,e,r){this.type=yr,this.needle=t,this.haystack=e,this.fromIndex=r;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,wr),n=e.parse(t[2],2,wr);if(!r||!n)return null;if(!Pr(r.type,[xr,gr,yr,mr,wr]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${Sr(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,yr);return i?new Wi(r,n,i):null}return new Wi(r,n)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!Er(e,["boolean","string","number","null"]))throw new jr(`Expected first argument to be of type boolean, string, number or null, but found ${Sr(Or(e))} instead.`);if(!Er(r,["string","array"]))throw new jr(`Expected second argument to be of type array or string, but found ${Sr(Or(r))} instead.`);if(this.fromIndex){const n=this.fromIndex.evaluate(t);return r.indexOf(e,n)}return r.indexOf(e)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex);}outputDefined(){return !1}serialize(){if(null!=this.fromIndex&&void 0!==this.fromIndex){const t=this.fromIndex.serialize();return ["index-of",this.needle.serialize(),this.haystack.serialize(),t]}return ["index-of",this.needle.serialize(),this.haystack.serialize()]}}class Yi{constructor(t,e,r,n,i,s){this.inputType=t,this.type=e,this.input=r,this.cases=n,this.outputs=i,this.otherwise=s;}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const i={},s=[];for(let o=2;o<t.length-1;o+=2){let a=t[o];const l=t[o+1];Array.isArray(a)||(a=[a]);const u=e.concat(o);if(0===a.length)return u.error("Expected at least one branch label.");for(const t of a){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,Or(t)))return null}else r=Or(t);if(void 0!==i[String(t)])return u.error("Branch labels must be unique.");i[String(t)]=s.length;}const c=e.parse(l,o,n);if(!c)return null;n=n||c.type,s.push(c);}const o=e.parse(t[1],1,wr);if(!o)return null;const a=e.parse(t[t.length-1],t.length-1,n);return a?"value"!==o.type.kind&&e.concat(1).checkSubtype(r,o.type)?null:new Yi(r,n,o,i,s,a):null}evaluate(t){const e=this.input.evaluate(t);return (Tr(Or(e),this.inputType)&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const t=["match",this.input.serialize()],e=Object.keys(this.cases).sort(),r=[],n={};for(const t of e){const e=n[this.cases[t]];void 0===e?(n[this.cases[t]]=r.length,r.push([this.cases[t],[t]])):r[e][1].push(t);}const i=t=>"number"===this.inputType.kind?Number(t):t;for(const[e,n]of r)t.push(1===n.length?i(n[0]):n.map(i)),t.push(this.outputs[e].serialize());return t.push(this.otherwise.serialize()),t}}class Ki{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r;}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let i=1;i<t.length-1;i+=2){const s=e.parse(t[i],i,xr);if(!s)return null;const o=e.parse(t[i+1],i+1,r);if(!o)return null;n.push([s,o]),r=r||o.type;}const i=e.parse(t[t.length-1],t.length-1,r);return i?new Ki(r,n,i):null}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise);}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const t=["case"];return this.eachChild((e=>{t.push(e.serialize());})),t}}class Ji{constructor(t,e,r,n){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=n;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,wr),n=e.parse(t[2],2,yr);if(!r||!n)return null;if(!Pr(r.type,[Ir(wr),gr,wr]))return e.error(`Expected first argument to be of type array or string, but found ${Sr(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,yr);return i?new Ji(r.type,r,n,i):null}return new Ji(r.type,r,n)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);if(!Er(e,["string","array"]))throw new jr(`Expected first argument to be of type array or string, but found ${Sr(Or(e))} instead.`);if(this.endIndex){const n=this.endIndex.evaluate(t);return e.slice(r,n)}return e.slice(r)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex);}outputDefined(){return !1}serialize(){if(null!=this.endIndex&&void 0!==this.endIndex){const t=this.endIndex.serialize();return ["slice",this.input.serialize(),this.beginIndex.serialize(),t]}return ["slice",this.input.serialize(),this.beginIndex.serialize()]}}function Qi(t,e){return "=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function ts(t,e,r,n){return 0===n.compare(e,r)}function es(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=xr,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind;}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let s=e.parse(t[1],1,wr);if(!s)return null;if(!Qi(r,s.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${Sr(s.type)}'.`);let o=e.parse(t[2],2,wr);if(!o)return null;if(!Qi(r,o.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${Sr(o.type)}'.`);if(s.type.kind!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return e.error(`Cannot compare types '${Sr(s.type)}' and '${Sr(o.type)}'.`);n&&("value"===s.type.kind&&"value"!==o.type.kind?s=new Gr(o.type,[s]):"value"!==s.type.kind&&"value"===o.type.kind&&(o=new Gr(s.type,[o])));let a=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return e.error("Cannot use collator to compare non-string types.");if(a=e.parse(t[3],3,_r),!a)return null}return new i(s,o,a)}evaluate(i){const s=this.lhs.evaluate(i),o=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const e=Or(s),r=Or(o);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new jr(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const t=Or(s),r=Or(o);if("string"!==t.kind||"string"!==r.kind)return e(i,s,o)}return this.collator?r(i,s,o,this.collator.evaluate(i)):e(i,s,o)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator);}outputDefined(){return !0}serialize(){const e=[t];return this.eachChild((t=>{e.push(t.serialize());})),e}}}const rs=es("==",(function(t,e,r){return e===r}),ts),ns=es("!=",(function(t,e,r){return e!==r}),(function(t,e,r,n){return !ts(0,e,r,n)})),is=es("<",(function(t,e,r){return e<r}),(function(t,e,r,n){return n.compare(e,r)<0})),ss=es(">",(function(t,e,r){return e>r}),(function(t,e,r,n){return n.compare(e,r)>0})),os=es("<=",(function(t,e,r){return e<=r}),(function(t,e,r,n){return n.compare(e,r)<=0})),as=es(">=",(function(t,e,r){return e>=r}),(function(t,e,r,n){return n.compare(e,r)>=0}));class ls{constructor(t,e,r,n,i,s){this.type=gr,this.number=t,this.locale=e,this.currency=r,this.unit=n,this.minFractionDigits=i,this.maxFractionDigits=s;}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,yr);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=e.parseObjectValue(n.locale,2,"locale",gr),!i))return null;let s=null;if(n.currency&&(s=e.parseObjectValue(n.currency,2,"currency",gr),!s))return null;let o=null;if(n.unit&&(o=e.parseObjectValue(n.unit,2,"unit",gr),!o))return null;let a=null;if(n["min-fraction-digits"]&&(a=e.parseObjectValue(n["min-fraction-digits"],2,"min-fraction-digits",yr),!a))return null;let l=null;return n["max-fraction-digits"]&&(l=e.parseObjectValue(n["max-fraction-digits"],2,"max-fraction-digits",yr),!l)?null:new ls(r,i,s,o,a,l)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:(this.currency?"currency":this.unit&&"unit")||"decimal",currency:this.currency?this.currency.evaluate(t):void 0,unit:this.unit?this.unit.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.unit&&t(this.unit),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits);}outputDefined(){return !1}serialize(){const t={};return this.locale&&(t.locale=this.locale.serialize()),this.currency&&(t.currency=this.currency.serialize()),this.unit&&(t.unit=this.unit.serialize()),this.minFractionDigits&&(t["min-fraction-digits"]=this.minFractionDigits.serialize()),this.maxFractionDigits&&(t["max-fraction-digits"]=this.maxFractionDigits.serialize()),["number-format",this.number.serialize(),t]}}class us{constructor(t){this.type=yr,this.input=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${Sr(r.type)} instead.`):new us(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return e.length;if(Array.isArray(e))return e.length;throw new jr(`Expected value to be of type string or array, but found ${Sr(Or(e))} instead.`)}eachChild(t){t(this.input);}outputDefined(){return !1}serialize(){const t=["length"];return this.eachChild((e=>{t.push(e.serialize());})),t}}function cs(t){return function(){t=1831565813+(t|=0)|0;let e=Math.imul(t^t>>>15,1|t);return e=e+Math.imul(e^e>>>7,61|e)^e,((e^e>>>14)>>>0)/4294967296}}const hs={"==":rs,"!=":ns,">":ss,"<":is,">=":as,"<=":os,array:Gr,at:Hi,"at-interpolated":Xi,boolean:Gr,case:Ki,coalesce:Gi,collator:tn,format:qr,image:Hr,in:Zi,"index-of":Wi,interpolate:ji,"interpolate-hcl":ji,"interpolate-lab":ji,length:us,let:qi,literal:Nr,match:Yi,number:Gr,"number-format":ls,object:Gr,slice:Ji,step:Ai,string:Gr,"to-boolean":Wr,"to-color":Wr,"to-number":Wr,"to-string":Wr,var:vi,within:Mn,distance:ci,config:xi};function ps(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,o=Lr(e,r,n,s);if(o)throw new jr(o);return new sr(e/255,r/255,n/255,s)}function fs(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,o=function(t,e,r,n){return "number"==typeof t&&t>=0&&t<=360?"number"==typeof e&&e>=0&&e<=100&&"number"==typeof r&&r>=0&&r<=100?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid hsla value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid hsla value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 's', and 'l' must be between 0 and 100.`:`Invalid hsla value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'h' must be between 0 and 360.`}(e,r,n,s);if(o)throw new jr(o);const a=`hsla(${e}, ${r}%, ${n}%, ${s})`,l=sr.parse(a);if(!l)throw new jr(`Failed to parse HSLA color: ${a}`);return l}function ds(t,e){return t in e}function ms(t,e){const r=e[t];return void 0===r?null:r}function ys(t){return {type:t}}function gs(t){return {result:"success",value:t}}function xs(t){return {result:"error",value:t}}function vs(t,e){return !!t&&!!t.parameters&&t.parameters.indexOf(e)>-1}function bs(t){return "data-driven"===t["property-type"]}function ws(t){return vs(t.expression,"measure-light")}function _s(t){return vs(t.expression,"zoom")}function As(t){return !!t.expression&&t.expression.interpolated}function Ms(t){return "object"==typeof t&&null!==t&&!Array.isArray(t)}function Is(t){return t}function Ss(t,e){const r="color"===e.type,n=t.stops&&"object"==typeof t.stops[0][0],i=n||!(n||void 0!==t.property),s=t.type||(As(e)?"exponential":"interval");if(r&&((t=pr({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],sr.parse(t[1])]))),t.default=sr.parse(t.default?t.default:e.default)),t.colorSpace&&"rgb"!==t.colorSpace&&!Ni[t.colorSpace])throw new Error(`Unknown color space: ${t.colorSpace}`);let o,a,l;if("exponential"===s)o=Es;else if("interval"===s)o=Ps;else if("categorical"===s){o=ks,a=Object.create(null);for(const e of t.stops)a[e[0]]=e[1];l=typeof t.stops[0][0];}else {if("identity"!==s)throw new Error(`Unknown function type "${s}"`);o=Ts;}if(n){const r={},n=[];for(let e=0;e<t.stops.length;e++){const i=t.stops[e],s=i[0].zoom;void 0===r[s]&&(r[s]={zoom:s,type:t.type,property:t.property,default:t.default,stops:[]},n.push(s)),r[s].stops.push([i[0].value,i[1]]);}const i=[];for(const t of n)i.push([r[t].zoom,Ss(r[t],e)]);const s={name:"linear"};return {kind:"composite",interpolationType:s,interpolationFactor:ji.interpolationFactor.bind(void 0,s),zoomStops:i.map((t=>t[0])),evaluate:({zoom:r},n)=>Es({stops:i,base:t.base},e,r).evaluate(r,n)}}if(i){const r="exponential"===s?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return {kind:"camera",interpolationType:r,interpolationFactor:ji.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:r})=>o(t,e,r,a,l)}}return {kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[t.property]:void 0;return void 0===i?zs(t.default,e.default):o(t,e,i,a,l)}}}function zs(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function ks(t,e,r,n,i){return zs(typeof r===i?n[r]:void 0,t.default,e.default)}function Ps(t,e,r){if("number"!==Xr(r))return zs(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const i=_i(t.stops.map((t=>t[0])),r);return t.stops[i][1]}function Es(t,e,r){const n=void 0!==t.base?t.base:1;if("number"!==Xr(r))return zs(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const s=_i(t.stops.map((t=>t[0])),r),o=function(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}(r,n,t.stops[s][0],t.stops[s+1][0]),a=t.stops[s][1],l=t.stops[s+1][1];let u=hr[e.type]||Is;if(t.colorSpace&&"rgb"!==t.colorSpace){const e=Ni[t.colorSpace];u=(t,r)=>e.reverse(e.interpolate(e.forward(t),e.forward(r),o));}return "function"==typeof a.evaluate?{evaluate(...t){const e=a.evaluate.apply(void 0,t),r=l.evaluate.apply(void 0,t);if(void 0!==e&&void 0!==r)return u(e,r,o)}}:u(a,l,o)}function Ts(t,e,r){return "color"===e.type?r=sr.parse(r):"formatted"===e.type?r=Cr.fromString(r.toString()):"resolvedImage"===e.type?r=Dr.build(r.toString()):Xr(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0),zs(r,t.default,e.default)}Jr.register(hs,{error:[{kind:"error"},[gr],(t,[e])=>{throw new jr(e.evaluate(t))}],typeof:[gr,[wr],(t,[e])=>Sr(Or(e.evaluate(t)))],"to-rgba":[Ir(yr,4),[vr],(t,[e])=>e.evaluate(t).toNonPremultipliedRenderColor(null).toArray()],"to-hsla":[Ir(yr,4),[vr],(t,[e])=>e.evaluate(t).toNonPremultipliedRenderColor(null).toHslaArray()],rgb:[vr,[yr,yr,yr],ps],rgba:[vr,[yr,yr,yr,yr],ps],hsl:[vr,[yr,yr,yr],fs],hsla:[vr,[yr,yr,yr,yr],fs],has:{type:xr,overloads:[[[gr],(t,[e])=>ds(e.evaluate(t),t.properties())],[[gr,br],(t,[e,r])=>ds(e.evaluate(t),r.evaluate(t))]]},get:{type:wr,overloads:[[[gr],(t,[e])=>ms(e.evaluate(t),t.properties())],[[gr,br],(t,[e,r])=>ms(e.evaluate(t),r.evaluate(t))]]},"feature-state":[wr,[gr],(t,[e])=>ms(e.evaluate(t),t.featureState||{})],properties:[br,[],t=>t.properties()],"geometry-type":[gr,[],t=>t.geometryType()],worldview:[gr,[],t=>t.globals.worldview||""],id:[wr,[],t=>t.id()],zoom:[yr,[],t=>t.globals.zoom],pitch:[yr,[],t=>t.globals.pitch||0],"distance-from-center":[yr,[],t=>t.distanceFromCenter()],"measure-light":[yr,[gr],(t,[e])=>t.measureLight(e.evaluate(t))],"heatmap-density":[yr,[],t=>t.globals.heatmapDensity||0],"line-progress":[yr,[],t=>t.globals.lineProgress||0],"raster-value":[yr,[],t=>t.globals.rasterValue||0],"raster-particle-speed":[yr,[],t=>t.globals.rasterParticleSpeed||0],"sky-radial-progress":[yr,[],t=>t.globals.skyRadialProgress||0],accumulated:[wr,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[yr,ys(yr),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r}],"*":[yr,ys(yr),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r}],"-":{type:yr,overloads:[[[yr,yr],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[yr],(t,[e])=>-e.evaluate(t)]]},"/":[yr,[yr,yr],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[yr,[yr,yr],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[yr,[],()=>Math.LN2],pi:[yr,[],()=>Math.PI],e:[yr,[],()=>Math.E],"^":[yr,[yr,yr],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[yr,[yr],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[yr,[yr],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[yr,[yr],(t,[e])=>Math.log(e.evaluate(t))],log2:[yr,[yr],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[yr,[yr],(t,[e])=>Math.sin(e.evaluate(t))],cos:[yr,[yr],(t,[e])=>Math.cos(e.evaluate(t))],tan:[yr,[yr],(t,[e])=>Math.tan(e.evaluate(t))],asin:[yr,[yr],(t,[e])=>Math.asin(e.evaluate(t))],acos:[yr,[yr],(t,[e])=>Math.acos(e.evaluate(t))],atan:[yr,[yr],(t,[e])=>Math.atan(e.evaluate(t))],min:[yr,ys(yr),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[yr,ys(yr),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[yr,[yr],(t,[e])=>Math.abs(e.evaluate(t))],round:[yr,[yr],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[yr,[yr],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[yr,[yr],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[xr,[gr,wr],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[xr,[wr],(t,[e])=>t.id()===e.value],"filter-type-==":[xr,[gr],(t,[e])=>t.geometryType()===e.value],"filter-<":[xr,[gr,wr],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[xr,[wr],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<n}],"filter->":[xr,[gr,wr],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[xr,[wr],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>n}],"filter-<=":[xr,[gr,wr],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[xr,[wr],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n}],"filter->=":[xr,[gr,wr],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[xr,[wr],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n}],"filter-has":[xr,[wr],(t,[e])=>e.value in t.properties()],"filter-has-id":[xr,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[xr,[Ir(gr)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[xr,[Ir(wr)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[xr,[gr,Ir(wr)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[xr,[gr,Ir(wr)],(t,[e,r])=>function(t,e,r,n){for(;r<=n;){const i=r+n>>1;if(e[i]===t)return !0;e[i]>t?n=i-1:r=i+1;}return !1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:xr,overloads:[[[xr,xr],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[ys(xr),(t,e)=>{for(const r of e)if(!r.evaluate(t))return !1;return !0}]]},any:{type:xr,overloads:[[[xr,xr],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[ys(xr),(t,e)=>{for(const r of e)if(r.evaluate(t))return !0;return !1}]]},"!":[xr,[xr],(t,[e])=>!e.evaluate(t)],"is-supported-script":[xr,[gr],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return !r||r(e.evaluate(t))}],upcase:[gr,[gr],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[gr,[gr],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[gr,ys(wr),(t,e)=>e.map((e=>Ur(e.evaluate(t)))).join("")],"resolved-locale":[gr,[_r],(t,[e])=>e.evaluate(t).resolvedLocale()],random:[yr,[yr,yr,wr],(t,e)=>{const[r,n,i]=e.map((e=>e.evaluate(t)));if(r>n)return r;if(r===n)return r;let s;if("string"==typeof i)s=function(t){let e=0;if(0===t.length)return e;for(let r=0;r<t.length;r++)e=(e<<5)-e+t.charCodeAt(r),e|=0;return e}(i);else {if("number"!=typeof i)throw new jr(`Invalid seed input: ${i}`);s=i;}return r+cs(s)()*(n-r)}]});class Bs{constructor(t,e,r,n){this.expression=t,this._warningHistory={},this._evaluator=new Kr(r,n),this._defaultValue=e?function(t){return "color"===t.type&&(Ms(t.default)||Array.isArray(t.default))?new sr(0,0,0,0):"color"===t.type?sr.parse(t.default)||null:void 0===t.default?null:t.default}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null,this.configDependencies=fi(t);}evaluateWithoutErrorHandling(t,e,r,n,i,s,o,a){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=n||null,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s,this._evaluator.featureTileCoord=o||null,this._evaluator.featureDistanceData=a||null,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,n,i,s,o,a){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n||null,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s||null,this._evaluator.featureTileCoord=o||null,this._evaluator.featureDistanceData=a||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new jr(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(`Failed to evaluate expression "${JSON.stringify(this.expression.serialize())}". ${t.message}`)),this._defaultValue}}}function Vs(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in hs}function Cs(t,e,r,n){const i=new bi(hs,[],e?function(t){const e={color:vr,string:gr,number:yr,enum:gr,boolean:xr,formatted:Ar,resolvedImage:Mr};return "array"===t.type?Ir(e[t.value]||wr,t.length):e[t.type]}(e):void 0,void 0,void 0,r,n),s=i.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return s?gs(new Bs(s,e,r,n)):xs(i.errors)}class Fs{constructor(t,e,r,n){this.kind=t,this._styleExpression=e,this.isLightConstant=r,this.isLineProgressConstant=n,this.isStateDependent="constant"!==t&&!pi(e.expression),this.configDependencies=fi(e.expression);}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}}class Ds{constructor(t,e,r,n,i,s){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!pi(e.expression),this.isLightConstant=i,this.isLineProgressConstant=s,this.configDependencies=fi(e.expression),this.interpolationType=n;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}interpolationFactor(t,e,r){return this.interpolationType?ji.interpolationFactor(this.interpolationType,t,e,r):0}}function Ls(t,e,r,n){if("error"===(t=Cs(t,e,r,n)).result)return t;const i=t.value.expression,s=hi(i);if(!s&&!bs(e))return xs([new fr("","data expressions not supported")]);const o=di(i,["zoom","pitch","distance-from-center"]);if(!o&&!_s(e))return xs([new fr("","zoom expressions not supported")]);const a=di(i,["measure-light"]);if(!a&&!ws(e))return xs([new fr("","measure-light expression not supported")]);const l=di(i,["line-progress"]);if(!l&&!function(t){return vs(t.expression,"line-progress")}(e))return xs([new fr("","line-progress expression not supported")]);const u=e.expression&&e.expression.relaxZoomRestriction,c=Os(i);return c||o||u?c instanceof fr?xs([c]):c instanceof ji&&!As(e)?xs([new fr("",'"interpolate" expressions cannot be used with this property')]):gs(c?new Ds(s&&l?"camera":"composite",t.value,c.labels,c instanceof ji?c.interpolation:void 0,a,l):new Fs(s&&l?"constant":"source",t.value,a,l)):xs([new fr("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression, or in the properties of atmosphere.')])}class Rs{constructor(t,e){this._parameters=t,this._specification=e,pr(this,Ss(this._parameters,this._specification));}static deserialize(t){return new Rs(t._parameters,t._specification)}static serialize(t){return {_parameters:t._parameters,_specification:t._specification}}}function Os(t){let e=null;if(t instanceof qi)e=Os(t.result);else if(t instanceof Gi){for(const r of t.args)if(e=Os(r),e)break}else (t instanceof Ai||t instanceof ji)&&t.input instanceof Jr&&"zoom"===t.input.name&&(e=t);return e instanceof fr||t.eachChild((t=>{const r=Os(t);r instanceof fr?e=r:e&&r&&e!==r&&(e=new fr("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));})),e}var Us,Ns,js=function(){if(Ns)return Us;Ns=1,Us=e;var t=3;function e(e,r,n){var i=this.cells=[];if(e instanceof ArrayBuffer){this.arrayBuffer=e;var s=new Int32Array(this.arrayBuffer);e=s[0],this.d=(r=s[1])+2*(n=s[2]);for(var o=0;o<this.d*this.d;o++){var a=s[t+o],l=s[t+o+1];i.push(a===l?null:s.subarray(a,l));}var u=s[t+i.length+1];this.keys=s.subarray(s[t+i.length],u),this.bboxes=s.subarray(u),this.insert=this._insertReadonly;}else {this.d=r+2*n;for(var c=0;c<this.d*this.d;c++)i.push([]);this.keys=[],this.bboxes=[];}this.n=r,this.extent=e,this.padding=n,this.scale=r/e,this.uid=0;var h=n/r*e;this.min=-h,this.max=e+h;}return e.prototype.insert=function(t,e,r,n,i){this._forEachCell(e,r,n,i,this._insertCell,this.uid++),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i);},e.prototype._insertReadonly=function(){throw "Cannot insert into a GridIndex created from an ArrayBuffer."},e.prototype._insertCell=function(t,e,r,n,i,s){this.cells[i].push(s);},e.prototype.query=function(t,e,r,n,i){var s=this.min,o=this.max;if(t<=s&&e<=s&&o<=r&&o<=n&&!i)return Array.prototype.slice.call(this.keys);var a=[];return this._forEachCell(t,e,r,n,this._queryCell,a,{},i),a},e.prototype._queryCell=function(t,e,r,n,i,s,o,a){var l=this.cells[i];if(null!==l)for(var u=this.keys,c=this.bboxes,h=0;h<l.length;h++){var p=l[h];if(void 0===o[p]){var f=4*p;(a?a(c[f+0],c[f+1],c[f+2],c[f+3]):t<=c[f+2]&&e<=c[f+3]&&r>=c[f+0]&&n>=c[f+1])?(o[p]=!0,s.push(u[p])):o[p]=!1;}}},e.prototype._forEachCell=function(t,e,r,n,i,s,o,a){for(var l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n),p=l;p<=c;p++)for(var f=u;f<=h;f++){var d=this.d*f+p;if((!a||a(this._convertFromCellCoord(p),this._convertFromCellCoord(f),this._convertFromCellCoord(p+1),this._convertFromCellCoord(f+1)))&&i.call(this,t,e,r,n,d,s,o,a))return}},e.prototype._convertFromCellCoord=function(t){return (t-this.padding)/this.scale},e.prototype._convertToCellCoord=function(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))},e.prototype.toArrayBuffer=function(){if(this.arrayBuffer)return this.arrayBuffer;for(var e=this.cells,r=t+this.cells.length+1+1,n=0,i=0;i<this.cells.length;i++)n+=this.cells[i].length;var s=new Int32Array(r+n+this.keys.length+this.bboxes.length);s[0]=this.extent,s[1]=this.n,s[2]=this.padding;for(var o=r,a=0;a<e.length;a++){var l=e[a];s[t+a]=o,s.set(l,o),o+=l.length;}return s[t+e.length]=o,s.set(this.keys,o),s[t+e.length+1]=o+=this.keys.length,s.set(this.bboxes,o),o+=this.bboxes.length,s.buffer},Us}(),$s=dt(js);const Gs={};function qs(t,e,r={}){Object.defineProperty(t,"_classRegistryKey",{value:e,writable:!1}),Gs[e]={klass:t,omit:r.omit||[]};}qs(Object,"Object"),$s.serialize=function(t,e){const r=t.toArrayBuffer();return e&&e.add(r),{buffer:r}},$s.deserialize=function(t){return new $s(t.buffer)},Object.defineProperty($s,"name",{value:"Grid"}),qs($s,"Grid"),"undefined"!=typeof DOMMatrix&&qs(DOMMatrix,"DOMMatrix"),qs(sr,"Color"),qs(Error,"Error"),qs(Cr,"Formatted"),qs(Vr,"FormattedSection"),qs(Ve,"AJAXError"),qs(Dr,"ResolvedImage"),qs(Rs,"StylePropertyFunction"),qs(Bs,"StyleExpression",{omit:["_evaluator"]}),qs(er,"ImageId"),qs(Fr,"ImageVariant"),qs(Ds,"ZoomDependentExpression"),qs(Fs,"ZoomConstantExpression"),qs(Jr,"CompoundExpression",{omit:["_evaluate"]});for(const t in hs)Gs[hs[t]._classRegistryKey]||qs(hs[t],`Expression${t}`);function Hs(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function Xs(t){return self.ImageBitmap&&t instanceof ImageBitmap}function Zs(t,e){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp)return t;if(Hs(t)||Xs(t))return e&&e.add(t),t;if(ArrayBuffer.isView(t))return e&&e.add(t.buffer),t;if(t instanceof ImageData)return e&&e.add(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const n of t)r.push(Zs(n,e));return r}if(t instanceof Map){const r={$name:"Map",entries:[]};for(const[n,i]of t.entries())r.entries.push(Zs(n),Zs(i,e));return r}if(t instanceof Set){const e={$name:"Set"};let r=0;for(const n of t.values())e[++r]=Zs(n);return e}if(t instanceof DOMMatrix){const e={$name:"DOMMatrix"},r=["is2D","m11","m12","m13","m14","m21","m22","m23","m24","m31","m32","m33","m34","m41","m42","m43","m44","a","b","c","d","e","f"];for(const n of r)e[n]=t[n];return e}if("bigint"==typeof t)return {$name:"BigInt",value:t.toString()};if("object"==typeof t){const r=t.constructor,n=r._classRegistryKey;if(!n)throw new Error(`Can't serialize object of unregistered class "${r.name}".`);const i=r.serialize?r.serialize(t,e):{};if(!r.serialize){for(const r in t)t.hasOwnProperty(r)&&(Gs[n].omit.indexOf(r)>=0||(i[r]=Zs(t[r],e)));t instanceof Error&&(i.message=t.message);}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return "Object"!==n&&(i.$name=n),i}throw new Error("can't serialize object of type "+typeof t)}function Ws(t){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||Hs(t)||Xs(t)||ArrayBuffer.isView(t)||t instanceof ImageData)return t;if(Array.isArray(t))return t.map(Ws);if("object"==typeof t){const e=t.$name||"Object";if("Map"===e){const e=t.entries||[],r=new Map;for(let t=0;t<e.length;t+=2)r.set(Ws(e[t]),Ws(e[t+1]));return r}if("Set"===e){const e=new Set;for(const r of Object.keys(t))"$name"!==r&&e.add(Ws(t[r]));return e}if("DOMMatrix"===e){let e;return e=t.is2D?[t.a,t.b,t.c,t.d,t.e,t.f]:[t.m11,t.m12,t.m13,t.m14,t.m21,t.m22,t.m23,t.m24,t.m31,t.m32,t.m33,t.m34,t.m41,t.m42,t.m43,t.m44],new DOMMatrix(e)}if("BigInt"===e)return BigInt(t.value);const{klass:r}=Gs[e];if(!r)throw new Error(`Can't deserialize unregistered class "${e}".`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const e of Object.keys(t))"$name"!==e&&(n[e]=Ws(t[e]));return n}throw new Error("can't deserialize object of type "+typeof t)}const Ys={"Latin-1 Supplement":t=>t>=128&&t<=255,Arabic:t=>t>=1536&&t<=1791,"Arabic Supplement":t=>t>=1872&&t<=1919,"Arabic Extended-A":t=>t>=2208&&t<=2303,"Hangul Jamo":t=>t>=4352&&t<=4607,"Unified Canadian Aboriginal Syllabics":t=>t>=5120&&t<=5759,Khmer:t=>t>=6016&&t<=6143,"Unified Canadian Aboriginal Syllabics Extended":t=>t>=6320&&t<=6399,"General Punctuation":t=>t>=8192&&t<=8303,"Letterlike Symbols":t=>t>=8448&&t<=8527,"Number Forms":t=>t>=8528&&t<=8591,"Miscellaneous Technical":t=>t>=8960&&t<=9215,"Control Pictures":t=>t>=9216&&t<=9279,"Optical Character Recognition":t=>t>=9280&&t<=9311,"Enclosed Alphanumerics":t=>t>=9312&&t<=9471,"Geometric Shapes":t=>t>=9632&&t<=9727,"Miscellaneous Symbols":t=>t>=9728&&t<=9983,"Miscellaneous Symbols and Arrows":t=>t>=11008&&t<=11263,"CJK Radicals Supplement":t=>t>=11904&&t<=12031,"Kangxi Radicals":t=>t>=12032&&t<=12255,"Ideographic Description Characters":t=>t>=12272&&t<=12287,"CJK Symbols and Punctuation":t=>t>=12288&&t<=12351,Hiragana:t=>t>=12352&&t<=12447,Katakana:t=>t>=12448&&t<=12543,Bopomofo:t=>t>=12544&&t<=12591,"Hangul Compatibility Jamo":t=>t>=12592&&t<=12687,Kanbun:t=>t>=12688&&t<=12703,"Bopomofo Extended":t=>t>=12704&&t<=12735,"CJK Strokes":t=>t>=12736&&t<=12783,"Katakana Phonetic Extensions":t=>t>=12784&&t<=12799,"Enclosed CJK Letters and Months":t=>t>=12800&&t<=13055,"CJK Compatibility":t=>t>=13056&&t<=13311,"CJK Unified Ideographs Extension A":t=>t>=13312&&t<=19903,"Yijing Hexagram Symbols":t=>t>=19904&&t<=19967,"CJK Unified Ideographs":t=>t>=19968&&t<=40959,"Yi Syllables":t=>t>=40960&&t<=42127,"Yi Radicals":t=>t>=42128&&t<=42191,"Hangul Jamo Extended-A":t=>t>=43360&&t<=43391,"Hangul Syllables":t=>t>=44032&&t<=55215,"Hangul Jamo Extended-B":t=>t>=55216&&t<=55295,"Private Use Area":t=>t>=57344&&t<=63743,"CJK Compatibility Ideographs":t=>t>=63744&&t<=64255,"Arabic Presentation Forms-A":t=>t>=64336&&t<=65023,"Vertical Forms":t=>t>=65040&&t<=65055,"CJK Compatibility Forms":t=>t>=65072&&t<=65103,"Small Form Variants":t=>t>=65104&&t<=65135,"Arabic Presentation Forms-B":t=>t>=65136&&t<=65279,"Halfwidth and Fullwidth Forms":t=>t>=65280&&t<=65519,Osage:t=>t>=66736&&t<=66815,"CJK Unified Ideographs Extension B":t=>t>=131072&&t<=173791};function Ks(t){for(const e of t)if(to(e.charCodeAt(0)))return !0;return !1}function Js(t){for(const e of t)if(!Qs(e.charCodeAt(0)))return !1;return !0}function Qs(t){return !(Ys.Arabic(t)||Ys["Arabic Supplement"](t)||Ys["Arabic Extended-A"](t)||Ys["Arabic Presentation Forms-A"](t)||Ys["Arabic Presentation Forms-B"](t))}function to(t){return !(746!==t&&747!==t&&(t<4352||!(Ys["Bopomofo Extended"](t)||Ys.Bopomofo(t)||Ys["CJK Compatibility Forms"](t)&&!(t>=65097&&t<=65103)||Ys["CJK Compatibility Ideographs"](t)||Ys["CJK Compatibility"](t)||Ys["CJK Radicals Supplement"](t)||Ys["CJK Strokes"](t)||!(!Ys["CJK Symbols and Punctuation"](t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||Ys["CJK Unified Ideographs Extension A"](t)||Ys["CJK Unified Ideographs"](t)||Ys["Enclosed CJK Letters and Months"](t)||Ys["Hangul Compatibility Jamo"](t)||Ys["Hangul Jamo Extended-A"](t)||Ys["Hangul Jamo Extended-B"](t)||Ys["Hangul Jamo"](t)||Ys["Hangul Syllables"](t)||Ys.Hiragana(t)||Ys["Ideographic Description Characters"](t)||Ys.Kanbun(t)||Ys["Kangxi Radicals"](t)||Ys["Katakana Phonetic Extensions"](t)||Ys.Katakana(t)&&12540!==t||!(!Ys["Halfwidth and Fullwidth Forms"](t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!Ys["Small Form Variants"](t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||Ys["Unified Canadian Aboriginal Syllabics"](t)||Ys["Unified Canadian Aboriginal Syllabics Extended"](t)||Ys["Vertical Forms"](t)||Ys["Yijing Hexagram Symbols"](t)||Ys["Yi Syllables"](t)||Ys["Yi Radicals"](t))))}function eo(t){return !(to(t)||function(t){return !!(Ys["Latin-1 Supplement"](t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||Ys["General Punctuation"](t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||Ys["Letterlike Symbols"](t)||Ys["Number Forms"](t)||Ys["Miscellaneous Technical"](t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||Ys["Control Pictures"](t)&&9251!==t||Ys["Optical Character Recognition"](t)||Ys["Enclosed Alphanumerics"](t)||Ys["Geometric Shapes"](t)||Ys["Miscellaneous Symbols"](t)&&!(t>=9754&&t<=9759)||Ys["Miscellaneous Symbols and Arrows"](t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||Ys["CJK Symbols and Punctuation"](t)||Ys.Katakana(t)||Ys["Private Use Area"](t)||Ys["CJK Compatibility Forms"](t)||Ys["Small Form Variants"](t)||Ys["Halfwidth and Fullwidth Forms"](t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}function ro(t){return Ys.Arabic(t)||Ys["Arabic Supplement"](t)||Ys["Arabic Extended-A"](t)||Ys["Arabic Presentation Forms-A"](t)||Ys["Arabic Presentation Forms-B"](t)}function no(t){return t>=1424&&t<=2303||Ys["Arabic Presentation Forms-A"](t)||Ys["Arabic Presentation Forms-B"](t)}function io(t,e){return !(!e&&no(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||Ys.Khmer(t))}function so(t){for(const e of t)if(no(e.charCodeAt(0)))return !0;return !1}const oo={unavailable:"unavailable",deferred:"deferred",loading:"loading",parsing:"parsing",parsed:"parsed",loaded:"loaded",error:"error"};let ao=null,lo=oo.unavailable,uo=null;const co=function(t){t&&"string"==typeof t&&t.indexOf("NetworkError")>-1&&(lo=oo.error),ao&&ao(t);};function ho(){po.fire(new Ye("pluginStateChange",{pluginStatus:lo,pluginURL:uo}));}const po=new tr,fo=function(){return lo},mo=function(){if(lo!==oo.deferred||!uo)throw new Error("rtl-text-plugin cannot be downloaded unless a pluginURL is specified");lo=oo.loading,ho(),uo&&De({url:uo},(t=>{t?co(t):(lo=oo.loaded,ho());}));},yo={applyArabicShaping:null,processBidirectionalText:null,processStyledBidirectionalText:null,isLoaded:()=>lo===oo.loaded||null!=yo.applyArabicShaping,isLoading:()=>lo===oo.loading,setState(t){lo=t.pluginStatus,uo=t.pluginURL;},isParsing:()=>lo===oo.parsing,isParsed:()=>lo===oo.parsed,getPluginURL:()=>uo};class go{constructor(t,e){this.zoom=t,e?(this.now=e.now,this.fadeDuration=e.fadeDuration,this.transition=e.transition,this.pitch=e.pitch,this.brightness=e.brightness,this.worldview=e.worldview):(this.now=0,this.fadeDuration=0,this.transition={},this.pitch=0,this.brightness=0);}isSupportedScript(t){return function(t,e){for(const r of t)if(!io(r.charCodeAt(0),e))return !1;return !0}(t,yo.isLoaded())}}class xo{constructor(t,e,r,n){this.property=t,this.value=e,this.expression=function(t,e,r,n){if(Ms(t))return new Rs(t,e);if(Vs(t)||Array.isArray(t)&&t.length>0){const i=Ls(t,e,r,n);if("error"===i.result)throw new Error(i.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return i.value}{let r=t;return "string"==typeof t&&"color"===e.type&&(r=sr.parse(t)),{kind:"constant",configDependencies:new Set,evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification,r,n);}isDataDriven(){return "source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}}class vo{constructor(t,e,r){this.property=t,this.value=new xo(t,void 0,e,r);}transitioned(t,e){return new wo(this.property,this.value,e,Ct({},t.transition,this.transition),t.now)}untransitioned(){return new wo(this.property,this.value,null,{},0)}}class bo{constructor(t,e,r){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues),this._scope=e,this._options=r,this.configDependencies=new Set;}getValue(t){return Nt(this._values[t].value.value)}setValue(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new vo(this._values[t].property,this._scope,this._options)),this._values[t].value=new xo(this._values[t].property,null===e?void 0:Nt(e),this._scope,this._options),this._values[t].value.expression.configDependencies&&(this.configDependencies=new Set([...this.configDependencies,...this._values[t].value.expression.configDependencies]));}setTransitionOrValue(t,e){e&&(this._options=e);const r=this._properties.properties;if(t)for(const e in t){const n=t[e];if(e.endsWith("-transition")){const t=e.slice(0,-11);r[t]&&this.setTransition(t,n);}else r.hasOwnProperty(e)&&this.setValue(e,n);}}getTransition(t){return Nt(this._values[t].transition)}setTransition(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new vo(this._values[t].property)),this._values[t].transition=Nt(e)||void 0;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}-transition`]=n);}return t}transitioned(t,e){const r=new _o(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r}untransitioned(){const t=new _o(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class wo{constructor(t,e,r,n,i){const s=n.delay||0,o=n.duration||0;i=i||0,this.property=t,this.value=e,this.begin=i+s,this.end=this.begin+o,t.specification.transition&&(n.delay||n.duration)&&(this.prior=r);}possiblyEvaluate(t,e,r){const n=t.now||0,i=this.value.possiblyEvaluate(t,e,r),s=this.prior;if(s){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return s.possiblyEvaluate(t,e,r);{const o=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,r),i,zt(o))}}return i}}class _o{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues);}possiblyEvaluate(t,e,r){const n=new Io(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return !0;return !1}}class Ao{constructor(t,e,r){this._properties=t,this._values=Object.create(t.defaultPropertyValues),this._scope=e,this._options=r,this.configDependencies=new Set;}getValue(t){return Nt(this._values[t].value)}setValue(t,e){this._values[t]=new xo(this._values[t].property,null===e?void 0:Nt(e),this._scope,this._options),this._values[t].expression.configDependencies&&(this.configDependencies=new Set([...this.configDependencies,...this._values[t].expression.configDependencies]));}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);}return t}possiblyEvaluate(t,e,r){const n=new Io(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}}class Mo{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r;}isConstant(){return "constant"===this.value.kind}constantOr(t){return "constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n)}}class Io{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues);}get(t){return this._values[t]}}class So{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return t.expression.evaluate(e)}interpolate(t,e,r){const n=hr[this.specification.type];return n?n(t,e,r):t}}class zo{constructor(t,e){this.specification=t,this.overrides=e;}possiblyEvaluate(t,e,r,n){return new Mo(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,n)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new Mo(this,{kind:"constant",value:void 0},t.parameters);const n=hr[this.specification.type];return n?new Mo(this,{kind:"constant",value:n(t.value.value,e.value.value,r)},t.parameters):t}evaluate(t,e,r,n,i,s){return "constant"===t.kind?t.value:t.evaluate(e,r,n,i,s)}}class ko{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){return !!t.expression.evaluate(e,null,{},r,n)}interpolate(){return !1}}class Po{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];const e=new go(0,{});for(const r in t){const n=t[r];n.specification.overridable&&this.overridableProperties.push(r);const i=this.defaultPropertyValues[r]=new xo(n,void 0),s=this.defaultTransitionablePropertyValues[r]=new vo(n);this.defaultTransitioningPropertyValues[r]=s.untransitioned(),this.defaultPossiblyEvaluatedValues[r]=i.possiblyEvaluate(e);}}}qs(zo,"DataDrivenProperty"),qs(So,"DataConstantProperty"),qs(ko,"ColorRampProperty");var Eo=JSON.parse('{"$version":8,"$root":{"version":{"type":"enum","values":[8]},"fragment":{"type":"boolean"},"name":{"type":"string"},"metadata":{"type":"*"},"center":{"type":"array","value":"number"},"zoom":{"type":"number"},"bearing":{"type":"number","default":0,"period":360},"pitch":{"type":"number","default":0},"light":{"type":"light"},"lights":{"type":"array","value":"light-3d"},"terrain":{"type":"terrain","optional":true},"fog":{"type":"fog"},"snow":{"type":"snow"},"rain":{"type":"rain"},"camera":{"type":"camera"},"color-theme":{"type":"colorTheme"},"indoor":{"type":"indoor"},"imports":{"type":"array","value":"import"},"iconsets":{"type":"iconsets"},"schema":{"type":"schema"},"sources":{"type":"sources"},"sprite":{"type":"string"},"glyphs":{"type":"string","default":"mapbox://fonts/mapbox/{fontstack}/{range}.pbf"},"transition":{"type":"transition"},"projection":{"type":"projection"},"layers":{"type":"array","value":"layer"},"models":{"type":"models"},"featuresets":{"type":"featuresets"}},"featuresets":{"*":{"type":"featureset"}},"featureset":{"metadata":{"type":"*"},"selectors":{"type":"array","value":"selector"}},"selector":{"layer":{"type":"string"},"properties":{"type":"selectorProperty"},"featureNamespace":{"type":"string"},"_uniqueFeatureID":{"type":"boolean"}},"selectorProperty":{"*":{"type":"*"}},"model":{"type":"string"},"import":{"id":{"type":"string"},"url":{"type":"string"},"config":{"type":"config"},"data":{"type":"$root"},"color-theme":{"type":"colorTheme","optional":true}},"config":{"*":{"type":"*"}},"schema":{"*":{"type":"option"}},"option":{"default":{"type":"*","expression":{}},"type":{"type":"enum","values":{"string":1,"number":1,"boolean":1,"color":1}},"array":{"type":"boolean"},"minValue":{"type":"number"},"maxValue":{"type":"number"},"stepValue":{"type":"number"},"values":{"type":"array","value":"*"},"metadata":{"type":"*"}},"models":{"*":{"type":"model"}},"light-3d":{"id":{"type":"string"},"properties":{"type":"properties"},"type":{"type":"enum","values":{"ambient":{},"directional":{},"flat":{}}}},"properties":["properties_light_directional","properties_light_ambient","properties_light_flat"],"properties_light_directional":{"direction":{"type":"array","default":[210,30],"minimum":[0,0],"maximum":[360,90],"length":2,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"use-theme":true,"transition":true},"intensity":{"type":"number","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"cast-shadows":{"type":"boolean","default":false},"shadow-quality":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{"parameters":["zoom"]}},"shadow-intensity":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"properties_light_ambient":{"color":{"type":"color","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"use-theme":true,"transition":true},"intensity":{"type":"number","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"properties_light_flat":{"anchor":{"type":"enum","default":"viewport","values":{"map":1,"viewport":1},"expression":{"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"use-theme":true,"transition":true},"intensity":{"type":"number","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"iconsets":{"*":{"type":"iconset"}},"iconset":["iconset_sprite","iconset_source"],"iconset_sprite":{"type":{"type":"enum","values":{"sprite":1}},"url":{"type":"string"}},"iconset_source":{"type":{"type":"enum","values":{"source":1}},"source":{"type":"string"}},"sources":{"*":{"type":"source"}},"source":["source_vector","source_raster","source_raster_dem","source_raster_array","source_geojson","source_video","source_image","source_model"],"source_vector":{"type":{"type":"enum","values":{"vector":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"extra_bounds":{"type":"array","value":{"type":"array","value":"number","length":4}},"scheme":{"type":"enum","values":{"xyz":1,"tms":1},"default":"xyz"},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"attribution":{"type":"string"},"promoteId":{"type":"promoteId"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster":{"type":{"type":"enum","values":{"raster":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"extra_bounds":{"type":"array","value":{"type":"array","value":"number","length":4}},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"scheme":{"type":"enum","values":{"xyz":1,"tms":1},"default":"xyz"},"attribution":{"type":"string"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster_dem":{"type":{"type":"enum","values":{"raster-dem":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"extra_bounds":{"type":"array","value":{"type":"array","value":"number","length":4}},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"attribution":{"type":"string"},"encoding":{"type":"enum","values":{"terrarium":1,"mapbox":1},"default":"mapbox"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster_array":{"type":{"type":"enum","values":{"raster-array":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"extra_bounds":{"type":"array","value":{"type":"array","value":"number","length":4}},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"attribution":{"type":"string"},"rasterLayers":{"type":"*"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_geojson":{"type":{"type":"enum","values":{"geojson":1}},"data":{"type":"*"},"maxzoom":{"type":"number","default":18},"minzoom":{"type":"number","default":0},"attribution":{"type":"string"},"buffer":{"type":"number","default":128,"maximum":512,"minimum":0},"filter":{"type":"*"},"tolerance":{"type":"number","default":0.375},"cluster":{"type":"boolean","default":false},"clusterRadius":{"type":"number","default":50,"minimum":0},"clusterMaxZoom":{"type":"number"},"clusterMinPoints":{"type":"number"},"clusterProperties":{"type":"*"},"lineMetrics":{"type":"boolean","default":false},"generateId":{"type":"boolean","default":false},"promoteId":{"type":"promoteId"},"dynamic":{"type":"boolean","default":false}},"source_video":{"type":{"type":"enum","values":{"video":1}},"urls":{"type":"array","value":"string"},"coordinates":{"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"source_image":{"type":{"type":"enum","values":{"image":1}},"url":{"type":"string"},"coordinates":{"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"source_model":{"type":{"type":"enum","values":{"model":1,"batched-model":1}},"maxzoom":{"type":"number","default":18},"minzoom":{"type":"number","default":0},"tiles":{"type":"array","value":"string"}},"layer":{"id":{"type":"string"},"type":{"type":"enum","values":{"fill":{},"line":{},"symbol":{},"circle":{},"heatmap":{},"fill-extrusion":{},"building":{},"raster":{},"raster-particle":{},"hillshade":{},"model":{},"background":{},"sky":{},"slot":{},"clip":{}}},"metadata":{"type":"*"},"source":{"type":"string"},"source-layer":{"type":"string"},"slot":{"type":"string"},"minzoom":{"type":"number","minimum":0,"maximum":24},"maxzoom":{"type":"number","minimum":0,"maximum":24},"filter":{"type":"filter"},"layout":{"type":"layout"},"paint":{"type":"paint"}},"layout":["layout_clip","layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_building","layout_symbol","layout_raster","layout_raster-particle","layout_hillshade","layout_background","layout_sky","layout_model"],"layout_background":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}}},"layout_sky":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}}},"layout_model":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}},"model-id":{"type":"string","default":"","property-type":"data-driven","expression":{"parameters":["zoom","feature"]}}},"layout_clip":{"clip-layer-types":{"type":"array","value":"enum","values":{"model":1,"symbol":1},"default":[],"expression":{}},"clip-layer-scope":{"type":"array","value":"string","default":[],"expression":{}}},"layout_fill":{"fill-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}},"fill-elevation-reference":{"type":"enum","values":{"none":1,"hd-road-base":1,"hd-road-markup":1},"default":"none","expression":{}},"fill-construct-bridge-guard-rail":{"type":"boolean","default":"true","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"}},"layout_circle":{"circle-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"circle-elevation-reference":{"type":"enum","values":{"none":1,"hd-road-markup":1},"default":"none","expression":{}},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}}},"layout_heatmap":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}}},"layout_fill-extrusion":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}},"fill-extrusion-edge-radius":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{}}},"layout_building":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}},"building-roof-shape":{"type":"enum","values":{"flat":1,"hipped":1,"gabled":1,"parapet":1,"mansard":1,"skillion":1,"pyramidal":1},"default":"flat","expression":{"parameters":["feature"]},"property-type":"data-driven"},"building-height":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{},"property-type":"data-driven"},"building-base":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{},"property-type":"data-driven"}},"layout_line":{"line-cap":{"type":"enum","values":{"butt":1,"round":1,"square":1},"default":"butt","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-join":{"type":"enum","values":{"bevel":1,"round":1,"miter":1,"none":1},"default":"miter","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{"type":"number","default":2,"expression":{"interpolated":true,"parameters":["zoom"]}},"line-round-limit":{"type":"number","default":1.05,"expression":{"interpolated":true,"parameters":["zoom"]}},"line-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-z-offset":{"type":"number","default":0,"expression":{"parameters":["zoom","feature","line-progress"]},"property-type":"data-driven"},"line-elevation-reference":{"type":"enum","values":{"none":1,"sea":1,"ground":1,"hd-road-markup":1},"default":"none","expression":{}},"line-cross-slope":{"type":"number","expression":{}},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}},"line-width-unit":{"type":"enum","values":{"pixels":1,"meters":1},"default":"pixels","expression":{"parameters":["zoom"]}}},"layout_symbol":{"symbol-placement":{"type":"enum","values":{"point":1,"line":1,"line-center":1},"default":"point","expression":{"parameters":["zoom"]}},"symbol-spacing":{"type":"number","default":250,"minimum":1,"expression":{"interpolated":true,"parameters":["zoom"]}},"symbol-avoid-edges":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]}},"symbol-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{"type":"enum","values":{"auto":1,"viewport-y":1,"source":1},"default":"auto","expression":{"parameters":["zoom"]}},"symbol-z-elevate":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]}},"symbol-elevation-reference":{"type":"enum","values":{"sea":1,"ground":1,"hd-road-markup":1},"default":"ground","expression":{"parameters":["zoom"]}},"icon-allow-overlap":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]}},"icon-ignore-placement":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]}},"icon-optional":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]}},"icon-rotation-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]}},"icon-size":{"type":"number","default":1,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-size-scale-range":{"type":"array","value":"number","length":2,"default":[0.8,2],"minimum":0.1,"maximum":10,"expression":{}},"icon-text-fit":{"type":"enum","values":{"none":1,"width":1,"height":1,"both":1},"default":"none","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit-padding":{"type":"array","value":"number","length":4,"default":[0,0,0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-image":{"type":"resolvedImage","tokens":true,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{"type":"number","default":0,"period":360,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{"type":"number","default":2,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]}},"icon-keep-upright":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]}},"icon-offset":{"type":"array","value":"number","length":2,"default":[0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{"type":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]}},"text-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]}},"text-rotation-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]}},"text-field":{"type":"formatted","default":"","tokens":true,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-font":{"type":"array","value":"string","default":["Open Sans Regular","Arial Unicode MS Regular"],"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-size":{"type":"number","default":16,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-size-scale-range":{"type":"array","value":"number","length":2,"default":[0.8,2],"minimum":0.1,"maximum":10,"expression":{}},"text-max-width":{"type":"number","default":10,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{"type":"number","default":1.2,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-letter-spacing":{"type":"number","default":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-justify":{"type":"enum","values":{"auto":1,"left":1,"center":1,"right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{"type":"number","default":0,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["zoom","feature"]}},"text-variable-anchor":{"type":"array","value":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"expression":{"parameters":["zoom"]}},"text-anchor":{"type":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{"type":"number","default":45,"expression":{"interpolated":true,"parameters":["zoom"]}},"text-writing-mode":{"type":"array","value":"enum","values":{"horizontal":1,"vertical":1},"expression":{"parameters":["zoom"]}},"text-rotate":{"type":"number","default":0,"period":360,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-padding":{"type":"number","default":2,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]}},"text-keep-upright":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]}},"text-transform":{"type":"enum","values":{"none":1,"uppercase":1,"lowercase":1},"default":"none","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-offset":{"type":"array","value":"number","length":2,"default":[0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]}},"text-ignore-placement":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]}},"text-optional":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]}},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}}},"layout_raster":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}}},"layout_raster-particle":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}}},"layout_hillshade":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}}},"filter":{"type":"array","value":"*"},"filter_symbol":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature","pitch","distance-from-center"]}},"filter_fill":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_hillshade":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_raster":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_raster-particle":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_clip":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_model":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_line":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_circle":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_fill-extrusion":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_building":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_heatmap":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_operator":{"type":"enum","values":{"==":1,"!=":1,">":1,">=":1,"<":1,"<=":1,"in":1,"!in":1,"all":1,"any":1,"none":1,"has":1,"!has":1}},"geometry_type":{"type":"enum","values":{"Point":1,"LineString":1,"Polygon":1}},"function":{"expression":{"type":"expression"},"stops":{"type":"array","value":"function_stop"},"base":{"type":"number","default":1,"minimum":0},"property":{"type":"string","default":"$zoom"},"type":{"type":"enum","values":{"identity":1,"exponential":1,"interval":1,"categorical":1},"default":"exponential"},"colorSpace":{"type":"enum","values":{"rgb":1,"lab":1,"hcl":1},"default":"rgb"},"default":{"type":"*"}},"function_stop":{"type":"array","minimum":0,"maximum":24,"value":["number","color"],"length":2},"expression":{"type":"array","value":"*","minimum":1},"fog":{"range":{"type":"array","default":[0.5,10],"minimum":-20,"maximum":20,"length":2,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"color":{"type":"color","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"use-theme":true,"transition":true},"high-color":{"type":"color","default":"#245cdf","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"use-theme":true,"transition":true},"space-color":{"type":"color","default":["interpolate",["linear"],["zoom"],4,"#010b19",7,"#367ab9"],"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"use-theme":true,"transition":true},"horizon-blend":{"type":"number","default":["interpolate",["linear"],["zoom"],4,0.2,7,0.1],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"star-intensity":{"type":"number","default":["interpolate",["linear"],["zoom"],5,0.35,6,0],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vertical-range":{"type":"array","default":[0,0],"minimum":0,"length":2,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}}},"snow":{"density":{"type":"number","default":["interpolate",["linear"],["zoom"],11,0,13,0.85],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"intensity":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"color":{"type":"color","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"use-theme":true,"transition":true},"opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vignette":{"type":"number","default":["interpolate",["linear"],["zoom"],11,0,13,0.3],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vignette-color":{"type":"color","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"use-theme":true,"transition":true},"center-thinning":{"type":"number","default":0.4,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"direction":{"type":"array","default":[0,50],"minimum":0,"maximum":360,"length":2,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"flake-size":{"type":"number","default":0.71,"minimum":0,"maximum":5,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true}},"rain":{"density":{"type":"number","default":["interpolate",["linear"],["zoom"],11,0,13,0.5],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"intensity":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"color":{"type":"color","default":["interpolate",["linear"],["measure-light","brightness"],0,"#03113d",0.3,"#a8adbc"],"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"use-theme":true,"transition":true},"opacity":{"type":"number","default":["interpolate",["linear"],["measure-light","brightness"],0,0.88,1,0.7],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vignette":{"type":"number","default":["interpolate",["linear"],["zoom"],11,0,13,1],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vignette-color":{"type":"color","default":["interpolate",["linear"],["measure-light","brightness"],0,"#001736",0.3,"#464646"],"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"use-theme":true,"transition":true},"center-thinning":{"type":"number","default":0.57,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"direction":{"type":"array","default":[0,80],"minimum":0,"maximum":360,"length":2,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"droplet-size":{"type":"array","default":[2.6,18.2],"minimum":0,"maximum":50,"length":2,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"distortion-strength":{"type":"number","default":0.7,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true}},"camera":{"camera-projection":{"type":"enum","values":{"perspective":1,"orthographic":1},"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"default":"perspective"}},"colorTheme":{"data":{"type":"string","expression":{}}},"indoor":{"floorplanFeaturesetId":{"type":"string","expression":{}},"buildingFeaturesetId":{"type":"string","expression":{}}},"light":{"anchor":{"type":"enum","default":"viewport","values":{"map":1,"viewport":1},"expression":{"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"use-theme":true,"transition":true},"intensity":{"type":"number","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"projection":{"name":{"type":"enum","values":{"albers":1,"equalEarth":1,"equirectangular":1,"lambertConformalConic":1,"mercator":1,"naturalEarth":1,"winkelTripel":1,"globe":1},"default":"mercator"},"center":{"type":"array","length":2,"value":"number","minimum":[-180,-90],"maximum":[180,90]},"parallels":{"type":"array","length":2,"value":"number","minimum":[-90,-90],"maximum":[90,90]}},"terrain":{"source":{"type":"string"},"exaggeration":{"type":"number","default":1,"minimum":0,"maximum":1000,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"paint":["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_building","paint_symbol","paint_raster","paint_raster-particle","paint_hillshade","paint_background","paint_sky","paint_model"],"paint_fill":{"fill-antialias":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]}},"fill-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-outline-color":{"type":"color","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]}},"fill-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-pattern-cross-fade":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-z-offset":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-bridge-guard-rail-color":{"type":"color","default":"rgba(241, 236, 225, 255)","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light","feature"]},"property-type":"data-driven"},"fill-tunnel-structure-color":{"type":"color","default":"rgba(241, 236, 225, 255)","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light","feature"]},"property-type":"data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-extrusion-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]}},"fill-extrusion-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-extrusion-pattern-cross-fade":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-extrusion-height":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-height-alignment":{"type":"enum","values":{"terrain":1,"flat":1},"default":"flat"},"fill-extrusion-base-alignment":{"type":"enum","values":{"terrain":1,"flat":1},"default":"terrain"},"fill-extrusion-vertical-gradient":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]}},"fill-extrusion-ambient-occlusion-intensity":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-radius":{"type":"number","default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-wall-radius":{"type":"number","default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-ground-radius":{"type":"number","default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-ground-attenuation":{"type":"number","default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-flood-light-color":{"type":"color","default":"#ffffff","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-extrusion-flood-light-intensity":{"type":"number","default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-extrusion-flood-light-wall-radius":{"property-type":"data-driven","type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}},"fill-extrusion-flood-light-ground-radius":{"property-type":"data-driven","type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}},"fill-extrusion-flood-light-ground-attenuation":{"type":"number","default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-vertical-scale":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-rounded-roof":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]}},"fill-extrusion-cutoff-fade-range":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{}},"fill-extrusion-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light","feature-state"]},"property-type":"data-driven"},"fill-extrusion-line-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-extrusion-cast-shadows":{"type":"boolean","default":true}},"paint_building":{"building-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"building-ambient-occlusion-wall-intensity":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"building-ambient-occlusion-ground-intensity":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"building-ambient-occlusion-ground-radius":{"type":"number","default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"building-ambient-occlusion-ground-attenuation":{"type":"number","default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"building-vertical-scale":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"building-cast-shadows":{"type":"boolean","default":true},"building-color":{"type":"color","default":"rgba(193, 154, 127, 1)","use-theme":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]},"property-type":"data-driven"},"building-emissive-strength":{"type":"number","default":0,"minimum":0,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"property-type":"data-driven"}},"paint_line":{"line-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"line-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]}},"line-width":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light","line-progress"]},"property-type":"data-driven"},"line-gap-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-offset":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-dasharray":{"type":"array","value":"number","minimum":0,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-pattern-cross-fade":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"line-gradient":{"type":"color","use-theme":true,"expression":{"interpolated":true,"parameters":["line-progress"]}},"line-trim-offset":{"type":"array","value":"number","length":2,"default":[0,0],"minimum":[0,0],"maximum":[1,1]},"line-trim-fade-range":{"type":"array","value":"number","length":2,"default":[0,0],"minimum":[0,0],"maximum":[1,1],"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"line-trim-color":{"type":"color","default":"transparent","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"line-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"line-border-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-border-color":{"type":"color","default":"rgba(0, 0, 0, 0)","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-occlusion-opacity":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"paint_circle":{"circle-radius":{"type":"number","default":5,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-blur":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"circle-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]}},"circle-pitch-scale":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]}},"circle-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1},"default":"viewport","expression":{"parameters":["zoom"]}},"circle-stroke-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-stroke-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-stroke-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}}},"paint_heatmap":{"heatmap-radius":{"type":"number","default":30,"minimum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"heatmap-weight":{"type":"number","default":1,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"heatmap-intensity":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"heatmap-color":{"type":"color","default":["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",0.1,"royalblue",0.3,"cyan",0.5,"lime",0.7,"yellow",1,"red"],"use-theme":true,"expression":{"interpolated":true,"parameters":["heatmap-density"]}},"heatmap-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}}},"paint_symbol":{"icon-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-occlusion-opacity":{"type":"number","minimum":0,"maximum":1,"default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-emissive-strength":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light","feature-state"]},"property-type":"data-driven"},"text-emissive-strength":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light","feature-state"]},"property-type":"data-driven"},"icon-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"icon-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]}},"icon-image-cross-fade":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"text-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-occlusion-opacity":{"type":"number","minimum":0,"maximum":1,"default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"overridable":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"text-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]}},"icon-color-saturation":{"type":"number","default":0,"minimum":-1,"maximum":1,"expression":{}},"icon-color-contrast":{"type":"number","default":0,"minimum":-1,"maximum":1,"expression":{}},"icon-color-brightness-min":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{}},"icon-color-brightness-max":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{}},"symbol-z-offset":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"}},"paint_raster":{"raster-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-color":{"type":"color","use-theme":true,"expression":{"interpolated":true,"parameters":["raster-value"]}},"raster-color-mix":{"type":"array","default":[0.2126,0.7152,0.0722,0],"length":4,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-color-range":{"type":"array","length":2,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-hue-rotate":{"type":"number","default":0,"period":360,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-brightness-min":{"type":"number","default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-brightness-max":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-saturation":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-contrast":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-resampling":{"type":"enum","values":{"linear":1,"nearest":1},"default":"linear","expression":{"parameters":["zoom"]}},"raster-fade-duration":{"type":"number","default":300,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"raster-array-band":{"type":"string"},"raster-elevation":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}}},"paint_raster-particle":{"raster-particle-array-band":{"type":"string"},"raster-particle-count":{"type":"number","default":512,"minimum":1},"raster-particle-color":{"type":"color","use-theme":true,"expression":{"interpolated":true,"parameters":["raster-particle-speed"]}},"raster-particle-max-speed":{"type":"number","default":1,"minimum":1},"raster-particle-speed-factor":{"type":"number","default":0.2,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-particle-fade-opacity-factor":{"type":"number","default":0.98,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-particle-reset-rate-factor":{"type":"number","default":0.8,"minimum":0,"maximum":1},"raster-particle-elevation":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}}},"paint_hillshade":{"hillshade-illumination-direction":{"type":"number","default":335,"minimum":0,"maximum":359,"expression":{"interpolated":true,"parameters":["zoom"]}},"hillshade-illumination-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"viewport","expression":{"parameters":["zoom"]}},"hillshade-exaggeration":{"type":"number","default":0.5,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"hillshade-shadow-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"hillshade-highlight-color":{"type":"color","default":"#FFFFFF","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"hillshade-accent-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"hillshade-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}}},"paint_background":{"background-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":[]}},"background-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"background-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom"]}},"background-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"background-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}}},"paint_sky":{"sky-type":{"type":"enum","values":{"gradient":1,"atmosphere":1},"default":"atmosphere","expression":{"parameters":["zoom"]}},"sky-atmosphere-sun":{"type":"array","value":"number","length":2,"minimum":[0,0],"maximum":[360,180],"expression":{"parameters":["zoom"]}},"sky-atmosphere-sun-intensity":{"type":"number","default":10,"minimum":0,"maximum":100},"sky-gradient-center":{"type":"array","value":"number","default":[0,0],"length":2,"minimum":[0,0],"maximum":[360,180],"expression":{"parameters":["zoom"]}},"sky-gradient-radius":{"type":"number","default":90,"minimum":0,"maximum":180,"expression":{"parameters":["zoom"]}},"sky-gradient":{"type":"color","default":["interpolate",["linear"],["sky-radial-progress"],0.8,"#87ceeb",1,"white"],"use-theme":true,"expression":{"interpolated":true,"parameters":["sky-radial-progress"]}},"sky-atmosphere-halo-color":{"type":"color","default":"white","use-theme":true},"sky-atmosphere-color":{"type":"color","default":"white","use-theme":true},"sky-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}}},"paint_model":{"model-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"property-type":"data-driven"},"model-rotation":{"type":"array","value":"number","length":3,"default":[0,0,0],"period":360,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-scale":{"type":"array","value":"number","length":3,"default":[1,1,1],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-translation":{"type":"array","value":"number","length":3,"default":[0,0,0],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-color":{"type":"color","default":"#ffffff","property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light","zoom"]},"use-theme":true,"transition":true},"model-color-mix-intensity":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-type":{"type":"enum","values":{"common-3d":1,"location-indicator":1},"default":"common-3d"},"model-cast-shadows":{"type":"boolean","default":true},"model-receive-shadows":{"type":"boolean","default":true},"model-ambient-occlusion-intensity":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"model-emissive-strength":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":5,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-roughness":{"type":"number","default":1,"minimum":0,"maximum":1,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state"]},"transition":true},"model-height-based-emissive-strength-multiplier":{"type":"array","default":[1,1,1,1,0],"length":5,"value":"number","property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-cutoff-fade-range":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{}},"model-front-cutoff":{"type":"array","value":"number","expression":{"interpolated":true,"parameters":["zoom"]},"length":3,"default":[0,0,1],"minimum":[0,0,0],"maximum":[1,1,1]}},"transition":{"duration":{"type":"number","default":300,"minimum":0},"delay":{"type":"number","default":0,"minimum":0}},"promoteId":{"*":{"type":"*"}}}');function To(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function Bo(t){if(Array.isArray(t))return t.map(Bo);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=Bo(t[r]);return e}return To(t)}function Vo(t){if(!0===t||!1===t)return !0;if(!Array.isArray(t)||0===t.length)return !1;switch(t[0]){case "has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case "in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case "!in":case "!has":case "none":return !1;case "==":case "!=":case ">":case ">=":case "<":case "<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case "any":case "all":for(const e of t.slice(1))if(!Vo(e)&&"boolean"!=typeof e)return !1;return !0;default:return !0}}function Co(t,e="",r=null,n="fill"){if(null==t)return {filter:()=>!0,needGeometry:!1,needFeature:!1};Vo(t)||(t=No(t));const i=t;let s=!0;try{s=function(t){if(!Lo(t))return t;let e=Bo(t);return Do(e),e=Fo(e),e}(i);}catch(t){console.warn(`Failed to extract static filter. Filter will continue working, but at higher memory usage and slower framerate.\nThis is most likely a bug, please report this via https://github.com/mapbox/mapbox-gl-js/issues/new?assignees=&labels=&template=Bug_report.md\nand paste the contents of this message in the report.\nThank you!\nFilter Expression:\n${JSON.stringify(i,null,2)}\n        `);}let o=null,a=null;if("background"!==n&&"sky"!==n&&"slot"!==n){a=Eo[`filter_${n}`];const t=Cs(s,a,e,r);if("error"===t.result)throw new Error(t.value.map((t=>`${t.key}: ${t.message}`)).join(", "));o=(e,r,n)=>t.value.evaluate(e,r,{},n);}let l=null,u=null;if(s!==i){const t=Cs(i,a,e,r);if("error"===t.result)throw new Error(t.value.map((t=>`${t.key}: ${t.message}`)).join(", "));l=(e,r,n,i,s)=>t.value.evaluate(e,r,{},n,void 0,void 0,i,s),u=!hi(t.value.expression);}return {filter:o,dynamicFilter:l||void 0,needGeometry:Uo(s),needFeature:!!u}}function Fo(t){if(!Array.isArray(t))return t;const e=function(t){if(Ro.has(t[0]))for(let e=1;e<t.length;e++)if(Lo(t[e]))return !0;return t}(t);return !0===e?e:e.map((t=>Fo(t)))}function Do(t){let e=!1;const r=[];if("case"===t[0]){for(let n=1;n<t.length-1;n+=2)e=e||Lo(t[n]),r.push(t[n+1]);r.push(t[t.length-1]);}else if("match"===t[0]){e=e||Lo(t[1]);for(let e=2;e<t.length-1;e+=2)r.push(t[e+1]);r.push(t[t.length-1]);}else if("step"===t[0]){e=e||Lo(t[1]);for(let e=1;e<t.length-1;e+=2)r.push(t[e+1]);}e&&(t.length=0,t.push("any",...r));for(let e=1;e<t.length;e++)Do(t[e]);}function Lo(t){if(!Array.isArray(t))return !1;if("pitch"===(e=t[0])||"distance-from-center"===e)return !0;var e;for(let e=1;e<t.length;e++)if(Lo(t[e]))return !0;return !1}const Ro=new Set(["in","==","!=",">",">=","<","<=","to-boolean"]);function Oo(t,e){return t<e?-1:t>e?1:0}function Uo(t){if(!Array.isArray(t))return !1;if("within"===t[0]||"distance"===t[0])return !0;for(let e=1;e<t.length;e++)if(Uo(t[e]))return !0;return !1}function No(t){if(!t)return !0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?jo(t[1],t[2],"=="):"!="===e?qo(jo(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?jo(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(No))):"all"===e?["all"].concat(t.slice(1).map(No)):"none"===e?["all"].concat(t.slice(1).map(No).map(qo)):"in"===e?$o(t[1],t.slice(2)):"!in"===e?qo($o(t[1],t.slice(2))):"has"===e?Go(t[1]):"!has"!==e||qo(Go(t[1]));var r;}function jo(t,e,r){switch(t){case "$type":return [`filter-type-${r}`,e];case "$id":return [`filter-id-${r}`,e];default:return [`filter-${r}`,t,e]}}function $o(t,e){if(0===e.length)return !1;switch(t){case "$type":return ["filter-type-in",["literal",e]];case "$id":return ["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(Oo)]]:["filter-in-small",t,["literal",e]]}}function Go(t){switch(t){case "$type":return !0;case "$id":return ["filter-has-id"];default:return ["filter-has",t]}}function qo(t){return ["!",t]}const Ho="";function Xo(t,e){return e?`${t}${Ho}${e}`:t}const Zo="-transition",Wo=new Set(["fill","line","background","hillshade","raster"]);class Yo extends tr{constructor(t,e,r,n,i){if(super(),this.id=t.id,this.fqid=Xo(this.id,r),this.type=t.type,this.scope=r,this.lut=n,this.options=i,this._featureFilter={filter:()=>!0,needGeometry:!1,needFeature:!1},this._filterCompiled=!1,this.configDependencies=new Set,"custom"!==t.type){if(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,t.type&&"background"!==t.type&&"sky"!==t.type&&"slot"!==t.type){this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter;const e=Cs(this.filter,Eo[`filter_${t.type}`]);"error"!==e.result&&(this.configDependencies=new Set([...this.configDependencies,...e.value.configDependencies]));}if(t.slot&&(this.slot=t.slot),e.layout&&(this._unevaluatedLayout=new Ao(e.layout,this.scope,i),this.configDependencies=new Set([...this.configDependencies,...this._unevaluatedLayout.configDependencies])),e.paint){this._transitionablePaint=new bo(e.paint,this.scope,i);for(const e in t.paint)this.setPaintProperty(e,t.paint[e]);for(const e in t.layout)this.setLayoutProperty(e,t.layout[e]);this.configDependencies=new Set([...this.configDependencies,...this._transitionablePaint.configDependencies]),this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new Io(e.paint);}}}onAdd(t){}onRemove(t){}isDraped(t){return !this.is3D(!0)&&Wo.has(this.type)}getLayoutProperty(t){return "visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}setLayoutProperty(t,e){if("custom"===this.type&&"visibility"===t)return void(this.visibility=e);const r=this._unevaluatedLayout;r._properties.properties[t]&&(r.setValue(t,e),this.configDependencies=new Set([...this.configDependencies,...r.configDependencies]),"visibility"===t&&this.possiblyEvaluateVisibility());}possiblyEvaluateVisibility(){this._unevaluatedLayout._values.visibility&&(this.visibility=this._unevaluatedLayout._values.visibility.possiblyEvaluate({zoom:0}));}getPaintProperty(t){return t.endsWith(Zo)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e){const r=this._transitionablePaint,n=r._properties.properties;if(t.endsWith(Zo)){const i=t.slice(0,-11);return n[i]&&r.setTransition(i,e||void 0),!1}if(!n[t])return !1;const i=r._values[t],s=i.value.isDataDriven(),o=i.value;r.setValue(t,e),this.configDependencies=new Set([...this.configDependencies,...r.configDependencies]),this._handleSpecialPaintPropertyUpdate(t);const a=r._values[t].value,l=a.isDataDriven(),u=t.endsWith("pattern")||"line-dasharray"===t;return l||s||u||this._handleOverridablePaintPropertyUpdate(t,o,a)}_handleSpecialPaintPropertyUpdate(t){}getProgramIds(){return null}getDefaultProgramParams(t,e,r){return null}_handleOverridablePaintPropertyUpdate(t,e,r){return !1}isHidden(t){return !!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e);}serialize(){return Ut({id:this.id,type:this.type,slot:this.slot,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()},((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}is3D(t){return !1}hasElevation(){return !1}isSky(){return !1}isTileClipped(){return !1}hasOffscreenPass(){return !1}hasShadowPass(){return !1}canCastShadows(){return !1}hasLightBeamPass(){return !1}cutoffRange(){return 0}tileCoverLift(){return 0}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof Mo&&bs(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return !0}return !1}compileFilter(t){this._filterCompiled||(this._featureFilter=Co(this.filter,this.scope,t),this._filterCompiled=!0);}invalidateCompiledFilter(){this._filterCompiled=!1;}dynamicFilter(){return this._featureFilter.dynamicFilter}dynamicFilterNeedsFeature(){return this._featureFilter.needFeature}getLayerRenderingStats(){return this._stats}resetLayerRenderingStats(t){this._stats&&("shadow"===t.renderPass?this._stats.numRenderedVerticesInShadowPass=0:this._stats.numRenderedVerticesInTransparentPass=0);}queryRadius(t){}queryIntersectsFeature(t,e,r,n,i,s,o,a,l){}}const Ko={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class Jo{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8;}}class Qo{constructor(){this.capacity=-1,this.resize(0);}static serialize(t,e){return t._trim(),e&&e.add(t.arrayBuffer),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews());}clear(){this.length=0;}resize(t){this.reserve(t),this.length=t;}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e);}}_refreshViews(){throw new Error("StructArray#_refreshViews() must be implemented by each concrete StructArray layout")}emplace(...t){throw new Error("StructArray#emplace() must be implemented by each concrete StructArray layout")}emplaceBack(...t){throw new Error("StructArray#emplaceBack() must be implemented by each concrete StructArray layout")}destroy(){this.int8=this.uint8=this.int16=this.uint16=this.int32=this.uint32=this.float32=null,this.arrayBuffer=null;}}function ta(t,e=1){let r=0,n=0;return {members:t.map((t=>{const i=Ko[t.type].BYTES_PER_ELEMENT,s=r=ea(r,Math.max(e,i)),o=t.components||1;return n=Math.max(n,i),r+=i*o,{name:t.name,type:t.type,components:o,offset:s}})),size:ea(r,Math.max(n,e)),alignment:e}}function ea(t,e){return Math.ceil(t/e)*e}class ra extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e,this.int16[n+1]=r,t}}ra.prototype.bytesPerElement=4,qs(ra,"StructArrayLayout2i4");class na extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}na.prototype.bytesPerElement=6,qs(na,"StructArrayLayout3i6");class ia extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,t}}ia.prototype.bytesPerElement=8,qs(ia,"StructArrayLayout4i8");class sa extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}sa.prototype.bytesPerElement=4,qs(sa,"StructArrayLayout1f4");class oa extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=4*t,s=2*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.float32[s+1]=n,t}}oa.prototype.bytesPerElement=8,qs(oa,"StructArrayLayout2i1f8");class aa extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=4*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}aa.prototype.bytesPerElement=8,qs(aa,"StructArrayLayout3i8");class la extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const o=5*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=s,t}}la.prototype.bytesPerElement=10,qs(la,"StructArrayLayout5i10");class ua extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s,o)}emplace(t,e,r,n,i,s,o,a){const l=6*t,u=12*t,c=3*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.uint8[u+4]=n,this.uint8[u+5]=i,this.uint8[u+6]=s,this.uint8[u+7]=o,this.float32[c+2]=a,t}}ua.prototype.bytesPerElement=12,qs(ua,"StructArrayLayout2i4ub1f12");class ca extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.float32[i+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}ca.prototype.bytesPerElement=12,qs(ca,"StructArrayLayout3f12");class ha extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const o=6*t,a=3*t;return this.uint16[o+0]=e,this.uint16[o+1]=r,this.uint16[o+2]=n,this.uint16[o+3]=i,this.float32[a+2]=s,t}}ha.prototype.bytesPerElement=12,qs(ha,"StructArrayLayout4ui1f12");class pa extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.uint16[s+0]=e,this.uint16[s+1]=r,this.uint16[s+2]=n,this.uint16[s+3]=i,t}}pa.prototype.bytesPerElement=8,qs(pa,"StructArrayLayout4ui8");class fa extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,o){const a=6*t;return this.int16[a+0]=e,this.int16[a+1]=r,this.int16[a+2]=n,this.int16[a+3]=i,this.int16[a+4]=s,this.int16[a+5]=o,t}}fa.prototype.bytesPerElement=12,qs(fa,"StructArrayLayout6i12");class da extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o,a,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,r,n,i,s,o,a,l,u,c,h)}emplace(t,e,r,n,i,s,o,a,l,u,c,h,p){const f=12*t;return this.int16[f+0]=e,this.int16[f+1]=r,this.int16[f+2]=n,this.int16[f+3]=i,this.uint16[f+4]=s,this.uint16[f+5]=o,this.uint16[f+6]=a,this.uint16[f+7]=l,this.int16[f+8]=u,this.int16[f+9]=c,this.int16[f+10]=h,this.int16[f+11]=p,t}}da.prototype.bytesPerElement=24,qs(da,"StructArrayLayout4i4ui4i24");class ma extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,o){const a=10*t,l=5*t;return this.int16[a+0]=e,this.int16[a+1]=r,this.int16[a+2]=n,this.float32[l+2]=i,this.float32[l+3]=s,this.float32[l+4]=o,t}}ma.prototype.bytesPerElement=20,qs(ma,"StructArrayLayout3i3f20");class ya extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,t}}ya.prototype.bytesPerElement=16,qs(ya,"StructArrayLayout4f16");class ga extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}ga.prototype.bytesPerElement=4,qs(ga,"StructArrayLayout1ul4");class xa extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,t}}xa.prototype.bytesPerElement=4,qs(xa,"StructArrayLayout2ui4");class va extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o,a,l,u,c,h,p){const f=this.length;return this.resize(f+1),this.emplace(f,t,e,r,n,i,s,o,a,l,u,c,h,p)}emplace(t,e,r,n,i,s,o,a,l,u,c,h,p,f){const d=20*t,m=10*t;return this.int16[d+0]=e,this.int16[d+1]=r,this.int16[d+2]=n,this.int16[d+3]=i,this.int16[d+4]=s,this.float32[m+3]=o,this.float32[m+4]=a,this.float32[m+5]=l,this.float32[m+6]=u,this.int16[d+14]=c,this.uint32[m+8]=h,this.uint16[d+18]=p,this.uint16[d+19]=f,t}}va.prototype.bytesPerElement=40,qs(va,"StructArrayLayout5i4f1i1ul2ui40");class ba extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s,o)}emplace(t,e,r,n,i,s,o,a){const l=8*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.int16[l+2]=n,this.int16[l+4]=i,this.int16[l+5]=s,this.int16[l+6]=o,this.int16[l+7]=a,t}}ba.prototype.bytesPerElement=16,qs(ba,"StructArrayLayout3i2i2i16");class wa extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const o=4*t,a=8*t;return this.float32[o+0]=e,this.float32[o+1]=r,this.float32[o+2]=n,this.int16[a+6]=i,this.int16[a+7]=s,t}}wa.prototype.bytesPerElement=16,qs(wa,"StructArrayLayout2f1f2i16");class _a extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,o){const a=20*t,l=5*t;return this.uint8[a+0]=e,this.uint8[a+1]=r,this.float32[l+1]=n,this.float32[l+2]=i,this.float32[l+3]=s,this.float32[l+4]=o,t}}_a.prototype.bytesPerElement=20,qs(_a,"StructArrayLayout2ub4f20");class Aa extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,this.uint16[i+2]=n,t}}Aa.prototype.bytesPerElement=6,qs(Aa,"StructArrayLayout3ui6");class Ma extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,m,y,g,x,v,b){const w=this.length;return this.resize(w+1),this.emplace(w,t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,m,y,g,x,v,b)}emplace(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,m,y,g,x,v,b,w){const _=30*t,A=15*t,M=60*t;return this.int16[_+0]=e,this.int16[_+1]=r,this.int16[_+2]=n,this.float32[A+2]=i,this.float32[A+3]=s,this.uint16[_+8]=o,this.uint16[_+9]=a,this.uint32[A+5]=l,this.uint32[A+6]=u,this.uint32[A+7]=c,this.uint16[_+16]=h,this.uint16[_+17]=p,this.uint16[_+18]=f,this.float32[A+10]=d,this.float32[A+11]=m,this.uint8[M+48]=y,this.uint8[M+49]=g,this.uint8[M+50]=x,this.uint32[A+13]=v,this.int16[_+28]=b,this.uint8[M+58]=w,t}}Ma.prototype.bytesPerElement=60,qs(Ma,"StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60");class Ia extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,m,y,g,x,v,b,w,_,A,M,I,S,z,k,P,E,T,B){const V=this.length;return this.resize(V+1),this.emplace(V,t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,m,y,g,x,v,b,w,_,A,M,I,S,z,k,P,E,T,B)}emplace(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,m,y,g,x,v,b,w,_,A,M,I,S,z,k,P,E,T,B,V){const C=20*t,F=40*t,D=80*t;return this.float32[C+0]=e,this.float32[C+1]=r,this.int16[F+4]=n,this.int16[F+5]=i,this.int16[F+6]=s,this.int16[F+7]=o,this.int16[F+8]=a,this.int16[F+9]=l,this.int16[F+10]=u,this.int16[F+11]=c,this.int16[F+12]=h,this.uint16[F+13]=p,this.uint16[F+14]=f,this.uint16[F+15]=d,this.uint16[F+16]=m,this.uint16[F+17]=y,this.uint16[F+18]=g,this.uint16[F+19]=x,this.uint16[F+20]=v,this.uint16[F+21]=b,this.uint16[F+22]=w,this.uint16[F+23]=_,this.uint16[F+24]=A,this.uint16[F+25]=M,this.uint16[F+26]=I,this.uint16[F+27]=S,this.uint32[C+14]=z,this.float32[C+15]=k,this.float32[C+16]=P,this.float32[C+17]=E,this.float32[C+18]=T,this.uint8[D+76]=B,this.uint16[F+39]=V,t}}Ia.prototype.bytesPerElement=80,qs(Ia,"StructArrayLayout2f9i15ui1ul4f1ub1ui80");class Sa extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,o){const a=6*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.float32[a+3]=i,this.float32[a+4]=s,this.float32[a+5]=o,t}}Sa.prototype.bytesPerElement=24,qs(Sa,"StructArrayLayout6f24");class za extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const o=5*t;return this.float32[o+0]=e,this.float32[o+1]=r,this.float32[o+2]=n,this.float32[o+3]=i,this.float32[o+4]=s,t}}za.prototype.bytesPerElement=20,qs(za,"StructArrayLayout5f20");class ka extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s,o)}emplace(t,e,r,n,i,s,o,a){const l=7*t;return this.float32[l+0]=e,this.float32[l+1]=r,this.float32[l+2]=n,this.float32[l+3]=i,this.float32[l+4]=s,this.float32[l+5]=o,this.float32[l+6]=a,t}}ka.prototype.bytesPerElement=28,qs(ka,"StructArrayLayout7f28");class Pa extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o,a,l,u,c){const h=this.length;return this.resize(h+1),this.emplace(h,t,e,r,n,i,s,o,a,l,u,c)}emplace(t,e,r,n,i,s,o,a,l,u,c,h){const p=11*t;return this.float32[p+0]=e,this.float32[p+1]=r,this.float32[p+2]=n,this.float32[p+3]=i,this.float32[p+4]=s,this.float32[p+5]=o,this.float32[p+6]=a,this.float32[p+7]=l,this.float32[p+8]=u,this.float32[p+9]=c,this.float32[p+10]=h,t}}Pa.prototype.bytesPerElement=44,qs(Pa,"StructArrayLayout11f44");class Ea extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o,a,l){const u=this.length;return this.resize(u+1),this.emplace(u,t,e,r,n,i,s,o,a,l)}emplace(t,e,r,n,i,s,o,a,l,u){const c=9*t;return this.float32[c+0]=e,this.float32[c+1]=r,this.float32[c+2]=n,this.float32[c+3]=i,this.float32[c+4]=s,this.float32[c+5]=o,this.float32[c+6]=a,this.float32[c+7]=l,this.float32[c+8]=u,t}}Ea.prototype.bytesPerElement=36,qs(Ea,"StructArrayLayout9f36");class Ta extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e,this.float32[n+1]=r,t}}Ta.prototype.bytesPerElement=8,qs(Ta,"StructArrayLayout2f8");class Ba extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=6*t;return this.uint32[3*t+0]=e,this.uint16[s+2]=r,this.uint16[s+3]=n,this.uint16[s+4]=i,t}}Ba.prototype.bytesPerElement=12,qs(Ba,"StructArrayLayout1ul3ui12");class Va extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}Va.prototype.bytesPerElement=2,qs(Va,"StructArrayLayout1ui2");class Ca extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,m){const y=this.length;return this.resize(y+1),this.emplace(y,t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,m)}emplace(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,m,y){const g=16*t;return this.float32[g+0]=e,this.float32[g+1]=r,this.float32[g+2]=n,this.float32[g+3]=i,this.float32[g+4]=s,this.float32[g+5]=o,this.float32[g+6]=a,this.float32[g+7]=l,this.float32[g+8]=u,this.float32[g+9]=c,this.float32[g+10]=h,this.float32[g+11]=p,this.float32[g+12]=f,this.float32[g+13]=d,this.float32[g+14]=m,this.float32[g+15]=y,t}}Ca.prototype.bytesPerElement=64,qs(Ca,"StructArrayLayout16f64");class Fa extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s,o)}emplace(t,e,r,n,i,s,o,a){const l=10*t,u=5*t;return this.uint16[l+0]=e,this.uint16[l+1]=r,this.uint16[l+2]=n,this.uint16[l+3]=i,this.float32[u+2]=s,this.float32[u+3]=o,this.float32[u+4]=a,t}}Fa.prototype.bytesPerElement=20,qs(Fa,"StructArrayLayout4ui3f20");class Da extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.int16[1*t+0]=e,t}}Da.prototype.bytesPerElement=2,qs(Da,"StructArrayLayout1i2");class La extends Qo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint8[1*t+0]=e,t}}La.prototype.bytesPerElement=1,qs(La,"StructArrayLayout1ub1");class Ra extends Jo{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.int16[this._pos2+3]}get tileAnchorY(){return this._structArray.int16[this._pos2+4]}get x1(){return this._structArray.float32[this._pos4+3]}get y1(){return this._structArray.float32[this._pos4+4]}get x2(){return this._structArray.float32[this._pos4+5]}get y2(){return this._structArray.float32[this._pos4+6]}get padding(){return this._structArray.int16[this._pos2+14]}get featureIndex(){return this._structArray.uint32[this._pos4+8]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+18]}get bucketIndex(){return this._structArray.uint16[this._pos2+19]}}Ra.prototype.size=40;class Oa extends va{get(t){return new Ra(this,t)}}qs(Oa,"CollisionBoxArray");class Ua extends Jo{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.float32[this._pos4+2]}get tileAnchorY(){return this._structArray.float32[this._pos4+3]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+8]}get numGlyphs(){return this._structArray.uint16[this._pos2+9]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+5]}get lineStartIndex(){return this._structArray.uint32[this._pos4+6]}get lineLength(){return this._structArray.uint32[this._pos4+7]}get segment(){return this._structArray.uint16[this._pos2+16]}get lowerSize(){return this._structArray.uint16[this._pos2+17]}get upperSize(){return this._structArray.uint16[this._pos2+18]}get lineOffsetX(){return this._structArray.float32[this._pos4+10]}get lineOffsetY(){return this._structArray.float32[this._pos4+11]}get writingMode(){return this._structArray.uint8[this._pos1+48]}get placedOrientation(){return this._structArray.uint8[this._pos1+49]}set placedOrientation(t){this._structArray.uint8[this._pos1+49]=t;}get hidden(){return this._structArray.uint8[this._pos1+50]}set hidden(t){this._structArray.uint8[this._pos1+50]=t;}get crossTileID(){return this._structArray.uint32[this._pos4+13]}set crossTileID(t){this._structArray.uint32[this._pos4+13]=t;}get associatedIconIndex(){return this._structArray.int16[this._pos2+28]}get flipState(){return this._structArray.uint8[this._pos1+58]}set flipState(t){this._structArray.uint8[this._pos1+58]=t;}}Ua.prototype.size=60;class Na extends Ma{get(t){return new Ua(this,t)}}qs(Na,"PlacedSymbolArray");class ja extends Jo{get tileAnchorX(){return this._structArray.float32[this._pos4+0]}get tileAnchorY(){return this._structArray.float32[this._pos4+1]}get projectedAnchorX(){return this._structArray.int16[this._pos2+4]}get projectedAnchorY(){return this._structArray.int16[this._pos2+5]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+6]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+7]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+8]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+9]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+10]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+11]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+12]}get key(){return this._structArray.uint16[this._pos2+13]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+14]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+15]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+16]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+17]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+18]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+19]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+20]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+21]}get featureIndex(){return this._structArray.uint16[this._pos2+22]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+23]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+24]}get numIconVertices(){return this._structArray.uint16[this._pos2+25]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+26]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+27]}get crossTileID(){return this._structArray.uint32[this._pos4+14]}set crossTileID(t){this._structArray.uint32[this._pos4+14]=t;}get textOffset0(){return this._structArray.float32[this._pos4+15]}get textOffset1(){return this._structArray.float32[this._pos4+16]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+17]}get zOffset(){return this._structArray.float32[this._pos4+18]}set zOffset(t){this._structArray.float32[this._pos4+18]=t;}get hasIconTextFit(){return this._structArray.uint8[this._pos1+76]}get elevationFeatureIndex(){return this._structArray.uint16[this._pos2+39]}}ja.prototype.size=80;class $a extends Ia{get(t){return new ja(this,t)}}qs($a,"SymbolInstanceArray");class Ga extends sa{getoffsetX(t){return this.float32[1*t+0]}}qs(Ga,"GlyphOffsetArray");class qa extends ra{getx(t){return this.int16[2*t+0]}gety(t){return this.int16[2*t+1]}}qs(qa,"SymbolLineVertexArray");class Ha extends Jo{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}get layoutVertexArrayOffset(){return this._structArray.uint16[this._pos2+4]}}Ha.prototype.size=12;class Xa extends Ba{get(t){return new Ha(this,t)}}qs(Xa,"FeatureIndexArray");class Za extends xa{geta_centroid_pos0(t){return this.uint16[2*t+0]}geta_centroid_pos1(t){return this.uint16[2*t+1]}}qs(Za,"FillExtrusionCentroidArray");class Wa extends Jo{get a_join_normal_inside0(){return this._structArray.int16[this._pos2+0]}get a_join_normal_inside1(){return this._structArray.int16[this._pos2+1]}get a_join_normal_inside2(){return this._structArray.int16[this._pos2+2]}}Wa.prototype.size=6;class Ya extends na{get(t){return new Wa(this,t)}}qs(Ya,"FillExtrusionWallArray");const Ka=ta([{name:"a_pos",components:2,type:"Int16"}],4),Ja=ta([{name:"a_circle_z_offset",components:1,type:"Float32"}],4),Qa=ta([{name:"a_pos_3",components:3,type:"Int16"},{name:"a_pos_normal_3",components:3,type:"Int16"}]);class tl{constructor(t=[]){this.segments=t;}_prepareSegment(t,e,r,n){let i=this.segments[this.segments.length-1];return t>tl.MAX_VERTEX_ARRAY_LENGTH&&Gt(`Max vertices per segment is ${tl.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}`),(!i||i.vertexLength+t>tl.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n)&&(i={vertexOffset:e,primitiveOffset:r,vertexLength:0,primitiveLength:0},void 0!==n&&(i.sortKey=n),this.segments.push(i)),i}prepareSegment(t,e,r,n){return this._prepareSegment(t,e.length,r.length,n)}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy();}static simpleSegment(t,e,r,n){return new tl([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}function el(t,e){return 256*(t=Et(Math.floor(t),0,255))+Et(Math.floor(e),0,255)}tl.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,qs(tl,"SegmentVector");const rl=ta([{name:"a_pattern",components:4,type:"Uint16"},{name:"a_pixel_ratio",components:1,type:"Float32"}]),nl=ta([{name:"a_pattern_b",components:4,type:"Uint16"}]),il=ta([{name:"a_dash",components:4,type:"Uint16"}]);class sl{constructor(){this.ids=[],this.uniqueIds=[],this.positions=[],this.indexed=!1;}add(t,e,r,n){this.ids.push(ol(t)),this.positions.push(e,r,n);}eachPosition(t,e){const r=ol(t);let n=0,i=this.ids.length-1;for(;n<i;){const t=n+i>>1;this.ids[t]>=r?i=t:n=t+1;}for(;this.ids[n]===r;)e(this.positions[3*n],this.positions[3*n+1],this.positions[3*n+2]),n++;}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return al(r,n,0,r.length-1),e&&(e.add(r.buffer),e.add(n.buffer)),{ids:r,positions:n}}static deserialize(t){const e=new sl;let r;e.ids=t.ids,e.positions=t.positions;for(const t of e.ids)t!==r&&e.uniqueIds.push(t),r=t;return e.indexed=!0,e}}function ol(t){const e=+t;return !isNaN(e)&&Number.MIN_SAFE_INTEGER<=e&&e<=Number.MAX_SAFE_INTEGER?e:We(String(t))}function al(t,e,r,n){for(;r<n;){const i=t[r+n>>1];let s=r-1,o=n+1;for(;;){do{s++;}while(t[s]<i);do{o--;}while(t[o]>i);if(s>=o)break;ll(t,s,o),ll(e,3*s,3*o),ll(e,3*s+1,3*o+1),ll(e,3*s+2,3*o+2);}o-r<n-o?(al(t,e,r,o),r=o+1):(al(t,e,o+1,n),n=o);}}function ll(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}qs(sl,"FeaturePositionMap");class ul{constructor(t){this.gl=t.gl,this.initialized=!1;}fetchUniformLocation(t,e){return this.location||this.initialized||(this.location=this.gl.getUniformLocation(t,e),this.initialized=!0),!!this.location}set(t,e,r){throw new Error("Uniform#set() must be implemented by each concrete Uniform")}}class cl extends ul{constructor(t){super(t),this.current=0;}set(t,e,r){this.fetchUniformLocation(t,e)&&this.current!==r&&(this.current=r,this.gl.uniform1i(this.location,r));}}class hl extends ul{constructor(t){super(t),this.current=0;}set(t,e,r){this.fetchUniformLocation(t,e)&&this.current!==r&&(this.current=r,this.gl.uniform1f(this.location,r));}}class pl extends ul{constructor(t){super(t),this.current=[0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]||(this.current=r,this.gl.uniform2f(this.location,r[0],r[1])));}}class fl extends ul{constructor(t){super(t),this.current=[0,0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]&&r[2]===this.current[2]||(this.current=r,this.gl.uniform3f(this.location,r[0],r[1],r[2])));}}class dl extends ul{constructor(t){super(t),this.current=[0,0,0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]&&r[2]===this.current[2]&&r[3]===this.current[3]||(this.current=r,this.gl.uniform4f(this.location,r[0],r[1],r[2],r[3])));}}class ml extends ul{constructor(t){super(t),this.current=sr.transparent.toPremultipliedRenderColor(null);}set(t,e,r){this.fetchUniformLocation(t,e)&&(r.r===this.current.r&&r.g===this.current.g&&r.b===this.current.b&&r.a===this.current.a||(this.current=r,this.gl.uniform4f(this.location,r.r,r.g,r.b,r.a)));}}const yl=new Float32Array(16);class gl extends ul{constructor(t){super(t),this.current=yl;}set(t,e,r){if(this.fetchUniformLocation(t,e)){if(r[12]!==this.current[12]||r[0]!==this.current[0])return this.current=r,void this.gl.uniformMatrix4fv(this.location,!1,r);for(let t=1;t<16;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix4fv(this.location,!1,r);break}}}}const xl=new Float32Array(9),vl=new Float32Array(4);class bl extends ul{constructor(t){super(t),this.current=vl;}set(t,e,r){if(this.fetchUniformLocation(t,e))for(let t=0;t<4;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix2fv(this.location,!1,r);break}}}function wl(t){return [el(255*t.r,255*t.g),el(255*t.b,255*t.a)]}class _l{constructor(t,e,r,n){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=r,this.context=n;}setUniform(t,e,r,n,i){const s=n.constantOr(this.value);e.set(t,i,s instanceof sr?s.toPremultipliedRenderColor(this.lutExpression&&"none"===this.lutExpression.value?null:this.context.lut):s);}getBinding(t,e){return "color"===this.type?new ml(t):new hl(t)}}class Al{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.pattern=null,this.patternTransition=null,this.pixelRatio=1;}setConstantPatternPositions(t,e){this.pixelRatio=t.pixelRatio||1,this.pattern=t.tl.concat(t.br),this.patternTransition=e?e.tl.concat(e.br):this.pattern;}setUniform(t,e,r,n,i){let s=null;"u_pattern"!==i&&"u_dash"!==i||(s=this.pattern),"u_pattern_b"===i&&(s=this.patternTransition),"u_pixel_ratio"===i&&(s=this.pixelRatio),s&&e.set(t,i,s);}getBinding(t,e){return "u_pattern"===e||"u_pattern_b"===e||"u_dash"===e?new dl(t):new hl(t)}}class Ml{constructor(t,e,r,n){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n;}populatePaintArray(t,e,r,n,i,s,o,a){const l=this.paintVertexArray.length,u="composite"===this.expression.kind||"source"===this.expression.kind?this.expression.evaluate(new go(0,{brightness:s,worldview:a}),e,{},i,n,o):"constant"===this.expression.kind&&this.expression.value,c=!!this.lutExpression&&"none"===("composite"===this.lutExpression.kind||"source"===this.lutExpression.kind?this.lutExpression.evaluate(new go(0,{brightness:s,worldview:a}),e,{},i,n,o):this.lutExpression.value);this.paintVertexArray.resize(t),this._setPaintValue(l,t,u,c?null:this.context.lut);}updatePaintArray(t,e,r,n,i,s,o,a){const l="composite"===this.expression.kind||"source"===this.expression.kind?this.expression.evaluate({zoom:0,brightness:o,worldview:a},r,n,void 0,i):"constant"===this.expression.kind&&this.expression.value,u=!!this.lutExpression&&"none"===("composite"===this.lutExpression.kind||"source"===this.lutExpression.kind?this.lutExpression.evaluate(new go(0,{brightness:o,worldview:a}),r,n,void 0,i):this.lutExpression.value);this._setPaintValue(t,e,l,u?null:this.context.lut);}_setPaintValue(t,e,r,n){if("color"===this.type){const i=wl(r.toPremultipliedRenderColor(n));for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1]);}else {for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.lutExpression&&"constant"!==this.lutExpression.kind&&(this.lutExpression.isStateDependent||!this.lutExpression.isLightConstant)||"constant"!==this.expression.kind&&(this.expression.isStateDependent||!this.expression.isLightConstant)));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class Il{constructor(t,e,r,n,i,s){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=r,this.useIntegerZoom=n,this.context=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new s;}populatePaintArray(t,e,r,n,i,s,o,a){const l=this.expression.evaluate(new go(this.context.zoom,{brightness:s,worldview:a}),e,{},i,n,o),u=this.expression.evaluate(new go(this.context.zoom+1,{brightness:s,worldview:a}),e,{},i,n,o),c=!!this.lutExpression&&"none"===("composite"===this.lutExpression.kind||"source"===this.lutExpression.kind?this.lutExpression.evaluate(new go(0,{brightness:s,worldview:a}),e,{},i,n,o):this.lutExpression.value),h=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(h,t,l,u,c?null:this.context.lut);}updatePaintArray(t,e,r,n,i,s,o,a){const l=this.expression.evaluate({zoom:this.context.zoom,brightness:o,worldview:a},r,n,void 0,i),u=this.expression.evaluate({zoom:this.context.zoom+1,brightness:o,worldview:a},r,n,void 0,i),c=!!this.lutExpression&&"none"===("composite"===this.lutExpression.kind||"source"===this.lutExpression.kind?this.lutExpression.evaluate(new go(0,{brightness:o,worldview:a}),r,n,void 0,i):this.lutExpression.value);this._setPaintValue(t,e,l,u,c?null:this.context.lut);}_setPaintValue(t,e,r,n,i){if("color"===this.type){const n=wl(r.toPremultipliedRenderColor(i)),s=wl(r.toPremultipliedRenderColor(i));for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1],s[0],s[1]);}else {for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent||!this.expression.isLightConstant));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(t,e,r,n,i){const s=this.useIntegerZoom?Math.floor(r.zoom):r.zoom,o=Et(this.expression.interpolationFactor(s,this.context.zoom,this.context.zoom+1),0,1);e.set(t,i,o);}getBinding(t,e){return new hl(t)}}class Sl{constructor(t,e,r,n,i){this.expression=t,this.layerId=i,this.paintVertexAttributes=("array"===r?il:rl).members;for(let t=0;t<e.length;++t);this.paintVertexArray=new n,this.paintTransitionVertexArray=new pa;}populatePaintArray(t,e,r,n){const i=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValues(i,t,e.patterns&&e.patterns[this.layerId],r);}updatePaintArray(t,e,r,n,i,s,o){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],s);}_setPaintValues(t,e,r,n){if(!n||!r)return;const i=n[r[0]],s=n[r[1]];if(i){if(i){const{tl:r,br:n,pixelRatio:s}=i;for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r[0],r[1],n[0],n[1],s);}if(s){this.paintTransitionVertexArray.resize(this.paintVertexArray.length);const{tl:r,br:n}=s;for(let i=t;i<e;i++)this.paintTransitionVertexArray.emplace(i,r[0],r[1],n[0],n[1]);}}}upload(t){const e=this.expression.isStateDependent||!this.expression.isLightConstant;this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,e)),this.paintTransitionVertexArray&&this.paintTransitionVertexArray.length&&(this.paintTransitionVertexBuffer=t.createVertexBuffer(this.paintTransitionVertexArray,nl.members,e));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy(),this.paintTransitionVertexBuffer&&this.paintTransitionVertexBuffer.destroy();}}class zl{constructor(t,e,r=(()=>!0)){this.binders={},this._buffers=[],this.context=e;const n=[];for(const i in t.paint._values){const s=t.paint.get(i);if(i.endsWith("-use-theme"))continue;if(!r(i))continue;if(!(s instanceof Mo&&bs(s.property.specification)))continue;const o=El(i,t.type),a=s.value,l=s.property.specification.type,u=!!s.property.useIntegerZoom,c="line-dasharray"===i||i.endsWith("pattern"),h=t.paint.get(`${i}-use-theme`),p="line-dasharray"===i&&"constant"!==t.layout.get("line-cap").value.kind||h&&"constant"!==h.value.kind;if("constant"!==a.kind||p)if("source"===a.kind||p||c){const e=Vl(i,l,"source");this.binders[i]=c?new Sl(a,o,l,e,t.id):new Ml(a,o,l,e),n.push(`/a_${i}`);}else {const t=Vl(i,l,"composite");this.binders[i]=new Il(a,o,l,u,e,t),n.push(`/z_${i}`);}else this.binders[i]=c?new Al(a.value,o):new _l(a.value,o,l,e),n.push(`/u_${i}`);h&&(this.binders[i].lutExpression=h.value);}this.cacheKey=n.sort().join("");}getMaxValue(t){const e=this.binders[t];return e instanceof Ml||e instanceof Il?e.maxValue:0}populatePaintArrays(t,e,r,n,i,s,o,a){for(const l in this.binders){const u=this.binders[l];u.context=this.context,(u instanceof Ml||u instanceof Il||u instanceof Sl)&&u.populatePaintArray(t,e,r,n,i,s,o,a);}}setConstantPatternPositions(t,e){for(const r in this.binders){const n=this.binders[r];n instanceof Al&&n.setConstantPatternPositions(t,e);}}getPatternTransitionVertexBuffer(t){const e=this.binders[t];return e instanceof Sl?e.paintTransitionVertexBuffer:null}updatePaintArrays(t,e,r,n,i,s,o,a,l,u){let c=!1;const h=Object.keys(t),p=0!==h.length&&!a,f=p?h:e.uniqueIds;this.context.lut=i.lut;for(const a in this.binders){const h=this.binders[a];if(h.context=this.context,(h instanceof Ml||h instanceof Il||h instanceof Sl)&&h.expression&&h.expression.kind&&"constant"!==h.expression.kind&&(!0===h.expression.isStateDependent||!1===h.expression.isLightConstant)){const d=i.paint.get(a);h.expression=d.value;for(const r of f){const i=t[r.toString()];e.eachPosition(r,((t,e,r)=>{const a=n.feature(t);h.updatePaintArray(e,r,a,i,s,o,l,u);}));}if(!p)for(const e of r.uniqueIds){const i=t[e.toString()];r.eachPosition(e,((t,e,r)=>{const a=n.feature(t);h.updatePaintArray(e,r,a,i,s,o,l,u);}));}c=!0;}}return c}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof _l||r instanceof Al)&&t.push(...r.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)));}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Ml||r instanceof Il||r instanceof Sl)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);if(r instanceof Sl)for(let e=0;e<nl.members.length;e++)t.push(nl.members[e].name);}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof _l||r instanceof Al||r instanceof Il)for(const e of r.uniformNames)t.push(e);}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t){const e=[];for(const r in this.binders){const n=this.binders[r];if(n instanceof _l||n instanceof Al||n instanceof Il)for(const i of n.uniformNames)e.push({name:i,property:r,binding:n.getBinding(t,i)});}return e}setUniforms(t,e,r,n,i){for(const{name:e,property:s,binding:o}of r)this.binders[s].setUniform(t,o,i,n.get(s),e);}updatePaintBuffers(){this._buffers=[];for(const t in this.binders){const e=this.binders[t];(e instanceof Ml||e instanceof Il||e instanceof Sl)&&e.paintVertexBuffer&&this._buffers.push(e.paintVertexBuffer),e instanceof Sl&&e.paintTransitionVertexBuffer&&this._buffers.push(e.paintTransitionVertexBuffer);}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof Ml||r instanceof Il||r instanceof Sl)&&r.upload(t);}this.updatePaintBuffers();}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof Ml||e instanceof Il||e instanceof Sl)&&e.destroy();}}}class kl{constructor(t,e,r=(()=>!0)){this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new zl(n,e,r);this.needsUpload=!1,this._featureMap=new sl,this._featureMapWithoutIds=new sl,this._bufferOffset=0,this._idlessCounter=0;}populatePaintArrays(t,e,r,n,i,s,o,a,l){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n,i,s,o,a,l);void 0!==e.id?this._featureMap.add(e.id,r,this._bufferOffset,t):(this._featureMapWithoutIds.add(this._idlessCounter,r,this._bufferOffset,t),this._idlessCounter+=1),this._bufferOffset=t,this.needsUpload=!0;}updatePaintArrays(t,e,r,n,i,s,o,a){for(const l of r)this.needsUpload=this.programConfigurations[l.id].updatePaintArrays(t,this._featureMap,this._featureMapWithoutIds,e,l,n,i,s,o||0,a)||this.needsUpload;}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1;}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy();}}const Pl={"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-occlusion-opacity":["occlusion_opacity"],"icon-occlusion-opacity":["occlusion_opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-emissive-strength":["emissive_strength"],"icon-emissive-strength":["emissive_strength"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"symbol-z-offset":["z_offset"],"line-gap-width":["gapwidth"],"line-pattern":["pattern","pixel_ratio","pattern_b"],"fill-pattern":["pattern","pixel_ratio","pattern_b"],"fill-extrusion-pattern":["pattern","pixel_ratio","pattern_b"],"line-dasharray":["dash"],"fill-bridge-guard-rail-color":["structure_color"],"fill-tunnel-structure-color":["structure_color"]};function El(t,e){return Pl[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}const Tl={"line-pattern":{source:ha,composite:ha},"fill-pattern":{source:ha,composite:ha},"fill-extrusion-pattern":{source:ha,composite:ha},"line-dasharray":{source:pa,composite:pa}},Bl={color:{source:Ta,composite:ya},number:{source:sa,composite:Ta}};function Vl(t,e,r){const n=Tl[t];return n&&n[r]||Bl[e][r]}qs(_l,"ConstantBinder"),qs(Al,"PatternConstantBinder"),qs(Ml,"SourceExpressionBinder"),qs(Sl,"PatternCompositeBinder"),qs(Il,"CompositeExpressionBinder"),qs(zl,"ProgramConfiguration",{omit:["_buffers"]}),qs(kl,"ProgramConfigurationSet");const Cl=Cn/Math.PI/2,Fl=5,Dl=6,Ll=16383,Rl=64,Ol=[Rl,32,16],Ul=-Cl,Nl=Cl;function jl(t,e,r,n=Cl){return r=Mt(r),[t*Math.sin(r)*n,-e*n,t*Math.cos(r)*n]}function $l(t,e,r){return jl(Math.cos(Mt(t)),Math.sin(Mt(t)),e,r)}const Gl=6371008.8,ql=2*Math.PI*Gl;class Hl{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new Hl(Bt(this.lng,-180,180),this.lat)}toArray(){return [this.lng,this.lat]}toString(){return `LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return Gl*Math.acos(Math.min(i,1))}toBounds(t=0){const e=360*t/40075017,r=e/Math.cos(Math.PI/180*this.lat);return new Xl({lng:this.lng-r,lat:this.lat-e},{lng:this.lng+r,lat:this.lat+e})}toEcef(t){return $l(this.lat,this.lng,Cl+t*Cl/Gl)}static convert(t){if(t instanceof Hl)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new Hl(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new Hl(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}class Xl{constructor(t,e){if(t)if(e)this.setSouthWest(t).setNorthEast(e);else if(4===t.length){const e=t;this.setSouthWest([e[0],e[1]]).setNorthEast([e[2],e[3]]);}else {const e=t;this.setSouthWest(e[0]).setNorthEast(e[1]);}}setNorthEast(t){return this._ne=t instanceof Hl?new Hl(t.lng,t.lat):Hl.convert(t),this}setSouthWest(t){return this._sw=t instanceof Hl?new Hl(t.lng,t.lat):Hl.convert(t),this}extend(t){const e=this._sw,r=this._ne;let n,i;if(t instanceof Hl)n=t,i=t;else {if(!(t instanceof Xl))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(Xl.convert(t)):this.extend(Hl.convert(t)):"object"==typeof t&&null!==t&&t.hasOwnProperty("lat")&&(t.hasOwnProperty("lon")||t.hasOwnProperty("lng"))?this.extend(Hl.convert(t)):this;if(n=t._sw,i=t._ne,!n||!i)return this}return e||r?(e.lng=Math.min(n.lng,e.lng),e.lat=Math.min(n.lat,e.lat),r.lng=Math.max(i.lng,r.lng),r.lat=Math.max(i.lat,r.lat)):(this._sw=new Hl(n.lng,n.lat),this._ne=new Hl(i.lng,i.lat)),this}getCenter(){return new Hl((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new Hl(this.getWest(),this.getNorth())}getSouthEast(){return new Hl(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return [this._sw.toArray(),this._ne.toArray()]}toString(){return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return !(this._sw&&this._ne)}contains(t){const{lng:e,lat:r}=Hl.convert(t);let n=this._sw.lng<=e&&e<=this._ne.lng;return this._sw.lng>this._ne.lng&&(n=this._sw.lng>=e&&e>=this._ne.lng),this._sw.lat<=r&&r<=this._ne.lat&&n}static convert(t){if(t)return t instanceof Xl?t:new Xl(t)}}const Zl=0,Wl=25.5;function Yl(t){return ql*Math.cos(t*Math.PI/180)}function Kl(t){return (180+t)/360}function Jl(t){return (180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function Ql(t,e){return t/Yl(e)}function tu(t){return 360*t-180}function eu(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function ru(t,e){return t*Yl(eu(e))}const nu=85.051129;function iu(t){return Math.cos(Mt(Et(t,-85.051129,nu)))}function su(t,e){const r=Et(e,Zl,Wl),n=Math.pow(2,r);return iu(t)*ql/(512*n)}function ou(t){return 1/Math.cos(t*Math.PI/180)}function au(t,e=0){const r=Math.exp(Math.PI*(1-(t.y+e/Cn)/(1<<t.z)*2));return 80150034*r/(r*r+1)/Cn/(1<<t.z)}class lu{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r;}static fromLngLat(t,e=0){const r=Hl.convert(t);return new lu(Kl(r.lng),Jl(r.lat),Ql(e,r.lat))}toLngLat(){return new Hl(tu(this.x),eu(this.y))}toAltitude(){return ru(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/ql*ou(eu(this.y))}}function uu(t,e,r,n,i,s,o,a,l){const u=(e+n)/2,c=(r+i)/2,h=new bt(u,c);a(h),function(t,e,r,n,i,s){const o=r-i,a=n-s;return Math.abs((n-e)*o-(r-t)*a)/Math.hypot(o,a)}(h.x,h.y,s.x,s.y,o.x,o.y)>=l?(uu(t,e,r,u,c,s,h,a,l),uu(t,u,c,n,i,h,o,a,l)):t.push(o);}function cu(t,e,r){let n=t[0],i=n.x,s=n.y;e(n);const o=[n];for(let a=1;a<t.length;a++){const l=t[a],{x:u,y:c}=l;e(l),uu(o,i,s,u,c,n,l,e,r),i=u,s=c,n=l;}return o}function hu(t,e,r,n){if(n(e,r)){const i=e.add(r)._mult(.5);hu(t,e,i,n),hu(t,i,r,n);}else t.push(r);}function pu(t,e){let r=t[0];const n=[r];for(let i=1;i<t.length;i++){const s=t[i];hu(n,r,s,e),r=s;}return n}const fu=Math.pow(2,14)-1,du=-fu-1;function mu(t,e){const r=Math.round(t.x*e),n=Math.round(t.y*e);return t.x=Et(r,du,fu),t.y=Et(n,du,fu),(r<t.x||r>t.x+1||n<t.y||n>t.y+1)&&Gt("Geometry exceeds allowed extent, reduce your vector tile buffer size"),t}function yu(t,e,r){const n=t.loadGeometry(),i=t.extent,s=Cn/i;if(e&&r&&r.projection.isReprojectedInTileSpace){const s=1<<e.z,{scale:o,x:a,y:l,projection:u}=r,c=t=>{const r=tu((e.x+t.x/i)/s),n=eu((e.y+t.y/i)/s),c=u.project(r,n);t.x=(c.x*o-a)*i,t.y=(c.y*o-l)*i;};for(let e=0;e<n.length;e++)if(1!==t.type)n[e]=cu(n[e],c,1);else {const t=[];for(const r of n[e])r.x<0||r.x>=i||r.y<0||r.y>=i||(c(r),t.push(r));n[e]=t;}}for(const t of n)for(const e of t)mu(e,s);return n}function gu(t,e){return {type:t.type,id:t.id,properties:t.properties,geometry:e?yu(t):[]}}var xu,vu,bu,wu,_u,Au,Mu,Iu={};function Su(){if(vu)return xu;vu=1;var t=vt();function e(t,e,n,i,s){this.properties={},this.extent=n,this.type=0,this._pbf=t,this._geometry=-1,this._keys=i,this._values=s,t.readFields(r,this,e);}function r(t,e,r){1==t?e.id=r.readVarint():2==t?function(t,e){for(var r=t.readVarint()+t.pos;t.pos<r;){var n=e._keys[t.readVarint()],i=e._values[t.readVarint()];e.properties[n]=i;}}(r,e):3==t?e.type=r.readVarint():4==t&&(e._geometry=r.pos);}function n(t){for(var e,r,n=0,i=0,s=t.length,o=s-1;i<s;o=i++)n+=((r=t[o]).x-(e=t[i]).x)*(e.y+r.y);return n}return xu=e,e.types=["Unknown","Point","LineString","Polygon"],e.prototype.loadGeometry=function(){var e=this._pbf;e.pos=this._geometry;for(var r,n=e.readVarint()+e.pos,i=1,s=0,o=0,a=0,l=[];e.pos<n;){if(s<=0){var u=e.readVarint();i=7&u,s=u>>3;}if(s--,1===i||2===i)o+=e.readSVarint(),a+=e.readSVarint(),1===i&&(r&&l.push(r),r=[]),r.push(new t(o,a));else {if(7!==i)throw new Error("unknown command "+i);r&&r.push(r[0].clone());}}return r&&l.push(r),l},e.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,r=1,n=0,i=0,s=0,o=1/0,a=-1/0,l=1/0,u=-1/0;t.pos<e;){if(n<=0){var c=t.readVarint();r=7&c,n=c>>3;}if(n--,1===r||2===r)(i+=t.readSVarint())<o&&(o=i),i>a&&(a=i),(s+=t.readSVarint())<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error("unknown command "+r)}return [o,l,a,u]},e.prototype.toGeoJSON=function(t,r,i){var s,o,a=this.extent*Math.pow(2,i),l=this.extent*t,u=this.extent*r,c=this.loadGeometry(),h=e.types[this.type];function p(t){for(var e=0;e<t.length;e++){var r=t[e];t[e]=[360*(r.x+l)/a-180,360/Math.PI*Math.atan(Math.exp((180-360*(r.y+u)/a)*Math.PI/180))-90];}}switch(this.type){case 1:var f=[];for(s=0;s<c.length;s++)f[s]=c[s][0];p(c=f);break;case 2:for(s=0;s<c.length;s++)p(c[s]);break;case 3:for(c=function(t){var e=t.length;if(e<=1)return [t];for(var r,i,s=[],o=0;o<e;o++){var a=n(t[o]);0!==a&&(void 0===i&&(i=a<0),i===a<0?(r&&s.push(r),r=[t[o]]):r.push(t[o]));}return r&&s.push(r),s}(c),s=0;s<c.length;s++)for(o=0;o<c[s].length;o++)p(c[s][o]);}1===c.length?c=c[0]:h="Multi"+h;var d={type:"Feature",geometry:{type:h,coordinates:c},properties:this.properties};return "id"in this&&(d.id=this.id),d},xu}function zu(){if(wu)return bu;wu=1;var t=Su();function e(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(r,this,e),this.length=this._features.length;}function r(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){for(var e=null,r=t.readVarint()+t.pos;t.pos<r;){var n=t.readVarint()>>3;e=1===n?t.readString():2===n?t.readFloat():3===n?t.readDouble():4===n?t.readVarint64():5===n?t.readVarint():6===n?t.readSVarint():7===n?t.readBoolean():null;}return e}(r));}return bu=e,e.prototype.feature=function(e){if(e<0||e>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[e];var r=this._pbf.readVarint()+this._pbf.pos;return new t(this._pbf,r,this.extent,this._keys,this._values)},bu}function ku(){return Mu||(Mu=1,Iu.VectorTile=function(){if(Au)return _u;Au=1;var t=zu();function e(e,r,n){if(3===e){var i=new t(n,n.readVarint()+n.pos);i.length&&(r[i.name]=i);}}return _u=function(t,r){this.layers=t.readFields(e,{},r);},_u}(),Iu.VectorTileFeature=Su(),Iu.VectorTileLayer=zu()),Iu}var Pu=ku();const Eu="3d_elevation_id",Tu="level";class Bu{constructor(){this._valid=!1;}reset(t){return this.feature=t,this._valid=!0,this._geometry=t.loadGeometry(),0!==this._geometry.length&&0!==this._geometry[0].length||(this._valid=!1),this}geometry(t,e){return this._valid&&t(e(this._geometry)),this}require(t,e,r){return this.get(t,!0,e,r)}optional(t,e,r){return this.get(t,!1,e,r)}success(){return this._valid}get(t,e,r,n){const i=this.feature.properties.hasOwnProperty(t)?+this.feature.properties[t]:void 0;return this._valid&&void 0!==i&&!Number.isNaN(i)?r(n?n(i):i):e&&(this._valid=!1),this}}class Vu{constructor(t,e){this.featureFunc=t,this.vertexFunc=e;}parseFeature(t,e,r){return this.featureFunc(t,e,r)}parseVertex(t,e,r){return this.vertexFunc(t,e,r)}}const Cu=new Vu(((t,e,r)=>t.reset(e).require(Eu,(t=>{r.id=t;})).optional("fixed_height_relative",(t=>{r.constantHeight=t;}),Du.decodeRelativeHeight).geometry((t=>{r.bounds=t;}),pn).success()),((t,e,r)=>t.reset(e).require(Eu,(t=>{r.id=t;})).require("elevation_idx",(t=>{r.idx=t;})).require("extent",(t=>{r.extent=t;})).require("height_relative",(t=>{r.height=t;}),Du.decodeRelativeHeight).geometry((t=>{r.position=t;}),Du.getPoint).success())),Fu=new Vu(((t,e,r)=>t.reset(e).require(Eu,(t=>{r.id=t;})).optional("fixed_height",(t=>{r.constantHeight=t;}),Du.decodeMetricHeight).geometry((t=>{r.bounds=t;}),pn).success()),((t,e,r)=>t.reset(e).require(Eu,(t=>{r.id=t;})).require("elevation_idx",(t=>{r.idx=t;})).require("extent",(t=>{r.extent=t;})).require("height",(t=>{r.height=t;}),Du.decodeMetricHeight).geometry((t=>{r.position=t;}),Du.getPoint).success()));class Du{static getPoint(t){return at(t[0][0].x,t[0][0].y)}static decodeRelativeHeight(t){return 1e-4*t*5}static decodeMetricHeight(t){return 1e-4*t}static parse(t){const e=[],r=[],n=t.length,i=new Bu;for(let o=0;o<n;o++){const n=t.feature(o),a=n.properties.hasOwnProperty("version")?String(n.properties.version):void 0,l=(s=a)?"1.0.1"===s?Fu:void 0:Cu;if(void 0===l){Gt(`Unknown elevation feature version number ${a||"(unknown)"}`);continue}const u=n.properties.hasOwnProperty("type")?n.properties.type:void 0;if(u)if("Point"===Pu.VectorTileFeature.types[n.type]&&"curve_point"===u){const t={};l.parseVertex(i,n,t)&&e.push(t);}else if("Polygon"===Pu.VectorTileFeature.types[n.type]&&"curve_meta"===u){const t={};l.parseFeature(i,n,t)&&r.push(t);}}var s;return {vertices:e,features:r}}}class Lu{constructor(t,e){this.pos=t,this.dir=e;}intersectsPlane(t,e,r){const n=ft(e,this.dir);if(Math.abs(n)<1e-6)return !1;const i=((t[0]-this.pos[0])*e[0]+(t[1]-this.pos[1])*e[1])/n;return r[0]=this.pos[0]+this.dir[0]*i,r[1]=this.pos[1]+this.dir[1]*i,!0}}class Ru{constructor(t,e){this.pos=t,this.dir=e;}intersectsPlane(t,e,r){const n=F(e,this.dir);if(Math.abs(n)<1e-6)return !1;const i=((t[0]-this.pos[0])*e[0]+(t[1]-this.pos[1])*e[1]+(t[2]-this.pos[2])*e[2])/n;return r[0]=this.pos[0]+this.dir[0]*i,r[1]=this.pos[1]+this.dir[1]*i,r[2]=this.pos[2]+this.dir[2]*i,!0}closestPointOnSphere(t,r,n){if(function(t,r){var n=t[0],i=t[1],s=t[2],o=r[0],a=r[1],l=r[2];return Math.abs(n-o)<=e*Math.max(1,Math.abs(n),Math.abs(o))&&Math.abs(i-a)<=e*Math.max(1,Math.abs(i),Math.abs(a))&&Math.abs(s-l)<=e*Math.max(1,Math.abs(s),Math.abs(l))}(this.pos,t)||0===r)return n[0]=n[1]=n[2]=0,!1;const[i,s,o]=this.dir,a=this.pos[0]-t[0],l=this.pos[1]-t[1],u=this.pos[2]-t[2],c=i*i+s*s+o*o,h=2*(a*i+l*s+u*o),p=h*h-4*c*(a*a+l*l+u*u-r*r);if(p<0){const t=Math.max(-h/2,0),e=a+i*t,c=l+s*t,p=u+o*t,f=Math.hypot(e,c,p);return n[0]=e*r/f,n[1]=c*r/f,n[2]=p*r/f,!1}{const t=(-h-Math.sqrt(p))/(2*c);if(t<0){const t=Math.hypot(a,l,u);return n[0]=a*r/t,n[1]=l*r/t,n[2]=u*r/t,!1}return n[0]=a+i*t,n[1]=l+s*t,n[2]=u+o*t,!0}}}class Ou{constructor(t,e,r,n,i){this.TL=t,this.TR=e,this.BR=r,this.BL=n,this.horizon=i;}static fromInvProjectionMatrix(t,e,r){const n=[-1,1,1],i=[1,1,1],s=[1,-1,1],o=[-1,-1,1],a=R(n,n,t),l=R(i,i,t),u=R(s,s,t),c=R(o,o,t);return new Ou(a,l,u,c,e/r)}}function Uu(t,e,r){let n=1/0,i=-1/0;const s=[];for(const o of t){j(s,o,e);const t=F(s,r);n=Math.min(n,t),i=Math.max(i,t);}return [n,i]}function Nu(t,e){let r=!0;for(let n=0;n<t.planes.length;n++){const i=t.planes[n];let s=0;for(let t=0;t<e.length;t++)s+=F(i,e[t])+i[3]>=0;if(0===s)return 0;s!==e.length&&(r=!1);}return r?2:1}function ju(t,e){for(const r of t.projections){const n=Uu(e,t.points[0],r.axis);if(r.projection[1]<n[0]||r.projection[0]>n[1])return 0}return 1}function $u(t,e){let r=0;const n=[0,0,0,0];for(let o=0;o<t.length;o++)n[0]=t[o][0],n[1]=t[o][1],n[2]=t[o][2],n[3]=1,(i=n)[0]*(s=e)[0]+i[1]*s[1]+i[2]*s[2]+i[3]*s[3]>=0&&r++;var i,s;return r}class Gu{constructor(t,e){this.points=t||new Array(8).fill([0,0,0]),this.planes=e||new Array(6).fill([0,0,0,0]),this.bounds=qu.fromPoints(this.points),this.projections=[],this.frustumEdges=[j([],this.points[2],this.points[3]),j([],this.points[0],this.points[3]),j([],this.points[4],this.points[0]),j([],this.points[5],this.points[1]),j([],this.points[6],this.points[2]),j([],this.points[7],this.points[3])];for(const t of this.frustumEdges){const e=[0,-t[2],t[1]],r=[t[2],0,-t[0]];this.projections.push({axis:e,projection:Uu(this.points,this.points[0],e)}),this.projections.push({axis:r,projection:Uu(this.points,this.points[0],r)});}}static fromInvProjectionMatrix(t,e,r,n){const i=Math.pow(2,r),s=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((r=>{const s=Z([],r,t),o=1/s[3]/e*i;return (a=s)[0]=(l=s)[0]*(u=[o,o,n?1/s[3]:o,o])[0],a[1]=l[1]*u[1],a[2]=l[2]*u[2],a[3]=l[3]*u[3],a;var a,l,u;})),o=[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]].map((t=>{const e=C([],D([],j([],s[t[0]],s[t[1]]),j([],s[t[2]],s[t[1]]))),r=-F(e,s[t[1]]);return e.concat(r)})),a=[];for(let t=0;t<s.length;t++)a.push([s[t][0],s[t][1],s[t][2]]);return new Gu(a,o)}intersectsPrecise(t,e,r){for(let r=0;r<e.length;r++)if(!$u(t,e[r]))return 0;for(let e=0;e<this.planes.length;e++)if(!$u(t,this.planes[e]))return 0;for(const e of r)for(const r of this.frustumEdges){const n=D([],e,r),i=_(n);if(0===i)continue;P(n,n,1/i);const s=Uu(this.points,this.points[0],n),o=Uu(t,this.points[0],n);if(s[0]>o[1]||o[0]>s[1])return 0}return 1}containsPoint(t){for(const e of this.planes){const r=e[3];if(F([e[0],e[1],e[2]],t)+r<0)return !1}return !0}}class qu{static fromPoints(t){const e=[1/0,1/0,1/0],r=[-1/0,-1/0,-1/0];for(const n of t)z(e,e,n),k(r,r,n);return new qu(e,r)}static fromTileIdAndHeight(t,e,r){const n=1<<t.canonical.z,i=t.canonical.x,s=t.canonical.y;return new qu([i/n,s/n,e],[(i+1)/n,(s+1)/n,r])}static applyTransform(t,e){const r=t.getCorners();for(let t=0;t<r.length;++t)R(r[t],r[t],e);return qu.fromPoints(r)}static applyTransformFast(t,e){const r=[e[12],e[13],e[14]],n=[...r];for(let i=0;i<3;i++)for(let s=0;s<3;s++){const o=e[4*s+i],a=o*t.min[s],l=o*t.max[s];r[i]+=Math.min(a,l),n[i]+=Math.max(a,l);}return new qu(r,n)}static projectAabbCorners(t,e){const r=t.getCorners();for(let t=0;t<r.length;++t)R(r[t],r[t],e);return r}constructor(t,e){this.min=t,this.max=e,this.center=P([],M([],this.min,this.max),.5);}quadrant(t){const e=[t%2==0,t<2],r=w(this.min),n=w(this.max);for(let t=0;t<e.length;t++)r[t]=e[t]?this.min[t]:this.center[t],n[t]=e[t]?this.center[t]:this.max[t];return n[2]=this.max[2],new qu(r,n)}distanceX(t){return Math.max(Math.min(this.max[0],t[0]),this.min[0])-t[0]}distanceY(t){return Math.max(Math.min(this.max[1],t[1]),this.min[1])-t[1]}distanceZ(t){return Math.max(Math.min(this.max[2],t[2]),this.min[2])-t[2]}getCorners(){const t=this.min,e=this.max;return [[t[0],t[1],t[2]],[e[0],t[1],t[2]],[e[0],e[1],t[2]],[t[0],e[1],t[2]],[t[0],t[1],e[2]],[e[0],t[1],e[2]],[e[0],e[1],e[2]],[t[0],e[1],e[2]]]}intersects(t){return this.intersectsAabb(t.bounds)?Nu(t,this.getCorners()):0}intersectsFlat(t){return this.intersectsAabb(t.bounds)?Nu(t,[[this.min[0],this.min[1],0],[this.max[0],this.min[1],0],[this.max[0],this.max[1],0],[this.min[0],this.max[1],0]]):0}intersectsPrecise(t,e){return e||this.intersects(t)?ju(t,this.getCorners()):0}intersectsPreciseFlat(t,e){return e||this.intersectsFlat(t)?ju(t,[[this.min[0],this.min[1],0],[this.max[0],this.min[1],0],[this.max[0],this.max[1],0],[this.min[0],this.max[1],0]]):0}intersectsAabb(t){for(let e=0;e<3;++e)if(this.min[e]>t.max[e]||t.min[e]>this.max[e])return !1;return !0}intersectsAabbXY(t){return !(this.min[0]>t.max[0]||t.min[0]>this.max[0]||this.min[1]>t.max[1]||t.min[1]>this.max[1])}encapsulate(t){for(let e=0;e<3;e++)this.min[e]=Math.min(this.min[e],t.min[e]),this.max[e]=Math.max(this.max[e],t.max[e]);}encapsulatePoint(t){for(let e=0;e<3;e++)this.min[e]=Math.min(this.min[e],t[e]),this.max[e]=Math.max(this.max[e],t[e]);}closestPoint(t){return [Math.max(Math.min(this.max[0],t[0]),this.min[0]),Math.max(Math.min(this.max[1],t[1]),this.min[1]),Math.max(Math.min(this.max[2],t[2]),this.min[2])]}}qs(qu,"Aabb");class Hu{constructor(t,e){this.feature=t,this.metersToTile=e,this.index=0;}get(){const t=this.feature.vertices[this.index],e=this.feature.vertexProps[this.index].dir,r=e[1],n=-e[0],i=(t.extent+1)*this.metersToTile;return [new bt(Math.trunc(t.position[0]+r*i),Math.trunc(t.position[1]+n*i)),new bt(Math.trunc(t.position[0]-r*i),Math.trunc(t.position[1]-n*i))]}next(){this.index++;}valid(){return this.index<this.feature.vertices.length}}class Xu{constructor(t,e,r,n,i,s){if(this.vertices=new Array,this.vertexProps=new Array,this.edges=new Array,this.edgeProps=new Array,this.id=t,this.heightRange={min:r,max:r},this.safeArea=e,this.constantHeight=r,null==this.constantHeight&&(null!=this.constantHeight||0!==n.length)){this.vertices=n,this.edges=i,this.edges=this.edges.filter((t=>{return t.a<this.vertices.length&&t.b<this.vertices.length&&!((e=this.vertices[t.a].position)[0]===(r=this.vertices[t.b].position)[0]&&e[1]===r[1]);var e,r;})),this.heightRange={min:Number.POSITIVE_INFINITY,max:Number.NEGATIVE_INFINITY};for(const t of this.vertices)this.vertexProps.push({dir:at(0,0)}),this.heightRange.min=Math.min(this.heightRange.min,t.height),this.heightRange.max=Math.max(this.heightRange.max,t.height);for(const t of this.edges){const e=this.vertices[t.a].position,r=this.vertices[t.b].position,n=ut(ot(),r,e),i=ht(n),s=ct(ot(),n,1/i);this.edgeProps.push({vec:n,dir:s,len:i});const o=this.vertexProps[t.a].dir,a=this.vertexProps[t.b].dir;lt(o,o,s),lt(a,a,s);}for(const t of this.vertexProps)0===t.dir[0]&&0===t.dir[1]||pt(t.dir,t.dir);this.tessellate(s);}}pointElevation(t){if(null!=this.constantHeight)return this.constantHeight;const e=this.getClosestEdge(t);if(null==e)return 0;const[r,n]=e;return ur(this.vertices[this.edges[r].a].height,this.vertices[this.edges[r].b].height,n)}computeSlopeNormal(t,e){const r=this.getClosestEdge(t);if(!r)return A(0,0,1);const n=r[0],i=this.edges[n],s=this.edgeProps[n].vec,o=A(s[0],s[1],(this.vertices[i.b].height-this.vertices[i.a].height)*e),a=A(o[1],-o[0],0);D(a,a,o);const l=_(a);return l>0?P(a,a,1/l):A(0,0,1)}getSafeArea(){return this.safeArea}isTunnel(){return this.heightRange.max<=-5}getClosestEdge(t){if(0===this.edges.length)return;let e=0,r=Number.POSITIVE_INFINITY,n=0;const i=at(t.x,t.y);for(let t=0;t<this.edges.length;t++){const s=this.edges[t],o=this.edgeProps[t].dir,a=new Lu(i,this.edgeProps[t].dir),l=this.vertices[s.a].position,u=this.vertices[s.b].position,c=ot(),h=ot(),p=a.intersectsPlane(l,this.vertexProps[s.a].dir,c),f=a.intersectsPlane(u,this.vertexProps[s.b].dir,h);if(!p||!f)continue;const d=ut(ot(),h,c),m=ut(ot(),i,c),y=ft(d,d),g=y>0?ft(m,d)/y:0,x=Et(g,0,1),v=Math.abs((g-x)*this.edgeProps[t].len),b=ut(ot(),i,l),w=v+Math.abs(ft(b,at(o[1],-o[0])));w<r&&(e=t,r=w,n=x);}return [e,n]}tessellate(t){for(let e=this.edges.length-1;e>=0;--e){const r=this.edges[e].a,n=this.edges[e].b,{position:i,height:s,extent:o}=this.vertices[r],{position:a,height:l,extent:u}=this.vertices[n],c=this.vertexProps[r].dir,h=this.vertexProps[n].dir,p=A(i[0]/t,i[1]/t,s),f=A(a[0]/t,a[1]/t,l),d=A(c[1],-c[0],0);P(d,d,o);const m=A(h[1],-h[0],0);if(P(m,m,u),this.distSqLines(A(p[0]+.5*d[0],p[1]+.5*d[1],p[2]+.5*d[2]),A(f[0]-.5*m[0],f[1]-.5*m[1],f[2]-.5*m[2]),A(p[0]-.5*d[0],p[1]-.5*d[1],p[2]-.5*d[2]),A(f[0]+.5*m[0],f[1]+.5*m[1],f[2]+.5*m[2]))<=.0025000000000000005)continue;const y=this.vertices.length,g=lt(ot(),i,a);this.vertices.push({position:ct(g,g,.5),height:.5*(s+l),extent:.5*(o+u)});const x=lt(ot(),c,h);this.vertexProps.push({dir:pt(x,x)}),this.edges.splice(e,1),this.edgeProps.splice(e,1),this.edges.push({a:r,b:y}),this.edges.push({a:y,b:n});const v=ut(ot(),this.vertices[y].position,i),b=ht(v),w={vec:v,dir:ct(ot(),v,1/b),len:b};this.edgeProps.push(w),this.edgeProps.push(w);}}distSqLines(t,e,r,n){const i=I(b(),e,t),s=I(b(),n,r),o=I(b(),t,r),a=F(i,i),l=F(i,s),u=F(i,o),c=F(s,s),h=F(s,o),p=a*c-l*l;if(0===p){const e=F(o,s)/F(s,s);return T(L(b(),r,n,e),t)}const f=(l*h-u*c)/p,d=(a*h-l*u)/p;return T(L(b(),t,e,f),L(b(),r,n,d))}}class Zu{static parseFrom(t,e){const r=Du.parse(t);if(!r)return [];let{vertices:n,features:i}=r;const s=1/au(e);i.sort(((t,e)=>t.id-e.id)),n.sort(((t,e)=>t.id-e.id||t.idx-e.idx)),n=n.filter(((t,e,r)=>e===r.findIndex((e=>e.id===t.id&&e.idx===t.idx))));const o=new Array;let a=0;const l=n.length;for(const t of i){if(t.constantHeight){o.push(new Xu(t.id,t.bounds,t.constantHeight));continue}for(;a!==l&&n[a].id<t.id;)a++;if(a===l||n[a].id!==t.id)continue;const e=new Array,r=new Array,i=a;for(;a!==l&&n[a].id===t.id;){const t=n[a];if(e.push({position:t.position,height:t.height,extent:t.extent}),a!==i&&n[a-1].idx===t.idx-1){const t=a-i;r.push({a:t-1,b:t});}a++;}o.push(new Xu(t.id,t.bounds,void 0,e,r,s));}return o}static getElevationFeature(t,e){if(!e)return;const r=+t.properties[Eu];return Number.isNaN(r)?void 0:e.find((t=>t.id===r))}}class Wu{constructor(t,e){this.zScale=1,this.xOffset=0,this.yOffset=0,t.equals(e)||(this.zScale=Math.pow(2,e.z-t.z),this.xOffset=(t.x*this.zScale-e.x)*Cn,this.yOffset=(t.y*this.zScale-e.y)*Cn);}constantElevation(t,e){if(null!=t.constantHeight)return this.computeBiasedHeight(t.constantHeight,e)}pointElevation(t,e,r){const n=this.constantElevation(e,r);return null!=n?n:(t.x=t.x*this.zScale+this.xOffset,t.y=t.y*this.zScale+this.yOffset,this.computeBiasedHeight(e.pointElevation(t),r))}computeBiasedHeight(t,e){return e<=0?t:t+e*Tt(0,e,t>=0?t:Math.abs(.5*t))}}qs(Xu,"ElevationFeature");class Yu{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.projection=t.projection,this.layoutVertexArray=new ra,this.indexArray=new Aa,this.segments=new tl,this.programConfigurations=new kl(t.layers,{zoom:t.zoom,lut:t.lut}),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.elevationMode=this.layers[0].layout.get("circle-elevation-reference"),this.hasElevation=!1,"none"!==this.elevationMode&&(this.elevatedLayoutVertexArray=new sa),this.worldview=t.worldview;}updateFootprints(t,e){}populate(t,e,r,n){const i=this.layers[0],s=[];let o=null;"circle"===i.type&&(o=i.layout.get("circle-sort-key"));for(const{feature:e,id:i,index:a,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=gu(e,t);if(!this.layers[0]._featureFilter.filter(new go(this.zoom,{worldview:this.worldview}),u,r))continue;const c=o?o.evaluate(u,{},r):void 0,h={id:i,properties:e.properties,type:e.type,sourceLayerIndex:l,index:a,geometry:t?u.geometry:yu(e,r,n),patterns:{},sortKey:c};s.push(h);}o&&s.sort(((t,e)=>t.sortKey-e.sortKey));let a=null;"globe"===n.projection.name&&(this.globeExtVertexArray=new fa,a=n.projection);for(const n of s){const{geometry:i,index:s,sourceLayerIndex:o}=n,l=t[s].feature;this.addFeature(n,i,s,e.availableImages,r,a,e.brightness,e.elevationFeatures),e.featureIndex.insert(l,i,s,o,this.index);}this.hasElevation||(this.elevatedLayoutVertexArray=void 0);}update(t,e,r,n,i,s,o){this.programConfigurations.updatePaintArrays(t,e,i,r,n,s,o,this.worldview);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Ka.members),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.globeExtVertexArray&&(this.globeExtVertexBuffer=t.createVertexBuffer(this.globeExtVertexArray,Qa.members)),this.elevatedLayoutVertexArray&&(this.elevatedLayoutVertexBuffer=t.createVertexBuffer(this.elevatedLayoutVertexArray,Ja.members))),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.globeExtVertexBuffer&&this.globeExtVertexBuffer.destroy(),this.elevatedLayoutVertexBuffer&&this.elevatedLayoutVertexBuffer.destroy());}addFeature(t,e,r,n,i,s,o,a){let l;"none"!==this.elevationMode&&(l=Zu.getElevationFeature(t,a));for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=Cn||n<0||n>=Cn)continue;if(s){const t=s.projectTilePoint(r,n,i),e=s.upVector(i,r,n);this.addGlobeExtVertex(t,e),this.addGlobeExtVertex(t,e),this.addGlobeExtVertex(t,e),this.addGlobeExtVertex(t,e);}const o=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray,t.sortKey),a=o.vertexLength;if(this.addCircleVertex(r,n,-1,-1),this.addCircleVertex(r,n,1,-1),this.addCircleVertex(r,n,1,1),this.addCircleVertex(r,n,-1,1),"none"!==this.elevationMode){const t=l?l.pointElevation(new bt(r,n)):0;this.hasElevation=this.hasElevation||0!==t;for(let e=0;e<4;e++)this.elevatedLayoutVertexArray.emplaceBack(t);}this.indexArray.emplaceBack(a,a+1,a+2),this.indexArray.emplaceBack(a,a+2,a+3),o.vertexLength+=4,o.primitiveLength+=2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{},n,i,o,void 0,this.worldview);}addCircleVertex(t,e,r,n){this.layoutVertexArray.emplaceBack(2*t+(r+1)/2,2*e+(n+1)/2);}addGlobeExtVertex(t,e){const r=16384;this.globeExtVertexArray.emplaceBack(t.x,t.y,t.z,e[0]*r,e[1]*r,e[2]*r);}}function Ku(t,e){for(let r=0;r<t.length;r++)if(lc(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(lc(t,e[r]))return !0;return !!ec(t,e)}function Ju(t,e,r){return !!lc(t,e)||!!sc(e,t,r)}function Qu(t,e){if(1===t.length)return ac(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(lc(t,n[e]))return !0}for(let r=0;r<t.length;r++)if(ac(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(ec(t,e[r]))return !0;return !1}function tc(t,e,r){if(t.length>1){if(ec(t,e))return !0;for(let n=0;n<e.length;n++)if(sc(e[n],t,r))return !0}for(let n=0;n<t.length;n++)if(sc(t[n],e,r))return !0;return !1}function ec(t,e){if(0===t.length||0===e.length)return !1;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)if(rc(n,i,e[t],e[t+1]))return !0}return !1}function rc(t,e,r,n){return qt(t,r,n)!==qt(e,r,n)&&qt(t,e,r)!==qt(t,e,n)}function nc(t,e,r){return (t.x-r.x)*(e.y-r.y)-(t.y-r.y)*(e.x-r.x)}function ic(t,e,r,n){const i=nc(t,e,n),s=nc(t,e,r);if(Math.sign(i)===Math.sign(s))return;const o=nc(r,n,t),a=o+s-i;return Math.sign(o)!==Math.sign(a)?[o/(o-a),s/(s-i)]:void 0}function sc(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if(oc(t,e[r-1],e[r])<n)return !0;return !1}function oc(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const i=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(i<0?e:i>1?r:r.sub(e)._mult(i)._add(e))}function ac(t,e){let r,n,i,s=!1;for(let o=0;o<t.length;o++){r=t[o];for(let t=0,o=r.length-1;t<r.length;o=t++)n=r[t],i=r[o],n.y>e.y!=i.y>e.y&&e.x<(i.x-n.x)*(e.y-n.y)/(i.y-n.y)+n.x&&(s=!s);}return s}function lc(t,e){let r=!1;for(let n=0,i=t.length-1;n<t.length;i=n++){const s=t[n],o=t[i];s.y>e.y!=o.y>e.y&&e.x<(o.x-s.x)*(e.y-s.y)/(o.y-s.y)+s.x&&(r=!r);}return r}function uc(t,e,r,n,i){for(const s of t)if(e<=s.x&&r<=s.y&&n>=s.x&&i>=s.y)return !0;const s=[new bt(e,r),new bt(e,i),new bt(n,i),new bt(n,r)];if(t.length>2)for(const e of s)if(lc(t,e))return !0;for(let e=0;e<t.length-1;e++)if(cc(t[e],t[e+1],s))return !0;return !1}function cc(t,e,r){const n=r[0],i=r[2];if(t.x<n.x&&e.x<n.x||t.x>i.x&&e.x>i.x||t.y<n.y&&e.y<n.y||t.y>i.y&&e.y>i.y)return !1;const s=qt(t,e,r[0]);return s!==qt(t,e,r[1])||s!==qt(t,e,r[2])||s!==qt(t,e,r[3])}function hc(t,e,r,n,i,s){let o=e.y-t.y,a=t.x-e.x;if(s=s||0){const t=o*o+a*a;if(0===t)return !0;const e=Math.sqrt(t);o/=e,a/=e;}return !((r.x-t.x)*o+(r.y-t.y)*a-s<0||(n.x-t.x)*o+(n.y-t.y)*a-s<0||(i.x-t.x)*o+(i.y-t.y)*a-s<0)}function pc(t,e,r,n,i,s,o){return !(hc(t,e,n,i,s,o)||hc(e,r,n,i,s,o)||hc(r,t,n,i,s,o)||hc(n,i,t,e,r,o)||hc(i,s,t,e,r,o)||hc(s,n,t,e,r,o))}function fc(t,e,r){const n=e.paint.get(t).value;return "constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t)}function dc(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function mc(t,e,r,n,i){if(!e[0]&&!e[1])return t;const s=bt.convert(e)._mult(i);"viewport"===r&&s._rotate(-n);const o=[];for(let e=0;e<t.length;e++)o.push(t[e].sub(s));return o}function yc(t,e,r,n){const i=bt.convert(t)._mult(n);return "viewport"===e&&i._rotate(-r),i}let gc,xc;function vc(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return [t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2]}qs(Yu,"CircleBucket",{omit:["layers"]});class bc{constructor(t,e,r){this.z=t,this.x=e,this.y=r,this.key=Ac(0,t,t,e,r);}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e){const r=function(t,e,r){var n=vc(256*t,256*(e=Math.pow(2,r)-e-1),r),i=vc(256*(t+1),256*(e+1),r);return n[0]+","+n[1]+","+i[0]+","+i[1]}(this.x,this.y,this.z),n=function(t,e,r){let n,i="";for(let s=t;s>0;s--)n=1<<s-1,i+=(e&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace("{prefix}",(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===e?Math.pow(2,this.z)-this.y-1:this.y)).replace("{quadkey}",n).replace("{bbox-epsg-3857}",r)}toString(){return `${this.z}/${this.x}/${this.y}`}}class wc{constructor(t,e){this.wrap=t,this.canonical=e,this.key=Ac(t,e.z,e.z,e.x,e.y);}}class _c{constructor(t,e,r,n,i){this.overscaledZ=t,this.wrap=e,this.canonical=new bc(r,+n,+i),this.key=0===e&&t===r?this.canonical.key:Ac(e,t,r,n,i);}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){const e=this.canonical.z-t;return t>this.canonical.z?new _c(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new _c(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e=!0){if(this.overscaledZ===t&&e)return this.key;if(t>this.canonical.z)return Ac(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y);{const r=this.canonical.z-t;return Ac(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}}isChildOf(t){if(t.wrap!==this.wrap)return !1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.z<this.canonical.z&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return [new _c(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return [new _c(e,this.wrap,e,r,n),new _c(e,this.wrap,e,r+1,n),new _c(e,this.wrap,e,r,n+1),new _c(e,this.wrap,e,r+1,n+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new _c(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new _c(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new wc(this.wrap,this.canonical)}toString(){return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}}function Ac(t,e,r,n,i){const s=1<<Math.min(r,22);let o=s*(i%s)+n%s;return t&&r<22&&(o+=s*s*((t<0?-2*t-1:2*t)%(1<<2*(22-r)))),16*(32*o+r)+(e-r)}const Mc=[t=>{let e=t.canonical.x-1,r=t.wrap;return e<0&&(e=(1<<t.canonical.z)-1,r--),new _c(t.overscaledZ,r,t.canonical.z,e,t.canonical.y)},t=>{let e=t.canonical.x+1,r=t.wrap;return e===1<<t.canonical.z&&(e=0,r++),new _c(t.overscaledZ,r,t.canonical.z,e,t.canonical.y)},t=>new _c(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,(0===t.canonical.y?1<<t.canonical.z:t.canonical.y)-1),t=>new _c(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y===(1<<t.canonical.z)-1?0:t.canonical.y+1)];qs(bc,"CanonicalTileID"),qs(_c,"OverscaledTileID",{omit:["projMatrix","expandedProjMatrix"]});const Ic=ta([{type:"Float32",name:"a_globe_pos",components:3},{type:"Float32",name:"a_uv",components:2}]),{members:Sc}=Ic,zc=ta([{name:"a_pos_3",components:3,type:"Int16"}]);var kc=ta([{name:"a_pos",type:"Int16",components:2}]);function Pc(t){return t*Cl/Gl}const Ec=[new qu([Ul,Ul,Ul],[Nl,Nl,Nl]),new qu([Ul,Ul,Ul],[0,0,Nl]),new qu([0,Ul,Ul],[Nl,0,Nl]),new qu([Ul,0,Ul],[0,Nl,Nl]),new qu([0,0,Ul],[Nl,Nl,Nl])];function Tc(t,e,r,n=!0){const i=P([],t._camera.position,t.worldSize),s=[e,r,1,1];Z(s,s,t.pixelMatrixInverse),H(s,s,1/s[3]);const o=C([],j([],s,i)),a=t.globeMatrix,l=[a[12],a[13],a[14]],u=j([],l,i),c=_(u),h=C([],u),p=t.worldSize/(2*Math.PI),f=F(h,o),d=Math.asin(p/c);if(d<Math.acos(f)){if(!n)return null;const t=[],e=[];P(t,o,c/f),C(e,j(e,t,u)),C(o,M(o,u,P(o,e,Math.tan(d)*c)));}const m=[];new Ru(i,o).closestPointOnSphere(l,p,m);const y=C([],Kt(a,0)),g=C([],Kt(a,1)),x=C([],Kt(a,2)),v=F(y,m),b=F(g,m),w=F(x,m),A=It(Math.asin(-b/p));let I=It(Math.atan2(v,w));I=t.center.lng+function(t,e){const r=(e-t+180)%360-180;return r<-180?r+360:r}(t.center.lng,I);const S=Kl(I),z=Et(Jl(A),0,1);return new lu(S,z)}class Bc{constructor(t,e,r){this.a=j([],t,r),this.b=j([],e,r),this.center=r;const n=C([],this.a),i=C([],this.b);this.angle=Math.acos(F(n,i));}}function Vc(t,e){if(0===t.angle)return null;let r;return r=0===t.a[e]?1/t.angle*.5*Math.PI:1/t.angle*Math.atan(t.b[e]/t.a[e]/Math.sin(t.angle)-1/Math.tan(t.angle)),r<0||r>1?null:function(t,e,r,n){const i=Math.sin(r);return t*(Math.sin((1-n)*r)/i)+e*(Math.sin(n*r)/i)}(t.a[e],t.b[e],t.angle,Et(r,0,1))+t.center[e]}function Cc(t){if(t.z<=1)return Ec[t.z+2*t.y+t.x];const e=Oc(Rc(t));return qu.fromPoints(e)}function Fc(t,e,r){return P(t,t,1-r),E(t,t,e,r)}function Dc(t,e,r){for(const n of t)R(n,n,e),P(n,n,r);}function Lc(t,e,r,n){const i=e/t.worldSize,s=t.globeMatrix;if(r.z<=1){const t=Cc(r).getCorners();return Dc(t,s,i),qu.fromPoints(t)}const o=Rc(r,n),a=Oc(o,Cl+Pc(t._tileCoverLift));Dc(a,s,i);const l=Number.MAX_VALUE,u=[-l,-l,-l],c=[l,l,l];if(o.contains(t.center)){for(const t of a)z(c,c,t),k(u,u,t);u[2]=0;const e=t.point,r=[e.x*i,e.y*i,0];return z(c,c,r),k(u,u,r),new qu(c,u)}if(t._tileCoverLift>0){for(const t of a)z(c,c,t),k(u,u,t);return new qu(c,u)}const h=[s[12]*i,s[13]*i,s[14]*i],p=o.getCenter(),f=Et(t.center.lat,-85.051129,nu),d=Et(p.lat,-85.051129,nu),m=Kl(t.center.lng),y=Jl(f);let g=m-Kl(p.lng);const x=y-Jl(d);g>.5?g-=1:g<-.5&&(g+=1);let v=0;Math.abs(g)>Math.abs(x)?v=g>=0?1:3:(v=x>=0?0:2,E(h,h,[s[4]*i,s[5]*i,s[6]*i],-Math.sin(Mt(x>=0?o.getSouth():o.getNorth()))*Cl));const b=a[v],w=a[(v+1)%4],_=new Bc(b,w,h),A=[Vc(_,0)||b[0],Vc(_,1)||b[1],Vc(_,2)||b[2]],I=Zc(t.zoom);if(I>0){const n=function({x:t,y:e,z:r},n,i,s,o){const a=1/(1<<r);let l=t*a,u=l+a,c=e*a,h=c+a,p=0;const f=(l+u)/2-s;return f>.5?p=-1:f<-.5&&(p=1),l=((l+p)*n-(s*=n))*i+s,u=((u+p)*n-s)*i+s,c=(c*n-(o*=n))*i+o,h=(h*n-o)*i+o,[[l,h,0],[u,h,0],[u,c,0],[l,c,0]]}(r,e,t._pixelsPerMercatorPixel,m,y);for(let t=0;t<a.length;t++)Fc(a[t],n[t],I);const i=M([],n[v],n[(v+1)%4]);P(i,i,.5),Fc(A,i,I);}for(const t of a)z(c,c,t),k(u,u,t);return c[2]=Math.min(b[2],w[2]),z(c,c,A),k(u,u,A),new qu(c,u)}function Rc({x:t,y:e,z:r},n=!1){const i=1/(1<<r),s=new Hl(tu(t*i),e===(1<<r)-1&&n?-90:eu((e+1)*i)),o=new Hl(tu((t+1)*i),0===e&&n?90:eu(e*i));return new Xl(s,o)}function Oc(t,e=Cl){const r=Mt(t.getNorth()),n=Mt(t.getSouth()),i=Math.cos(r),s=Math.cos(n),o=Math.sin(r),a=Math.sin(n),l=t.getWest(),u=t.getEast();return [jl(s,a,l,e),jl(s,a,u,e),jl(i,o,u,e),jl(i,o,l,e)]}function Uc(t,e,r,n){const i=1<<r.z,s=(t/Cn+r.x)/i;return $l(eu((e/Cn+r.y)/i),tu(s),n)}function Nc({min:t,max:e}){return Ll/Math.max(e[0]-t[0],e[1]-t[1],e[2]-t[2])}const jc=new Float64Array(16);function $c(t){const e=Nc(t),r=y(jc,[e,e,e]);return h(r,r,V([],t.min))}function Gc(t){const e=(n=t.min,(r=jc)[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=1,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=1,r[11]=0,r[12]=n[0],r[13]=n[1],r[14]=n[2],r[15]=1,r);var r,n;const i=1/Nc(t);return p(e,e,[i,i,i])}function qc(t){const e=Cn/(2*Math.PI);return t/(2*Math.PI)/e}function Hc(t,e){return Cn/(512*Math.pow(2,t))*Nc(Cc(e))}function Xc(t,e,r,n,i){const s=qc(r),o=[t,e,-r/(2*Math.PI)],a=l(new Float64Array(16));return h(a,a,o),p(a,a,[s,s,s]),f(a,a,Mt(-i)),d(a,a,Mt(-n)),a}function Zc(t){return Tt(Fl,Dl,t)}function Wc(t,e){const r=$l(e.lat,e.lng),n=function(t){const e=$l(t._center.lat,t._center.lng);let r=D([],A(0,1,0),e);const n=g([],-t.angle,e);r=R(r,r,n),g(n,-t._pitch,r);const i=C([],e);return P(i,i,Pc(t.cameraToCenterDistance/t.pixelsPerMeter)),R(i,i,n),M([],e,i)}(t);return o=(i=I([],n,r))[0],a=i[1],l=i[2],u=(s=r)[0],c=s[1],h=s[2],f=(p=Math.sqrt(o*o+a*a+l*l)*Math.sqrt(u*u+c*c+h*h))&&F(i,s)/p,Math.acos(Math.min(Math.max(f,-1),1));var i,s,o,a,l,u,c,h,p,f;}function Yc(t,e){return Wc(t,e)>Math.PI/2*1.01}const Kc=Mt(85),Jc=Math.cos(Kc),Qc=Math.sin(Kc),th=a(),eh=t=>{const e=[];return "map"===t.paint.get("circle-pitch-alignment")&&e.push("PITCH_WITH_MAP"),"map"===t.paint.get("circle-pitch-scale")&&e.push("SCALE_WITH_MAP"),e};function rh(t,e,r,n,i,s,o,a,l){if(s&&t.queryGeometry.isAboveHorizon)return !1;s&&(l*=t.pixelToTileUnitsFactor);const u=t.tileID.canonical,c=r.projection.upVectorScale(u,r.center.lat,r.worldSize).metersToTile;for(const h of e)for(const e of h){const h=e.add(a),p=i&&r.elevation?r.elevation.exaggeration()*i.getElevationAt(h.x,h.y,!0):0,f=r.projection.projectTilePoint(h.x,h.y,u);if(p>0){const t=r.projection.upVector(u,h.x,h.y);f.x+=t[0]*c*p,f.y+=t[1]*c*p,f.z+=t[2]*c*p;}const d=s?h:nh(f.x,f.y,f.z,n),m=s?t.tilespaceRays.map((t=>oh(t,p))):t.queryGeometry.screenGeometry,y=Z([],[f.x,f.y,f.z,1],n);if(!o&&s?l*=y[3]/r.cameraToCenterDistance:o&&!s&&(l*=r.cameraToCenterDistance/y[3]),s){const t=eu((e.y/Cn+u.y)/(1<<u.z));l/=r.projection.pixelsPerMeter(t,1)/Ql(1,t);}if(Ju(m,d,l))return !0}return !1}function nh(t,e,r,n){const i=Z([],[t,e,r,1],n);return new bt(i[0]/i[3],i[1]/i[3])}const ih=A(0,0,0),sh=A(0,0,1);function oh(t,e){const r=b();return ih[2]=e,t.intersectsPlane(ih,sh,r),new bt(r[0],r[1])}class ah extends Yu{}let lh,uh,ch,hh;function ph(t,{width:e,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==e*r*n)throw new RangeError("mismatched image size")}else i=new Uint8Array(e*r*n);return t.width=e,t.height=r,t.data=i,t}function fh(t,e,r){const{width:n,height:i}=e;n===t.width&&i===t.height||(dh(t,e,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,n),height:Math.min(t.height,i)},r,null),t.width=n,t.height=i,t.data=e.data);}function dh(t,e,r,n,i,s,o,a){if(0===i.width||0===i.height)return e;if(i.width>t.width||i.height>t.height||r.x>t.width-i.width||r.y>t.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>e.width||i.height>e.height||n.x>e.width-i.width||n.y>e.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const l=t.data,u=e.data,c=4===s&&a;for(let a=0;a<i.height;a++){const h=((r.y+a)*t.width+r.x)*s,p=((n.y+a)*e.width+n.x)*s;if(c)for(let t=0;t<i.width;t++){const e=h+t*s+3,r=p+t*s;u[r+0]=255,u[r+1]=255,u[r+2]=255,u[r+3]=l[e];}else if(o)for(let t=0;t<i.width;t++){const e=h+t*s,r=p+t*s,n=new sr(l[e+0]/255,l[e+1]/255,l[e+2]/255,l[e+3]).toNonPremultipliedRenderColor(o).toArray();u[r+0]=n[0],u[r+1]=n[1],u[r+2]=n[2],u[r+3]=n[3];}else for(let t=0;t<i.width*s;t++)u[p+t]=l[h+t];}return e}qs(ah,"HeatmapBucket",{omit:["layers"]});class mh{constructor(t,e){ph(this,t,1,e);}resize(t){fh(this,new mh(t),1);}clone(){return new mh({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){dh(t,e,r,n,i,1,null);}}class yh{constructor(t,e){ph(this,t,4,e);}resize(t){fh(this,new yh(t),4);}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t;}clone(){return new yh({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i,s,o){dh(t,e,r,n,i,4,s,o);}}class gh{constructor(t,e){this.width=t.width,this.height=t.height,this.data=e instanceof Uint8Array?new Float32Array(e.buffer):e;}}function xh(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,i=t.image||new yh({width:r,height:n}),s=(r,n,s)=>{e[t.evaluationKey]=s;const o=t.expression.evaluate(e),a=o?o.toNonPremultipliedRenderColor(null):null;a&&(i.data[r+n+0]=Math.floor(255*a.r),i.data[r+n+1]=Math.floor(255*a.g),i.data[r+n+2]=Math.floor(255*a.b),i.data[r+n+3]=Math.floor(255*a.a));};if(t.clips)for(let e=0,i=0;e<n;++e,i+=4*r)for(let n=0,o=0;n<r;n++,o+=4){const a=n/(r-1),{start:l,end:u}=t.clips[e];s(i,o,l*(1-a)+u*a);}else for(let t=0,e=0;t<r;t++,e+=4)s(0,e,t/(r-1));return i}qs(mh,"AlphaImage"),qs(yh,"RGBAImage");const vh=ta([{name:"a_pos",components:2,type:"Int16"}],4),bh=ta([{name:"a_road_z_offset",components:1,type:"Float32"}],4),wh=ta([{name:"a_pos",components:2,type:"Int16"},{name:"a_height",components:1,type:"Float32"}],4),_h=ta([{name:"a_pos_normal_3",components:3,type:"Int16"}],4);function Ah(t,e,r=2){const n=e&&e.length,i=n?e[0]*r:t.length;let s=Mh(t,0,i,r,!0);const o=[];if(!s||s.next===s.prev)return o;let a,l,u;if(n&&(s=function(t,e,r,n){const i=[];for(let r=0,s=e.length;r<s;r++){const o=Mh(t,e[r]*n,r<s-1?e[r+1]*n:t.length,n,!1);o===o.next&&(o.steiner=!0),i.push(Fh(o));}i.sort(Th);for(let t=0;t<i.length;t++)r=Bh(i[t],r);return r}(t,e,s,r)),t.length>80*r){a=1/0,l=1/0;let e=-1/0,n=-1/0;for(let s=r;s<i;s+=r){const r=t[s],i=t[s+1];r<a&&(a=r),i<l&&(l=i),r>e&&(e=r),i>n&&(n=i);}u=Math.max(e-a,n-l),u=0!==u?32767/u:0;}return Sh(s,o,r,a,l,u,0),o}function Mh(t,e,r,n,i){let s;if(i===function(t,e,r,n){let i=0;for(let s=e,o=r-n;s<r;s+=n)i+=(t[o]-t[s])*(t[s+1]+t[o+1]),o=s;return i}(t,e,r,n)>0)for(let i=e;i<r;i+=n)s=Hh(i/n|0,t[i],t[i+1],s);else for(let i=r-n;i>=e;i-=n)s=Hh(i/n|0,t[i],t[i+1],s);return s&&Uh(s,s.next)&&(Xh(s),s=s.next),s}function Ih(t,e){if(!t)return t;e||(e=t);let r,n=t;do{if(r=!1,n.steiner||!Uh(n,n.next)&&0!==Oh(n.prev,n,n.next))n=n.next;else {if(Xh(n),n=e=n.prev,n===n.next)break;r=!0;}}while(r||n!==e);return e}function Sh(t,e,r,n,i,s,o){if(!t)return;!o&&s&&function(t,e,r,n){let i=t;do{0===i.z&&(i.z=Ch(i.x,i.y,e,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){let e,r=1;do{let n,i=t;t=null;let s=null;for(e=0;i;){e++;let o=i,a=0;for(let t=0;t<r&&(a++,o=o.nextZ,o);t++);let l=r;for(;a>0||l>0&&o;)0!==a&&(0===l||!o||i.z<=o.z)?(n=i,i=i.nextZ,a--):(n=o,o=o.nextZ,l--),s?s.nextZ=n:t=n,n.prevZ=s,s=n;i=o;}s.nextZ=null,r*=2;}while(e>1)}(i);}(t,n,i,s);let a=t;for(;t.prev!==t.next;){const l=t.prev,u=t.next;if(s?kh(t,n,i,s):zh(t))e.push(l.i,t.i,u.i),Xh(t),t=u.next,a=u.next;else if((t=u)===a){o?1===o?Sh(t=Ph(Ih(t),e),e,r,n,i,s,2):2===o&&Eh(t,e,r,n,i,s):Sh(Ih(t),e,r,n,i,s,1);break}}}function zh(t){const e=t.prev,r=t,n=t.next;if(Oh(e,r,n)>=0)return !1;const i=e.x,s=r.x,o=n.x,a=e.y,l=r.y,u=n.y,c=Math.min(i,s,o),h=Math.min(a,l,u),p=Math.max(i,s,o),f=Math.max(a,l,u);let d=n.next;for(;d!==e;){if(d.x>=c&&d.x<=p&&d.y>=h&&d.y<=f&&Lh(i,a,s,l,o,u,d.x,d.y)&&Oh(d.prev,d,d.next)>=0)return !1;d=d.next;}return !0}function kh(t,e,r,n){const i=t.prev,s=t,o=t.next;if(Oh(i,s,o)>=0)return !1;const a=i.x,l=s.x,u=o.x,c=i.y,h=s.y,p=o.y,f=Math.min(a,l,u),d=Math.min(c,h,p),m=Math.max(a,l,u),y=Math.max(c,h,p),g=Ch(f,d,e,r,n),x=Ch(m,y,e,r,n);let v=t.prevZ,b=t.nextZ;for(;v&&v.z>=g&&b&&b.z<=x;){if(v.x>=f&&v.x<=m&&v.y>=d&&v.y<=y&&v!==i&&v!==o&&Lh(a,c,l,h,u,p,v.x,v.y)&&Oh(v.prev,v,v.next)>=0)return !1;if(v=v.prevZ,b.x>=f&&b.x<=m&&b.y>=d&&b.y<=y&&b!==i&&b!==o&&Lh(a,c,l,h,u,p,b.x,b.y)&&Oh(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}for(;v&&v.z>=g;){if(v.x>=f&&v.x<=m&&v.y>=d&&v.y<=y&&v!==i&&v!==o&&Lh(a,c,l,h,u,p,v.x,v.y)&&Oh(v.prev,v,v.next)>=0)return !1;v=v.prevZ;}for(;b&&b.z<=x;){if(b.x>=f&&b.x<=m&&b.y>=d&&b.y<=y&&b!==i&&b!==o&&Lh(a,c,l,h,u,p,b.x,b.y)&&Oh(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}return !0}function Ph(t,e){let r=t;do{const n=r.prev,i=r.next.next;!Uh(n,i)&&Nh(n,r,r.next,i)&&Gh(n,i)&&Gh(i,n)&&(e.push(n.i,r.i,i.i),Xh(r),Xh(r.next),r=t=i),r=r.next;}while(r!==t);return Ih(r)}function Eh(t,e,r,n,i,s){let o=t;do{let t=o.next.next;for(;t!==o.prev;){if(o.i!==t.i&&Rh(o,t)){let a=qh(o,t);return o=Ih(o,o.next),a=Ih(a,a.next),Sh(o,e,r,n,i,s,0),void Sh(a,e,r,n,i,s,0)}t=t.next;}o=o.next;}while(o!==t)}function Th(t,e){let r=t.x-e.x;return 0===r&&(r=t.y-e.y,0===r)&&(r=(t.next.y-t.y)/(t.next.x-t.x)-(e.next.y-e.y)/(e.next.x-e.x)),r}function Bh(t,e){const r=function(t,e){let r=e;const n=t.x,i=t.y;let s,o=-1/0;if(Uh(t,r))return r;do{if(Uh(t,r.next))return r.next;if(i<=r.y&&i>=r.next.y&&r.next.y!==r.y){const t=r.x+(i-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(t<=n&&t>o&&(o=t,s=r.x<r.next.x?r:r.next,t===n))return s}r=r.next;}while(r!==e);if(!s)return null;const a=s,l=s.x,u=s.y;let c=1/0;r=s;do{if(n>=r.x&&r.x>=l&&n!==r.x&&Dh(i<u?n:o,i,l,u,i<u?o:n,i,r.x,r.y)){const e=Math.abs(i-r.y)/(n-r.x);Gh(r,t)&&(e<c||e===c&&(r.x>s.x||r.x===s.x&&Vh(s,r)))&&(s=r,c=e);}r=r.next;}while(r!==a);return s}(t,e);if(!r)return e;const n=qh(r,t);return Ih(n,n.next),Ih(r,r.next)}function Vh(t,e){return Oh(t.prev,t,e.prev)<0&&Oh(e.next,t,t.next)<0}function Ch(t,e,r,n,i){return (t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-n)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function Fh(t){let e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next;}while(e!==t);return r}function Dh(t,e,r,n,i,s,o,a){return (i-o)*(e-a)>=(t-o)*(s-a)&&(t-o)*(n-a)>=(r-o)*(e-a)&&(r-o)*(s-a)>=(i-o)*(n-a)}function Lh(t,e,r,n,i,s,o,a){return !(t===o&&e===a)&&Dh(t,e,r,n,i,s,o,a)}function Rh(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&Nh(r,r.next,t,e))return !0;r=r.next;}while(r!==t);return !1}(t,e)&&(Gh(t,e)&&Gh(e,t)&&function(t,e){let r=t,n=!1;const i=(t.x+e.x)/2,s=(t.y+e.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&i<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;}while(r!==t);return n}(t,e)&&(Oh(t.prev,t,e.prev)||Oh(t,e.prev,e))||Uh(t,e)&&Oh(t.prev,t,t.next)>0&&Oh(e.prev,e,e.next)>0)}function Oh(t,e,r){return (e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function Uh(t,e){return t.x===e.x&&t.y===e.y}function Nh(t,e,r,n){const i=$h(Oh(t,e,r)),s=$h(Oh(t,e,n)),o=$h(Oh(r,n,t)),a=$h(Oh(r,n,e));return i!==s&&o!==a||!(0!==i||!jh(t,r,e))||!(0!==s||!jh(t,n,e))||!(0!==o||!jh(r,t,n))||!(0!==a||!jh(r,e,n))}function jh(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function $h(t){return t>0?1:t<0?-1:0}function Gh(t,e){return Oh(t.prev,t,t.next)<0?Oh(t,e,t.next)>=0&&Oh(t,t.prev,e)>=0:Oh(t,e,t.prev)<0||Oh(t,t.next,e)<0}function qh(t,e){const r=Zh(t.i,t.x,t.y),n=Zh(e.i,e.x,e.y),i=t.next,s=e.prev;return t.next=e,e.prev=t,r.next=i,i.prev=r,n.next=r,r.prev=n,s.next=n,n.prev=s,n}function Hh(t,e,r,n){const i=Zh(t,e,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function Xh(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ);}function Zh(t,e,r){return {i:t,x:e,y:r,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}function Wh(t,e){const r=t.length;if(r<=1)return [t];const n=[];let i,s;for(let e=0;e<r;e++){const r=Ht(t[e]);0!==r&&(t[e].area=Math.abs(r),void 0===s&&(s=r<0),s===r<0?(i&&n.push(i),i=[t[e]]):i.push(t[e]));}if(i&&n.push(i),e>1)for(let t=0;t<n.length;t++)n[t].length<=e||(en(n[t],e,1,n[t].length-1,Yh),n[t]=n[t].slice(0,e));return n}function Yh(t,e){return e.area-t.area}function Kh(t,e,r=1){if(!t)return null;const n="string"==typeof t?Dr.from(t).getPrimary():t.getPrimary(),i="string"==typeof t?null:t.getSecondary();for(const t of [n,i]){if(!t)continue;const n=t.id.toString();e.has(n)||e.set(n,[]),t.scaleSelf(r),e.get(n).push(t);}return {primary:n.toString(),secondary:i?i.toString():null}}function Jh(t,e,r,n){const i=n.patternDependencies;let s=!1;for(const n of e){const e=n.paint.get(`${t}-pattern`);e.isConstant()||(s=!0),Kh(e.constantOr(null),i,r)&&(s=!0);}return s}function Qh(t,e,r,n,i,s){const o=s.patternDependencies;for(const a of e){const e=a.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:n},r,{},s.availableImages);t=t&&t.name?t.name:t;const l=Kh(t,o,i);if(!l)continue;const{primary:u,secondary:c}=l;u&&(r.patterns[a.id]=[u,c].filter(Boolean));}}return r}class tp{constructor(){this.polygons=new Map;}add(t,...e){this.polygons.has(t)?this.polygons.get(t).push(...e):this.polygons.set(t,e);}merge(t){for(const[e,r]of t.polygons)this.add(e,...r);}}class ep{constructor(){this.portals=[];}static evaluate(t){if(0===t.length)return new ep;let e=[];for(const r of t)e.push(...r.portals);if(0===e.length)return new ep;const r=(t,e)=>t<=0&&e<=0||t>=Cn&&e>=Cn;for(const t of e){const e=t.va,n=t.vb;(r(e.x,n.x)||r(e.y,n.y))&&(t.type="border");}const n=e.filter((t=>"unevaluated"!==t.type)),i=e.filter((t=>"unevaluated"===t.type));if(0===i.length)return new ep;i.sort(((t,e)=>t.hash===e.hash?t.isTunnel===e.isTunnel?0:t.isTunnel?-1:1:t.hash<e.hash?1:-1)),e=n.concat(i);let s=n.length,o=s,a=s;do{if(o++,o===e.length||e[s].hash!==e[o].hash){if(o-s==2){a<s&&(e[a]=e[s],e[s]=null);const t=e[a],r=e[o-1];t.type=t.isTunnel!==r.isTunnel?"tunnel":"polygon",t.connection={a:t.connection.a,b:r.connection.a},a++;}s=o;}}while(s!==e.length);return e.splice(a),e.sort(((t,e)=>t.hash<e.hash?1:-1)),{portals:e}}}qs(ep,"ElevationPortalGraph"),qs(tp,"ElevationPolygons");class rp{constructor(t,e,r){this.outPositions=t,this.outNormals=e,this.outIndices=r,this.vertexLookup=new Map,this.buffer=new ArrayBuffer(4),this.view=new DataView(this.buffer);}addVertex(t,e,r){let n=t[2];null!=r&&(n*=r);const i=this.getVec3Bits(t)<<96n|this.getVec3Bits(e),s=this.vertexLookup.get(i);if(null!=s)return s;const o=this.outPositions.length;this.vertexLookup.set(i,o);const a=Math.trunc(16384*e[0]),l=Math.trunc(16384*e[1]),u=Math.trunc(16384*e[2]);return this.outPositions.emplaceBack(t[0],t[1],n),this.outNormals.emplaceBack(a,l,u),o}addVertices(t,e,...r){const n=[];for(const i of r){const r=this.addVertex(i,t,e);n.push(r);}return n}addTriangles(t,e,r){if(e&&r){const n=1===r.length,i=A(0,0,0);for(let s=0;s<t.length;s+=3){const o=e[t[s+0]],a=e[t[s+1]],l=e[t[s+2]],u=n?r[0]:r[t[s+1]],c=n?r[0]:r[t[s+2]],h=this.addVertex(A(o.x,o.y,n?r[0]:r[t[s+0]]),i),p=this.addVertex(A(a.x,a.y,u),i),f=this.addVertex(A(l.x,l.y,c),i);this.outIndices.emplaceBack(h,p,f);}}else for(let e=0;e<t.length;e+=3)this.outIndices.emplaceBack(t[e+0],t[e+1],t[e+2]);}addQuad(t,e){const r=this.addVertices(e,void 0,...t.map((t=>A(t.coord.x,t.coord.y,t.height)))),[n,i,s,o]=r;this.addTriangles([n,i,s,s,o,n]);}getVertexCount(){return this.outPositions.length}clearVertexLookup(){this.vertexLookup.clear();}getBits(t){return this.view.setFloat32(0,t),BigInt(this.view.getUint32(0))}getVec3Bits(t){return this.getBits(t[0])<<64n|this.getBits(t[1])<<32n|this.getBits(t[2])}}class np{constructor(t,e,r,n){this.unevaluatedPortals=new ep,this.portalPolygons=new tp,this.bridgeFeatureSections=[],this.tunnelFeatureSections=[],this.vertexHashLookup=new Map,this.unevalVertices=[],this.unevalHeights=[],this.unevalTriangles=[],this.unevalTunnelTriangles=[],this.unevalEdges=[],this.vertexPositions=new oa,this.vertexNormals=new aa,this.indexArray=new Aa,this.tileToMeters=au(t),this.bridgeProgramConfigurations=new kl(e,{zoom:r,lut:n},(t=>"fill-tunnel-structure-color"!==t)),this.tunnelProgramConfigurations=new kl(e,{zoom:r,lut:n},(t=>"fill-bridge-guard-rail-color"!==t));}addVertices(t,e){const r=this.unevalVertices.length;for(let r=0;r<t.length;r++)this.unevalVertices.push(t[r]),this.unevalHeights.push(e[r]);return r}addTriangles(t,e,r){const n=r?this.unevalTunnelTriangles:this.unevalTriangles;for(const r of t)n.push(r+e);}addRenderableRing(t,e,r,n,i,s){const o=[new bt(i.min.x,i.min.y),new bt(i.max.x,i.min.y),new bt(i.max.x,i.max.y),new bt(i.min.x,i.max.y)];for(let a=0;a<r-1;a++){const r=e+a,l=r+1,u=this.unevalVertices[r],c=this.unevalVertices[l];if(!(u.x>=i.min.x&&u.x<=i.max.x&&u.y>=i.min.y&&u.y<=i.max.y||c.x>=i.min.x&&c.x<=i.max.x&&c.y>=i.min.y&&c.y<=i.max.y||cc(u,c,o)))continue;if(this.isOnBorder(u.x,c.x)||this.isOnBorder(u.y,c.y))continue;const h=np.computeEdgeHash(this.unevalVertices[r],this.unevalVertices[l]);let p,f=this.vertexHashLookup.get(np.computePosHash(u));null!=f?p=f.next:(f=this.vertexHashLookup.get(np.computePosHash(c)),p=null!=f?f.prev:h),this.unevalEdges.push({polygonIdx:t,a:r,b:l,hash:h,portalHash:p,isTunnel:n,type:"unevaluated",featureInfo:s});}}addPortalCandidates(t,e,r,n,i){if(0===e.length)return;this.portalPolygons.add(t,{geometry:e,zLevel:i});const s=e[0];this.vertexHashLookup.clear();let o=np.computeEdgeHash(s[s.length-2],s[s.length-1]);for(let e=0;e<s.length-1;e++){const i=s[e+0],a=s[e+1],l=at(a.x-i.x,a.y-i.y),u=ht(l);if(0===u)continue;let c="unevaluated";const h=n.pointElevation(i),p=n.pointElevation(a);Math.abs(h)<.01&&Math.abs(p)<.01?c="entrance":(this.isOnBorder(i.x,a.x)||this.isOnBorder(i.y,a.y))&&(c="border");const f=np.computeEdgeHash(i,a);this.unevaluatedPortals.portals.push({connection:{a:t,b:void 0},va:i,vb:a,vab:l,length:u,hash:f,isTunnel:r,type:c});const d=np.computePosHash(i);this.vertexHashLookup.set(d,{prev:o,next:f}),o=f;}}construct(t){if(0===this.unevalVertices.length)return;const e=()=>({vertexOffset:0,primitiveOffset:this.indexArray.length}),r=t=>{t.primitiveLength=this.indexArray.length-t.primitiveOffset;},n=new rp(this.vertexPositions,this.vertexNormals,this.indexArray);this.prepareEdges(t.portals,this.unevalEdges);const i=e(),s=e(),o=e(),a=(t,e)=>{t.sort(((t,r)=>t.type===e&&r.type!==e?-1:t.type!==e&&r.type===e?1:0));const r=t.findIndex((t=>t.type!==e));return r>=0?r:t.length};let l=0;this.unevalEdges.length>0&&(l=a(this.unevalEdges,"none"),this.constructBridgeStructures(n,this.unevalVertices,this.unevalHeights,this.unevalEdges,{min:0,max:l},this.tileToMeters)),r(o);const u=e(),c=e();if(this.unevalEdges.length>0){const t=this.unevalEdges.splice(l),e=a(t,"tunnel")+l;this.unevalEdges.push(...t),this.constructTunnelStructures(n,this.unevalVertices,this.unevalHeights,this.unevalEdges,{min:0,max:l},{min:l,max:e});}r(u),n.addTriangles(this.unevalTriangles,this.unevalVertices,this.unevalHeights),r(c),n.addTriangles(this.unevalTunnelTriangles,this.unevalVertices,this.unevalHeights),r(s),n.addTriangles(this.unevalTunnelTriangles,this.unevalVertices,[-.1]),r(i),this.maskSegments=tl.simpleSegment(0,c.primitiveOffset,0,c.primitiveLength),this.depthSegments=tl.simpleSegment(0,s.primitiveOffset,0,s.primitiveLength),this.renderableBridgeSegments=tl.simpleSegment(0,o.primitiveOffset,0,o.primitiveLength),this.renderableTunnelSegments=tl.simpleSegment(0,u.primitiveOffset,0,u.primitiveLength),this.shadowCasterSegments=tl.simpleSegment(0,i.primitiveOffset,0,i.primitiveLength);}update(t,e,r,n,i,s,o,a){this.bridgeProgramConfigurations.updatePaintArrays(t,e,i,r,n,s,o,a),this.tunnelProgramConfigurations.updatePaintArrays(t,e,i,r,n,s,o,a);}upload(t){this.vertexBuffer||0===this.vertexPositions.length||0===this.vertexNormals.length||0===this.indexArray.length||(this.vertexBuffer=t.createVertexBuffer(this.vertexPositions,wh.members),this.vertexBufferNormal=t.createVertexBuffer(this.vertexNormals,_h.members),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.bridgeProgramConfigurations.upload(t),this.tunnelProgramConfigurations.upload(t));}destroy(){this.vertexBuffer&&(this.vertexBuffer.destroy(),this.vertexBufferNormal.destroy(),this.indexBuffer.destroy()),this.maskSegments&&(this.maskSegments.destroy(),this.depthSegments.destroy(),this.renderableBridgeSegments.destroy(),this.renderableTunnelSegments.destroy(),this.shadowCasterSegments.destroy()),this.bridgeProgramConfigurations.destroy(),this.tunnelProgramConfigurations.destroy();}populatePaintArrays(t,e,r,n,i){const s=(s,o)=>{for(let a=0;a<o.length-1;a++){const l=o[a].featureIndex,u=o[a+1].vertexStart,c=t.feature(l);s.populatePaintArrays(u,c,l,{},r,e,n,void 0,i);}};s(this.bridgeProgramConfigurations,this.bridgeFeatureSections),s(this.tunnelProgramConfigurations,this.tunnelFeatureSections);}computeVertexConnections(t,e,r,n,i){const s=new Map;for(let o=n;o<i;o++){const n=r[o],i=n.a,a=n.b,l=np.computePosHash(t[i]),u=np.computePosHash(t[a]);s.has(l)||s.set(l,{}),s.has(u)||s.set(u,{});const c=s.get(l),h=s.get(u);e[i]<=0&&e[a]<=0||(c.to=a,h.from=i);}return s}constructBridgeStructures(t,e,r,n,i,s){t.clearVertexLookup();const o=this.computeVertexConnections(e,r,n,i.min,i.max),a=1/s,l=.5*a,u=t=>A(e[t].x,e[t].y,r[t]*a),c=t=>{const r=o.get(np.computePosHash(e[t])),n=r.from,i=r.to;if(!n||!i)return;const s=u(n),a=u(t),l=u(i),c=A(0,0,0);if(!N(s,a)){const t=j(b(),a,s);M(c,c,C(t,t));}if(!N(l,a)){const t=j(b(),l,a);M(c,c,C(t,t));}const h=G(c);return h>0?P(c,c,1/h):void 0};let h=Number.POSITIVE_INFINITY;this.sortSubarray(n,i.min,i.max,((t,e)=>t.featureInfo.featureIndex-e.featureInfo.featureIndex));for(let o=i.min;o<i.max;o++){const i=n[o];if(!i.featureInfo.guardRailEnabled)continue;const u=this.prepareEdgePoints(e,r,i,((t,e)=>t>e));if(null==u)continue;const p=u[0],f=u[1],d=A(p.coord.x,p.coord.y,a*p.height),m=A(f.coord.x,f.coord.y,a*f.height);if(N(d,m))continue;const y=j(b(),m,d);C(y,y);const g=t=>C(t,t),x=c(i.a)||y,v=c(i.b)||y,w=g(A(x[1],-x[0],0)),_=g(A(v[1],-v[0],0)),I=g(D(b(),w,x)),S=g(D(b(),_,v)),z=b(),k=[M(b(),d,P(z,j(z,w,I),l)),M(b(),d,P(z,M(z,w,I),l)),M(b(),d,P(z,I,l)),d],E=[M(b(),m,P(z,j(z,_,S),l)),M(b(),m,P(z,M(z,_,S),l)),M(b(),m,P(z,S,l)),m];h=this.addFeatureSection(i.featureInfo.featureIndex,h,this.bridgeFeatureSections,t);const[T,B]=t.addVertices(w,s,k[0],k[1]),[F,L]=t.addVertices(_,s,E[0],E[1]);t.addTriangles([T,B,F,B,L,F]);const[R,O]=t.addVertices(I,s,k[1],k[2]),[U,$]=t.addVertices(S,s,E[1],E[2]);t.addTriangles([R,O,U,O,$,U]);const[G,q]=t.addVertices(V(w,w),s,k[2],k[3]),[H,X]=t.addVertices(V(_,_),s,E[2],E[3]);t.addTriangles([G,q,H,q,X,H]);}this.bridgeFeatureSections.push({featureIndex:Number.POSITIVE_INFINITY,vertexStart:t.getVertexCount()});}constructTunnelStructures(t,e,r,n,i,s){t.clearVertexLookup();let o=Number.POSITIVE_INFINITY;const a=(t,e)=>t.featureInfo.featureIndex-e.featureInfo.featureIndex;this.sortSubarray(n,i.min,i.max,a),this.sortSubarray(n,s.min,s.max,a);const l=t=>C(t,t);for(let s=i.min;s<i.max;s++){const i=this.prepareEdgePoints(e,r,n[s],((t,e)=>t<e));if(null==i)continue;const[a,u]=i,c=l(A(-(u.coord.y-a.coord.y),u.coord.x-a.coord.x,0));o=this.addFeatureSection(n[s].featureInfo.featureIndex,o,this.tunnelFeatureSections,t),t.addQuad([a,u,{coord:u.coord,height:n[s].isTunnel?-.1:0},{coord:a.coord,height:n[s].isTunnel?-.1:0}],c);}for(let i=s.min;i<s.max;i++){const s=n[i];s.isTunnel&&([s.a,s.b]=[s.b,s.a]);const a=e[s.a],u=e[s.b],c=l(A(-(u.y-a.y),u.x-a.x,0));o=this.addFeatureSection(s.featureInfo.featureIndex,o,this.tunnelFeatureSections,t),t.addQuad([{coord:u,height:0},{coord:a,height:0},{coord:a,height:r[s.a]+4},{coord:u,height:r[s.b]+4}],c),t.addQuad([{coord:a,height:0},{coord:u,height:0},{coord:u,height:r[s.b]+4},{coord:a,height:r[s.a]+4}],c);}this.tunnelFeatureSections.push({featureIndex:Number.POSITIVE_INFINITY,vertexStart:t.getVertexCount()});}prepareEdgePoints(t,e,r,n){let i=e[r.a],s=e[r.b];const o=n(i,0),a=n(s,0);if(o&&a)return [{coord:t[r.a],height:i},{coord:t[r.b],height:s}];if(!o&&!a)return;const l=t[r.a].clone(),u=t[r.b].clone();if(o){if(!a){const t=s/(s-i);u.x=ur(u.x,l.x,t),u.y=ur(u.y,l.y,t),s=ur(s,i,t);}}else {const t=i/(i-s);l.x=ur(l.x,u.x,t),l.y=ur(l.y,u.y,t),i=ur(i,s,t);}return [{coord:l,height:i},{coord:u,height:s}]}prepareEdges(t,e){if(0===e.length)return;e.sort(((t,e)=>t.hash===e.hash?e.polygonIdx-t.polygonIdx:e.hash>t.hash?1:-1));let r=0,n=0,i=0,s=e[r].polygonIdx;do{n++,(n===e.length||e[r].hash!==e[n].hash)&&((1==n-r||e[n-1].polygonIdx!==s)&&(i<r&&(e[i]=e[r],e[r]=null),e[i].type="none",i++),r=n,r!==e.length&&(s=e[r].polygonIdx));}while(r!==e.length);if(e.splice(i),0!==e.length&&0!==t.length){e.sort(((t,e)=>t.portalHash<e.portalHash?1:-1));let r=0,n=0;for(;r!==e.length&&n!==t.length;){const i=e[r],s=t[n];i.portalHash>s.hash?r++:s.hash>i.portalHash?n++:(i.type=s.type,r++);}}}isOnBorder(t,e){return t<=0&&e<=0||t>=Cn&&e>=Cn}addFeatureSection(t,e,r,n){return t!==e&&(e=t,r.push({featureIndex:t,vertexStart:n.getVertexCount()}),n.clearVertexLookup()),e}sortSubarray(t,e,r,n){const i=t.slice(e,r);i.sort(n),t.splice(e,i.length,...i);}static computeEdgeHash(t,e){return (t.y===e.y&&t.x>e.x||t.y>e.y)&&([t,e]=[e,t]),BigInt(np.computePosHash(t))<<32n|BigInt(np.computePosHash(e))}static computePosHash(t){return ((65535&t.x)<<16|65535&t.y)>>>0}}var ip,sp={exports:{}},op=(ip||(ip=1,function(t,e){!function(t){function e(t,e){return t>e?1:t<e?-1:0}var r=function(t,r){void 0===t&&(t=e),void 0===r&&(r=!1),this._compare=t,this._root=null,this._size=0,this._noDuplicates=!!r;},n={size:{configurable:!0}};function i(t,e,r,n,s){var o=s-n;if(o>0){var a=n+Math.floor(o/2),l={key:e[a],data:r[a],parent:t};return l.left=i(l,e,r,n,a),l.right=i(l,e,r,a+1,s),l}return null}function s(t,e,r,n,i){if(!(r>=n)){for(var o=t[r+n>>1],a=r-1,l=n+1;;){do{a++;}while(i(t[a],o)<0);do{l--;}while(i(t[l],o)>0);if(a>=l)break;var u=t[a];t[a]=t[l],t[l]=u,u=e[a],e[a]=e[l],e[l]=u;}s(t,e,r,l,i),s(t,e,l+1,n,i);}}r.prototype.rotateLeft=function(t){var e=t.right;e&&(t.right=e.left,e.left&&(e.left.parent=t),e.parent=t.parent),t.parent?t===t.parent.left?t.parent.left=e:t.parent.right=e:this._root=e,e&&(e.left=t),t.parent=e;},r.prototype.rotateRight=function(t){var e=t.left;e&&(t.left=e.right,e.right&&(e.right.parent=t),e.parent=t.parent),t.parent?t===t.parent.left?t.parent.left=e:t.parent.right=e:this._root=e,e&&(e.right=t),t.parent=e;},r.prototype._splay=function(t){for(;t.parent;){var e=t.parent;e.parent?e.left===t&&e.parent.left===e?(this.rotateRight(e.parent),this.rotateRight(e)):e.right===t&&e.parent.right===e?(this.rotateLeft(e.parent),this.rotateLeft(e)):e.left===t&&e.parent.right===e?(this.rotateRight(e),this.rotateLeft(e)):(this.rotateLeft(e),this.rotateRight(e)):e.left===t?this.rotateRight(e):this.rotateLeft(e);}},r.prototype.splay=function(t){for(var e,r,n,i,s;t.parent;)(r=(e=t.parent).parent)&&r.parent?((n=r.parent).left===r?n.left=t:n.right=t,t.parent=n):(t.parent=null,this._root=t),i=t.left,s=t.right,t===e.left?(r&&(r.left===e?(e.right?(r.left=e.right,r.left.parent=r):r.left=null,e.right=r,r.parent=e):(i?(r.right=i,i.parent=r):r.right=null,t.left=r,r.parent=t)),s?(e.left=s,s.parent=e):e.left=null,t.right=e,e.parent=t):(r&&(r.right===e?(e.left?(r.right=e.left,r.right.parent=r):r.right=null,e.left=r,r.parent=e):(s?(r.left=s,s.parent=r):r.left=null,t.right=r,r.parent=t)),i?(e.right=i,i.parent=e):e.right=null,t.left=e,e.parent=t);},r.prototype.replace=function(t,e){t.parent?t===t.parent.left?t.parent.left=e:t.parent.right=e:this._root=e,e&&(e.parent=t.parent);},r.prototype.minNode=function(t){if(void 0===t&&(t=this._root),t)for(;t.left;)t=t.left;return t},r.prototype.maxNode=function(t){if(void 0===t&&(t=this._root),t)for(;t.right;)t=t.right;return t},r.prototype.insert=function(t,e){var r=this._root,n=null,i=this._compare;if(this._noDuplicates)for(;r;){if(n=r,0===i(r.key,t))return;r=i(r.key,t)<0?r.right:r.left;}else for(;r;)n=r,r=i(r.key,t)<0?r.right:r.left;return r={key:t,data:e,left:null,right:null,parent:n},n?i(n.key,r.key)<0?n.right=r:n.left=r:this._root=r,this.splay(r),this._size++,r},r.prototype.find=function(t){for(var e=this._root,r=this._compare;e;){var n=r(e.key,t);if(n<0)e=e.right;else {if(!(n>0))return e;e=e.left;}}return null},r.prototype.contains=function(t){for(var e=this._root,r=this._compare;e;){var n=r(t,e.key);if(0===n)return !0;e=n<0?e.left:e.right;}return !1},r.prototype.remove=function(t){var e=this.find(t);if(!e)return !1;if(this.splay(e),e.left)if(e.right){var r=this.minNode(e.right);r.parent!==e&&(this.replace(r,r.right),r.right=e.right,r.right.parent=r),this.replace(e,r),r.left=e.left,r.left.parent=r;}else this.replace(e,e.left);else this.replace(e,e.right);return this._size--,!0},r.prototype.removeNode=function(t){if(!t)return !1;if(this.splay(t),t.left)if(t.right){var e=this.minNode(t.right);e.parent!==t&&(this.replace(e,e.right),e.right=t.right,e.right.parent=e),this.replace(t,e),e.left=t.left,e.left.parent=e;}else this.replace(t,t.left);else this.replace(t,t.right);return this._size--,!0},r.prototype.erase=function(t){var e=this.find(t);if(e){this.splay(e);var r=e.left,n=e.right,i=null;r&&(r.parent=null,i=this.maxNode(r),this.splay(i),this._root=i),n&&(r?i.right=n:this._root=n,n.parent=i),this._size--;}},r.prototype.pop=function(){var t=this._root,e=null;if(t){for(;t.left;)t=t.left;e={key:t.key,data:t.data},this.remove(t.key);}return e},r.prototype.next=function(t){var e=t;if(e)if(e.right)for(e=e.right;e&&e.left;)e=e.left;else for(e=t.parent;e&&e.right===t;)t=e,e=e.parent;return e},r.prototype.prev=function(t){var e=t;if(e)if(e.left)for(e=e.left;e&&e.right;)e=e.right;else for(e=t.parent;e&&e.left===t;)t=e,e=e.parent;return e},r.prototype.forEach=function(t){for(var e=this._root,r=[],n=!1,i=0;!n;)e?(r.push(e),e=e.left):r.length>0?(t(e=r.pop(),i++),e=e.right):n=!0;return this},r.prototype.range=function(t,e,r,n){for(var i=[],s=this._compare,o=this._root;0!==i.length||o;)if(o)i.push(o),o=o.left;else {if(s((o=i.pop()).key,e)>0)break;if(s(o.key,t)>=0&&r.call(n,o))return this;o=o.right;}return this},r.prototype.keys=function(){for(var t=this._root,e=[],r=[],n=!1;!n;)t?(e.push(t),t=t.left):e.length>0?(t=e.pop(),r.push(t.key),t=t.right):n=!0;return r},r.prototype.values=function(){for(var t=this._root,e=[],r=[],n=!1;!n;)t?(e.push(t),t=t.left):e.length>0?(t=e.pop(),r.push(t.data),t=t.right):n=!0;return r},r.prototype.at=function(t){for(var e=this._root,r=[],n=!1,i=0;!n;)if(e)r.push(e),e=e.left;else if(r.length>0){if(e=r.pop(),i===t)return e;i++,e=e.right;}else n=!0;return null},r.prototype.load=function(t,e,r){if(void 0===t&&(t=[]),void 0===e&&(e=[]),void 0===r&&(r=!1),0!==this._size)throw new Error("bulk-load: tree is not empty");var n=t.length;return r&&s(t,e,0,n-1,this._compare),this._root=i(null,t,e,0,n),this._size=n,this},r.prototype.min=function(){var t=this.minNode(this._root);return t?t.key:null},r.prototype.max=function(){var t=this.maxNode(this._root);return t?t.key:null},r.prototype.isEmpty=function(){return null===this._root},n.size.get=function(){return this._size},r.createTree=function(t,e,n,i,s){return new r(n,s).load(t,e,i)},Object.defineProperties(r.prototype,n);var o=0,a=1,l=2,u=3,c=0,h=1,p=2,f=3;function d(t,e,r){null===e?(t.inOut=!1,t.otherInOut=!0):(t.isSubject===e.isSubject?(t.inOut=!e.inOut,t.otherInOut=e.otherInOut):(t.inOut=!e.otherInOut,t.otherInOut=e.isVertical()?!e.inOut:e.inOut),e&&(t.prevInResult=!m(e,r)||e.isVertical()?e.prevInResult:e));var n=m(t,r);t.resultTransition=n?function(t,e){var r,n=!t.inOut,i=!t.otherInOut;switch(e){case c:r=n&&i;break;case h:r=n||i;break;case f:r=n^i;break;case p:r=t.isSubject?n&&!i:i&&!n;}return r?1:-1}(t,r):0;}function m(t,e){switch(t.type){case o:switch(e){case c:return !t.otherInOut;case h:return t.otherInOut;case p:return t.isSubject&&t.otherInOut||!t.isSubject&&!t.otherInOut;case f:return !0}break;case l:return e===c||e===h;case u:return e===p;case a:return !1}return !1}var y=function(t,e,r,n,i){this.left=e,this.point=t,this.otherEvent=r,this.isSubject=n,this.type=i||o,this.inOut=!1,this.otherInOut=!1,this.prevInResult=null,this.resultTransition=0,this.otherPos=-1,this.outputContourId=-1,this.isExteriorRing=!0;},g={inResult:{configurable:!0}};function x(t,e){return t[0]===e[0]&&t[1]===e[1]}y.prototype.isBelow=function(t){var e=this.point,r=this.otherEvent.point;return this.left?(e[0]-t[0])*(r[1]-t[1])-(r[0]-t[0])*(e[1]-t[1])>0:(r[0]-t[0])*(e[1]-t[1])-(e[0]-t[0])*(r[1]-t[1])>0},y.prototype.isAbove=function(t){return !this.isBelow(t)},y.prototype.isVertical=function(){return this.point[0]===this.otherEvent.point[0]},g.inResult.get=function(){return 0!==this.resultTransition},y.prototype.clone=function(){var t=new y(this.point,this.left,this.otherEvent,this.isSubject,this.type);return t.contourId=this.contourId,t.resultTransition=this.resultTransition,t.prevInResult=this.prevInResult,t.isExteriorRing=this.isExteriorRing,t.inOut=this.inOut,t.otherInOut=this.otherInOut,t},Object.defineProperties(y.prototype,g);var v=11102230246251565e-32,b=134217729,w=(3+8*v)*v;function _(t,e,r,n,i){var s,o,a,l,u=e[0],c=n[0],h=0,p=0;c>u==c>-u?(s=u,u=e[++h]):(s=c,c=n[++p]);var f=0;if(h<t&&p<r)for(c>u==c>-u?(a=s-((o=u+s)-u),u=e[++h]):(a=s-((o=c+s)-c),c=n[++p]),s=o,0!==a&&(i[f++]=a);h<t&&p<r;)c>u==c>-u?(a=s-((o=s+u)-(l=o-s))+(u-l),u=e[++h]):(a=s-((o=s+c)-(l=o-s))+(c-l),c=n[++p]),s=o,0!==a&&(i[f++]=a);for(;h<t;)a=s-((o=s+u)-(l=o-s))+(u-l),u=e[++h],s=o,0!==a&&(i[f++]=a);for(;p<r;)a=s-((o=s+c)-(l=o-s))+(c-l),c=n[++p],s=o,0!==a&&(i[f++]=a);return 0===s&&0!==f||(i[f++]=s),f}function A(t){return new Float64Array(t)}var M=33306690738754716e-32,I=22204460492503146e-32,S=11093356479670487e-47,z=A(4),k=A(8),P=A(12),E=A(16),T=A(4);function B(t,e,r){var n=function(t,e,r,n,i,s){var o=(e-s)*(r-i),a=(t-i)*(n-s),l=o-a;if(0===o||0===a||o>0!=a>0)return l;var u=Math.abs(o+a);return Math.abs(l)>=M*u?l:-function(t,e,r,n,i,s,o){var a,l,u,c,h,p,f,d,m,y,g,x,v,A,M,B,V,C,F=t-i,D=r-i,L=e-s,R=n-s;z[0]=(M=(d=F-(f=(p=b*F)-(p-F)))*(y=R-(m=(p=b*R)-(p-R)))-((A=F*R)-f*m-d*m-f*y))-((g=M-(V=(d=L-(f=(p=b*L)-(p-L)))*(y=D-(m=(p=b*D)-(p-D)))-((B=L*D)-f*m-d*m-f*y)))+(h=M-g))+(h-V),z[1]=(v=A-((x=A+g)-(h=x-A))+(g-h))-((g=v-B)+(h=v-g))+(h-B),z[2]=x-((C=x+g)-(h=C-x))+(g-h),z[3]=C;var O=function(t,e){for(var r=e[0],n=1;n<4;n++)r+=e[n];return r}(0,z),U=I*o;if(O>=U||-O>=U)return O;if(a=t-(F+(h=t-F))+(h-i),u=r-(D+(h=r-D))+(h-i),l=e-(L+(h=e-L))+(h-s),c=n-(R+(h=n-R))+(h-s),0===a&&0===l&&0===u&&0===c)return O;if(U=S*o+w*Math.abs(O),(O+=F*c+R*a-(L*u+D*l))>=U||-O>=U)return O;T[0]=(M=(d=a-(f=(p=b*a)-(p-a)))*(y=R-(m=(p=b*R)-(p-R)))-((A=a*R)-f*m-d*m-f*y))-((g=M-(V=(d=l-(f=(p=b*l)-(p-l)))*(y=D-(m=(p=b*D)-(p-D)))-((B=l*D)-f*m-d*m-f*y)))+(h=M-g))+(h-V),T[1]=(v=A-((x=A+g)-(h=x-A))+(g-h))-((g=v-B)+(h=v-g))+(h-B),T[2]=x-((C=x+g)-(h=C-x))+(g-h),T[3]=C;var N=_(4,z,4,T,k);T[0]=(M=(d=F-(f=(p=b*F)-(p-F)))*(y=c-(m=(p=b*c)-(p-c)))-((A=F*c)-f*m-d*m-f*y))-((g=M-(V=(d=L-(f=(p=b*L)-(p-L)))*(y=u-(m=(p=b*u)-(p-u)))-((B=L*u)-f*m-d*m-f*y)))+(h=M-g))+(h-V),T[1]=(v=A-((x=A+g)-(h=x-A))+(g-h))-((g=v-B)+(h=v-g))+(h-B),T[2]=x-((C=x+g)-(h=C-x))+(g-h),T[3]=C;var j=_(N,k,4,T,P);T[0]=(M=(d=a-(f=(p=b*a)-(p-a)))*(y=c-(m=(p=b*c)-(p-c)))-((A=a*c)-f*m-d*m-f*y))-((g=M-(V=(d=l-(f=(p=b*l)-(p-l)))*(y=u-(m=(p=b*u)-(p-u)))-((B=l*u)-f*m-d*m-f*y)))+(h=M-g))+(h-V),T[1]=(v=A-((x=A+g)-(h=x-A))+(g-h))-((g=v-B)+(h=v-g))+(h-B),T[2]=x-((C=x+g)-(h=C-x))+(g-h),T[3]=C;var $=_(j,P,4,T,E);return E[$-1]}(t,e,r,n,i,s,u)}(t[0],t[1],e[0],e[1],r[0],r[1]);return n>0?-1:n<0?1:0}function V(t,e){var r=t.point,n=e.point;return r[0]>n[0]?1:r[0]<n[0]?-1:r[1]!==n[1]?r[1]>n[1]?1:-1:function(t,e,r,n){return t.left!==e.left?t.left?1:-1:0!==B(r,t.otherEvent.point,e.otherEvent.point)?t.isBelow(e.otherEvent.point)?-1:1:!t.isSubject&&e.isSubject?1:-1}(t,e,r)}function C(t,e,r){var n=new y(e,!1,t,t.isSubject),i=new y(e,!0,t.otherEvent,t.isSubject);return x(t.point,t.otherEvent.point)&&console.warn("what is that, a collapsed segment?",t),n.contourId=i.contourId=t.contourId,V(i,t.otherEvent)>0&&(t.otherEvent.left=!0,i.left=!1),t.otherEvent.otherEvent=i,t.otherEvent=n,r.push(i),r.push(n),r}function F(t,e){return t[0]*e[1]-t[1]*e[0]}function D(t,e){return t[0]*e[0]+t[1]*e[1]}function L(t,e,r){var n=function(t,e,r,n,i){var s=[e[0]-t[0],e[1]-t[1]],o=[n[0]-r[0],n[1]-r[1]];function a(t,e,r){return [t[0]+e*r[0],t[1]+e*r[1]]}var l=[r[0]-t[0],r[1]-t[1]],u=F(s,o),c=u*u,h=D(s,s);if(c>0){var p=F(l,o)/u;if(p<0||p>1)return null;var f=F(l,s)/u;return f<0||f>1?null:0===p||1===p?[a(t,p,s)]:0===f||1===f?[a(r,f,o)]:[a(t,p,s)]}if((c=(u=F(l,s))*u)>0)return null;var d=D(s,l)/h,m=d+D(s,o)/h,y=Math.min(d,m),g=Math.max(d,m);return y<=1&&g>=0?1===y?[a(t,y>0?y:0,s)]:0===g?[a(t,g<1?g:1,s)]:[a(t,y>0?y:0,s),a(t,g<1?g:1,s)]:null}(t.point,t.otherEvent.point,e.point,e.otherEvent.point),i=n?n.length:0;if(0===i)return 0;if(1===i&&(x(t.point,e.point)||x(t.otherEvent.point,e.otherEvent.point)))return 0;if(2===i&&t.isSubject===e.isSubject)return 0;if(1===i)return x(t.point,n[0])||x(t.otherEvent.point,n[0])||C(t,n[0],r),x(e.point,n[0])||x(e.otherEvent.point,n[0])||C(e,n[0],r),1;var s=[],o=!1,c=!1;return x(t.point,e.point)?o=!0:1===V(t,e)?s.push(e,t):s.push(t,e),x(t.otherEvent.point,e.otherEvent.point)?c=!0:1===V(t.otherEvent,e.otherEvent)?s.push(e.otherEvent,t.otherEvent):s.push(t.otherEvent,e.otherEvent),o&&c||o?(e.type=a,t.type=e.inOut===t.inOut?l:u,o&&!c&&C(s[1].otherEvent,s[0].point,r),2):c?(C(s[0],s[1].point,r),3):s[0]!==s[3].otherEvent?(C(s[0],s[1].point,r),C(s[1],s[2].point,r),3):(C(s[0],s[1].point,r),C(s[3].otherEvent,s[2].point,r),3)}function R(t,e){if(t===e)return 0;if(0!==B(t.point,t.otherEvent.point,e.point)||0!==B(t.point,t.otherEvent.point,e.otherEvent.point))return x(t.point,e.point)?t.isBelow(e.otherEvent.point)?-1:1:t.point[0]===e.point[0]?t.point[1]<e.point[1]?-1:1:1===V(t,e)?e.isAbove(t.point)?-1:1:t.isBelow(e.point)?-1:1;if(t.isSubject!==e.isSubject)return t.isSubject?-1:1;var r=t.point,n=e.point;return r[0]===n[0]&&r[1]===n[1]?(r=t.otherEvent.point)[0]===(n=e.otherEvent.point)[0]&&r[1]===n[1]?0:t.contourId>e.contourId?1:-1:1===V(t,e)?1:-1}var O=function(){this.points=[],this.holeIds=[],this.holeOf=null,this.depth=null;};function U(t,e,r,n){var i,s=t+1,o=e[t].point,a=e.length;for(s<a&&(i=e[s].point);s<a&&i[0]===o[0]&&i[1]===o[1];){if(!r[s])return s;++s<a&&(i=e[s].point);}for(s=t-1;r[s]&&s>n;)s--;return s}O.prototype.isExterior=function(){return null==this.holeOf};var N=$,j=$;function $(t,e){if(!(this instanceof $))return new $(t,e);if(this.data=t||[],this.length=this.data.length,this.compare=e||G,this.length>0)for(var r=(this.length>>1)-1;r>=0;r--)this._down(r);}function G(t,e){return t<e?-1:t>e?1:0}$.prototype={push:function(t){this.data.push(t),this.length++,this._up(this.length-1);},pop:function(){if(0!==this.length){var t=this.data[0];return this.length--,this.length>0&&(this.data[0]=this.data[this.length],this._down(0)),this.data.pop(),t}},peek:function(){return this.data[0]},_up:function(t){for(var e=this.data,r=this.compare,n=e[t];t>0;){var i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;},_down:function(t){for(var e=this.data,r=this.compare,n=this.length>>1,i=e[t];t<n;){var s=1+(t<<1),o=s+1,a=e[s];if(o<this.length&&r(e[o],a)<0&&(s=o,a=e[o]),r(a,i)>=0)break;e[t]=a,t=s;}e[t]=i;}},N.default=j;var q=Math.max,H=Math.min,X=0;function Z(t,e,r,n,i,s){var o,a,l,u,c,h;for(o=0,a=t.length-1;o<a;o++)if(u=t[o+1],c=new y(l=t[o],!1,void 0,e),h=new y(u,!1,c,e),c.otherEvent=h,l[0]!==u[0]||l[1]!==u[1]){c.contourId=h.contourId=r,s||(c.isExteriorRing=!1,h.isExteriorRing=!1),V(c,h)>0?h.left=!0:c.left=!0;var p=l[0],f=l[1];i[0]=H(i[0],p),i[1]=H(i[1],f),i[2]=q(i[2],p),i[3]=q(i[3],f),n.push(c),n.push(h);}}var W=[];function Y(t,e,n){"number"==typeof t[0][0][0]&&(t=[t]),"number"==typeof e[0][0][0]&&(e=[e]);var i=function(t,e,r){var n=null;return t.length*e.length==0&&(r===c?n=W:r===p?n=t:r!==h&&r!==f||(n=0===t.length?e:t)),n}(t,e,n);if(i)return i===W?null:i;var s=[1/0,1/0,-1/0,-1/0],o=[1/0,1/0,-1/0,-1/0],a=function(t,e,r,n,i){var s,o,a,l,u,c,h=new N(null,V);for(a=0,l=t.length;a<l;a++)for(u=0,c=(s=t[a]).length;u<c;u++)(o=0===u)&&X++,Z(s[u],!0,X,h,r,o);for(a=0,l=e.length;a<l;a++)for(u=0,c=(s=e[a]).length;u<c;u++)o=0===u,i===p&&(o=!1),o&&X++,Z(s[u],!1,X,h,n,o);return h}(t,e,s,o,n);if(i=function(t,e,r,n,i){var s=null;return (r[0]>n[2]||n[0]>r[2]||r[1]>n[3]||n[1]>r[3])&&(i===c?s=W:i===p?s=t:i!==h&&i!==f||(s=t.concat(e))),s}(t,e,s,o,n))return i===W?null:i;for(var l=function(t){var e,r,n=function(t){var e,r,n,i,s=[];for(r=0,n=t.length;r<n;r++)((e=t[r]).left&&e.inResult||!e.left&&e.otherEvent.inResult)&&s.push(e);for(var o=!1;!o;)for(o=!0,r=0,n=s.length;r<n;r++)r+1<n&&1===V(s[r],s[r+1])&&(i=s[r],s[r]=s[r+1],s[r+1]=i,o=!1);for(r=0,n=s.length;r<n;r++)(e=s[r]).otherPos=r;for(r=0,n=s.length;r<n;r++)(e=s[r]).left||(i=e.otherPos,e.otherPos=e.otherEvent.otherPos,e.otherEvent.otherPos=i);return s}(t),i={},s=[],o=function(){if(!i[e]){var t=s.length,r=function(t,e,r){var n=new O;if(null!=t.prevInResult){var i=t.prevInResult,s=i.outputContourId;if(i.resultTransition>0){var o=e[s];if(null!=o.holeOf){var a=o.holeOf;e[a].holeIds.push(r),n.holeOf=a,n.depth=e[s].depth;}else e[s].holeIds.push(r),n.holeOf=s,n.depth=e[s].depth+1;}else n.holeOf=null,n.depth=e[s].depth;}else n.holeOf=null,n.depth=0;return n}(n[e],s,t),o=function(e){i[e]=!0,e<n.length&&n[e]&&(n[e].outputContourId=t);},a=e,l=e;for(r.points.push(n[e].point);o(a),o(a=n[a].otherPos),r.points.push(n[a].point),!((a=U(a,n,i,l))==l||a>=n.length)&&n[a];);s.push(r);}};for(e=0,r=n.length;e<r;e++)o();return s}(function(t,e,n,i,s,o){for(var a,l,u,h=new r(R),f=[],m=Math.min(i[2],s[2]);0!==t.length;){var y=t.pop();if(f.push(y),o===c&&y.point[0]>m||o===p&&y.point[0]>i[2])break;if(y.left){l=a=h.insert(y),a=a!==(u=h.minNode())?h.prev(a):null,l=h.next(l);var g=a?a.key:null;if(d(y,g,o),l&&2===L(y,l.key,t)&&(d(y,g,o),d(l.key,y,o)),a&&2===L(a.key,y,t)){var x=a;d(g,(x=x!==u?h.prev(x):null)?x.key:null,o),d(y,g,o);}}else l=a=h.find(y=y.otherEvent),a&&l&&(a=a!==u?h.prev(a):null,l=h.next(l),h.remove(y),l&&a&&L(a.key,l.key,t));}return f}(a,0,0,s,o,n)),u=[],m=0;m<l.length;m++){var y=l[m];if(y.isExterior()){for(var g=[y.points],x=0;x<y.holeIds.length;x++)g.push(l[y.holeIds[x]].points);u.push(g);}}return u}var K={UNION:h,DIFFERENCE:p,INTERSECTION:c,XOR:f};t.diff=function(t,e){return Y(t,e,p)},t.intersection=function(t,e){return Y(t,e,c)},t.operations=K,t.union=function(t,e){return Y(t,e,h)},t.xor=function(t,e){return Y(t,e,f)},Object.defineProperty(t,"__esModule",{value:!0});}(e);}(0,sp.exports)),sp.exports);
    /**
     * martinez v0.7.4
     * Martinez polygon clipping algorithm, does boolean operation on polygons (multipolygons, polygons with holes etc): intersection, union, difference, xor
     *
     * @author Alex Milevski <info@w8r.name>
     * @license MIT
     * @preserve
     */function ap(t,e,r,n){const i=[],s=0===n?(t,e,r,n,i,s)=>{t.push(new bt(s,r+(s-e)/(n-e)*(i-r)));}:(t,e,r,n,i,s)=>{t.push(new bt(e+(s-r)/(i-r)*(n-e),s));};for(const o of t){const t=[];for(const i of o){if(i.length<=2)continue;const o=[];for(let t=0;t<i.length-1;t++){const a=i[t].x,l=i[t].y,u=i[t+1].x,c=i[t+1].y,h=0===n?a:l,p=0===n?u:c;h<e?p>e&&s(o,a,l,u,c,e):h>r?p<r&&s(o,a,l,u,c,r):o.push(i[t]),p<e&&h>=e&&s(o,a,l,u,c,e),p>r&&h<=r&&s(o,a,l,u,c,r);}let a=i[i.length-1];const l=0===n?a.x:a.y;l>=e&&l<=r&&o.push(a),o.length&&(a=o[o.length-1],o[0].x===a.x&&o[0].y===a.y||o.push(o[0]),t.push(o));}t.length&&i.push(t);}return i}function lp(t,e){const r=cp(t),n=cp([e]),i=op.intersection(r,n);return null==i?[]:hp(i)}function up(t,e){const r=65536;let n=cp(t,r);for(;e.valid();e.next()){const[t,i]=e.get(),s=t.x*r,o=t.y*r,a=i.x*r,l=i.y*r,u=a-s,c=l-o,h=Math.hypot(u,c),p=Math.trunc(c/h*3),f=-Math.trunc(u/h*3);n=op.diff(n,[[[s,o],[a,l],[a+p,l+f],[s+p,o+f],[s,o]]]);}return hp(n,1/r)}function cp(t,e=1){return [t.map((t=>t.map((t=>[t.x*e,t.y*e]))))]}function hp(t,e=1){return t.map((t=>t.map(((t,r)=>{const n=t.map((t=>new bt(t[0]*e,t[1]*e).round()));return r>0&&n.reverse(),n}))))}class pp{constructor(t,e){this.layoutVertexArray=new ra,this.indexArray=new Aa,this.lineIndexArray=new xa,this.triangleSegments=new tl,this.lineSegments=new tl,this.programConfigurations=new kl(t.layers,{zoom:t.zoom,lut:t.lut}),this.uploaded=!1,e&&(this.elevatedLayoutVertexArray=new sa);}update(t,e,r,n,i,s,o,a){this.programConfigurations.updatePaintArrays(t,e,i,r,n,s,o,a);}isEmpty(){return 0===this.layoutVertexArray.length}needsUpload(){return this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,vh.members),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.lineIndexBuffer=t.createIndexBuffer(this.lineIndexArray),this.elevatedLayoutVertexArray&&this.elevatedLayoutVertexArray.length>0&&(this.elevatedLayoutVertexBuffer=t.createVertexBuffer(this.elevatedLayoutVertexArray,bh.members))),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.elevatedLayoutVertexBuffer&&this.elevatedLayoutVertexBuffer.destroy(),this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.lineIndexBuffer.destroy(),this.programConfigurations.destroy(),this.triangleSegments.destroy(),this.lineSegments.destroy());}populatePaintArrays(t,e,r,n,i,s,o){this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,e,r,n,i,s,void 0,o);}}class fp{constructor(t){this.zoom=t.zoom,this.pixelRatio=t.pixelRatio,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.lut=t.lut,this.bufferData=new pp(t,!1),this.elevationBufferData=new pp(t,!0),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.projection=t.projection,this.elevationMode=this.layers[0].layout.get("fill-elevation-reference"),this.sourceLayerIndex=t.sourceLayerIndex,this.worldview=t.worldview;}updateFootprints(t,e){}populate(t,e,r,n){this.hasPattern=Jh("fill",this.layers,this.pixelRatio,e);const i=this.layers[0].layout.get("fill-sort-key"),s=[];for(const{feature:o,id:a,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=gu(o,t);if(!this.layers[0]._featureFilter.filter(new go(this.zoom,{worldview:this.worldview}),c,r))continue;const h=i?i.evaluate(c,{},r,e.availableImages):void 0,p={id:a,properties:o.properties,type:o.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:yu(o,r,n),patterns:{},sortKey:h};s.push(p);}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:o}=n;if(this.hasPattern){const t=Qh("fill",this.layers,n,this.zoom,this.pixelRatio,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,{},e.availableImages,e.brightness,e.elevationFeatures);e.featureIndex.insert(t[s].feature,i,s,o,this.index);}}update(t,e,r,n,i,s,o){this.bufferData.update(t,e,r,n,i,s,o,this.worldview),this.elevationBufferData.update(t,e,r,n,i,s,o,this.worldview),this.elevatedStructures&&this.elevatedStructures.update(t,e,r,n,i,s,o,this.worldview);}addFeatures(t,e,r,n,i,s){for(const i of this.patternFeatures)this.addFeature(i,i.geometry,i.index,e,r,n,s,t.elevationFeatures);}isEmpty(){return this.bufferData.isEmpty()&&this.elevationBufferData.isEmpty()}uploadPending(){return !this.uploaded||this.bufferData.needsUpload()||this.elevationBufferData.needsUpload()}upload(t){this.bufferData.upload(t),this.elevationBufferData.upload(t),this.elevatedStructures&&this.elevatedStructures.upload(t);}destroy(){this.bufferData.destroy(),this.elevationBufferData.destroy(),this.elevatedStructures&&this.elevatedStructures.destroy();}addFeature(t,e,r,n,i,s=[],o,a){const l=Wh(e,500);"none"!==this.elevationMode?this.addElevatedRoadFeature(t,l,n,r,a):this.addGeometry(l,this.bufferData),this.bufferData.populatePaintArrays(t,r,i,s,n,o,this.worldview),this.elevationBufferData.populatePaintArrays(t,r,i,s,n,o,this.worldview);}getUnevaluatedPortalGraph(){return this.elevatedStructures?this.elevatedStructures.unevaluatedPortals:void 0}getElevationPolygons(){return this.elevatedStructures?this.elevatedStructures.portalPolygons:void 0}setEvaluatedPortalGraph(t,e,r,n,i){this.elevatedStructures&&(this.elevatedStructures.construct(t),this.elevatedStructures.populatePaintArrays(e,r,n,i,this.worldview));}addElevatedRoadFeature(t,e,r,n,i){const s=new Array,o=Zu.getElevationFeature(t,i);if(!o)return void this.addGeometry(e,this.bufferData);{const t=this.clipPolygonsToTile(e,1);t.length>0&&s.push({polygons:t,elevationFeature:o,elevationTileID:r});}const a={guardRailEnabled:this.layers[0].layout.get("fill-construct-bridge-guard-rail").evaluate(t,{},r),featureIndex:n};for(const e of s)if(e.elevationFeature){if("hd-road-base"===this.elevationMode){this.elevatedStructures||(this.elevatedStructures=new np(e.elevationTileID,this.layers,this.zoom,this.lut));const r=e.elevationFeature.isTunnel();let n=0;t.properties.hasOwnProperty(Tu)&&(n=+t.properties[Tu]);for(const t of e.polygons)this.elevatedStructures.addPortalCandidates(e.elevationFeature.id,t,r,e.elevationFeature,n);}null==e.elevationFeature.constantHeight&&(e.polygons=this.prepareElevatedPolygons(e.polygons,e.elevationFeature,e.elevationTileID));const i=new Wu(r,e.elevationTileID);this.addElevatedGeometry(e.polygons,i,e.elevationFeature,"hd-road-base"===this.elevationMode?0:.05,n,a);}}addElevatedGeometry(t,e,r,n,i,s){const o={elevation:r,elevationSampler:e,bias:n,index:i,featureInfo:s},[a,l]=this.addGeometry(t,this.elevationBufferData,o);null==this.elevationBufferData.heightRange?this.elevationBufferData.heightRange={min:a,max:l}:(this.elevationBufferData.heightRange.min=Math.min(this.elevationBufferData.heightRange.min,a),this.elevationBufferData.heightRange.max=Math.max(this.elevationBufferData.heightRange.max,l));}addGeometry(t,e,r){let n=Number.POSITIVE_INFINITY,i=Number.NEGATIVE_INFINITY,s=null;r&&(s=r.elevationSampler.constantElevation(r.elevation,r.bias),null!=s&&(n=s,i=s));const o=(t,o,a)=>{if(null!=r)if(o.push(t),null!=s)e.elevatedLayoutVertexArray.emplaceBack(s),a.push(s);else {const s=r.elevationSampler.pointElevation(t,r.elevation,r.bias);e.elevatedLayoutVertexArray.emplaceBack(s),a.push(s),n=Math.min(n,s),i=Math.max(i,s);}};for(const n of t){let t=0;for(const e of n)t+=e.length;const i=e.triangleSegments.prepareSegment(t,e.layoutVertexArray,e.indexArray),s=i.vertexLength,a=[],l=[],u=[],c=[],h=[],p=e.layoutVertexArray.length;for(const t of n){if(0===t.length)continue;t!==n[0]&&l.push(a.length/2);const i=e.lineSegments.prepareSegment(t.length,e.layoutVertexArray,e.lineIndexArray),s=i.vertexLength;r&&h.push(e.layoutVertexArray.length-p),o(t[0],u,c),e.layoutVertexArray.emplaceBack(t[0].x,t[0].y),e.lineIndexArray.emplaceBack(s+t.length-1,s),a.push(t[0].x),a.push(t[0].y);for(let r=1;r<t.length;r++)o(t[r],u,c),e.layoutVertexArray.emplaceBack(t[r].x,t[r].y),e.lineIndexArray.emplaceBack(s+r-1,s+r),a.push(t[r].x),a.push(t[r].y);i.vertexLength+=t.length,i.primitiveLength+=t.length;}const f=Ah(a,l);for(let t=0;t<f.length;t+=3)e.indexArray.emplaceBack(s+f[t],s+f[t+1],s+f[t+2]);if(f.length>0&&r&&"hd-road-base"===this.elevationMode){const t=r.elevation.isTunnel(),e=r.elevation.safeArea,n=this.elevatedStructures.addVertices(u,c);this.elevatedStructures.addTriangles(f,n,t);const i=h.length;if(i>0){for(let s=0;s<i-1;s++)this.elevatedStructures.addRenderableRing(r.index,h[s]+n,h[s+1]-h[s],t,e,r.featureInfo);this.elevatedStructures.addRenderableRing(r.index,h[i-1]+n,u.length-h[i-1],t,e,r.featureInfo);}}i.vertexLength+=t,i.primitiveLength+=f.length/3;}return [n,i]}prepareElevatedPolygons(t,e,r){const n=1/au(r),i=[];for(const r of t){const t=up(r,new Hu(e,n));i.push(...t);}return i}clipPolygonsToTile(t,e){const r=-e,n=-e,i=Cn+e,s=Cn+e;let o=0;const a=[],l=[];for(;o<t.length;o++){const e=t[o],u=pn(e);(u.min.x>=r&&u.max.x<=i&&u.min.y>=n&&u.max.y<=s?a:l).push(e);}if(a.length===t.length)return t;const u=[new bt(r,n),new bt(i,n),new bt(i,s),new bt(r,s),new bt(r,n)],c=a;for(const t of l)c.push(...lp(t,u));return c}}let dp,mp,yp,gp;qs(fp,"FillBucket",{omit:["layers","patternFeatures"]}),qs(pp,"FillBufferData"),qs(np,"ElevatedStructures");class xp{constructor(t,e,r,n){if(this.triangleCount=e.length/3,this.min=new bt(0,0),this.max=new bt(0,0),this.xScale=0,this.yScale=0,this.cellsX=0,this.cellsY=0,this.cells=[],this.payload=[],0===this.triangleCount||0===t.length)return;const[i,s]=[t[0].clone(),t[0].clone()];for(let e=1;e<t.length;++e){const r=t[e];i.x=Math.min(i.x,r.x),i.y=Math.min(i.y,r.y),s.x=Math.max(s.x,r.x),s.y=Math.max(s.y,r.y);}if(n){const t=Math.ceil(Math.max(s.x-i.x,s.y-i.y)/n);r=Math.max(r,t);}if(0===r)return;this.min=i,this.max=s;const o=this.max.sub(this.min);o.x=Math.max(o.x,1),o.y=Math.max(o.y,1);const a=Math.max(o.x,o.y)/r;this.cellsX=Math.max(1,Math.ceil(o.x/a)),this.cellsY=Math.max(1,Math.ceil(o.y/a)),this.xScale=1/a,this.yScale=1/a;const l=[];for(let r=0;r<this.triangleCount;r++){const n=t[e[3*r+0]].sub(this.min),i=t[e[3*r+1]].sub(this.min),s=t[e[3*r+2]].sub(this.min),o=vp(Math.floor(Math.min(n.x,i.x,s.x)),this.xScale,this.cellsX),u=vp(Math.floor(Math.max(n.x,i.x,s.x)),this.xScale,this.cellsX),c=vp(Math.floor(Math.min(n.y,i.y,s.y)),this.yScale,this.cellsY),h=vp(Math.floor(Math.max(n.y,i.y,s.y)),this.yScale,this.cellsY),p=new bt(0,0),f=new bt(0,0),d=new bt(0,0),m=new bt(0,0);for(let t=c;t<=h;++t){p.y=f.y=t*a,d.y=m.y=(t+1)*a;for(let e=o;e<=u;++e)p.x=d.x=e*a,f.x=m.x=(e+1)*a,(pc(n,i,s,p,f,m)||pc(n,i,s,p,m,d))&&l.push({cellIdx:t*this.cellsX+e,triIdx:r});}}if(0===l.length)return;l.sort(((t,e)=>t.cellIdx-e.cellIdx||t.triIdx-e.triIdx));let u=0;for(;u<l.length;){const t=l[u].cellIdx,e={start:this.payload.length,len:0};for(;u<l.length&&l[u].cellIdx===t;)++e.len,this.payload.push(l[u++].triIdx);this.cells[t]=e;}}_lazyInitLookup(){this.lookup||(this.lookup=new Uint8Array(Math.ceil(this.triangleCount/8))),this.lookup.fill(0);}queryPoint(t,e){if(0===this.triangleCount||0===this.cells.length)return;if(t.x>this.max.x||this.min.x>t.x||t.y>this.max.y||this.min.y>t.y)return;const r=vp(t.x-this.min.x,this.xScale,this.cellsX),n=vp(t.y-this.min.y,this.yScale,this.cellsY),i=this.cells[n*this.cellsX+r];if(i){this._lazyInitLookup();for(let t=0;t<i.len;t++){const r=this.payload[i.start+t],n=Math.floor(r/8),s=1<<r%8;if(!(this.lookup[n]&s)&&(this.lookup[n]|=s,e.push(r),e.length===this.triangleCount))return}}}query(t,e,r){if(0===this.triangleCount||0===this.cells.length)return;if(t.x>this.max.x||this.min.x>e.x)return;if(t.y>this.max.y||this.min.y>e.y)return;this._lazyInitLookup();const n=vp(t.x-this.min.x,this.xScale,this.cellsX),i=vp(e.x-this.min.x,this.xScale,this.cellsX),s=vp(t.y-this.min.y,this.yScale,this.cellsY),o=vp(e.y-this.min.y,this.yScale,this.cellsY);for(let t=s;t<=o;t++)for(let e=n;e<=i;e++){const n=this.cells[t*this.cellsX+e];if(n)for(let t=0;t<n.len;t++){const e=this.payload[n.start+t],i=Math.floor(e/8),s=1<<e%8;if(!(this.lookup[i]&s)&&(this.lookup[i]|=s,r.push(e),r.length===this.triangleCount))return}}}}function vp(t,e,r){return Math.max(0,Math.min(r-1,Math.floor(t*e)))}qs(xp,"TriangleGridIndex");class bp{constructor(t){this.zoom=t.zoom,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.footprints=[],this.worldview=t.worldview;}updateFootprints(t,e){for(const r of this.footprints)e.push({footprint:r,id:t});}populate(t,e,r,n){const i=[];for(const{feature:e,id:s,index:o,sourceLayerIndex:a}of t){const t=this.layers[0]._featureFilter.needGeometry,l=gu(e,t);if(!this.layers[0]._featureFilter.filter(new go(this.zoom,{worldview:this.worldview}),l,r))continue;const u={id:s,properties:e.properties,type:e.type,sourceLayerIndex:a,index:o,geometry:t?l.geometry:yu(e,r,n),patterns:{}};i.push(u);}for(const n of i){const{geometry:i,index:s,sourceLayerIndex:o}=n;this.addFeature(n,i,s,r,{},e.availableImages,e.brightness),e.featureIndex.insert(t[s].feature,i,s,o,this.index);}}isEmpty(){return 0===this.footprints.length}uploadPending(){return !1}upload(t){}update(t,e,r,n,i,s,o){}destroy(){}addFeature(t,e,r,n,i,s=[],o){for(const t of Wh(e,2)){const e=[],r=[],n=[],i=new bt(1/0,1/0),s=new bt(-1/0,-1/0);for(const o of t)if(0!==o.length){o!==t[0]&&n.push(r.length/2);for(let t=0;t<o.length;t++)r.push(o[t].x),r.push(o[t].y),e.push(o[t]),i.x=Math.min(i.x,o[t].x),i.y=Math.min(i.y,o[t].y),s.x=Math.max(s.x,o[t].x),s.y=Math.max(s.y,o[t].y);}const o=Ah(r,n),a=new xp(e,o,8,256);this.footprints.push({vertices:e,indices:o,grid:a,min:i,max:s});}}}qs(bp,"ClipBucket",{omit:["layers"]});const wp=ta([{name:"a_pos_normal_ed",components:4,type:"Int16"}]),_p=ta([{name:"a_pos_end",components:4,type:"Int16"},{name:"a_angular_offset_factor",components:1,type:"Int16"}]),Ap=ta([{name:"a_centroid_pos",components:2,type:"Uint16"}]),Mp=ta([{name:"a_join_normal_inside",components:3,type:"Int16"}]),Ip=ta([{name:"a_hidden_by_landmark",components:1,type:"Uint8"}]),Sp=ta([{name:"a_pos_3",components:3,type:"Int16"},{name:"a_pos_normal_3",components:3,type:"Int16"}]),{members:zp}=wp,kp=Number.MAX_SAFE_INTEGER;function Pp(t,e,r,n){return t.order<e||t.order===kp||!(t.clipMask&r)||function(t,e){return 0!==e.length&&void 0===e.find((e=>e===t))}(n,t.clipScope)}function Ep(t,e){return t.x-e.x||t.y-e.y}function Tp(t,e){return 0===Ep(t.min,e.min)&&0===Ep(t.max,e.max)}function Bp(t,e){return !(t.min.x>e.max.x||t.max.x<e.min.x||t.min.y>e.max.y||t.max.y<e.min.y)}function Vp(t,e){if(t.length!==e.length)return !1;for(let r=0;r<t.length;r++)if(t[r].sourceId!==e[r].sourceId||!Tp(t[r],e[r])||t[r].order!==e[r].order||t[r].clipMask!==e[r].clipMask||!wt(t[r].clipScope,e[r].clipScope))return !1;return !0}function Cp(t,e,r){const n=1/Cn,i=1/(1<<r.canonical.z),s=(e.x*n+r.canonical.x)*i+r.wrap,o=(e.y*n+r.canonical.y)*i;return {min:new bt((t.x*n+r.canonical.x)*i+r.wrap,(t.y*n+r.canonical.y)*i),max:new bt(s,o)}}function Fp(t,e,r){const n=1<<r.canonical.z,i=((e.x-r.wrap)*n-r.canonical.x)*Cn,s=(e.y*n-r.canonical.y)*Cn;return {min:new bt(((t.x-r.wrap)*n-r.canonical.x)*Cn,(t.y*n-r.canonical.y)*Cn),max:new bt(i,s)}}function Dp(t,e,r,n,i,s,o){const a=t.indices,l=t.vertices,u=[];for(let c=n;c<n+i;c+=3){const n=e[r[c+0]+s],i=e[r[c+1]+s],h=e[r[c+2]+s],p=Math.min(n.x,i.x,h.x),f=Math.max(n.x,i.x,h.x),d=Math.min(n.y,i.y,h.y),m=Math.max(n.y,i.y,h.y);u.length=0,t.grid.query(new bt(p,d),new bt(f,m),u);for(let t=0;t<u.length;t++){const e=u[t];if(pc(l[a[3*e+0]],l[a[3*e+1]],l[a[3*e+2]],n,i,h,o))return !0}}return !1}function Lp(t,e,r,n){if(!t||!r)return !1;let i=t.vertices;if(!e.canonical.equals(n.canonical)||e.wrap!==n.wrap){if(r.vertices.length<t.vertices.length)return Lp(r,n,t,e);const s=e.canonical,o=n.canonical,a=Math.pow(2,o.z-s.z);i=t.vertices.map((t=>new bt((t.x+s.x*Cn)*a-o.x*Cn,(t.y+s.y*Cn)*a-o.y*Cn)));}return Dp(r,i,t.indices,0,t.indices.length,0,0)}function Rp(t,e,r,n){const i=Math.pow(2,n.z-r.z);return new bt((t+r.x*Cn)*i-n.x*Cn,(e+r.y*Cn)*i-n.y*Cn)}function Op(t,e){const r=[];e.grid.queryPoint(t,r);const n=e.indices,i=e.vertices;for(let e=0;e<r.length;e++){const s=r[e];if(lc([i[n[3*s+0]],i[n[3*s+1]],i[n[3*s+2]]],t))return !0}return !1}const Up=[new bt(0,0),new bt(Cn,0),new bt(Cn,Cn),new bt(0,Cn)];function Np(t,e){const r=[];let n=[];if(!e||t.length<2)return [t];if(2===t.length)return cc(t[0],t[1],Up)?[t]:[];for(let e=0;e<t.length+2;e++){const i=t[e%t.length],s=t[(e+1)%t.length],o=cc(0===e?t[t.length-1]:t[(e-1)%t.length],i,Up),a=cc(i,s,Up),l=o||a;l&&n.push(i),l&&a||n.length>0&&(n.length>1&&r.push(n),n=[]);}return n.length>1&&r.push(n),r}const jp=Pu.VectorTileFeature.types,$p=["fill-extrusion-base","fill-extrusion-height","fill-extrusion-color","fill-extrusion-pattern","fill-extrusion-flood-light-wall-radius","fill-extrusion-line-width","fill-extrusion-emissive-strength"],Gp=["fill-extrusion-flood-light-ground-radius"],qp=Math.pow(2,13),Hp=Math.pow(2,15)-1,Xp=new bt(0,1),Zp=2147483648;function Wp(t,e,r,n,i,s,o,a){t.emplaceBack((e<<1)+o,(r<<1)+s,(Math.floor(n*qp)<<1)+i,Math.round(a));}function Yp(t,e,r){t.emplaceBack(e.x*Cn,e.y*Cn,r?1:0);}function Kp(t,e,r,n,i,s){t.emplaceBack(e.x,e.y,(r.x<<1)+n,(r.y<<1)+i,s);}function Jp(t,e,r){const n=16384;t.emplaceBack(e.x,e.y,e.z,r[0]*n,r[1]*n,r[2]*n);}class Qp{constructor(){this.vertexOffset=0,this.vertexCount=0,this.indexOffset=0,this.indexCount=0;}}class tf{constructor(){this.centroidXY=new bt(0,0),this.vertexArrayOffset=0,this.vertexCount=0,this.groundVertexArrayOffset=0,this.groundVertexCount=0,this.flags=0,this.footprintSegIdx=-1,this.footprintSegLen=0,this.polygonSegIdx=-1,this.polygonSegLen=0,this.min=new bt(Number.MAX_VALUE,Number.MAX_VALUE),this.max=new bt(-Number.MAX_VALUE,-Number.MAX_VALUE),this.height=0;}span(){return new bt(this.max.x-this.min.x,this.max.y-this.min.y)}}class ef{constructor(){this.acc=new bt(0,0),this.accCount=0,this.centroidDataIndex=0;}startRing(t,e){t.min.x===Number.MAX_VALUE&&(t.min.x=t.max.x=e.x,t.min.y=t.max.y=e.y);}appendEdge(t,e,r){this.accCount++,this.acc._add(e);let n=!!this.borders;e.x<t.min.x?(t.min.x=e.x,n=!0):e.x>t.max.x&&(t.max.x=e.x,n=!0),e.y<t.min.y?(t.min.y=e.y,n=!0):e.y>t.max.y&&(t.max.y=e.y,n=!0),((0===e.x||e.x===Cn)&&e.x===r.x)!=((0===e.y||e.y===Cn)&&e.y===r.y)&&this.processBorderOverlap(e,r),n&&this.checkBorderIntersection(e,r);}checkBorderIntersection(t,e){e.x<0!=t.x<0&&this.addBorderIntersection(0,ur(e.y,t.y,(0-e.x)/(t.x-e.x))),e.x>Cn!=t.x>Cn&&this.addBorderIntersection(1,ur(e.y,t.y,(Cn-e.x)/(t.x-e.x))),e.y<0!=t.y<0&&this.addBorderIntersection(2,ur(e.x,t.x,(0-e.y)/(t.y-e.y))),e.y>Cn!=t.y>Cn&&this.addBorderIntersection(3,ur(e.x,t.x,(Cn-e.y)/(t.y-e.y)));}addBorderIntersection(t,e){this.borders||(this.borders=[[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE]]);const r=this.borders[t];e<r[0]&&(r[0]=e),e>r[1]&&(r[1]=e);}processBorderOverlap(t,e){if(t.x===e.x){if(t.y===e.y)return;const r=0===t.x?0:1;this.addBorderIntersection(r,e.y),this.addBorderIntersection(r,t.y);}else {const r=0===t.y?2:3;this.addBorderIntersection(r,e.x),this.addBorderIntersection(r,t.x);}}centroid(){return 0===this.accCount?new bt(0,0):new bt(Math.floor(Math.max(0,this.acc.x)/this.accCount),Math.floor(Math.max(0,this.acc.y)/this.accCount))}intersectsCount(){return this.borders?this.borders.reduce(((t,e)=>t+ +(e[0]!==Number.MAX_VALUE)),0):0}}function rf(t,e){const r=t.add(e)._unit(),n=Et(t.x*r.x+t.y*r.y,-1,1);var i,s,o;return i=Math.acos(n),Math.min(4,Math.max(-4,Math.tan(i)))/4*Hp*((s=t).x*(o=e).y-s.y*o.x<0?-1:1)}const nf=[t=>t.x<0,t=>t.x>Cn,t=>t.y<0,t=>t.y>Cn];function sf(t,e,r,n){const i=[4];if(0===n)return i;r._mult(n);const s=t.sub(r),o=e.sub(r),a=[t,e,s,o];for(let t=0;t<4;t++)for(const e of a)if(nf[t](e)){i.push(t);break}return i}class of{constructor(t){this.vertexArray=new la,this.indexArray=new Aa,this.programConfigurations=new kl(t.layers,{zoom:t.zoom,lut:t.lut},(t=>Gp.includes(t))),this._segments=new tl,this.hiddenByLandmarkVertexArray=new La,this._segmentToGroundQuads={},this._segmentToGroundQuads[0]=[],this._segmentToRegionTriCounts={},this._segmentToRegionTriCounts[0]=[0,0,0,0,0],this.regionSegments={},this.regionSegments[4]=new tl;}getDefaultSegment(){return this.regionSegments[4]}hasData(){return 0!==this.vertexArray.length}addData(t,e,r,n=!1){const i=t.length;if(i>2){let s=Math.max(0,this._segments.get().length-1);const o=this._segments._prepareSegment(4*i,this.vertexArray.length,2*this._segmentToGroundQuads[s].length);let a;s!==this._segments.get().length-1&&(s++,this._segmentToGroundQuads[s]=[],this._segmentToRegionTriCounts[s]=[0,0,0,0,0]);{const e=t[0],r=t[1];a=rf(e.sub(t[i-1])._perp()._unit(),r.sub(e)._perp()._unit());}for(let l=0;l<i;l++){const u=l===i-1?0:l+1,c=t[l],h=t[u],p=t[u===i-1?0:u+1],f=h.sub(c)._perp()._unit(),d=rf(f,p.sub(h)._perp()._unit()),m=a,y=d;if(hf(c,h,e)||n&&pf(c,e)&&pf(h,e)){a=d;continue}const g=o.vertexLength;Kp(this.vertexArray,c,h,1,1,m),Kp(this.vertexArray,c,h,1,0,m),Kp(this.vertexArray,c,h,0,1,y),Kp(this.vertexArray,c,h,0,0,y),o.vertexLength+=4;const x=sf(c,h,f,r);for(const t of x)this._segmentToGroundQuads[s].push({id:g,region:t}),this._segmentToRegionTriCounts[s][t]+=2,o.primitiveLength+=2;a=d;}}}prepareBorderSegments(){if(!this.hasData())return;const t=this._segments.get(),e=t.length;for(let t=0;t<e;t++)this._segmentToGroundQuads[t].sort(((t,e)=>t.region-e.region));for(let r=0;r<e;r++){const e=this._segmentToGroundQuads[r],n=t[r],i=this._segmentToRegionTriCounts[r];i.reduce(((t,e)=>t+e),0);let s=0;for(let t=0;t<=4;t++){const e=i[t];if(0!==e){let r=this.regionSegments[t];r||(r=this.regionSegments[t]=new tl);const i={vertexOffset:n.vertexOffset,primitiveOffset:n.primitiveOffset+s,vertexLength:n.vertexLength,primitiveLength:e};r.get().push(i);}s+=e;}for(let t=0;t<e.length;t++){const r=e[t].id;this.indexArray.emplaceBack(r,r+1,r+3),this.indexArray.emplaceBack(r,r+3,r+2);}}this._segmentToGroundQuads=null,this._segmentToRegionTriCounts=null,this._segments.destroy(),this._segments=null;}addPaintPropertiesData(t,e,r,n,i,s,o){this.hasData()&&this.programConfigurations.populatePaintArrays(this.vertexArray.length,t,e,r,n,i,s,void 0,o);}upload(t){this.hasData()&&(this.vertexBuffer=t.createVertexBuffer(this.vertexArray,_p.members),this.indexBuffer=t.createIndexBuffer(this.indexArray));}uploadPaintProperties(t){this.hasData()&&this.programConfigurations.upload(t);}update(t,e,r,n,i,s,o,a){this.hasData()&&this.programConfigurations.updatePaintArrays(t,e,r,n,i,s,o,a);}updateHiddenByLandmark(t){if(!this.hasData())return;const e=t.groundVertexCount+t.groundVertexArrayOffset;if(0===t.groundVertexCount)return;const r=t.flags&Zp?1:0;for(let n=t.groundVertexArrayOffset;n<e;++n)this.hiddenByLandmarkVertexArray.emplace(n,r);this._needsHiddenByLandmarkUpdate=!0;}uploadHiddenByLandmark(t){this.hasData()&&this._needsHiddenByLandmarkUpdate&&(!this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexArray.length>0?this.hiddenByLandmarkVertexBuffer=t.createVertexBuffer(this.hiddenByLandmarkVertexArray,Ip.members,!0):this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexBuffer.updateData(this.hiddenByLandmarkVertexArray),this._needsHiddenByLandmarkUpdate=!1);}destroy(){if(this.vertexBuffer){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexBuffer.destroy(),this._segments&&this._segments.destroy(),this.programConfigurations.destroy();for(let t=0;t<=4;t++){const e=this.regionSegments[t];e&&e.destroy();}}}}class af{constructor(t){this.zoom=t.zoom,this.canonical=t.canonical,this.overscaling=t.overscaling,this.layers=t.layers,this.pixelRatio=t.pixelRatio,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.edgeRadius=0,this.projection=t.projection,this.activeReplacements=[],this.replacementUpdateTime=0,this.centroidData=[],this.footprintIndices=new Aa,this.footprintVertices=new ra,this.footprintSegments=[],this.layoutVertexArray=new ia,this.centroidVertexArray=new Za,this.wallVertexArray=new Ya,this.indexArray=new Aa,this.programConfigurations=new kl(t.layers,{zoom:t.zoom,lut:t.lut},(t=>$p.includes(t))),this.segments=new tl,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.groundEffect=new of(t),this.maxHeight=0,this.partLookup={},this.triangleSubSegments=[],this.polygonSegments=[],this.worldview=t.worldview;}updateFootprints(t,e){}populate(t,e,r,n){this.features=[],this.hasPattern=Jh("fill-extrusion",this.layers,this.pixelRatio,e),this.featuresOnBorder=[],this.borderFeatureIndices=[[],[],[],[]],this.borderDoneWithNeighborZ=[-1,-1,-1,-1],this.selfDEMTileTimestamp=Number.MAX_VALUE,this.borderDEMTileTimestamp=[Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE],this.tileToMeter=au(r),this.edgeRadius=this.layers[0].layout.get("fill-extrusion-edge-radius")/this.tileToMeter,this.wallMode=0!==this.layers[0].paint.get("fill-extrusion-line-width").constantOr(1);for(const{feature:i,id:s,index:o,sourceLayerIndex:a}of t){const t=this.layers[0]._featureFilter.needGeometry,l=gu(i,t);if(!this.layers[0]._featureFilter.filter(new go(this.zoom,{worldview:this.worldview}),l,r))continue;const u={id:s,sourceLayerIndex:a,index:o,geometry:t?l.geometry:yu(i,r,n),properties:i.properties,type:i.type,patterns:{}},c=this.layoutVertexArray.length,h="Polygon"===jp[u.type];if(this.hasPattern)this.features.push(Qh("fill-extrusion",this.layers,u,this.zoom,this.pixelRatio,e));else if(this.wallMode)for(const t of u.geometry)for(const i of Np(t,h))this.addFeature(u,[i],o,r,{},e.availableImages,n,e.brightness);else this.addFeature(u,u.geometry,o,r,{},e.availableImages,n,e.brightness);e.featureIndex.insert(i,u.geometry,o,a,this.index,c);}this.sortBorders(),"mercator"===this.projection.name&&this.splitToSubtiles(),this.groundEffect.prepareBorderSegments(),this.polygonSegments.length=0;}addFeatures(t,e,r,n,i,s){for(const t of this.features){const o="Polygon"===jp[t.type],{geometry:a}=t;if(this.wallMode)for(const l of a)for(const a of Np(l,o))this.addFeature(t,[a],t.index,e,r,n,i,s);else this.addFeature(t,a,t.index,e,r,n,i,s);}this.sortBorders(),"mercator"===this.projection.name&&this.splitToSubtiles();}update(t,e,r,n,i,s,o){this.programConfigurations.updatePaintArrays(t,e,i,r,n,s,o,this.worldview),this.groundEffect.update(t,e,i,r,n,s,o,this.worldview);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload||this.groundEffect.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,zp),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.wallVertexBuffer=t.createVertexBuffer(this.wallVertexArray,Mp.members),this.layoutVertexExtArray&&(this.layoutVertexExtBuffer=t.createVertexBuffer(this.layoutVertexExtArray,Sp.members,!0)),this.groundEffect.upload(t)),this.groundEffect.uploadPaintProperties(t),this.programConfigurations.upload(t),this.uploaded=!0;}uploadCentroid(t){this.groundEffect.uploadHiddenByLandmark(t),this.needsCentroidUpdate&&(!this.centroidVertexBuffer&&this.centroidVertexArray.length>0?this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,Ap.members,!0):this.centroidVertexBuffer&&this.centroidVertexBuffer.updateData(this.centroidVertexArray),this.needsCentroidUpdate=!1);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.centroidVertexBuffer&&this.centroidVertexBuffer.destroy(),this.layoutVertexExtBuffer&&this.layoutVertexExtBuffer.destroy(),this.groundEffect.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,n,i,s,o,a){const l=this.layers[0].paint.get("fill-extrusion-flood-light-ground-radius").evaluate(t,{})/this.tileToMeter,u=[new bt(0,0),new bt(Cn,Cn)],c=o.projection,h="globe"===c.name,p=this.wallMode||"Polygon"===jp[t.type],f=new ef;f.centroidDataIndex=this.centroidData.length;const d=new tf,m=this.layers[0].paint.get("fill-extrusion-base").evaluate(t,{},n)<=0,y=this.layers[0].paint.get("fill-extrusion-height").evaluate(t,{},n);let g;if(d.height=y,d.vertexArrayOffset=this.layoutVertexArray.length,d.groundVertexArrayOffset=this.groundEffect.vertexArray.length,h&&!this.layoutVertexExtArray&&(this.layoutVertexExtArray=new fa),this.wallMode){if(h)return void Gt("Non zero fill-extrusion-line-width is not yet supported on globe.");if(1!==e.length)return;g=function(t){const e=t[0].x===t[t.length-1].x&&t[0].y===t[t.length-1].y,r=function(t){let e=0;const r=t.length;for(let n=0;n<r;n++)e+=(t[(n+1)%r].x-t[n].x)*(t[(n+1)%r].y+t[n].y);return e>=0}(t);r||(t=t.reverse());const n={geometry:[],joinNormals:[],indices:[]},i=[],s=[],o=[];let a=t.length;for(;a>=2&&t[a-1].equals(t[a-2]);)a--;if(a<(e?3:2))return n;let l,u,c,h,p,f=0;for(;f<a-1&&t[f].equals(t[f+1]);)f++;e&&(l=t[a-2],p=t[f].sub(l)._unit()._perp());for(let r=f;r<a;r++){if(c=r===a-1?e?t[f+1]:void 0:t[r+1],c&&t[r].equals(c))continue;p&&(h=p),l&&(u=l),l=t[r],p=c?c.sub(l)._unit()._perp():h,h=h||p;let n=h.add(p);0===n.x&&0===n.y||n._unit();const d=n.x*p.x+n.y*p.y,m=0!==d?1/d:1/0,y=h.x*p.y-h.y*p.x>0;let g="miter";const x=2;"miter"===g&&m>x&&(g="bevel"),"bevel"===g&&(m>100&&(g="flipbevel"),m<x&&(g="miter"));const v=(t,e,r,n)=>{const a=new bt(t.x,t.y),l=new bt(t.x,t.y);a.x+=e.x*n,a.y+=e.y*n,l.x-=e.x*Math.max(r,1),l.y-=e.y*Math.max(r,1),o.push(e),i.push(a),s.push(l);};if("miter"===g)n._mult(m),v(l,n,0,0);else if("flipbevel"===g)n=p.mult(-1),v(l,n,0,0),v(l,n.mult(-1),0,0);else {const t=-Math.sqrt(m*m-1),e=y?t:0,r=y?0:t;u&&v(l,h,e,r),c&&v(l,p,e,r);}}n.geometry=[...i,...s.reverse(),i[0]],n.joinNormals=[...o,...o.reverse(),o[o.length-1]];const d=n.geometry.length-1;for(let t=0;t<d/2;t++)if(t+1<d/2){let e=t,r=t+1,i=d-1-t,s=d-2-t;e=0===e?d-1:e-1,r=0===r?d-1:r-1,i=0===i?d-1:i-1,s=0===s?d-1:s-1,n.indices.push(i),n.indices.push(r),n.indices.push(e),n.indices.push(i),n.indices.push(s),n.indices.push(r);}return n}(e[0]),e=[g.geometry];}const x=(t,e)=>t<(e.length-1)/2||t===e.length-1,v=this.wallMode?[e]:Wh(e,500);for(let t=v.length-1;t>=0;t--){const e=v[t];(0===e.length||(b=e[0]).every((t=>t.x<=0))||b.every((t=>t.x>=Cn))||b.every((t=>t.y<=0))||b.every((t=>t.y>=Cn)))&&v.splice(t,1);}var b;let w;if(h)w=yf(v,u,n);else {w=[];for(const t of v)w.push({polygon:t,bounds:u});}const _=p?this.edgeRadius:0,A=_>0&&this.zoom<17,M=(t,e)=>{if(0===t.length)return !1;const r=t[t.length-1];return e.x===r.x&&e.y===r.y};for(const{polygon:t,bounds:e}of w){let r=0,i=0;for(const e of t)p&&!e[0].equals(e[e.length-1])&&e.push(e[0]),i+=p?e.length-1:e.length;const s=this.segments.prepareSegment((p?5:4)*i,this.layoutVertexArray,this.indexArray);d.footprintSegIdx<0&&(d.footprintSegIdx=this.footprintSegments.length),d.polygonSegIdx<0&&(d.polygonSegIdx=this.polygonSegments.length);const o={triangleArrayOffset:this.indexArray.length,triangleCount:0,triangleSegIdx:this.segments.segments.length-1},a=new Qp;if(a.vertexOffset=this.footprintVertices.length,a.indexOffset=3*this.footprintIndices.length,a.ringIndices=[],p){const i=[],o=[];r=s.vertexLength;for(let r=0;r<t.length;r++){const u=t[r];u.length&&0!==r&&o.push(i.length/2);const p=[];let f,d;f=u[1].sub(u[0])._perp()._unit(),a.ringIndices.push(u.length-1);for(let t=1;t<u.length;t++){const e=u[t],r=u[t===u.length-1?1:t+1],o=e.clone();if(_){d=r.sub(e)._perp()._unit();const t=f.add(d)._unit(),n=_*Math.min(4,1/(f.x*t.x+f.y*t.y));o.x+=n*t.x,o.y+=n*t.y,o.x=Math.round(o.x),o.y=Math.round(o.y),f=d;}if(!m||0!==_&&!A||M(p,o)||p.push(o),Wp(this.layoutVertexArray,o.x,o.y,0,0,1,1,0),this.wallMode){const e=x(t,u);Yp(this.wallVertexArray,g.joinNormals[t],!e);}s.vertexLength++,this.footprintVertices.emplaceBack(e.x,e.y),i.push(e.x,e.y),h&&Jp(this.layoutVertexExtArray,c.projectTilePoint(o.x,o.y,n),c.upVector(n,o.x,o.y));}m&&(0===_||A)&&(0!==p.length&&M(p,p[0])&&p.pop(),this.groundEffect.addData(p,e,l));}const u=this.wallMode?g.indices:Ah(i,o);for(let t=0;t<u.length;t+=3)this.footprintIndices.emplaceBack(a.vertexOffset+u[t+0],a.vertexOffset+u[t+1],a.vertexOffset+u[t+2]),this.indexArray.emplaceBack(r+u[t],r+u[t+2],r+u[t+1]),s.primitiveLength++;a.indexCount+=u.length,a.vertexCount+=this.footprintVertices.length-a.vertexOffset;}for(let i=0;i<t.length;i++){const o=t[i];f.startRing(d,o[0]);let a=o.length>4&&ff(o[o.length-2],o[0],o[1]),u=_?uf(o[o.length-2],o[0],o[1],_):0;const y=[];let v,b,w;b=o[1].sub(o[0])._perp()._unit();let A=!0;for(let t=1,i=0;t<o.length;t++){let l=o[t-1],p=o[t];const I=o[t===o.length-1?1:t+1];if(f.appendEdge(d,p,l),hf(p,l,e)){_&&(b=I.sub(p)._perp()._unit(),A=!A);continue}const S=p.sub(l)._perp(),z=S.x/(Math.abs(S.x)+Math.abs(S.y)),k=S.y>0?1:0,P=l.dist(p);if(i+P>32768&&(i=0),_){w=I.sub(p)._perp()._unit();let t=cf(l,p,I,lf(b,w),_);isNaN(t)&&(t=0);const e=p.sub(l)._unit();l=l.add(e.mult(u))._round(),p=p.add(e.mult(-t))._round(),u=t,b=w,m&&this.zoom>=17&&(M(y,l)||y.push(l),M(y,p)||y.push(p));}const E=s.vertexLength,T=o.length>4&&ff(l,p,I);let B=df(i,a,A);if(Wp(this.layoutVertexArray,l.x,l.y,z,k,0,0,B),Wp(this.layoutVertexArray,l.x,l.y,z,k,0,1,B),this.wallMode){const e=x(t-1,o),r=g.joinNormals[t-1];Yp(this.wallVertexArray,r,e),Yp(this.wallVertexArray,r,e);}if(i+=P,B=df(i,T,!A),a=T,Wp(this.layoutVertexArray,p.x,p.y,z,k,0,0,B),Wp(this.layoutVertexArray,p.x,p.y,z,k,0,1,B),this.wallMode){const e=x(t,o),r=g.joinNormals[t];Yp(this.wallVertexArray,r,e),Yp(this.wallVertexArray,r,e);}if(s.vertexLength+=4,this.indexArray.emplaceBack(E+0,E+1,E+2),this.indexArray.emplaceBack(E+1,E+3,E+2),s.primitiveLength+=2,_){const n=r+(1===t?o.length-2:t-2),i=1===t?r:n+1;if(this.indexArray.emplaceBack(E+1,n,E+3),this.indexArray.emplaceBack(n,i,E+3),s.primitiveLength+=2,void 0===v&&(v=E),!hf(I,o[t],e)){const e=t===o.length-1?v:s.vertexLength;this.indexArray.emplaceBack(E+2,E+3,e),this.indexArray.emplaceBack(E+3,e+1,e),this.indexArray.emplaceBack(E+3,i,e+1),s.primitiveLength+=3;}A=!A;}if(h){const t=this.layoutVertexExtArray,e=c.projectTilePoint(l.x,l.y,n),r=c.projectTilePoint(p.x,p.y,n),i=c.upVector(n,l.x,l.y),s=c.upVector(n,p.x,p.y);Jp(t,e,i),Jp(t,e,i),Jp(t,r,s),Jp(t,r,s);}}p&&(r+=o.length-1),m&&_&&this.zoom>=17&&(0!==y.length&&M(y,y[0])&&y.pop(),this.groundEffect.addData(y,e,l,_>0));}this.footprintSegments.push(a),o.triangleCount=this.indexArray.length-o.triangleArrayOffset,this.polygonSegments.push(o),++d.footprintSegLen,++d.polygonSegLen;}if(d.vertexCount=this.layoutVertexArray.length-d.vertexArrayOffset,d.groundVertexCount=this.groundEffect.vertexArray.length-d.groundVertexArrayOffset,0!==d.vertexCount){if(d.centroidXY=f.borders?Xp:this.encodeCentroid(f,d),this.centroidData.push(d),f.borders){this.featuresOnBorder.push(f);const t=this.featuresOnBorder.length-1;for(let e=0;e<f.borders.length;e++)f.borders[e][0]!==Number.MAX_VALUE&&this.borderFeatureIndices[e].push(t);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,s,n,a,void 0,this.worldview),this.groundEffect.addPaintPropertiesData(t,r,i,s,n,a,this.worldview),this.maxHeight=Math.max(this.maxHeight,y);}}sortBorders(){for(let t=0;t<this.borderFeatureIndices.length;t++)this.borderFeatureIndices[t].sort(((e,r)=>this.featuresOnBorder[e].borders[t][0]-this.featuresOnBorder[r].borders[t][0]));}splitToSubtiles(){const t=[];for(let e=0;e<this.centroidData.length;e++){const r=this.centroidData[e],n=+(r.min.y+r.max.y>Cn),i=2*n+(+(r.min.x+r.max.x>Cn)^n);for(let n=0;n<r.polygonSegLen;n++){const s=r.polygonSegIdx+n;t.push({centroidIdx:e,subtile:i,polygonSegmentIdx:s,triangleSegmentIdx:this.polygonSegments[s].triangleSegIdx});}}const e=new Aa;t.sort(((t,e)=>t.triangleSegmentIdx===e.triangleSegmentIdx?t.subtile-e.subtile:t.triangleSegmentIdx-e.triangleSegmentIdx));let r=0,n=0,i=0;for(const e of t){if(e.triangleSegmentIdx!==r)break;i++;}const s=t.length;for(;n!==t.length;){r=t[n].triangleSegmentIdx;let o=0,a=n,l=n;for(let e=a;e<i&&t[e].subtile===o;e++)l++;for(;a!==i;){const n=t[a];o=n.subtile;const s=this.centroidData[n.centroidIdx].min.clone(),u=this.centroidData[n.centroidIdx].max.clone(),c={vertexOffset:this.segments.segments[r].vertexOffset,primitiveOffset:e.length,vertexLength:this.segments.segments[r].vertexLength,primitiveLength:0,sortKey:void 0,vaos:{}};for(let r=a;r<l;r++){const n=t[r],i=this.polygonSegments[n.polygonSegmentIdx],o=this.centroidData[n.centroidIdx].min,a=this.centroidData[n.centroidIdx].max,l=this.indexArray.uint16;for(let t=i.triangleArrayOffset;t<i.triangleArrayOffset+i.triangleCount;t++)e.emplaceBack(l[3*t],l[3*t+1],l[3*t+2]);c.primitiveLength+=i.triangleCount,s.x=Math.min(s.x,o.x),s.y=Math.min(s.y,o.y),u.x=Math.max(u.x,a.x),u.y=Math.max(u.y,a.y);}c.primitiveLength>0&&this.triangleSubSegments.push({segment:c,min:s,max:u}),a=l;for(let e=a;e<i&&t[e].subtile===t[a].subtile;e++)l++;}n=i;for(let e=n;e<s&&t[e].triangleSegmentIdx===t[n].triangleSegmentIdx;e++)i++;}e._trim(),this.indexArray=e;}getVisibleSegments(t,e,r){const n=new tl;if(this.wallMode){for(const t of this.triangleSubSegments)n.segments.push(t.segment);return n}let i=0,s=0;const o=1<<t.canonical.z;if(e){const r=e.getMinMaxForTile(t);r&&(i=r.min,s=r.max);}s+=this.maxHeight;const a=t.toUnwrapped();let l;const u=[a.canonical.x/o+a.wrap,a.canonical.y/o],c=[(a.canonical.x+1)/o+a.wrap,(a.canonical.y+1)/o],h=(t,e,r)=>[t[0]*(1-r[0])+e[0]*r[0],t[1]*(1-r[1])+e[1]*r[1]],p=[],f=[];for(const t of this.triangleSubSegments){p[0]=t.min.x/Cn,p[1]=t.min.y/Cn,f[0]=t.max.x/Cn,f[1]=t.max.y/Cn;const e=h(u,c,p),o=h(u,c,f);if(0===new qu([e[0],e[1],i],[o[0],o[1],s]).intersectsPrecise(r)){l&&(n.segments.push(l),l=void 0);continue}const a=t.segment;l&&l.vertexOffset!==a.vertexOffset&&(n.segments.push(l),l=void 0),l?(l.vertexLength+=a.vertexLength,l.primitiveLength+=a.primitiveLength):l={vertexOffset:a.vertexOffset,primitiveLength:a.primitiveLength,vertexLength:a.vertexLength,primitiveOffset:a.primitiveOffset,sortKey:void 0,vaos:{}};}return l&&n.segments.push(l),n}encodeCentroid(t,e){const r=t.centroid(),n=e.span(),i=Math.min(7,Math.round(n.x*this.tileToMeter/10)),s=Math.min(7,Math.round(n.y*this.tileToMeter/10));return new bt(Et(r.x,1,Cn-1)<<3|i,Et(r.y,1,Cn-1)<<3|s)}encodeBorderCentroid(t){if(!t.borders)return new bt(0,0);const e=t.borders,r=Number.MAX_VALUE;if(e[0][0]!==r||e[1][0]!==r){const t=e[0][0]!==r?0:1;return new bt(6|(e[0][0]!==r?0:65528),(e[t][0]+e[t][1])/2<<3|6)}{const t=e[2][0]!==r?2:3;return new bt((e[t][0]+e[t][1])/2<<3|6,6|(e[2][0]!==r?0:65528))}}showCentroid(t){const e=this.centroidData[t.centroidDataIndex];e.flags&=Zp,e.centroidXY.x=0,e.centroidXY.y=0,this.writeCentroidToBuffer(e);}writeCentroidToBuffer(t){this.groundEffect.updateHiddenByLandmark(t);const e=t.vertexArrayOffset,r=t.vertexCount+t.vertexArrayOffset,n=t.flags&Zp?Xp:t.centroidXY,i=this.centroidVertexArray.geta_centroid_pos0(e);if(this.centroidVertexArray.geta_centroid_pos1(e)!==n.y||i!==n.x){for(let t=e;t<r;++t)this.centroidVertexArray.emplace(t,n.x,n.y);this.needsCentroidUpdate=!0;}}createCentroidsBuffer(){this.centroidVertexArray.resize(this.layoutVertexArray.length),this.groundEffect.hiddenByLandmarkVertexArray.resize(this.groundEffect.vertexArray.length);for(const t of this.centroidData)this.writeCentroidToBuffer(t);}updateReplacement(t,e,r){if(e.updateTime===this.replacementUpdateTime)return;this.replacementUpdateTime=e.updateTime;const n=e.getReplacementRegionsForTile(t.toUnwrapped());if(Vp(this.activeReplacements,n))return;if(this.activeReplacements=n,0===this.centroidVertexArray.length)this.createCentroidsBuffer();else for(const t of this.centroidData)t.flags&=2147483647;const i=[];for(const e of this.activeReplacements){if(e.order<r)continue;const n=Math.max(1,Math.pow(2,e.footprintTileId.canonical.z-t.canonical.z));for(const r of this.centroidData)if(!(r.flags&Zp||e.min.x>r.max.x||r.min.x>e.max.x||e.min.y>r.max.y||r.min.y>e.max.y))for(let s=0;s<r.footprintSegLen;s++){const o=this.footprintSegments[r.footprintSegIdx+s];if(i.length=0,gf(this.footprintVertices,o.vertexOffset,o.vertexCount,e.footprintTileId.canonical,t.canonical,i),Dp(e.footprint,i,this.footprintIndices.uint16,o.indexOffset,o.indexCount,-o.vertexOffset,-n)){r.flags|=Zp;break}}}for(const t of this.centroidData)this.writeCentroidToBuffer(t);this.borderDoneWithNeighborZ=[-1,-1,-1,-1];}footprintContainsPoint(t,e,r){let n=!1;for(let i=0;i<r.footprintSegLen;i++){const s=this.footprintSegments[r.footprintSegIdx+i];let o=0;for(const r of s.ringIndices){for(let i=o,a=r+o-1;i<r+o;a=i++){const r=this.footprintVertices.int16[2*(i+s.vertexOffset)+0],o=this.footprintVertices.int16[2*(i+s.vertexOffset)+1],l=this.footprintVertices.int16[2*(a+s.vertexOffset)+1];o>e!=l>e&&t<(this.footprintVertices.int16[2*(a+s.vertexOffset)+0]-r)*(e-o)/(l-o)+r&&(n=!n);}o=r;}}return n}getHeightAtTileCoord(t,e){let r=Number.NEGATIVE_INFINITY,n=!0;const i=4*(t+Cn)*Cn+(e+Cn);if(this.partLookup.hasOwnProperty(i)){const t=this.partLookup[i];return t?{height:t.height,hidden:!!(t.flags&Zp)}:void 0}for(const s of this.centroidData)t>s.max.x||s.min.x>t||e>s.max.y||s.min.y>e||this.footprintContainsPoint(t,e,s)&&s&&s.height>r&&(r=s.height,this.partLookup[i]=s,n=!!(s.flags&Zp));if(r!==Number.NEGATIVE_INFINITY)return {height:r,hidden:n};this.partLookup[i]=void 0;}}function lf(t,e){const r=t.add(e)._unit();return t.x*r.x+t.y*r.y}function uf(t,e,r,n){const i=e.sub(t)._perp()._unit(),s=r.sub(e)._perp()._unit();return cf(t,e,r,lf(i,s),n)}function cf(t,e,r,n,i){const s=Math.sqrt(1-n*n);return Math.min(t.dist(e)/3,e.dist(r)/3,i*s/n)}function hf(t,e,r){return t.x<r[0].x&&e.x<r[0].x||t.x>r[1].x&&e.x>r[1].x||t.y<r[0].y&&e.y<r[0].y||t.y>r[1].y&&e.y>r[1].y}function pf(t,e){return t.x<e[0].x||t.x>e[1].x||t.y<e[0].y||t.y>e[1].y}function ff(t,e,r){if(t.x<0||t.x>=Cn||e.x<0||e.x>=Cn||r.x<0||r.x>=Cn)return !1;const n=r.sub(e),i=n.perp(),s=t.sub(e);return (n.x*s.x+n.y*s.y)/Math.sqrt((n.x*n.x+n.y*n.y)*(s.x*s.x+s.y*s.y))>-.866&&i.x*s.x+i.y*s.y<0}function df(t,e,r){const n=e?2|t:-3&t;return r?1|n:-2&n}function mf(){const t=Math.PI/32,e=Math.tan(t),r=Gl;return r*Math.sqrt(1+2*e*e)-r}function yf(t,e,r){const n=1<<r.z,i=tu(r.x/n),s=tu((r.x+1)/n),o=eu(r.y/n),a=eu((r.y+1)/n);return function(t,e,r,n,i=0,s){const o=[];if(!t.length||!r||!n)return o;const a=(t,e)=>{for(const r of t)o.push({polygon:r,bounds:e});},l=Math.ceil(Math.log2(r)),u=Math.ceil(Math.log2(n)),c=l-u,h=[];for(let t=0;t<Math.abs(c);t++)h.push(c>0?0:1);for(let t=0;t<Math.min(l,u);t++)h.push(0),h.push(1);let p=t;if(p=ap(p,e[0].y-i,e[1].y+i,1),p=ap(p,e[0].x-i,e[1].x+i,0),!p.length)return o;const f=[];for(h.length?f.push({polygons:p,bounds:e,depth:0}):a(p,e);f.length;){const t=f.pop(),e=t.depth,r=h[e],n=t.bounds[0],o=t.bounds[1],l=0===r?n.x:n.y,u=0===r?o.x:o.y,c=s?s(r,l,u):.5*(l+u),p=ap(t.polygons,l-i,c+i,r),d=ap(t.polygons,c-i,u+i,r);if(p.length){const t=[n,new bt(0===r?c:o.x,1===r?c:o.y)];h.length>e+1?f.push({polygons:p,bounds:t,depth:e+1}):a(p,t);}if(d.length){const t=[new bt(0===r?c:n.x,1===r?c:n.y),o];h.length>e+1?f.push({polygons:d,bounds:t,depth:e+1}):a(d,t);}}return o}(t,e,Math.ceil((s-i)/11.25),Math.ceil((o-a)/11.25),1,((t,e,i)=>{if(0===t)return .5*(e+i);{const t=eu((r.y+e/Cn)/n);return (Jl(.5*(eu((r.y+i/Cn)/n)+t))*n-r.y)*Cn}}))}function gf(t,e,r,n,i,s){const o=Math.pow(2,n.z-i.z);for(let a=0;a<r;a++){let r=t.int16[2*(a+e)+0],l=t.int16[2*(a+e)+1];r=(r+i.x*Cn)*o-n.x*Cn,l=(l+i.y*Cn)*o-n.y*Cn,s.push(new bt(r,l));}}let xf,vf;qs(af,"FillExtrusionBucket",{omit:["layers","features"]}),qs(tf,"PartData"),qs(Qp,"FootprintSegment"),qs(ef,"BorderCentroidData"),qs(of,"GroundEffect");class bf extends bt{constructor(t,e,r){super(t,e),this.z=r;}}class wf extends bf{constructor(t,e,r,n){super(t,e,r),this.w=n;}}function _f(t,e,r,n){const i="x"===r?"y":"x",s=(n-t[r])/(e[r]-t[r]);t[i]=Math.round(t[i]+(e[i]-t[i])*s),t[r]=n,t.hasOwnProperty("z")&&(t.z=ur(t.z,e.z,s)),t.hasOwnProperty("w")&&(t.w=ur(t.w,e.w,s));}function Af(t,e,r,n){const i=r,s=n;for(const r of ["x","y"]){let n=t,o=e;n[r]>=o[r]&&(n=e,o=t),n[r]<i&&o[r]>i&&_f(n,o,r,i),n[r]<s&&o[r]>s&&_f(o,n,r,s);}}function Mf(t,e,r,n,i,s){const o=[];for(let a=0;a<t.length;a++){const l=t[a];let u;const c=o.length;let h=0;for(let t=0;t<l.length-1;t++){let c=l[t],p=l[t+1],f=0;const d=h;let m,y;s&&(f=Math.hypot(p.x-c.x,p.y-c.y),h+=f,m=c,y=p),c.x<e&&p.x<e||(c.x<e?c=new bt(e,c.y+(e-c.x)/(p.x-c.x)*(p.y-c.y))._round():p.x<e&&(p=new bt(e,c.y+(e-c.x)/(p.x-c.x)*(p.y-c.y))._round()),c.y<r&&p.y<r||(c.y<r?c=new bt(c.x+(r-c.y)/(p.y-c.y)*(p.x-c.x),r)._round():p.y<r&&(p=new bt(c.x+(r-c.y)/(p.y-c.y)*(p.x-c.x),r)._round()),c.x>=n&&p.x>=n||(c.x>=n?c=new bt(n,c.y+(n-c.x)/(p.x-c.x)*(p.y-c.y))._round():p.x>=n&&(p=new bt(n,c.y+(n-c.x)/(p.x-c.x)*(p.y-c.y))._round()),c.y>=i&&p.y>=i||(c.y>=i?c=new bt(c.x+(i-c.y)/(p.y-c.y)*(p.x-c.x),i)._round():p.y>=i&&(p=new bt(c.x+(i-c.y)/(p.y-c.y)*(p.x-c.x),i)._round()),u&&c.equals(u[u.length-1])||(u=[c],o.push(u),s&&s.push({progress:{min:d+Sf(m,y,c)*f,max:1},parentIndex:a,prevPoint:m,nextPoint:y})),u.push(p),s&&(s[s.length-1].progress.max=d+Sf(m,y,p)*f,s[s.length-1].nextPoint=y)))));}if(s&&h>0)for(let t=c;t<o.length;t++)s[t].progress.min/=h,s[t].progress.max/=h;}return o}function If(t,e,r,n,i){if(t.length<2)return void n.push(t);const s=[];for(;e.valid();){const[r,n]=e.get();for(let e=0;e<t.length-1;e++){const i=t[e],o=t[e+1],a=ic(i,o,r,n);if(a){const[t]=a,r=new bt(ur(i.x,o.x,t),ur(i.y,o.y,t));s.push({t:e+t,distance:0,point:r});}}e.next();}if(0===s.length)return void n.push(t);s.sort(((t,e)=>t.t-e.t));let o=0,a=0,l=[];for(n.push(l);o!==t.length;){if(a===s.length){for(;o!==t.length;)0!==l.length&&l[l.length-1].equals(t[o])||l.push(t[o]),o++;break}s[a].t<=o?(0!==l.length&&l[l.length-1].equals(s[a].point)||l.push(s[a].point),Math.trunc(s[a].t),a++):(0!==l.length&&l[l.length-1].equals(t[o])||l.push(t[o]),o++);}}function Sf(t,e,r){return t.x!==e.x?(r.x-t.x)/(e.x-t.x):t.y!==e.y?(r.y-t.y)/(e.y-t.y):0}function zf(t,e){return t.x*e.x+t.y*e.y}function kf(t,e){if(1===t.length){let r=0;const n=e[r++];let i;for(;!i||n.equals(i);)if(i=e[r++],!i)return 1/0;for(;r<e.length;r++){const s=e[r],o=t[0],a=i.sub(n),l=s.sub(n),u=o.sub(n),c=zf(a,a),h=zf(a,l),p=zf(l,l),f=zf(u,a),d=zf(u,l),m=c*p-h*h,y=(p*f-h*d)/m,g=(c*d-h*f)/m,x=n.z*(1-y-g)+i.z*y+s.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}function Pf(t,e,r,n,i,s,o,a){const l=o*i.getElevationAt(t,e,!0,!0),u=0!==s[0],c=u?0===s[1]?o*(s[0]/7-450):o*function(t,e,r){const n=Math.floor(e[0]/8),i=Math.floor(e[1]/8),s=10*(e[0]-8*n),o=10*(e[1]-8*i),a=t.getElevationAt(n,i,!0,!0),l=t.getMeterToDEM(r),u=Math.floor(.5*(s*l-1)),c=Math.floor(.5*(o*l-1)),h=t.tileCoordToPixel(n,i),p=2*u+1,f=2*c+1,d=function(t,e,r,n,i){return [t.getElevationAtPixel(e,r,!0),t.getElevationAtPixel(e+i,r,!0),t.getElevationAtPixel(e,r+i,!0),t.getElevationAtPixel(e+n,r+i,!0)]}(t,h.x-u,h.y-c,p,f),m=Math.abs(d[0]-d[1]),y=Math.abs(d[2]-d[3]),g=Math.abs(d[0]-d[2])+Math.abs(d[1]-d[3]),x=Math.min(.25,.5*l*(m+y)/p),v=Math.min(.25,.5*l*g/f);return a+Math.max(x*s,v*o)}(i,s,a):l;return {base:l+(0===r?-1:r),top:u?Math.max(c+n,l+r+2):l+n}}class Ef{constructor(t){this._callback=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._callback();});}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._callback();}),0));}remove(){this._channel=void 0,this._callback=()=>{};}}class Tf{constructor(){this.tasks={},this.taskQueue=[],Rt(["process"],this),this.invoker=new Ef(this.process),this.nextId=0;}add(t,e){const r=this.nextId++,n=function({type:t,isSymbolTile:e,zoom:r}){return r=r||0,"message"===t?0:"maybePrepare"!==t||e?"parseTile"!==t||e?"parseTile"===t&&e?300-r:"maybePrepare"===t&&e?400-r:500:200-r:100-r}(e);if(0===n){try{t();}finally{}return null}return this.tasks[r]={fn:t,metadata:e,priority:n,id:r},this.taskQueue.push(r),this.invoker.trigger(),{cancel:()=>{delete this.tasks[r];}}}process(){try{if(this.taskQueue=this.taskQueue.filter((t=>!!this.tasks[t])),!this.taskQueue.length)return;const t=this.pick();if(null===t)return;const e=this.tasks[t];if(delete this.tasks[t],this.taskQueue.length&&this.invoker.trigger(),!e)return;e.fn();}finally{}}pick(){let t=null,e=1/0;for(let r=0;r<this.taskQueue.length;r++){const n=this.tasks[this.taskQueue[r]];n.priority<e&&(e=n.priority,t=r);}if(null===t)return null;const r=this.taskQueue[t];return this.taskQueue.splice(t,1),r}remove(){this.invoker.remove();}}class Bf{constructor(t,e,r){this.target=t,this.parent=e,this.mapId=r,this.callbacks={},this.cancelCallbacks={},Rt(["receive"],this),this.target.addEventListener("message",this.receive,!1),this.scheduler=new Tf;}send(t,e,r,n,i=!1,s){const o=Math.round(1e18*Math.random()).toString(36).substring(0,10);r&&(r.metadata=s,this.callbacks[o]=r);const a=new Set;return this.target.postMessage({id:o,type:t,hasCallback:!!r,targetMapId:n,mustQueue:i,sourceMapId:this.mapId,data:Zs(e,a)},a),{cancel:()=>{r&&delete this.callbacks[o],this.target.postMessage({id:o,type:"<cancel>",targetMapId:n,sourceMapId:this.mapId});}}}receive(t){const e=t.data;if(!e)return;const r=e.id;if(r&&(!e.targetMapId||this.mapId===e.targetMapId))if("<cancel>"===e.type){const t=this.cancelCallbacks[r];delete this.cancelCallbacks[r],t&&t.cancel();}else if(e.mustQueue||Zt(self)){const t=this.callbacks[r],n=this.scheduler.add((()=>this.processTask(r,e)),t&&t.metadata||{type:"message"});n&&(this.cancelCallbacks[r]=n);}else this.processTask(r,e);}processTask(t,e){if(delete this.cancelCallbacks[t],"<response>"===e.type){const r=this.callbacks[t];delete this.callbacks[t],r&&(e.error?r(Ws(e.error)):r(null,Ws(e.data)));}else {const r=new Set,n=e.hasCallback?(e,n)=>{this.target.postMessage({id:t,type:"<response>",sourceMapId:this.mapId,error:e?Zs(e):null,data:Zs(n,r)},r);}:()=>{},i=Ws(e.data);if(this.parent[e.type])this.parent[e.type](e.sourceMapId,i,n);else if(this.parent.getWorkerSource){const t=e.type.split("."),{source:r,scope:s}=i;this.parent.getWorkerSource(e.sourceMapId,t[0],r,s)[t[1]](i,n);}else n(new Error(`Could not find function ${e.type}`));}}remove(){this.scheduler.remove(),this.target.removeEventListener("message",this.receive,!1);}}var Vf={workerUrl:"",workerClass:null,workerParams:void 0};const Cf="mapboxgl_preloaded_worker_pool";class Ff{constructor(){this.active={};}acquire(t,e=Ff.workerCount){if(!this.workers)for(this.workers=[];this.workers.length<e;)this.workers.push(null!=Vf.workerClass?new Vf.workerClass:new self.Worker(Vf.workerUrl,Vf.workerParams));return this.active[t]=!0,this.workers.slice()}release(t){delete this.active[t],this.workers&&0===this.numActive()&&(this.workers.forEach((t=>{t.terminate();})),this.workers=null);}isPreloaded(){return !!this.active[Cf]}numActive(){return Object.keys(this.active).length}}Ff.workerCount=2;class Df{constructor(t,e,r="Worker",n=Ff.workerCount){this.workerPool=t,this.actors=[],this.currentActor=0,this.id=Dt();const i=this.workerPool.acquire(this.id,n);for(let t=0;t<i.length;t++){const n=new Df.Actor(i[t],e,this.id);n.name=`${r} ${t}`,this.actors.push(n);}this.ready=!1,this.broadcast("checkIfReady",null,(()=>{this.ready=!0;}));}broadcast(t,e,r){Vt(this.actors,((r,n)=>{r.send(t,e,n);}),r=r||function(){});}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(){this.actors.forEach((t=>{t.remove();})),this.actors=[],this.workerPool.release(this.id);}}let Lf,Rf;function Of(){return Lf||(Lf=new Ff),Lf}Df.Actor=Bf;class Uf{constructor(t){this.module=t;}createIntArray(t){const e=new Int32Array(t),r=this.module.malloc(e.length*e.BYTES_PER_ELEMENT);return this.module.heap32.set(e,r/e.BYTES_PER_ELEMENT),r}createFloatArray(t){const e=new Float32Array(t),r=this.module.malloc(e.length*e.BYTES_PER_ELEMENT);return this.module.heapF32.set(e,r/e.BYTES_PER_ELEMENT),r}createStringBuffer(t){const e=this.module.malloc(t.length+1);for(let r=0;r<t.length;++r)this.module.heapU8[e+r]=t.charCodeAt(r);return this.module.heapU8[e+t.length]=0,e}readStringBuffer(t){let e="";for(;0!==this.module.heapU8[t];)e+=String.fromCharCode(this.module.heapU8[t]),++t;return e}setStyle(t){const e=t.entranceColorRgb,r=t.facadeGlazingColorRgb,n=t.roofColorRgb,i=t.wallColorRgb,s=t.normalScale;this.module.setStyle(e[0],e[1],e[2],r[0],r[1],r[2],n[0],n[1],n[2],i[0],i[1],i[2],s[0],s[1],s[2],t.tileToMeters);}setAOOptions(t,e){this.module.setAOOptions(t?1:0,e);}setMetricOptions(t,e){this.module.setMetricOptions(t?1:0,e);}setFacadeOptions(t,e,r){this.module.setFacadeOptions(t,e,r);}generateMesh(t,e){for(const e of t){const t=this.createStringBuffer(e.roofType),r=[0],n=[];for(const t of e.coordinates)if(Array.isArray(t)){for(const e of t)n.push(e.x),n.push(e.y);r.push(n.length);}const i=this.createIntArray(r),s=this.createFloatArray(n);this.module.addFeature(e.id,e.sourceId,e.minHeight,e.height,t,e.roofType.length,s,i,r.length-1),this.module.free(t),this.module.free(i),this.module.free(s);}for(const t of e){let e;e=t.entrances?JSON.parse(t.entrances):[];const r=this.createFloatArray(e),n=[];for(const e of t.coordinates)n.push(e.x),n.push(e.y);const i=this.createFloatArray(n);this.module.addFacade(t.sourceId,t.crossPerc,t.distanceToRoad,r,e.length,i,n.length),this.module.free(r),this.module.free(i);}if(!this.module.generateMesh()){const t=this.module.getLastError();return this.readStringBuffer(t)}const r=this.module.getMeshCount(),n=new Array(r);for(let t=0;t<r;t++){const e=this.module.getPositionsPtr(t),r=this.module.getPositionsLength(t),i=new Float32Array(this.module.heapF32.buffer,e,r),s=this.module.getNormalsPtr(t),o=this.module.getNormalsLength(t),a=new Float32Array(this.module.heapF32.buffer,s,o),l=this.module.getColorsPtr(t),u=this.module.getColorsLength(t),c=new Uint8Array(this.module.heapU8.buffer,l,u),h=this.module.getAOPtr(t),p=this.module.getAOLength(t),f=new Float32Array(this.module.heapF32.buffer,h,p),d=this.module.getIndicesPtr(t),m=this.module.getIndicesLength(t),y=new Int32Array(this.module.heap32.buffer,d,m),g=this.module.getBuildingPart(t),x=this.readStringBuffer(g);n[t]={positions:i,normals:a,colors:c,ao:f,indices:y,buildingPart:x};}const i=this.module.getRingCount(),s=[];for(let t=0;t<i;t++){const e=this.module.getRingPtr(t),r=this.module.getRingLength(t),n=new Float32Array(this.module.heapF32.buffer,e,r);s.push(n);}return {meshes:n,modifiedPolygonRings:s}}}let Nf,jf,$f,Gf,qf,Hf=null,Xf=null,Zf=null,Wf=null;function Yf(){return Zt(self)&&self.worker.dracoUrl?self.worker.dracoUrl:jf||ne.DRACO_URL}function Kf(){if(Zt(self)&&self.worker.meshoptUrl)return self.worker.meshoptUrl;if(Gf)return Gf;const t=new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,3,2,0,0,5,3,1,0,1,12,1,0,10,22,2,12,0,65,0,65,0,65,0,252,10,0,0,11,7,0,65,0,253,15,26,11]);if("object"!=typeof WebAssembly)throw new Error("WebAssembly not supported, cannot instantiate meshoptimizer");return Gf=WebAssembly.validate(t)?ne.MESHOPT_SIMD_URL:ne.MESHOPT_URL,Gf}const Jf={5120:Int8Array,5121:Uint8Array,5122:Int16Array,5123:Uint16Array,5125:Uint32Array,5126:Float32Array},Qf={5120:"DT_INT8",5121:"DT_UINT8",5122:"DT_INT16",5123:"DT_UINT16",5125:"DT_UINT32",5126:"DT_FLOAT32"},td={SCALAR:1,VEC2:2,VEC3:3,VEC4:4,MAT2:4,MAT3:9,MAT4:16};function ed(t,e,r){const n=r.json.bufferViews.length,i=r.buffers.length;e.bufferView=n,r.json.bufferViews[n]={buffer:i,byteLength:t.byteLength},r.buffers[i]=t;}const rd="KHR_draco_mesh_compression";function nd(t,e){const r=t.extensions&&t.extensions[rd];if(!r)return;const n=new $f.Decoder,i=cd(e,r.bufferView),s=new $f.Mesh;if(!n.DecodeArrayToMesh(i,i.byteLength,s))throw new Error("Failed to decode Draco mesh");const o=e.json.accessors[t.indices],a=Jf[o.componentType],l=o.count*a.BYTES_PER_ELEMENT,u=$f._malloc(l);a===Uint16Array?n.GetTrianglesUInt16Array(s,l,u):n.GetTrianglesUInt32Array(s,l,u),ed($f.memory.buffer.slice(u,u+l),o,e),$f._free(u);for(const i of Object.keys(r.attributes)){const o=n.GetAttributeByUniqueId(s,r.attributes[i]),a=e.json.accessors[t.attributes[i]],l=Qf[a.componentType],u=a.count*td[a.type]*Jf[a.componentType].BYTES_PER_ELEMENT,c=$f._malloc(u);n.GetAttributeDataArrayForAllPoints(s,o,$f[l],u,c),ed($f.memory.buffer.slice(c,c+u),a,e),$f._free(c);}n.destroy(),s.destroy(),delete t.extensions[rd];}const id="EXT_meshopt_compression";function sd(t,e){if(!t.extensions||!t.extensions[id])return;const r=t.extensions[id],n=new Uint8Array(e.buffers[r.buffer],r.byteOffset||0,r.byteLength||0),i=new Uint8Array(r.count*r.byteStride);qf.decodeGltfBuffer(i,r.count,r.byteStride,n,r.mode,r.filter),t.buffer=e.buffers.length,t.byteOffset=0,e.buffers[t.buffer]=i.buffer,delete t.extensions[id];}const od=1179937895,ad=new TextDecoder("utf8");function ld(t,e){return new URL(t,e).href}function ud(t,e,r,n){return fetch(ld(t.uri,n)).then((t=>t.arrayBuffer())).then((t=>{e.buffers[r]=t;}))}function cd(t,e){const r=t.json.bufferViews[e];return new Uint8Array(t.buffers[r.buffer],r.byteOffset||0,r.byteLength)}function hd(t,e,r,n){if(t.uri){const i=ld(t.uri,n);return fetch(i).then((t=>t.blob())).then((t=>createImageBitmap(t))).then((t=>{e.images[r]=t;}))}if(void 0!==t.bufferView){const n=cd(e,t.bufferView),i=new Blob([n],{type:t.mimeType});return createImageBitmap(i).then((t=>{e.images[r]=t;}))}}function pd(t,e=0,r){const n={json:null,images:[],buffers:[]};if(new Uint32Array(t,e,1)[0]===od){const r=new Uint32Array(t,e);let i=2;const s=(r[i++]>>2)-3,o=r[i++]>>2;if(i++,n.json=JSON.parse(ad.decode(r.subarray(i,i+o))),i+=o,i<s){const s=r[i++];i++;const o=e+(i<<2);n.buffers[0]=t.slice(o,o+s);}}else n.json=JSON.parse(ad.decode(new Uint8Array(t,e)));const{buffers:i,images:s,meshes:o,extensionsUsed:a,bufferViews:l}=n.json;let u=Promise.resolve();if(i){const t=[];for(let e=0;e<i.length;e++){const s=i[e];s.uri?t.push(ud(s,n,e,r)):n.buffers[e]||(n.buffers[e]=null);}u=Promise.all(t);}return u.then((()=>{const t=[],e=a&&a.includes(rd),i=a&&a.includes(id);if(e&&t.push(function(){if(!$f)return null!=Nf?Nf:(Nf=function(t){let e,r=null;function n(){e=new Uint8Array(r.buffer);}function i(){throw new Error("Unexpected Draco error.")}const s={a:{a:i,d:function(t,r,n){return e.copyWithin(t,r,r+n)},c:function(t){const i=e.length,s=Math.max(t>>>0,Math.ceil(1.2*i)),o=Math.ceil((s-i)/65536);try{return r.grow(o),n(),!0}catch(t){return !1}},b:i}};return (WebAssembly.instantiateStreaming?WebAssembly.instantiateStreaming(t,s):t.then((t=>t.arrayBuffer())).then((t=>WebAssembly.instantiate(t,s)))).then((t=>{const{Rb:i,Qb:s,P:o,T:a,X:l,Ja:u,La:c,Qa:h,Va:p,Wa:f,eb:d,jb:m,f:y,e:g,yb:x,zb:v,Ab:b,Bb:w,Db:_,Gb:A}=t.instance.exports;r=g;const M=(()=>{let t=0,r=0,n=0,o=0;return a=>{n&&(i(o),i(t),r+=n,n=t=0),t||(r+=128,t=s(r));const l=a.length+7&-8;let u=t;l>=r&&(n=l,u=o=s(l));for(let t=0;t<a.length;t++)e[u+t]=a[t];return u}})();return n(),y(),{memory:g,_free:i,_malloc:s,Mesh:class{constructor(){this.ptr=o();}destroy(){a(this.ptr);}},Decoder:class{constructor(){this.ptr=u();}destroy(){m(this.ptr);}DecodeArrayToMesh(t,e,r){const n=M(t),i=c(this.ptr,n,e,r.ptr);return !!l(i)}GetAttributeByUniqueId(t,e){return {ptr:h(this.ptr,t.ptr,e)}}GetTrianglesUInt16Array(t,e,r){p(this.ptr,t.ptr,e,r);}GetTrianglesUInt32Array(t,e,r){f(this.ptr,t.ptr,e,r);}GetAttributeDataArrayForAllPoints(t,e,r,n,i){d(this.ptr,t.ptr,e.ptr,r,n,i);}},DT_INT8:x(),DT_UINT8:v(),DT_INT16:b(),DT_UINT16:w(),DT_UINT32:_(),DT_FLOAT32:A()}}))}(fetch(Yf())),Nf.then((t=>{$f=t,Nf=void 0;})))}()),i&&t.push(function(){if(qf)return;const t=function(t){let e;const r=WebAssembly.instantiateStreaming(t,{}).then((t=>{e=t.instance,e.exports.__wasm_call_ctors();})),n={NONE:"",OCTAHEDRAL:"meshopt_decodeFilterOct",QUATERNION:"meshopt_decodeFilterQuat",EXPONENTIAL:"meshopt_decodeFilterExp"},i={ATTRIBUTES:"meshopt_decodeVertexBuffer",TRIANGLES:"meshopt_decodeIndexBuffer",INDICES:"meshopt_decodeIndexSequence"};return {ready:r,supported:!0,decodeGltfBuffer(t,r,s,o,a,l){!function(t,e,r,n,i,s,o){const a=t.exports.sbrk,l=n+3&-4,u=a(l*i),c=a(s.length),h=new Uint8Array(t.exports.memory.buffer);h.set(s,c);const p=e(u,n,i,c,s.length);if(0===p&&o&&o(u,l,i),r.set(h.subarray(u,u+n*i)),a(u-a(0)),0!==p)throw new Error(`Malformed buffer data: ${p}`)}(e,e.exports[i[a]],t,r,s,o,e.exports[n[l]]);}}}(fetch(Kf()));return t.ready.then((()=>{qf=t;}))}()),s)for(let e=0;e<s.length;e++)t.push(hd(s[e],n,e,r));return (t.length?Promise.all(t):Promise.resolve()).then((()=>{if(e&&o)for(const{primitives:t}of o)for(const e of t)nd(e,n);if(i&&o&&l)for(const t of l)sd(t,n);return n}))}))}class fd{constructor(t){this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.hasPattern=!1,this.worldview=t.worldview;}updateFootprints(t,e){}prepare(){return function(){if(null!=Wf||null!=Zf)return null;if(null!=Xf)return Xf;const t=fetch(ne.BUILDING_GEN_URL);return Xf=function(t){let e,r,n,i;function s(){e=new Uint8Array(i.buffer),r=new Int32Array(i.buffer),n=new Float32Array(i.buffer);}function o(){throw new Error("Unexpected BuildingGen error.")}const a=()=>{},l={a:{a:o,f:function(t){const r=e.length,n=Math.max(t>>>0,Math.ceil(1.2*r)),o=Math.ceil((n-r)/65536);try{return i.grow(o),s(),!0}catch(t){return !1}},g:o,b:a,c:a,d:a,e:a}};return (WebAssembly.instantiateStreaming?WebAssembly.instantiateStreaming(t,l):t.then((t=>t.arrayBuffer())).then((t=>WebAssembly.instantiate(t,l)))).then((t=>{const o=t.instance.exports;return (0,o.g)(),i=o.f,s(),new Uf({setStyle:o.h,setAOOptions:o.i,setMetricOptions:o.j,setFacadeOptions:o.k,addFeature:o.l,addFacade:o.m,generateMesh:o.n,getLastError:o.o,getMeshCount:o.p,getPositionsPtr:o.q,getPositionsLength:o.r,getNormalsPtr:o.s,getNormalsLength:o.t,getColorsPtr:o.u,getColorsLength:o.v,getAOPtr:o.w,getAOLength:o.x,getIndicesPtr:o.y,getIndicesLength:o.z,getBuildingPart:o.A,getRingCount:o.B,getRingPtr:o.C,getRingLength:o.D,free:o.E,malloc:o.F,heapU8:e,heap32:r,heapF32:n})}))}(t).then((t=>(Xf=null,Wf=t,Wf))).catch((t=>{Gt("Could not load building-gen"),Xf=null,Zf=t;})),Xf}()}populate(t,e,r,n){}update(t,e,r,n,i,s,o){}isEmpty(){return !1}uploadPending(){return !1}upload(t){}destroy(){}getHeightAtTileCoord(t,e){return {height:Number.NEGATIVE_INFINITY,hidden:!0}}}let dd,md;qs(fd,"BuildingBucket",{omit:["layers"]});const yd=ta([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"},{name:"a_linesofar",components:1,type:"Float32"}],4),gd=ta([{name:"a_z_offset_width",components:3,type:"Float32"}],4),{members:xd}=yd,vd=ta([{name:"a_packed",components:3,type:"Float32"}]),{members:bd}=vd,wd=ta([{name:"a_pattern_data",components:3,type:"Float32"}]),{members:_d}=wd;class Ad{constructor(t,e){this.width=t,this.height=e,this.nextRow=0,this.image=new mh({width:t,height:e}),this.positions={},this.uploaded=!1;}getDash(t,e){const r=this.getKey(t,e);return this.positions[r]}trim(){const t=this.width,e=this.height=Lt(this.nextRow);this.image.resize({width:t,height:e});}getKey(t,e){return t.join(",")+e}getDashRanges(t,e,r){const n=[];let i=t.length%2==1?-t[t.length-1]*r:0,s=t[0]*r,o=!0;n.push({left:i,right:s,isDash:o,zeroLength:0===t[0]});let a=t[0];for(let e=1;e<t.length;e++){o=!o;const l=t[e];i=a*r,a+=l,s=a*r,n.push({left:i,right:s,isDash:o,zeroLength:0===l});}return n}addRoundDash(t,e,r){const n=e/2;for(let e=-r;e<=r;e++){const i=this.width*(this.nextRow+r+e);let s=0,o=t[s];for(let a=0;a<this.width;a++){a/o.right>1&&(o=t[++s]);const l=Math.abs(a-o.left),u=Math.abs(a-o.right),c=Math.min(l,u);let h;const p=e/r*(n+1);if(o.isDash){const t=n-Math.abs(p);h=Math.sqrt(c*c+t*t);}else h=n-Math.sqrt(c*c+p*p);this.image.data[i+a]=Math.max(0,Math.min(255,h+128));}}}addRegularDash(t,e){for(let e=t.length-1;e>=0;--e){const r=t[e],n=t[e+1];r.zeroLength?t.splice(e,1):n&&n.isDash===r.isDash&&(n.left=r.left,t.splice(e,1));}const r=t[0],n=t[t.length-1];r.isDash===n.isDash&&(r.left=n.left-this.width,n.right=r.right+this.width);const i=this.width*this.nextRow;let s=0,o=t[s];for(let r=0;r<this.width;r++){r/o.right>1&&(o=t[++s]);const n=Math.abs(r-o.left),a=Math.abs(r-o.right),l=Math.min(n,a);this.image.data[i+r]=Math.max(0,Math.min(255,(o.isDash?l:-l)+e+128));}}addDash(t,e){const r=this.getKey(t,e);if(this.positions[r])return this.positions[r];const n="round"===e,i=n?7:0,s=2*i+1;if(this.nextRow+s>this.height)return Gt("LineAtlas out of space"),null;0===t.length&&t.push(1);let o=0;for(let e=0;e<t.length;e++)t[e]<0&&(Gt("Negative value is found in line dasharray, replacing values with 0"),t[e]=0),o+=t[e];if(0!==o){const r=this.width/o,s=this.getDashRanges(t,this.width,r);n?this.addRoundDash(s,r,i):this.addRegularDash(s,"square"===e?.5*r:0);}const a=this.nextRow+i;this.nextRow+=s;const l={tl:[a,i],br:[o,0]};return this.positions[r]=l,l}}qs(Ad,"LineAtlas");const Md=Pu.VectorTileFeature.types,Id=Math.cos(Math.PI/180*37.5),Sd=Math.cos(Math.PI/180*5);class zd{constructor(t){this.evaluationGlobals={zoom:0,lineProgress:void 0},this.elevationType="none",this.zoom=t.zoom,this.evaluationGlobals.zoom=this.zoom,this.overscaling=t.overscaling,this.pixelRatio=t.pixelRatio,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.projection=t.projection,this.hasPattern=!1,this.hasCrossSlope=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={};})),this.layoutVertexArray=new ua,this.layoutVertexArray2=new ca,this.patternVertexArray=new ca,this.indexArray=new Aa,this.programConfigurations=new kl(t.layers,{zoom:t.zoom,lut:t.lut}),this.segments=new tl,this.maxLineLength=0,this.zOffsetVertexArray=new ca,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.tessellationStep=t.tessellationStep?t.tessellationStep:Cn/64,this.worldview=t.worldview;}updateFootprints(t,e){}populate(t,e,r,n){this.hasPattern=Jh("line",this.layers,this.pixelRatio,e);const i=this.layers[0].layout.get("line-sort-key");this.tileToMeter=au(r);const s=this.layers[0].layout.get("line-elevation-reference");if("hd-road-markup"===s)this.elevationType="road";else {const t=this.layers[0].layout.get("line-z-offset"),e=t.isConstant()&&!t.constantOr(0);this.elevationType="sea"!==s&&"ground"!==s&&e?"none":"offset","offset"===this.elevationType&&"none"===s&&Gt(`line-elevation-reference: ground is used for the layer ${this.layerIds[0]} because non-zero line-z-offset value was found.`);}const o=this.layers[0].layout.get("line-cross-slope");this.hasCrossSlope="offset"===this.elevationType&&void 0!==o;const a=[];for(const{feature:e,id:s,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=gu(e,t);if(!this.layers[0]._featureFilter.filter(new go(this.zoom,{worldview:this.worldview}),u,r))continue;const c=i?i.evaluate(u,{},r):void 0,h={id:s,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:yu(e,r,n),patterns:{},sortKey:c};a.push(h);}i&&a.sort(((t,e)=>t.sortKey-e.sortKey));const{lineAtlas:l,featureIndex:u}=e,c=this.addConstantDashes(l);for(const n of a){const{geometry:i,index:s,sourceLayerIndex:o}=n;if(c&&this.addFeatureDashes(n,l),this.hasPattern){const t=Qh("line",this.layers,n,this.zoom,this.pixelRatio,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,l.positions,e.availableImages,e.brightness,e.elevationFeatures);u.insert(t[s].feature,i,s,o,this.index);}}addConstantDashes(t){let e=!1;for(const r of this.layers){const n=r.paint.get("line-dasharray").value,i=r.layout.get("line-cap").value;if("constant"!==n.kind||"constant"!==i.kind)e=!0;else {const e=i.value,r=n.value;if(!r)continue;t.addDash(r,e);}}return e}addFeatureDashes(t,e){const r=this.zoom;for(const n of this.layers){const i=n.paint.get("line-dasharray").value,s=n.layout.get("line-cap").value;if("constant"===i.kind&&"constant"===s.kind)continue;let o,a;if("constant"===i.kind){if(o=i.value,!o)continue}else o=i.evaluate({zoom:r},t);a="constant"===s.kind?s.value:s.evaluate({zoom:r},t),e.addDash(o,a),t.patterns[n.id]=[e.getKey(o,a)];}}update(t,e,r,n,i,s,o,a){this.programConfigurations.updatePaintArrays(t,e,i,r,n,s,o,a);}addFeatures(t,e,r,n,i,s){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r,n,s);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,bd)),0!==this.patternVertexArray.length&&(this.patternVertexBuffer=t.createVertexBuffer(this.patternVertexArray,_d)),!this.zOffsetVertexBuffer&&this.zOffsetVertexArray.length>0&&(this.zOffsetVertexBuffer=t.createVertexBuffer(this.zOffsetVertexArray,gd.members,!0)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,xd),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.zOffsetVertexBuffer&&this.zOffsetVertexBuffer.destroy(),this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}lineFeatureClips(t){if(t.properties&&t.properties.hasOwnProperty("mapbox_clip_start")&&t.properties.hasOwnProperty("mapbox_clip_end"))return {start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,n,i,s,o,a){const l=this.layers[0].layout,u=l.get("line-join").evaluate(t,{}),c=l.get("line-cap").evaluate(t,{}),h=l.get("line-miter-limit"),p=l.get("line-round-limit");this.lineClips=this.lineFeatureClips(t),this.lineFeature=t,this.zOffsetValue=l.get("line-z-offset").value;const f=this.layers[0].paint.get("line-width").value;if("constant"!==f.kind&&!1===f.isLineProgressConstant&&(this.variableWidthValue=f),"road"===this.elevationType){const r=this.layoutVertexArray.length;if(!this.addElevatedRoadFeature(t,e,n,a,u,c,h,p)){const[i,s]=this.clipRuntimeLinesToTile(e,1);for(let e=0;e<i.length;e++){const r=i[e],o=s[e],a={progress:{min:o.progress.min,max:o.progress.max},nextDir:this.computeSegNextDir(o,r),prevDir:this.computeSegPrevDir(o,r)};this.addLine(r,t,n,u,c,h,p,a);}this.fillNonElevatedRoadSegment(r);}}else for(const r of e)this.addLine(r,t,n,u,c,h,p);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,s,n,o,void 0,this.worldview);}computeSegNextDir(t,e){return t.nextPoint.sub(e.at(-2)).unit()}computeSegPrevDir(t,e){return e[1].sub(t.prevPoint).unit()}clipLinesToTile(t,e){return Mf(t,-e,-e,Cn+e,Cn+e)}clipRuntimeLinesToTile(t,e){const r=[];return [Mf(t,-e,-e,Cn+e,Cn+e,r),r]}addElevatedRoadFeature(t,e,r,n,i,s,o,a){const l=[],u=Zu.getElevationFeature(t,n);if(u){const t=this.clipLinesToTile(e,1),n=this.prepareElevatedLines(t,u,r);for(const t of n)l.push({geometry:t,elevation:u,elevationTileID:r,segment:{progress:{min:0,max:1},nextDir:void 0,prevDir:void 0}});}if(0===l.length)return !1;for(const e of l){const n=this.layoutVertexArray.length;this.addLine(e.geometry,t,r,i,s,o,a);const l=new Wu(r,e.elevationTileID);if(e.elevation)for(let t=n;t<this.layoutVertexArray.length;t++){const r=new bt(this.layoutVertexArray.int16[6*t]>>1,this.layoutVertexArray.int16[6*t+1]>>1),n=l.pointElevation(r,e.elevation,.05);this.updateHeightRange(n),this.zOffsetVertexArray.emplaceBack(n,0,0);}else this.fillNonElevatedRoadSegment(n);}return !0}prepareElevatedLines(t,e,r){if(null!=e.constantHeight)return t;const n=[],i=1/au(r);for(const r of t)If(r,new Hu(e,i),0,n);return n}fillNonElevatedRoadSegment(t){for(let e=t;e<this.layoutVertexArray.length;e++)this.zOffsetVertexArray.emplaceBack(0,0,0);}updateHeightRange(t){this.heightRange?(this.heightRange.min=Math.min(this.heightRange.min,t),this.heightRange.max=Math.max(this.heightRange.max,t)):this.heightRange={min:t,max:t};}addLine(t,e,r,n,i,s,o,a){this.distance=0,this.prevDistance=0,this.scaledDistance=0,this.totalDistance=0,this.totalFeatureLength=0,this.lineSoFar=0,this.currentVertex=void 0;const l="none"===n;this.patternJoinNone=this.hasPattern&&l,this.segmentStart=0,this.segmentStartf32=0,this.segmentPoints=[];const u=a&&a.progress.min>0,c=a&&a.progress.max<1;if(this.lineClips){let r={min:this.lineClips.start,max:this.lineClips.end},n=1;if(a){const t=this.lineClips.end-this.lineClips.start;r=function(t,e,r){return {min:re(t.min,e,r),max:re(t.max,e,r)}}(a.progress,{min:0,max:1},r),t>0&&(n=(r.max-r.min)/t);}const i=+e.properties.mapbox_clip_feature_len,s=+e.properties.mapbox_clip_seg_len;if(Number.isNaN(i)||Number.isNaN(s)){for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);const e=this.totalDistance/(r.max-r.min);this.totalFeatureLength=Number.isFinite(e)?e:0,this.lineClips.start=r.min,this.lineClips.end=r.max,this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}else this.totalFeatureLength=i,this.distance=s*n,this.lineClips.start=r.min,this.lineClips.end=r.max,this.maxLineLength=Math.max(this.maxLineLength,this.distance);this.lineClipsArray.push(this.lineClips),this.updateScaledDistance();}const h="Polygon"===Md[e.type];let p=t.length;for(;p>=2&&t[p-1].equals(t[p-2]);)p--;let f=0;for(;f<p-1&&t[f].equals(t[f+1]);)f++;if(p<(h?3:2))return;"bevel"===n&&(s=1.05);const d=this.segments.prepareSegment(10*p,this.layoutVertexArray,this.indexArray);let m,y,g,x,v,b,w,_;a&&a.prevDir&&(b=a.prevDir.perp()),a&&a.nextDir&&(w=a.nextDir.perp()),this.e1=this.e2=-1,h&&(m=t[p-2],v=t[f].sub(m)._unit()._perp());for(let e=f;e<p;e++){if(g=e===p-1?h?t[f+1]:void 0:t[e+1],g&&t[e].equals(g))continue;v&&(x=v),m&&(y=m),m=t[e],_=this.evaluateLineProgressFeatures(y?y.dist(m):0),v=g?g.sub(m)._unit()._perp():x,x=x||v;const r=y&&g;let a=r?n:h||l?"butt":i;const A=x.x*v.x+x.y*v.y;if(l){const t=function(t){if(t.patternJoinNone){const e=t.segmentPoints.length/2,r=t.lineSoFar-t.segmentStart;for(let n=0;n<e;++n){const e=t.segmentPoints[2*n+1],i=Math.round(t.segmentPoints[2*n])+.5+.25*e;t.patternVertexArray.emplaceBack(i,r,t.segmentStart),t.patternVertexArray.emplaceBack(i,r,t.segmentStart);}t.segmentPoints.length=0;}t.e1=t.e2=-1;};if(r&&A<Sd){this.updateDistance(y,m),this.addCurrentVertex(m,x,1,1,d,_),t(this),this.addCurrentVertex(m,v,-1,-1,d,_);continue}if(y){if(!g){this.updateDistance(y,m),this.addCurrentVertex(m,x,1,1,d,_),t(this);continue}a="miter";}}let M=x.add(v);0===M.x&&0===M.y||M._unit();const I=M.x*v.x+M.y*v.y,S=0!==I?1/I:1/0,z=2*Math.sqrt(2-2*I),k=I<Id&&y&&g,P=x.x*v.y-x.y*v.x>0,E=this.overscaling<=16?15*Cn/(512*this.overscaling):0;if(r&&"round"===a)if(S<o)a="miter";else if(S<=2){const t=kd(m,-10,Cn+10);a="offset"===this.elevationType&&(t||this.hasCrossSlope)?"miter":"fakeround";}if("miter"===a&&S>s&&(a="bevel"),"bevel"===a&&(S>2&&(a="flipbevel"),S<s&&(a="miter")),y&&!("miter"===a&&k)&&this.updateDistance(y,m),"miter"===a)if(k){const t=m.dist(y);if(t>2*E){const e=m.sub(m.sub(y)._mult(E/t)._round());this.updateDistance(y,e),this.addCurrentVertex(e,x,0,0,d,_),y=e;}this.updateDistance(y,m),M._mult(S),this.addCurrentVertex(m,M,0,0,d,_);const e=m.dist(g);if(e>2*E){const t=m.add(g.sub(m)._mult(E/e)._round());this.updateDistance(m,t),this.addCurrentVertex(t,v,0,0,d,_),m=t;}}else M._mult(S),this.addCurrentVertex(m,M,0,0,d,_);else if("flipbevel"===a){if(S>100)M=v.mult(-1);else {const t=S*x.add(v).mag()/x.sub(v).mag();M._perp()._mult(t*(P?-1:1));}this.addCurrentVertex(m,M,0,0,d,_),this.addCurrentVertex(m,M.mult(-1),0,0,d,_);}else if("bevel"===a||"fakeround"===a){null!=_&&y&&this.addCurrentVertex(m,w||x,-1,-1,d,_);const t=m.dist(y)<=2*E&&"bevel"!==a,e=M.mult(P?1:-1);e._mult(S);const r=v.mult(P?-1:1),n=x.mult(P?-1:1),i=this.evaluateLineProgressFeatures(this.distance);if(null==_&&(this.addHalfVertex(m,e.x,e.y,!1,!P,0,d,i),t||this.addHalfVertex(m,e.x+2*n.x,e.y+2*n.y,!1,P,0,d,i)),"fakeround"===a){const t=Math.round(180*z/Math.PI/20);this.addHalfVertex(m,n.x,n.y,!1,P,0,d,i);for(let e=0;e<t;e++){let s=e/t;if(.5!==s){const t=s-.5;s+=s*t*(s-1)*((1.0904+A*(A*(3.55645-1.43519*A)-3.2452))*t*t+(.848013+A*(.215638*A-1.06021)));}const o=r.sub(n)._mult(s)._add(n)._unit();this.addHalfVertex(m,o.x,o.y,!1,P,0,d,i);}this.addHalfVertex(m,r.x,r.y,!1,P,0,d,i);}t||null!=_||this.addHalfVertex(m,e.x+2*r.x,e.y+2*r.y,!1,P,0,d,i),null!=_&&g&&this.addCurrentVertex(m,b||v,1,1,d,_);}else if("butt"===a)this.addCurrentVertex(m,M,0,0,d,_);else if("square"===a){if(!y){const t=u?0:-1;this.addCurrentVertex(m,M,t,t,d,_);}if(this.addCurrentVertex(m,M,0,0,d,_),y){const t=c?0:1;this.addCurrentVertex(m,M,t,t,d,_);}}else if("round"===a){if(y){const t=!r&&w?w:x;this.addCurrentVertex(m,t,0,0,d,_),!r&&c||this.addCurrentVertex(m,t,1,1,d,_,!0);}if(g){const t=!r&&b?b:v;!r&&u||this.addCurrentVertex(m,t,-1,-1,d,_,!0),this.addCurrentVertex(m,t,0,0,d,_);}}}}addVerticesTo(t,e,r,n,i,s,o,a,l,u){const c=(e.w-t.w)/this.tessellationStep|0;let h=0;const p=this.scaledDistance;if(c>1){this.lineSoFar=t.w;const p=(e.x-t.x)/c,f=(e.y-t.y)/c,d=(e.z-t.z)/c,m=(e.w-t.w)/c;for(let e=1;e<c;++e){t.x+=p,t.y+=f,t.z+=d,this.lineSoFar+=m,h+=m;const e=this.evaluateLineProgressFeatures(this.prevDistance+h);this.scaledDistance=(this.prevDistance+h)/this.totalDistance,this.addHalfVertex(t,r,n,u,!1,o,l,e),this.addHalfVertex(t,i,s,u,!0,-a,l,e);}}this.lineSoFar=e.w,this.scaledDistance=p;const f=this.evaluateLineProgressFeatures(this.distance);this.addHalfVertex(e,r,n,u,!1,o,l,f),this.addHalfVertex(e,i,s,u,!0,-a,l,f);}evaluateLineProgressFeatures(t){if(!this.variableWidthValue&&"offset"!==this.elevationType)return null;this.evaluationGlobals.lineProgress=0,this.lineClips?this.evaluationGlobals.lineProgress=Math.min(1,(this.totalFeatureLength*this.lineClips.start+t)/this.totalFeatureLength):Gt(`line-progress evaluation for ${this.layerIds[0]} requires enabling 'lineMetrics' for the source.`);let e=0;return this.variableWidthValue&&"constant"!==this.variableWidthValue.kind&&(e=this.variableWidthValue.evaluate(this.evaluationGlobals,this.lineFeature)||0),"offset"!==this.elevationType?{zOffset:0,variableWidth:e}:"constant"===this.zOffsetValue.kind?{zOffset:this.zOffsetValue.value,variableWidth:e}:{zOffset:this.zOffsetValue.evaluate(this.evaluationGlobals,this.lineFeature)||0,variableWidth:e}}addCurrentVertex(t,e,r,n,i,s,o=!1){const a=e.x+e.y*r,l=e.y-e.x*r,u=e.y*n-e.x,c=-e.y-e.x*n;if(null!=s){const e="offset"===this.elevationType,h=-10,p=Cn+10,f=s.zOffset,d=new wf(t.x,t.y,f,this.lineSoFar),m=!!e&&kd(t,h,p),y=this.lineSoFar,g=this.distance;if(this.currentVertex)if(m){const e=this.currentVertexIsOutside,s=this.currentVertex,m=new wf(t.x,t.y,f,this.lineSoFar);if(Af(s,m,h,p),!kd(m,h,p)){if(e){this.e1=this.e2=-1,this.distance-=s.dist(d),this.lineSoFar=s.w;const t=this.evaluateLineProgressFeatures(s.w-this.totalFeatureLength*(this.lineClips?this.lineClips.start:0));this.addHalfVertex(s,a,l,o,!1,r,i,t),this.addHalfVertex(s,u,c,o,!0,-n,i,t),this.prevDistance=this.distance;}this.distance=this.prevDistance+s.dist(m),this.scaledDistance=this.distance/this.totalDistance,this.addVerticesTo(s,m,a,l,u,c,r,n,i,o),this.distance=g,this.scaledDistance=this.distance/this.totalDistance;}}else {const t=this.currentVertex;if(this.currentVertexIsOutside){Af(t,d,h,p),this.e1=this.e2=-1,this.distance-=t.dist(d),this.scaledDistance=this.distance/this.totalDistance,this.lineSoFar=t.w;const e=this.evaluateLineProgressFeatures(t.w-this.totalFeatureLength*(this.lineClips?this.lineClips.start:0));this.addHalfVertex(t,a,l,o,!1,r,i,e),this.addHalfVertex(t,u,c,o,!0,-n,i,e),this.prevDistance=this.distance,this.distance=g,this.scaledDistance=this.distance/this.totalDistance;}this.addVerticesTo(t,d,a,l,u,c,r,n,i,o);}else m||(this.addHalfVertex(t,a,l,o,!1,r,i,s),this.addHalfVertex(t,u,c,o,!0,-n,i,s));this.currentVertex=d,this.currentVertexIsOutside=m,this.lineSoFar=y;}else this.addHalfVertex(t,a,l,o,!1,r,i,s),this.addHalfVertex(t,u,c,o,!0,-n,i,s);}addHalfVertex({x:t,y:e},r,n,i,s,o,a,l){if(this.patternJoinNone&&(0===this.segmentPoints.length&&(this.segmentStart=this.lineSoFar,this.segmentStartf32=Math.fround(this.lineSoFar)),s||this.segmentPoints.push(this.lineSoFar-this.segmentStart,o)),this.layoutVertexArray.emplaceBack((t<<1)+(i?1:0),(e<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===o?0:o<0?-1:1),0,this.lineSoFar-this.segmentStartf32),this.lineClips){const t=ur(this.lineClips.start,this.lineClips.end,this.scaledDistance);this.layoutVertexArray2.emplaceBack(this.scaledDistance,this.lineClipsArray.length,t);}const u=a.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,this.e2,u),a.primitiveLength++),s?this.e2=u:this.e1=u,null!=l&&this.zOffsetVertexArray.emplaceBack(l.zOffset,l.variableWidth,l.variableWidth);}updateScaledDistance(){this.lineClips?(this.scaledDistance=this.distance/this.totalDistance,this.lineSoFar=this.totalFeatureLength*this.lineClips.start+this.distance):this.lineSoFar=this.distance;}updateDistance(t,e){this.prevDistance=this.distance,this.distance+=t.dist(e),this.updateScaledDistance();}}function kd(t,e,r){return t.x<e||t.x>r||t.y<e||t.y>r}let Pd,Ed;function Td(t,e,r){return e*(Cn/(t.tileSize*Math.pow(2,r-t.tileID.overscaledZ)))}qs(zd,"LineBucket",{omit:["layers","patternFeatures","currentVertex","currentVertexIsOutside"]});const Bd=(t,e,r)=>(1-r)*t+r*e;function Vd(t,e){return 1/Td(t,1,e.tileZoom)}function Cd(t,e,r,n){return t.translatePosMatrix(n||e.tileID.projMatrix,e,r.paint.get("line-translate"),r.paint.get("line-translate-anchor"))}const Fd=t=>{const e=[];Dd(t)&&e.push("RENDER_LINE_DASH"),t.paint.get("line-gradient")&&e.push("RENDER_LINE_GRADIENT");const r=t.paint.get("line-trim-offset");0===r[0]&&0===r[1]||e.push("RENDER_LINE_TRIM_OFFSET"),0!==t.paint.get("line-border-width").constantOr(1)&&e.push("RENDER_LINE_BORDER");const n="none"===t.layout.get("line-join").constantOr("miter"),i=!!t.paint.get("line-pattern").constantOr(1);return n&&i&&e.push("LINE_JOIN_NONE"),e};function Dd(t){const e=t.paint.get("line-dasharray").value;return e.value||"constant"!==e.kind}let Ld;const Rd=()=>Ld||(Ld={layout:Pd||(Pd=new Po({"line-cap":new zo(Eo.layout_line["line-cap"]),"line-join":new zo(Eo.layout_line["line-join"]),"line-miter-limit":new So(Eo.layout_line["line-miter-limit"]),"line-round-limit":new So(Eo.layout_line["line-round-limit"]),"line-sort-key":new zo(Eo.layout_line["line-sort-key"]),"line-z-offset":new zo(Eo.layout_line["line-z-offset"]),"line-elevation-reference":new So(Eo.layout_line["line-elevation-reference"]),"line-cross-slope":new So(Eo.layout_line["line-cross-slope"]),visibility:new So(Eo.layout_line.visibility),"line-width-unit":new So(Eo.layout_line["line-width-unit"])})),paint:Ed||(Ed=new Po({"line-opacity":new zo(Eo.paint_line["line-opacity"]),"line-color":new zo(Eo.paint_line["line-color"]),"line-translate":new So(Eo.paint_line["line-translate"]),"line-translate-anchor":new So(Eo.paint_line["line-translate-anchor"]),"line-width":new zo(Eo.paint_line["line-width"]),"line-gap-width":new zo(Eo.paint_line["line-gap-width"]),"line-offset":new zo(Eo.paint_line["line-offset"]),"line-blur":new zo(Eo.paint_line["line-blur"]),"line-dasharray":new zo(Eo.paint_line["line-dasharray"]),"line-pattern":new zo(Eo.paint_line["line-pattern"]),"line-pattern-cross-fade":new So(Eo.paint_line["line-pattern-cross-fade"]),"line-gradient":new ko(Eo.paint_line["line-gradient"]),"line-trim-offset":new So(Eo.paint_line["line-trim-offset"]),"line-trim-fade-range":new So(Eo.paint_line["line-trim-fade-range"]),"line-trim-color":new So(Eo.paint_line["line-trim-color"]),"line-emissive-strength":new So(Eo.paint_line["line-emissive-strength"]),"line-border-width":new zo(Eo.paint_line["line-border-width"]),"line-border-color":new zo(Eo.paint_line["line-border-color"]),"line-occlusion-opacity":new So(Eo.paint_line["line-occlusion-opacity"]),"line-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"}),"line-gradient-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"}),"line-trim-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"}),"line-border-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"})}))},Ld);class Od extends zo{possiblyEvaluate(t,e){return e=new go(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,transition:e.transition,worldview:e.worldview}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,n){return e=Ct({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,n)}}let Ud;function Nd(t,e){return e>0?e+2*t:t}const jd=ta([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_tex_size",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),$d=ta([{name:"a_globe_anchor",components:3,type:"Int16"},{name:"a_globe_normal",components:3,type:"Float32"}],4),Gd=ta([{name:"a_projected_pos",components:4,type:"Float32"}],4);ta([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const qd=ta([{name:"a_auto_z_offset",components:1,type:"Float32"}],4),Hd=ta([{name:"a_x_axis",components:3,type:"Float32"},{name:"a_y_axis",components:3,type:"Float32"}]),Xd=ta([{name:"a_texb",components:2,type:"Uint16"}]),Zd=ta([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_elevation_from_sea",components:2,type:"Float32"}]),Wd=ta([{name:"a_size_scale",components:1,type:"Float32"},{name:"a_padding",components:2,type:"Float32"},{name:"a_auto_z_offset",components:1,type:"Float32"}]);ta([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Int16",name:"tileAnchorX"},{type:"Int16",name:"tileAnchorY"},{type:"Float32",name:"x1"},{type:"Float32",name:"y1"},{type:"Float32",name:"x2"},{type:"Float32",name:"y2"},{type:"Int16",name:"padding"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const Yd=ta([{name:"a_pos",components:3,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),Kd=ta([{name:"a_pos_2f",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);ta([{name:"triangle",components:3,type:"Uint16"}]),ta([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"},{type:"Uint8",name:"flipState"}]),ta([{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",components:2,name:"textOffset"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Float32",name:"zOffset"},{type:"Uint8",name:"hasIconTextFit"},{type:"Uint16",name:"elevationFeatureIndex"}]),ta([{type:"Float32",name:"offsetX"}]),ta([{type:"Int16",name:"x"},{type:"Int16",name:"y"}]);var Jd=24;function Qd(t,e,r){return t.sections.forEach((t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return "uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()),yo.applyArabicShaping&&(t=yo.applyArabicShaping(t)),t}(t.text,e,r);})),t}const tm={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂","←":"↑","→":"↓"};function em(t){return "︶"===t||"﹈"===t||"︸"===t||"﹄"===t||"﹂"===t||"︾"===t||"︼"===t||"︺"===t||"︘"===t||"﹀"===t||"︐"===t||"︓"===t||"︔"===t||"｀"===t||"￣"===t||"︑"===t||"︒"===t}function rm(t){return "︵"===t||"﹇"===t||"︷"===t||"﹃"===t||"﹁"===t||"︽"===t||"︻"===t||"︹"===t||"︗"===t||"︿"===t}var nm,im,sm,om={};
    /*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */function am(){return nm||(nm=1,om.read=function(t,e,r,n,i){var s,o,a=8*i-n-1,l=(1<<a)-1,u=l>>1,c=-7,h=r?i-1:0,p=r?-1:1,f=t[e+h];for(h+=p,s=f&(1<<-c)-1,f>>=-c,c+=a;c>0;s=256*s+t[e+h],h+=p,c-=8);for(o=s&(1<<-c)-1,s>>=-c,c+=n;c>0;o=256*o+t[e+h],h+=p,c-=8);if(0===s)s=1-u;else {if(s===l)return o?NaN:1/0*(f?-1:1);o+=Math.pow(2,n),s-=u;}return (f?-1:1)*o*Math.pow(2,s-n)},om.write=function(t,e,r,n,i,s){var o,a,l,u=8*s-i-1,c=(1<<u)-1,h=c>>1,p=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,f=n?0:s-1,d=n?1:-1,m=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(a=isNaN(e)?1:0,o=c):(o=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-o))<1&&(o--,l*=2),(e+=o+h>=1?p/l:p*Math.pow(2,1-h))*l>=2&&(o++,l/=2),o+h>=c?(a=0,o=c):o+h>=1?(a=(e*l-1)*Math.pow(2,i),o+=h):(a=e*Math.pow(2,h-1)*Math.pow(2,i),o=0));i>=8;t[r+f]=255&a,f+=d,a/=256,i-=8);for(o=o<<i|a,u+=i;u>0;t[r+f]=255&o,f+=d,o/=256,u-=8);t[r+f-d]|=128*m;}),om}function lm(){if(sm)return im;sm=1,im=e;var t=am();function e(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length;}e.Varint=0,e.Fixed64=1,e.Bytes=2,e.Fixed32=5;var r=4294967296,n=1/r,i="undefined"==typeof TextDecoder?null:new TextDecoder("utf8");function s(t){return t.type===e.Bytes?t.readVarint()+t.pos:t.pos+1}function o(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function a(t,e,r){var n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(var i=r.pos-1;i>=t;i--)r.buf[i+n]=r.buf[i];}function l(t,e){for(var r=0;r<t.length;r++)e.writeVarint(t[r]);}function u(t,e){for(var r=0;r<t.length;r++)e.writeSVarint(t[r]);}function c(t,e){for(var r=0;r<t.length;r++)e.writeFloat(t[r]);}function h(t,e){for(var r=0;r<t.length;r++)e.writeDouble(t[r]);}function p(t,e){for(var r=0;r<t.length;r++)e.writeBoolean(t[r]);}function f(t,e){for(var r=0;r<t.length;r++)e.writeFixed32(t[r]);}function d(t,e){for(var r=0;r<t.length;r++)e.writeSFixed32(t[r]);}function m(t,e){for(var r=0;r<t.length;r++)e.writeFixed64(t[r]);}function y(t,e){for(var r=0;r<t.length;r++)e.writeSFixed64(t[r]);}function g(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function x(t,e,r){t[r]=e,t[r+1]=e>>>8,t[r+2]=e>>>16,t[r+3]=e>>>24;}function v(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}return e.prototype={destroy:function(){this.buf=null;},readFields:function(t,e,r){for(r=r||this.length;this.pos<r;){var n=this.readVarint(),i=n>>3,s=this.pos;this.type=7&n,t(i,e,this),this.pos===s&&this.skip(n);}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=g(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=v(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=g(this.buf,this.pos)+g(this.buf,this.pos+4)*r;return this.pos+=8,t},readSFixed64:function(){var t=g(this.buf,this.pos)+v(this.buf,this.pos+4)*r;return this.pos+=8,t},readFloat:function(){var e=t.read(this.buf,this.pos,!0,23,4);return this.pos+=4,e},readDouble:function(){var e=t.read(this.buf,this.pos,!0,52,8);return this.pos+=8,e},readVarint:function(t){var e,r,n=this.buf;return e=127&(r=n[this.pos++]),r<128?e:(e|=(127&(r=n[this.pos++]))<<7,r<128?e:(e|=(127&(r=n[this.pos++]))<<14,r<128?e:(e|=(127&(r=n[this.pos++]))<<21,r<128?e:function(t,e,r){var n,i,s=r.buf;if(n=(112&(i=s[r.pos++]))>>4,i<128)return o(t,n,e);if(n|=(127&(i=s[r.pos++]))<<3,i<128)return o(t,n,e);if(n|=(127&(i=s[r.pos++]))<<10,i<128)return o(t,n,e);if(n|=(127&(i=s[r.pos++]))<<17,i<128)return o(t,n,e);if(n|=(127&(i=s[r.pos++]))<<24,i<128)return o(t,n,e);if(n|=(1&(i=s[r.pos++]))<<31,i<128)return o(t,n,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(r=n[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&i?function(t,e,r){return i.decode(t.subarray(e,r))}(this.buf,e,t):function(t,e,r){for(var n="",i=e;i<r;){var s,o,a,l=t[i],u=null,c=l>239?4:l>223?3:l>191?2:1;if(i+c>r)break;1===c?l<128&&(u=l):2===c?128==(192&(s=t[i+1]))&&(u=(31&l)<<6|63&s)<=127&&(u=null):3===c?(o=t[i+2],128==(192&(s=t[i+1]))&&128==(192&o)&&((u=(15&l)<<12|(63&s)<<6|63&o)<=2047||u>=55296&&u<=57343)&&(u=null)):4===c&&(o=t[i+2],a=t[i+3],128==(192&(s=t[i+1]))&&128==(192&o)&&128==(192&a)&&((u=(15&l)<<18|(63&s)<<12|(63&o)<<6|63&a)<=65535||u>=1114112)&&(u=null)),null===u?(u=65533,c=1):u>65535&&(u-=65536,n+=String.fromCharCode(u>>>10&1023|55296),u=56320|1023&u),n+=String.fromCharCode(u),i+=c;}return n}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,r){if(this.type!==e.Bytes)return t.push(this.readVarint(r));var n=s(this);for(t=t||[];this.pos<n;)t.push(this.readVarint(r));return t},readPackedSVarint:function(t){if(this.type!==e.Bytes)return t.push(this.readSVarint());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==e.Bytes)return t.push(this.readBoolean());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==e.Bytes)return t.push(this.readFloat());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==e.Bytes)return t.push(this.readDouble());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==e.Bytes)return t.push(this.readFixed32());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==e.Bytes)return t.push(this.readSFixed32());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==e.Bytes)return t.push(this.readFixed64());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==e.Bytes)return t.push(this.readSFixed64());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readSFixed64());return t},skip:function(t){var r=7&t;if(r===e.Varint)for(;this.buf[this.pos++]>127;);else if(r===e.Bytes)this.pos=this.readVarint()+this.pos;else if(r===e.Fixed32)this.pos+=4;else {if(r!==e.Fixed64)throw new Error("Unimplemented type: "+r);this.pos+=8;}},writeTag:function(t,e){this.writeVarint(t<<3|e);},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var r=new Uint8Array(e);r.set(this.buf),this.buf=r,this.length=e;}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),x(this.buf,t,this.pos),this.pos+=4;},writeSFixed32:function(t){this.realloc(4),x(this.buf,t,this.pos),this.pos+=4;},writeFixed64:function(t){this.realloc(8),x(this.buf,-1&t,this.pos),x(this.buf,Math.floor(t*n),this.pos+4),this.pos+=8;},writeSFixed64:function(t){this.realloc(8),x(this.buf,-1&t,this.pos),x(this.buf,Math.floor(t*n),this.pos+4),this.pos+=8;},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var r,n;if(t>=0?(r=t%4294967296|0,n=t/4294967296|0):(n=~(-t/4294967296),4294967295^(r=~(-t%4294967296))?r=r+1|0:(r=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7);}(r,0,e),function(t,e){var r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))));}(n,e);}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))));},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t);},writeBoolean:function(t){this.writeVarint(Boolean(t));},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,r){for(var n,i,s=0;s<e.length;s++){if((n=e.charCodeAt(s))>55295&&n<57344){if(!i){n>56319||s+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):i=n;continue}if(n<56320){t[r++]=239,t[r++]=191,t[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null;}else i&&(t[r++]=239,t[r++]=191,t[r++]=189,i=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240,t[r++]=n>>12&63|128),t[r++]=n>>6&63|128),t[r++]=63&n|128);}return r}(this.buf,t,this.pos);var r=this.pos-e;r>=128&&a(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r;},writeFloat:function(e){this.realloc(4),t.write(this.buf,e,this.pos,!0,23,4),this.pos+=4;},writeDouble:function(e){this.realloc(8),t.write(this.buf,e,this.pos,!0,52,8),this.pos+=8;},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var r=0;r<e;r++)this.buf[this.pos++]=t[r];},writeRawMessage:function(t,e){this.pos++;var r=this.pos;t(e,this);var n=this.pos-r;n>=128&&a(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n;},writeMessage:function(t,r,n){this.writeTag(t,e.Bytes),this.writeRawMessage(r,n);},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,l,e);},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,u,e);},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,p,e);},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,c,e);},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,h,e);},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,f,e);},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,d,e);},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,m,e);},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,y,e);},writeBytesField:function(t,r){this.writeTag(t,e.Bytes),this.writeBytes(r);},writeFixed32Field:function(t,r){this.writeTag(t,e.Fixed32),this.writeFixed32(r);},writeSFixed32Field:function(t,r){this.writeTag(t,e.Fixed32),this.writeSFixed32(r);},writeFixed64Field:function(t,r){this.writeTag(t,e.Fixed64),this.writeFixed64(r);},writeSFixed64Field:function(t,r){this.writeTag(t,e.Fixed64),this.writeSFixed64(r);},writeVarintField:function(t,r){this.writeTag(t,e.Varint),this.writeVarint(r);},writeSVarintField:function(t,r){this.writeTag(t,e.Varint),this.writeSVarint(r);},writeStringField:function(t,r){this.writeTag(t,e.Bytes),this.writeString(r);},writeFloatField:function(t,r){this.writeTag(t,e.Fixed32),this.writeFloat(r);},writeDoubleField:function(t,r){this.writeTag(t,e.Fixed64),this.writeDouble(r);},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e));}},im}var um=dt(lm());const cm=3;function hm(t,e,r){e.glyphs=[],1===t&&r.readMessage(pm,e);}function pm(t,e,r){if(3===t){const{id:t,bitmap:n,width:i,height:s,left:o,top:a,advance:l}=r.readMessage(fm,{});e.glyphs.push({id:t,bitmap:new mh({width:i+2*cm,height:s+2*cm},n),metrics:{width:i,height:s,left:o,top:a,advance:l}});}else 4===t?e.ascender=r.readSVarint():5===t&&(e.descender=r.readSVarint());}function fm(t,e,r){1===t?e.id=r.readVarint():2===t?e.bitmap=r.readBytes():3===t?e.width=r.readVarint():4===t?e.height=r.readVarint():5===t?e.left=r.readSVarint():6===t?e.top=r.readSVarint():7===t&&(e.advance=r.readVarint());}const dm=cm,mm={horizontal:1,vertical:2,horizontalOnly:3};class ym{constructor(){this.scale=1,this.fontStack="",this.image=null;}static forText(t,e){const r=new ym;return r.scale=t||1,r.fontStack=e,r}static forImage(t){const e=new ym;return e.image=t,e}}class gm{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null;}static fromFeature(t,e,r){const n=new gm;for(let i=0;i<t.sections.length;i++){const s=t.sections[i];s.image?n.addImageSection(s,r):n.addTextSection(s,e);}return n}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSections(){return this.sections}getSectionIndex(t){return this.sectionIndex[t]}getCodePoint(t){return this.text.codePointAt(t)}verticalizePunctuation(t){this.text=function(t,e){let r="";for(let n=0;n<t.length;n++){const i=t.charCodeAt(n+1)||null,s=t.charCodeAt(n-1)||null;r+=!e&&(i&&eo(i)&&!tm[t[n+1]]||s&&eo(s)&&!tm[t[n-1]])||!tm[t[n]]?t[n]:tm[t[n]];}return r}(this.text,t);}trim(){let t=0;for(let e=0;e<this.text.length&&vm[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&vm[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e);}substring(t,e){const r=new gm;return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((t,e)=>Math.max(t,this.sections[e].scale)),0)}addTextSection(t,e){this.text+=t.text,this.sections.push(ym.forText(t.scale,t.fontStack||e));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r);}addImageSection(t,e){const r=t.image?t.image.getPrimary():null;if(!r)return void Gt("Can't add FormattedSection with an empty image.");r.scaleSelf(e);const n=this.getNextImageSectionCharCode();n?(this.text+=String.fromCodePoint(n),this.sections.push(ym.forImage(r)),this.sectionIndex.push(this.sections.length-1)):Gt("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}}function xm(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,m=1){const y=gm.fromFeature(t,i,m);h===mm.vertical&&y.verticalizePunctuation(p);let g=[];const x=function(t,e,r,n,i,s){if(!t)return [];const o=[],a=function(t,e,r,n,i,s){let o=0;for(let r=0;r<t.length();r++){const a=t.getSection(r);o+=wm(t.getCodePoint(r),a,n,i,e,s);}return o/Math.max(1,Math.ceil(o/r))}(t,e,r,n,i,s),l=t.text.indexOf("​")>=0;let u=0;for(let r=0;r<t.length();r++){const h=t.getSection(r),p=t.getCodePoint(r);if(vm[p]||(u+=wm(p,h,n,i,e,s)),r<t.length()-1){const e=!((c=p)<11904||!(Ys["Bopomofo Extended"](c)||Ys.Bopomofo(c)||Ys["CJK Compatibility Forms"](c)||Ys["CJK Compatibility Ideographs"](c)||Ys["CJK Compatibility"](c)||Ys["CJK Radicals Supplement"](c)||Ys["CJK Strokes"](c)||Ys["CJK Symbols and Punctuation"](c)||Ys["CJK Unified Ideographs Extension A"](c)||Ys["CJK Unified Ideographs"](c)||Ys["Enclosed CJK Letters and Months"](c)||Ys["Halfwidth and Fullwidth Forms"](c)||Ys.Hiragana(c)||Ys["Ideographic Description Characters"](c)||Ys["Kangxi Radicals"](c)||Ys["Katakana Phonetic Extensions"](c)||Ys.Katakana(c)||Ys["Vertical Forms"](c)||Ys["Yi Radicals"](c)||Ys["Yi Syllables"](c)));(bm[p]||e||h.image)&&o.push(Mm(r+1,u,a,o,Am(p,t.getCodePoint(r+1),e&&l),!1));}}var c;return Im(Mm(t.length(),u,a,o,0,!0))}(y,u,s,e,n,f),{processBidirectionalText:v,processStyledBidirectionalText:b}=yo;if(v&&1===y.sections.length){const t=v(y.toString(),x);for(const e of t){const t=new gm;t.text=e,t.sections=y.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);g.push(t);}}else if(b){const t=b(y.text,y.sectionIndex,x);for(const e of t){const t=new gm;t.text=e[0],t.sectionIndex=e[1],t.sections=y.sections,g.push(t);}}else g=function(t,e){const r=[],n=t.text;let i=0;for(const n of e)r.push(t.substring(i,n)),i=n;return i<n.length&&r.push(t.substring(i,n.length)),r}(y,x);const w=[],_={positionedLines:w,text:y.toString(),top:c[1],bottom:c[1],left:c[0],right:c[0],writingMode:h,iconsInText:!1,verticalizable:!1,hasBaseline:!1};if(function(t,e,r,n,i,s,o,a,l,u,c,h){let p=0,f=0,d=0;const m="right"===a?1:"left"===a?0:.5;let y=!1;for(const t of i){const r=t.getSections();for(const t of r){if(t.image)continue;const r=e[t.fontStack];if(r&&(y=void 0!==r.ascender&&void 0!==r.descender,!y))break}if(!y)break}let g=0;for(const o of i){o.trim();const i=o.getMaxScale(),a=(i-1)*Jd,v={positionedGlyphs:[],lineOffset:0};t.positionedLines[g]=v;const b=v.positionedGlyphs;let w=0;if(!o.length()){f+=s,++g;continue}let _=0,A=0;for(let s=0;s<o.length();s++){const a=o.getSection(s),d=o.getSectionIndex(s),m=o.getCodePoint(s);let g=a.scale,v=null,M=null,I=null,S=Jd,z=0;l===mm.vertical&&(12312===(x=m)||12313===x||12316===x||12540===x||12448===x)&&(l=mm.horizontal);const k=!(l===mm.horizontal||!c&&!to(m)||c&&(vm[m]||ro(m)));if(a.image){const e=n.get(a.image.toString());if(!e)continue;I=a.image,t.iconsInText=t.iconsInText||!0,M=e.paddedRect;const r=e.displaySize;g=g*Jd/h,v={width:r[0],height:r[1],left:0,top:-3,advance:k?r[1]:r[0],localGlyph:!1},z=y?-v.height*g:i*Jd-17-r[1]*g,S=v.advance;const s=(k?r[0]:r[1])*g-Jd*i;s>0&&s>w&&(w=s);}else {const t=r[a.fontStack];if(!t)continue;t[m]&&(M=t[m]);const n=e[a.fontStack];if(!n)continue;const s=n.glyphs[m];if(!s)continue;if(v=s.metrics,S=8203!==m?Jd:0,y){const t=void 0!==n.ascender?Math.abs(n.ascender):0,e=void 0!==n.descender?Math.abs(n.descender):0,r=(t+e)*g;_<r&&(_=r,A=(t-e)/2*g),z=-t*g;}else z=(i-g)*Jd-17;}k?(t.verticalizable=!0,b.push({glyph:m,image:I,x:p,y:f+z,vertical:k,scale:g,localGlyph:v.localGlyph,fontStack:a.fontStack,sectionIndex:d,metrics:v,rect:M}),p+=S*g+u):(b.push({glyph:m,image:I,x:p,y:f+z,vertical:k,scale:g,localGlyph:v.localGlyph,fontStack:a.fontStack,sectionIndex:d,metrics:v,rect:M}),p+=v.advance*g+u);}0!==b.length&&(d=Math.max(p-u,d),y?zm(b,m,w,A,s*i/2):zm(b,m,w,0,s/2)),p=0;const M=s*i+w;v.lineOffset=Math.max(w,a),f+=M,++g;}var x;const v=f,{horizontalAlign:b,verticalAlign:w}=Sm(o);((function(t,e,r,n,i,s){const o=(e-r)*i,a=-s*n;for(const e of t)for(const t of e.positionedGlyphs)t.x+=o,t.y+=a;}))(t.positionedLines,m,b,w,d,v),t.top+=-w*v,t.bottom=t.top+v,t.left+=-b*d,t.right=t.left+d,t.hasBaseline=y;}(_,e,r,n,g,o,a,l,h,u,p,d),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return !1;return !0}(w))return _}const vm={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},bm={10:!0,32:!0,38:!0,40:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0};function wm(t,e,r,n,i,s){if(e.image){const t=n.get(e.image.toString());return t?t.displaySize[0]*e.scale*Jd/s+i:0}{const n=r[e.fontStack],s=n&&n.glyphs[t];return s?s.metrics.advance*e.scale+i:0}}function _m(t,e,r,n){const i=Math.pow(t-e,2);return n?t<e?i/2:2*i:i+Math.abs(r)*r}function Am(t,e,r){let n=0;return 10===t&&(n-=1e4),r&&(n+=150),40!==t&&65288!==t||(n+=50),41!==e&&65289!==e||(n+=50),n}function Mm(t,e,r,n,i,s){let o=null,a=_m(e,r,i,s);for(const t of n){const n=_m(e-t.x,r,i,s)+t.badness;n<=a&&(o=t,a=n);}return {index:t,x:e,priorBreak:o,badness:a}}function Im(t){return t?Im(t.priorBreak).concat(t.index):[]}function Sm(t){let e=.5,r=.5;switch(t){case "right":case "top-right":case "bottom-right":e=1;break;case "left":case "top-left":case "bottom-left":e=0;}switch(t){case "bottom":case "bottom-right":case "bottom-left":r=1;break;case "top":case "top-right":case "top-left":r=0;}return {horizontalAlign:e,verticalAlign:r}}function zm(t,e,r,n,i){if(!(e||r||n||i))return;const s=t.length-1,o=t[s],a=(o.x+o.metrics.advance*o.scale)*e;for(let e=0;e<=s;e++)t[e].x-=a,t[e].y+=r+n+i;}function km(t){return void 0!==t.imagePrimary&&void 0!==t.top&&void 0!==t.bottom&&void 0!==t.left&&void 0!==t.right}function Pm(t,e,r,n){const{horizontalAlign:i,verticalAlign:s}=Sm(n),o=r[0]-t.displaySize[0]*i,a=r[1]-t.displaySize[1]*s;return {imagePrimary:t,imageSecondary:e,top:a,bottom:a+t.displaySize[1],left:o,right:o+t.displaySize[0]}}function Em(t,e,r,n,i,s){const o=t.imagePrimary;let a;if(o.content){const t=o.content,e=o.pixelRatio||1;a=[t[0]/e,t[1]/e,o.displaySize[0]-t[2]/e,o.displaySize[1]-t[3]/e];}const l=e.left*s,u=e.right*s;let c,h,p,f;"width"===r||"both"===r?(f=i[0]+l-n[3],h=i[0]+u+n[1]):(f=i[0]+(l+u-o.displaySize[0])/2,h=f+o.displaySize[0]);const d=e.top*s,m=e.bottom*s;return "height"===r||"both"===r?(c=i[1]+d-n[0],p=i[1]+m+n[2]):(c=i[1]+(d+m-o.displaySize[1])/2,p=c+o.displaySize[1]),{imagePrimary:o,imageSecondary:void 0,top:c,right:h,bottom:p,left:f,collisionPadding:a}}function Tm(t){return !t.imagePrimary.stretchX}function Bm(t){return !t.imagePrimary.stretchY}function Vm(t){return {width:t.right-t.left,height:t.bottom-t.top}}const Cm=128;function Fm(t,e,r){const{expression:n}=e;if("constant"===n.kind)return {kind:"constant",layoutSize:n.evaluate(new go(t+1,{worldview:r}))};if("source"===n.kind)return {kind:"source"};{const{zoomStops:e,interpolationType:i}=n;let s=0;for(;s<e.length&&e[s]<=t;)s++;s=Math.max(0,s-1);let o=s;for(;o<e.length&&e[o]<t+1;)o++;o=Math.min(e.length-1,o);const a=e[s],l=e[o];return "composite"===n.kind?{kind:"composite",minZoom:a,maxZoom:l,interpolationType:i}:{kind:"camera",minZoom:a,maxZoom:l,minSize:n.evaluate(new go(a,{worldview:r})),maxSize:n.evaluate(new go(l,{worldview:r})),interpolationType:i}}}function Dm(t,{uSize:e,uSizeT:r},{lowerSize:n,upperSize:i}){return "source"===t.kind?n/Cm:"composite"===t.kind?ur(n/Cm,i/Cm,r):e}function Lm(t,e,r=1){let n=0,i=0;if("constant"===t.kind)i=t.layoutSize*r;else if("source"!==t.kind){const{interpolationType:s,minZoom:o,maxZoom:a}=t,l=s?Et(ji.interpolationFactor(s,e,o,a),0,1):0;"camera"===t.kind?i=ur(t.minSize,t.maxSize,l)*r:n=l*r;}return {uSizeT:n,uSize:i}}class Rm extends bt{constructor(t,e,r,n,i){super(t,e),this.angle=n,this.z=r,void 0!==i&&(this.segment=i);}clone(){return new Rm(this.x,this.y,this.z,this.angle,this.segment)}}function Om(t,e,r,n,i){if(void 0===e.segment)return !0;let s=e,o=e.segment+1,a=0;for(;a>-r/2;){if(o--,o<0)return !1;a-=t[o].dist(s),s=t[o];}a+=t[o].dist(t[o+1]),o++;const l=[];let u=0;for(;a<r/2;){const e=t[o],r=t[o+1];if(!r)return !1;let s=t[o-1].angleTo(e)-e.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:a,angleDelta:s}),u+=s;a-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return !1;o++,a+=e.dist(r);}return !0}function Um(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function Nm(t,e,r){return t?.6*e*r:0}function jm(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function $m(t,e,r,n,i,s){const o=Nm(r,i,s),a=jm(r,n)*s;let l=0;const u=Um(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1],s=n.dist(i);if(l+s>u){const c=(u-l)/s,h=ur(n.x,i.x,c),p=ur(n.y,i.y,c),f=new Rm(h,p,0,i.angleTo(n),r);return !o||Om(t,f,a,o,e)?f:void 0}l+=s;}}function Gm(t,e,r,n,i,s,o,a,l){const u=Nm(n,s,o),c=jm(n,i),h=c*o,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),qm(t,p?e/2*a%e:(c/2+2*s)*o*a%e,e,u,r,h,p,!1,l)}function qm(t,e,r,n,i,s,o,a,l){const u=s/2,c=Um(t);let h=0,p=e-r,f=[];for(let e=0;e<t.length-1;e++){const o=t[e],a=t[e+1],d=o.dist(a),m=a.angleTo(o);for(;p+r<h+d;){p+=r;const y=(p-h)/d,g=ur(o.x,a.x,y),x=ur(o.y,a.y,y);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new Rm(g,x,0,m,e);n&&!Om(t,r,s,n,i)||f.push(r);}}h+=d;}return a||f.length||o||(f=qm(t,h/2,r,n,i,s,o,!0,l)),f}function Hm(t){let e=0,r=0;for(const n of t)e+=n.w*n.h,r=Math.max(r,n.w);t.sort(((t,e)=>e.h-t.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let i=0,s=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,s=Math.max(s,e.y+e.h),i=Math.max(i,e.x+e.w),e.w===r.w&&e.h===r.h){const e=n.pop();t<n.length&&(n[t]=e);}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return {w:i,h:s,fill:e/(i*s)||0}}qs(Rm,"Anchor");const Xm=1;class Zm{static getImagePositionScale(t,e,r){if(e&&t&&t.options&&t.options.transform){const e=t.options.transform;return {x:e.a,y:e.d}}return {x:r,y:r}}constructor(t,e,r,n){this.paddedRect=t;const{pixelRatio:i,version:s,stretchX:o,stretchY:a,content:l,sdf:u,usvg:c}=e;this.pixelRatio=i,this.stretchX=o,this.stretchY=a,this.content=l,this.version=s,this.padding=r,this.sdf=u,this.usvg=c,this.scale=Zm.getImagePositionScale(n,c,i);}get tl(){return [this.paddedRect.x+this.padding,this.paddedRect.y+this.padding]}get br(){return [this.paddedRect.x+this.paddedRect.w-this.padding,this.paddedRect.y+this.paddedRect.h-this.padding]}get displaySize(){return [(this.paddedRect.w-2*this.padding)/this.scale.x,(this.paddedRect.h-2*this.padding)/this.scale.y]}}function Wm(t,e,r){const n=Fr.parse(t),i=function(t,e,r=[1,1]){return {x:0,y:0,w:(t.data?t.data.width:t.width*r[0])+2*e,h:(t.data?t.data.height:t.height*r[1])+2*e}}(e,r,[n.options.transform.a,n.options.transform.d]);return {bin:i,imagePosition:new Zm(i,e,r,n),imageVariant:n}}class Ym{constructor(t,e,r){const n=new Map,i=new Map;this.haveRenderCallbacks=[];const s=[];this.addImages(t,n,Xm,s),this.addImages(e,i,2,s);const{w:o,h:a}=Hm(s),l=new yh({width:o||1,height:a||1});for(const[e,i]of t.entries()){const t=n.get(e).paddedRect;yh.copy(i.data,l,{x:0,y:0},{x:t.x+Xm,y:t.y+Xm},i.data,r,i.sdf);}for(const[t,n]of e.entries()){const e=i.get(t),s=e.paddedRect;let o=e.padding;const a=s.x+o,u=s.y+o,c=n.data.width,h=n.data.height;o=o>1?o-1:o,yh.copy(n.data,l,{x:0,y:0},{x:a,y:u},n.data,r),yh.copy(n.data,l,{x:0,y:h-o},{x:a,y:u-o},{width:c,height:o},r),yh.copy(n.data,l,{x:0,y:0},{x:a,y:u+h},{width:c,height:o},r),yh.copy(n.data,l,{x:c-o,y:0},{x:a-o,y:u},{width:o,height:h},r),yh.copy(n.data,l,{x:0,y:0},{x:a+c,y:u},{width:o,height:h},r),yh.copy(n.data,l,{x:c-o,y:h-o},{x:a-o,y:u-o},{width:o,height:o},r),yh.copy(n.data,l,{x:0,y:h-o},{x:a+c,y:u-o},{width:o,height:o},r),yh.copy(n.data,l,{x:0,y:0},{x:a+c,y:u+h},{width:o,height:o},r),yh.copy(n.data,l,{x:c-o,y:0},{x:a-o,y:u+h},{width:o,height:o},r);}this.lut=r,this.image=l,this.iconPositions=n,this.patternPositions=i;}addImages(t,e,r,n){for(const[i,s]of t.entries()){const{bin:t,imagePosition:o,imageVariant:a}=Wm(i,s,r);e.set(i,o),n.push(t),s.hasRenderCallback&&this.haveRenderCallbacks.push(a.id);}}patchUpdatedImages(t,e,r){this.haveRenderCallbacks=this.haveRenderCallbacks.filter((e=>t.hasImage(e,r))),t.dispatchRenderCallbacks(this.haveRenderCallbacks,r);for(const n of t.getUpdatedImages(r)){for(const i of this.iconPositions.keys()){const s=Fr.parse(i);if(er.isEqual(s.id,n)){const s=t.getImage(n,r);this.patchUpdatedImage(this.iconPositions.get(i),s,e);}}for(const i of this.patternPositions.keys()){const s=Fr.parse(i);if(er.isEqual(s.id,n)){const s=t.getImage(n,r);this.patchUpdatedImage(this.patternPositions.get(i),s,e);}}}}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[n,i]=t.tl,s=t.sdf;if(this.lut||s){const t={width:e.data.width,height:e.data.height},o=new yh(t);yh.copy(e.data,o,{x:0,y:0},{x:0,y:0},t,this.lut,s),r.update(o,{position:{x:n,y:i}});}else r.update(e.data,{position:{x:n,y:i}});}}qs(Zm,"ImagePosition"),qs(Ym,"ImageAtlas");const Km=1e20;function Jm(t,e,r,n,i,s,o,a,l){for(let u=e;u<e+n;u++)Qm(t,r*s+u,s,i,o,a,l);for(let u=r;u<r+i;u++)Qm(t,u*s+e,1,n,o,a,l);}function Qm(t,e,r,n,i,s,o){s[0]=0,o[0]=-1e20,o[1]=Km,i[0]=t[e];for(let a=1,l=0,u=0;a<n;a++){i[a]=t[e+a*r];const n=a*a;do{const t=s[l];u=(i[a]-i[t]+n-t*t)/(a-t)/2;}while(u<=o[l]&&--l>-1);l++,s[l]=a,o[l]=u,o[l+1]=Km;}for(let a=0,l=0;a<n;a++){for(;o[l+1]<a;)l++;const n=s[l],u=a-n;t[e+a*r]=i[n]+u*u;}}const ty=2,ey={none:0,ideographs:1,all:2};class ry{constructor(t,e,r){this.requestManager=t,this.localGlyphMode=e,this.localFontFamily=r,this.urls={},this.entries={},this.localGlyphs={200:{},400:{},500:{},900:{}};}setURL(t,e){this.urls[e]=t;}getGlyphs(t,e,r){const n=[],i=this.urls[e]||ne.GLYPHS_URL;for(const e in t)for(const r of t[e])n.push({stack:e,id:r});Vt(n,(({stack:t,id:e},r)=>{let n=this.entries[t];n||(n=this.entries[t]={glyphs:{},requests:{},ranges:{},ascender:void 0,descender:void 0});let s=n.glyphs[e];if(void 0!==s)return void r(null,{stack:t,id:e,glyph:s});if(s=this._tinySDF(n,t,e),s)return n.glyphs[e]=s,void r(null,{stack:t,id:e,glyph:s});const o=Math.floor(e/256);if(256*o>65535)return Gt("glyphs > 65535 not supported"),void r(null,{stack:t,id:e,glyph:s});if(n.ranges[o])return void r(null,{stack:t,id:e,glyph:s});let a=n.requests[o];a||(a=n.requests[o]=[],ry.loadGlyphRange(t,o,i,this.requestManager,((t,e)=>{if(e){n.ascender=e.ascender,n.descender=e.descender;for(const t in e.glyphs)this._doesCharSupportLocalGlyph(+t)||(n.glyphs[+t]=e.glyphs[+t]);n.ranges[o]=!0;}for(const r of a)r(t,e);delete n.requests[o];}))),a.push(((n,i)=>{n?r(n):i&&r(null,{stack:t,id:e,glyph:i.glyphs[e]||null});}));}),((t,e)=>{if(t)r(t);else if(e){const t={};for(const{stack:r,id:n,glyph:i}of e)void 0===t[r]&&(t[r]={}),void 0===t[r].glyphs&&(t[r].glyphs={}),t[r].glyphs[n]=i&&{id:i.id,bitmap:i.bitmap.clone(),metrics:i.metrics},t[r].ascender=this.entries[r].ascender,t[r].descender=this.entries[r].descender;r(null,t);}}));}_doesCharSupportLocalGlyph(t){return this.localGlyphMode!==ey.none&&(this.localGlyphMode===ey.all?!!this.localFontFamily:!!this.localFontFamily&&(Ys["CJK Unified Ideographs"](t)||Ys["Hangul Syllables"](t)||Ys.Hiragana(t)||Ys.Katakana(t)||Ys["CJK Symbols and Punctuation"](t)||Ys["CJK Unified Ideographs Extension A"](t)||Ys["CJK Unified Ideographs Extension B"](t)||Ys.Osage(t)))}_tinySDF(t,e,r){const n=this.localFontFamily;if(!n||!this._doesCharSupportLocalGlyph(r))return;let i=t.tinySDF;if(!i){let r="400";/bold/i.test(e)?r="900":/medium/i.test(e)?r="500":/light/i.test(e)&&(r="200"),i=t.tinySDF=new ry.TinySDF({fontFamily:n,fontWeight:r,fontSize:24*ty,buffer:3*ty,radius:8*ty}),i.fontWeight=r;}if(this.localGlyphs[i.fontWeight][r])return this.localGlyphs[i.fontWeight][r];const s=String.fromCodePoint(r),{data:o,width:a,height:l,glyphWidth:u,glyphHeight:c,glyphLeft:h,glyphTop:p,glyphAdvance:f}=i.draw(s);return this.localGlyphs[i.fontWeight][r]={id:r,bitmap:new mh({width:a,height:l},o),metrics:{width:u/ty,height:c/ty,left:h/ty,top:p/ty-27,advance:f/ty,localGlyph:!0}}}}ry.loadGlyphRange=function(t,e,r,n,i){const s=256*e,o=s+255,a=n.transformRequest(n.normalizeGlyphsURL(r).replace("{fontstack}",t).replace("{range}",`${s}-${o}`),Be.Glyphs);De(a,((t,e)=>{if(t)i(t);else if(e){const t={},r=function(t){return new um(t).readFields(hm,{})}(e);for(const e of r.glyphs)t[e.id]=e;i(null,{glyphs:t,ascender:r.ascender,descender:r.descender});}}));},ry.TinySDF=class{constructor({fontSize:t=24,buffer:e=3,radius:r=8,cutoff:n=.25,fontFamily:i="sans-serif",fontWeight:s="normal",fontStyle:o="normal"}={}){this.buffer=e,this.cutoff=n,this.radius=r;const a=this.size=t+4*e,l=this._createCanvas(a),u=this.ctx=l.getContext("2d",{willReadFrequently:!0});u.font=`${o} ${s} ${t}px ${i}`,u.textBaseline="alphabetic",u.textAlign="left",u.fillStyle="black",this.gridOuter=new Float64Array(a*a),this.gridInner=new Float64Array(a*a),this.f=new Float64Array(a),this.z=new Float64Array(a+1),this.v=new Uint16Array(a);}_createCanvas(t){const e=document.createElement("canvas");return e.width=e.height=t,e}draw(t){const{width:e,actualBoundingBoxAscent:r,actualBoundingBoxDescent:n,actualBoundingBoxLeft:i,actualBoundingBoxRight:s}=this.ctx.measureText(t),o=Math.ceil(r),a=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(s-i))),l=Math.min(this.size-this.buffer,o+Math.ceil(n)),u=a+2*this.buffer,c=l+2*this.buffer,h=Math.max(u*c,0),p=new Uint8ClampedArray(h),f={data:p,width:u,height:c,glyphWidth:a,glyphHeight:l,glyphTop:o,glyphLeft:0,glyphAdvance:e};if(0===a||0===l)return f;const{ctx:d,buffer:m,gridInner:y,gridOuter:g}=this;d.clearRect(m,m,a,l),d.fillText(t,m,m+o);const x=d.getImageData(m,m,a,l);g.fill(Km,0,h),y.fill(0,0,h);for(let t=0;t<l;t++)for(let e=0;e<a;e++){const r=x.data[4*(t*a+e)+3]/255;if(0===r)continue;const n=(t+m)*u+e+m;if(1===r)g[n]=0,y[n]=Km;else {const t=.5-r;g[n]=t>0?t*t:0,y[n]=t<0?t*t:0;}}Jm(g,0,0,u,c,u,this.f,this.v,this.z),Jm(y,m,m,a,l,u,this.f,this.v,this.z);for(let t=0;t<h;t++){const e=Math.sqrt(g[t])-Math.sqrt(y[t]);p[t]=Math.round(255-255*(e/this.radius+this.cutoff));}return f}};const ny=Xm;function iy(t,e){return t+e[1]-e[0]}function sy(t,e,r,n,i=1){const s=[],o=t.imagePrimary,a=o.pixelRatio,l=o.paddedRect.w-2*ny,u=o.paddedRect.h-2*ny,c=(t.right-t.left)*i,h=(t.bottom-t.top)*i,p=o.stretchX||[[0,l]],f=o.stretchY||[[0,u]],d=p.reduce(iy,0),m=f.reduce(iy,0),y=l-d,g=u-m;let x=0,v=d,b=0,w=m,_=0,A=y,M=0,I=g;if(o.content&&n){const t=o.content;x=oy(p,0,t[0]),b=oy(f,0,t[1]),v=oy(p,t[0],t[2]),w=oy(f,t[1],t[3]),_=t[0]-x,M=t[1]-b,A=t[2]-t[0]-v,I=t[3]-t[1]-w;}const S=(n,s,l,u)=>{const p=ly(n.stretch-x,v,c,t.left*i),f=uy(n.fixed-_,A,n.stretch,d),y=ly(s.stretch-b,w,h,t.top*i),g=uy(s.fixed-M,I,s.stretch,m),S=ly(l.stretch-x,v,c,t.left*i),z=uy(l.fixed-_,A,l.stretch,d),k=ly(u.stretch-b,w,h,t.top*i),P=uy(u.fixed-M,I,u.stretch,m),E=new bt(p,y),T=new bt(S,y),B=new bt(S,k),V=new bt(p,k),C=new bt(f/a,g/a),F=new bt(z/a,P/a),D=e*Math.PI/180;if(D){const t=Math.sin(D),e=Math.cos(D),r=[e,-t,t,e];E._matMult(r),T._matMult(r),V._matMult(r),B._matMult(r);}const L=n.stretch+n.fixed,R=l.stretch+l.fixed,O=s.stretch+s.fixed,U=u.stretch+u.fixed,N=t.imageSecondary;return {tl:E,tr:T,bl:V,br:B,texPrimary:{x:o.paddedRect.x+ny+L,y:o.paddedRect.y+ny+O,w:R-L,h:U-O},texSecondary:N?{x:N.paddedRect.x+ny+L,y:N.paddedRect.y+ny+O,w:R-L,h:U-O}:void 0,writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:C,pixelOffsetBR:F,minFontScaleX:A/a/c,minFontScaleY:I/a/h,isSDF:r}};if(n&&(o.stretchX||o.stretchY)){const t=ay(p,y,d),e=ay(f,g,m);for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)s.push(S(n,e[t],i,e[t+1]));}}else s.push(S({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:l+1},{fixed:0,stretch:u+1}));return s}function oy(t,e,r){let n=0;for(const i of t)n+=Math.max(e,Math.min(r,i[1]))-Math.max(e,Math.min(r,i[0]));return n}function ay(t,e,r){const n=[{fixed:-1,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}),n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)});}return n.push({fixed:e+ny,stretch:r}),n}function ly(t,e,r,n){return t/e*r+n}function uy(t,e,r,n){return t-e*r/n}function cy(t,e,r,n){const i=e+t.positionedLines[n].lineOffset;return 0===n?r+i/2:r+(i+(e+t.positionedLines[n-1].lineOffset))/2}function hy(t,e=1,r=!1){let n=1/0,i=1/0,s=-1/0,o=-1/0;const a=t[0];for(let t=0;t<a.length;t++){const e=a[t];(!t||e.x<n)&&(n=e.x),(!t||e.y<i)&&(i=e.y),(!t||e.x>s)&&(s=e.x),(!t||e.y>o)&&(o=e.y);}const l=Math.min(s-n,o-i);let u=l/2;const c=new Vn([],py);if(0===l)return new bt(n,i);for(let e=n;e<s;e+=l)for(let r=i;r<o;r+=l)c.push(new fy(e+u,r+u,u,t));let h=function(t){let e=0,r=0,n=0;const i=t[0];for(let t=0,s=i.length,o=s-1;t<s;o=t++){const s=i[t],a=i[o],l=s.x*a.y-a.x*s.y;r+=(s.x+a.x)*l,n+=(s.y+a.y)*l,e+=3*l;}return new fy(r/e,n/e,0,t)}(t),p=c.length;for(;c.length;){const n=c.pop();(n.d>h.d||!h.d)&&(h=n,r&&console.log("found best %d after %d probes",Math.round(1e4*n.d)/1e4,p)),n.max-h.d<=e||(u=n.h/2,c.push(new fy(n.p.x-u,n.p.y-u,u,t)),c.push(new fy(n.p.x+u,n.p.y-u,u,t)),c.push(new fy(n.p.x-u,n.p.y+u,u,t)),c.push(new fy(n.p.x+u,n.p.y+u,u,t)),p+=4);}return r&&(console.log(`num probes: ${p}`),console.log(`best distance: ${h.d}`)),h.p}function py(t,e){return e.max-t.max}class fy{constructor(t,e,r,n){this.p=new bt(t,e),this.h=r,this.d=function(t,e){let r=!1,n=1/0;for(let i=0;i<e.length;i++){const s=e[i];for(let e=0,i=s.length,o=i-1;e<i;o=e++){const i=s[e],a=s[o];i.y>t.y!=a.y>t.y&&t.x<(a.x-i.x)*(t.y-i.y)/(a.y-i.y)+i.x&&(r=!r),n=Math.min(n,oc(t,i,a));}}return (r?1:-1)*Math.sqrt(n)}(this.p,n),this.max=this.d+this.h*Math.SQRT2;}}const dy=Object.keys,my=Number.POSITIVE_INFINITY,yy=Math.sqrt(2);function gy(t,[e,r]){let n=0,i=0;if(r===my){e<0&&(e=0);const r=e/yy;switch(t){case "top-right":case "top-left":i=r-7;break;case "bottom-right":case "bottom-left":i=7-r;break;case "bottom":i=7-e;break;case "top":i=e-7;}switch(t){case "top-right":case "bottom-right":n=-r;break;case "top-left":case "bottom-left":n=r;break;case "left":n=e;break;case "right":n=-e;}}else {switch(e=Math.abs(e),r=Math.abs(r),t){case "top-right":case "top-left":case "top":i=r-7;break;case "bottom-right":case "bottom-left":case "bottom":i=7-r;}switch(t){case "top-right":case "bottom-right":case "right":n=-e;break;case "top-left":case "bottom-left":case "left":n=e;}}return [n,i]}function xy(t,e,r,n,i,s,o,a,l){if(!e||!e.usvg)return;const u=Vm(n),c=Vm(i),h="both"!==s&&"width"!==s||!Tm(n)?1:c.width/u.width,p="both"!==s&&"height"!==s||!Bm(n)?1:c.height/u.height;r.scaleSelf(h,p);const f=r.toString();o.set(f,r),a.set(f,e);const{imagePosition:d}=Wm(f,e,Xm);l.set(f,d);}function vy(t,e,r,n,i,s,o,a,l){if(!t)return;const u=function(t,e,r,n,i,s){if("camera"===t.kind)return t.maxSize;if("composite"===t.kind){const n=e.possiblyEvaluate(new go(t.maxZoom,{worldview:s}),r).evaluate(i,{},r),o=e.possiblyEvaluate(new go(t.minZoom,{worldview:s}),r).evaluate(i,{},r);return Math.max(n,o)}return e.possiblyEvaluate(new go(n,{worldview:s})).evaluate(i,{},r)}(e,r,n,i,s,l);return t.scaleSelf(u*a*o)}function by(t,e,r,n,i,s,o,a,l){return {iconPrimary:vy(t.getPrimary(),e,r,n,i,s,o,a,l),iconSecondary:vy(t.getSecondary(),e,r,n,i,s,o,a,l)}}function wy(t,e,r){if(!e)return;const n=r.get(t.toString()),i=r.get(e.toString());i&&(n.paddedRect.w===i.paddedRect.w&&n.paddedRect.h===i.paddedRect.h||Gt(`Mismatch in icon variant sizes: ${t.toString()} and ${e.toString()}`),n.usvg!==i.usvg&&Gt(`Mismatch in icon variant image types: ${t.id} and ${e.id}`));}function _y(t,e,r,n){if(!t)return;const i=e.get(r.toString());if(t.imagePrimary=i,n){const r=e.get(n.toString());t.imageSecondary=r;}}function Ay(t,e){for(const r in t.horizontal)My(t.horizontal[r],e);My(t.vertical,e);}function My(t,e){if(t)for(const r of t.positionedLines)for(const t of r.positionedGlyphs)if(null!==t.image){const r=t.image.toString();t.rect=e.get(r).paddedRect;}}function Iy(t){switch(t){case "right":case "top-right":case "bottom-right":return "right";case "left":case "top-left":case "bottom-left":return "left"}return "center"}function Sy(t,e,r,n,i,s,o,a,l){const u=Ty(s.horizontal)||s.vertical,c=r.get("icon-text-fit-padding").evaluate(n,{},i);let h,p=e;return e&&"none"!==l&&(t.allowVerticalPlacement&&s.vertical&&(h=Em(e,s.vertical,l,c,a,o)),u&&(p=Em(e,u,l,c,a,o))),{defaultShapedIcon:p,verticallyShapedIcon:h}}function zy(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,m,y,g,x,v){let b=o.textMaxSize.evaluate(e,{},p);void 0===b?b=a*o.textScaleFactor:b*=o.textScaleFactor;const w=t.layers[0].layout,_=Ty(r.horizontal)||r.vertical,A="globe"===f.name,M=Jd,I=t.tilePixelRatio*b/M,S=(B=t.overscaling,t.zoom>18&&B>2&&(B>>=1),Math.max(Cn/(512*B),1)*w.get("symbol-spacing")),z=w.get("text-padding")*t.tilePixelRatio,k=w.get("icon-padding")*t.tilePixelRatio,P=Mt(w.get("text-max-angle")),E="map"===w.get("icon-rotation-alignment")&&"point"!==v,T=S/2;var B;!1===t.hasAnyIconTextFit&&"none"!==y&&(t.hasAnyIconTextFit=!0);const V=e.properties?+e.properties[Eu]:null,C=V&&t.elevationFeatureIdToIndex?t.elevationFeatureIdToIndex.get(V):65535,F=(a,l,v)=>{if(l.x<0||l.x>=Cn||l.y<0||l.y>=Cn)return;let b=null;if(A){const{x:t,y:e,z:r}=f.projectTilePoint(l.x,l.y,v);b={anchor:new Rm(t,e,r,0,void 0),up:f.upVector(v,l.x,l.y)};}!function(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,m,y,g,x,v,b,w,_,A,M,I,S,z,k){const P=t.addToLineVertexArray(e,n);let E,T,B,V,C,F,D,L=0,R=0,O=0,U=0,N=-1,j=-1;const $={};let G=We("");const q=r?r.anchor:e,H="none"!==z;let X=0,Z=0;if(void 0===l._unevaluatedLayout.getValue("text-radial-offset")){const t=l.layout.get("text-offset").evaluate(b,{},M);X=t[0]*Jd,Z=t[1]*Jd;}else X=l.layout.get("text-radial-offset").evaluate(b,{},M)*Jd,Z=my;if(t.allowVerticalPlacement&&i.vertical){const t=i.vertical;if(d)F=Vy(t),a&&(D=Vy(a));else {const r=l.layout.get("text-rotate").evaluate(b,{},M)+90;B=By(u,q,e,c,h,p,t,f,r,m),a&&(V=By(u,q,e,c,h,p,a,g,r));}}if(s){const n=t.iconSizeData,i=l.layout.get("icon-rotate").evaluate(b,{},M),o=sy(s,i,_,H,w.iconScaleFactor),f=a?sy(a,i,_,H,w.iconScaleFactor):void 0;T=By(u,q,e,c,h,p,s,g,i,null),L=4*o.length;let d=null;"source"===n.kind?(d=[Cm*l.layout.get("icon-size").evaluate(b,{},M)*w.iconScaleFactor],d[0]>Py&&Gt(`${t.layerIds[0]}: Value for "icon-size" is >= ${ky}. Reduce your "icon-size".`)):"composite"===n.kind&&(d=[Cm*w.compositeIconSizes[0].evaluate(b,{},M)*w.iconScaleFactor,Cm*w.compositeIconSizes[1].evaluate(b,{},M)*w.iconScaleFactor],(d[0]>Py||d[1]>Py)&&Gt(`${t.layerIds[0]}: Value for "icon-size" is >= ${ky}. Reduce your "icon-size".`)),t.addSymbols(t.icon,o,d,v,x,b,void 0,r,e,P.lineStartIndex,P.lineLength,-1,A,M,I,S),N=t.icon.placedSymbolArray.length-1,f&&(R=4*f.length,t.addSymbols(t.icon,f,d,v,x,b,mm.vertical,r,e,P.lineStartIndex,P.lineLength,-1,A,M,I,S),j=t.icon.placedSymbolArray.length-1);}for(const n in i.horizontal){const s=n,a=i.horizontal[s];E||(G=We(a.text),d?C=Vy(a):E=By(u,q,e,c,h,p,a,f,l.layout.get("text-rotate").evaluate(b,{},M),m));const y=1===a.positionedLines.length;if(O+=Ey(t,r,e,a,o,l,d,b,m,P,i.vertical?mm.horizontal:mm.horizontalOnly,y?dy(i.horizontal):[s],$,N,w,A,M,I),y)break}i.vertical&&(U+=Ey(t,r,e,i.vertical,o,l,d,b,m,P,mm.vertical,["vertical"],$,j,w,A,M,I));let W=-1;const Y=(t,e)=>t?Math.max(t,e):e;W=Y(C,W),W=Y(F,W),W=Y(D,W);const K=W>-1?1:0;t.glyphOffsetArray.length>=65535&&Gt("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==b.sortKey&&t.addToSortKeyRanges(t.symbolInstances.length,b.sortKey),t.symbolInstances.emplaceBack(e.x,e.y,q.x,q.y,q.z,$.right>=0?$.right:-1,$.center>=0?$.center:-1,$.left>=0?$.left:-1,$.vertical>=0?$.vertical:-1,N,j,G,void 0!==E?E:t.collisionBoxArray.length,void 0!==E?E+1:t.collisionBoxArray.length,void 0!==B?B:t.collisionBoxArray.length,void 0!==B?B+1:t.collisionBoxArray.length,void 0!==T?T:t.collisionBoxArray.length,void 0!==T?T+1:t.collisionBoxArray.length,V||t.collisionBoxArray.length,V?V+1:t.collisionBoxArray.length,c,O,U,L,R,K,0,X,Z,W,0,H?1:0,k);}(t,l,b,a,r,n,s,i,t.layers[0],t.collisionBoxArray,e.index,e.sourceLayerIndex,t.index,z,x,u,0,k,E,g,e,o,c,h,p,d,m,y,C);};if("line"===v)for(const i of Mf(e.geometry,0,0,Cn,Cn)){const e=Gm(i,S,P,r.vertical||_,n,M,I,t.overscaling,Cn);for(const r of e)_&&Cy(t,_.text,T,r)||F(i,r,p);}else if("line-center"===v){for(const t of e.geometry)if(t.length>1){const e=$m(t,P,r.vertical||_,n,M,I);e&&F(t,e,p);}}else if("Polygon"===e.type)for(const t of Wh(e.geometry,0)){const e=hy(t,16);F(t[0],new Rm(e.x,e.y,0,0,void 0),p);}else if("LineString"===e.type)for(const t of e.geometry)F(t,new Rm(t[0].x,t[0].y,0,0,void 0),p);else if("Point"===e.type)for(const t of e.geometry)for(const e of t)F([e],new Rm(e.x,e.y,0,0,void 0),p);}const ky=255,Py=ky*Cm;function Ey(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,m,y,g){const x=function(t,e,r,n,i,s,o,a){const l=[];if(0===e.positionedLines.length)return l;const u=n.layout.get("text-rotate").evaluate(s,{})*Math.PI/180,c=function(t){const e=t[0],r=t[1],n=e*r;return n>0?[e,-r]:n<0?[-e,r]:0===e?[r,e]:[r,-e]}(r);let h=Math.abs(e.top-e.bottom);for(const t of e.positionedLines)h-=t.lineOffset;const p=e.positionedLines.length,f=h/p;let d=e.top-r[1];for(let t=0;t<p;++t){const n=e.positionedLines[t];d=cy(e,f,d,t);for(const t of n.positionedGlyphs){if(!t.rect)continue;const n=t.rect||{};let s=dm+1,h=!0,p=1,f=0;if(t.image){const e=o.get(t.image.toString());if(!e)continue;if(e.sdf){Gt("SDF images are not supported in formatted text and will be ignored.");continue}h=!1,p=e.pixelRatio,s=Xm/p;}const m=(i||a)&&t.vertical,y=t.metrics.advance*t.scale/2,g=t.metrics,x=t.rect;if(null===x)continue;a&&e.verticalizable&&(f=t.image?y-t.metrics.width*t.scale/2:0);const v=i?[t.x+y,t.y]:[0,0];let b=[0,0],w=[0,0],_=!1;i||(m?(w=[t.x+y+c[0],t.y+c[1]-f],_=!0):b=[t.x+y+r[0],t.y+r[1]-f]);const A=x.w*t.scale/(p*(t.localGlyph?ty:1)),M=x.h*t.scale/(p*(t.localGlyph?ty:1));let I,S,z,k;if(m){const e=t.y-d,r=new bt(-y,y-e),n=-Math.PI/2,i=new bt(...w);I=new bt(-y+b[0],b[1]),I._rotateAround(n,r)._add(i),I.x+=-e+y,I.y-=(g.left-s)*t.scale;const o=t.image?g.advance*t.scale:Jd*t.scale,a=String.fromCodePoint(t.glyph);em(a)?I.x+=(1-s)*t.scale:rm(a)?I.x+=o-g.height*t.scale+(-s-1)*t.scale:I.x+=t.image||g.width+2*s===x.w&&g.height+2*s===x.h?(o-M)/2:(o-(g.height+2*s)*t.scale)/2,S=new bt(I.x,I.y-A),z=new bt(I.x+M,I.y),k=new bt(I.x+M,I.y-A);}else {const e=(g.left-s)*t.scale-y+b[0],r=(-g.top-s)*t.scale+b[1],n=e+A,i=r+M;I=new bt(e,r),S=new bt(n,r),z=new bt(e,i),k=new bt(n,i);}if(u){let t;t=i?new bt(0,0):_?new bt(c[0],c[1]):new bt(r[0],r[1]),I._rotateAround(u,t),S._rotateAround(u,t),z._rotateAround(u,t),k._rotateAround(u,t);}const P=new bt(0,0),E=new bt(0,0);l.push({tl:I,tr:S,bl:z,br:k,texPrimary:n,texSecondary:void 0,writingMode:e.writingMode,glyphOffset:v,sectionIndex:t.sectionIndex,isSDF:h,pixelOffsetTL:P,pixelOffsetBR:E,minFontScaleX:0,minFontScaleY:0});}}return l}(0,n,l,s,o,a,i,t.allowVerticalPlacement),v=t.textSizeData;let b=null;"source"===v.kind?(b=[Cm*s.layout.get("text-size").evaluate(a,{},y)*d.textScaleFactor],b[0]>Py&&Gt(`${t.layerIds[0]}: Value for "text-size" is >= ${ky}. Reduce your "text-size".`)):"composite"===v.kind&&(b=[Cm*d.compositeTextSizes[0].evaluate(a,{},y)*d.textScaleFactor,Cm*d.compositeTextSizes[1].evaluate(a,{},y)*d.textScaleFactor],(b[0]>Py||b[1]>Py)&&Gt(`${t.layerIds[0]}: Value for "text-size" is >= ${ky}. Reduce your "text-size".`)),t.addSymbols(t.text,x,b,l,o,a,c,e,r,u.lineStartIndex,u.lineLength,f,m,y,g,!1);for(const e of h)p[e]=t.text.placedSymbolArray.length-1;return 4*x.length}function Ty(t){for(const e in t)return t[e];return null}function By(t,e,r,n,i,s,o,a,l,u){let c=o.top,h=o.bottom,p=o.left,f=o.right;if(km(o)&&o.collisionPadding){const t=o.collisionPadding;p-=t[0],c-=t[1],f+=t[2],h+=t[3];}if(l){const t=new bt(p,c),e=new bt(f,c),r=new bt(p,h),n=new bt(f,h),i=Mt(l);let s=new bt(0,0);u&&(s=new bt(u[0],u[1])),t._rotateAround(i,s),e._rotateAround(i,s),r._rotateAround(i,s),n._rotateAround(i,s),p=Math.min(t.x,e.x,r.x,n.x),f=Math.max(t.x,e.x,r.x,n.x),c=Math.min(t.y,e.y,r.y,n.y),h=Math.max(t.y,e.y,r.y,n.y);}return t.emplaceBack(e.x,e.y,e.z,r.x,r.y,p,c,f,h,a,n,i,s),t.length-1}function Vy(t){km(t)&&t.collisionPadding&&(t.top-=t.collisionPadding[1],t.bottom+=t.collisionPadding[3]);const e=t.bottom-t.top;return e>0?Math.max(10,e):null}function Cy(t,e,r,n){const i=t.compareText;if(e in i){const t=i[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return !0}else i[e]=[];return i[e].push(n),!1}function Fy(t,e){const r=t.fovAboveCenter,n=t.elevation?t.elevation.getMinElevationBelowMSL()*e:0,i=(t._camera.position[2]*t.worldSize-n)/Math.cos(t._pitch),s=Math.sin(r)*i/Math.sin(Math.max(Math.PI/2-t._pitch-r,.01));let o=Math.sin(t._pitch)*s+i;const a=i*(1/t._horizonShift);if(!t.elevation||0===t.elevation.exaggeration()){let e=Math.max(t.zoom-17,0);t.isOrthographic&&(e/=10),o*=1+e;}return Math.min(1.01*o,a)}function Dy(t,e){if(!e.isReprojectedInTileSpace)return {scale:1<<t.z,x:t.x,y:t.y,x2:t.x+1,y2:t.y+1,projection:e};const r=Math.pow(2,-t.z),n=t.x*r,i=(t.x+1)*r,s=t.y*r,o=(t.y+1)*r,a=tu(n),l=tu(i),u=eu(s),c=eu(o),h=e.project(a,u),p=e.project(l,u),f=e.project(l,c),d=e.project(a,c);let m=Math.min(h.x,p.x,f.x,d.x),y=Math.min(h.y,p.y,f.y,d.y),g=Math.max(h.x,p.x,f.x,d.x),x=Math.max(h.y,p.y,f.y,d.y);const v=r/16;function b(t,r,n,i,s,o){const a=(n+s)/2,l=(i+o)/2,u=e.project(tu(a),eu(l)),c=Math.max(0,m-u.x,y-u.y,u.x-g,u.y-x);m=Math.min(m,u.x),g=Math.max(g,u.x),y=Math.min(y,u.y),x=Math.max(x,u.y),c>v&&(b(t,u,n,i,a,l),b(u,r,a,l,s,o));}b(h,p,n,s,i,s),b(p,f,i,s,i,o),b(f,d,i,o,n,o),b(d,h,n,o,n,s),m-=v,y-=v,g+=v,x+=v;const w=1/Math.max(g-m,x-y);return {scale:w,x:m*w,y:y*w,x2:g*w,y2:x*w,projection:e}}function Ly(t,{x:e,y:r},n=0){return new bt(((e-n)*t.scale-t.x)*Cn,(r*t.scale-t.y)*Cn)}const Ry=l(new Float32Array(16));class Oy{constructor(t){this.spec=t,this.name=t.name,this.wrap=!1,this.requiresDraping=!1,this.supportsWorldCopies=!1,this.supportsTerrain=!1,this.supportsFog=!1,this.supportsFreeCamera=!1,this.zAxisUnit="meters",this.isReprojectedInTileSpace=!0,this.unsupportedLayers=["custom"],this.center=[0,0],this.range=[3.5,7];}project(t,e){return {x:0,y:0,z:0}}unproject(t,e){return new Hl(0,0)}projectTilePoint(t,e,r){return {x:t,y:e,z:0}}locationPoint(t,e,r,n=!0){return t._coordinatePoint(t.locationCoordinate(e,r),n)}pixelsPerMeter(t,e){return Ql(1,t)*e}pixelSpaceConversion(t,e,r){return 1}farthestPixelDistance(t){return Fy(t,t.pixelsPerMeter)}pointCoordinate(t,e,r,n){const i=t.horizonLineFromTop(!1),s=new bt(e,Math.max(i,r));return t.rayIntersectionCoordinate(t.pointRayIntersection(s,n))}pointCoordinate3D(t,e,r){const n=new bt(e,r);if(t.elevation)return t.elevation.pointCoordinate(n);{const e=this.pointCoordinate(t,n.x,n.y,0);return [e.x,e.y,e.z]}}isPointAboveHorizon(t,e){if(t.elevation&&t.elevation.visibleDemTiles.length)return !this.pointCoordinate3D(t,e.x,e.y);const r=t.horizonLineFromTop();return e.y<r}createInversionMatrix(t,e){return Ry}createTileMatrix(t,e,r){let n,i,s;const o=r.canonical,a=l(new Float64Array(16));if(this.isReprojectedInTileSpace){const l=Dy(o,this);n=1,i=l.x+r.wrap*l.scale,s=l.y,p(a,a,[n/l.scale,n/l.scale,t.pixelsPerMeter/e]);}else n=e/t.zoomScale(o.z),i=(o.x+Math.pow(2,o.z)*r.wrap)*n,s=o.y*n;return h(a,a,[i,s,0]),p(a,a,[n/Cn,n/Cn,1]),a}upVector(t,e,r){return [0,0,1]}upVectorScale(t,e,r){return {metersToTile:1}}}class Uy extends Oy{constructor(t){super(t),this.range=[4,7],this.center=t.center||[-96,37.5];const[e,r]=this.parallels=t.parallels||[29.5,45.5],n=Math.sin(Mt(e));this.n=(n+Math.sin(Mt(r)))/2,this.c=1+n*(2*this.n-n),this.r0=Math.sqrt(this.c)/this.n;}project(t,e){const{n:r,c:n,r0:i}=this,s=Mt(t-this.center[0]),o=Mt(e),a=Math.sqrt(n-2*r*Math.sin(o))/r;return {x:a*Math.sin(s*r),y:a*Math.cos(s*r)-i,z:0}}unproject(t,e){const{n:r,c:n,r0:i}=this,s=i+e;let o=Math.atan2(t,Math.abs(s))*Math.sign(s);s*r<0&&(o-=Math.PI*Math.sign(t)*Math.sign(s));const a=Mt(this.center[0])*r;o=Bt(o,-Math.PI-a,Math.PI-a);const l=Et(It(o/r)+this.center[0],-180,180),u=Math.asin(Et((n-(t*t+s*s)*r*r)/(2*r),-1,1)),c=Et(It(u),-85.051129,nu);return new Hl(l,c)}}const Ny=1.340264,jy=-.081106,$y=893e-6,Gy=.003796,qy=Math.sqrt(3)/2;class Hy extends Oy{project(t,e){e=e/180*Math.PI,t=t/180*Math.PI;const r=Math.asin(qy*Math.sin(e)),n=r*r,i=n*n*n;return {x:.5*(t*Math.cos(r)/(qy*(Ny+3*jy*n+i*(7*$y+9*Gy*n)))/Math.PI+.5),y:1-.5*(r*(Ny+jy*n+i*($y+Gy*n))/Math.PI+1),z:0}}unproject(t,e){t=(2*t-.5)*Math.PI;let r=e=(2*(1-e)-1)*Math.PI,n=r*r,i=n*n*n;for(let t,s,o,a=0;a<12&&(s=r*(Ny+jy*n+i*($y+Gy*n))-e,o=Ny+3*jy*n+i*(7*$y+9*Gy*n),t=s/o,r=Et(r-t,-Math.PI/3,Math.PI/3),n=r*r,i=n*n*n,!(Math.abs(t)<1e-12));++a);const s=qy*t*(Ny+3*jy*n+i*(7*$y+9*Gy*n))/Math.cos(r),o=Math.asin(Math.sin(r)/qy),a=Et(180*s/Math.PI,-180,180),l=Et(180*o/Math.PI,-85.051129,nu);return new Hl(a,l)}}class Xy extends Oy{constructor(t){super(t),this.wrap=!0,this.supportsWorldCopies=!0;}project(t,e){return {x:.5+t/360,y:.5-e/360,z:0}}unproject(t,e){const r=360*(t-.5),n=Et(360*(.5-e),-85.051129,nu);return new Hl(r,n)}}const Zy=Math.PI/2;function Wy(t){return Math.tan((Zy+t)/2)}class Yy extends Oy{constructor(t){super(t),this.center=t.center||[0,30];const[e,r]=this.parallels=t.parallels||[30,30];let n=Mt(e),i=Mt(r);this.southernCenter=n+i<0,this.southernCenter&&(n=-n,i=-i);const s=Math.cos(n),o=Wy(n);this.n=n===i?Math.sin(n):Math.log(s/Math.cos(i))/Math.log(Wy(i)/o),this.f=s*Math.pow(Wy(n),this.n)/this.n;}project(t,e){e=Mt(e),this.southernCenter&&(e=-e),t=Mt(t-this.center[0]);const r=1e-6,{n,f:i}=this;i>0?e<-Zy+r&&(e=-Zy+r):e>Zy-r&&(e=Zy-r);const s=i/Math.pow(Wy(e),n);let o=s*Math.sin(n*t),a=i-s*Math.cos(n*t);return o=.5*(o/Math.PI+.5),a=.5*(a/Math.PI+.5),{x:o,y:this.southernCenter?a:1-a,z:0}}unproject(t,e){t=(2*t-.5)*Math.PI,this.southernCenter&&(e=1-e),e=(2*(1-e)-.5)*Math.PI;const{n:r,f:n}=this,i=n-e,s=Math.sign(i),o=Math.sign(r)*Math.sqrt(t*t+i*i);let a=Math.atan2(t,Math.abs(i))*s;i*r<0&&(a-=Math.PI*Math.sign(t)*s);const l=Et(It(a/r)+this.center[0],-180,180),u=Et(It(2*Math.atan(Math.pow(n/o,1/r))-Zy),-85.051129,nu);return new Hl(l,this.southernCenter?-u:u)}}class Ky extends Oy{constructor(t){super(t),this.wrap=!0,this.supportsWorldCopies=!0,this.supportsTerrain=!0,this.supportsFog=!0,this.supportsFreeCamera=!0,this.isReprojectedInTileSpace=!1,this.unsupportedLayers=[],this.range=null;}project(t,e){return {x:Kl(t),y:Jl(e),z:0}}unproject(t,e){const r=tu(t),n=eu(e);return new Hl(r,n)}}const Jy=Mt(nu);class Qy extends Oy{project(t,e){const r=(e=Mt(e))*e,n=r*r;return {x:.5*((t=Mt(t))*(.8707-.131979*r+n*(n*(.003971*r-.001529*n)-.013791))/Math.PI+.5),y:1-.5*(e*(1.007226+r*(.015085+n*(.028874*r-.044475-.005916*n)))/Math.PI+1),z:0}}unproject(t,e){t=(2*t-.5)*Math.PI;let r=e=(2*(1-e)-1)*Math.PI,n=25,i=0,s=r*r;do{s=r*r;const t=s*s;i=(r*(1.007226+s*(.015085+t*(.028874*s-.044475-.005916*t)))-e)/(1.007226+s*(.045255+t*(.259866*s-.311325-.005916*11*t))),r=Et(r-i,-Jy,Jy);}while(Math.abs(i)>1e-6&&--n>0);s=r*r;const o=Et(It(t/(.8707+s*(s*(s*s*s*(.003971-.001529*s)-.013791)-.131979))),-180,180),a=It(r);return new Hl(o,a)}}const tg=Mt(nu);class eg extends Oy{project(t,e){e=Mt(e),t=Mt(t);const r=Math.cos(e),n=2/Math.PI,i=Math.acos(r*Math.cos(t/2)),s=Math.sin(i)/i,o=.5*(t*n+2*r*Math.sin(t/2)/s)||0,a=.5*(e+Math.sin(e)/s)||0;return {x:.5*(o/Math.PI+.5),y:1-.5*(a/Math.PI+1),z:0}}unproject(t,e){let r=t=(2*t-.5)*Math.PI,n=e=(2*(1-e)-1)*Math.PI,i=25;const s=1e-6;let o=0,a=0;do{const i=Math.cos(n),s=Math.sin(n),l=2*s*i,u=s*s,c=i*i,h=Math.cos(r/2),p=Math.sin(r/2),f=2*h*p,d=p*p,m=1-c*h*h,y=m?1/m:0,g=m?Math.acos(i*h)*Math.sqrt(1/m):0,x=.5*(2*g*i*p+2*r/Math.PI)-t,v=.5*(g*s+n)-e,b=.5*y*(c*d+g*i*h*u)+1/Math.PI,w=y*(f*l/4-g*s*p),_=.125*y*(l*p-g*s*c*f),A=.5*y*(u*h+g*d*i)+.5,M=w*_-A*b;o=(v*w-x*A)/M,a=(x*_-v*b)/M,r=Et(r-o,-Math.PI,Math.PI),n=Et(n-a,-tg,tg);}while((Math.abs(o)>s||Math.abs(a)>s)&&--i>0);return new Hl(It(r),It(n))}}class rg extends Oy{constructor(t){super(t),this.center=t.center||[0,0],this.parallels=t.parallels||[0,0],this.cosPhi=Math.max(.01,Math.cos(Mt(this.parallels[0]))),this.scale=1/(2*Math.max(Math.PI*this.cosPhi,1/this.cosPhi)),this.wrap=!0,this.supportsWorldCopies=!0;}project(t,e){const{scale:r,cosPhi:n}=this;return {x:Mt(t)*n*r+.5,y:-Math.sin(Mt(e))/n*r+.5,z:0}}unproject(t,e){const{scale:r,cosPhi:n}=this,i=-(e-.5)/r,s=Et(It((t-.5)/r)/n,-180,180),o=Math.asin(Et(i*n,-1,1)),a=Et(It(o),-85.051129,nu);return new Hl(s,a)}}class ng extends Ky{constructor(t){super(t),this.requiresDraping=!0,this.supportsWorldCopies=!1,this.supportsFog=!0,this.zAxisUnit="pixels",this.unsupportedLayers=["debug"],this.range=[3,5];}projectTilePoint(t,e,r){const n=Uc(t,e,r);return R(n,n,$c(Cc(r))),{x:n[0],y:n[1],z:n[2]}}locationPoint(t,e,r){const n=$l(e.lat,e.lng),i=C([],n),s=r?t._centerAltitude+r:t.elevation?t.elevation.getAtPointOrZero(t.locationCoordinate(e),t._centerAltitude):t._centerAltitude;E(n,n,i,Ql(1,0)*Cn*s);const o=l(new Float64Array(16));return c(o,t.pixelMatrix,t.globeMatrix),R(n,n,o),new bt(n[0],n[1])}pixelsPerMeter(t,e){return Ql(1,0)*e}pixelSpaceConversion(t,e,r){const n=Ql(1,t)*e,i=ur(Ql(1,45)*e,n,r);return this.pixelsPerMeter(t,e)/i}createTileMatrix(t,e,r){const n=Gc(Cc(r.canonical));return c(new Float64Array(16),t.globeMatrix,n)}createInversionMatrix(t,e){const{center:r}=t,n=$c(Cc(e));return d(n,n,Mt(r.lng)),f(n,n,Mt(r.lat)),p(n,n,[t._pixelsPerMercatorPixel,t._pixelsPerMercatorPixel,1]),Float32Array.from(n)}pointCoordinate(t,e,r,n){return Tc(t,e,r,!0)||new lu(0,0)}pointCoordinate3D(t,e,r){const n=this.pointCoordinate(t,e,r,0);return [n.x,n.y,n.z]}isPointAboveHorizon(t,e){return !Tc(t,e.x,e.y,!1)}farthestPixelDistance(t){const e=function(t,e){const r=t.cameraToCenterDistance,n=t._centerAltitude*e,i=t._camera,s=t._camera.forward(),o=M([],P([],s,-r),[0,0,n]),a=t.worldSize/(2*Math.PI),l=[0,0,-a],u=t.width/t.height,c=Math.tan(t.fovAboveCenter),h=P([],i.up(),c),p=P([],i.right(),c*u),f=C([],M([],M([],s,h),p)),d=[];let m;if(new Ru(o,f).closestPointOnSphere(l,a,d)){const e=M([],d,l),r=j([],e,o);m=Math.cos(t.fovAboveCenter)*_(r);}else {const t=j([],o,l),e=j([],l,o);C(e,e);const r=_(t)-a;m=Math.sqrt(r*(r+2*a));const n=Math.acos(m/(a+r))-Math.acos(F(s,e));m*=Math.cos(n);}return 1.01*m}(t,this.pixelsPerMeter(t.center.lat,t.worldSize)),r=Zc(t.zoom);if(r>0){const n=Fy(t,Ql(1,t.center.lat)*t.worldSize),i=t.worldSize/(2*Math.PI),s=Math.max(t.width,t.height)/t.worldSize*Math.PI;return ur(e,n+i*(1-Math.cos(s)),Math.pow(r,10))}return e}upVector(t,e,r){return Uc(e,r,t,1)}upVectorScale(t){return {metersToTile:Pc(Nc(Cc(t)))}}}function ig(t){const e=t.parallels,r=!!e&&Math.abs(e[0]+e[1])<.01;switch(t.name){case "mercator":return new Ky(t);case "equirectangular":return new Xy(t);case "naturalEarth":return new Qy(t);case "equalEarth":return new Hy(t);case "winkelTripel":return new eg(t);case "albers":return r?new rg(t):new Uy(t);case "lambertConformalConic":return r?new rg(t):new Yy(t);case "globe":return new ng(t)}throw new Error(`Invalid projection name: ${t.name}`)}const sg=Pu.VectorTileFeature.types,og=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function ag(t,e,r,n,i,s,o,a,l,u,c,h,p){const f=a?Math.min(Py,Math.round(a[0])):0,d=a?Math.min(Py,Math.round(a[1])):0;t.emplaceBack(e,r,Math.round(32*n),Math.round(32*i),s,o,(f<<1)+(l?1:0),d,16*u,16*c,256*h,256*p);}function lg(t,e,r){t.emplaceBack(e,r);}function ug(t,e,r,n,i,s,o){t.emplaceBack(e,r,n,i,s,o);}const cg=(t,e,r,n)=>{for(let i=0;i<e;i++)t.emplaceBack(r[0],r[1],r[2],n[0],n[1],n[2]);};function hg(t,e,r,n,i){t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i);}function pg(t){for(const e of t.sections)if(so(e.text))return !0;return !1}class fg{constructor(t){this.layoutVertexArray=new da,this.indexArray=new Aa,this.programConfigurations=t,this.segments=new tl,this.dynamicLayoutVertexArray=new ya,this.opacityVertexArray=new ga,this.placedSymbolArray=new Na,this.iconTransitioningVertexArray=new xa,this.globeExtVertexArray=new ma,this.zOffsetVertexArray=new sa,this.orientationVertexArray=new Sa;}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length&&0===this.iconTransitioningVertexArray.length}upload(t,e,r,n,i){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,jd.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,Gd.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,og,!0),this.iconTransitioningVertexArray.length>0&&(this.iconTransitioningVertexBuffer=t.createVertexBuffer(this.iconTransitioningVertexArray,Xd.members,!0)),this.globeExtVertexArray.length>0&&(this.globeExtVertexBuffer=t.createVertexBuffer(this.globeExtVertexArray,$d.members,!0)),!this.zOffsetVertexBuffer&&(this.zOffsetVertexArray.length>0||i)&&(this.zOffsetVertexBuffer=t.createVertexBuffer(this.zOffsetVertexArray,qd.members,!0)),!this.orientationVertexBuffer&&this.orientationVertexArray&&this.orientationVertexArray.length>0&&(this.orientationVertexBuffer=t.createVertexBuffer(this.orientationVertexArray,Hd.members,!0)),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(t));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy(),this.iconTransitioningVertexBuffer&&this.iconTransitioningVertexBuffer.destroy(),this.globeExtVertexBuffer&&this.globeExtVertexBuffer.destroy(),this.zOffsetVertexBuffer&&this.zOffsetVertexBuffer.destroy(),this.orientationVertexBuffer&&this.orientationVertexBuffer.destroy());}}qs(fg,"SymbolBuffers");class dg{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new tl,this.collisionVertexArray=new _a,this.collisionVertexArrayExt=new ya;}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,Zd.members,!0),this.collisionVertexBufferExt=t.createVertexBuffer(this.collisionVertexArrayExt,Wd.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy(),this.collisionVertexBufferExt.destroy());}}qs(dg,"CollisionBuffers");class mg{constructor(t){this.collisionBoxArray=t.collisionBoxArray,this.zoom=t.zoom,this.lut=t.lut,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.pixelRatio=t.pixelRatio,this.sourceLayerIndex=t.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.fullyClipped=!1,this.hasAnyIconTextFit=!1,this.sortKeyRanges=[],this.collisionCircleArray=[],this.placementInvProjMatrix=l([]),this.placementViewportMatrix=l([]);const e=this.layers[0]._unevaluatedLayout._values;this.worldview=t.worldview,this.textSizeData=Fm(this.zoom,e["text-size"],this.worldview),this.iconSizeData=Fm(this.zoom,e["icon-size"],this.worldview);const r=this.layers[0].layout,n=r.get("symbol-sort-key"),i=r.get("symbol-z-order");this.canOverlap=r.get("text-allow-overlap")||r.get("icon-allow-overlap")||r.get("text-ignore-placement")||r.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==i&&void 0!==n.constantOr(1),this.sortFeaturesByY=("viewport-y"===i||"auto"===i&&!this.sortFeaturesByKey)&&this.canOverlap,this.writingModes=r.get("text-writing-mode").map((t=>mm[t])),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=t.sourceID,this.projection=t.projection,this.hasAnyZOffset=!1,this.zOffsetSortDirty=!1,this.zOffsetBuffersNeedUpload=!1,this.elevationType="none",this.elevationStateComplete=!1,this.activeReplacements=[],this.replacementUpdateTime=0;}createArrays(){this.text=new fg(new kl(this.layers,{zoom:this.zoom,lut:this.lut},(t=>t.startsWith("text")||t.startsWith("symbol")))),this.icon=new fg(new kl(this.layers,{zoom:this.zoom,lut:this.lut},(t=>t.startsWith("icon")||t.startsWith("symbol")))),this.glyphOffsetArray=new Ga,this.lineVertexArray=new qa,this.symbolInstances=new $a;}calculateGlyphDependencies(t,e,r,n,i){for(const r of t){const t=r.codePointAt(0);if(void 0===t)break;if(e[t]=!0,n&&i&&t<=65535){const t=tm[r];t&&(e[t.charCodeAt(0)]=!0);}}}updateFootprints(t,e){}updateReplacement(t,e){if(e.updateTime===this.replacementUpdateTime)return !1;this.replacementUpdateTime=e.updateTime;const r=e.getReplacementRegionsForTile(t.toUnwrapped(),!0);return !Vp(this.activeReplacements,r)&&(this.activeReplacements=r,!0)}populate(t,e,r,n){const i=this.layers[0],s=i.layout,o="globe"===this.projection.name,a=s.get("text-font"),l=s.get("text-field"),u=s.get("icon-image"),[c,h]=s.get("icon-size-scale-range"),p=Et(e.scaleFactor||1,c,h),f=("constant"!==l.value.kind||l.value.value instanceof Cr&&!l.value.value.isEmpty()||l.value.value.toString().length>0)&&("constant"!==a.value.kind||a.value.value.length>0),d="constant"!==u.value.kind||!!u.value.value||Object.keys(u.parameters).length>0,m=s.get("symbol-sort-key");if(this.features=[],!f&&!d)return;const y=e.iconDependencies,g=e.glyphDependencies,x=e.availableImages,v=new go(this.zoom,{worldview:this.worldview});for(const{feature:e,id:l,index:u,sourceLayerIndex:c}of t){const t=i._featureFilter.needGeometry,h=gu(e,t);if(!i._featureFilter.filter(v,h,r))continue;if(t||(h.geometry=yu(e,r,n)),o&&1!==e.type&&r.z<=5){const t=h.geometry,e=.98078528056,n=(t,n)=>F(Uc(t.x,t.y,r,1),Uc(n.x,n.y,r,1))<e;for(let e=0;e<t.length;e++)t[e]=pu(t[e],n);}let b,w;if(f){const t=i.getValueAndResolveTokens("text-field",h,r,x),e=Cr.factory(t);pg(e)&&(this.hasRTLText=!0),(!this.hasRTLText||"unavailable"===fo()||this.hasRTLText&&yo.isParsed())&&(b=Qd(e,i,h));}if(d){const t=i.getValueAndResolveTokens("icon-image",h,r,x);w="string"==typeof t?Dr.build(t):t;}if(!b&&!w)continue;const _=this.sortFeaturesByKey?m.evaluate(h,{},r):void 0,A={id:l,text:b,icon:w,index:u,sourceLayerIndex:c,geometry:h.geometry,properties:e.properties,type:sg[e.type],sortKey:_};if(this.features.push(A),w){const t=this.layers[0]._unevaluatedLayout._values,{iconPrimary:e,iconSecondary:n}=by(w,this.iconSizeData,t["icon-size"],r,this.zoom,A,this.pixelRatio,p,this.worldview),i=e.id.toString();if(y.has(i)?y.get(i).push(e):y.set(i,[e]),n){const t=n.id.toString();y.has(t)?y.get(t).push(n):y.set(t,[n]);}}if(b){const t=a.evaluate(h,{},r).join(","),e="map"===s.get("text-rotation-alignment")&&"point"!==s.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(mm.vertical)>=0;for(const r of b.sections)if(r.image){const t=r.image.getPrimary().scaleSelf(this.pixelRatio),e=t.id.toString(),n=y.get(e)||[];n.push(t),y.set(e,n);}else {const n=Ks(b.toString()),i=r.fontStack||t,s=g[i]=g[i]||{};this.calculateGlyphDependencies(r.text,s,e,this.allowVerticalPlacement,n);}}}if("line"===s.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let i=0;function s(e){n.push(t[e]),i++;}function o(t,e,i){const s=r[t];return delete r[t],r[e]=s,n[s].geometry[0].pop(),n[s].geometry[0]=n[s].geometry[0].concat(i[0]),s}function a(t,r,i){const s=e[r];return delete e[r],e[t]=s,n[s].geometry[0].shift(),n[s].geometry[0]=i[0].concat(n[s].geometry[0]),s}function l(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return `${t}:${n.x}:${n.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue}const f=l(p,h),d=l(p,h,!0);if(f in r&&d in e&&r[f]!==e[d]){const t=a(f,d,h),i=o(f,d,n[t].geometry);delete e[f],delete r[d],r[l(p,n[i].geometry,!0)]=i,n[t].geometry=null;}else f in r?o(f,d,h):d in e?a(f,d,h):(s(u),e[f]=i-1,r[d]=i-1);}return n.filter((t=>t.geometry))}(this.features)),"hd-road-markup"===s.get("symbol-elevation-reference")){if(this.elevationType="road",e.elevationFeatures){!this.elevationFeatures&&e.elevationFeatures.length>0&&(this.elevationFeatures=[],this.elevationFeatureIdToIndex=new Map);for(const t of e.elevationFeatures)this.elevationFeatureIdToIndex.set(t.id,this.elevationFeatures.length),this.elevationFeatures.push(t);}}else s.get("symbol-z-elevate")&&(this.elevationType="offset");"none"!==this.elevationType&&(this.zOffsetBuffersNeedUpload=!0),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey));}update(t,e,r,n,i,s,o){this.text.programConfigurations.updatePaintArrays(t,e,i,r,n,s,o,this.worldview),this.icon.programConfigurations.updatePaintArrays(t,e,i,r,n,s,o,this.worldview);}updateRoadElevation(t){if("road"!==this.elevationType||!this.elevationFeatures)return;if(this.elevationStateComplete)return;this.elevationStateComplete=!0,this.hasAnyZOffset=!1;let e=!1;const r=au(t),n=1/r;let i=!1,s=!1;for(let t=0;t<this.symbolInstances.length;t++){const o=this.symbolInstances.get(t),a=A(1,0,0),l=A(0,1,0),{numHorizontalGlyphVertices:u,numVerticalGlyphVertices:c,numIconVertices:h,numVerticalIconVertices:p}=o,f=u>0||c>0,d=h>0,m=this.elevationFeatures[o.elevationFeatureIndex];if(m){const t=new bt(o.tileAnchorX,o.tileAnchorY),u=.075+m.pointElevation(t);o.zOffset!==u&&(e=!0,o.zOffset=u);const c=m.computeSlopeNormal(t,n),h=st(W(),A(0,0,1),c);U(a,a,h),U(l,l,h),a[2]*=r,l[2]*=r,1===a[0]&&0===a[1]&&0===a[2]&&0===l[0]&&1===l[1]&&0===l[2]||(i=i||f,s=s||d);}if(f&&(cg(this.text.orientationVertexArray,u,a,l),cg(this.text.orientationVertexArray,c,a,l)),d){const{placedIconSymbolIndex:t,verticalPlacedIconSymbolIndex:e}=o;t>=0&&cg(this.icon.orientationVertexArray,h,a,l),e>=0&&cg(this.icon.orientationVertexArray,p,a,l);}}i||(this.text.orientationVertexArray=void 0),s||(this.icon.orientationVertexArray=void 0),e&&(this.zOffsetBuffersNeedUpload=!0,this.zOffsetSortDirty=!0);}updateZOffset(){const t=(t,e,n)=>{r+=e,r>t.length&&t.resize(r);for(let i=-e;i<0;i++)t.emplace(i+r,n);},e=(t,e,r)=>{n+=e,n>t.length&&t.resize(n);for(let i=-e;i<0;i++)t.emplace(i+n,r);};if(!this.zOffsetBuffersNeedUpload)return;this.zOffsetBuffersNeedUpload=!1;let r=0,n=0;for(let r=0;r<this.symbolInstances.length;r++){const n=this.symbolInstances.get(r),{numHorizontalGlyphVertices:i,numVerticalGlyphVertices:s,numIconVertices:o}=n,a=n.zOffset,l=o>0;if((i>0||s>0)&&(t(this.text.zOffsetVertexArray,i,a),t(this.text.zOffsetVertexArray,s,a)),l){const{placedIconSymbolIndex:t,verticalPlacedIconSymbolIndex:r}=n;t>=0&&e(this.icon.zOffsetVertexArray,o,a),r>=0&&e(this.icon.zOffsetVertexArray,n.numVerticalIconVertices,a);}}this.text.zOffsetVertexBuffer&&this.text.zOffsetVertexBuffer.updateData(this.text.zOffsetVertexArray),this.icon.zOffsetVertexBuffer&&this.icon.zOffsetVertexBuffer.updateData(this.icon.zOffsetVertexArray);}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return !this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload,this.zOffsetBuffersNeedUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload,this.zOffsetBuffersNeedUpload),this.uploaded=!0;}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy();}getProjection(){return this.projectionInstance||(this.projectionInstance=ig(this.projection)),this.projectionInstance}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData();}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment)for(const{x:t,y:r}of e)this.lineVertexArray.emplaceBack(t,r);return {lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,m){const y=t.indexArray,g=t.layoutVertexArray,x=t.globeExtVertexArray,v=t.segments.prepareSegment(4*e.length,g,y,this.canOverlap?s.sortKey:void 0),b=this.glyphOffsetArray.length,w=v.vertexLength,_=this.allowVerticalPlacement&&o===mm.vertical?Math.PI/2:0,A=s.text&&s.text.sections;for(let n=0;n<e.length;n++){const{tl:i,tr:o,bl:u,br:c,texPrimary:h,texSecondary:b,pixelOffsetTL:w,pixelOffsetBR:M,minFontScaleX:I,minFontScaleY:S,glyphOffset:z,isSDF:k,sectionIndex:P}=e[n],E=v.vertexLength,T=z[1];if(ag(g,l.x,l.y,i.x,T+i.y,h.x,h.y,r,k,w.x,w.y,I,S),ag(g,l.x,l.y,o.x,T+o.y,h.x+h.w,h.y,r,k,M.x,w.y,I,S),ag(g,l.x,l.y,u.x,T+u.y,h.x,h.y+h.h,r,k,w.x,M.y,I,S),ag(g,l.x,l.y,c.x,T+c.y,h.x+h.w,h.y+h.h,r,k,M.x,M.y,I,S),a){const{x:e,y:r,z:n}=a.anchor,[i,s,o]=a.up;ug(x,e,r,n,i,s,o),ug(x,e,r,n,i,s,o),ug(x,e,r,n,i,s,o),ug(x,e,r,n,i,s,o),hg(t.dynamicLayoutVertexArray,e,r,n,_);}else hg(t.dynamicLayoutVertexArray,l.x,l.y,l.z,_);if(m){const e=b||h;lg(t.iconTransitioningVertexArray,e.x,e.y),lg(t.iconTransitioningVertexArray,e.x+e.w,e.y),lg(t.iconTransitioningVertexArray,e.x,e.y+e.h),lg(t.iconTransitioningVertexArray,e.x+e.w,e.y+e.h);}y.emplaceBack(E,E+1,E+2),y.emplaceBack(E+1,E+2,E+3),v.vertexLength+=4,v.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(z[0]),n!==e.length-1&&P===e[n+1].sectionIndex||t.programConfigurations.populatePaintArrays(g.length,s,s.index,{},p,f,d,A&&A[P],this.worldview);}const M=a?a.anchor:l;t.placedSymbolArray.emplaceBack(M.x,M.y,M.z,l.x,l.y,b,this.glyphOffsetArray.length-b,w,u,c,l.segment,r?r[0]:0,r?r[1]:0,n[0],n[1],o,0,0,0,h,0);}_commitLayoutVertex(t,e,r,n,i,s,o){t.emplaceBack(e,r,n,i,s,Math.round(o.x),Math.round(o.y));}_addCollisionDebugVertices(t,e,r,n,i,s,o){const a=r.segments.prepareSegment(4,r.layoutVertexArray,r.indexArray),l=a.vertexLength,u=o.tileAnchorX,c=o.tileAnchorY;for(let t=0;t<4;t++)r.collisionVertexArray.emplaceBack(0,0,0,0,0,0);this._commitDebugCollisionVertexUpdate(r.collisionVertexArrayExt,e,t.padding,o.zOffset),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new bt(t.x1,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new bt(t.x2,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new bt(t.x2,t.y2)),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new bt(t.x1,t.y2)),a.vertexLength+=4;const h=r.indexArray;h.emplaceBack(l,l+1),h.emplaceBack(l+1,l+2),h.emplaceBack(l+2,l+3),h.emplaceBack(l+3,l),a.primitiveLength+=4;}_addTextDebugCollisionBoxes(t,e,r,n,i,s){for(let o=n;o<i;o++){const n=r.get(o),i=this.getSymbolInstanceTextSize(t,s,e,o);this._addCollisionDebugVertices(n,i,this.textCollisionBox,n.projectedAnchorX,n.projectedAnchorY,n.projectedAnchorZ,s);}}_addIconDebugCollisionBoxes(t,e,r,n,i,s){for(let o=n;o<i;o++){const n=r.get(o),i=this.getSymbolInstanceIconSize(t,e,s.placedIconSymbolIndex);this._addCollisionDebugVertices(n,i,this.iconCollisionBox,n.projectedAnchorX,n.projectedAnchorY,n.projectedAnchorZ,s);}}generateCollisionDebugBuffers(t,e,r){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new dg(ba,Yd.members,xa),this.iconCollisionBox=new dg(ba,Yd.members,xa);const n=Lm(this.iconSizeData,t),i=Lm(this.textSizeData,t,r);for(let r=0;r<this.symbolInstances.length;r++){const s=this.symbolInstances.get(r);this._addTextDebugCollisionBoxes(i,t,e,s.textBoxStartIndex,s.textBoxEndIndex,s),this._addTextDebugCollisionBoxes(i,t,e,s.verticalTextBoxStartIndex,s.verticalTextBoxEndIndex,s),this._addIconDebugCollisionBoxes(n,t,e,s.iconBoxStartIndex,s.iconBoxEndIndex,s),this._addIconDebugCollisionBoxes(n,t,e,s.verticalIconBoxStartIndex,s.verticalIconBoxEndIndex,s);}}getSymbolInstanceTextSize(t,e,r,n){const i=this.text.placedSymbolArray.get(e.rightJustifiedTextSymbolIndex>=0?e.rightJustifiedTextSymbolIndex:e.centerJustifiedTextSymbolIndex>=0?e.centerJustifiedTextSymbolIndex:e.leftJustifiedTextSymbolIndex>=0?e.leftJustifiedTextSymbolIndex:e.verticalPlacedTextSymbolIndex>=0?e.verticalPlacedTextSymbolIndex:n),s=Dm(this.textSizeData,t,i)/Jd;return this.tilePixelRatio*s}getSymbolInstanceIconSize(t,e,r){const n=this.icon.placedSymbolArray.get(r),i=Dm(this.iconSizeData,t,n);return this.tilePixelRatio*i}_commitDebugCollisionVertexUpdate(t,e,r,n){t.emplaceBack(e,-r,-r,n),t.emplaceBack(e,r,-r,n),t.emplaceBack(e,r,r,n),t.emplaceBack(e,-r,r,n);}_updateTextDebugCollisionBoxes(t,e,r,n,i,s,o){for(let o=n;o<i;o++){const n=r.get(o),i=this.getSymbolInstanceTextSize(t,s,e,o);this._commitDebugCollisionVertexUpdate(this.textCollisionBox.collisionVertexArrayExt,i,n.padding,s.zOffset);}}_updateIconDebugCollisionBoxes(t,e,r,n,i,s,o){for(let o=n;o<i;o++){const n=r.get(o),i=this.getSymbolInstanceIconSize(t,e,s.placedIconSymbolIndex);this._commitDebugCollisionVertexUpdate(this.iconCollisionBox.collisionVertexArrayExt,i,n.padding,s.zOffset);}}updateCollisionDebugBuffers(t,e,r,n){if(!this.hasDebugData())return;this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexArrayExt.clear(),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexArrayExt.clear();const i=Lm(this.iconSizeData,t,n),s=Lm(this.textSizeData,t,r);for(let o=0;o<this.symbolInstances.length;o++){const a=this.symbolInstances.get(o);this._updateTextDebugCollisionBoxes(s,t,e,a.textBoxStartIndex,a.textBoxEndIndex,a,r),this._updateTextDebugCollisionBoxes(s,t,e,a.verticalTextBoxStartIndex,a.verticalTextBoxEndIndex,a,r),this._updateIconDebugCollisionBoxes(i,t,e,a.iconBoxStartIndex,a.iconBoxEndIndex,a,n),this._updateIconDebugCollisionBoxes(i,t,e,a.verticalIconBoxStartIndex,a.verticalIconBoxEndIndex,a,n);}this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexBufferExt&&this.textCollisionBox.collisionVertexBufferExt.updateData(this.textCollisionBox.collisionVertexArrayExt),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexBufferExt&&this.iconCollisionBox.collisionVertexBufferExt.updateData(this.iconCollisionBox.collisionVertexArrayExt);}_deserializeCollisionBoxesForSymbol(t,e,r,n,i,s,o,a,l){const u={};if(e<r){const{x1:r,y1:n,x2:i,y2:s,padding:o,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(e);u.textBox={x1:r,y1:n,x2:i,y2:s,padding:o,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.textFeatureIndex=f;}if(n<i){const{x1:e,y1:r,x2:i,y2:s,padding:o,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(n);u.verticalTextBox={x1:e,y1:r,x2:i,y2:s,padding:o,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.verticalTextFeatureIndex=f;}if(s<o){const{x1:e,y1:r,x2:n,y2:i,padding:o,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(s);u.iconBox={x1:e,y1:r,x2:n,y2:i,padding:o,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.iconFeatureIndex=f;}if(a<l){const{x1:e,y1:r,x2:n,y2:i,padding:s,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(a);u.verticalIconBox={x1:e,y1:r,x2:n,y2:i,padding:s,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.verticalIconFeatureIndex=f;}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}hasIconTextFit(){return this.hasAnyIconTextFit}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+1,e+2),t.indexArray.emplaceBack(e+1,e+2,e+3);}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],i=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const o=this.symbolInstances.get(t);n.push(0|Math.round(e*o.tileAnchorX+r*o.tileAnchorY)),i.push(o.featureIndex);}return s.sort(((t,e)=>n[t]-n[e]||i[e]-i[t])),s}getSortedIndexesByZOffset(){if(!this.zOffsetSortDirty)return this.symbolInstanceIndexesSortedZOffset;if(!this.symbolInstanceIndexesSortedZOffset){this.symbolInstanceIndexesSortedZOffset=[];for(let t=0;t<this.symbolInstances.length;++t)this.symbolInstanceIndexesSortedZOffset.push(t);}return this.zOffsetSortDirty=!1,this.symbolInstanceIndexesSortedZOffset.sort(((t,e)=>this.symbolInstances.get(e).zOffset-this.symbolInstances.get(t).zOffset))}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1});}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex);const{rightJustifiedTextSymbolIndex:r,centerJustifiedTextSymbolIndex:n,leftJustifiedTextSymbolIndex:i,verticalPlacedTextSymbolIndex:s,placedIconSymbolIndex:o,verticalPlacedIconSymbolIndex:a}=e;r>=0&&this.addIndicesForPlacedSymbol(this.text,r),n>=0&&n!==r&&this.addIndicesForPlacedSymbol(this.text,n),i>=0&&i!==n&&i!==r&&this.addIndicesForPlacedSymbol(this.text,i),s>=0&&this.addIndicesForPlacedSymbol(this.text,s),o>=0&&this.addIndicesForPlacedSymbol(this.icon,o),a>=0&&this.addIndicesForPlacedSymbol(this.icon,a);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}}let yg,gg,xg;qs(mg,"SymbolBucket",{omit:["layers","collisionBoxArray","features","compareText"]}),mg.addDynamicAttributes=hg;class vg{constructor(t){this.type=t.property.overrides?t.property.overrides.runtimeType:mr,this.defaultValue=t;}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression);}outputDefined(){return !1}serialize(){return null}}qs(vg,"FormatSectionOverride",{omit:["defaultValue"]});const bg=()=>xg||(xg={layout:yg||(yg=new Po({"symbol-placement":new So(Eo.layout_symbol["symbol-placement"]),"symbol-spacing":new So(Eo.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new So(Eo.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new zo(Eo.layout_symbol["symbol-sort-key"]),"symbol-z-order":new So(Eo.layout_symbol["symbol-z-order"]),"symbol-z-elevate":new So(Eo.layout_symbol["symbol-z-elevate"]),"symbol-elevation-reference":new So(Eo.layout_symbol["symbol-elevation-reference"]),"icon-allow-overlap":new So(Eo.layout_symbol["icon-allow-overlap"]),"icon-ignore-placement":new So(Eo.layout_symbol["icon-ignore-placement"]),"icon-optional":new So(Eo.layout_symbol["icon-optional"]),"icon-rotation-alignment":new So(Eo.layout_symbol["icon-rotation-alignment"]),"icon-size":new zo(Eo.layout_symbol["icon-size"]),"icon-size-scale-range":new So(Eo.layout_symbol["icon-size-scale-range"]),"icon-text-fit":new zo(Eo.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new zo(Eo.layout_symbol["icon-text-fit-padding"]),"icon-image":new zo(Eo.layout_symbol["icon-image"]),"icon-rotate":new zo(Eo.layout_symbol["icon-rotate"]),"icon-padding":new So(Eo.layout_symbol["icon-padding"]),"icon-keep-upright":new So(Eo.layout_symbol["icon-keep-upright"]),"icon-offset":new zo(Eo.layout_symbol["icon-offset"]),"icon-anchor":new zo(Eo.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new So(Eo.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new So(Eo.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new So(Eo.layout_symbol["text-rotation-alignment"]),"text-field":new zo(Eo.layout_symbol["text-field"]),"text-font":new zo(Eo.layout_symbol["text-font"]),"text-size":new zo(Eo.layout_symbol["text-size"]),"text-size-scale-range":new So(Eo.layout_symbol["text-size-scale-range"]),"text-max-width":new zo(Eo.layout_symbol["text-max-width"]),"text-line-height":new zo(Eo.layout_symbol["text-line-height"]),"text-letter-spacing":new zo(Eo.layout_symbol["text-letter-spacing"]),"text-justify":new zo(Eo.layout_symbol["text-justify"]),"text-radial-offset":new zo(Eo.layout_symbol["text-radial-offset"]),"text-variable-anchor":new So(Eo.layout_symbol["text-variable-anchor"]),"text-anchor":new zo(Eo.layout_symbol["text-anchor"]),"text-max-angle":new So(Eo.layout_symbol["text-max-angle"]),"text-writing-mode":new So(Eo.layout_symbol["text-writing-mode"]),"text-rotate":new zo(Eo.layout_symbol["text-rotate"]),"text-padding":new So(Eo.layout_symbol["text-padding"]),"text-keep-upright":new So(Eo.layout_symbol["text-keep-upright"]),"text-transform":new zo(Eo.layout_symbol["text-transform"]),"text-offset":new zo(Eo.layout_symbol["text-offset"]),"text-allow-overlap":new So(Eo.layout_symbol["text-allow-overlap"]),"text-ignore-placement":new So(Eo.layout_symbol["text-ignore-placement"]),"text-optional":new So(Eo.layout_symbol["text-optional"]),visibility:new So(Eo.layout_symbol.visibility)})),paint:gg||(gg=new Po({"icon-opacity":new zo(Eo.paint_symbol["icon-opacity"]),"icon-occlusion-opacity":new zo(Eo.paint_symbol["icon-occlusion-opacity"]),"icon-emissive-strength":new zo(Eo.paint_symbol["icon-emissive-strength"]),"text-emissive-strength":new zo(Eo.paint_symbol["text-emissive-strength"]),"icon-color":new zo(Eo.paint_symbol["icon-color"]),"icon-halo-color":new zo(Eo.paint_symbol["icon-halo-color"]),"icon-halo-width":new zo(Eo.paint_symbol["icon-halo-width"]),"icon-halo-blur":new zo(Eo.paint_symbol["icon-halo-blur"]),"icon-translate":new So(Eo.paint_symbol["icon-translate"]),"icon-translate-anchor":new So(Eo.paint_symbol["icon-translate-anchor"]),"icon-image-cross-fade":new So(Eo.paint_symbol["icon-image-cross-fade"]),"text-opacity":new zo(Eo.paint_symbol["text-opacity"]),"text-occlusion-opacity":new zo(Eo.paint_symbol["text-occlusion-opacity"]),"text-color":new zo(Eo.paint_symbol["text-color"],{runtimeType:vr,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new zo(Eo.paint_symbol["text-halo-color"]),"text-halo-width":new zo(Eo.paint_symbol["text-halo-width"]),"text-halo-blur":new zo(Eo.paint_symbol["text-halo-blur"]),"text-translate":new So(Eo.paint_symbol["text-translate"]),"text-translate-anchor":new So(Eo.paint_symbol["text-translate-anchor"]),"icon-color-saturation":new So(Eo.paint_symbol["icon-color-saturation"]),"icon-color-contrast":new So(Eo.paint_symbol["icon-color-contrast"]),"icon-color-brightness-min":new So(Eo.paint_symbol["icon-color-brightness-min"]),"icon-color-brightness-max":new So(Eo.paint_symbol["icon-color-brightness-max"]),"symbol-z-offset":new zo(Eo.paint_symbol["symbol-z-offset"]),"icon-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"}),"icon-halo-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"}),"text-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"}),"text-halo-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"})}))},xg);class wg extends Yo{constructor(t,e,r,n){super(t,bg(),e,r,n),this._colorAdjustmentMatrix=l([]),this.hasInitialOcclusionOpacityProperties=void 0!==t.paint&&("icon-occlusion-opacity"in t.paint||"text-occlusion-opacity"in t.paint);}recalculate(t,e){super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]=this.layout.get("text-rotation-alignment")),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment"));const r=this.layout.get("text-writing-mode");if(r){const t=[];for(const e of r)t.indexOf(e)<0&&t.push(e);this.layout._values["text-writing-mode"]=t;}else this.layout._values["text-writing-mode"]="point"===this.layout.get("symbol-placement")?["horizontal"]:["horizontal","vertical"];this._setPaintOverrides();}getColorAdjustmentMatrix(t,e,r,n){return this._saturation===t&&this._contrast===e&&this._brightnessMin===r&&this._brightnessMax===n||(this._colorAdjustmentMatrix=function(t,e,r,n){t=ee(t),e=te(e);const i=a(),s=t/3,o=1-2*s,l=[o,s,s,0,s,o,s,0,s,s,o,0,0,0,0,1],u=.5-.5*e,h=n-r;return c(i,[h,0,0,0,0,h,0,0,0,0,h,0,r,r,r,1],[e,0,0,0,0,e,0,0,0,0,e,0,u,u,u,1]),c(i,i,l),i}(t,e,r,n),this._saturation=t,this._contrast=e,this._brightnessMin=r,this._brightnessMax=n),this._colorAdjustmentMatrix}getValueAndResolveTokens(t,e,r,n){const i=this.layout.get(t).evaluate(e,{},r,n),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||Vs(s.value)||!i?i:function(t,e){return e.replace(/{([^{}]+)}/g,((e,r)=>r in t?String(t[r]):""))}(e.properties,i)}createBucket(t){return new mg(t)}queryRadius(){return 0}queryIntersectsFeature(){return !1}_setPaintOverrides(){for(const t of bg().paint.overridableProperties){if(!wg.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new vg(e),n=new Bs(r,e.property.specification,this.scope,this.options);let i=null;i="constant"===e.value.kind||"source"===e.value.kind?new Fs("source",n):new Ds("composite",n,e.value.zoomStops,e.value.interpolationType),this.paint._values[t]=new Mo(e.property,i,e.parameters);}}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven())&&wg.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),n=bg().paint.properties[e];let i=!1;const s=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof Cr)s(r.value.value.sections);else if("source"===r.value.kind){const t=e=>{i||(e instanceof Nr&&Or(e.value)===Ar?s(e.value.sections):e instanceof qr?s(e.sections):e.eachChild(t));},e=r.value;e._styleExpression&&t(e._styleExpression.expression);}return i}getProgramIds(){return ["symbol"]}getDefaultProgramParams(t,e,r){return {config:new zl(this,{zoom:e,lut:r}),overrideFog:!1}}hasElevation(){return this.layout&&"hd-road-markup"===this.layout.get("symbol-elevation-reference")}}let _g,Ag,Mg,Ig;var Sg=ta([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);function zg(t){switch(t){case WebGL2RenderingContext.RGBA8:return WebGL2RenderingContext.RGBA;case WebGL2RenderingContext.DEPTH_COMPONENT16:return WebGL2RenderingContext.DEPTH_COMPONENT;case WebGL2RenderingContext.DEPTH24_STENCIL8:return WebGL2RenderingContext.DEPTH_STENCIL;case WebGL2RenderingContext.R8:case WebGL2RenderingContext.R32F:return WebGL2RenderingContext.RED}}function kg(t){switch(t){case WebGL2RenderingContext.RGBA8:return WebGL2RenderingContext.UNSIGNED_BYTE;case WebGL2RenderingContext.DEPTH_COMPONENT16:return WebGL2RenderingContext.UNSIGNED_SHORT;case WebGL2RenderingContext.DEPTH24_STENCIL8:return WebGL2RenderingContext.UNSIGNED_INT_24_8;case WebGL2RenderingContext.R8:return WebGL2RenderingContext.UNSIGNED_BYTE;case WebGL2RenderingContext.R32F:return WebGL2RenderingContext.FLOAT}}class Pg{constructor(t,e,r,n){this.context=t,this.format=r,this.useMipmap=n&&n.useMipmap,this.texture=t.gl.createTexture(),this.update(e,{premultiply:n&&n.premultiply});}update(t,e){const r=t&&t instanceof HTMLVideoElement&&0===t.width?t.videoWidth:t.width,n=t&&t instanceof HTMLVideoElement&&0===t.height?t.videoHeight:t.height,{context:i}=this,{gl:s}=i,{x:o,y:a}=e&&e.position?e.position:{x:0,y:0},l=o+r,u=a+n;!this.size||this.size[0]===l&&this.size[1]===u||(s.bindTexture(s.TEXTURE_2D,null),s.deleteTexture(this.texture),this.texture=s.createTexture(),this.size=null),s.bindTexture(s.TEXTURE_2D,this.texture),i.pixelStoreUnpackFlipY.set(!1),i.pixelStoreUnpack.set(1),i.pixelStoreUnpackPremultiplyAlpha.set(this.format===s.RGBA8&&(!e||!1!==e.premultiply));const c=t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||ImageBitmap&&t instanceof ImageBitmap;if(!this.size&&l>0&&u>0){const t=this.useMipmap?Math.floor(Math.log2(Math.max(l,u)))+1:1;s.texStorage2D(s.TEXTURE_2D,t,this.format,l,u),this.size=[l,u];}if(this.size)if(c)s.texSubImage2D(s.TEXTURE_2D,0,o,a,zg(this.format),kg(this.format),t);else {const e=t.data;e&&s.texSubImage2D(s.TEXTURE_2D,0,o,a,r,n,zg(this.format),kg(this.format),e);}this.useMipmap&&s.generateMipmap(s.TEXTURE_2D);}bind(t,e,r=!1){const{context:n}=this,{gl:i}=n;i.bindTexture(i.TEXTURE_2D,this.texture),t!==this.minFilter&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,t),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,this.useMipmap&&!r?t===i.NEAREST?i.NEAREST_MIPMAP_NEAREST:i.LINEAR_MIPMAP_LINEAR:t),this.minFilter=t),e!==this.wrapS&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,e),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,e),this.wrapS=e);}bindExtraParam(t,e,r,n,i){const{context:s}=this,{gl:o}=s;o.bindTexture(o.TEXTURE_2D,this.texture),e!==this.magFilter&&(o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MAG_FILTER,e),this.magFilter=e),t!==this.minFilter&&(o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MIN_FILTER,this.useMipmap?t===o.NEAREST?o.NEAREST_MIPMAP_NEAREST:o.LINEAR_MIPMAP_LINEAR:t),this.minFilter=t),r!==this.wrapS&&(o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_S,r),this.wrapS=r),n!==this.wrapT&&(o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_T,n),this.wrapT=n),i!==this.compareMode&&(i?(o.texParameteri(o.TEXTURE_2D,o.TEXTURE_COMPARE_MODE,o.COMPARE_REF_TO_TEXTURE),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_COMPARE_FUNC,i)):o.texParameteri(o.TEXTURE_2D,o.TEXTURE_COMPARE_MODE,o.NONE),this.compareMode=i);}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}}class Eg{constructor(t,e){this.context=t,this.texture=e;}bind(t,e){const{context:r}=this,{gl:n}=r;n.bindTexture(n.TEXTURE_2D,this.texture),t!==this.minFilter&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,t),this.minFilter=t),e!==this.wrapS&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,e),this.wrapS=e);}}function Tg(t,e,r,n,i,a,l,u){const c=[t,e,1,r,n,1,i,a,1],h=[l,u,1],p=s([],c),[f,d,m]=O(h,h,p);return o(c,c,[f,0,0,0,d,0,0,0,m])}function Bg(t,e,r,n,i,a,l,u){const c=function(t,e,r,n,i,a,l,u){const c=Tg(0,0,1,0,1,1,0,1),h=Tg(t,e,r,n,i,a,l,u);return o(h,h,s([],c))}(t,e,r,n,i,a,l,u);return [c[2]/c[8]/Cn,c[5]/c[8]/Cn]}function Vg(t){return [t[0],Math.min(Math.max(t[1],-85.051129),nu)]}class Cg extends tr{constructor(t,e,r,n){super(),this.id=t,this.dispatcher=r,this.coordinates=e.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.onNorthPole=!1,this.onSouthPole=!1,this.setEventedParent(n),this.options=e,this._dirty=!1;}load(t,e){if(this._loaded=e||!1,this.fire(new Ye("dataloading",{dataType:"source"})),this.url=this.options.url,!this.url)return t&&(this.coordinates=t),this._loaded=!0,void this._finishLoading();this._imageRequest=Ne(this.map._requestManager.transformRequest(this.url,Be.Image),((e,r)=>{this._imageRequest=null,this._loaded=!0,e?this.fire(new Ke(e)):r&&(this.image=r instanceof HTMLImageElement?fe.getImageData(r):r,this._dirty=!0,this.width=this.image.width,this.height=this.image.height,t&&(this.coordinates=t),this._finishLoading());}));}loaded(){return this._loaded}updateImage(t){return t.url?(this._imageRequest&&t.url!==this.options.url&&(this._imageRequest.cancel(),this._imageRequest=null),this.options.url=t.url,this.load(t.coordinates,this._loaded),this):this}setTexture(t){if(!(t.handle instanceof WebGLTexture))throw new Error("The provided handle is not a WebGLTexture instance");return this.texture=new Eg(this.map.painter.context,t.handle),this.width=t.dimensions[0],this.height=t.dimensions[1],this._dirty=!1,this._loaded=!0,this._finishLoading(),this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new Ye("data",{dataType:"source",sourceDataType:"metadata"})));}onAdd(t){this.map=t,this.load();}onRemove(t){this._imageRequest&&(this._imageRequest.cancel(),this._imageRequest=null),!this.texture||this.texture instanceof Eg||this.texture.destroy(),this.boundsBuffer&&(this.boundsBuffer.destroy(),this.elevatedGlobeVertexBuffer&&this.elevatedGlobeVertexBuffer.destroy(),this.elevatedGlobeIndexBuffer&&this.elevatedGlobeIndexBuffer.destroy());}setCoordinates(t){if(this.coordinates=t,this._boundsArray=void 0,this._unsupportedCoords=!1,!t.length)return this;this.onNorthPole=!1,this.onSouthPole=!1;let e=t[0][1],r=t[0][1];for(const n of t)n[1]>r&&(r=n[1]),n[1]<e&&(e=n[1]);const n=(r+e)/2;if(n>nu?this.onNorthPole=!0:n<-85.051129&&(this.onSouthPole=!0),!this.onNorthPole&&!this.onSouthPole){const e=t.map(lu.fromLngLat);this.tileID=function(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const s of t)e=Math.min(e,s.x),r=Math.min(r,s.y),n=Math.max(n,s.x),i=Math.max(i,s.y);const s=Math.max(n-e,i-r),o=Math.max(0,Math.floor(-Math.log(s)/Math.LN2)),a=Math.pow(2,o);let l=Math.floor((e+n)/2*a);return l>1&&(l-=1),new bc(o,l,Math.floor((r+i)/2*a))}(e),this.minzoom=this.maxzoom=this.tileID.z;}return this.fire(new Ye("data",{dataType:"source",sourceDataType:"content"})),this}_clear(){this._boundsArray=void 0,this._unsupportedCoords=!1;}_prepareData(t){for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture);}if(this._boundsArray||this.onNorthPole||this.onSouthPole||this._unsupportedCoords)return;const e=Dy(new bc(0,0,0),this.map.transform.projection),r=[e.projection.project(this.coordinates[0][0],this.coordinates[0][1]),e.projection.project(this.coordinates[1][0],this.coordinates[1][1]),e.projection.project(this.coordinates[2][0],this.coordinates[2][1]),e.projection.project(this.coordinates[3][0],this.coordinates[3][1])];if(!function(t){const e=t[1].x-t[0].x,r=t[1].y-t[0].y,n=t[2].x-t[1].x,i=t[2].y-t[1].y,s=t[3].x-t[2].x,o=t[3].y-t[2].y,a=t[0].x-t[3].x,l=t[0].y-t[3].y,u=e*i-n*r,c=n*o-s*i,h=s*l-a*o,p=a*r-e*l;return u>0&&c>0&&h>0&&p>0||u<0&&c<0&&h<0&&p<0}(r))return console.warn("Image source coordinates are defining non-convex area in the Mercator projection"),void(this._unsupportedCoords=!0);const n=Dy(this.tileID,this.map.transform.projection),[i,a,l,u]=this.coordinates.map((t=>{const e=n.projection.project(t[0],t[1]);return Ly(n,e)._round()}));this.perspectiveTransform=Bg(i.x,i.y,a.x,a.y,l.x,l.y,u.x,u.y);const c=this._boundsArray=new ia;c.emplaceBack(i.x,i.y,0,0),c.emplaceBack(a.x,a.y,Cn,0),c.emplaceBack(u.x,u.y,0,Cn),c.emplaceBack(l.x,l.y,Cn,Cn),this.boundsBuffer&&(this.boundsBuffer.destroy(),this.elevatedGlobeVertexBuffer&&this.elevatedGlobeVertexBuffer.destroy(),this.elevatedGlobeIndexBuffer&&this.elevatedGlobeIndexBuffer.destroy()),this.boundsBuffer=t.createVertexBuffer(c,Sg.members),this.boundsSegments=tl.simpleSegment(0,0,4,2);const h=[],p=[Vg((f=this.coordinates)[0]),Vg(f[1]),Vg(f[2]),Vg(f[3])];var f;const[d,m,y,g]=function(t){let e=t[0][0],r=e,n=t[0][1],i=n;for(let s=1;s<t.length;s++)t[s][0]<e?e=t[s][0]:t[s][0]>r&&(r=t[s][0]),t[s][1]<n?n=t[s][1]:t[s][1]>i&&(i=t[s][1]);return [e,n,r-e,i-n]}(p);{const n=new ia,[i,a,l,u]=function(t){let e=t[0].x,r=e,n=t[0].y,i=n;for(let s=1;s<t.length;s++)t[s].x<e?e=t[s].x:t[s].x>r&&(r=t[s].x),t[s].y<n?n=t[s].y:t[s].y>i&&(i=t[s].y);return [e,n,r-e,i-n]}(r),c=t=>[(t.x-i)/l,(t.y-a)/u],[p,f,x,v]=r.map(c),b=function(t,e,r,n,i,a,l,u){const c=Tg(0,0,1,0,1,1,0,1);return o(c,c,s([],Tg(t,e,r,n,i,a,l,u)))}(p[0],p[1],f[0],f[1],x[0],x[1],v[0],v[1]);this.elevatedGlobePerspectiveTransform=Bg(p[0],p[1],f[0],f[1],x[0],x[1],v[0],v[1]);const w=(t,e)=>{h.push(t.lng);const r=Math.round((t.lng-d)/y*Cn),i=Math.round((t.lat-m)/g*Cn),s=c(e),o=O([],[s[0],s[1],1],b),a=Math.round(o[0]/o[2]*Cn),l=Math.round(o[1]/o[2]*Cn);n.emplaceBack(r,i,a,l);},_=r[3].x-r[0].x,A=r[3].y-r[0].y,M=r[2].x-r[1].x,I=r[2].y-r[1].y;for(let t=0;t<65;t++){const n=t/64,i=[r[0].x+n*_,r[0].y+n*A],s=[r[1].x+n*M,r[1].y+n*I],o=s[0]-i[0],a=s[1]-i[1];for(let t=0;t<65;t++){const r=t/64,n={x:i[0]+o*r,y:i[1]+a*r};w(e.projection.unproject(n.x,n.y),n);}}this.elevatedGlobeVertexBuffer=t.createVertexBuffer(n,Sg.members);}{this.maxLongitudeTriangleSize=0;let e=[],r=new Aa;const n=(t,n,i)=>{r.emplaceBack(t,n,i);const s=h[t],o=h[n],a=h[i],l=Math.min(Math.min(s,o),a),u=Math.max(Math.max(s,o),a)-l;u>this.maxLongitudeTriangleSize&&(this.maxLongitudeTriangleSize=u),e.push(l+u/2);};for(let t=0;t<64;t++)for(let e=0;e<64;e++){const r=65*t+e,i=r+1,s=r+65,o=s+1;n(r,s,i),n(i,s,o);}[e,r]=function(t,e){const r=Array.from({length:t.length},((t,e)=>e));r.sort(((e,r)=>t[e]-t[r]));const n=[],i=new Aa;for(let s=0;s<r.length;s++){const o=r[s];n.push(t[o]);const a=3*o,l=a+1;i.emplaceBack(e.uint16[a],e.uint16[l],e.uint16[l+1]);}return [n,i]}(e,r),this.elevatedGlobeTrianglesCenterLongitudes=e,this.elevatedGlobeIndexBuffer=t.createIndexBuffer(r);}this.elevatedGlobeSegments=tl.simpleSegment(0,0,4225,8192),this.elevatedGlobeGridMatrix=new Float32Array([0,y/Cn,0,g/Cn,0,0,m,d,0]);}prepare(){const t=0!==Object.keys(this.tiles).length;if(this.tileID&&!t)return;const e=this.map.painter.context,r=e.gl;!this._dirty||this.texture instanceof Eg||(this.texture?this.texture.update(this.image):(this.texture=new Pg(e,this.image,r.RGBA8),this.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE)),this._dirty=!1),t&&this._prepareData(e);}loadTile(t,e){this.tileID&&this.tileID.equals(t.tileID.canonical)?(this.tiles[String(t.tileID.wrap)]=t,t.buckets={},e(null)):(t.state="errored",e(null));}serialize(){return {type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return !1}getSegmentsForLongitude(t){const e=this.elevatedGlobeSegments;if(!this.elevatedGlobeTrianglesCenterLongitudes||!e)return null;const r=this.elevatedGlobeTrianglesCenterLongitudes;let n=(i=t+180)+360*Math.round((r[0]-i)/360);var i;const s=new tl,o=(t,r)=>{s.segments.push({vertexOffset:0,primitiveOffset:t,vertexLength:e.segments[0].vertexLength,primitiveLength:r,sortKey:void 0,vaos:{}});},a=.51*this.maxLongitudeTriangleSize;if(Math.abs(r[0]-n)<=a){const t=Qt(r,0,r.length,n+a);return t===r.length||o(t,Jt(r,t+1,r.length,n+360-a)-t),s}n<r[0]&&(n+=360);const l=Jt(r,0,r.length,n-a);if(l===r.length)return o(0,r.length),s;o(0,l-0);const u=Qt(r,l+1,r.length,n+a);return u!==r.length&&o(u,r.length-u),s}}const Fg=(Math.pow(256,2)-1)/16907520;class Dg extends Yo{constructor(t,e,r,n){super(t,{layout:Mg||(Mg=new Po({visibility:new So(Eo.layout_raster.visibility)})),paint:Ig||(Ig=new Po({"raster-opacity":new So(Eo.paint_raster["raster-opacity"]),"raster-color":new ko(Eo.paint_raster["raster-color"]),"raster-color-mix":new So(Eo.paint_raster["raster-color-mix"]),"raster-color-range":new So(Eo.paint_raster["raster-color-range"]),"raster-hue-rotate":new So(Eo.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new So(Eo.paint_raster["raster-brightness-min"]),"raster-brightness-max":new So(Eo.paint_raster["raster-brightness-max"]),"raster-saturation":new So(Eo.paint_raster["raster-saturation"]),"raster-contrast":new So(Eo.paint_raster["raster-contrast"]),"raster-resampling":new So(Eo.paint_raster["raster-resampling"]),"raster-fade-duration":new So(Eo.paint_raster["raster-fade-duration"]),"raster-emissive-strength":new So(Eo.paint_raster["raster-emissive-strength"]),"raster-array-band":new So(Eo.paint_raster["raster-array-band"]),"raster-elevation":new So(Eo.paint_raster["raster-elevation"]),"raster-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this.updateColorRamp(),this._curRampRange=[NaN,NaN];}getProgramIds(){return ["raster"]}hasColorMap(){return !!this._transitionablePaint._values["raster-color"].value.value}tileCoverLift(){return this.paint.get("raster-elevation")}isDraped(t){return !(t&&t._source instanceof Cg&&(t._source.onNorthPole||t._source.onSouthPole))&&0===this.paint.get("raster-elevation")}_handleSpecialPaintPropertyUpdate(t){"raster-color"!==t&&"raster-color-range"!==t||(this._curRampRange=[NaN,NaN],this.updateColorRamp());}updateColorRamp(t){if(!this.hasColorMap())return;if(!this._curRampRange)return;const e=this._transitionablePaint._values["raster-color"].value.expression,[r,n]=t||this._transitionablePaint._values["raster-color-range"].value.expression.evaluate({zoom:0})||[NaN,NaN];isNaN(r)&&isNaN(n)||r===this._curRampRange[0]&&n===this._curRampRange[1]||(this.colorRamp=xh({expression:e,evaluationKey:"rasterValue",image:this.colorRamp,clips:[{start:r,end:n}],resolution:256}),this.colorRampTexture=null,this._curRampRange=[r,n]);}}let Lg,Rg,Og,Ug,Ng;class jg extends Yo{constructor(t,e,r,n){super(t,{layout:Lg||(Lg=new Po({visibility:new So(Eo["layout_raster-particle"].visibility)})),paint:Rg||(Rg=new Po({"raster-particle-array-band":new So(Eo["paint_raster-particle"]["raster-particle-array-band"]),"raster-particle-count":new So(Eo["paint_raster-particle"]["raster-particle-count"]),"raster-particle-color":new ko(Eo["paint_raster-particle"]["raster-particle-color"]),"raster-particle-max-speed":new So(Eo["paint_raster-particle"]["raster-particle-max-speed"]),"raster-particle-speed-factor":new So(Eo["paint_raster-particle"]["raster-particle-speed-factor"]),"raster-particle-fade-opacity-factor":new So(Eo["paint_raster-particle"]["raster-particle-fade-opacity-factor"]),"raster-particle-reset-rate-factor":new So(Eo["paint_raster-particle"]["raster-particle-reset-rate-factor"]),"raster-particle-elevation":new So(Eo["paint_raster-particle"]["raster-particle-elevation"]),"raster-particle-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._updateColorRamp(),this.lastInvalidatedAt=fe.now();}onRemove(t){this.colorRampTexture&&this.colorRampTexture.destroy(),this.tileFramebuffer&&this.tileFramebuffer.destroy(),this.particleFramebuffer&&this.particleFramebuffer.destroy();}hasColorMap(){return !!this._transitionablePaint._values["raster-particle-color"].value.value}getProgramIds(){return ["rasterParticle"]}hasOffscreenPass(){return "none"!==this.visibility}isDraped(t){return !1}_handleSpecialPaintPropertyUpdate(t){"raster-particle-color"!==t&&"raster-particle-max-speed"!==t||(this._updateColorRamp(),this._invalidateAnimationState()),"raster-particle-count"===t&&this._invalidateAnimationState();}_updateColorRamp(){if(!this.hasColorMap())return;const t=this._transitionablePaint._values["raster-particle-color"].value.expression,e=this._transitionablePaint._values["raster-particle-max-speed"].value.expression.evaluate({zoom:0});this.colorRamp=xh({expression:t,evaluationKey:"rasterParticleSpeed",image:this.colorRamp,clips:[{start:0,end:e}],resolution:256}),this.colorRampTexture=null;}_invalidateAnimationState(){this.lastInvalidatedAt=fe.now();}tileCoverLift(){return this.paint.get("raster-particle-elevation")}}class $g extends Yo{constructor(t,e){super(t,{},e,null),this.implementation=t,t.slot&&(this.slot=t.slot);}is3D(t){return "3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}isDraped(t){return void 0!==this.implementation.renderToTile}shouldRedrape(){return !!this.implementation.shouldRerenderTiles&&this.implementation.shouldRerenderTiles()}recalculate(){}updateTransitions(){}hasTransition(){return !1}serialize(){}onAdd(t){this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl);}onRemove(t){this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl);}}function Gg(t,e,r){const n=[0,0,1],i=Y([]);return J(i,i,r?-Mt(t)+Math.PI:Mt(t)),K(i,i,-Mt(e)),U(n,n,i),C(n,n)}function qg(t,e){const r=Xg(t.projection,t.zoom,t.width,t.height),n=function(t,e,r,n,i){const s=new Hl(r.lng-180*Zg,r.lat),o=new Hl(r.lng+180*Zg,r.lat),a=t.project(s.lng,s.lat),u=t.project(o.lng,o.lat),h=-Math.atan2(u.y-a.y,u.x-a.x),f=lu.fromLngLat(r);f.y=Et(f.y,-1+Zg,1-Zg);const d=f.toLngLat(),y=t.project(d.lng,d.lat),g=lu.fromLngLat(d);g.x+=Zg;const x=g.toLngLat(),v=t.project(x.lng,x.lat),b=Yg(v.x-y.x,v.y-y.y,h),w=lu.fromLngLat(d);w.y+=Zg;const _=w.toLngLat(),A=t.project(_.lng,_.lat),M=Yg(A.x-y.x,A.y-y.y,h),I=Math.abs(b.x)/Math.abs(M.y),S=l([]);m(S,S,-h*(1-(i?0:n)));const z=l([]);return p(z,z,[1,1-(1-I)*n,1]),z[4]=-M.x/M.y*n,m(z,z,h),c(z,S,z),z}(t.projection,0,t.center,r,e),i=Hg(t);return p(n,n,[i,i,1]),n}function Hg(t){const e=t.projection,r=Xg(t.projection,t.zoom,t.width,t.height),n=Wg(e,t.center),i=Wg(e,Hl.convert(e.center));return Math.pow(2,n*r+(1-r)*i)}function Xg(t,e,r,n,i=1/0){const s=t.range;if(!s)return 0;const o=Math.min(i,Math.max(r,n)),a=Math.log(o/1024)/Math.LN2;return Tt(s[0]+a,s[1]+a,e)}const Zg=1/4e4;function Wg(t,e){const r=Et(e.lat,-85.051129,nu),n=new Hl(e.lng-180*Zg,r),i=new Hl(e.lng+180*Zg,r),s=t.project(n.lng,r),o=t.project(i.lng,r),a=lu.fromLngLat(n),l=lu.fromLngLat(i),u=o.x-s.x,c=o.y-s.y,h=l.x-a.x,p=l.y-a.y,f=Math.sqrt((h*h+p*p)/(u*u+c*c));return Math.log(f)/Math.LN2}function Yg(t,e,r){const n=Math.cos(r),i=Math.sin(r);return {x:t*n-e*i,y:t*i+e*n}}function Kg(t,e,r){l(t),m(t,t,Mt(e[2])),f(t,t,Mt(e[0])),d(t,t,Mt(e[1])),p(t,t,r),c(t,t,[1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1]);}function Jg(t,e,r,n,i,s,o,a){const l=[r[0]-e[0],r[1]-e[1],0],u=[n[0]-e[0],n[1]-e[1],0];if(_(l)<1e-12||_(u)<1e-12)return Y(t);const c=D([],l,u);C(c,c),I(u,n,e),l[2]=(s-i)*a,u[2]=(o-i)*a;const h=l;return D(h,l,u),C(h,h),st(t,c,h)}function Qg(t,e,r=!1){const n=Zc(e.zoom),i=function(t,e,r){const n=e.worldSize,i=[t[12],t[13],t[14]],s=eu(i[1]/n),o=tu(i[0]/n),a=l([]),u=Ql(1,s)*n,f=Ql(1,0)*n*su(s,e.zoom),d=1/qc(n);let m=f*d;if(r){const t=Xg(e.projection,e.zoom,e.width,e.height,1024);m=d*e.projection.pixelSpaceConversion(e.center.lat,n,t);}const y=$l(s,o);M(y,y,P([],C([],y),u*m*i[2]));const g=function(t){const e=[t[0],t[1],t[2]];let r=[0,1,0];const n=D([],r,e);return D(r,e,n),0===B(r)&&(r=[0,1,0],D(n,e,r)),C(n,n),C(r,r),C(e,e),[n[0],n[1],n[2],0,r[0],r[1],r[2],0,e[0],e[1],e[2],0,t[0],t[1],t[2],1]}(y);p(a,a,[m,m,m*u]),h(a,a,[-i[0],-i[1],-i[2]]);const x=c([],e.globeMatrix,g);return c(x,x,a),c(x,x,t),x}(t,e,r);if(n>0){const r=function(t,e){const r=e.worldSize,n=Ql(1,0)*r*su(e.center.lat,e.zoom)/qc(r),i=Ql(1,e.center.lat)*r,s=l([]);return d(s,s,Mt(e.center.lng)),f(s,s,Mt(e.center.lat)),h(s,s,[0,0,Cl]),p(s,s,[n,n,n*i]),h(s,s,[e.point.x-.5*r,e.point.y-.5*r,0]),c(s,s,t),c(s,e.globeMatrix,s)}(t,e);return function(t,e,r){const n=(t,e,r)=>{const n=_(t),i=_(e),s=Fc(t,e,r);return P(s,s,1/_(s)*ur(n,i,r))},i=n([t[0],t[1],t[2]],[e[0],e[1],e[2]],r),s=n([t[4],t[5],t[6]],[e[4],e[5],e[6]],r),o=n([t[8],t[9],t[10]],[e[8],e[9],e[10]],r),a=Fc([t[12],t[13],t[14]],[e[12],e[13],e[14]],r);return [i[0],i[1],i[2],0,s[0],s[1],s[2],0,o[0],o[1],o[2],0,a[0],a[1],a[2],1]}(i,r,n)}return i}function tx(t,e,r,n){const i=qu.projectAabbCorners(n,r);let s=Number.MAX_VALUE,o=-1;for(let t=0;t<i.length;++t){const r=i[t];r[0]=(.5*r[0]+.5)*e.width,r[1]=(.5-.5*r[1])*e.height,r[2]<s&&(o=t,s=r[2]);}const a=t=>new bt(i[t][0],i[t][1]);let l;switch(o){case 0:case 6:l=[a(1),a(5),a(4),a(7),a(3),a(2),a(1)];break;case 1:case 7:l=[a(0),a(4),a(5),a(6),a(2),a(3),a(0)];break;case 3:case 5:l=[a(1),a(0),a(4),a(7),a(6),a(2),a(1)];break;default:l=[a(1),a(5),a(6),a(7),a(3),a(0),a(1)];}if(Ku(t,l))return s}const ex=ta([{name:"a_pos_3f",components:3,type:"Float32"}]),rx=ta([{name:"a_color_3f",components:3,type:"Float32"}]),nx=ta([{name:"a_color_4f",components:4,type:"Float32"}]),ix=ta([{name:"a_uv_2f",components:2,type:"Float32"}]),sx=ta([{name:"a_normal_3f",components:3,type:"Float32"}]),ox=ta([{name:"a_normal_matrix0",components:4,type:"Float32"},{name:"a_normal_matrix1",components:4,type:"Float32"},{name:"a_normal_matrix2",components:4,type:"Float32"},{name:"a_normal_matrix3",components:4,type:"Float32"}]),ax=ta([{name:"a_pbr",components:4,type:"Uint16"},{name:"a_heightBasedEmissiveStrength",components:3,type:"Float32"}]),lx={None:0,Model:1,Symbol:2,FillExtrusion:4};class ux{constructor(t,e,r,n){this.message=(t?`${t}: `:"")+r,n&&(this.identifier=n),null!=e&&e.__line__&&(this.line=e.__line__);}}function cx(t,e){const r=-1===t.indexOf("://");try{return new URL(t,r&&e?"http://example.com":void 0),!0}catch(t){return !1}}class hx{constructor(t,e){this.feature=t,this.instancedDataOffset=e,this.instancedDataCount=0,this.rotation=[0,0,0],this.scale=[1,1,1],this.translation=[0,0,0];}}class px{constructor(){this.instancedDataArray=new Ca,this.instancesEvaluatedElevation=[],this.features=[],this.idToFeaturesIndex={};}}class fx{constructor(t){this.zoom=t.zoom,this.canonical=t.canonical,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.projection=t.projection,this.index=t.index,this.worldview=t.worldview,this.hasZoomDependentProperties=this.layers[0].isZoomDependent(),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.hasPattern=!1,this.instancesPerModel={},this.validForExaggeration=0,this.maxVerticalOffset=0,this.maxScale=0,this.maxHeight=0,this.lookupDim=this.zoom>this.canonical.z?256:this.zoom>15?75:100,this.instanceCount=0,this.terrainElevationMin=0,this.terrainElevationMax=0,this.validForDEMTile={id:null,timestamp:0},this.modelUris=[],this.modelsRequested=!1,this.activeReplacements=[],this.replacementUpdateTime=0,this.styleDefinedModelURLs=t.styleDefinedModelURLs;}updateFootprints(t,e){}populate(t,e,r,n){this.tileToMeter=au(r);const i=this.layers[0]._featureFilter.needGeometry;this.lookup=new Uint8Array(this.lookupDim*this.lookupDim);for(const{feature:s,id:o,index:a,sourceLayerIndex:l}of t){const t=null!=o?o:s.properties&&s.properties.hasOwnProperty("id")?s.properties.id:void 0,u=gu(s,i);if(!this.layers[0]._featureFilter.filter(new go(this.zoom,{worldview:this.worldview}),u,r))continue;const c={id:t,sourceLayerIndex:l,index:a,geometry:i?u.geometry:yu(s,r,n),properties:s.properties,type:s.type,patterns:{}},h=this.addFeature(c,c.geometry,u);h&&e.featureIndex.insert(s,c.geometry,a,l,this.index,this.instancesPerModel[h].instancedDataArray.length,Cn/32);}this.lookup=null;}update(t,e,r,n){for(const e in this.instancesPerModel){const r=this.instancesPerModel[e];for(const e in t)r.idToFeaturesIndex.hasOwnProperty(e)&&(this.evaluate(r.features[r.idToFeaturesIndex[e]],t[e],r,!0),this.uploaded=!1);}this.maxHeight=0;}updateZoomBasedPaintProperties(){if(!this.hasZoomDependentProperties)return !1;let t=!1;for(const e in this.instancesPerModel){const r=this.instancesPerModel[e];for(const e of r.features){const n=this.layers[0],i=e.feature,s=this.canonical,o=n.paint.get("model-rotation").evaluate(i,{},s),a=n.paint.get("model-scale").evaluate(i,{},s),l=n.paint.get("model-translation").evaluate(i,{},s);N(e.rotation,o)&&N(e.scale,a)&&N(e.translation,l)||(this.evaluate(e,e.featureStates,r,!0),t=!0);}}return t}updateReplacement(t,e,r,n){if(e.updateTime===this.replacementUpdateTime)return !1;this.replacementUpdateTime=e.updateTime;const i=e.getReplacementRegionsForTile(t.toUnwrapped(),!0);if(Vp(this.activeReplacements,i))return !1;this.activeReplacements=i;let s=!1;for(const e in this.instancesPerModel){const i=this.instancesPerModel[e],o=i.instancedDataArray;for(const e of i.features){const i=e.instancedDataOffset,a=e.instancedDataCount;for(let e=0;e<a;e++){const a=16*(e+i);let l=o.float32[a+0];const u=l>Cn;l=u?l-Cn:l;const c=Math.floor(l),h=o.float32[a+1];let p=!1;for(const e of this.activeReplacements)if(!Pp(e,r,lx.Model,n)&&!(e.min.x>c||c>e.max.x||e.min.y>h||h>e.max.y)&&(p=Op(Rp(c,h,t.canonical,e.footprintTileId.canonical),e.footprint),p))break;o.float32[a]=p?l+Cn:l,s=s||p!==u;}}}return s}isEmpty(){for(const t in this.instancesPerModel)if(0!==this.instancesPerModel[t].instancedDataArray.length)return !1;return !0}uploadPending(){return !this.uploaded}upload(t){if(!this.uploaded)for(const e in this.instancesPerModel){const r=this.instancesPerModel[e];r.instancedDataArray.length<0||0===r.instancedDataArray.length||(r.instancedDataBuffer?r.instancedDataBuffer.updateData(r.instancedDataArray):r.instancedDataBuffer=t.createVertexBuffer(r.instancedDataArray,ox.members,!0,void 0,this.instanceCount));}this.uploaded=!0;}destroy(){for(const t in this.instancesPerModel){const e=this.instancesPerModel[t];0!==e.instancedDataArray.length&&e.instancedDataBuffer&&e.instancedDataBuffer.destroy();}const t=this.layers[0].modelManager;if(t&&this.modelUris&&this.modelsRequested)for(const e of this.modelUris)t.removeModel(e,"",!0);}addFeature(t,e,r){const n=this.layers[0],i=n.layout.get("model-id").evaluate(r,{},this.canonical);if(!i)return Gt(`modelId is not evaluated for layer ${n.id} and it is not going to get rendered.`),i;(cx(i,!1)||void 0!==this.styleDefinedModelURLs[i])&&(this.modelUris.includes(i)||this.modelUris.push(i)),this.instancesPerModel[i]||(this.instancesPerModel[i]=new px);const s=this.instancesPerModel[i],o=s.instancedDataArray,a=new hx(r,o.length);for(const t of e)for(const e of t){if(e.x<0||e.x>=Cn||e.y<0||e.y>=Cn)continue;const t=(this.lookupDim-1)/Cn,r=this.lookupDim*(e.y*t|0)+e.x*t|0;if(this.lookup){if(0!==this.lookup[r])continue;this.lookup[r]=1;}this.instanceCount++;const n=o.length;o.resize(n+1),s.instancesEvaluatedElevation.push(0),o.float32[16*n]=e.x,o.float32[16*n+1]=e.y;}return a.instancedDataCount=s.instancedDataArray.length-a.instancedDataOffset,a.instancedDataCount>0&&(t.id&&(s.idToFeaturesIndex[t.id]=s.features.length),s.features.push(a),this.evaluate(a,{},s,!1)),i}getModelUris(){return this.modelUris}evaluate(t,e,r,n){const i=this.layers[0],s=t.feature,o=this.canonical,a=t.rotation=i.paint.get("model-rotation").evaluate(s,e,o),l=t.scale=i.paint.get("model-scale").evaluate(s,e,o),u=t.translation=i.paint.get("model-translation").evaluate(s,e,o),c=i.paint.get("model-color").evaluate(s,e,o);c.a=i.paint.get("model-color-mix-intensity").evaluate(s,e,o);const h=[];this.maxVerticalOffset<u[2]&&(this.maxVerticalOffset=u[2]),this.maxScale=Math.max(Math.max(this.maxScale,l[0]),Math.max(l[1],l[2])),Kg(h,a,l);const p=Math.round(100*c.a)+c.b/1.05;for(let e=0;e<t.instancedDataCount;++e){const i=t.instancedDataOffset+e,s=16*i,a=r.instancedDataArray.float32;let l=0;n&&(l=a[s+6]-r.instancesEvaluatedElevation[i]);const f=0|a[s+1];a[s]=(0|a[s])+c.r/1.05,a[s+1]=f+c.g/1.05,a[s+2]=p,a[s+3]=1/(o.z>10?this.tileToMeter:au(o,f)),a[s+4]=u[0],a[s+5]=u[1],a[s+6]=u[2]+l,a[s+7]=h[0],a[s+8]=h[1],a[s+9]=h[2],a[s+10]=h[4],a[s+11]=h[5],a[s+12]=h[6],a[s+13]=h[8],a[s+14]=h[9],a[s+15]=h[10],r.instancesEvaluatedElevation[i]=u[2];}}}let dx,mx;qs(fx,"ModelBucket",{omit:["layers"]}),qs(px,"PerModelAttributes"),qs(hx,"ModelFeature");const yx=64,gx={CoordinateSpaceTile:1,HasMapboxMeshFeatures:4,HasMeshoptCompression:8};function xx(t,e,r,n,i,s,o,a,u,f=!1){const d=r.zoom,m=r.project(n),y=su(n.lat,d),g=1/y;l(t),h(t,t,[m.x+o[0]*g,m.y+o[1]*g,o[2]]);let v=1,b=1;const w=r.worldSize;if(f){if("mercator"===r.projection.name){let t=0;r.elevation&&(t=r.elevation.getAtPointOrZero(new lu(m.x/w,m.y/w),0));const e=Z([],[m.x,m.y,t,1],r.projMatrix)[3]/r.cameraToCenterDistance;v=e,b=e*su(r.center.lat,d);}else if("globe"===r.projection.name){const e=Qg(t,r),i=[0,0,0,1];Z(i,i,c([],r.projMatrix,e));const s=i[3]/r.cameraToCenterDistance,o=Zc(d),a=r.projection.pixelsPerMeter(n.lat,w)*su(n.lat,d),l=r.projection.pixelsPerMeter(r.center.lat,w)*su(r.center.lat,d);v=s/ur(a,iu(r.center.lat),o),b=s*y/a,v*=l,b*=l;}}else v=g;p(t,t,[v,v,b]);const _=[...t],A=e.orientation,M=[];if(Kg(M,[A[0]+i[0],A[1]+i[1],A[2]+i[2]],s),c(t,_,M),a&&r.elevation){let i=0;const s=[];if(u&&r.elevation){i=function(t,e,r,n,i){const s=e.elevation;if(!s)return 0;const o=qu.projectAabbCorners(r,n),a=Ql(1,i.lat)*e.worldSize,l=function(t,e){const r=[0,0,1],n=[{corners:[0,1,3,2],dotProductWithUp:0},{corners:[1,5,2,6],dotProductWithUp:0},{corners:[0,4,1,5],dotProductWithUp:0},{corners:[2,6,3,7],dotProductWithUp:0},{corners:[4,7,5,6],dotProductWithUp:0},{corners:[0,3,4,7],dotProductWithUp:0}];for(const i of n){const n=t[i.corners[0]],s=t[i.corners[1]],o=t[i.corners[2]],a=[s[0]-n[0],s[1]-n[1],e*(s[2]-n[2])],l=D(a,a,[o[0]-n[0],o[1]-n[1],e*(o[2]-n[2])]);C(l,l),i.dotProductWithUp=F(l,r);}return n.sort(((t,e)=>t.dotProductWithUp-e.dotProductWithUp)),n[0].corners}(o,a),u=o[l[0]],c=o[l[1]],h=o[l[2]],p=o[l[3]],f=s.getAtPointOrZero(new lu(u[0]/e.worldSize,u[1]/e.worldSize),0),d=s.getAtPointOrZero(new lu(c[0]/e.worldSize,c[1]/e.worldSize),0),m=s.getAtPointOrZero(new lu(h[0]/e.worldSize,h[1]/e.worldSize),0),y=s.getAtPointOrZero(new lu(p[0]/e.worldSize,p[1]/e.worldSize),0),g=(f+y)/2,x=(d+m)/2;return g>x?d<m?Jg(t,c,p,u,d,y,f,a):Jg(t,h,u,p,m,f,y,a):f<y?Jg(t,u,c,h,f,d,m,a):Jg(t,p,h,c,y,m,d,a),Math.max(g,x)}(s,r,e.aabb,t,n);const o=c([],x([],s),M);c(t,_,o);}else i=r.elevation.getAtPointOrZero(new lu(m.x/w,m.y/w),0);0!==i&&(t[14]+=i);}}function vx(t,e,r=!1){t.uploaded||(t.gfxTexture=new Pg(e,t.image,r?e.gl.R8:e.gl.RGBA8,{useMipmap:t.sampler.minFilter>=e.gl.NEAREST_MIPMAP_NEAREST}),t.uploaded=!0,t.image=null);}function bx(t,e,r){t.indexBuffer=e.createIndexBuffer(t.indexArray,!1,!0),t.vertexBuffer=e.createVertexBuffer(t.vertexArray,ex.members,!1,!0),t.normalArray&&(t.normalBuffer=e.createVertexBuffer(t.normalArray,sx.members,!1,!0)),t.texcoordArray&&(t.texcoordBuffer=e.createVertexBuffer(t.texcoordArray,ix.members,!1,!0)),t.colorArray&&(t.colorBuffer=e.createVertexBuffer(t.colorArray,(12===t.colorArray.bytesPerElement?rx:nx).members,!1,!0)),t.featureArray&&(t.pbrBuffer=e.createVertexBuffer(t.featureArray,ax.members,!0)),t.segments=tl.simpleSegment(0,0,t.vertexArray.length,t.indexArray.length);const n=t.material;n.pbrMetallicRoughness.baseColorTexture&&vx(n.pbrMetallicRoughness.baseColorTexture,e),n.pbrMetallicRoughness.metallicRoughnessTexture&&vx(n.pbrMetallicRoughness.metallicRoughnessTexture,e),n.normalTexture&&vx(n.normalTexture,e),n.occlusionTexture&&vx(n.occlusionTexture,e,r),n.emissionTexture&&vx(n.emissionTexture,e);}function wx(t,e,r){if(t.meshes)for(const n of t.meshes)bx(n,e,r);if(t.children)for(const n of t.children)wx(n,e,r);}function _x(t){if(t.meshes)for(const e of t.meshes)e.indexArray.destroy(),e.vertexArray.destroy(),e.colorArray&&e.colorArray.destroy(),e.normalArray&&e.normalArray.destroy(),e.texcoordArray&&e.texcoordArray.destroy(),e.featureArray&&e.featureArray.destroy();if(t.children)for(const e of t.children)_x(e);}function Ax(t){if(t.meshes)for(const r of t.meshes)r.vertexBuffer&&(r.vertexBuffer.destroy(),r.indexBuffer.destroy(),r.normalBuffer&&r.normalBuffer.destroy(),r.texcoordBuffer&&r.texcoordBuffer.destroy(),r.colorBuffer&&r.colorBuffer.destroy(),r.pbrBuffer&&r.pbrBuffer.destroy(),r.segments.destroy(),r.material&&((e=r.material).pbrMetallicRoughness.baseColorTexture&&e.pbrMetallicRoughness.baseColorTexture.gfxTexture&&e.pbrMetallicRoughness.baseColorTexture.gfxTexture.destroy(),e.pbrMetallicRoughness.metallicRoughnessTexture&&e.pbrMetallicRoughness.metallicRoughnessTexture.gfxTexture&&e.pbrMetallicRoughness.metallicRoughnessTexture.gfxTexture.destroy(),e.normalTexture&&e.normalTexture.gfxTexture&&e.normalTexture.gfxTexture.destroy(),e.emissionTexture&&e.emissionTexture.gfxTexture&&e.emissionTexture.gfxTexture.destroy(),e.occlusionTexture&&e.occlusionTexture.gfxTexture&&e.occlusionTexture.gfxTexture.destroy()));var e;if(t.children)for(const e of t.children)Ax(e);}class Mx{constructor(t,e,r){this._demTile=t,this._dem=this._demTile.dem,this._scale=e,this._offset=r;}static create(t,e,r){const n=r||t.findDEMTileFor(e);if(!n||!n.dem)return;const i=n.dem,s=n.tileID,o=1<<e.canonical.z-s.canonical.z;return new Mx(n,i.dim/Cn/o,[(e.canonical.x/o-s.canonical.x)*i.dim,(e.canonical.y/o-s.canonical.y)*i.dim])}tileCoordToPixel(t,e){const r=e*this._scale+this._offset[1],n=Math.floor(t*this._scale+this._offset[0]),i=Math.floor(r);return new bt(n,i)}getElevationAt(t,e,r,n){const i=t*this._scale+this._offset[0],s=e*this._scale+this._offset[1],o=Math.floor(i),a=Math.floor(s),l=this._dem;return n=!!n,r?ur(ur(l.get(o,a,n),l.get(o,a+1,n),s-a),ur(l.get(o+1,a,n),l.get(o+1,a+1,n),s-a),i-o):l.get(o,a,n)}getElevationAtPixel(t,e,r){return this._dem.get(t,e,!!r)}getMeterToDEM(t){return (1<<this._demTile.tileID.canonical.z)*Ql(1,t)*this._dem.stride}}const Ix=new Float32Array(262144),Sx=new Uint8Array(262144);function zx(t){let e=0;if(t.meshes)for(const r of t.meshes)e=Math.max(e,r.aabb.max[2]);if(t.children)for(const r of t.children)e=Math.max(e,zx(r));return e}function kx(t,e,r){if(t.meshes)for(const n of t.meshes){if(n.aabb.min[0]===1/0)continue;const i=qu.applyTransform(n.aabb,t.matrix);r.insert(e,i.min[0],i.min[1],i.max[0],i.max[1]);}if(t.children)for(const n of t.children)kx(n,e,r);}const Px=["","wall","door","roof","window","lamp","logo"];class Ex{constructor(t){this.node=t,this.evaluatedRMEA=[[1,0,0,1],[1,0,0,1],[1,0,0,1],[1,0,0,1],[.4,1,0,1],[1,0,0,1],[1,0,0,1]],this.hiddenByReplacement=!1,this.evaluatedTranslation=[0,0,0],this.evaluatedScale=[1,1,1],this.evaluatedColor=[],this.emissionHeightBasedParams=[],this.cameraCollisionOpacity=1,this.feature={type:"Point",id:t.id,geometry:[],properties:{height:zx(t)}},this.aabb=this._getLocalBounds(),this.state=null;}_getLocalBounds(){if(!this.node.meshes)return new qu([1/0,1/0,1/0],[-1/0,-1/0,-1/0]);if(!this.aabb){let t=0;const e=new qu([1/0,1/0,1/0],[-1/0,-1/0,-1/0]);for(const r of this.node.meshes)this.node.lightMeshIndex!==t&&(r.transformedAabb=qu.applyTransformFast(r.aabb,this.node.matrix),e.encapsulate(r.transformedAabb)),t++;this.aabb=e;}return this.aabb}}class Tx{constructor(t,e,r,n,i,s,o,a){this.id=r,this.layers=t,this.layerIds=this.layers.map((t=>t.fqid)),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.modelTraits|=gx.CoordinateSpaceTile,this.uploaded=!1,this.hasPattern=!1,n&&(this.modelTraits|=gx.HasMapboxMeshFeatures),i&&(this.modelTraits|=gx.HasMeshoptCompression),this.zoom=-1,this.terrainExaggeration=1,this.projection={name:"mercator"},this.replacementUpdateTime=0,this.elevationReadFromZ=255,this.brightness=s,this.worldview=a,this.dirty=!0,this.needsUpload=!1,this.filter=null,this.nodesInfo=[];for(const t of e)this.nodesInfo.push(new Ex(t)),kx(t,o.featureIndexArray.length,o.grid),o.featureIndexArray.emplaceBack(this.nodesInfo.length-1,0,o.bucketLayerIDs.length-1,0);this.states={};}updateFootprints(t,e){for(const r of this.getNodesInfo()){const n=r.node;n.footprint&&e.push({footprint:n.footprint,id:t});}}update(t){const e=0!==Object.keys(t).length;if(e&&!this.stateDependentLayers.length)return;const r=e?this.stateDependentLayers:this.layers;if(!wt(t,this.states))for(const e of r)this.evaluate(e,t);this.states=structuredClone(t);}populate(){console.log("populate 3D model bucket");}uploadPending(){return !this.uploaded||this.needsUpload}upload(t){if(!this.needsUpload)return;const e=this.getNodesInfo();for(const r of e){const e=r.node;this.uploaded?this.updatePbrBuffer(e):wx(e,t,!0);}for(const t of e)_x(t.node);this.uploaded=!0,this.needsUpload=!1;}updatePbrBuffer(t){let e=!1;if(!t.meshes)return e;for(const r of t.meshes)r.pbrBuffer&&(r.pbrBuffer.updateData(r.featureArray),e=!0);return e}needsReEvaluation(t,e,r){const n=t.transform.projectionOptions,i=t.style.getBrightness(),s=this.brightness!==i;if(!this.uploaded||this.dirty||n.name!==this.projection.name||Bx(r.paint.get("model-color").value,s)||Bx(r.paint.get("model-color-mix-intensity").value,s)||Bx(r.paint.get("model-roughness").value,s)||Bx(r.paint.get("model-emissive-strength").value,s)||Bx(r.paint.get("model-height-based-emissive-strength-multiplier").value,s)){this.projection=n,this.brightness=i;const t=this.getNodesInfo();for(const e of t)e.state=null;return !0}return !1}evaluateTransform(t,e){if(t.transform.zoom===this.zoom)return;this.zoom=t.transform.zoom;const r=this.getNodesInfo(),n=this.id.canonical;for(const t of r){const r=t.feature;t.evaluatedTranslation=e.paint.get("model-translation").evaluate(r,{},n),t.evaluatedScale=e.paint.get("model-scale").evaluate(r,{},n);}}evaluate(t,e){const r=this.getNodesInfo();for(const n of r){if(!n.node.meshes)continue;const r=n.feature,i=e&&e[r.id];if(wt(i,n.state))continue;n.state=structuredClone(i);const s=n.node.meshes&&n.node.meshes[0].featureData,o=n.evaluatedColor[2],a=n.evaluatedRMEA[2],l=this.id.canonical;if(n.hasTranslucentParts=!1,s){for(let e=0;e<Px.length;e++){const s=Px[e];s.length&&(r.properties.part=s);const o=t.paint.get("model-color").evaluate(r,i,l).toPremultipliedRenderColor(null),a=t.paint.get("model-color-mix-intensity").evaluate(r,i,l);n.evaluatedColor[e]=[o.r,o.g,o.b,a],n.evaluatedRMEA[e][0]=t.paint.get("model-roughness").evaluate(r,i,l),n.evaluatedRMEA[e][2]=t.paint.get("model-emissive-strength").evaluate(r,i,l),n.evaluatedRMEA[e][3]=o.a,n.emissionHeightBasedParams[e]=t.paint.get("model-height-based-emissive-strength-multiplier").evaluate(r,i,l),!n.hasTranslucentParts&&o.a<1&&(n.hasTranslucentParts=!0);}delete r.properties.part,Cx(n,o!==n.evaluatedColor[2]||a!==n.evaluatedRMEA[2],this.modelTraits);}else n.evaluatedRMEA[0][2]=t.paint.get("model-emissive-strength").evaluate(r,i,l);n.evaluatedTranslation=t.paint.get("model-translation").evaluate(r,i,l),n.evaluatedScale=t.paint.get("model-scale").evaluate(r,i,l),this.updatePbrBuffer(n.node)||(this.needsUpload=!0);}this.dirty=!1;}elevationUpdate(t,e,r,n){const i=t.findDEMTileFor(r);if(i&&(i.tileID.canonical!==this.terrainTile||e!==this.terrainExaggeration)){if(i.dem&&i.tileID.overscaledZ!==this.elevationReadFromZ){this.elevationReadFromZ=i.tileID.overscaledZ;const e=Mx.create(t,r,i);if(!e)return;this.modelTraits&gx.HasMapboxMeshFeatures&&this.updateDEM(t,e,r,n);for(const t of this.getNodesInfo()){const r=t.node;if(!r.footprint||!r.footprint.vertices||!r.footprint.vertices.length)continue;const n=r.footprint.vertices;let i=e.getElevationAt(n[0].x,n[0].y,!0,!0);for(let t=1;t<n.length;t++)i=Math.min(i,e.getElevationAt(n[t].x,n[t].y,!0,!0));r.elevation=i;}}this.terrainTile=i.tileID.canonical,this.terrainExaggeration=e;}}updateDEM(t,e,r,n){let i=e._dem._modifiedForSources[n];if(void 0===i&&(e._dem._modifiedForSources[n]=[],i=e._dem._modifiedForSources[n]),i.includes(r.canonical))return;const s=e._dem.dim;i.push(r.canonical);let o=!1;for(const t of this.getNodesInfo()){const r=t.node;if(!r.footprint||!r.footprint.grid)continue;const n=r.footprint.grid,i=e.tileCoordToPixel(n.min.x,n.min.y),a=e.tileCoordToPixel(n.max.x,n.max.y),l=Math.min(Math.min(s-a.y,i.x),Math.min(i.y,s-a.x));if(l<0)continue;const u=Et(l,2,5);let c=Math.max(0,i.x-u),h=Math.max(0,i.y-u),p=Math.min(a.x+u,s-1),f=Math.min(a.y+u,s-1);for(let t=h;t<=f;++t)for(let e=c;e<=p;++e)Sx[t*s+e]=255;let d=0,m=0;for(let t=0;t<n.cellsY;++t)for(let r=0;r<n.cellsX;++r){if(!n.cells[t*n.cellsX+r])continue;const i=e.tileCoordToPixel(n.min.x+r/n.xScale,n.min.y+t/n.yScale),o=e.tileCoordToPixel(n.min.x+(r+1)/n.xScale,n.min.y+(t+1)/n.yScale);for(let t=i.y;t<=Math.min(o.y+1,s-1);++t)for(let r=i.x;r<=Math.min(o.x+1,s-1);++r)255===Sx[t*s+r]&&(Sx[t*s+r]=0,d+=e.getElevationAtPixel(r,t),m++);}const y=d/m;c=Math.max(1,i.x-u),h=Math.max(1,i.y-u),p=Math.min(a.x+u,s-2),f=Math.min(a.y+u,s-2),o=!0;for(let t=h;t<=f;++t)for(let r=c;r<=p;++r)0===Sx[t*s+r]&&(Ix[t*s+r]=e._dem.set(r,t,y));for(let t=1;t<u;++t){c=Math.max(1,i.x-t),h=Math.max(1,i.y-t),p=Math.min(a.x+t,s-2),f=Math.min(a.y+t,s-2);for(let r=h;r<=f;++r)for(let n=c;n<=p;++n){const i=r*s+n;if(255===Sx[i]){let o=0,a=0,l=-1,c=-1;for(let e=-1;e<=1;++e)for(let i=-1;i<=1;++i){const u=(r+e)*s+n+i;if(Sx[u]>=t)continue;const h=Ix[u],p=Math.abs(h);p>a&&(o=h,a=p,l=i,c=e);}if(a>.1){const s=1-(t+.5*Math.abs(l*c))/u;let a=e._dem.get(n,r)+o*s;const h=e._dem.get(n+l,r+c),p=e._dem.get(n-l,r-c,!0);(a-h)*(a-p)>0&&(a=(h+p)/2),Ix[i]=e._dem.set(n,r,a),Sx[i]=t;}}}}}o&&(e._demTile.needsDEMTextureUpload=!0,e._dem._timestamp=fe.now());}setFilter(t){this.filter=t?Co(t):null;}getNodesInfo(){return this.filter?this.nodesInfo.filter((t=>this.filter.filter(new go(this.id.overscaledZ,{worldview:this.worldview}),t.feature,this.id.canonical))):this.nodesInfo}destroy(){const t=this.getNodesInfo();for(const e of t)_x(e.node),Ax(e.node);}isEmpty(){return !this.nodesInfo.length}updateReplacement(t,e){if(e.updateTime===this.replacementUpdateTime)return;this.replacementUpdateTime=e.updateTime;const r=e.getReplacementRegionsForTile(t.toUnwrapped());for(const t of this.getNodesInfo()){const e=t.node.footprint;t.hiddenByReplacement=!!e&&!r.find((t=>t.footprint===e));}}getHeightAtTileCoord(t,e){const r=[],n=[0,0,0],i=l([]);for(const s of this.getNodesInfo()){const o=s.node.meshes[0],a=o.transformedAabb;if(t<a.min[0]||e<a.min[1]||t>a.max[0]||e>a.max[1])continue;if(!0===s.node.hidden)return {height:1/0,maxHeight:s.feature.properties.height,hidden:!1,verticalScale:s.evaluatedScale[2]};u(i,s.node.matrix),n[0]=t,n[1]=e,R(n,n,i);const l=(n[0]-o.aabb.min[0])/(o.aabb.max[0]-o.aabb.min[0])*yx|0,c=Math.min(63,(n[1]-o.aabb.min[1])/(o.aabb.max[1]-o.aabb.min[1])*yx|0)*yx+Math.min(63,l),h=o.heightmap[c];if(!(h<0&&s.node.footprint)){if(s.hiddenByReplacement)return;return {height:h,maxHeight:s.feature.properties.height,hidden:!1,verticalScale:s.evaluatedScale[2]}}if(s.node.footprint.grid.query(new bt(t,e),new bt(t,e),r),r.length>0)return {height:void 0,maxHeight:s.feature.properties.height,hidden:s.hiddenByReplacement,verticalScale:s.evaluatedScale[2]}}}}function Bx(t,e){return t instanceof Fs&&!t.isLightConstant&&e}function Vx(t,e,r,n,i,s,o,a){let l=(61440&e|(61440&e)>>4)>>8,u=(3840&e|(3840&e)>>4)>>4,c=240&e|(240&e)>>4;r[3]>0&&(l=ur(l,255*r[0],r[3]),u=ur(u,255*r[1],r[3]),c=ur(c,255*r[2],r[3]));const h=l<<8|u,p=c<<8|Math.floor(255*n[3]),f=function(t){const e=Et(t,0,2);return Math.min(Math.round(.5*e*255),255)}(n[2])<<8|15*n[0]<<4|15*n[1],d=Et(i[0],0,1),m=Et(i[1],0,1),y=Et(i[2],0,1),g=Et(i[3],0,1);let x,v,b,w;if(d!==m&&o!==s&&m!==d){const t=o-s;v=1/(t*(m-d)),b=-(s+t*d)/(t*(m-d));const e=Et(i[4],-1,1);w=Math.pow(10,e),x=255*y<<8|255*g;}else x=65535,v=0,b=1,w=1;if(t.emplaceBack(h,p,f,x,v,b,w),a){const t=a.length;a.clear();for(let e=0;e<t;e++)a.emplaceBack(h,p,f,x,v,b,w);}}function Cx(t,e,r){const n=t.node;let i=0;const s=r&gx.HasMeshoptCompression;for(const r of n.meshes){if(n.lights&&n.lightMeshIndex===i)continue;if(!r.featureData)continue;r.featureArray=new Fa,r.featureArray.reserve(r.featureData.length);let o=e;for(const e of r.featureData){const i=s?65535&e:e>>16&65535,a=s?e>>16&65535:65535&e,l=(15&a)<8?15&a:0,u=t.evaluatedRMEA[l],c=t.evaluatedColor[l],h=t.emissionHeightBasedParams[l];let p;if(o&&2===l&&n.lights&&(p=new Fa,p.resize(10*n.lights.length)),Vx(r.featureArray,i,c,u,h,r.aabb.min[2],r.aabb.max[2],p),p&&o){o=!1;const t=n.meshes[n.lightMeshIndex];t.featureArray=p,t.featureArray._trim();}}r.featureArray._trim(),i++;}}function Fx(t,e,r,n){const i=1<<t.z;e.lat=eu((n/Cn+t.y)/i),e.lng=tu((r/Cn+t.x)/i);}function Dx(t,e,r,n){const i=t.getNodesInfo()[e];if(!i||i.hiddenByReplacement||!i.node.meshes)return;let s=Number.MAX_VALUE;const o=i.node,a=r.tile,l=n.calculatePosMatrix(a.tileID.toUnwrapped(),n.worldSize),u=i.evaluatedScale;let f=0;n.elevation&&o.elevation&&(f=o.elevation*n.elevation.exaggeration()),h(l,l,[(o.anchor?o.anchor[0]:0)*(u[0]-1),(o.anchor?o.anchor[1]:0)*(u[1]-1),f]),p(l,l,u);const d=r.queryGeometry,m=d.isPointQuery()?d.screenBounds:d.screenGeometry,y=function(t){const e=c([],l,t.matrix);c(e,n.expandedFarZProjMatrix,e);for(let r=0;r<t.meshes.length;++r){const i=t.meshes[r];if(r===t.lightMeshIndex)continue;const o=tx(m,n,e,i.aabb);null!=o&&(s=Math.min(o,s));}if(t.children)for(const e of t.children)y(e);};if(y(o),s===Number.MAX_VALUE)return;const g=new Hl(0,0);return Fx(a.tileID.canonical,g,i.node.anchor[0],i.node.anchor[1]),{intersectionZ:s,position:g,feature:i.feature}}qs(Tx,"Tiled3dModelBucket",{omit:["layers"]}),qs(Ex,"Tiled3dModelFeature");const Lx={circle:class extends Yo{constructor(t,e,r,n){super(t,{layout:gc||(gc=new Po({"circle-sort-key":new zo(Eo.layout_circle["circle-sort-key"]),"circle-elevation-reference":new So(Eo.layout_circle["circle-elevation-reference"]),visibility:new So(Eo.layout_circle.visibility)})),paint:xc||(xc=new Po({"circle-radius":new zo(Eo.paint_circle["circle-radius"]),"circle-color":new zo(Eo.paint_circle["circle-color"]),"circle-blur":new zo(Eo.paint_circle["circle-blur"]),"circle-opacity":new zo(Eo.paint_circle["circle-opacity"]),"circle-translate":new So(Eo.paint_circle["circle-translate"]),"circle-translate-anchor":new So(Eo.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new So(Eo.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new So(Eo.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new zo(Eo.paint_circle["circle-stroke-width"]),"circle-stroke-color":new zo(Eo.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new zo(Eo.paint_circle["circle-stroke-opacity"]),"circle-emissive-strength":new So(Eo.paint_circle["circle-emissive-strength"]),"circle-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"}),"circle-stroke-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n);}createBucket(t){return new Yu(t)}queryRadius(t){const e=t;return fc("circle-radius",this,e)+fc("circle-stroke-width",this,e)+dc(this.paint.get("circle-translate"))}queryIntersectsFeature(t,e,r,n,i,s,o,a){const l=yc(this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),u=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r);return rh(t,n,s,o,a,"map"===this.paint.get("circle-pitch-alignment"),"map"===this.paint.get("circle-pitch-scale"),l,u)}getProgramIds(){return ["circle"]}getDefaultProgramParams(t,e,r){const n=eh(this);return {config:new zl(this,{zoom:e,lut:r}),defines:n,overrideFog:!1}}is3D(t){return !t&&!!this.layout&&"none"!==this.layout.get("circle-elevation-reference")}hasElevation(){return this.layout&&"none"!==this.layout.get("circle-elevation-reference")}},heatmap:class extends Yo{createBucket(t){return new ah(t)}constructor(t,e,r,n){super(t,{layout:lh||(lh=new Po({visibility:new So(Eo.layout_heatmap.visibility)})),paint:uh||(uh=new Po({"heatmap-radius":new zo(Eo.paint_heatmap["heatmap-radius"]),"heatmap-weight":new zo(Eo.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new So(Eo.paint_heatmap["heatmap-intensity"]),"heatmap-color":new ko(Eo.paint_heatmap["heatmap-color"]),"heatmap-opacity":new So(Eo.paint_heatmap["heatmap-opacity"]),"heatmap-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=xh({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null;}resize(){this.heatmapFbo&&(this.heatmapFbo.destroy(),this.heatmapFbo=null);}queryRadius(t){return fc("heatmap-radius",this,t)}queryIntersectsFeature(t,e,r,n,i,s,o,a){const l=this.paint.get("heatmap-radius").evaluate(e,r);return rh(t,n,s,o,a,!0,!0,new bt(0,0),l)}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}getProgramIds(){return ["heatmap","heatmapTexture"]}getDefaultProgramParams(t,e,r){return "heatmap"===t?{config:new zl(this,{zoom:e,lut:r}),overrideFog:!1}:{}}},hillshade:class extends Yo{constructor(t,e,r,n){super(t,{layout:ch||(ch=new Po({visibility:new So(Eo.layout_hillshade.visibility)})),paint:hh||(hh=new Po({"hillshade-illumination-direction":new So(Eo.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new So(Eo.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new So(Eo.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new So(Eo.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new So(Eo.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new So(Eo.paint_hillshade["hillshade-accent-color"]),"hillshade-emissive-strength":new So(Eo.paint_hillshade["hillshade-emissive-strength"]),"hillshade-shadow-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"}),"hillshade-highlight-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"}),"hillshade-accent-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n);}shouldRedrape(){return this.hasOffscreenPass()&&"viewport"===this.paint.get("hillshade-illumination-anchor")}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}getProgramIds(){return ["hillshade","hillshadePrepare"]}getDefaultProgramParams(t,e,r){return {overrideFog:!1}}},fill:class extends Yo{constructor(t,e,r,n){super(t,{layout:dp||(dp=new Po({"fill-sort-key":new zo(Eo.layout_fill["fill-sort-key"]),visibility:new So(Eo.layout_fill.visibility),"fill-elevation-reference":new So(Eo.layout_fill["fill-elevation-reference"]),"fill-construct-bridge-guard-rail":new zo(Eo.layout_fill["fill-construct-bridge-guard-rail"])})),paint:mp||(mp=new Po({"fill-antialias":new So(Eo.paint_fill["fill-antialias"]),"fill-opacity":new zo(Eo.paint_fill["fill-opacity"]),"fill-color":new zo(Eo.paint_fill["fill-color"]),"fill-outline-color":new zo(Eo.paint_fill["fill-outline-color"]),"fill-translate":new So(Eo.paint_fill["fill-translate"]),"fill-translate-anchor":new So(Eo.paint_fill["fill-translate-anchor"]),"fill-pattern":new zo(Eo.paint_fill["fill-pattern"]),"fill-pattern-cross-fade":new So(Eo.paint_fill["fill-pattern-cross-fade"]),"fill-emissive-strength":new So(Eo.paint_fill["fill-emissive-strength"]),"fill-z-offset":new zo(Eo.paint_fill["fill-z-offset"]),"fill-bridge-guard-rail-color":new zo(Eo.paint_fill["fill-bridge-guard-rail-color"]),"fill-tunnel-structure-color":new zo(Eo.paint_fill["fill-tunnel-structure-color"]),"fill-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"}),"fill-outline-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"}),"fill-bridge-guard-rail-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"}),"fill-tunnel-structure-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n);}getProgramIds(){const t=this.paint.get("fill-pattern"),e=t&&t.constantOr(1),r=[e?"fillPattern":"fill"];return this.paint.get("fill-antialias")&&r.push(e&&!this.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline"),r}getDefaultProgramParams(t,e,r){return {config:new zl(this,{zoom:e,lut:r}),overrideFog:!1}}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(t){return new fp(t)}queryRadius(){return dc(this.paint.get("fill-translate"))}queryIntersectsFeature(t,e,r,n,i,s){return !t.queryGeometry.isAboveHorizon&&Qu(mc(t.tilespaceGeometry,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),n)}isTileClipped(){return 0===this.paint.get("fill-z-offset").constantOr(1)}is3D(t){if(0!==this.paint.get("fill-z-offset").constantOr(1))return !0;const e=this.layout&&"none"!==this.layout.get("fill-elevation-reference");return null!=t?e&&!t:e}hasElevation(){return this.layout&&"none"!==this.layout.get("fill-elevation-reference")}hasShadowPass(){return this.layout&&"none"!==this.layout.get("fill-elevation-reference")}},"fill-extrusion":class extends Yo{constructor(t,e,r,n){super(t,{layout:xf||(xf=new Po({visibility:new So(Eo["layout_fill-extrusion"].visibility),"fill-extrusion-edge-radius":new So(Eo["layout_fill-extrusion"]["fill-extrusion-edge-radius"])})),paint:vf||(vf=new Po({"fill-extrusion-opacity":new So(Eo["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new zo(Eo["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new So(Eo["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new So(Eo["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new zo(Eo["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-pattern-cross-fade":new So(Eo["paint_fill-extrusion"]["fill-extrusion-pattern-cross-fade"]),"fill-extrusion-height":new zo(Eo["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new zo(Eo["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-height-alignment":new So(Eo["paint_fill-extrusion"]["fill-extrusion-height-alignment"]),"fill-extrusion-base-alignment":new So(Eo["paint_fill-extrusion"]["fill-extrusion-base-alignment"]),"fill-extrusion-vertical-gradient":new So(Eo["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"]),"fill-extrusion-ambient-occlusion-intensity":new So(Eo["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-intensity"]),"fill-extrusion-ambient-occlusion-radius":new So(Eo["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-radius"]),"fill-extrusion-ambient-occlusion-wall-radius":new So(Eo["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-wall-radius"]),"fill-extrusion-ambient-occlusion-ground-radius":new So(Eo["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-ground-radius"]),"fill-extrusion-ambient-occlusion-ground-attenuation":new So(Eo["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-ground-attenuation"]),"fill-extrusion-flood-light-color":new So(Eo["paint_fill-extrusion"]["fill-extrusion-flood-light-color"]),"fill-extrusion-flood-light-intensity":new So(Eo["paint_fill-extrusion"]["fill-extrusion-flood-light-intensity"]),"fill-extrusion-flood-light-wall-radius":new zo(Eo["paint_fill-extrusion"]["fill-extrusion-flood-light-wall-radius"]),"fill-extrusion-flood-light-ground-radius":new zo(Eo["paint_fill-extrusion"]["fill-extrusion-flood-light-ground-radius"]),"fill-extrusion-flood-light-ground-attenuation":new So(Eo["paint_fill-extrusion"]["fill-extrusion-flood-light-ground-attenuation"]),"fill-extrusion-vertical-scale":new So(Eo["paint_fill-extrusion"]["fill-extrusion-vertical-scale"]),"fill-extrusion-rounded-roof":new So(Eo["paint_fill-extrusion"]["fill-extrusion-rounded-roof"]),"fill-extrusion-cutoff-fade-range":new So(Eo["paint_fill-extrusion"]["fill-extrusion-cutoff-fade-range"]),"fill-extrusion-emissive-strength":new zo(Eo["paint_fill-extrusion"]["fill-extrusion-emissive-strength"]),"fill-extrusion-line-width":new zo(Eo["paint_fill-extrusion"]["fill-extrusion-line-width"]),"fill-extrusion-cast-shadows":new So(Eo["paint_fill-extrusion"]["fill-extrusion-cast-shadows"]),"fill-extrusion-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"}),"fill-extrusion-flood-light-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._stats={numRenderedVerticesInShadowPass:0,numRenderedVerticesInTransparentPass:0};}createBucket(t){return new af(t)}queryRadius(){return dc(this.paint.get("fill-extrusion-translate"))}is3D(t){return !0}hasShadowPass(){return this.paint.get("fill-extrusion-cast-shadows")}cutoffRange(){return this.paint.get("fill-extrusion-cutoff-fade-range")}canCastShadows(){return !0}getProgramIds(){return [this.paint.get("fill-extrusion-pattern").constantOr(1)?"fillExtrusionPattern":"fillExtrusion"]}queryIntersectsFeature(t,e,r,n,i,s,o,a,l){const u=yc(this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),c=this.paint.get("fill-extrusion-height").evaluate(e,r),h=this.paint.get("fill-extrusion-base").evaluate(e,r),p=[0,0],f=a&&s.elevation,d=s.elevation?s.elevation.exaggeration():1,m=t.tile.getBucket(this);if(f&&m instanceof af){const t=m.centroidVertexArray,e=l+1;e<t.length&&(p[0]=t.geta_centroid_pos0(e),p[1]=t.geta_centroid_pos1(e));}if(0===p[0]&&1===p[1])return !1;"globe"===s.projection.name&&(n=yf([n],[new bt(0,0),new bt(Cn,Cn)],t.tileID.canonical).map((t=>t.polygon)).flat());const y=f?a:null,[g,x]=function(t,e,r,n,i,s,o,a,l,u,c){return "globe"===t.projection.name?function(t,e,r,n,i,s,o,a,l,u,c){const h=[],p=[],f=t.projection.upVectorScale(c,t.center.lat,t.worldSize).metersToTile,d=[0,0,0,1],m=[0,0,0,1],y=(t,e,r,n)=>{t[0]=e,t[1]=r,t[2]=n,t[3]=1;},g=mf();r>0&&(r+=g),n+=g;for(const g of e){const e=[],x=[];for(const h of g){const p=h.x+i.x,g=h.y+i.y,v=t.projection.projectTilePoint(p,g,c),b=t.projection.upVector(c,h.x,h.y);let w=r,_=n;if(o){const t=Pf(p,g,r,n,o,a,l,u);w+=t.base,_+=t.top;}0!==r?y(d,v.x+b[0]*f*w,v.y+b[1]*f*w,v.z+b[2]*f*w):y(d,v.x,v.y,v.z),y(m,v.x+b[0]*f*_,v.y+b[1]*f*_,v.z+b[2]*f*_),R(d,d,s),R(m,m,s),e.push(new bf(d[0],d[1],d[2])),x.push(new bf(m[0],m[1],m[2]));}h.push(e),p.push(x);}return [h,p]}(t,e,r,n,i,s,o,a,l,u,c):o?function(t,e,r,n,i,s,o,a,l){const u=[],c=[],h=[0,0,0,1];for(const p of t){const t=[],f=[];for(const u of p){const c=u.x+n.x,p=u.y+n.y,d=Pf(c,p,e,r,s,o,a,l);h[0]=c,h[1]=p,h[2]=d.base,h[3]=1,Z(h,h,i),h[3]=Math.max(h[3],1e-5);const m=new bf(h[0]/h[3],h[1]/h[3],h[2]/h[3]);h[0]=c,h[1]=p,h[2]=d.top,h[3]=1,Z(h,h,i),h[3]=Math.max(h[3],1e-5);const y=new bf(h[0]/h[3],h[1]/h[3],h[2]/h[3]);t.push(m),f.push(y);}u.push(t),c.push(f);}return [u,c]}(e,r,n,i,s,o,a,l,u):function(t,e,r,n,i){const s=[],o=[],a=i[8]*e,l=i[9]*e,u=i[10]*e,c=i[11]*e,h=i[8]*r,p=i[9]*r,f=i[10]*r,d=i[11]*r;for(const e of t){const t=[],r=[];for(const s of e){const e=s.x+n.x,o=s.y+n.y,m=i[0]*e+i[4]*o+i[12],y=i[1]*e+i[5]*o+i[13],g=i[2]*e+i[6]*o+i[14],x=i[3]*e+i[7]*o+i[15],v=m+a,b=y+l,w=g+u,_=Math.max(x+c,1e-5),A=m+h,M=y+p,I=g+f,S=Math.max(x+d,1e-5);t.push(new bf(v/_,b/_,w/_)),r.push(new bf(A/S,M/S,I/S));}s.push(t),o.push(r);}return [s,o]}(e,r,n,i,s)}(s,n,h,c,u,o,y,p,d,s.center.lat,t.tileID.canonical),v=t.queryGeometry;return function(t,e,r){let n=1/0;Qu(r,e)&&(n=kf(r,e[0]));for(let i=0;i<e.length;i++){const s=e[i],o=t[i];for(let t=0;t<s.length-1;t++){const e=s[t],i=[e,s[t+1],o[t+1],o[t],e];Ku(r,i)&&(n=Math.min(n,kf(r,i)));}}return n!==1/0&&n}(g,x,v.isPointQuery()?v.screenBounds:v.screenGeometry)}},building:class extends Yo{constructor(t,e,r,n){super(t,{layout:dd||(dd=new Po({visibility:new So(Eo.layout_building.visibility),"building-roof-shape":new zo(Eo.layout_building["building-roof-shape"]),"building-height":new zo(Eo.layout_building["building-height"]),"building-base":new zo(Eo.layout_building["building-base"])})),paint:md||(md=new Po({"building-opacity":new So(Eo.paint_building["building-opacity"]),"building-ambient-occlusion-wall-intensity":new So(Eo.paint_building["building-ambient-occlusion-wall-intensity"]),"building-ambient-occlusion-ground-intensity":new So(Eo.paint_building["building-ambient-occlusion-ground-intensity"]),"building-ambient-occlusion-ground-radius":new So(Eo.paint_building["building-ambient-occlusion-ground-radius"]),"building-ambient-occlusion-ground-attenuation":new So(Eo.paint_building["building-ambient-occlusion-ground-attenuation"]),"building-vertical-scale":new So(Eo.paint_building["building-vertical-scale"]),"building-cast-shadows":new So(Eo.paint_building["building-cast-shadows"]),"building-color":new zo(Eo.paint_building["building-color"]),"building-emissive-strength":new zo(Eo.paint_building["building-emissive-strength"]),"building-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._stats={numRenderedVerticesInShadowPass:0,numRenderedVerticesInTransparentPass:0};}createBucket(t){return new fd(t)}},line:class extends Yo{constructor(t,e,r,n){const i=Rd();super(t,i,e,r,n),i.layout&&(this.layout=new Io(i.layout)),this.gradientVersion=0,this.hasElevatedBuckets=!1,this.hasNonElevatedBuckets=!1;}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this._transitionablePaint._values["line-gradient"].value.expression;this.stepInterpolant=t._styleExpression&&t._styleExpression.expression instanceof Ai,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER;}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}widthExpression(){return this._transitionablePaint._values["line-width"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=(()=>{if(Ud)return Ud;const t=Rd();return Ud=new Od(t.paint.properties["line-width"].specification),Ud.useIntegerZoom=!0,Ud})().possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t);}createBucket(t){return new zd(t)}getProgramIds(){return [this.paint.get("line-pattern").constantOr(1)?"linePattern":"line"]}getDefaultProgramParams(t,e,r){const n=Fd(this);return {config:new zl(this,{zoom:e,lut:r}),defines:n,overrideFog:!1}}queryRadius(t){const e=t,r=Nd(fc("line-width",this,e),fc("line-gap-width",this,e)),n=fc("line-offset",this,e);return r/2+Math.abs(n)+dc(this.paint.get("line-translate"))}queryIntersectsFeature(t,e,r,n,i,s){if(t.queryGeometry.isAboveHorizon)return !1;const o=mc(t.tilespaceGeometry,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),a=t.pixelToTileUnitsFactor/2*Nd(this.paint.get("line-width").evaluate(e,r),this.paint.get("line-gap-width").evaluate(e,r)),l=this.paint.get("line-offset").evaluate(e,r);return l&&(n=function(t,e){const r=[],n=new bt(0,0);for(let i=0;i<t.length;i++){const s=t[i],o=[];for(let t=0;t<s.length;t++){const r=s[t],i=s[t+1],a=0===t?n:r.sub(s[t-1])._unit()._perp(),l=t===s.length-1?n:i.sub(r)._unit()._perp(),u=a._add(l)._unit();u._mult(1/(u.x*l.x+u.y*l.y)),o.push(u._mult(e)._add(r));}r.push(o);}return r}(n,l*t.pixelToTileUnitsFactor)),function(t,e,r){for(let n=0;n<e.length;n++){const i=e[n];if(t.length>=3)for(let e=0;e<i.length;e++)if(lc(t,i[e]))return !0;if(tc(t,i,r))return !0}return !1}(o,n,a)}isTileClipped(){return this.hasNonElevatedBuckets}isDraped(t){return !this.hasElevatedBuckets}hasElevation(){return this.layout&&"none"!==this.layout.get("line-elevation-reference")}},symbol:wg,background:class extends Yo{constructor(t,e,r,n){super(t,{layout:_g||(_g=new Po({visibility:new So(Eo.layout_background.visibility)})),paint:Ag||(Ag=new Po({"background-pitch-alignment":new So(Eo.paint_background["background-pitch-alignment"]),"background-color":new So(Eo.paint_background["background-color"]),"background-pattern":new So(Eo.paint_background["background-pattern"]),"background-opacity":new So(Eo.paint_background["background-opacity"]),"background-emissive-strength":new So(Eo.paint_background["background-emissive-strength"]),"background-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n);}getProgramIds(){return [this.paint.get("background-pattern")?"backgroundPattern":"background"]}getDefaultProgramParams(t,e,r){return {overrideFog:!1}}is3D(t){return "viewport"===this.paint.get("background-pitch-alignment")}},raster:Dg,"raster-particle":jg,sky:class extends Yo{constructor(t,e,r,n){super(t,{layout:Og||(Og=new Po({visibility:new So(Eo.layout_sky.visibility)})),paint:Ug||(Ug=new Po({"sky-type":new So(Eo.paint_sky["sky-type"]),"sky-atmosphere-sun":new So(Eo.paint_sky["sky-atmosphere-sun"]),"sky-atmosphere-sun-intensity":new So(Eo.paint_sky["sky-atmosphere-sun-intensity"]),"sky-gradient-center":new So(Eo.paint_sky["sky-gradient-center"]),"sky-gradient-radius":new So(Eo.paint_sky["sky-gradient-radius"]),"sky-gradient":new ko(Eo.paint_sky["sky-gradient"]),"sky-atmosphere-halo-color":new So(Eo.paint_sky["sky-atmosphere-halo-color"]),"sky-atmosphere-color":new So(Eo.paint_sky["sky-atmosphere-color"]),"sky-opacity":new So(Eo.paint_sky["sky-opacity"]),"sky-gradient-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"}),"sky-atmosphere-halo-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"}),"sky-atmosphere-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"sky-gradient"===t?this._updateColorRamp():"sky-atmosphere-sun"!==t&&"sky-atmosphere-halo-color"!==t&&"sky-atmosphere-color"!==t&&"sky-atmosphere-sun-intensity"!==t||(this._skyboxInvalidated=!0);}_updateColorRamp(){this.colorRamp=xh({expression:this._transitionablePaint._values["sky-gradient"].value.expression,evaluationKey:"skyRadialProgress"}),this.colorRampTexture&&(this.colorRampTexture.destroy(),this.colorRampTexture=null);}needsSkyboxCapture(t){if(this._skyboxInvalidated||!this.skyboxTexture||!this.skyboxGeometry)return !0;if(!this.paint.get("sky-atmosphere-sun")){const e=t.style.light.properties.get("position");return this._lightPosition.azimuthal!==e.azimuthal||this._lightPosition.polar!==e.polar}return !1}getCenter(t,e){if("atmosphere"===this.paint.get("sky-type")){const r=this.paint.get("sky-atmosphere-sun"),n=!r,i=t.style.light,s=i.properties.get("position");return n&&"viewport"===i.properties.get("anchor")&&Gt("The sun direction is attached to a light with viewport anchor, lighting may behave unexpectedly."),n?Gg(s.azimuthal,90-s.polar,e):Gg(r[0],90-r[1],e)}const r=this.paint.get("sky-gradient-center");return Gg(r[0],90-r[1],e)}isSky(){return !0}markSkyboxValid(t){this._skyboxInvalidated=!1,this._lightPosition=t.style.light.properties.get("position");}hasOffscreenPass(){return !0}getProgramIds(){const t=this.paint.get("sky-type");return "atmosphere"===t?["skyboxCapture","skybox"]:"gradient"===t?["skyboxGradient"]:null}},slot:class extends Yo{constructor(t,e,r,n){super(t,{paint:Ng||(Ng=new Po({}))},e,null);}},model:class extends Yo{constructor(t,e,r,n){super(t,{layout:dx||(dx=new Po({visibility:new So(Eo.layout_model.visibility),"model-id":new zo(Eo.layout_model["model-id"])})),paint:mx||(mx=new Po({"model-opacity":new zo(Eo.paint_model["model-opacity"]),"model-rotation":new zo(Eo.paint_model["model-rotation"]),"model-scale":new zo(Eo.paint_model["model-scale"]),"model-translation":new zo(Eo.paint_model["model-translation"]),"model-color":new zo(Eo.paint_model["model-color"]),"model-color-mix-intensity":new zo(Eo.paint_model["model-color-mix-intensity"]),"model-type":new So(Eo.paint_model["model-type"]),"model-cast-shadows":new So(Eo.paint_model["model-cast-shadows"]),"model-receive-shadows":new So(Eo.paint_model["model-receive-shadows"]),"model-ambient-occlusion-intensity":new So(Eo.paint_model["model-ambient-occlusion-intensity"]),"model-emissive-strength":new zo(Eo.paint_model["model-emissive-strength"]),"model-roughness":new zo(Eo.paint_model["model-roughness"]),"model-height-based-emissive-strength-multiplier":new zo(Eo.paint_model["model-height-based-emissive-strength-multiplier"]),"model-cutoff-fade-range":new So(Eo.paint_model["model-cutoff-fade-range"]),"model-front-cutoff":new So(Eo.paint_model["model-front-cutoff"]),"model-color-use-theme":new zo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._stats={numRenderedVerticesInShadowPass:0,numRenderedVerticesInTransparentPass:0};}createBucket(t){return new fx(t)}getProgramIds(){return ["model"]}is3D(t){return !0}hasShadowPass(){return !0}canCastShadows(){return !0}hasLightBeamPass(){return !0}cutoffRange(){return this.paint.get("model-cutoff-fade-range")}queryRadius(t){return t instanceof Tx?Cn-1:0}queryIntersectsFeature(t,e,r,n,i,s){if(!this.modelManager)return !1;const o=this.modelManager,l=t.tile.getBucket(this);if(!(l&&l instanceof fx))return !1;for(const r in l.instancesPerModel){const n=l.instancesPerModel[r],i=void 0!==e.id?e.id:e.properties&&e.properties.hasOwnProperty("id")?e.properties.id:void 0;if(n.idToFeaturesIndex.hasOwnProperty(i)){const e=n.features[n.idToFeaturesIndex[i]],u=o.getModel(r,this.scope);if(!u)return !1;let h=a();const p=new Hl(0,0),f=l.canonical;let d=Number.MAX_VALUE;for(let r=0;r<e.instancedDataCount;++r){const i=16*(e.instancedDataOffset+r),o=n.instancedDataArray.float32,a=[o[i+4],o[i+5],o[i+6]];Fx(f,p,o[i],0|o[i+1]),xx(h,u,s,p,e.rotation,e.scale,a,!1,!1,!1),"globe"===s.projection.name&&(h=Qg(h,s));const l=c([],s.projMatrix,h),m=t.queryGeometry,y=tx(m.isPointQuery()?m.screenBounds:m.screenGeometry,s,l,u.aabb);null!=y&&(d=Math.min(y,d));}return d!==Number.MAX_VALUE&&d}}return !1}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven()||"model-color"!==t&&"model-color-mix-intensity"!==t&&"model-rotation"!==t&&"model-scale"!==t&&"model-translation"!==t&&"model-emissive-strength"!==t)}_isPropertyZoomDependent(t){const e=this._transitionablePaint._values[t];return null!=e&&null!=e.value&&null!=e.value.expression&&e.value.expression instanceof Ds}isZoomDependent(){return this._isPropertyZoomDependent("model-scale")||this._isPropertyZoomDependent("model-rotation")||this._isPropertyZoomDependent("model-translation")}},clip:class extends Yo{constructor(t,e,r,n){super(t,{layout:yp||(yp=new Po({"clip-layer-types":new So(Eo.layout_clip["clip-layer-types"]),"clip-layer-scope":new So(Eo.layout_clip["clip-layer-scope"])})),paint:gp||(gp=new Po({}))},e,r,n);}recalculate(t,e){super.recalculate(t,e);}createBucket(t){return new bp(t)}is3D(t){return !0}}},Rx=new sr(0,0,0),Ox={PATH_RULE_NON_ZERO:1,PATH_RULE_EVEN_ODD:2},Ux={LINE_CAP_BUTT:1,LINE_CAP_ROUND:2,LINE_CAP_SQUARE:3},Nx={LINE_JOIN_MITER:1,LINE_JOIN_MITER_CLIP:2,LINE_JOIN_ROUND:3,LINE_JOIN_BEVEL:4},jx={PAINT_ORDER_FILL_AND_STROKE:1},$x={PATH_COMMAND_MOVE:1,PATH_COMMAND_LINE:2,PATH_COMMAND_QUAD:3,PATH_COMMAND_CUBIC:4,PATH_COMMAND_CLOSE:5},Gx={MASK_TYPE_LUMINANCE:1};function qx(t,e,r){1===t&&e.icons.push(function(t,e){return function(t){if(t.usvg_tree.height||(t.usvg_tree.height=t.usvg_tree.width),!t.metadata)return t;const{metadata:e}=t;if(e.content_area){const{content_area:r}=e;null==r.top&&(r.top=r.left),null==r.width&&(r.width=t.usvg_tree.width),null==r.height&&(r.height=r.width);}return e.stretch_x&&e.stretch_x.length&&Hx(e,"x"),e.stretch_y&&e.stretch_y.length&&Hx(e,"y"),t}(t.readFields(Xx,{name:void 0},e))}(r,r.readVarint()+r.pos));}function Hx(t,e){const r=[],n=t[`stretch_${e}`];let i=null;for(let t=0;t<n.length;t++)null===i?i=0===r.length?n[0]:r[r.length-1][1]+n[t]:(r.push([i,i+n[t]]),i=null);t[`stretch_${e}_areas`]=r;}function Xx(t,e,r){1===t?e.name=r.readString():2===t?e.metadata=function(t,e){return t.readFields(Zx,{stretch_x:null,stretch_y:null,stretch_x_areas:null,stretch_y_areas:null,variables:[]},e)}(r,r.readVarint()+r.pos):3===t&&(e.usvg_tree=function(t,e){return t.readFields(Kx,{width:20,children:[],linear_gradients:[],radial_gradients:[],clip_paths:[],masks:[]},e)}(r,r.readVarint()+r.pos),e.data="usvg_tree");}function Zx(t,e,r){1===t?e.stretch_x=r.readPackedVarint():2===t?e.stretch_y=r.readPackedVarint():3===t?e.content_area=function(t,e){return t.readFields(Wx,{left:0},e)}(r,r.readVarint()+r.pos):4===t&&e.variables.push(function(t,e){return t.readFields(Yx,{name:void 0},e)}(r,r.readVarint()+r.pos));}function Wx(t,e,r){1===t?e.left=r.readVarint():2===t?e.width=r.readVarint():3===t?e.top=r.readVarint():4===t&&(e.height=r.readVarint());}function Yx(t,e,r){1===t?e.name=r.readString():2===t&&(e.rgb_color=sv(r.readVarint()),e.value="rgb_color");}function Kx(t,e,r){1===t?e.width=e.height=r.readVarint():2===t?e.height=r.readVarint():3===t?e.children.push(Jx(r,r.readVarint()+r.pos)):4===t?e.linear_gradients.push(function(t,e){return t.readFields(av,{spread_method:1,stops:[],x1:0,y1:0,x2:1,y2:0},e)}(r,r.readVarint()+r.pos)):5===t?e.radial_gradients.push(function(t,e){return t.readFields(cv,{spread_method:1,stops:[],cx:.5,cy:.5,r:.5,fx:.5,fy:.5,fr:0},e)}(r,r.readVarint()+r.pos)):7===t?e.clip_paths.push(function(t,e){return t.readFields(hv,{children:[]},e)}(r,r.readVarint()+r.pos)):8===t&&e.masks.push(function(t,e){const r=t.readFields(pv,{left:0,width:20,mask_type:Gx.MASK_TYPE_LUMINANCE,children:[]},e);return null==r.height&&(r.height=r.width),null==r.top&&(r.top=r.left),r}(r,r.readVarint()+r.pos));}function Jx(t,e){return t.readFields(Qx,{},e)}function Qx(t,e,r){1===t?(e.group=function(t,e){return t.readFields(tv,{opacity:255,children:[]},e)}(r,r.readVarint()+r.pos),e.node="group"):2===t&&(e.path=function(t,e){return t.readFields(nv,{paint_order:1,commands:[],step:1,diffs:[],rule:Ox.PATH_RULE_NON_ZERO},e)}(r,r.readVarint()+r.pos),e.node="path");}function tv(t,e,r){1===t?e.transform=ev(r,r.readVarint()+r.pos):2===t?e.opacity=r.readVarint():5===t?e.clip_path_idx=r.readVarint():6===t?e.mask_idx=r.readVarint():7===t&&e.children.push(Jx(r,r.readVarint()+r.pos));}function ev(t,e){return t.readFields(rv,{sx:1,ky:0,kx:0,sy:1,tx:0,ty:0},e)}function rv(t,e,r){1===t?e.sx=r.readFloat():2===t?e.ky=r.readFloat():3===t?e.kx=r.readFloat():4===t?e.sy=r.readFloat():5===t?e.tx=r.readFloat():6===t&&(e.ty=r.readFloat());}function nv(t,e,r){1===t?e.fill=function(t,e){return t.readFields(iv,{rgb_color:Rx,paint:"rgb_color",opacity:255},e)}(r,r.readVarint()+r.pos):2===t?e.stroke=function(t,e){return t.readFields(ov,{rgb_color:Rx,paint:"rgb_color",dasharray:[],dashoffset:0,miterlimit:4,opacity:255,width:1,linecap:1,linejoin:1},e)}(r,r.readVarint()+r.pos):3===t?e.paint_order=r.readVarint():5===t?r.readPackedVarint(e.commands):6===t?e.step=r.readFloat():7===t?r.readPackedSVarint(e.diffs):8===t&&(e.rule=r.readVarint());}function iv(t,e,r){1===t?(e.rgb_color=sv(r.readVarint()),e.paint="rgb_color"):2===t?(e.linear_gradient_idx=r.readVarint(),e.paint="linear_gradient_idx"):3===t?(e.radial_gradient_idx=r.readVarint(),e.paint="radial_gradient_idx"):5===t&&(e.opacity=r.readVarint());}function sv(t){return new sr((t>>16&255)/255,(t>>8&255)/255,(255&t)/255,1)}function ov(t,e,r){1===t?(e.rgb_color=sv(r.readVarint()),e.paint="rgb_color"):2===t?(e.linear_gradient_idx=r.readVarint(),e.paint="linear_gradient_idx"):3===t?(e.radial_gradient_idx=r.readVarint(),e.paint="radial_gradient_idx"):5===t?r.readPackedFloat(e.dasharray):6===t?e.dashoffset=r.readFloat():7===t?e.miterlimit=r.readFloat():8===t?e.opacity=r.readVarint():9===t?e.width=r.readFloat():10===t?e.linecap=r.readVarint():11===t&&(e.linejoin=r.readVarint());}function av(t,e,r){1===t?e.transform=ev(r,r.readVarint()+r.pos):2===t?e.spread_method=r.readVarint():3===t?e.stops.push(lv(r,r.readVarint()+r.pos)):4===t?e.x1=r.readFloat():5===t?e.y1=r.readFloat():6===t?e.x2=r.readFloat():7===t&&(e.y2=r.readFloat());}function lv(t,e){return t.readFields(uv,{offset:0,opacity:255,rgb_color:Rx},e)}function uv(t,e,r){1===t?e.offset=r.readFloat():2===t?e.opacity=r.readVarint():3===t&&(e.rgb_color=sv(r.readVarint()));}function cv(t,e,r){1===t?e.transform=ev(r,r.readVarint()+r.pos):2===t?e.spread_method=r.readVarint():3===t?e.stops.push(lv(r,r.readVarint()+r.pos)):4===t?e.cx=r.readFloat():5===t?e.cy=r.readFloat():6===t?e.r=r.readFloat():7===t?e.fx=r.readFloat():8===t?e.fy=r.readFloat():9===t&&(e.fr=r.readFloat());}function hv(t,e,r){1===t?e.transform=ev(r,r.readVarint()+r.pos):2===t?e.clip_path_idx=r.readVarint():3===t&&e.children.push(Jx(r,r.readVarint()+r.pos));}function pv(t,e,r){1===t?e.left=e.top=r.readFloat():2===t?e.width=e.height=r.readFloat():3===t?e.top=r.readFloat():4===t?e.height=r.readFloat():5===t?e.mask_type=r.readVarint():6===t?e.mask_idx=r.readVarint():7===t&&e.children.push(Jx(r,r.readVarint()+r.pos));}class fv{static calculate(t={},e=[]){const r=new Map,n=new Map;if(0===Object.keys(t).length)return r;e.forEach((t=>{n.set(t.name,t.rgb_color||new sr(0,0,0));}));for(const[e,i]of Object.entries(t))n.has(e)?r.set(n.get(e).toString(),i):console.warn(`Ignoring unknown image variable "${e}"`);return r}}function dv(t,e=255,r){const n=e/255,i=t.toString(),s=r.has(i)?r.get(i).clone():t.clone();return s.a*=n,s.toString()}function mv(t,e){if(!pe()){const r=document.createElement("canvas");return r.width=t,r.height=e,r}return new OffscreenCanvas(t,e)}function yv(t,e){const r=fv.calculate(e.params,t.metadata?t.metadata.variables:[]),n=t.usvg_tree,i=n.width,s=n.height,o=e.transform?e.transform:new DOMMatrix,a=Math.max(1,Math.round(i*o.a)),l=Math.max(1,Math.round(s*o.d)),u=new DOMMatrix([a/i,0,0,l/s,0,0]),c=mv(a,l).getContext("2d");return gv(c,u,n,n,r),c.getImageData(0,0,a,l)}function gv(t,e,r,n,i){for(const s of n.children)xv(t,e,r,s,i);}function xv(t,e,r,n,i){n.group?(t.save(),function(t,e,r,n,i){const s=null!=n.mask_idx?r.masks[n.mask_idx]:null,o=null!=n.clip_path_idx?r.clip_paths[n.clip_path_idx]:null;if(n.transform&&(e=zv(n.transform).preMultiplySelf(e)),!function(t,e,r){return 255!==t.opacity||e||r}(n,null!=o,null!=s))return void gv(t,e,r,n,i);const a=mv(t.canvas.width,t.canvas.height),l=a.getContext("2d");gv(l,e,r,n,i),o&&Iv(l,e,r,o),s&&Sv(l,e,r,s,i),t.globalAlpha=n.opacity/255,t.drawImage(a,0,0);}(t,e,r,n.group,i),t.restore()):n.path&&(t.save(),function(t,e,r,n,i){t.setTransform(e),n.paint_order===jx.PAINT_ORDER_FILL_AND_STROKE?(vv(t,r,n,i),wv(t,r,n,i)):(wv(t,r,n,i),vv(t,r,n,i));}(t,e,r,n.path,i),t.restore());}function vv(t,e,r,n){const i=r.fill;if(!i)return;const s=i.opacity/255;switch(t.save(),t.beginPath(),kv(r,t),i.paint){case "rgb_color":t.fillStyle=dv(i.rgb_color,i.opacity,n);break;case "linear_gradient_idx":{const r=e.linear_gradients[i.linear_gradient_idx];r.transform&&t.setTransform(zv(r.transform).preMultiplySelf(t.getTransform())),t.fillStyle=_v(t,r,s,n);break}case "radial_gradient_idx":{const r=e.radial_gradients[i.radial_gradient_idx];r.transform&&t.setTransform(zv(r.transform).preMultiplySelf(t.getTransform())),t.fillStyle=Av(t,r,s,n);}}t.fill(bv(r)),t.restore();}function bv(t){return t.rule===Ox.PATH_RULE_NON_ZERO?"nonzero":t.rule===Ox.PATH_RULE_EVEN_ODD?"evenodd":void 0}function wv(t,e,r,n){const i=r.stroke;if(!i)return;const s=Pv(r);t.lineWidth=i.width,t.miterLimit=i.miterlimit,t.setLineDash(i.dasharray),t.lineDashOffset=i.dashoffset;const o=i.opacity/255;switch(i.paint){case "rgb_color":t.strokeStyle=dv(i.rgb_color,i.opacity,n);break;case "linear_gradient_idx":t.strokeStyle=_v(t,e.linear_gradients[i.linear_gradient_idx],o,n,!0);break;case "radial_gradient_idx":t.strokeStyle=Av(t,e.radial_gradients[i.radial_gradient_idx],o,n,!0);}switch(i.linejoin){case Nx.LINE_JOIN_MITER_CLIP:case Nx.LINE_JOIN_MITER:t.lineJoin="miter";break;case Nx.LINE_JOIN_ROUND:t.lineJoin="round";break;case Nx.LINE_JOIN_BEVEL:t.lineJoin="bevel";}switch(i.linecap){case Ux.LINE_CAP_BUTT:t.lineCap="butt";break;case Ux.LINE_CAP_ROUND:t.lineCap="round";break;case Ux.LINE_CAP_SQUARE:t.lineCap="square";}t.stroke(s);}function _v(t,e,r,n,i=!1){if(1===e.stops.length){const t=e.stops[0];return dv(t.rgb_color,t.opacity*r,n)}const{x1:s,y1:o,x2:a,y2:l}=e;let u=new DOMPoint(s,o),c=new DOMPoint(a,l);if(i){const t=zv(e.transform);u=t.transformPoint(u),c=t.transformPoint(c);}const h=t.createLinearGradient(u.x,u.y,c.x,c.y);for(const t of e.stops)h.addColorStop(t.offset,dv(t.rgb_color,t.opacity*r,n));return h}function Av(t,e,r,n,i=!1){if(1===e.stops.length){const t=e.stops[0];return dv(t.rgb_color,t.opacity*r,n)}const s=zv(e.transform),{fx:o,fy:a,fr:l,cx:u,cy:c,r:h}=e;let p=new DOMPoint(o,a),f=new DOMPoint(u,c),d=l,m=h;if(i){p=s.transformPoint(p),f=s.transformPoint(f);const t=(s.a+s.d)/2;d=l*t,m=e.r*t;}const y=t.createRadialGradient(p.x,p.y,d,f.x,f.y,m);for(const t of e.stops)y.addColorStop(t.offset,dv(t.rgb_color,t.opacity*r,n));return y}function Mv(t,e,r,n){const i=n.transform?zv(n.transform).preMultiplySelf(e):e,s=mv(t.canvas.width,t.canvas.height),o=s.getContext("2d");for(const t of n.children)if(t.group)Mv(o,i,r,t.group);else if(t.path){const e=t.path,r=new Path2D;r.addPath(Pv(e),i),o.fill(r,bv(e));}const a=null!=n.clip_path_idx?r.clip_paths[n.clip_path_idx]:null;a&&Iv(o,i,r,a),t.globalCompositeOperation="source-over",t.drawImage(s,0,0);}function Iv(t,e,r,n){const i=mv(t.canvas.width,t.canvas.height);Mv(i.getContext("2d"),e,r,n),t.globalCompositeOperation="destination-in",t.drawImage(i,0,0);}function Sv(t,e,r,n,i){if(0===n.children.length)return;const s=null!=n.mask_idx?r.masks[n.mask_idx]:null;s&&Sv(t,e,r,s,i);const o=t.canvas.width,a=t.canvas.height,l=mv(o,a),u=l.getContext("2d"),c=n.width,h=n.height,p=n.left,f=n.top,d=new Path2D,m=new Path2D;m.rect(p,f,c,h),d.addPath(m,e),u.clip(d);for(const t of n.children)xv(u,e,r,t,i);const y=u.getImageData(0,0,o,a),g=y.data;if(n.mask_type===Gx.MASK_TYPE_LUMINANCE)for(let t=0;t<g.length;t+=4)g[t+3]=g[t+3]/255*(.2126*g[t]+.7152*g[t+1]+.0722*g[t+2]);u.putImageData(y,0,0),t.globalCompositeOperation="destination-in",t.drawImage(l,0,0);}function zv(t){return t?new DOMMatrix([t.sx,t.ky,t.kx,t.sy,t.tx,t.ty]):new DOMMatrix}function kv(t,e){const r=t.step;let n=t.diffs[0]*r,i=t.diffs[1]*r;e.moveTo(n,i);for(let s=0,o=2;s<t.commands.length;s++)switch(t.commands[s]){case $x.PATH_COMMAND_MOVE:n+=t.diffs[o++]*r,i+=t.diffs[o++]*r,e.moveTo(n,i);break;case $x.PATH_COMMAND_LINE:n+=t.diffs[o++]*r,i+=t.diffs[o++]*r,e.lineTo(n,i);break;case $x.PATH_COMMAND_QUAD:{const s=n+t.diffs[o++]*r,a=i+t.diffs[o++]*r;n=s+t.diffs[o++]*r,i=a+t.diffs[o++]*r,e.quadraticCurveTo(s,a,n,i);break}case $x.PATH_COMMAND_CUBIC:{const s=n+t.diffs[o++]*r,a=i+t.diffs[o++]*r,l=s+t.diffs[o++]*r,u=a+t.diffs[o++]*r;n=l+t.diffs[o++]*r,i=u+t.diffs[o++]*r,e.bezierCurveTo(s,a,l,u,n,i);break}case $x.PATH_COMMAND_CLOSE:e.closePath();}return e}function Pv(t){return kv(t,new Path2D)}class Ev{constructor(t){this.capacity=t,this.cache=new Map;}get(t){if(!this.cache.has(t))return;const e=this.cache.get(t);return this.cache.delete(t),this.cache.set(t,e),e}put(t,e){this.cache.has(t)?this.cache.delete(t):this.cache.size===this.capacity&&this.cache.delete(this.cache.keys().next().value),this.cache.set(t,e);}delete(t){this.cache.delete(t);}}qs(Ev,"LRUCache");class Tv{constructor(){this.cacheMap=new Map,this.cacheDependenciesMap=new Map;}static _getImage(t){return new yh(t,t.data)}getFromCache(t,e,r){return this.cacheMap.has(r)||this.cacheMap.set(r,new Ev(150)),this.cacheMap.get(r).get(Xo(t.toString(),e))}setInCache(t,e,r,n){this.cacheDependenciesMap.has(n)||this.cacheDependenciesMap.set(n,new Map),this.cacheMap.has(n)||this.cacheMap.set(n,new Ev(150));const i=this.cacheDependenciesMap.get(n),s=Xo(t.id.toString(),r);i.get(s)||i.set(s,new Set);const o=this.cacheMap.get(n),a=t.toString();i.get(s).add(a),o.put(Xo(t.toString(),r),e);}removeImagesFromCacheByIds(t,e,r=0){if(!this.cacheMap.has(r)||!this.cacheDependenciesMap.has(r))return;const n=this.cacheMap.get(r),i=this.cacheDependenciesMap.get(r);for(const r of t){const t=Xo(r.toString(),e);if(i.has(t)){for(const e of i.get(t))n.delete(e);i.delete(t);}}}rasterize(t,e,r,n,i=yv){const s=this.getFromCache(t,r,n);if(s)return s.clone();const o=i(e.icon,t.options),a=Tv._getImage(o);return this.setInCache(t,a,r,n),a.clone()}}class Bv{constructor(t){this.size=t,this.minimums=[],this.maximums=[],this.leaves=[];}getElevation(t,e){const r=this.toIdx(t,e);return {min:this.minimums[r],max:this.maximums[r]}}isLeaf(t,e){return this.leaves[this.toIdx(t,e)]}toIdx(t,e){return e*this.size+t}}function Vv(t,e,r,n){let i=0,s=Number.MAX_VALUE;for(let o=0;o<3;o++)if(Math.abs(n[o])<1e-15){if(r[o]<t[o]||r[o]>e[o])return null}else {const a=1/n[o];let l=(t[o]-r[o])*a,u=(e[o]-r[o])*a;if(l>u){const t=l;l=u,u=t;}if(l>i&&(i=l),u<s&&(s=u),i>s)return null}return i}function Cv(t,e,r,n,i,s,o,a,l,u,c){const h=n-t,p=i-e,f=s-r,d=o-t,m=a-e,y=l-r,g=c[1]*y-c[2]*m,x=c[2]*d-c[0]*y,v=c[0]*m-c[1]*d,b=h*g+p*x+f*v;if(Math.abs(b)<1e-15)return null;const w=1/b,_=u[0]-t,A=u[1]-e,M=u[2]-r,I=(_*g+A*x+M*v)*w;if(I<0||I>1)return null;const S=A*f-M*p,z=M*h-_*f,k=_*p-A*h,P=(c[0]*S+c[1]*z+c[2]*k)*w;return P<0||I+P>1?null:(d*S+m*z+y*k)*w}function Fv(t,e,r){return (t-e)/(r-e)}function Dv(t,e,r,n,i,s,o,a,l){const u=1<<r,c=s-n,h=o-i,p=(t+1)/u*c+n,f=(e+0)/u*h+i,d=(e+1)/u*h+i;a[0]=(t+0)/u*c+n,a[1]=f,l[0]=p,l[1]=d;}class Lv{constructor(t){if(this.maximums=[],this.minimums=[],this.leaves=[],this.childOffsets=[],this.nodeCount=0,this.dem=t,this._siblingOffset=[[0,0],[1,0],[0,1],[1,1]],!this.dem)return;const e=function(t){const e=Math.ceil(Math.log2(t.dim/8)),r=[];let n=Math.ceil(Math.pow(2,e));const i=1/n,s=(t,e,r,n,i)=>{const s=n?1:0,o=(t+1)*r-s,a=e*r,l=(e+1)*r-s;i[0]=t*r,i[1]=a,i[2]=o,i[3]=l;};let o=new Bv(n);const a=[];for(let e=0;e<n*n;e++){s(e%n,Math.floor(e/n),i,!1,a);const r=Ov(a[0],a[1],t),l=Ov(a[2],a[1],t),u=Ov(a[2],a[3],t),c=Ov(a[0],a[3],t);o.minimums.push(Math.min(r,l,u,c)),o.maximums.push(Math.max(r,l,u,c)),o.leaves.push(1);}for(r.push(o),n/=2;n>=1;n/=2){const t=r[r.length-1];o=new Bv(n);for(let e=0;e<n*n;e++){s(e%n,Math.floor(e/n),2,!0,a);const r=t.getElevation(a[0],a[1]),i=t.getElevation(a[2],a[1]),l=t.getElevation(a[2],a[3]),u=t.getElevation(a[0],a[3]),c=t.isLeaf(a[0],a[1]),h=t.isLeaf(a[2],a[1]),p=t.isLeaf(a[2],a[3]),f=t.isLeaf(a[0],a[3]),d=Math.min(r.min,i.min,l.min,u.min),m=Math.max(r.max,i.max,l.max,u.max),y=c&&h&&p&&f;o.maximums.push(m),o.minimums.push(d),o.leaves.push(m-d<=5&&y?1:0);}r.push(o);}return r}(this.dem),r=e.length-1,n=e[r];this._addNode(n.minimums[0],n.maximums[0],n.leaves[0]),this._construct(e,0,0,r,0);}raycastRoot(t,e,r,n,i,s,o=1){return Vv([t,e,-100],[r,n,this.maximums[0]*o],i,s)}raycast(t,e,r,n,i,s,o=1){if(!this.nodeCount)return null;const a=this.raycastRoot(t,e,r,n,i,s,o);if(null==a)return null;const l=[],u=[],c=[],h=[],p=[{idx:0,t:a,nodex:0,nodey:0,depth:0}];for(;p.length>0;){const{idx:a,t:f,nodex:d,nodey:m,depth:y}=p.pop();if(this.leaves[a]){Dv(d,m,y,t,e,r,n,c,h);const a=1<<y,l=(d+0)/a,u=(d+1)/a,p=(m+0)/a,g=(m+1)/a,x=Ov(l,p,this.dem)*o,v=Ov(u,p,this.dem)*o,b=Ov(u,g,this.dem)*o,w=Ov(l,g,this.dem)*o,_=Cv(c[0],c[1],x,h[0],c[1],v,h[0],h[1],b,i,s),A=Cv(h[0],h[1],b,c[0],h[1],w,c[0],c[1],x,i,s),M=Math.min(null!==_?_:Number.MAX_VALUE,null!==A?A:Number.MAX_VALUE);if(M!==Number.MAX_VALUE)return M;{const t=E([],i,s,f);if(Rv(x,v,w,b,Fv(t[0],c[0],h[0]),Fv(t[1],c[1],h[1]))>=t[2])return f}continue}let g=0;for(let p=0;p<this._siblingOffset.length;p++){Dv((d<<1)+this._siblingOffset[p][0],(m<<1)+this._siblingOffset[p][1],y+1,t,e,r,n,c,h),c[2]=-100,h[2]=this.maximums[this.childOffsets[a]+p]*o;const f=Vv(c,h,i,s);if(null!=f){const t=f;l[p]=t;let e=!1;for(let r=0;r<g&&!e;r++)t>=l[u[r]]&&(u.splice(r,0,p),e=!0);e||(u[g]=p),g++;}}for(let t=0;t<g;t++){const e=u[t];p.push({idx:this.childOffsets[a]+e,t:l[e],nodex:(d<<1)+this._siblingOffset[e][0],nodey:(m<<1)+this._siblingOffset[e][1],depth:y+1});}}return null}_addNode(t,e,r){return this.minimums.push(t),this.maximums.push(e),this.leaves.push(r),this.childOffsets.push(0),this.nodeCount++}_construct(t,e,r,n,i){if(1===t[n].isLeaf(e,r))return;this.childOffsets[i]||(this.childOffsets[i]=this.nodeCount);const s=n-1,o=t[s];let a=0,l=0;for(let t=0;t<this._siblingOffset.length;t++){const n=2*e+this._siblingOffset[t][0],i=2*r+this._siblingOffset[t][1],s=o.getElevation(n,i),u=o.isLeaf(n,i),c=this._addNode(s.min,s.max,u);u&&(a|=1<<t),l||(l=c);}for(let n=0;n<this._siblingOffset.length;n++)a&1<<n||this._construct(t,2*e+this._siblingOffset[n][0],2*r+this._siblingOffset[n][1],s,l+n);}}function Rv(t,e,r,n,i,s){return ur(ur(t,r,s),ur(e,n,s),i)}function Ov(t,e,r){const n=r.dim,i=Et(t*n-.5,0,n-1),s=Et(e*n-.5,0,n-1),o=Math.floor(i),a=Math.floor(s),l=Math.min(o+1,n-1),u=Math.min(a+1,n-1);return Rv(r.get(o,a),r.get(l,a),r.get(o,u),r.get(l,u),i-o,s-a)}const Uv={mapbox:[6553.6,25.6,.1,1e4],terrarium:[256,1,1/256,32768]};function Nv(t,e,r){return (256*t*256+256*e+r)/10-1e4}function jv(t,e,r){return 256*t+e+r/256-32768}class $v{get tree(){return this._tree||this._buildQuadTree(),this._tree}constructor(t,e,r,n=!1){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&"mapbox"!==r&&"terrarium"!==r)return void Gt(`"${r}" is not a valid encoding type. Valid types include "mapbox" and "terrarium".`);this.stride=e.height;const i=this.dim=e.height-2,s=new Uint32Array(e.data.buffer);if(this.pixels=new Uint8Array(e.data.buffer),this.floatView=new Float32Array(e.data.buffer),this.borderReady=n,this._modifiedForSources={},!n){for(let t=0;t<i;t++)s[this._idx(-1,t)]=s[this._idx(0,t)],s[this._idx(i,t)]=s[this._idx(i-1,t)],s[this._idx(t,-1)]=s[this._idx(t,0)],s[this._idx(t,i)]=s[this._idx(t,i-1)];s[this._idx(-1,-1)]=s[this._idx(0,0)],s[this._idx(i,-1)]=s[this._idx(i-1,0)],s[this._idx(-1,i)]=s[this._idx(0,i-1)],s[this._idx(i,i)]=s[this._idx(i-1,i-1)];}const o="terrarium"===r?jv:Nv;for(let t=0;t<s.length;++t){const e=4*t;this.floatView[t]=o(this.pixels[e],this.pixels[e+1],this.pixels[e+2]);}this._timestamp=fe.now();}_buildQuadTree(){this._tree=new Lv(this);}get(t,e,r=!1){r&&(t=Et(t,-1,this.dim),e=Et(e,-1,this.dim));const n=this._idx(t,e);return this.floatView[n]}set(t,e,r){const n=this._idx(t,e),i=this.floatView[n];return this.floatView[n]=r,r-i}static getUnpackVector(t){return Uv[t]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return (e+1)*this.stride+(t+1)}static pack(t,e){const r=[0,0,0,0],n=$v.getUnpackVector(e);let i=Math.floor((t+n[3])/n[2]);return r[2]=i%256,i=Math.floor(i/256),r[1]=i%256,i=Math.floor(i/256),r[0]=i,r}getPixels(){return new gh({width:this.stride,height:this.stride},this.pixels)}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,i=e*this.dim+this.dim,s=r*this.dim,o=r*this.dim+this.dim;switch(e){case -1:n=i-1;break;case 1:i=n+1;}switch(r){case -1:s=o-1;break;case 1:o=s+1;}const a=-e*this.dim,l=-r*this.dim;for(let e=s;e<o;e++)for(let r=n;r<i;r++){const n=4*this._idx(r,e),i=4*this._idx(r+a,e+l);this.pixels[n+0]=t.pixels[i+0],this.pixels[n+1]=t.pixels[i+1],this.pixels[n+2]=t.pixels[i+2],this.pixels[n+3]=t.pixels[i+3];}}onDeserialize(){this._tree&&(this._tree.dem=this);}}function Gv(t,e,r){1===t?e.headerLength=r.readFixed32():2===t?e.x=r.readVarint():3===t?e.y=r.readVarint():4===t?e.z=r.readVarint():5===t&&e.layers.push(function(t,e){return t.readFields(Wv,{version:0,name:"",units:"",tileSize:0,buffer:0,pixelFormat:0,dataIndex:[]},e)}(r,r.readVarint()+r.pos));}function qv(t,e,r){1===t?(e.delta_filter=function(t,e){return t.readFields(Hv,{blockSize:0},e)}(r,r.readVarint()+r.pos),e.filter="delta_filter"):2===t?(r.readVarint(),e.filter="zigzag_filter"):3===t?(r.readVarint(),e.filter="bitshuffle_filter"):4===t&&(r.readVarint(),e.filter="byteshuffle_filter");}function Hv(t,e,r){1===t&&(e.blockSize=r.readVarint());}function Xv(t,e,r){1===t?(r.readVarint(),e.codec="gzip_data"):2===t?(r.readVarint(),e.codec="jpeg_image"):3===t?(r.readVarint(),e.codec="webp_image"):4===t&&(r.readVarint(),e.codec="png_image");}function Zv(t,e,r){let n=0,i=0;1===t?e.firstByte=r.readFixed64():2===t?e.lastByte=r.readFixed64():3===t?e.filters.push(function(t,e){return t.readFields(qv,{},e)}(r,r.readVarint()+r.pos)):4===t?e.codec=function(t,e){return t.readFields(Xv,{},e)}(r,r.readVarint()+r.pos):5===t?i=r.readFloat():6===t?n=r.readFloat():7===t?e.bands.push(r.readString()):8===t?e.offset=r.readDouble():9===t&&(e.scale=r.readDouble()),0===e.offset&&(e.offset=i),0===e.scale&&(e.scale=n);}function Wv(t,e,r){1===t?e.version=r.readVarint():2===t?e.name=r.readString():3===t?e.units=r.readString():4===t?e.tileSize=r.readVarint():5===t?e.buffer=r.readVarint():6===t?e.pixelFormat=r.readVarint():7===t&&e.dataIndex.push(function(t,e){return t.readFields(Zv,{firstByte:0,lastByte:0,filters:[],codec:null,offset:0,scale:0,bands:[]},e)}(r,r.readVarint()+r.pos));}function Yv(t,e,r){if(2===t)!function(t,e,r){t.readFields(Kv,r,e);}(r,r.readVarint()+r.pos,e);else if(3===t)throw new Error("Not implemented")}function Kv(t,e,r){if(1===t){let t=0;const n=r.readVarint()+r.pos;for(;r.pos<n;)e[t++]=r.readVarint();}}function Jv(t,e){if(4!==e.length)throw new Error(`Expected data of dimension 4 but got ${e.length}.`);let r=e[3];for(let n=2;n>=1;n--){const i=1===n?1:0,s=2===n?1:0;for(let n=0;n<e[0];n++){const o=e[1]*n;for(let n=i;n<e[1];n++){const i=e[2]*(n+o);for(let n=s;n<e[2];n++){const s=e[3]*(n+i);for(let n=0;n<e[3];n++){const e=s+n;t[e]+=t[e-r];}}}}r*=e[n];}return t}function Qv(t){for(let e=0,r=t.length;e<r;e++)t[e]=t[e]>>>1^-(1&t[e]);return t}function tb(t,e){switch(e){case "uint32":return t;case "uint16":for(let e=0;e<t.length;e+=2){const r=t[e],n=t[e+1];t[e]=(240&r)>>4|(61440&r)>>8|(240&n)<<4|61440&n,t[e+1]=15&r|(3840&r)>>4|(15&n)<<8|(3840&n)<<4;}return t;case "uint8":for(let e=0;e<t.length;e+=4){const r=t[e],n=t[e+1],i=t[e+2],s=t[e+3];t[e+0]=(192&r)>>6|(192&n)>>4|(192&i)>>2|192&s,t[e+1]=(48&r)>>4|(48&n)>>2|48&i|(48&s)<<2,t[e+2]=(12&r)>>2|12&n|(12&i)<<2|(12&s)<<4,t[e+3]=3&r|(3&n)<<2|(3&i)<<4|(3&s)<<6;}return t;default:throw new Error(`Invalid pixel format, "${e}"`)}}qs($v,"DEMData"),qs(Lv,"DemMinMaxQuadTree",{omit:["dem"]});var eb=Uint8Array,rb=Uint16Array,nb=Int32Array,ib=new eb([0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,0,0,0]),sb=new eb([0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,0,0]),ob=new eb([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),ab=function(t,e){for(var r=new rb(31),n=0;n<31;++n)r[n]=e+=1<<t[n-1];var i=new nb(r[30]);for(n=1;n<30;++n)for(var s=r[n];s<r[n+1];++s)i[s]=s-r[n]<<5|n;return {b:r,r:i}},lb=ab(ib,2),ub=lb.b,cb=lb.r;ub[28]=258,cb[258]=28;for(var hb=ab(sb,0).b,pb=new rb(32768),fb=0;fb<32768;++fb){var db=(43690&fb)>>1|(21845&fb)<<1;pb[fb]=((65280&(db=(61680&(db=(52428&db)>>2|(13107&db)<<2))>>4|(3855&db)<<4))>>8|(255&db)<<8)>>1;}var mb=function(t,e,r){for(var n=t.length,i=0,s=new rb(e);i<n;++i)t[i]&&++s[t[i]-1];var o,a=new rb(e);for(i=1;i<e;++i)a[i]=a[i-1]+s[i-1]<<1;o=new rb(1<<e);var l=15-e;for(i=0;i<n;++i)if(t[i])for(var u=i<<4|t[i],c=e-t[i],h=a[t[i]-1]++<<c,p=h|(1<<c)-1;h<=p;++h)o[pb[h]>>l]=u;return o},yb=new eb(288);for(fb=0;fb<144;++fb)yb[fb]=8;for(fb=144;fb<256;++fb)yb[fb]=9;for(fb=256;fb<280;++fb)yb[fb]=7;for(fb=280;fb<288;++fb)yb[fb]=8;var gb=new eb(32);for(fb=0;fb<32;++fb)gb[fb]=5;var xb=mb(yb,9),vb=mb(gb,5),bb=function(t){for(var e=t[0],r=1;r<t.length;++r)t[r]>e&&(e=t[r]);return e},wb=function(t,e,r){var n=e/8|0;return (t[n]|t[n+1]<<8)>>(7&e)&r},_b=function(t,e){var r=e/8|0;return (t[r]|t[r+1]<<8|t[r+2]<<16)>>(7&e)},Ab=["unexpected EOF","invalid block type","invalid length/literal","invalid distance","stream finished","no stream handler",,"no callback","invalid UTF-8 data","extra field too long","date not in range 1980-2099","filename too long","stream finishing","invalid zip data"],Mb=function(t,e,r){var n=new Error(e||Ab[t]);if(n.code=t,Error.captureStackTrace&&Error.captureStackTrace(n,Mb),!r)throw n;return n},Ib=new eb(0),Sb="undefined"!=typeof TextDecoder&&new TextDecoder;try{Sb.decode(Ib,{stream:!0});}catch(t){}const zb={gzip_data:"gzip"};class kb extends Error{constructor(t){super(t),this.name="MRTError";}}const Pb={0:"uint32",1:"uint32",2:"uint16",3:"uint8"},Eb={uint32:1,uint16:2,uint8:4},Tb={uint32:Uint32Array,uint16:Uint16Array,uint8:Uint8Array};let Bb;class Vb{constructor(t=5){this.x=NaN,this.y=NaN,this.z=NaN,this.layers={},this._cacheSize=t;}getLayer(t){const e=this.layers[t];if(!e)throw new kb(`Layer '${t}' not found`);return e}getHeaderLength(t){const e=new Uint8Array(t),r=new DataView(t);if(13!==e[0])throw new kb("File is not a valid MRT.");return r.getUint32(1,!0)}parseHeader(t){const e=new Uint8Array(t),r=this.getHeaderLength(t);if(e.length<r)throw new kb(`Expected header with length >= ${r} but got buffer of length ${e.length}`);const n=function(t,e){return t.readFields(Gv,{headerLength:0,x:0,y:0,z:0,layers:[]},void 0)}(new Bb(e.subarray(0,r)));if(!isNaN(this.x)&&(this.x!==n.x||this.y!==n.y||this.z!==n.z))throw new kb(`Invalid attempt to parse header ${n.z}/${n.x}/${n.y} for tile ${this.z}/${this.x}/${this.y}`);this.x=n.x,this.y=n.y,this.z=n.z;for(const t of n.layers)this.layers[t.name]=new Cb(t,{cacheSize:this._cacheSize});return this}createDecodingTask(t){const e=[],r=this.getLayer(t.layerName);for(let n of t.blockIndices){const i=r.dataIndex[n],s=i.firstByte-t.firstByte,o=i.lastByte-t.firstByte;if(r._blocksInProgress.has(n))continue;const a={layerName:r.name,firstByte:s,lastByte:o,pixelFormat:r.pixelFormat,blockIndex:n,blockShape:[i.bands.length].concat(r.bandShape),buffer:r.buffer,codec:i.codec.codec,filters:i.filters.map((t=>t.filter))};r._blocksInProgress.add(n),e.push(a);}return new Fb(e,(()=>{e.forEach((t=>r._blocksInProgress.delete(t.blockIndex)));}),((t,n)=>{if(e.forEach((t=>r._blocksInProgress.delete(t.blockIndex))),t)throw t;n.forEach((t=>{this.getLayer(t.layerName).processDecodedData(t);}));}))}}class Cb{constructor({version:t,name:e,units:r,tileSize:n,pixelFormat:i,buffer:s,dataIndex:o},a){if(this.version=t,1!==this.version)throw new kb(`Cannot parse raster layer encoded with MRT version ${t}`);this.name=e,this.units=r,this.tileSize=n,this.buffer=s,this.pixelFormat=Pb[i],this.dataIndex=o,this.bandShape=[n+2*s,n+2*s,Eb[this.pixelFormat]],this._decodedBlocks=new Ev(a?a.cacheSize:5),this._blocksInProgress=new Set;}get dimension(){return Eb[this.pixelFormat]}get cacheSize(){return this._decodedBlocks.capacity}getBandList(){return this.dataIndex.map((({bands:t})=>t)).flat()}processDecodedData(t){const e=t.blockIndex.toString();this._decodedBlocks.get(e)||this._decodedBlocks.put(e,t.data);}getBlockForBand(t){let e=0;switch(typeof t){case "string":for(const[r,n]of this.dataIndex.entries()){for(const[i,s]of n.bands.entries())if(s===t)return {bandIndex:e+i,blockIndex:r,blockBandIndex:i};e+=n.bands.length;}break;case "number":for(const[r,n]of this.dataIndex.entries()){if(t>=e&&t<e+n.bands.length)return {bandIndex:t,blockIndex:r,blockBandIndex:t-e};e+=n.bands.length;}break;default:throw new kb(`Invalid band \`${JSON.stringify(t)}\`. Expected string or integer.`)}return {blockIndex:-1,blockBandIndex:-1}}getDataRange(t){let e=1/0,r=-1/0;const n=[],i=new Set;for(const s of t){const{blockIndex:t}=this.getBlockForBand(s);if(t<0)throw new kb(`Invalid band: ${JSON.stringify(s)}`);const o=this.dataIndex[t];n.includes(t)||n.push(t),i.add(t),e=Math.min(e,o.firstByte),r=Math.max(r,o.lastByte);}if(i.size>this.cacheSize)throw new kb(`Number of blocks to decode (${i.size}) exceeds cache size (${this.cacheSize}).`);return {layerName:this.name,firstByte:e,lastByte:r,blockIndices:n}}hasBand(t){const{blockIndex:e}=this.getBlockForBand(t);return e>=0}hasDataForBand(t){const{blockIndex:e}=this.getBlockForBand(t);return e>=0&&!!this._decodedBlocks.get(e.toString())}getBandView(t){const{blockIndex:e,blockBandIndex:r}=this.getBlockForBand(t);if(e<0)throw new kb(`Band not found: ${JSON.stringify(t)}`);const n=this._decodedBlocks.get(e.toString());if(!n)throw new kb(`Data for band ${JSON.stringify(t)} of layer "${this.name}" not decoded.`);const i=this.dataIndex[e],s=this.bandShape.reduce(((t,e)=>t*e),1),o=r*s,a=n.subarray(o,o+s);return {data:a,bytes:new Uint8Array(a.buffer).subarray(a.byteOffset,a.byteOffset+a.byteLength),tileSize:this.tileSize,buffer:this.buffer,pixelFormat:this.pixelFormat,dimension:this.dimension,offset:i.offset,scale:i.scale}}}Vb.setPbf=function(t){Bb=t;};class Fb{constructor(t,e,r){this.tasks=t,this._onCancel=e,this._onComplete=r,this._finalized=!1;}cancel(){this._finalized||(this._onCancel(),this._finalized=!0);}complete(t,e){this._finalized||(this._onComplete(t,e),this._finalized=!0);}}function Db(t,e){const r=t.json.bufferViews[e.bufferView],n=Jf[e.componentType];return new n(t.buffers[r.buffer],(e.byteOffset||0)+(r.byteOffset||0),e.count*(r.byteStride&&r.byteStride!==td[e.type]*n.BYTES_PER_ELEMENT?r.byteStride/n.BYTES_PER_ELEMENT:td[e.type]))}function Lb(t,e,r,n){const i=Jf[e.componentType],s=function(t){switch(t){case Int8Array:return 1/127;case Uint8Array:return 1/255;case Int16Array:return 1/32767;case Uint16Array:return 1/65535;default:return 1}}(i),o=t.json.bufferViews[e.bufferView],a=o.byteStride?o.byteStride/i.BYTES_PER_ELEMENT:td[e.type],l=r.float32,u=l.length/r.capacity;for(let t=0,r=0;t<e.count*a;t+=a,r+=u)for(let e=0;e<u;e++)l[r+e]=n[t+e]*s;r._trim();}function Rb(t,e,r){const n=t.indices,i=t.attributes,s={};s.indexArray=new Aa;const o=e.json.accessors[n],a=o.count/3;s.indexArray.reserve(a);const l=Db(e,o);for(let t=0;t<a;t++)s.indexArray.emplaceBack(l[3*t],l[3*t+1],l[3*t+2]);s.indexArray._trim(),s.vertexArray=new ca;const u=e.json.accessors[i.POSITION];s.vertexArray.reserve(u.count);const c=Db(e,u);for(let t=0;t<u.count;t++)s.vertexArray.emplaceBack(c[3*t],c[3*t+1],c[3*t+2]);if(s.vertexArray._trim(),s.aabb=new qu(u.min,u.max),s.centroid=function(t,e){const r=[0,0,0],n=t.length;if(n>0){for(let i=0;i<n;i++){const n=3*t[i];r[0]+=e[n],r[1]+=e[n+1],r[2]+=e[n+2];}r[0]/=n,r[1]/=n,r[2]/=n;}return r}(l,c),void 0!==i.COLOR_0){const t=e.json.accessors[i.COLOR_0],r=td[t.type],n=Db(e,t);s.colorArray=3===r?new ca:new ya,s.colorArray.resize(t.count),Lb(e,t,s.colorArray,n);}if(void 0!==i.NORMAL){s.normalArray=new ca;const t=e.json.accessors[i.NORMAL];s.normalArray.resize(t.count);const r=Db(e,t);Lb(e,t,s.normalArray,r);}if(void 0!==i.TEXCOORD_0&&r.length>0){s.texcoordArray=new Ta;const t=e.json.accessors[i.TEXCOORD_0];s.texcoordArray.resize(t.count);const r=Db(e,t);Lb(e,t,s.texcoordArray,r);}if(void 0!==i._FEATURE_ID_RGBA4444){const t=e.json.accessors[i._FEATURE_ID_RGBA4444];e.json.extensionsUsed&&e.json.extensionsUsed.includes("EXT_meshopt_compression")&&(s.featureData=Db(e,t));}void 0!==i._FEATURE_RGBA4444&&(s.featureData=new Uint32Array(Db(e,e.json.accessors[i._FEATURE_RGBA4444]).buffer));const h=t.material;return s.material=function(t,e){const{emissiveFactor:r=[0,0,0],alphaMode:n="OPAQUE",alphaCutoff:i=.5,normalTexture:s,occlusionTexture:o,emissiveTexture:a,doubleSided:l}=t,{baseColorFactor:u=[1,1,1,1],metallicFactor:c=1,roughnessFactor:h=1,baseColorTexture:p,metallicRoughnessTexture:f}=t.pbrMetallicRoughness||{},d=o?e[o.index]:void 0;if(o&&o.extensions&&o.extensions.KHR_texture_transform&&d){const t=o.extensions.KHR_texture_transform;d.offsetScale=[t.offset[0],t.offset[1],t.scale[0],t.scale[1]];}return {pbrMetallicRoughness:{baseColorFactor:new sr(...u),metallicFactor:c,roughnessFactor:h,baseColorTexture:p?e[p.index]:void 0,metallicRoughnessTexture:f?e[f.index]:void 0},doubleSided:l,emissiveFactor:new sr(...r),alphaMode:n,alphaCutoff:i,normalTexture:s?e[s.index]:void 0,occlusionTexture:d,emissionTexture:a?e[a.index]:void 0,defined:void 0===t.defined}}(void 0!==h?e.json.materials[h]:{defined:!1},r),s}function Ob(t,e,r){const{matrix:n,rotation:i,translation:s,scale:o,mesh:a,extras:l,children:u}=t,c={};if(c.matrix=n||function(t,e,r,n){var i=e[0],s=e[1],o=e[2],a=e[3],l=i+i,u=s+s,c=o+o,h=i*l,p=i*u,f=i*c,d=s*u,m=s*c,y=o*c,g=a*l,x=a*u,v=a*c,b=n[0],w=n[1],_=n[2];return t[0]=(1-(d+y))*b,t[1]=(p+v)*b,t[2]=(f-x)*b,t[3]=0,t[4]=(p-v)*w,t[5]=(1-(h+y))*w,t[6]=(m+g)*w,t[7]=0,t[8]=(f+x)*_,t[9]=(m-g)*_,t[10]=(1-(h+d))*_,t[11]=0,t[12]=r[0],t[13]=r[1],t[14]=r[2],t[15]=1,t}([],i||[0,0,0,1],s||[0,0,0],o||[1,1,1]),void 0!==a){c.meshes=r[a];const t=c.anchor=[0,0];for(const e of c.meshes){const{min:r,max:n}=e.aabb;t[0]+=r[0]+n[0],t[1]+=r[1]+n[1];}t[0]=Math.floor(t[0]/c.meshes.length/2),t[1]=Math.floor(t[1]/c.meshes.length/2);}if(l&&(l.id&&(c.id=l.id),l.lights&&(c.lights=function(t){if(!t.length)return [];const e=function(t){const e=atob(t),r=new Uint8Array(e.length);for(let t=0;t<e.length;t++)r[t]=e.codePointAt(t);return r}(t),r=[],n=e.length/24,i=new Uint16Array(e.buffer),s=new Float32Array(e.buffer);for(let t=0;t<n;t++){const e=i[2*t*6]/30,n=i[2*t*6+1]/30,o=i[2*t*6+10]/100,a=s[6*t+1],l=s[6*t+2],u=s[6*t+3],c=s[6*t+4],h=u-a,p=c-l,f=Math.hypot(h,p);r.push({pos:[a+.5*h,l+.5*p,n],normal:[p/f,-h/f,0],width:f,height:e,depth:o,points:[a,l,u,c]});}return r}(l.lights))),u){const t=[];for(const n of u)t.push(Ob(e.json.nodes[n],e,r));c.children=t;}return c}function Ub(t){if(0===t.vertices.length||0===t.indices.length)return null;const e=new xp(t.vertices,t.indices,8,256),[r,n]=[e.min.clone(),e.max.clone()];return {vertices:t.vertices,indices:t.indices,grid:e,min:r,max:n}}function Nb(t){if(!t.extras||!t.extras.ground)return null;const e=t.extras.ground;if(!e||!Array.isArray(e)||0===e.length)return null;const r=e[0];if(!r||!Array.isArray(r)||0===r.length)return null;const n=[];for(const t of r){if(!Array.isArray(t)||2!==t.length)continue;const e=t[0],r=t[1];"number"==typeof e&&"number"==typeof r&&n.push(new bt(e,r));}if(n.length<3)return null;n.length>1&&n[n.length-1].equals(n[0])&&n.pop();let i=0;for(let t=0;t<n.length;t++){const e=n[t],r=n[(t+1)%n.length],s=n[(t+2)%n.length];i+=(e.x-r.x)*(s.y-r.y)-(s.x-r.x)*(e.y-r.y);}i>0&&n.reverse();const s=Ah(n.flatMap((t=>[t.x,t.y])),[]);return 0===s.length?null:{vertices:n,indices:s}}function jb(t,e){const r=[],n=[];let i=0;const s=[];for(const o of t){i=r.length;const t=o.vertexArray.float32,a=o.indexArray.uint16;for(let n=0;n<o.vertexArray.length;n++)s[0]=t[3*n+0],s[1]=t[3*n+1],s[2]=t[3*n+2],R(s,s,e),r.push(new bt(s[0],s[1]));for(let t=0;t<3*o.indexArray.length;t++)n.push(a[t]+i);}if(n.length%3!=0)return null;for(let t=0;t<n.length;t+=3){const e=r[n[t+0]],i=r[n[t+1]],s=r[n[t+2]];(e.x-i.x)*(s.y-i.y)-(s.x-i.x)*(e.y-i.y)>0&&([n[t+1],n[t+2]]=[n[t+2],n[t+1]]);}return {vertices:r,indices:n}}function $b(t){const e=function(t,e){const r=[],n=WebGL2RenderingContext;if(t.json.textures)for(const i of t.json.textures){const s={magFilter:n.LINEAR,minFilter:n.NEAREST,wrapS:n.REPEAT,wrapT:n.REPEAT};void 0!==i.sampler&&Object.assign(s,t.json.samplers[i.sampler]),r.push({image:e[i.source],sampler:s,uploaded:!1});}return r}(t,t.images),r=function(t,e){const r=[];for(const n of t.json.meshes){const i=[];for(const r of n.primitives)i.push(Rb(r,t,e));r.push(i);}return r}(t,e),{scenes:n,scene:i,nodes:s}=t.json,o=n?n[i||0].nodes:s,a=[];for(const e of o)a.push(Ob(s[e],t,r));return function(t,e,r){const n={},i=new Set;for(let s=0;s<t.length;s++){const t=r[e[s]];if(!t.extras)continue;const o=t.extras["mapbox:footprint:version"],a=t.extras["mapbox:footprint:id"];(o||a)&&i.add(s),"1.0.0"===o&&a&&(n[a]=s);}for(let s=0;s<t.length;s++){if(i.has(s))continue;const o=t[s],a=r[e[s]];if(!a.extras)continue;let l=null;o.id in n&&(l=jb(t[n[o.id]].meshes,o.matrix)),l||(l=Nb(a)),l&&(o.footprint=Ub(l));}if(i.size>0){const e=Array.from(i.values()).sort(((t,e)=>t-e));for(let r=e.length-1;r>=0;r--)t.splice(e[r],1);}}(a,o,t.json.nodes),a}function Gb(t){t.heightmap=new Float32Array(4096),t.heightmap.fill(-1);const e=t.vertexArray.float32,r=t.aabb.min[0]-1,n=t.aabb.min[1]-1,i=yx/(t.aabb.max[0]-r+2),s=yx/(t.aabb.max[1]-n+2);for(let o=0;o<e.length;o+=3){const a=e[o+2],l=(e[o+0]-r)*i|0,u=(e[o+1]-n)*s|0;a>t.heightmap[u*yx+l]&&(t.heightmap[u*yx+l]=a);}}function qb(t,e){const r={};r.indexArray=new Aa,r.indexArray.reserve(4*t.length),r.vertexArray=new ca,r.vertexArray.reserve(10*t.length),r.colorArray=new ya,r.vertexArray.reserve(10*t.length);let n=0;for(const i of t){const t=Math.min(10,Math.max(4,1.3*i.height))*e,s=[-i.normal[1],i.normal[0],0],o=Math.min(.29,.1*i.width/i.depth),a=i.width-2*i.depth*e*(o+.01),l=E([],i.pos,s,a/2),u=E([],i.pos,s,-a/2),c=[l[0],l[1],l[2]+i.height],h=[u[0],u[1],u[2]+i.height],p=E([],i.normal,s,o);P(p,p,t);const f=E([],i.normal,s,-o);P(f,f,t),M(p,l,p),M(f,u,f),l[2]+=.1,u[2]+=.1,r.vertexArray.emplaceBack(p[0],p[1],p[2]),r.vertexArray.emplaceBack(f[0],f[1],f[2]),r.vertexArray.emplaceBack(l[0],l[1],l[2]),r.vertexArray.emplaceBack(u[0],u[1],u[2]),r.vertexArray.emplaceBack(c[0],c[1],c[2]),r.vertexArray.emplaceBack(h[0],h[1],h[2]),r.vertexArray.emplaceBack(l[0],l[1],l[2]),r.vertexArray.emplaceBack(u[0],u[1],u[2]),r.vertexArray.emplaceBack(p[0],p[1],p[2]),r.vertexArray.emplaceBack(f[0],f[1],f[2]);const d=a/t/2;r.colorArray.emplaceBack(-d-o,-1,d,.8),r.colorArray.emplaceBack(d+o,-1,d,.8),r.colorArray.emplaceBack(-d,0,d,1.3),r.colorArray.emplaceBack(d,0,d,1.3),r.colorArray.emplaceBack(d+o,-.8,d,.7),r.colorArray.emplaceBack(d+o,-.8,d,.7),r.colorArray.emplaceBack(0,0,d,1.3),r.colorArray.emplaceBack(0,0,d,1.3),r.colorArray.emplaceBack(d+o,-1.2,d,.8),r.colorArray.emplaceBack(d+o,-1.2,d,.8),r.indexArray.emplaceBack(6+n,4+n,8+n),r.indexArray.emplaceBack(7+n,9+n,5+n),r.indexArray.emplaceBack(0+n,1+n,2+n),r.indexArray.emplaceBack(1+n,3+n,2+n),n+=10;}const i={defined:!0};i.emissiveFactor=sr.black;const s={};return s.baseColorFactor=sr.white,i.pbrMetallicRoughness=s,r.material=i,r.aabb=new qu([1/0,1/0,1/0],[-1/0,-1/0,-1/0]),r}Vb.performDecoding=function(t,e){const r=new Uint8Array(t);return Promise.all(e.tasks.map((t=>{const{layerName:e,firstByte:n,lastByte:i,pixelFormat:s,blockShape:o,blockIndex:a,filters:l,codec:u}=t,c=r.subarray(n,i+1),h=new Uint32Array(o[0]*o[1]*o[2]);let p;if("gzip_data"!==u)throw new kb(`Unhandled codec: ${u}`);return p=function(t,e){if(!globalThis.DecompressionStream&&"gzip_data"===e)return Promise.resolve(((s=function(t){31==t[0]&&139==t[1]&&8==t[2]||Mb(6,"invalid gzip data");var e=t[3],r=10;4&e&&(r+=2+(t[10]|t[11]<<8));for(var n=(e>>3&1)+(e>>4&1);n>0;n-=!t[r++]);return r+(2&e)}(i=t))+8>i.length&&Mb(6,"invalid gzip data"),function(t,e,r,n){var i=t.length;if(!i||e.f&&!e.l)return r||new eb(0);var s=!r,o=s||2!=e.i,a=e.i;s&&(r=new eb(3*i));var l,u,c=function(t){var e=r.length;if(t>e){var n=new eb(Math.max(2*e,t));n.set(r),r=n;}},h=e.f||0,p=e.p||0,f=e.b||0,d=e.l,m=e.d,y=e.m,g=e.n,x=8*i;do{if(!d){h=wb(t,p,1);var v=wb(t,p+1,3);if(p+=3,!v){var b=t[(T=4+((p+7)/8|0))-4]|t[T-3]<<8,w=T+b;if(w>i){a&&Mb(0);break}o&&c(f+b),r.set(t.subarray(T,w),f),e.b=f+=b,e.p=p=8*w,e.f=h;continue}if(1==v)d=xb,m=vb,y=9,g=5;else if(2==v){var _=wb(t,p,31)+257,A=wb(t,p+10,15)+4,M=_+wb(t,p+5,31)+1;p+=14;for(var I=new eb(M),S=new eb(19),z=0;z<A;++z)S[ob[z]]=wb(t,p+3*z,7);p+=3*A;var k=bb(S),P=(1<<k)-1,E=mb(S,k);for(z=0;z<M;){var T,B=E[wb(t,p,P)];if(p+=15&B,(T=B>>4)<16)I[z++]=T;else {var V=0,C=0;for(16==T?(C=3+wb(t,p,3),p+=2,V=I[z-1]):17==T?(C=3+wb(t,p,7),p+=3):18==T&&(C=11+wb(t,p,127),p+=7);C--;)I[z++]=V;}}var F=I.subarray(0,_),D=I.subarray(_);y=bb(F),g=bb(D),d=mb(F,y),m=mb(D,g);}else Mb(1);if(p>x){a&&Mb(0);break}}o&&c(f+131072);for(var L=(1<<y)-1,R=(1<<g)-1,O=p;;O=p){var U=(V=d[_b(t,p)&L])>>4;if((p+=15&V)>x){a&&Mb(0);break}if(V||Mb(2),U<256)r[f++]=U;else {if(256==U){O=p,d=null;break}var N=U-254;U>264&&(N=wb(t,p,(1<<(G=ib[z=U-257]))-1)+ub[z],p+=G);var j=m[_b(t,p)&R],$=j>>4;if(j||Mb(3),p+=15&j,D=hb[$],$>3){var G=sb[$];D+=_b(t,p)&(1<<G)-1,p+=G;}if(p>x){a&&Mb(0);break}o&&c(f+131072);var q=f+N;if(f<D){var H=0-D,X=Math.min(D,q);for(H+f<0&&Mb(3);f<X;++f)r[f]=(void 0)[H+f];}for(;f<q;++f)r[f]=r[f-D];}}e.l=d,e.p=O,e.b=f,e.f=h,d&&(h=1,e.m=y,e.d=m,e.n=g);}while(!h);return f!=r.length&&s?(l=r,(null==(u=f)||u>l.length)&&(u=l.length),new eb(l.subarray(0,u))):r.subarray(0,f)}(i.subarray(s,-8),{i:2},new eb(((r=i)[(n=r.length)-4]|r[n-3]<<8|r[n-2]<<16|r[n-1]<<24)>>>0))));var r,n,i,s;const o=zb[e];if(!o)throw new Error(`Unhandled codec: ${e}`);const a=new globalThis.DecompressionStream(o);return new Response(new Blob([t]).stream().pipeThrough(a)).arrayBuffer().then((t=>new Uint8Array(t)))}(c,u).then((t=>(function(t,e){t.readFields(Yv,e);}(new Bb(t),h),new(0,Tb[s])(h.buffer)))),p.then((t=>{for(let e=l.length-1;e>=0;e--)switch(l[e]){case "delta_filter":Jv(t,o);break;case "zigzag_filter":Qv(t);break;case "bitshuffle_filter":tb(t,s);break;default:throw new kb(`Unhandled filter "${l[e]}"`)}return {layerName:e,blockIndex:a,data:t}})).catch((t=>{throw t}))})))},qs(Fb,"MRTDecodingBatch",{omit:["_onCancel","_onComplete"]}),qs(Vb,"MapboxRasterTile"),qs(Cb,"MapboxRasterLayer",{omit:["_blocksInProgress"]});class Hb{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r;}}encode(t){return this._stringToNumber[t]}decode(t){return this._numberToString[t]}}const Xb=["id","tile","layer","source","sourceLayer","state"];class Zb{constructor(t,e,r,n,i){this.type="Feature",this._vectorTileFeature=t,this._z=e,this._x=r,this._y=n,this.properties=t.properties,this.id=i;}clone(){const t=new Zb(this._vectorTileFeature,this._z,this._x,this._y,this.id);return this.state&&(t.state=Object.assign({},this.state)),this.layer&&(t.layer=Object.assign({},this.layer)),this.source&&(t.source=this.source),this.sourceLayer&&(t.sourceLayer=this.sourceLayer),t}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._x,this._y,this._z).geometry),this._geometry}set geometry(t){this._geometry=t;}toJSON(){const t={type:"Feature",state:void 0,geometry:this.geometry,properties:this.properties};for(const e of Xb)void 0!==this[e]&&(t[e]=this[e]);return t}}class Wb{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new $s(Cn,16,0),this.featureIndexArray=new Xa,this.promoteId=e,this.is3DTile=!1,this.serializedLayersCache=new Map;}insert(t,e,r,n,i,s=0,o=0){const a=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i,s);const l=this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x),n[1]=Math.min(n[1],e.y),n[2]=Math.max(n[2],e.x),n[3]=Math.max(n[3],e.y);}0!==o&&(n[0]-=o,n[1]-=o,n[2]+=o,n[3]+=o),n[0]<Cn&&n[1]<Cn&&n[2]>=0&&n[3]>=0&&l.insert(a,n[0],n[1],n[2],n[3]);}}loadVTLayers(){if(!this.vtLayers){this.vtLayers=new Pu.VectorTile(new um(this.rawTileData)).layers,this.sourceLayerCoder=new Hb(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"]),this.vtFeatures={};for(const t in this.vtLayers)this.vtFeatures[t]=[];}return this.vtLayers}query(t,e){const{tilespaceGeometry:r,transform:n,tileTransform:i,pixelPosMatrix:s,availableImages:o,worldview:a}=e;this.loadVTLayers(),this.serializedLayersCache.clear();const l=r.bufferedTilespaceBounds,u=this.grid.query(l.min.x,l.min.y,l.max.x,l.max.y,((t,e,n,i)=>uc(r.bufferedTilespaceGeometry,t,e,n,i)));u.sort(Kb);let c=null;n.elevation&&u.length>0&&(c=Mx.create(n.elevation,this.tileID));const h={};let p;for(let e=0;e<u.length;e++){const l=u[e];if(l===p)continue;p=l;const f=this.featureIndexArray.get(l);let d=null;this.is3DTile?this.loadMatchingModelFeature(h,f,t,r,n,a):this.loadMatchingFeature(h,f,t,o,a,((t,e,o,a=0)=>(d||(d=yu(t,this.tileID.canonical,i)),e.queryIntersectsFeature(r,t,o,d,this.z,n,s,c,a))));}return h}loadMatchingFeature(t,e,r,n,i,s){const{featureIndex:o,bucketIndex:a,sourceLayerIndex:l,layoutVertexArrayOffset:u}=e,c=this.bucketLayerIDs[a],h=r.layers,p=Object.keys(h);if(p.length&&!jt(p,c))return;const f=r.sourceCache,d=this.sourceLayerCoder.decode(l),m=this.vtLayers[d].feature(o),y=this.getId(m,d);for(let e=0;e<c.length;e++){const r=c[e];if(!h[r])continue;const{styleLayer:a,targets:l}=h[r];let p={};void 0!==y&&(p=f.getFeatureState(a.sourceLayer,y));const d=!s||s(m,a,p,u);if(!d)continue;const g=new Zb(m,this.z,this.x,this.y,y);g.tile=this.tileID.canonical,g.state=p;let x=this.serializedLayersCache.get(r);x||(x=a.serialize(),x.id=r,this.serializedLayersCache.set(r,x)),g.source=x.source,g.sourceLayer=x["source-layer"],g.layer=Ct({},x),g.layer.paint=Yb(x.paint,a.paint,m,p,n),g.layer.layout=Yb(x.layout,a.layout,m,p,n);let v=!1;for(const t of l){this.updateFeatureProperties(g,t);const{filter:e}=t;if(e)if(m.properties=g.properties,e.needGeometry){const t=gu(m,!0);if(!e.filter(new go(this.tileID.overscaledZ,{worldview:i}),t,this.tileID.canonical))continue}else if(!e.filter(new go(this.tileID.overscaledZ,{worldview:i}),m))continue;v=!0,t.targetId&&this.addFeatureVariant(g,t);}v&&this.appendToResult(t,r,o,g,d);}}loadMatchingModelFeature(t,e,r,n,i,s){const{featureIndex:o,bucketIndex:a}=e,l=this.bucketLayerIDs[a],u=r.layers,c=Object.keys(u);if(!c.length||jt(c,l))for(let e=0;e<l.length;e++){const a=l[e],{styleLayer:c,targets:h}=u[a];if("model"!==c.type)continue;const p=n.tile,f=p.getBucket(c);if(!(f&&f instanceof Tx))continue;const d=Dx(f,o,n,i);if(!d)continue;const{z:m,x:y,y:g}=p.tileID.canonical,{feature:x,intersectionZ:v,position:b}=d;let w={};void 0!==x.id&&(w=r.sourceCache.getFeatureState(c.sourceLayer,x.id));const _=new Zb({},m,y,g,x.id);_.tile=this.tileID.canonical,_.state=w,_.properties=x.properties,_.geometry={type:"Point",coordinates:[b.lng,b.lat]};let A=this.serializedLayersCache.get(a);A||(A=c.serialize(),A.id=a,this.serializedLayersCache.set(a,A)),_.source=A.source,_.sourceLayer=A["source-layer"],_.layer=Ct({},A);let M=!1;for(const t of h){this.updateFeatureProperties(_,t);const{filter:e}=t;if(e)if(x.properties=_.properties,e.needGeometry){if(!e.filter(new go(this.tileID.overscaledZ,{worldview:s}),x,this.tileID.canonical))continue}else if(!e.filter(new go(this.tileID.overscaledZ,{worldview:s}),x))continue;M=!0,t.targetId&&this.addFeatureVariant(_,t);}M&&this.appendToResult(t,a,o,_,v);}}updateFeatureProperties(t,e,r){if(e.properties){const n={};for(const i in e.properties){const s=e.properties[i].evaluate({zoom:this.z},t._vectorTileFeature,t.state,t.tile,r);null!=s&&(n[i]=s);}t.properties=n;}}addFeatureVariant(t,e,r){const n={target:e.target,namespace:e.namespace,uniqueFeatureID:e.uniqueFeatureID};e.properties&&(n.properties=t.properties),t.variants=t.variants||{},t.variants[e.targetId]=t.variants[e.targetId]||[],t.variants[e.targetId].push(n);}appendToResult(t,e,r,n,i){let s=t[e];void 0===s&&(s=t[e]=[]),s.push({featureIndex:r,feature:n,intersectionZ:i});}lookupSymbolFeatures(t,e,r,n,i,s){const o={};this.loadVTLayers();for(const a of t)this.loadMatchingFeature(o,{bucketIndex:e,sourceLayerIndex:r,featureIndex:a,layoutVertexArrayOffset:0},n,i,s);return o}loadFeature(t){const{featureIndex:e,sourceLayerIndex:r}=t;this.loadVTLayers();const n=this.sourceLayerCoder.decode(r),i=this.vtFeatures[n];if(i[e])return i[e];const s=this.vtLayers[n].feature(e);return i[e]=s,s}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return !0;return !1}getId(t,e){let r=t.id;if(this.promoteId){const n=Array.isArray(this.promoteId)||"object"!=typeof this.promoteId?this.promoteId:this.promoteId[e];if(null!=n)if(Array.isArray(n)){if(!this.promoteIdExpression){const t=Cs(n);if("success"!==t.result){const e=t.value.map((t=>`${t.key}: ${t.message}`)).join(", ");return void Gt(`Failed to create expression for promoteId: ${e}`)}this.promoteIdExpression=t.value;}this.promoteIdExpression._evaluator||(this.promoteIdExpression._evaluator=new Kr),r=this.promoteIdExpression.evaluate({zoom:0},t);}else r=t.properties[n];"boolean"==typeof r&&(r=Number(r));}return r}}function Yb(t,e,r,n,i){return Ot(t,((t,s)=>{const o=e instanceof Io?e.get(s):null;return o&&o.evaluate?o.evaluate(r,n,void 0,i):o}))}function Kb(t,e){return e-t}qs(Wb,"FeatureIndex",{omit:["rawTileData","sourceLayerCoder"]});const Jb=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class Qb{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,r]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const n=r>>4;if(1!==n)throw new Error(`Got v${n} data when expected v1.`);const i=Jb[15&r];if(!i)throw new Error("Unrecognized array type.");const[s]=new Uint16Array(t,2,1),[o]=new Uint32Array(t,4,1);return new Qb(o,s,i,t)}constructor(t,e=64,r=Float64Array,n){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=r,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const i=Jb.indexOf(this.ArrayType),s=2*t*this.ArrayType.BYTES_PER_ELEMENT,o=t*this.IndexArrayType.BYTES_PER_ELEMENT,a=(8-o%8)%8;if(i<0)throw new Error(`Unexpected typed array class: ${r}.`);n&&n instanceof ArrayBuffer?(this.data=n,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+o+a,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+s+o+a),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+o+a,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+i]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t);}add(t,e){const r=this._pos>>1;return this.ids[r]=r,this.coords[this._pos++]=t,this.coords[this._pos++]=e,r}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return tw(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,r,n){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:i,coords:s,nodeSize:o}=this,a=[0,i.length-1,0],l=[];for(;a.length;){const u=a.pop()||0,c=a.pop()||0,h=a.pop()||0;if(c-h<=o){for(let o=h;o<=c;o++){const a=s[2*o],u=s[2*o+1];a>=t&&a<=r&&u>=e&&u<=n&&l.push(i[o]);}continue}const p=h+c>>1,f=s[2*p],d=s[2*p+1];f>=t&&f<=r&&d>=e&&d<=n&&l.push(i[p]),(0===u?t<=f:e<=d)&&(a.push(h),a.push(p-1),a.push(1-u)),(0===u?r>=f:n>=d)&&(a.push(p+1),a.push(c),a.push(1-u));}return l}within(t,e,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:i,nodeSize:s}=this,o=[0,n.length-1,0],a=[],l=r*r;for(;o.length;){const u=o.pop()||0,c=o.pop()||0,h=o.pop()||0;if(c-h<=s){for(let r=h;r<=c;r++)iw(i[2*r],i[2*r+1],t,e)<=l&&a.push(n[r]);continue}const p=h+c>>1,f=i[2*p],d=i[2*p+1];iw(f,d,t,e)<=l&&a.push(n[p]),(0===u?t-r<=f:e-r<=d)&&(o.push(h),o.push(p-1),o.push(1-u)),(0===u?t+r>=f:e+r>=d)&&(o.push(p+1),o.push(c),o.push(1-u));}return a}}function tw(t,e,r,n,i,s){if(i-n<=r)return;const o=n+i>>1;ew(t,e,o,n,i,s),tw(t,e,r,n,o-1,1-s),tw(t,e,r,o+1,i,1-s);}function ew(t,e,r,n,i,s){for(;i>n;){if(i-n>600){const o=i-n+1,a=r-n+1,l=Math.log(o),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(o-u)/o)*(a-o/2<0?-1:1);ew(t,e,r,Math.max(n,Math.floor(r-a*u/o+c)),Math.min(i,Math.floor(r+(o-a)*u/o+c)),s);}const o=e[2*r+s];let a=n,l=i;for(rw(t,e,n,r),e[2*i+s]>o&&rw(t,e,n,i);a<l;){for(rw(t,e,a,l),a++,l--;e[2*a+s]<o;)a++;for(;e[2*l+s]>o;)l--;}e[2*n+s]===o?rw(t,e,n,l):(l++,rw(t,e,l,i)),l<=r&&(n=l+1),r<=l&&(i=l-1);}}function rw(t,e,r,n){nw(t,r,n),nw(e,2*r,2*n),nw(e,2*r+1,2*n+1);}function nw(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function iw(t,e,r,n){const i=t-r,s=e-n;return i*i+s*s}t.$=Jr,t.A=Ye,t.B=Fr,t.C=Xo,t.D=Df,t.E=tr,t.F=2,t.G=Zm,t.H=Hm,t.I=er,t.J=Xr,t.K=class extends ux{},t.L=pr,t.M=To,t.N=As,t.O=bs,t.P=bt,t.Q=_s,t.R=Be,t.S=Vs,t.T=Pg,t.U=Bo,t.V=ux,t.W=Ls,t.X=Cs,t.Y=pi,t.Z=di,t._=hi,t.a=function(t){return ne.API_CDN_URL_REGEX.test(t)},t.a$=Dt,t.a0=ir,t.a1=Vo,t.a2=Ms,t.a3=ws,t.a4=function(t){const e=t.value;let r=[];if(!e)return r;const n=Xr(e);return "string"!==n?(r=r.concat([new ux(t.key,e,`string expected, "${n}" found`)]),r):(cx(e,!0)||(r=r.concat([new ux(t.key,e,`invalid url "${e}"`)])),r)},t.a5=Eo,t.a6=bo,t.a7=Po,t.a8=So,t.a9=class{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return Xt(t.expression.evaluate(e))}interpolate(t,e,r){return {x:ur(t.x,e.x,r),y:ur(t.y,e.y,r),z:ur(t.z,e.z,r),azimuthal:ur(t.azimuthal,e.azimuthal,r),polar:ur(t.polar,e.polar,r)}}},t.aA=Z,t.aB=Cl,t.aC=lc,t.aD=Kl,t.aE=cu,t.aF=function(t,e){const r={};for(let n=0;n<e.length;n++){const i=e[n];i in t&&(r[i]=t[i]);}return r},t.aG=Xl,t.aH=Jl,t.aI=class{constructor(t){this.entries={},this.scheduler=t;}request(t,e,r,n){const i=this.entries[t]=this.entries[t]||{callbacks:[]};if(i.result){const[t,r]=i.result;return this.scheduler?this.scheduler.add((()=>{n(t,r);}),e):n(t,r),()=>{}}return i.callbacks.push(n),i.cancel||(i.cancel=r(((r,n)=>{i.result=[r,n];for(const t of i.callbacks)this.scheduler?this.scheduler.add((()=>{t(r,n);}),e):t(r,n);setTimeout((()=>delete this.entries[t]),3e3);}))),()=>{i.result||(i.callbacks=i.callbacks.filter((t=>t!==n)),i.callbacks.length||(i.cancel(),delete this.entries[t]));}}},t.aJ=function(t,e,r){const n=JSON.stringify(t.request);return t.data&&(this.deduped.entries[n]={result:[null,t.data]}),this.deduped.request(n,{type:"parseTile",isSymbolTile:t.isSymbolTile,zoom:t.tileZoom},(e=>{const n=De(t.request,((t,n,i,s)=>{t?e(t):n&&e(null,{vectorTile:r?void 0:new Pu.VectorTile(new um(n)),rawData:n,cacheControl:i,expires:s});}));return ()=>{n.cancel(),e();}}),e)},t.aK=function(t){Me++,Me>xe&&(t.getActor().send("enforceCacheSizeLimit",ge),Me=0);},t.aL=function(t){return t<=1?1:Math.pow(2,Math.floor(Math.log(t)/Math.LN2))},t.aM=_c,t.aN=Dg,t.aO=jg,t.aP=Cg,t.aQ=function(t,e){const r=document.createElement("video");r.muted=!0,r.onloadstart=function(){e(null,r);};for(let e=0;e<t.length;e++){const n=document.createElement("source");Le(t[e])||(r.crossOrigin="Anonymous"),n.src=t[e],r.appendChild(n);}return {cancel:()=>{}}},t.aR=Eg,t.aS=function(t){return fetch(t).then((t=>t.arrayBuffer())).then((e=>pd(e,0,t)))},t.aT=$b,t.aU=class{constructor(t,e,r,n){this.id=t,this.position=null!=e?new Hl(e[0],e[1]):new Hl(0,0),this.orientation=null!=r?r:[0,0,0],this.nodes=n,this.uploaded=!1,this.aabb=new qu([1/0,1/0,1/0],[-1/0,-1/0,-1/0]),this.matrix=[];}_applyTransformations(t,e){if(c(t.matrix,e,t.matrix),t.meshes)for(const e of t.meshes){const r=qu.applyTransformFast(e.aabb,t.matrix);this.aabb.encapsulate(r);}if(t.children)for(const e of t.children)this._applyTransformations(e,t.matrix);}computeBoundsAndApplyParent(){const t=l([]);for(const e of this.nodes)this._applyTransformations(e,t);}computeModelMatrix(t,e,r,n,i,s,o=!1){xx(this.matrix,this,t.transform,this.position,e,r,n,i,s,o);}upload(t){if(!this.uploaded){for(const e of this.nodes)wx(e,t);for(const t of this.nodes)_x(t);this.uploaded=!0;}}destroy(){for(const t of this.nodes)Ax(t);}},t.aV=Rt,t.aW=Dy,t.aX=tu,t.aY=eu,t.aZ=ia,t.a_=Aa,t.aa=go,t.ab=Ds,t.ac=lu,t.ad=R,t.ae=_,t.af=Tt,t.ag=Io,t.ah=Zc,t.ai=ur,t.aj=Cn,t.ak=cr,t.al=Mt,t.am=sr,t.an=class{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return function([t,e]){const r=Xt([1,t,e]);return {x:r.x,y:r.y,z:r.z}}(t.expression.evaluate(e))}interpolate(t,e,r){return {x:ur(t.x,e.x,r),y:ur(t.y,e.y,r),z:ur(t.z,e.z,r)}}},t.ao=function(t,e,r=0,n=!0){const i=new bt(r,r),s=t.sub(i),o=e.add(i),a=[s,new bt(o.x,s.y),o,new bt(s.x,o.y)];return n&&a.push(s.clone()),a},t.ap=function(t,e){const r=[];for(let n=0;n<t.length;n++){const i=Bt(n-1,-1,t.length-1),s=Bt(n+1,-1,t.length-1),o=t[n],a=t[s],l=t[i].sub(o).unit(),u=a.sub(o).unit(),c=u.angleWithSep(l.x,l.y),h=l.add(u).unit().mult(-1*e/Math.sin(c/2));r.push(o.add(h));}return r},t.aq=Ly,t.ar=uc,t.as=function(t,e,r=0){return A(((e.x-r)*t.scale-t.x)*Cn,(e.y*t.scale-t.y)*Cn,ru(e.z,e.y))},t.at=j,t.au=C,t.av=Ru,t.aw=Td,t.ax=function(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const s of t)e=Math.min(e,s.x),r=Math.min(r,s.y),n=Math.max(n,s.x),i=Math.max(i,s.y);return {min:new bt(e,r),max:new bt(n,i)}},t.ay=Et,t.az=c,t.b=function(t){return ne.API_FONTS_REGEX.test(t)},t.b$=function(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],o=e[3],a=Math.sin(r),l=Math.cos(r);return t[0]=n*l+i*a,t[1]=i*l-n*a,t[2]=s*l+o*a,t[3]=o*l-s*a,t},t.b0=Oa,t.b1=mg,t.b2=function(){yo.isLoading()||yo.isLoaded()||"deferred"!==fo()||mo();},t.b3=Co,t.b4=gu,t.b5=Zb,t.b6=Wt,t.b7=zd,t.b8=fp,t.b9=yu,t.bA=function(t,e){const{x:r,y:n}=t.point,i=Xc(r,n,t.worldSize/t._pixelsPerMercatorPixel,0,0);return c(i,i,Gc(Cc(e)))},t.bB=n,t.bC=function(t){return t[0]=0,t[1]=0,t[2]=0,t},t.bD=function(t,e){return Math.hypot(e[0]-t[0],e[1]-t[1],e[2]-t[2])},t.bE=E,t.bF=D,t.bG=F,t.bH=Lm,t.bI=mm,t.bJ=Dm,t.bK=function(t,e,r,n,i){const s=5*e+2;t.float32[s+0]=r,t.float32[s+1]=n,t.float32[s+2]=i;},t.bL=hg,t.bM=Mf,t.bN=Ku,t.bO=Jd,t.bP=Pp,t.bQ=lx,t.bR=Rp,t.bS=Op,t.bT=Sm,t.bU=gy,t.bV=Iy,t.bW=Qb,t.bX=Bt,t.bY=P,t.bZ=G,t.b_=Y,t.ba=ra,t.bb=Va,t.bc=kc,t.bd=tl,t.be=Ah,t.bf=Sg,t.bg=function(t,e){const r=Zc(e.zoom);if(0===r)return Cc(t);const n=Rc(t),i=Oc(n),s=Kl(n.getWest())*e.worldSize,o=Kl(n.getEast())*e.worldSize,a=Jl(n.getNorth())*e.worldSize,l=Jl(n.getSouth())*e.worldSize,c=[s,a,0],h=[o,a,0],p=[s,l,0],f=[o,l,0],d=u([],e.globeMatrix);return R(c,c,d),R(h,h,d),R(p,p,d),R(f,f,d),i[0]=Fc(i[0],p,r),i[1]=Fc(i[1],f,r),i[2]=Fc(i[2],h,r),i[3]=Fc(i[3],c,r),qu.fromPoints(i)},t.bh=$c,t.bi=u,t.bj=Uc,t.bk=Fc,t.bl=na,t.bm=zc,t.bn=y,t.bo=h,t.bp=Vb,t.bq=um,t.br=De,t.bs=function(t,e){const r=[];for(const n in t)n in e||r.push(n);return r},t.bt=Vt,t.bu=["type","source","source-layer","minzoom","maxzoom","filter","layout"],t.bv=wt,t.bw=function(t){var e=new r(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},t.bx=l,t.by=m,t.bz=a,t.c=se,t.c$=Of,t.c0=K,t.c1=Kt,t.c2=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=e[3],t},t.c3=x,t.c4=function(t,e,r,n,i){var s,o=1/Math.tan(e/2);return t[0]=o/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=o,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0?(t[10]=(i+n)*(s=1/(n-i)),t[14]=2*i*n*s):(t[10]=-1,t[14]=-2*n),t},t.c5=function(t,e,r,n,i,s,o){var a=1/(e-r),l=1/(n-i),u=1/(s-o);return t[0]=-2*a,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*u,t[11]=0,t[12]=(e+r)*a,t[13]=(i+n)*l,t[14]=(o+s)*u,t[15]=1,t},t.c6=Ql,t.c7=function(t,e,r){t[4*e+0]=r[0],t[4*e+1]=r[1],t[4*e+2]=r[2],t[4*e+3]=r[3];},t.c8=cl,t.c9=fl,t.cA=Xg,t.cB=v,t.cC=qg,t.cD=function(t){const e=qg(t,!0);return n([],[e[0],e[1],e[4],e[5]])},t.cE=p,t.cF=Ou,t.cG=f,t.cH=function(t){const{x:e,y:r}=t.point,{lng:n,lat:i}=t._center;return Xc(e,r,t.worldSize,n,i)},t.cI=S,t.cJ=It,t.cK=Ac,t.cL=Fl,t.cM=function(t,e,r){let n=0;for(let r=0;r<2;++r){const i=0;t[r]>i&&(n+=(t[r]-i)*(t[r]-i)),e[r]<i&&(n+=(i-e[r])*(i-e[r]));}return n},t.cN=function(t){return t*t*t*t*t},t.cO=Yl,t.cP=45,t.cQ=dl,t.cR=function(t,e,r){const n=Math.sqrt(t*t+e*e+r*r),i=n>0?Math.acos(r/n)*At:0;let s=0!==t||0!==e?Math.atan2(-e,-t)*At+90:0;return s<0&&(s+=360),[n,s,i]},t.cS=A,t.cT=Xt,t.cU=au,t.cV=M,t.cW=qu,t.cX=I,t.cY=function(t){return [Math.pow(t[0],1/2.2),Math.pow(t[1],1/2.2),Math.pow(t[2],1/2.2)]},t.cZ=cx,t.c_=function(t,e){return t.readFields(qx,{icons:[]},e)},t.ca=hl,t.cb=pl,t.cc=gl,t.cd=Hl,t.ce=ig,t.cf=function(){var t=new r(4);return r!=Float32Array&&(t[1]=0,t[2]=0),t[0]=1,t[3]=1,t},t.cg=function(t,e,r){var n=e[0],i=e[1],s=e[2],o=e[3],a=Math.sin(r),l=Math.cos(r);return t[0]=n*l+s*a,t[1]=i*l+o*a,t[2]=n*-a+s*l,t[3]=i*-a+o*l,t},t.ch=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]},t.ci=N,t.cj=function(t){return Math.hypot(t[0],t[1],t[2],t[3])},t.ck=it,t.cl=U,t.cm=wc,t.cn=Gu,t.co=Hg,t.cp=bc,t.cq=Lc,t.cr=function(t,e,r,n,i,s,o,a,l){if("globe"===l.name)return Lc(t,e,new bc(r,n,i),!1);const u=Dy({z:r,x:n,y:i},l);return new qu([(s+u.x/u.scale)*e,e*(u.y/u.scale),o],[(s+u.x2/u.scale)*e,e*(u.y2/u.scale),a])},t.cs=function(t,e,r){return t[0]=Math.min(e[0],r[0]),t[1]=Math.min(e[1],r[1]),t[2]=Math.min(e[2],r[2]),t[3]=Math.min(e[3],r[3]),t},t.ct=function(t,e,r){return t[0]=Math.max(e[0],r[0]),t[1]=Math.max(e[1],r[1]),t[2]=Math.max(e[2],r[2]),t[3]=Math.max(e[3],r[3]),t},t.cu=function(t){const e=Math.round((t+45+360)%360/90)%4;return St[e]},t.cv=nu,t.cw=H,t.cx=Dl,t.cy=function(t){const e=l(new Float64Array(16));c(e,t.pixelMatrix,t.globeMatrix);const r=[0,Ul,0],n=[0,Nl,0];return R(r,r,e),R(n,n,e),[r[0]>0&&r[0]<=t.width&&r[1]>0&&r[1]<=t.height&&!Yc(t,new Hl(t.center.lat,90)),n[0]>0&&n[0]<=t.width&&n[1]>0&&n[1]<=t.height&&!Yc(t,new Hl(t.center.lat,-90))]},t.cz=function(t,e){const{scale:r}=t.tileTransform,n=r*Cn/(t.tileSize*Math.pow(2,e.zoom-t.tileID.overscaledZ+t.tileID.canonical.z));return function(t,e,r){var n=e[1],i=e[2],s=e[3],o=r[0],a=r[1];return t[0]=e[0]*o,t[1]=n*o,t[2]=i*a,t[3]=s*a,t}(new Float32Array(4),e.inverseAdjustmentMatrix,[n,n])},t.d=function(t){return ne.API_TILEJSON_REGEX.test(t)},t.d$=Da,t.d0=ry,t.d1=ey,t.d2=Ce,t.d3=co,t.d4=me,t.d5=We,t.d6=Nt,t.d7=function(t){const e=t.indexOf(Ho);return e>=0?t.slice(0,e):t},t.d8=function(t){return t.indexOf(Ho)>=0},t.d9=function(t){const e=t.lastIndexOf(Ho);return e>=0?t.slice(e+1):""},t.dA=Hc,t.dB=te,t.dC=ee,t.dD=256,t.dE=function(t,e){const r=[0,0,0];return R(r,r,$c(Cc(e.canonical))),R(r,r,t),r},t.dF=t=>({u_matrix:new gl(t),u_texsize:new pl(t),u_pixels_to_tile_units:new bl(t),u_device_pixel_ratio:new hl(t),u_width_scale:new hl(t),u_floor_width_scale:new hl(t),u_image:new cl(t),u_units_to_pixels:new pl(t),u_tile_units_to_pixels:new hl(t),u_alpha_discard_threshold:new hl(t),u_trim_offset:new pl(t),u_trim_fade_range:new pl(t),u_trim_color:new dl(t),u_emissive_strength:new hl(t),u_zbias_factor:new hl(t),u_tile_to_meter:new hl(t),u_ground_shadow_factor:new fl(t),u_pattern_transition:new hl(t)}),t.dG=t=>({u_matrix:new gl(t),u_pixels_to_tile_units:new bl(t),u_device_pixel_ratio:new hl(t),u_width_scale:new hl(t),u_floor_width_scale:new hl(t),u_units_to_pixels:new pl(t),u_dash_image:new cl(t),u_gradient_image:new cl(t),u_image_height:new hl(t),u_texsize:new pl(t),u_tile_units_to_pixels:new hl(t),u_alpha_discard_threshold:new hl(t),u_trim_offset:new pl(t),u_trim_fade_range:new pl(t),u_trim_color:new dl(t),u_emissive_strength:new hl(t),u_zbias_factor:new hl(t),u_tile_to_meter:new hl(t),u_ground_shadow_factor:new fl(t)}),t.dH=t=>({u_camera_to_center_distance:new hl(t),u_extrude_scale:new bl(t),u_device_pixel_ratio:new hl(t),u_matrix:new gl(t),u_inv_rot_matrix:new gl(t),u_merc_center:new pl(t),u_tile_id:new fl(t),u_zoom_transition:new hl(t),u_up_dir:new fl(t),u_emissive_strength:new hl(t)}),t.dI=wa,t.dJ=Kd,t.dK=eh,t.dL=(t,e,r,n,i,s)=>{const o=t.transform,a="globe"===o.projection.name;let l;if("map"===s.paint.get("circle-pitch-alignment"))if(a){const t=Hc(o.zoom,e.canonical)*o._pixelsPerMercatorPixel;l=Float32Array.from([t,0,0,t]);}else l=o.calculatePixelsToTileUnitsMatrix(r);else l=new Float32Array([o.pixelsToGLUnits[0],0,0,o.pixelsToGLUnits[1]]);const u={u_camera_to_center_distance:t.transform.getCameraToCenterDistance(o.projection),u_matrix:t.translatePosMatrix(e.projMatrix,r,s.paint.get("circle-translate"),s.paint.get("circle-translate-anchor")),u_device_pixel_ratio:fe.devicePixelRatio,u_extrude_scale:l,u_inv_rot_matrix:th,u_merc_center:[0,0],u_tile_id:[0,0,0],u_zoom_transition:0,u_up_dir:[0,0,0],u_emissive_strength:s.paint.get("circle-emissive-strength")};if(a){u.u_inv_rot_matrix=n,u.u_merc_center=i,u.u_tile_id=[e.canonical.x,e.canonical.y,1<<e.canonical.z],u.u_zoom_transition=Zc(o.zoom);const t=i[0]*Cn,r=i[1]*Cn;u.u_up_dir=o.projection.upVector(new bc(0,0,0),t,r);}return u},t.dM=Fd,t.dN=Dr,t.dO=(t,e,r,n,i,s,o,a,l,u)=>{const c=t.transform,h=c.pitch<15?Bd(.07,.7,Et((14-c.zoom)/5,0,1)):.07,p="none"===r.paint.get("line-trim-color-use-theme").constantOr("default");return {u_matrix:Cd(t,e,r,n),u_texsize:e.imageAtlasTexture?e.imageAtlasTexture.size:[0,0],u_pixels_to_tile_units:c.calculatePixelsToTileUnitsMatrix(e),u_device_pixel_ratio:i,u_width_scale:s,u_floor_width_scale:o,u_image:0,u_tile_units_to_pixels:Vd(e,c),u_units_to_pixels:[1/c.pixelsToGLUnits[0],1/c.pixelsToGLUnits[1]],u_alpha_discard_threshold:0,u_trim_offset:a,u_trim_fade_range:r.paint.get("line-trim-fade-range"),u_trim_color:r.paint.get("line-trim-color").toPremultipliedRenderColor(p?null:r.lut).toArray01(),u_emissive_strength:r.paint.get("line-emissive-strength"),u_zbias_factor:h,u_tile_to_meter:au(e.tileID.canonical,0),u_ground_shadow_factor:l,u_pattern_transition:u}},t.dP=(t,e,r,n,i,s,o,a,l,u)=>{const c=t.transform,h=c.calculatePixelsToTileUnitsMatrix(e),p="none"===r.paint.get("line-trim-color-use-theme").constantOr("default"),f=c.pitch<15?Bd(.07,.7,Et((14-c.zoom)/5,0,1)):.07;return {u_matrix:Cd(t,e,r,n),u_pixels_to_tile_units:h,u_device_pixel_ratio:s,u_width_scale:o,u_floor_width_scale:a,u_units_to_pixels:[1/c.pixelsToGLUnits[0],1/c.pixelsToGLUnits[1]],u_dash_image:0,u_gradient_image:1,u_image_height:i,u_texsize:Dd(r)&&e.lineAtlasTexture?e.lineAtlasTexture.size:[0,0],u_tile_units_to_pixels:Vd(e,t.transform),u_alpha_discard_threshold:0,u_trim_offset:l,u_trim_fade_range:r.paint.get("line-trim-fade-range"),u_trim_color:r.paint.get("line-trim-color").toPremultipliedRenderColor(p?null:r.lut).toArray01(),u_emissive_strength:r.paint.get("line-emissive-strength"),u_zbias_factor:f,u_tile_to_meter:au(e.tileID.canonical,0),u_ground_shadow_factor:u}},t.dQ=Lt,t.dR=xh,t.dS=ru,t.dT=Mc,t.dU=af,t.dV=mf,t.dW=Zp,t.dX=450,t.dY=7,t.dZ=Fg,t.d_=ta,t.da=function(t){const e=[],r=t.id;return void 0===r&&e.push({message:`layers.${r}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${r}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}),e},t.db=function(t,e,r,n){return "custom"===t.type?new $g(t,e):new Lx[t.type](t,e,r,n)},t.dc=Ut,t.dd=function(t){const e=t.indexOf(Ho);return e>=0?t.slice(e+1):""},t.de=class extends Zb{constructor(t,e){super(t._vectorTileFeature,t._z,t._x,t._y,t.id),t.state&&(this.state=Object.assign({},t.state)),this.target=e.target,this.namespace=e.namespace,e.properties&&(this.properties=e.properties),this.target&&("featuresetId"in this.target&&!this.target.importId||"layerId"in this.target)&&(this.source=t.source,this.sourceLayer=t.sourceLayer,this.layer=t.layer);}toJSON(){const t=super.toJSON();return t.target=this.target,t.namespace=this.namespace,t}},t.df=po,t.dg=Fe,t.dh=function(t){return t({pluginStatus:lo,pluginURL:uo}),po.on("pluginStateChange",t),t},t.di=ml,t.dj=class extends ul{constructor(t){super(t),this.current=xl;}set(t,e,r){if(this.fetchUniformLocation(t,e))for(let t=0;t<9;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix3fv(this.location,!1,r);break}}},t.dk=zt,t.dl=function(t,e,r){const n=Zc(r.zoom),i=t.style.map._antialias,s=t.terrain&&t.terrain.exaggeration()>0;return 0===n&&!i&&!s},t.dm=function(t){const e=t.pixelsPerMeter,r=e/Ql(1,t.center.lat),n=l(new Float64Array(16));return h(n,n,[t.point.x,t.point.y,0]),p(n,n,[r,r,e]),Float32Array.from(n)},t.dn=Rc,t.dp=function(t){const e=nu-5;t=Et(t,-80.051129,e)/e*90;const r=Math.pow(Math.abs(Math.sin(Mt(t))),3);return Math.round(r*(Ol.length-1))},t.dq=function(t,e,r,n){const i=e.getNorth(),s=e.getSouth(),a=e.getWest(),l=e.getEast(),u=1<<t.z,c=l-a,h=i-s,p=c/Rl,f=-h/Ol[r],d=[0,p,0,f,0,0,i,a,0];if(t.z>0){const t=180/n;o(d,d,[t/c+1,0,0,0,t/h+1,0,-.5*t/p,.5*t/f,1]);}return d[2]=u,d[5]=t.x,d[8]=t.y,d},t.dr=Cc,t.ds=function(t,e,r){const n=l(new Float64Array(16)),i=(e/(1<<t)-.5)*Math.PI*2;return d(n,r.globeMatrix,i),Float32Array.from(n)},t.dt=class{isDataAvailableAtPoint(t){const e=this._source();if(this.isUsingMockSource()||!e||t.y<0||t.y>1)return !1;const r=e.getSource().maxzoom,n=1<<r,i=Math.floor(t.x),s=Math.floor((t.x-i)*n),o=Math.floor(t.y*n),a=this.findDEMTileFor(new _c(r,i,r,s,o));return !(!a||!a.dem)}getAtPointOrZero(t,e=0){return this.getAtPoint(t,e)||0}getAtPoint(t,e,r=!0){if(this.isUsingMockSource())return null;null==e&&(e=null);const n=this._source();if(!n)return e;if(t.y<0||t.y>1)return e;const i=n.getSource().maxzoom,s=1<<i,o=Math.floor(t.x),a=t.x-o,l=new _c(i,o,i,Math.floor(a*s),Math.floor(t.y*s)),u=this.findDEMTileFor(l);if(!u||!u.dem)return e;const c=u.dem,h=1<<u.tileID.canonical.z,p=(a*h-u.tileID.canonical.x)*c.dim,f=(t.y*h-u.tileID.canonical.y)*c.dim,d=Math.floor(p),m=Math.floor(f);return (r?this.exaggeration():1)*ur(ur(c.get(d,m),c.get(d,m+1),f-m),ur(c.get(d+1,m),c.get(d+1,m+1),f-m),p-d)}getAtTileOffset(t,e,r){const n=1<<t.canonical.z;return this.getAtPointOrZero(new lu(t.wrap+(t.canonical.x+e/Cn)/n,(t.canonical.y+r/Cn)/n))}getAtTileOffsetFunc(t,e,r,n){return i=>{const s=this.getAtTileOffset(t,i.x,i.y),o=n.upVector(t.canonical,i.x,i.y);return P(o,o,s*n.upVectorScale(t.canonical,e,r).metersToTile),o}}getForTilePoints(t,e,r,n){if(this.isUsingMockSource())return !1;const i=Mx.create(this,t,n);return !!i&&(e.forEach((t=>{t[2]=this.exaggeration()*i.getElevationAt(t[0],t[1],r);})),!0)}getMinMaxForTile(t){if(this.isUsingMockSource())return null;const e=this.findDEMTileFor(t);if(!e||!e.dem)return null;const r=e.dem.tree,n=e.tileID,i=1<<t.canonical.z-n.canonical.z;let s=t.canonical.x/i-n.canonical.x,o=t.canonical.y/i-n.canonical.y,a=0;for(let e=0;e<t.canonical.z-n.canonical.z&&!r.leaves[a];e++){s*=2,o*=2;const t=2*Math.floor(o)+Math.floor(s);a=r.childOffsets[a]+t,s%=1,o%=1;}return {min:this.exaggeration()*r.minimums[a],max:this.exaggeration()*r.maximums[a]}}getMinElevationBelowMSL(){throw new Error("Pure virtual method called.")}raycast(t,e,r){throw new Error("Pure virtual method called.")}pointCoordinate(t){throw new Error("Pure virtual method called.")}_source(){throw new Error("Pure virtual method called.")}isUsingMockSource(){throw new Error("Pure virtual method called.")}exaggeration(){throw new Error("Pure virtual method called.")}findDEMTileFor(t){throw new Error("Pure virtual method called.")}get visibleDemTiles(){throw new Error("Getter must be implemented in subclass.")}getMinMaxForVisibleTiles(){const t=this.visibleDemTiles;if(0===t.length)return null;let e=!1,r=Number.MAX_VALUE,n=Number.MIN_VALUE;for(const i of t){const t=this.getMinMaxForTile(i.tileID);t&&(r=Math.min(r,t.min),n=Math.max(n,t.max),e=!0);}return e?{min:r,max:n}:null}},t.du=gh,t.dv=Pc,t.dw=function(t,e){return [Math.pow(t[0],2.2)*e,Math.pow(t[1],2.2)*e,Math.pow(t[2],2.2)*e]},t.dx=i,t.dy=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=0,t[3]=-r,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},t.dz=O,t.e=ne,t.e$=Hb,t.e0=256,t.e1=Gc,t.e2=ca,t.e3=d,t.e4=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t},t.e5=za,t.e6=ka,t.e7=cs,t.e8=function(t,e,r,n,i){return Et((t-e)/(r-e)*(i-n)+n,n,i)},t.e9=J,t.eA=function(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t[2]=e[2]/r[2],t},t.eB=$,t.eC=$l,t.eD=B,t.eE=function(t,e,r,n){return t[0]=e,t[1]=r,t[2]=n,t},t.eF=function([t,e,r]){const n=Math.hypot(t,e,r),i=Math.atan2(t,r),s=.5*Math.PI-Math.acos(-e/n);return new Hl(It(i),It(s))},t.eG=X,t.eH=Wg,t.eI=function(t){const e=t.navigator?t.navigator.userAgent:null;return !!function(t){if(null==Yt){const e=t.navigator?t.navigator.userAgent:null;Yt=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")));}return Yt}(t)&&!(!e||!(e.match("Version/15.4")||e.match("Version/15.5")||e.match(/CPU (OS|iPhone OS) (15_4|15_5) like Mac OS X/)))},t.eJ=function(t,e){ge=t,xe=e;},t.eK=Yc,t.eL=Wc,t.eM=function(t){const e=[0,0,0],r=l(new Float64Array(16));return c(r,t.pixelMatrix,t.globeMatrix),R(e,e,r),new bt(e[0],e[1])},t.eN=function(){const t=Lf;t&&(t.isPreloaded()&&1===t.numActive()?(t.release(Cf),Lf=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"));},t.eO=function(){Of().acquire(Cf);},t.eP=fo,t.eQ=function(t,e,r=!1){if(lo===oo.deferred||lo===oo.loading||lo===oo.loaded)throw new Error("setRTLTextPlugin cannot be called multiple times.");uo=fe.resolveURL(t),lo=oo.deferred,ao=e,ho(),r||mo();},t.eR=function(t){Gf=fe.resolveURL(t),Hf||(Hf=new Df(Of(),new tr)),Hf.broadcast("setMeshoptUrl",Gf);},t.eS=Kf,t.eT=function(t){jf=fe.resolveURL(t),Hf||(Hf=new Df(Of(),new tr)),Hf.broadcast("setDracoUrl",jf);},t.eU=Yf,t.eV=Vf,t.eW=function(t){const e=_e();if(!e)return;const r=e.delete(ye);t&&r.then((()=>t())).catch(t);},t.eX=Ff,t.eY=qs,t.eZ=mh,t.e_=ty,t.ea=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],o=e[4],a=e[5],l=e[6],u=e[7],c=e[8],h=c*o-a*u,p=-c*s+a*l,f=u*s-o*l,d=r*h+n*p+i*f;return d?(t[0]=h*(d=1/d),t[1]=(-c*n+i*u)*d,t[2]=(a*n-i*o)*d,t[3]=p*d,t[4]=(c*r-i*l)*d,t[5]=(-a*r+i*s)*d,t[6]=f*d,t[7]=(-u*r+n*l)*d,t[8]=(o*r-n*s)*d,t):null},t.eb=V,t.ec=su,t.ed=Qg,t.ee=function(t,e){if(t===e){var r=e[1],n=e[2],i=e[3],s=e[6],o=e[7],a=e[11];t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=s,t[11]=e[14],t[12]=i,t[13]=o,t[14]=a;}else t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15];return t},t.ef=b,t.eg=[1,1,1],t.eh=class{constructor(t,e,r,n){this.context=t,this.format=n,this.size=r,this.texture=t.gl.createTexture();const[i,s,o]=this.size,{gl:a}=t;a.bindTexture(a.TEXTURE_3D,this.texture),t.pixelStoreUnpackFlipY.set(!1),t.pixelStoreUnpack.set(1),t.pixelStoreUnpackPremultiplyAlpha.set(!1),a.texImage3D(a.TEXTURE_3D,0,this.format,i,s,o,0,zg(this.format),kg(this.format),e.data);}bind(t,e){const{context:r}=this,{gl:n}=r;n.bindTexture(n.TEXTURE_3D,this.texture),t!==this.minFilter&&(n.texParameteri(n.TEXTURE_3D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_3D,n.TEXTURE_MIN_FILTER,t),this.minFilter=t),e!==this.wrapS&&(n.texParameteri(n.TEXTURE_3D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_3D,n.TEXTURE_WRAP_T,e),this.wrapS=e);}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}},t.ei=Mx,t.ej=function(t,e,n,i){var s=new r(4);return s[0]=t,s[1]=e,s[2]=n,s[3]=i,s},t.ek=q,t.el=function(t,e,r,n){var i=e[0],s=e[1],o=e[2],a=e[3];return t[0]=i+n*(r[0]-i),t[1]=s+n*(r[1]-s),t[2]=o+n*(r[2]-o),t[3]=a+n*(r[3]-a),t},t.em=gx,t.en=xa,t.eo=Ta,t.ep=function(t,e,n,i,s,o,a,l,u,c,h,p,f,d,m,y){var g=new r(16);return g[0]=t,g[1]=e,g[2]=n,g[3]=i,g[4]=s,g[5]=o,g[6]=a,g[7]=l,g[8]=u,g[9]=c,g[10]=h,g[11]=p,g[12]=f,g[13]=d,g[14]=m,g[15]=y,g},t.eq=Gl,t.er=Ea,t.es=Pa,t.et=class{constructor(){this._updateTime=0,this._sourceIds=[],this._activeRegions=[],this._prevRegions=[],this._globalClipBounds={min:new bt(1/0,1/0),max:new bt(-1/0,-1/0)};}clear(){this._activeRegions.length>0&&++this._updateTime,this._activeRegions=[],this._prevRegions=[];}get updateTime(){return this._updateTime}getReplacementRegionsForTile(t,e=!1){const r=Cp(new bt(0,0),new bt(Cn,Cn),t),n=[];if(e&&!Bp(r,this._globalClipBounds))return n;for(const e of this._activeRegions){if(e.hiddenByOverlap)continue;if(!Bp(r,e))continue;const i=Fp(e.min,e.max,t);n.push({min:i.min,max:i.max,sourceId:this._sourceIds[e.priority],footprint:e.footprint,footprintTileId:e.tileId,order:e.order,clipMask:e.clipMask,clipScope:e.clipScope});}return n}setSources(t){this._setSources(t.map((t=>({getSourceId:()=>t.cache.id,getFootprints:()=>{const e=[];for(const r of t.cache.getVisibleCoordinates()){const n=t.cache.getTile(r).buckets[t.layer];n&&n.updateFootprints(r.toUnwrapped(),e);}return e},getOrder:()=>t.order,getClipMask:()=>t.clipMask,getClipScope:()=>t.clipScope}))));}_addSource(t){const e=t.getFootprints();if(0===e.length)return;const r=t.getOrder(),n=t.getClipMask(),i=t.getClipScope();for(const t of e){if(!t.footprint)continue;const e=Cp(t.footprint.min,t.footprint.max,t.id);this._activeRegions.push({min:e.min,max:e.max,hiddenByOverlap:!1,priority:this._sourceIds.length,tileId:t.id,footprint:t.footprint,order:r,clipMask:n,clipScope:i});}this._sourceIds.push(t.getSourceId());}_computeReplacement(){this._activeRegions.sort(((t,e)=>t.priority-e.priority||Ep(t.min,e.min)||Ep(t.max,e.max)||t.order-e.order||t.clipMask-e.clipMask||function(t,e){const r=(t,e)=>t+e;return t.length-e.length||t.reduce(r,"").localeCompare(e.reduce(r,""))}(t.clipScope,e.clipScope)));let t=this._activeRegions.length!==this._prevRegions.length;if(!t){let e=0;for(;!t&&e!==this._activeRegions.length;){const r=this._activeRegions[e],n=this._prevRegions[e];t=r.priority!==n.priority||!Tp(r,n)||r.order!==n.order||r.clipMask!==n.clipMask||!wt(r.clipScope,n.clipScope),++e;}}if(t){++this._updateTime;for(const t of this._activeRegions)t.order!==kp&&(this._globalClipBounds.min.x=Math.min(this._globalClipBounds.min.x,t.min.x),this._globalClipBounds.min.y=Math.min(this._globalClipBounds.min.y,t.min.y),this._globalClipBounds.max.x=Math.max(this._globalClipBounds.max.x,t.max.x),this._globalClipBounds.max.y=Math.max(this._globalClipBounds.max.y,t.max.y));const t=t=>{const e=this._activeRegions;if(t>=e.length)return t;const r=e[t].priority;for(;t<e.length&&e[t].priority===r;)++t;return t};if(this._sourceIds.length>1){let e=0,r=t(e);for(;e!==r;){let n=e;const i=e;for(;n!==r;){const t=this._activeRegions[n];t.hiddenByOverlap=!1;for(let e=0;e<i;e++){const r=this._activeRegions[e];if(!r.hiddenByOverlap&&t.order===kp&&Bp(t,r)&&(t.hiddenByOverlap=Lp(t.footprint,t.tileId,r.footprint,r.tileId),t.hiddenByOverlap))break}++n;}e=r,r=t(e);}}}}_setSources(t){[this._prevRegions,this._activeRegions]=[this._activeRegions,[]],this._sourceIds=[];for(let e=t.length-1;e>=0;e--)this._addSource(t[e]);this._computeReplacement();}},t.eu=kp,t.ev=class{constructor(t){this._createGrid(t),this._createPoles(t);}destroy(){this._poleIndexBuffer.destroy(),this._gridBuffer.destroy(),this._gridIndexBuffer.destroy(),this._poleNorthVertexBuffer.destroy(),this._poleSouthVertexBuffer.destroy();for(const t of this._poleSegments)t.destroy();for(const t of this._gridSegments)t.withSkirts.destroy(),t.withoutSkirts.destroy();}_fillGridMeshWithLods(t,e){const r=new ra,n=new Aa,i=[],s=t+1+2,o=e[0]+1,a=e[0]+1+(1+e.length),l=(t,e,r)=>{let n=t===s-1?t-2:0===t?t:t-1;return n+=r?24575:0,[n,e]};for(let t=0;t<s;++t)r.emplaceBack(...l(t,0,!0));for(let t=0;t<o;++t)for(let e=0;e<s;++e)r.emplaceBack(...l(e,t,(0===e||e===s-1)&&!0));for(let t=0;t<e.length;++t){const n=e[t];for(let t=0;t<s;++t)r.emplaceBack(...l(t,n,!0));}for(let t=0;t<e.length;++t){const o=n.length,l=e[t]+1+2,u=new Aa;for(let r=0;r<l-1;r++){const i=r===l-2,o=i?s*(a-e.length+t-r):s;for(let t=0;t<s-1;t++){const e=r*s+t;0===r||i||0===t||t===s-2?(u.emplaceBack(e+1,e,e+o),u.emplaceBack(e+o,e+o+1,e+1)):(n.emplaceBack(e+1,e,e+o),n.emplaceBack(e+o,e+o+1,e+1));}}const c=tl.simpleSegment(0,o,r.length,n.length-o);for(let t=0;t<u.uint16.length;t+=3)n.emplaceBack(u.uint16[t],u.uint16[t+1],u.uint16[t+2]);const h=tl.simpleSegment(0,o,r.length,n.length-o);i.push({withoutSkirts:c,withSkirts:h});}return {vertices:r,indices:n,segments:i}}_createGrid(t){const e=this._fillGridMeshWithLods(Rl,Ol);this._gridSegments=e.segments,this._gridBuffer=t.createVertexBuffer(e.vertices,kc.members),this._gridIndexBuffer=t.createIndexBuffer(e.indices,!0);}_createPoles(t){const e=new Aa;for(let t=0;t<=Rl;t++)e.emplaceBack(0,t+1,t+2);this._poleIndexBuffer=t.createIndexBuffer(e,!0);const r=new za,n=new za,i=new za,s=new za;this._poleSegments=[];for(let t=0,e=0;t<Fl;t++){const o=360/(1<<t);r.emplaceBack(0,-Cl,0,.5,0),n.emplaceBack(0,-Cl,0,.5,1),i.emplaceBack(0,-Cl,0,.5,.5),s.emplaceBack(0,-Cl,0,.5,.5);for(let t=0;t<=Rl;t++){let e=t/Rl,a=0;const l=ur(0,o,e),[u,c,h]=jl(Jc,Qc,l,Cl);r.emplaceBack(u,c,h,e,a),n.emplaceBack(u,c,h,e,1-a);const p=Mt(l);e=.5+.5*Math.sin(p),a=.5+.5*Math.cos(p),i.emplaceBack(u,c,h,e,a),s.emplaceBack(u,c,h,e,1-a);}this._poleSegments.push(tl.simpleSegment(e,0,66,64)),e+=66;}this._poleNorthVertexBuffer=t.createVertexBuffer(r,Sc,!1),this._poleSouthVertexBuffer=t.createVertexBuffer(n,Sc,!1),this._texturedPoleNorthVertexBuffer=t.createVertexBuffer(i,Sc,!1),this._texturedPoleSouthVertexBuffer=t.createVertexBuffer(s,Sc,!1);}getGridBuffers(t,e){return [this._gridBuffer,this._gridIndexBuffer,e?this._gridSegments[t].withSkirts:this._gridSegments[t].withoutSkirts]}getPoleBuffers(t,e){return [e?this._texturedPoleNorthVertexBuffer:this._poleNorthVertexBuffer,e?this._texturedPoleSouthVertexBuffer:this._poleSouthVertexBuffer,this._poleIndexBuffer,this._poleSegments[t]]}},t.ew=kt,t.ex=function(){return !!document.fullscreenElement||!!document.webkitFullscreenElement},t.ey=Pt,t.ez=ou,t.f=function(t){return btoa(encodeURIComponent(t).replace(/%([0-9A-F]{2})/g,((t,e)=>String.fromCharCode(Number("0x"+e)))))},t.f0=Wb,t.f1=Ad,t.f2=Eu,t.f3="hd_road_elevation",t.f4=Zu,t.f5=Ot,t.f6=ep,t.f7=Wm,t.f8=Xm,t.f9=function(t,e,r,n,i,s,o,a=1,l,u,c){t.createArrays(),t.tilePixelRatio=Cn/(512*t.overscaling),t.compareText={},t.iconsNeedLinear=!1;const h=t.layers[0].layout,p=t.layers[0]._unevaluatedLayout._values,f={};f.scaleFactor=a,f.textSizeScaleRange=h.get("text-size-scale-range"),f.iconSizeScaleRange=h.get("icon-size-scale-range");const[d,m]=f.textSizeScaleRange,[y,g]=f.iconSizeScaleRange;f.textScaleFactor=Et(f.scaleFactor,d,m),f.iconScaleFactor=Et(f.scaleFactor,y,g);const x=p["text-size"],v=p["icon-size"];if("composite"===t.textSizeData.kind){const{minZoom:e,maxZoom:r}=t.textSizeData;f.compositeTextSizes=[x.possiblyEvaluate(new go(e,{worldview:c}),s),x.possiblyEvaluate(new go(r,{worldview:c}),s)];}if("composite"===t.iconSizeData.kind){const{minZoom:e,maxZoom:r}=t.iconSizeData;f.compositeIconSizes=[v.possiblyEvaluate(new go(e,{worldview:c}),s),v.possiblyEvaluate(new go(r,{worldview:c}),s)];}f.layoutTextSize=x.possiblyEvaluate(new go(o+1,{worldview:c}),s),f.layoutIconSize=v.possiblyEvaluate(new go(o+1,{worldview:c}),s),f.textMaxSize=x.possiblyEvaluate(new go(18,{worldview:c}),s);const b=h.get("symbol-placement"),w="map"===h.get("text-rotation-alignment")&&"point"!==b,_=h.get("text-size");let A=!1;const M=[];for(const o of t.features){const a=h.get("text-font").evaluate(o,{},s).join(","),d=_.evaluate(o,{},s)*f.textScaleFactor,m=f.layoutTextSize.evaluate(o,{},s)*f.textScaleFactor,y=f.layoutIconSize.evaluate(o,{},s)*f.iconScaleFactor,g={horizontal:{},vertical:void 0},x=o.text;let v,I=[0,0];if(x){const n=x.toString(),u=h.get("text-letter-spacing").evaluate(o,{},s)*Jd,c=h.get("text-line-height").evaluate(o,{},s)*Jd,p=Js(n)?u:0,f=h.get("text-anchor").evaluate(o,{},s),y=h.get("text-variable-anchor");if(!y){const t=h.get("text-radial-offset").evaluate(o,{},s);if(t)I=gy(f,[t*Jd,my]);else {const t=h.get("text-offset").evaluate(o,{},s);I=[t[0]*Jd,t[1]*Jd];}}let v=w?"center":h.get("text-justify").evaluate(o,{},s);const _="point"===b,A=_?h.get("text-max-width").evaluate(o,{},s)*Jd:1/0,M=s=>{t.allowVerticalPlacement&&Ks(n)&&(g.vertical=xm(x,e,r,i,a,A,c,f,s,p,I,mm.vertical,!0,m,d,l));};if(!w&&y){const t="auto"===v?y.map((t=>Iy(t))):[v];let n=!1;for(let s=0;s<t.length;s++){const o=t[s];if(!g.horizontal[o])if(n)g.horizontal[o]=g.horizontal[0];else {const t=xm(x,e,r,i,a,A,c,"center",o,p,I,mm.horizontal,!1,m,d,l);t&&(g.horizontal[o]=t,n=1===t.positionedLines.length);}}M("left");}else {if("auto"===v&&(v=Iy(f)),_||h.get("text-writing-mode").indexOf("horizontal")>=0||!Ks(n)){const t=xm(x,e,r,i,a,A,c,f,v,p,I,mm.horizontal,!1,m,d,l);t&&(g.horizontal[v]=t);}M(_?"left":v);}}let S,z,k,P,E,T,B=!1;const V=h.get("icon-text-fit").evaluate(o,{},s);if(o.icon&&o.icon.hasPrimary()){const e=by(o.icon,t.iconSizeData,p["icon-size"],s,t.zoom,o,l,f.iconScaleFactor,c);S=e.iconPrimary,k=e.iconSecondary;const r=S.toString();if(z=n.get(r),z&&(E=h.get("icon-offset").evaluate(o,{},s),T=h.get("icon-anchor").evaluate(o,{},s),v=Pm(i.get(r),k?i.get(k.toString()):void 0,E,T),B=z.sdf,void 0===t.sdfIcons?t.sdfIcons=z.sdf:t.sdfIcons!==z.sdf&&Gt("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(z.pixelRatio!==t.pixelRatio||0!==h.get("icon-rotate").constantOr(1))&&(t.iconsNeedLinear=!0)),k){const t=k.toString();P=n.get(t);}}A=A||!(!o.icon||!o.icon.hasSecondary());const C=Ty(g.horizontal)||g.vertical;t.iconsInText||(t.iconsInText=!!C&&C.iconsInText);const F=m*f.textScaleFactor/Jd,{defaultShapedIcon:D,verticallyShapedIcon:L}=Sy(t,v,h,o,s,g,F,E,V);"none"!==V&&v&&(Tm(v)||Bm(v))&&(xy(0,z,S,v,D,V,u,n,i),xy(0,P,k,v,D,V,u,n,i),L&&(xy(0,z,S,v,L,V,u,n,i),xy(0,P,k,v,L,V,u,n,i))),v=D,M.push({feature:o,shapedTextOrientations:g,shapedText:C,shapedIcon:v,iconPrimary:S,iconSecondary:k,iconOffset:E,iconAnchor:T,verticallyShapedIcon:L,layoutTextSize:m,layoutIconSize:y,textOffset:I,isSDFIcon:B,iconTextFit:V});}return {featureData:M,sizes:f,hasAnySecondaryIcon:A,textAlongLine:w,symbolPlacement:b}},t.fa=Ym,t.fb=function(t,e,r,n,i,s,o,a,l,u){const{featureData:c,hasAnySecondaryIcon:h,sizes:p,textAlongLine:f,symbolPlacement:d}=e;for(const e of c){const{shapedIcon:r,verticallyShapedIcon:s,feature:c,shapedTextOrientations:m,shapedText:y,layoutTextSize:g,textOffset:x,isSDFIcon:v,iconPrimary:b,iconSecondary:w,iconTextFit:_,iconOffset:A}=e;_y(r,u.iconPositions,b,w),_y(s,u.iconPositions,b,w),Ay(m,u.iconPositions),wy(b,w,u.iconPositions),(y||r)&&zy(t,c,m,r,s,l,p,g,0,x,v,n,i,o,a,h,_,A,f,d);}r&&t.generateCollisionDebugBuffers(s,t.collisionBoxArray,p.textScaleFactor);},t.fc=Pu,t.fd=$v,t.fe=vt,t.ff=ku,t.fg=lm,t.fh=dt,t.fi=function(t){let e=0;if(new Uint32Array(t,0,1)[0]!==od){const r=new Uint32Array(t,0,7),[,,n,i,s,o]=r;e=r.byteLength+i+s+o+s,(n!==t.byteLength||e>=t.byteLength)&&Gt("Invalid b3dm header information.");}return pd(t,e)},t.fj=function(t,e){const r=$b(t);for(const t of r){for(const e of t.meshes)Gb(e);t.lights&&(t.lightMeshIndex=t.meshes.length,t.meshes.push(qb(t.lights,e)));}return r},t.fk=Tx,t.fl=Zt,t.fm=Bf,t.fn=yo,t.fo=oo,t.fp=function(t){Ae(),null!=be&&be.then((e=>{e.keys().then((r=>{for(let n=0;n<r.length-t;n++)e.delete(r[n]).catch((t=>Gt(t.message)));})).catch((t=>Gt(t.message)));})).catch((t=>Gt(t.message)));},t.g=function(t,e){return Fe(Ct(t,{method:"GET"}),e)},t.h=Ct,t.i=function(t){return ne.API_STYLE_REGEX.test(t)&&!se(t)},t.j=function(t){return 0===t.indexOf("mapbox:")},t.k=ie,t.l=Ie,t.m=function(t){return decodeURIComponent(atob(t).split("").map((t=>"%"+("00"+t.charCodeAt(0).toString(16)).slice(-2))).join(""))},t.n=function(t,e){return Fe(Ct(t,{type:"json"}),e)},t.o=Ne,t.p=function(t,e){return Fe(Ct(t,{method:"POST"}),e)},t.q=fe,t.r=yh,t.s=function(t){try{const e=self[t];return e.setItem("_mapbox_test_",1),e.removeItem("_mapbox_test_"),!0}catch(t){return !1}},t.t=pe,t.u=function(){return function t(e){return e?(e^Math.random()*(16>>e/4)).toString(16):([1e7]+-[1e3]+-4e3+-8e3+-1e11).replace(/[018]/g,t)}()},t.v=function(t){return !!t&&/^[0-9a-f]{8}-[0-9a-f]{4}-[4][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i.test(t)},t.w=Gt,t.x=function(){return Rf||(Rf=new Ff),Rf},t.y=Tv,t.z=Ke;}));
    
    define(["./shared"],(function(e){function t(e){const t=e?e.url.toString():void 0;return t?performance.getEntriesByName(t):[]}function s(e){if("number"==typeof e||"boolean"==typeof e||"string"==typeof e||null==e)return JSON.stringify(e);if(Array.isArray(e)){let t="[";for(const i of e)t+=`${s(i)},`;return `${t}]`}let t="{";for(const i of Object.keys(e).sort())t+=`${i}:${s(e[i])},`;return `${t}}`}function i(t){let i="";for(const o of e.bu)i+=`/${s(t[o])}`;return i}class o{constructor(e){this.keyCache={},this._layers={},this._layerConfigs={},e&&this.replace(e);}replace(e,t){this._layerConfigs={},this._layers={},this.update(e,[],t);}update(t,o,n){this._options=n;for(const s of t)this._layerConfigs[s.id]=s,(this._layers[s.id]=e.db(s,this.scope,null,this._options)).compileFilter(n),this.keyCache[s.id]&&delete this.keyCache[s.id];for(const e of o)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const r=function(e,t){const o={};for(let n=0;n<e.length;n++){const r=e[n];let a=t&&t[r.id];a||("symbol"===r.type?a=r.id:(a=i(r),"line"===r.type&&r.paint&&function e(t){return "string"==typeof t&&"line-progress"===t||(Array.isArray(t)?t.some(e):!(!t||"object"!=typeof t)&&Object.values(t).some(e))}(r.paint["line-width"])&&(a+=`/${s(r.paint["line-width"])}`))),t&&(t[r.id]=a);let l=o[a];l||(l=o[a]=[]),l.push(r);}const n=[];for(const e in o)n.push(o[e]);return n}(Object.values(this._layerConfigs),this.keyCache);for(const e of r){const t=e.map((e=>this._layers[e.id])),s=t[0];if("none"===s.visibility)continue;const i=s.source||"";let o=this.familiesBySource[i];o||(o=this.familiesBySource[i]={});const n=s.sourceLayer||"_geojsonTileLayer";let r=o[n];r||(r=o[n]=[]),r.push(t);}}}const n=1*e.e_;class r{constructor(t){const s={},i=[];for(const e in t){const o=t[e],r=s[e]={};for(const e in o.glyphs){const t=o.glyphs[+e];if(!t||0===t.bitmap.width||0===t.bitmap.height)continue;const s=t.metrics.localGlyph?n:1,a={x:0,y:0,w:t.bitmap.width+2*s,h:t.bitmap.height+2*s};i.push(a),r[e]=a;}}const{w:o,h:r}=e.H(i),a=new e.eZ({width:o||1,height:r||1});for(const i in t){const o=t[i];for(const t in o.glyphs){const r=o.glyphs[+t];if(!r||0===r.bitmap.width||0===r.bitmap.height)continue;const l=s[i][t],c=r.metrics.localGlyph?n:1;e.eZ.copy(r.bitmap,a,{x:0,y:0},{x:l.x+c,y:l.y+c},r.bitmap);}}this.image=a,this.positions=s;}}e.eY(r,"GlyphAtlas");class a{constructor(t){this.tileID=new e.aM(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.tileZoom=t.tileZoom,this.uid=t.uid,this.zoom=t.zoom,this.lut=t.lut,this.canonical=t.tileID.canonical,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.scope=t.scope,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.request&&t.request.collectResourceTiming,this.promoteId=t.promoteId,this.isSymbolTile=t.isSymbolTile,this.tileTransform=e.aW(t.tileID.canonical,t.projection),this.projection=t.projection,this.worldview=t.worldview,this.localizableLayerIds=t.localizableLayerIds,this.brightness=t.brightness,this.extraShadowCaster=!!t.extraShadowCaster,this.tessellationStep=t.tessellationStep,this.scaleFactor=t.scaleFactor,this.worldview=t.worldview;}parse(t,s,i,o,n,a){this.status="parsing",this.data=t,this.collisionBoxArray=new e.b0;const c=new e.e$(Object.keys(t.layers).sort()),h=new e.f0(this.tileID,this.promoteId);h.bucketLayerIDs=[];const u={},d=new e.f1(256,256),f={featureIndex:h,iconDependencies:new Map,patternDependencies:new Map,glyphDependencies:{},lineAtlas:d,availableImages:i,brightness:this.brightness,scaleFactor:this.scaleFactor,elevationFeatures:void 0},p=[],g=s.familiesBySource[this.source];for(const s in g){const n=t.layers[s];if(!n)continue;let r=!1,a=!1,d=!1;for(const e of g[s])"symbol"===e[0].type?r=!0:a=!0,e[0].is3D()&&"model"!==e[0].type&&(d=!0);if(this.extraShadowCaster&&!d)continue;if(!0===this.isSymbolTile&&!r)continue;if(!1===this.isSymbolTile&&!a)continue;1===n.version&&e.w(`Vector tile source "${this.source}" layer "${s}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const m=c.encode(s),y=[];let w=!1;for(let t=0,i=0;t<n.length;t++){const o=n.feature(t),r=h.getId(o,s);if(this.localizableLayerIds&&this.localizableLayerIds.has(s)){const e=o.properties?o.properties.worldview:null;if(this.worldview&&"string"==typeof e)if("all"===e)o.properties.$localized=!0;else {if(!e.split(",").includes(this.worldview))continue;o.properties.$localized=!0,o.properties.worldview=this.worldview;}}!w&&o.properties&&o.properties.hasOwnProperty(e.f2)&&(w=!0),y.push({feature:o,id:r,index:i,sourceLayerIndex:m}),i++;}w&&!f.elevationFeatures&&t.layers.hasOwnProperty(e.f3)&&(f.elevationFeatures=e.f4.parseFrom(t.layers[e.f3],this.canonical));for(const t of g[s]){const s=t[0];if(this.extraShadowCaster&&(!s.is3D()||"model"===s.type))continue;if(void 0!==this.isSymbolTile&&"symbol"===s.type!==this.isSymbolTile)continue;if(s.minzoom&&this.zoom<Math.floor(s.minzoom))continue;if(s.maxzoom&&this.zoom>=s.maxzoom)continue;if("none"===s.visibility)continue;l(t,this.zoom,f.brightness,i,this.worldview);const n=u[s.id]=s.createBucket({index:h.bucketLayerIDs.length,layers:t,zoom:this.zoom,lut:this.lut,canonical:this.canonical,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:m,sourceID:this.source,projection:this.projection.spec,tessellationStep:this.tessellationStep,styleDefinedModelURLs:o,worldview:this.worldview});h.bucketLayerIDs.push(t.map((t=>e.C(t.id,t.scope))));let r=n.prepare?n.prepare():null;null!=r?(r=r.then((()=>n.populate(y,f,this.tileID.canonical,this.tileTransform))),p.push(r)):n.populate(y,f,this.tileID.canonical,this.tileTransform);}}const m=()=>{let s,o,p,g,m,y;d.trim();const w={type:"maybePrepare",isSymbolTile:this.isSymbolTile,zoom:this.zoom},v=()=>{if(s)return this.status="done",a(s);if(this.extraShadowCaster)this.status="done",a(null,{buckets:Object.values(u).filter((e=>!e.isEmpty())),featureIndex:h,collisionBoxArray:null,glyphAtlasImage:null,lineAtlas:null,imageAtlas:null,brightness:f.brightness,glyphMap:null,iconMap:null,glyphPositions:null});else if(o&&p&&g){const t=new r(o),s=new Map;for(const[t,i]of p.entries()){const{imagePosition:o}=e.f7(t,i,e.f8);s.set(t,o);}const a={};for(const n in u){const r=u[n];r instanceof e.b1&&(l(r.layers,this.zoom,f.brightness,i,this.worldview),a[n]=e.f9(r,o,t.positions,p,s,this.tileID.canonical,this.tileZoom,this.scaleFactor,this.pixelRatio,m,this.worldview));}const c={iconsPending:!0,patternsPending:!0};this.rasterizeIfNeeded(n,p,m,(()=>{c.iconsPending=!1,x(a,t,c);})),this.rasterizeIfNeeded(n,g,y,(()=>{c.patternsPending=!1,x(a,t,c);}));}},x=(t,s,o,n)=>{if(o.iconsPending||o.patternsPending)return;const r=new e.fa(p,g,this.lut);for(const s in u){const o=u[s];if(s in t)e.fb(o,t[s],this.showCollisionBoxes,i,this.tileID.canonical,this.tileZoom,this.projection,this.brightness,p,r);else if(o.hasPattern&&(o instanceof e.b7||o instanceof e.b8||o instanceof e.dU)){l(o.layers,this.zoom,f.brightness,i,this.worldview);const e=Object.fromEntries(r.patternPositions);o.addFeatures(f,this.tileID.canonical,e,i,this.tileTransform,this.brightness);}}this.status="done",a(null,{buckets:Object.values(u).filter((e=>!e.isEmpty())),featureIndex:h,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:s.image,lineAtlas:d,imageAtlas:r,brightness:f.brightness});};if(!this.extraShadowCaster){const t=e.f5(f.glyphDependencies,(e=>Object.keys(e).map(Number)));Object.keys(t).length?n.send("getGlyphs",{uid:this.uid,stacks:t,scope:this.scope},((e,t)=>{s||(s=e,o=t,v());}),void 0,!1,w):o={};const i=Array.from(f.iconDependencies.keys()).map((t=>e.I.parse(t)));i.length?n.send("getImages",{images:i,source:this.source,scope:this.scope,tileID:this.tileID,type:"icons"},((e,t)=>{s||(s=e,p=new Map,m=this.updateImageMapAndGetImageTaskQueue(p,t,f.iconDependencies),v());}),void 0,!1,w):(p=new Map,m=new Map);const r=Array.from(f.patternDependencies.keys()).map((t=>e.I.parse(t)));r.length?n.send("getImages",{images:r,source:this.source,scope:this.scope,tileID:this.tileID,type:"patterns"},((e,t)=>{s||(s=e,g=new Map,y=this.updateImageMapAndGetImageTaskQueue(g,t,f.patternDependencies),v());}),void 0,!1,w):(g=new Map,y=new Map);}if(f.elevationFeatures&&f.elevationFeatures.length>0){const s=[];for(const t of Object.values(u))if(t instanceof e.b8){const e=t.getUnevaluatedPortalGraph();e&&s.push(e);}const i=e.f6.evaluate(s);for(const s of Object.values(u))if(s instanceof e.b8){const e=t.layers[c.decode(s.sourceLayerIndex)];s.setEvaluatedPortalGraph(i,e,this.tileID.canonical,f.availableImages,f.brightness);}}v();};p.length>0?Promise.allSettled(p).then(m).catch(a):m();}rasterizeIfNeeded(e,t,s,i){Array.from(t.values()).some((e=>e.usvg))?this.rasterize(e,t,s,i):i();}updateImageMapAndGetImageTaskQueue(e,t,s){const i=new Map;for(const o of t.keys()){const n=s.get(o)||[];for(const s of n){const o=s.toString(),n=t.get(s.id.toString());n.usvg?i.has(o)||(i.set(o,s),e.set(o,Object.assign({},n))):e.set(o,n);}}return i}rasterize(e,t,s,i){this.rasterizeTask=e.send("rasterizeImages",{scope:this.scope,tasks:s},((e,s)=>{if(!e)for(const[e,i]of s.entries()){const s=Object.assign(t.get(e),{data:i});t.set(e,s);}i();}));}cancelRasterize(){this.rasterizeTask&&this.rasterizeTask.cancel();}}function l(t,s,i,o,n){const r=new e.aa(s,{brightness:i,worldview:n});for(const e of t)e.recalculate(r,o);}class c extends e.E{constructor(t,s,i,o,n,r,a){super(),this.actor=t,this.layerIndex=s,this.availableImages=i,this.availableModels=o,this.loadVectorData=r||e.aJ,this.loading={},this.loaded={},this.deduped=new e.aI(t.scheduler),this.isSpriteLoaded=n,this.scheduler=t.scheduler,this.brightness=a;}loadTile(s,i){const o=s.uid,n=s&&s.request,r=n&&n.collectResourceTiming,l=this.loading[o]=new a(s);l.abort=this.loadVectorData(s,((a,c)=>{const h=!this.loading[o];if(delete this.loading[o],l.cancelRasterize(),h||a||!c)return l.status="done",h||(this.loaded[o]=l),i(a);const u=c.rawData,d={};c.expires&&(d.expires=c.expires),c.cacheControl&&(d.cacheControl=c.cacheControl),l.vectorTile=c.vectorTile||new e.fc.VectorTile(new e.bq(u));const f=()=>{l.parse(l.vectorTile,this.layerIndex,this.availableImages,this.availableModels,this.actor,((s,o)=>{if(s||!o)return i(s);const a={};if(r){const e=t(n);e.length>0&&(a.resourceTiming=JSON.parse(JSON.stringify(e)));}i(null,e.h({rawTileData:u.slice(0)},o,d,a));}));};this.isSpriteLoaded?f():this.once("isSpriteLoaded",(()=>{this.scheduler?this.scheduler.add(f,{type:"parseTile",isSymbolTile:s.isSymbolTile,zoom:s.tileZoom}):f();})),this.loaded=this.loaded||{},this.loaded[o]=l;}));}reloadTile(t,s){const i=this.loaded,o=t.uid;if(i&&i[o]){const n=i[o];n.scaleFactor=t.scaleFactor,n.showCollisionBoxes=t.showCollisionBoxes,n.projection=t.projection,n.brightness=t.brightness,n.tileTransform=e.aW(t.tileID.canonical,t.projection),n.extraShadowCaster=t.extraShadowCaster,n.lut=t.lut,n.worldview=t.worldview;const r=(e,t)=>{const i=n.reloadCallback;i&&(delete n.reloadCallback,n.parse(n.vectorTile,this.layerIndex,this.availableImages,this.availableModels,this.actor,i)),s(e,t);};"parsing"===n.status?n.reloadCallback=r:"done"===n.status&&(n.vectorTile?n.parse(n.vectorTile,this.layerIndex,this.availableImages,this.availableModels,this.actor,r):r());}else s(null,void 0);}abortTile(e,t){const s=e.uid,i=this.loading[s];i&&(i.abort&&i.abort(),delete this.loading[s]),t();}removeTile(e,t){const s=this.loaded,i=e.uid;s&&s[i]&&delete s[i],t();}}class h{loadTile(t,s){const{uid:i,encoding:o,rawImageData:n,padding:r}=t,a=ImageBitmap&&n instanceof ImageBitmap?this.getImageData(n,r):n;s(null,new e.fd(i,a,o,r<1));}reloadTile(e,t){t(null,null);}abortTile(e,t){t();}removeTile(e,t){t();}getImageData(e,t){this.offscreenCanvas&&this.offscreenCanvasContext||(this.offscreenCanvas=new OffscreenCanvas(e.width,e.height),this.offscreenCanvasContext=this.offscreenCanvas.getContext("2d",{willReadFrequently:!0})),this.offscreenCanvas.width=e.width,this.offscreenCanvas.height=e.height,this.offscreenCanvasContext.drawImage(e,0,0,e.width,e.height);const s=this.offscreenCanvasContext.getImageData(-t,-t,e.width+2*t,e.height+2*t);return this.offscreenCanvasContext.clearRect(0,0,this.offscreenCanvas.width,this.offscreenCanvas.height),s}}e.bp.setPbf(e.bq);class u{constructor(t){this._mrt=new e.bp(t.partial?30:1/0),this._isHeaderLoaded=!1,this.uid=t.uid,this.tileID=t.tileID,this.source=t.source;}parse(t,s){const i=this._mrt;this.status="parsing",this._entireBuffer=t;try{i.parseHeader(t),this._isHeaderLoaded=!0;const o=[];for(const s in i.layers){const n=i.getLayer(s),r=n.getDataRange(n.getBandList()),a=i.createDecodingTask(r),l=t.slice(r.firstByte,r.lastByte+1),c=e.bp.performDecoding(l,a).then((e=>a.complete(null,e))).catch((e=>a.complete(e,null)));o.push(c);}Promise.allSettled(o).then((()=>s(null,i))).catch((e=>s(e)));}catch(e){s(e);}}}class d{constructor(e){this.actor=e,this.loading={},this.loaded={};}loadTile(t,s){const i=t.uid,o=t.request,n=this.loading[i]=new u(t),{cancel:r}=e.br(o,((e,t,o,r)=>{const a=!this.loading[i];if(delete this.loading[i],a||e||!t)return n.status="done",a||(this.loaded[i]=n),s(e);n.parse(t,((e,t)=>{if(e||!t)return s(e);s(null,t,o,r);})),this.loaded[i]=n;}));n.abort=r;}reloadTile(e,t){t(null,void 0);}abortTile(e,t){const s=e.uid,i=this.loading[s];i&&(i.abort&&i.abort(),delete this.loading[s]),t();}removeTile(e,t){const s=e.uid;this.loaded[s]&&delete this.loaded[s],t();}decodeRasterArray(t,s){e.bp.performDecoding(t.buffer,t.task).then((e=>s(null,e))).catch((e=>s(e)));}}const f=e.fc.VectorTileFeature.prototype.toGeoJSON;class p{constructor(t){this._feature=t,this.extent=e.aj,this.type=t.type,this.properties=t.tags,"id"in t&&!isNaN(t.id)&&(this.id=parseInt(t.id,10));}loadGeometry(){if(1===this._feature.type){const t=[];for(const s of this._feature.geometry)t.push([new e.P(s[0],s[1])]);return t}{const t=[];for(const s of this._feature.geometry){const i=[];for(const t of s)i.push(new e.P(t[0],t[1]));t.push(i);}return t}}toGeoJSON(e,t,s){return f.call(this,e,t,s)}}class g{constructor(t){this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.extent=e.aj,this.length=t.length,this._features=t;}feature(e){return new p(this._features[e])}}class m{constructor(t,s){this.name=t,this.extent=e.aj,this.length=s.length,this._features=s;}feature(e){return new p(this._features[e])}}class y extends g{constructor(e){super([]),this.layers={};for(const t in e)this.layers[t]=new m(t,e[t]);}}const w=64/4096,v=128;class x{constructor(){this.features=new Map;}clear(){this.features.clear();}load(e=[],t){for(const s of e){const e=s.id;if(null==e)continue;let i=this.features.get(e);i&&this.updateCache(i,t),s.geometry?(i=I(s),this.updateCache(i,t),this.features.set(e,i)):this.features.delete(e),this.updateCache(i,t);}}updateCache(e,t){for(const{canonical:s,uid:i}of Object.values(t)){const{z:o,x:n,y:r}=s;b(e,Math.pow(2,o),n,r)&&delete t[i];}}getTile(e,t,s){const i=Math.pow(2,e),o=[];for(const e of this.features.values())b(e,i,t,s)&&o.push(T(e,i,t,s));return {features:o}}getFeatures(){return [...this.features.values()]}}function b({minX:e,minY:t,maxX:s,maxY:i},o,n,r){return e<(n+1+w)/o&&t<(r+1+w)/o&&s>(n-w)/o&&i>(r-w)/o}function I(e){const{id:t,geometry:s,properties:i}=e;if(!s)return;if("GeometryCollection"===s.type)throw new Error("GeometryCollection not supported in dynamic mode.");const{type:o,coordinates:n}=s,r={id:t,type:1,geometry:[],tags:i,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0},a=r.geometry;if("Point"===o)S(n,a,r);else if("MultiPoint"===o)for(const e of n)S(e,a,r);else if("LineString"===o)r.type=2,M(n,a,r);else if("MultiLineString"===o)r.type=2,P(n,a,r);else if("Polygon"===o)r.type=3,P(n,a,r,!0);else {if("MultiPolygon"!==o)throw new Error("Input data is not a valid GeoJSON object.");r.type=3;for(const e of n)P(e,a,r,!0);}return r}function S([t,s],i,o){const n=e.aD(t);let r=e.aH(s);r=r<0?0:r>1?1:r,i.push(n,r),o.minX=Math.min(o.minX,n),o.minY=Math.min(o.minY,r),o.maxX=Math.max(o.maxX,n),o.maxY=Math.max(o.maxY,r);}function M(e,t,s,i=!1,o=!1){const n=[];for(const t of e)S(t,n,s);t.push(n),i&&function(e,t){let s=0;for(let t=0,i=e.length,o=i-2;t<i;o=t,t+=2)s+=(e[t]-e[o])*(e[t+1]+e[o+1]);if(s>0===t)for(let t=0,s=e.length;t<s/2;t+=2){const i=e[t],o=e[t+1];e[t]=e[s-2-t],e[t+1]=e[s-1-t],e[s-2-t]=i,e[s-1-t]=o;}}(n,o);}function P(e,t,s,i=!1){for(let o=0;o<e.length;o++)M(e[o],t,s,i,0===o);}function T(t,s,i,o){const{id:n,type:r,geometry:a,tags:l}=t,c=[];if(1===r)!function(t,s,i,o,n){for(let r=0;r<t.length;r+=2){const a=Math.round(e.aj*(t[r+0]*s-i)),l=Math.round(e.aj*(t[r+1]*s-o));n.push([a,l]);}}(a,s,i,o,c);else for(const e of a)k(e,s,i,o,c);return {id:n,type:r,geometry:c,tags:l}}function k(t,s,i,o,n){const r=-128,a=e.aj+v;let l;for(let c=0;c<t.length-2;c+=2){let h=Math.round(e.aj*(t[c+0]*s-i)),u=Math.round(e.aj*(t[c+1]*s-o)),d=Math.round(e.aj*(t[c+2]*s-i)),f=Math.round(e.aj*(t[c+3]*s-o));const p=d-h,g=f-u;h<r&&d<r||(h<r?(u+=Math.round(g*((r-h)/p)),h=r):d<r&&(f=u+Math.round(g*((r-h)/p)),d=r),u<r&&f<r||(u<r?(h+=Math.round(p*((r-u)/g)),u=r):f<r&&(d=h+Math.round(p*((r-u)/g)),f=r),h>=a&&d>=a||(h>=a?(u+=Math.round(g*((a-h)/p)),h=a):d>=a&&(f=u+Math.round(g*((a-h)/p)),d=a),u>=a&&f>=a||(u>=a?(h+=Math.round(p*((a-u)/g)),u=a):f>=a&&(d=h+Math.round(p*((a-u)/g)),f=a),l&&h===l[l.length-1][0]&&u===l[l.length-1][1]||(l=[[h,u]],n.push(l)),l.push([d,f])))));}}var L,_,C,j={exports:{}},D=function(){if(C)return j.exports;C=1;var t=e.fg(),s=function(){if(_)return L;_=1;var t=e.fe(),s=e.ff().VectorTileFeature;function i(e,t){this.options=t||{},this.features=e,this.length=e.length;}function o(e,t){this.id="number"==typeof e.id?e.id:void 0,this.type=e.type,this.rawGeometry=1===e.type?[e.geometry]:e.geometry,this.properties=e.tags,this.extent=t||4096;}return L=i,i.prototype.feature=function(e){return new o(this.features[e],this.options.extent)},o.prototype.loadGeometry=function(){var e=this.rawGeometry;this.geometry=[];for(var s=0;s<e.length;s++){for(var i=e[s],o=[],n=0;n<i.length;n++)o.push(new t(i[n][0],i[n][1]));this.geometry.push(o);}return this.geometry},o.prototype.bbox=function(){this.geometry||this.loadGeometry();for(var e=this.geometry,t=1/0,s=-1/0,i=1/0,o=-1/0,n=0;n<e.length;n++)for(var r=e[n],a=0;a<r.length;a++){var l=r[a];t=Math.min(t,l.x),s=Math.max(s,l.x),i=Math.min(i,l.y),o=Math.max(o,l.y);}return [t,i,s,o]},o.prototype.toGeoJSON=s.prototype.toGeoJSON,L}();function i(e){var s=new t;return function(e,t){for(var s in e.layers)t.writeMessage(3,o,e.layers[s]);}(e,s),s.finish()}function o(e,t){var s;t.writeVarintField(15,e.version||1),t.writeStringField(1,e.name||""),t.writeVarintField(5,e.extent||4096);var i={keys:[],values:[],keycache:{},valuecache:{}};for(s=0;s<e.length;s++)i.feature=e.feature(s),t.writeMessage(2,n,i);var o=i.keys;for(s=0;s<o.length;s++)t.writeStringField(3,o[s]);var r=i.values;for(s=0;s<r.length;s++)t.writeMessage(4,h,r[s]);}function n(e,t){var s=e.feature;void 0!==s.id&&t.writeVarintField(1,s.id),t.writeMessage(2,r,e),t.writeVarintField(3,s.type),t.writeMessage(4,c,s);}function r(e,t){var s=e.feature,i=e.keys,o=e.values,n=e.keycache,r=e.valuecache;for(var a in s.properties){var l=s.properties[a],c=n[a];if(null!==l){void 0===c&&(i.push(a),n[a]=c=i.length-1),t.writeVarint(c);var h=typeof l;"string"!==h&&"boolean"!==h&&"number"!==h&&(l=JSON.stringify(l));var u=h+":"+l,d=r[u];void 0===d&&(o.push(l),r[u]=d=o.length-1),t.writeVarint(d);}}}function a(e,t){return (t<<3)+(7&e)}function l(e){return e<<1^e>>31}function c(e,t){for(var s=e.loadGeometry(),i=e.type,o=0,n=0,r=s.length,c=0;c<r;c++){var h=s[c],u=1;1===i&&(u=h.length),t.writeVarint(a(1,u));for(var d=3===i?h.length-1:h.length,f=0;f<d;f++){1===f&&1!==i&&t.writeVarint(a(2,d-1));var p=h[f].x-o,g=h[f].y-n;t.writeVarint(l(p)),t.writeVarint(l(g)),o+=p,n+=g;}3===i&&t.writeVarint(a(7,1));}}function h(e,t){var s=typeof e;"string"===s?t.writeStringField(1,e):"boolean"===s?t.writeBooleanField(7,e):"number"===s&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e));}return j.exports=i,j.exports.fromVectorTileJs=i,j.exports.fromGeojsonVt=function(e,t){t=t||{};var o={};for(var n in e)o[n]=new s(e[n].features,t),o[n].name=n,o[n].version=t.version,o[n].extent=t.extent;return i({layers:o})},j.exports.GeoJSONWrapper=s,j.exports}(),z=e.fh(D);const O={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},F=Math.fround||(A=new Float32Array(1),e=>(A[0]=+e,A[0]));var A;const Z=3,N=5,B=6;class R{constructor(e){this.options=Object.assign(Object.create(O),e),this.trees=new Array(this.options.maxZoom+1),this.stride=this.options.reduce?7:6,this.clusterProps=[];}load(e){const{log:t,minZoom:s,maxZoom:i}=this.options;t&&console.time("total time");const o=`prepare ${e.length} points`;t&&console.time(o),this.points=e;const n=[];for(let t=0;t<e.length;t++){const s=e[t];if(!s.geometry)continue;const[i,o]=s.geometry.coordinates,r=F(Y(i)),a=F(G(o));n.push(r,a,1/0,t,-1,1),this.options.reduce&&n.push(0);}let r=this.trees[i+1]=this._createTree(n);t&&console.timeEnd(o);for(let e=i;e>=s;e--){const s=+Date.now();r=this.trees[e]=this._createTree(this._cluster(r,e)),t&&console.log("z%d: %d clusters in %dms",e,r.numItems,+Date.now()-s);}return t&&console.timeEnd("total time"),this}getClusters(e,t){let s=((e[0]+180)%360+360)%360-180;const i=Math.max(-90,Math.min(90,e[1]));let o=180===e[2]?180:((e[2]+180)%360+360)%360-180;const n=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)s=-180,o=180;else if(s>o){const e=this.getClusters([s,i,180,n],t),r=this.getClusters([-180,i,o,n],t);return e.concat(r)}const r=this.trees[this._limitZoom(t)],a=r.range(Y(s),G(n),Y(o),G(i)),l=r.data,c=[];for(const e of a){const t=this.stride*e;c.push(l[t+N]>1?X(l,t,this.clusterProps):this.points[l[t+Z]]);}return c}getChildren(e){const t=this._getOriginId(e),s=this._getOriginZoom(e),i="No cluster with the specified id.",o=this.trees[s];if(!o)throw new Error(i);const n=o.data;if(t*this.stride>=n.length)throw new Error(i);const r=this.options.radius/(this.options.extent*Math.pow(2,s-1)),a=o.within(n[t*this.stride],n[t*this.stride+1],r),l=[];for(const t of a){const s=t*this.stride;n[s+4]===e&&l.push(n[s+N]>1?X(n,s,this.clusterProps):this.points[n[s+Z]]);}if(0===l.length)throw new Error(i);return l}getLeaves(e,t,s){const i=[];return this._appendLeaves(i,e,t=t||10,s=s||0,0),i}getTile(e,t,s){const i=this.trees[this._limitZoom(e)],o=Math.pow(2,e),{extent:n,radius:r}=this.options,a=r/n,l=(s-a)/o,c=(s+1+a)/o,h={features:[]};return this._addTileFeatures(i.range((t-a)/o,l,(t+1+a)/o,c),i.data,t,s,o,h),0===t&&this._addTileFeatures(i.range(1-a/o,l,1,c),i.data,o,s,o,h),t===o-1&&this._addTileFeatures(i.range(0,l,a/o,c),i.data,-1,s,o,h),h.features.length?h:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const s=this.getChildren(e);if(t++,1!==s.length)break;e=s[0].properties.cluster_id;}return t}_appendLeaves(e,t,s,i,o){const n=this.getChildren(t);for(const t of n){const n=t.properties;if(n&&n.cluster?o+n.point_count<=i?o+=n.point_count:o=this._appendLeaves(e,n.cluster_id,s,i,o):o<i?o++:e.push(t),e.length===s)break}return o}_createTree(t){const s=new e.bW(t.length/this.stride|0,this.options.nodeSize,Float32Array);for(let e=0;e<t.length;e+=this.stride)s.add(t[e],t[e+1]);return s.finish(),s.data=t,s}_addTileFeatures(e,t,s,i,o,n){for(const r of e){const e=r*this.stride,a=t[e+N]>1;let l,c,h;if(a)l=E(t,e,this.clusterProps),c=t[e],h=t[e+1];else {const s=this.points[t[e+Z]];l=s.properties;const[i,o]=s.geometry.coordinates;c=Y(i),h=G(o);}const u={type:1,geometry:[[Math.round(this.options.extent*(c*o-s)),Math.round(this.options.extent*(h*o-i))]],tags:l};let d;d=a||this.options.generateId?t[e+Z]:this.points[t[e+Z]].id,void 0!==d&&(u.id=d),n.features.push(u);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(Math.floor(+e),this.options.maxZoom+1))}_cluster(e,t){const{radius:s,extent:i,reduce:o,minPoints:n}=this.options,r=s/(i*Math.pow(2,t)),a=e.data,l=[],c=this.stride;for(let s=0;s<a.length;s+=c){if(a[s+2]<=t)continue;a[s+2]=t;const i=a[s],h=a[s+1],u=e.within(a[s],a[s+1],r),d=a[s+N];let f=d;for(const e of u){const s=e*c;a[s+2]>t&&(f+=a[s+N]);}if(f>d&&f>=n){let e,n=i*d,r=h*d,p=-1;const g=(s/c<<5)+(t+1)+this.points.length;for(const i of u){const l=i*c;if(a[l+2]<=t)continue;a[l+2]=t;const h=a[l+N];n+=a[l]*h,r+=a[l+1]*h,a[l+4]=g,o&&(e||(e=this._map(a,s,!0),p=this.clusterProps.length,this.clusterProps.push(e)),o(e,this._map(a,l)));}a[s+4]=g,l.push(n/f,r/f,1/0,g,-1,f),o&&l.push(p);}else {for(let e=0;e<c;e++)l.push(a[s+e]);if(f>1)for(const e of u){const s=e*c;if(!(a[s+2]<=t)){a[s+2]=t;for(let e=0;e<c;e++)l.push(a[s+e]);}}}}return l}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return (e-this.points.length)%32}_map(e,t,s){if(e[t+N]>1){const i=this.clusterProps[e[t+B]];return s?Object.assign({},i):i}const i=this.points[e[t+Z]].properties,o=this.options.map(i);return s&&o===i?Object.assign({},o):o}}function X(e,t,s){return {type:"Feature",id:e[t+Z],properties:E(e,t,s),geometry:{type:"Point",coordinates:[(i=e[t],360*(i-.5)),J(e[t+1])]}};var i;}function E(e,t,s){const i=e[t+N],o=i>=1e4?`${Math.round(i/1e3)}k`:i>=1e3?Math.round(i/100)/10+"k":i,n=e[t+B],r=-1===n?{}:Object.assign({},s[n]);return Object.assign(r,{cluster:!0,cluster_id:e[t+Z],point_count:i,point_count_abbreviated:o})}function Y(e){return e/360+.5}function G(e){const t=Math.sin(e*Math.PI/180),s=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return s<0?0:s>1?1:s}function J(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}function V(e,t,s,i){let o=i;const n=t+(s-t>>1);let r,a=s-t;const l=e[t],c=e[t+1],h=e[s],u=e[s+1];for(let i=t+3;i<s;i+=3){const t=$(e[i],e[i+1],l,c,h,u);if(t>o)r=i,o=t;else if(t===o){const e=Math.abs(i-n);e<a&&(r=i,a=e);}}o>i&&(r-t>3&&V(e,t,r,i),e[r+2]=o,s-r>3&&V(e,r,s,i));}function $(e,t,s,i,o,n){let r=o-s,a=n-i;if(0!==r||0!==a){const l=((e-s)*r+(t-i)*a)/(r*r+a*a);l>1?(s=o,i=n):l>0&&(s+=r*l,i+=a*l);}return r=e-s,a=t-i,r*r+a*a}function U(e,t,s,i){const o={id:e??null,type:t,geometry:s,tags:i,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};if("Point"===t||"MultiPoint"===t||"LineString"===t)W(o,s);else if("Polygon"===t)W(o,s[0]);else if("MultiLineString"===t)for(const e of s)W(o,e);else if("MultiPolygon"===t)for(const e of s)W(o,e[0]);return o}function W(e,t){for(let s=0;s<t.length;s+=3)e.minX=Math.min(e.minX,t[s]),e.minY=Math.min(e.minY,t[s+1]),e.maxX=Math.max(e.maxX,t[s]),e.maxY=Math.max(e.maxY,t[s+1]);}function q(e,t,s,i){if(!t.geometry)return;const o=t.geometry.coordinates;if(o&&0===o.length)return;const n=t.geometry.type,r=Math.pow(s.tolerance/((1<<s.maxZoom)*s.extent),2);let a=[],l=t.id;if(s.promoteId?l=t.properties[s.promoteId]:s.generateId&&(l=i||0),"Point"===n)H(o,a);else if("MultiPoint"===n)for(const e of o)H(e,a);else if("LineString"===n)Q(o,a,r,!1);else if("MultiLineString"===n){if(s.lineMetrics){for(const s of o)a=[],Q(s,a,r,!1),e.push(U(l,"LineString",a,t.properties));return}K(o,a,r,!1);}else if("Polygon"===n)K(o,a,r,!0);else {if("MultiPolygon"!==n){if("GeometryCollection"===n){for(const o of t.geometry.geometries)q(e,{id:l,geometry:o,properties:t.properties},s,i);return}throw new Error("Input data is not a valid GeoJSON object.")}for(const e of o){const t=[];K(e,t,r,!0),a.push(t);}}e.push(U(l,n,a,t.properties));}function H(e,t){t.push(ee(e[0]),te(e[1]),0);}function Q(e,t,s,i){let o,n,r=0;for(let s=0;s<e.length;s++){const a=ee(e[s][0]),l=te(e[s][1]);t.push(a,l,0),s>0&&(r+=i?(o*l-a*n)/2:Math.sqrt(Math.pow(a-o,2)+Math.pow(l-n,2))),o=a,n=l;}const a=t.length-3;t[2]=1,V(t,0,a,s),t[a+2]=1,t.size=Math.abs(r),t.start=0,t.end=t.size;}function K(e,t,s,i){for(let o=0;o<e.length;o++){const n=[];Q(e[o],n,s,i),t.push(n);}}function ee(e){return e/360+.5}function te(e){const t=Math.sin(e*Math.PI/180),s=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return s<0?0:s>1?1:s}function se(e,t,s,i,o,n,r,a){if(i/=t,n>=(s/=t)&&r<i)return e;if(r<s||n>=i)return null;const l=[];for(const t of e){const e=t.geometry;let n=t.type;const r=0===o?t.minX:t.minY,c=0===o?t.maxX:t.maxY;if(r>=s&&c<i){l.push(t);continue}if(c<s||r>=i)continue;let h=[];if("Point"===n||"MultiPoint"===n)ie(e,h,s,i,o);else if("LineString"===n)oe(e,h,s,i,o,!1,a.lineMetrics);else if("MultiLineString"===n)re(e,h,s,i,o,!1);else if("Polygon"===n)re(e,h,s,i,o,!0);else if("MultiPolygon"===n)for(const t of e){const e=[];re(t,e,s,i,o,!0),e.length&&h.push(e);}if(h.length){if(a.lineMetrics&&"LineString"===n){for(const e of h)l.push(U(t.id,n,e,t.tags));continue}"LineString"!==n&&"MultiLineString"!==n||(1===h.length?(n="LineString",h=h[0]):n="MultiLineString"),"Point"!==n&&"MultiPoint"!==n||(n=3===h.length?"Point":"MultiPoint"),l.push(U(t.id,n,h,t.tags));}}return l.length?l:null}function ie(e,t,s,i,o){for(let n=0;n<e.length;n+=3){const r=e[n+o];r>=s&&r<=i&&ae(t,e[n],e[n+1],e[n+2]);}}function oe(e,t,s,i,o,n,r){let a=ne(e);const l=0===o?le:ce;let c,h,u=e.start;for(let d=0;d<e.length-3;d+=3){const f=e[d],p=e[d+1],g=e[d+2],m=e[d+3],y=e[d+4],w=0===o?f:p,v=0===o?m:y;let x=!1;r&&(c=Math.sqrt(Math.pow(f-m,2)+Math.pow(p-y,2))),w<s?v>s&&(h=l(a,f,p,m,y,s),r&&(a.start=u+c*h)):w>i?v<i&&(h=l(a,f,p,m,y,i),r&&(a.start=u+c*h)):ae(a,f,p,g),v<s&&w>=s&&(h=l(a,f,p,m,y,s),x=!0),v>i&&w<=i&&(h=l(a,f,p,m,y,i),x=!0),!n&&x&&(r&&(a.end=u+c*h),t.push(a),a=ne(e)),r&&(u+=c);}let d=e.length-3;const f=e[d],p=e[d+1],g=0===o?f:p;g>=s&&g<=i&&ae(a,f,p,e[d+2]),d=a.length-3,n&&d>=3&&(a[d]!==a[0]||a[d+1]!==a[1])&&ae(a,a[0],a[1],a[2]),a.length&&t.push(a);}function ne(e){const t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t}function re(e,t,s,i,o,n){for(const r of e)oe(r,t,s,i,o,n,!1);}function ae(e,t,s,i){e.push(t,s,i);}function le(e,t,s,i,o,n){const r=(n-t)/(i-t);return ae(e,n,s+(o-s)*r,1),r}function ce(e,t,s,i,o,n){const r=(n-s)/(o-s);return ae(e,t+(i-t)*r,n,1),r}function he(e,t){const s=[];for(let i=0;i<e.length;i++){const o=e[i],n=o.type;let r;if("Point"===n||"MultiPoint"===n||"LineString"===n)r=ue(o.geometry,t);else if("MultiLineString"===n||"Polygon"===n){r=[];for(const e of o.geometry)r.push(ue(e,t));}else if("MultiPolygon"===n){r=[];for(const e of o.geometry){const s=[];for(const i of e)s.push(ue(i,t));r.push(s);}}s.push(U(o.id,n,r,o.tags));}return s}function ue(e,t){const s=[];s.size=e.size,void 0!==e.start&&(s.start=e.start,s.end=e.end);for(let i=0;i<e.length;i+=3)s.push(e[i]+t,e[i+1],e[i+2]);return s}function de(e,t){if(e.transformed)return e;const s=1<<e.z,i=e.x,o=e.y;for(const n of e.features){const e=n.geometry,r=n.type;if(n.geometry=[],1===r)for(let r=0;r<e.length;r+=2)n.geometry.push(fe(e[r],e[r+1],t,s,i,o));else for(let r=0;r<e.length;r++){const a=[];for(let n=0;n<e[r].length;n+=2)a.push(fe(e[r][n],e[r][n+1],t,s,i,o));n.geometry.push(a);}}return e.transformed=!0,e}function fe(e,t,s,i,o,n){return [Math.round(s*(e*i-o)),Math.round(s*(t*i-n))]}function pe(e,t,s,i,o){const n=t===o.maxZoom?0:o.tolerance/((1<<t)*o.extent),r={features:[],numPoints:0,numSimplified:0,numFeatures:e.length,source:null,x:s,y:i,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0};for(const t of e)ge(r,t,n,o);return r}function ge(e,t,s,i){const o=t.geometry,n=t.type,r=[];if(e.minX=Math.min(e.minX,t.minX),e.minY=Math.min(e.minY,t.minY),e.maxX=Math.max(e.maxX,t.maxX),e.maxY=Math.max(e.maxY,t.maxY),"Point"===n||"MultiPoint"===n)for(let t=0;t<o.length;t+=3)r.push(o[t],o[t+1]),e.numPoints++,e.numSimplified++;else if("LineString"===n)me(r,o,e,s,!1,!1);else if("MultiLineString"===n||"Polygon"===n)for(let t=0;t<o.length;t++)me(r,o[t],e,s,"Polygon"===n,0===t);else if("MultiPolygon"===n)for(let t=0;t<o.length;t++){const i=o[t];for(let t=0;t<i.length;t++)me(r,i[t],e,s,!0,0===t);}if(r.length){let s=t.tags||null;if("LineString"===n&&i.lineMetrics){s={};for(const e in t.tags)s[e]=t.tags[e];s.mapbox_clip_start=o.start/o.size,s.mapbox_clip_end=o.end/o.size;}const a={geometry:r,type:"Polygon"===n||"MultiPolygon"===n?3:"LineString"===n||"MultiLineString"===n?2:1,tags:s};null!==t.id&&(a.id=t.id),e.features.push(a);}}function me(e,t,s,i,o,n){const r=i*i;if(i>0&&t.size<(o?r:i))return void(s.numPoints+=t.length/3);const a=[];for(let e=0;e<t.length;e+=3)(0===i||t[e+2]>r)&&(s.numSimplified++,a.push(t[e],t[e+1])),s.numPoints++;o&&function(e,t){let s=0;for(let t=0,i=e.length,o=i-2;t<i;o=t,t+=2)s+=(e[t]-e[o])*(e[t+1]+e[o+1]);if(s>0===t)for(let t=0,s=e.length;t<s/2;t+=2){const i=e[t],o=e[t+1];e[t]=e[s-2-t],e[t+1]=e[s-1-t],e[s-2-t]=i,e[s-1-t]=o;}}(a,n),e.push(a);}const ye={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0};class we{constructor(e,t){const s=(t=this.options=function(e,t){for(const s in t)e[s]=t[s];return e}(Object.create(ye),t)).debug;if(s&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");let i=function(e,t){const s=[];if("FeatureCollection"===e.type)for(let i=0;i<e.features.length;i++)q(s,e.features[i],t,i);else q(s,"Feature"===e.type?e:{geometry:e},t);return s}(e,t);this.tiles={},this.tileCoords=[],s&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),i=function(e,t){const s=t.buffer/t.extent;let i=e;const o=se(e,1,-1-s,s,0,-1,2,t),n=se(e,1,1-s,2+s,0,-1,2,t);return (o||n)&&(i=se(e,1,-s,1+s,0,-1,2,t)||[],o&&(i=he(o,1).concat(i)),n&&(i=i.concat(he(n,-1)))),i}(i,t),i.length&&this.splitTile(i,0,0,0),s&&(i.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}splitTile(e,t,s,i,o,n,r){const a=[e,t,s,i],l=this.options,c=l.debug;for(;a.length;){i=a.pop(),s=a.pop(),t=a.pop(),e=a.pop();const h=1<<t,u=ve(t,s,i);let d=this.tiles[u];if(!d&&(c>1&&console.time("creation"),d=this.tiles[u]=pe(e,t,s,i,l),this.tileCoords.push({z:t,x:s,y:i}),c)){c>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,s,i,d.numFeatures,d.numPoints,d.numSimplified),console.timeEnd("creation"));const e=`z${t}`;this.stats[e]=(this.stats[e]||0)+1,this.total++;}if(d.source=e,null==o){if(t===l.indexMaxZoom||d.numPoints<=l.indexMaxPoints)continue}else {if(t===l.maxZoom||t===o)continue;if(null!=o){const e=o-t;if(s!==n>>e||i!==r>>e)continue}}if(d.source=null,0===e.length)continue;c>1&&console.time("clipping");const f=.5*l.buffer/l.extent,p=.5-f,g=.5+f,m=1+f;let y=null,w=null,v=null,x=null,b=se(e,h,s-f,s+g,0,d.minX,d.maxX,l),I=se(e,h,s+p,s+m,0,d.minX,d.maxX,l);e=null,b&&(y=se(b,h,i-f,i+g,1,d.minY,d.maxY,l),w=se(b,h,i+p,i+m,1,d.minY,d.maxY,l),b=null),I&&(v=se(I,h,i-f,i+g,1,d.minY,d.maxY,l),x=se(I,h,i+p,i+m,1,d.minY,d.maxY,l),I=null),c>1&&console.timeEnd("clipping"),a.push(y||[],t+1,2*s,2*i),a.push(w||[],t+1,2*s,2*i+1),a.push(v||[],t+1,2*s+1,2*i),a.push(x||[],t+1,2*s+1,2*i+1);}}getTile(e,t,s){e=+e,t=+t,s=+s;const i=this.options,{extent:o,debug:n}=i;if(e<0||e>24)return null;const r=1<<e,a=ve(e,t=t+r&r-1,s);if(this.tiles[a])return de(this.tiles[a],o);n>1&&console.log("drilling down to z%d-%d-%d",e,t,s);let l,c=e,h=t,u=s;for(;!l&&c>0;)c--,h>>=1,u>>=1,l=this.tiles[ve(c,h,u)];return l&&l.source?(n>1&&(console.log("found parent tile z%d-%d-%d",c,h,u),console.time("drilling down")),this.splitTile(l.source,c,h,u,e,t,s),n>1&&console.timeEnd("drilling down"),this.tiles[a]?de(this.tiles[a],o):null):null}}function ve(e,t,s){return 32*((1<<e)*s+t)+e}function xe(e,t){const s=e.tileID.canonical;if(!this._geoJSONIndex)return void t(null,null);const i=this._geoJSONIndex.getTile(s.z,s.x,s.y);if(!i)return void t(null,null);const o=e=>e.tags&&"3d_elevation_id"in e.tags&&"source"in e.tags&&"elevation"===e.tags.source,n=i.features.filter((e=>o(e)));let r;if(n.length>0){const e=i.features.filter((e=>!o(e)));r=new y({_geojsonTileLayer:e,hd_road_elevation:n});}else r=new g(i.features);let a=z(r);0===a.byteOffset&&a.byteLength===a.buffer.byteLength||(a=new Uint8Array(a)),t(null,{vectorTile:r,rawData:a.buffer});}class be extends c{constructor(e,t,s,i,o,n,r){super(e,t,s,i,o,xe,r),n&&(this.loadGeoJSON=n),this._dynamicIndex=new x;}loadData(s,i){const o=s&&s.request,n=o&&o.collectResourceTiming;this.loadGeoJSON(s,((r,a)=>{if(r||!a)return i(r);if("object"!=typeof a)return i(new Error(`Input data given to '${s.source}' is not a valid GeoJSON object.`));{try{if(s.filter){const t=e.X(s.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===t.result)throw new Error(t.value.map((e=>`${e.key}: ${e.message}`)).join(", "));a.features=a.features.filter((e=>t.value.evaluate({zoom:0},e)));}s.dynamic?("Feature"===a.type&&(a={type:"FeatureCollection",features:[a]}),s.append||(this._dynamicIndex.clear(),this.loaded={}),this._dynamicIndex.load(a.features,this.loaded),s.cluster&&(a.features=this._dynamicIndex.getFeatures())):this.loaded={},this._geoJSONIndex=s.cluster?new R(function({superclusterOptions:t,clusterProperties:s}){if(!s||!t)return t;const i={},o={},n={accumulated:null,zoom:0},r={properties:null},a=Object.keys(s);for(const t of a){const[n,r]=s[t],a=e.X(r),l=e.X("string"==typeof n?[n,["accumulated"],["get",t]]:n);i[t]=a.value,o[t]=l.value;}return t.map=e=>{r.properties=e;const t={};for(const e of a)t[e]=i[e].evaluate(n,r);return t},t.reduce=(e,t)=>{r.properties=t;for(const t of a)n.accumulated=e[t],e[t]=o[t].evaluate(n,r);},t}(s)).load(a.features):s.dynamic?this._dynamicIndex:function(e,t){return new we(e,t)}(a,s.geojsonVtOptions);}catch(e){return i(e)}const r={};if(n){const e=t(o);e&&(r.resourceTiming={},r.resourceTiming[s.source]=JSON.parse(JSON.stringify(e)));}i(null,r);}}));}reloadTile(e,t){const s=this.loaded;return s&&s[e.uid]?e.partial?t(null,void 0):super.reloadTile(e,t):this.loadTile(e,t)}loadGeoJSON(t,s){if(t.request)e.n(t.request,s);else {if("string"!=typeof t.data)return s(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`));try{return s(null,JSON.parse(t.data))}catch(e){return s(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`))}}}getClusterExpansionZoom(e,t){try{t(null,this._geoJSONIndex.getClusterExpansionZoom(e.clusterId));}catch(e){t(e);}}getClusterChildren(e,t){try{t(null,this._geoJSONIndex.getChildren(e.clusterId));}catch(e){t(e);}}getClusterLeaves(e,t){try{t(null,this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset));}catch(e){t(e);}}}class Ie{constructor(t,s,i){this.tileID=new e.aM(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.tileZoom=t.tileZoom,this.uid=t.uid,this.zoom=t.zoom,this.canonical=t.tileID.canonical,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.projection=t.projection,this.brightness=s,this.worldview=i;}parse(t,s,i,o){this.status="parsing";const n=new e.aM(i.tileID.overscaledZ,i.tileID.wrap,i.tileID.canonical.z,i.tileID.canonical.x,i.tileID.canonical.y),r=[],a=s.familiesBySource[i.source],l=new e.f0(n,i.promoteId);l.bucketLayerIDs=[],l.is3DTile=!0,e.fi(t).then((t=>{if(!t)return o(new Error("Could not parse tile"));const s=t.json.extensionsUsed&&t.json.extensionsUsed.includes("MAPBOX_mesh_features")||t.json.asset.extras&&t.json.asset.extras.MAPBOX_mesh_features,c=t.json.extensionsUsed&&t.json.extensionsUsed.includes("EXT_meshopt_compression"),h=new e.aa(this.zoom,{brightness:this.brightness,worldview:this.worldview});for(const o in a)for(const u of a[o]){const o=u[0];l.bucketLayerIDs.push(u.map((t=>e.C(t.id,t.scope)))),o.recalculate(h,[]);const a=e.fj(t,1/e.cU(i.tileID.canonical)),d=new e.fk(u,a,n,s,c,this.brightness,l,this.worldview);s||(d.needsUpload=!0),r.push(d),d.evaluate(o);}this.status="done",o(null,{buckets:r,featureIndex:l,collisionBoxArray:null,glyphAtlasImage:null,lineAtlas:null,imageAtlas:null,brightness:null});})).catch((e=>o(new Error(e.message))));}}class Se{constructor(e,t,s,i,o,n,r,a){this.actor=e,this.layerIndex=t,this.availableImages=s,this.availableModels=i,this.brightness=r,this.loading={},this.loaded={},this.worldview=a;}loadTile(t,s){const i=t.uid,o=this.loading[i]=new Ie(t,this.brightness,this.worldview);e.br(t.request,((e,n)=>{const r=!this.loading[i];return delete this.loading[i],r||e?(o.status="done",r||(this.loaded[i]=o),s(e)):n&&0!==n.byteLength?void o.parse(n,this.layerIndex,t,((e,t)=>{o.status="done",this.loaded=this.loaded||{},this.loaded[i]=o,e||!t?s(e):s(null,t);})):(o.status="done",this.loaded[i]=o,s())}));}reloadTile(e,t){const s=this.loaded,i=e.uid;if(s&&s[i]){const o=s[i];o.projection=e.projection,o.brightness=e.brightness;const n=(s,i)=>{o.reloadCallback&&(delete o.reloadCallback,this.loadTile(e,t)),t(s,i);};"parsing"===o.status?o.reloadCallback=n:"done"===o.status&&this.loadTile(e,t);}}abortTile(e,t){const s=e.uid;this.loading[s]&&delete this.loading[s],t();}removeTile(e,t){const s=this.loaded,i=e.uid;s&&s[i]&&delete s[i],t();}}class Me{constructor(t){this.self=t,this.actor=new e.fm(t,this),this.layerIndexes={},this.availableImages={},this.availableModels={},this.isSpriteLoaded={},this.imageRasterizer=new e.y,this.rtlPluginParsingListeners=[],this.projections={},this.defaultProjection=e.ce({name:"mercator"}),this.workerSourceTypes={vector:c,geojson:be,"raster-dem":h,"raster-array":d,"batched-model":Se},this.workerSources={},this.self.registerWorkerSource=(e,t)=>{if(this.workerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.workerSourceTypes[e]=t;},this.self.registerRTLTextPlugin=t=>{if(e.fn.isParsed())throw new Error("RTL text plugin already registered.");e.fn.setState({pluginStatus:e.fo.parsed,pluginURL:e.fn.getPluginURL()}),e.fn.applyArabicShaping=t.applyArabicShaping,e.fn.processBidirectionalText=t.processBidirectionalText,e.fn.processStyledBidirectionalText=t.processStyledBidirectionalText;for(const e of this.rtlPluginParsingListeners)e(null,!0);this.rtlPluginParsingListeners=[];};}clearCaches(e,t,s){delete this.layerIndexes[e],delete this.availableImages[e],delete this.availableModels[e],delete this.workerSources[e],s();}checkIfReady(e,t,s){s();}setReferrer(e,t){this.referrer=t;}spriteLoaded(t,s){this.isSpriteLoaded[t]||(this.isSpriteLoaded[t]={});const{scope:i,isLoaded:o}=s;if(this.isSpriteLoaded[t][i]=o,this.workerSources[t]&&this.workerSources[t][i])for(const s in this.workerSources[t][i]){const n=this.workerSources[t][i][s];for(const t in n){const s=n[t];s instanceof c&&(s.isSpriteLoaded=o,s.fire(new e.A("isSpriteLoaded")));}}}setImages(e,t,s){this.availableImages[e]||(this.availableImages[e]={});const{scope:i,images:o}=t;if(this.availableImages[e][i]=o,this.workerSources[e]&&this.workerSources[e][i]){for(const t in this.workerSources[e][i]){const s=this.workerSources[e][i][t];for(const e in s)s[e].availableImages=o;}s();}else s();}setModels(e,{scope:t,models:s},i){if(this.availableModels[e]||(this.availableModels[e]={}),this.availableModels[e][t]=s,this.workerSources[e]&&this.workerSources[e][t]){for(const i in this.workerSources[e][t]){const o=this.workerSources[e][t][i];for(const e in o)o[e].availableModels=s;}i();}else i();}setProjection(t,s){this.projections[t]=e.ce(s);}setBrightness(e,t,s){this.brightness=t,s();}setWorldview(e,t,s){this.worldview=t,s();}setLayers(e,t,s){this.getLayerIndex(e,t.scope).replace(t.layers,t.options),s();}updateLayers(e,t,s){this.getLayerIndex(e,t.scope).update(t.layers,t.removedIds,t.options),s();}loadTile(e,t,s){t.projection=this.projections[e]||this.defaultProjection,this.getWorkerSource(e,t.type,t.source,t.scope).loadTile(t,s);}decodeRasterArray(e,t,s){this.getWorkerSource(e,t.type,t.source,t.scope).decodeRasterArray(t,s);}reloadTile(e,t,s){t.projection=this.projections[e]||this.defaultProjection,this.getWorkerSource(e,t.type,t.source,t.scope).reloadTile(t,s);}abortTile(e,t,s){this.getWorkerSource(e,t.type,t.source,t.scope).abortTile(t,s);}removeTile(e,t,s){this.getWorkerSource(e,t.type,t.source,t.scope).removeTile(t,s);}removeSource(e,t,s){if(!(this.workerSources[e]&&this.workerSources[e][t.scope]&&this.workerSources[e][t.scope][t.type]&&this.workerSources[e][t.scope][t.type][t.source]))return;const i=this.workerSources[e][t.scope][t.type][t.source];delete this.workerSources[e][t.scope][t.type][t.source],void 0!==i.removeSource?i.removeSource(t,s):s();}loadWorkerSource(e,t,s){try{this.self.importScripts(t.url),s();}catch(e){s(e.toString());}}syncRTLPluginState(t,s,i){if(e.fn.isParsed())i(null,!0);else if(e.fn.isParsing())this.rtlPluginParsingListeners.push(i);else try{e.fn.setState(s);const t=e.fn.getPluginURL();!e.fn.isLoaded()||e.fn.isParsed()||e.fn.isParsing()||null==t||(e.fn.setState({pluginStatus:e.fo.parsing,pluginURL:e.fn.getPluginURL()}),this.self.importScripts(t),e.fn.isParsed()?i(null,!0):this.rtlPluginParsingListeners.push(i));}catch(e){i(e.toString());}}setDracoUrl(e,t){this.dracoUrl=t;}getAvailableImages(e,t){this.availableImages[e]||(this.availableImages[e]={});let s=this.availableImages[e][t];return s||(s=[]),s}getAvailableModels(e,t){this.availableModels[e]||(this.availableModels[e]={});let s=this.availableModels[e][t];return s||(s={}),s}getLayerIndex(e,t){this.layerIndexes[e]||(this.layerIndexes[e]={});let s=this.layerIndexes[e][t];return s||(s=this.layerIndexes[e][t]=new o,s.scope=t),s}getWorkerSource(e,t,s,i){const o=this.workerSources;return o[e]||(o[e]={}),o[e][i]||(o[e][i]={}),o[e][i][t]||(o[e][i][t]={}),this.isSpriteLoaded[e]||(this.isSpriteLoaded[e]={}),o[e][i][t][s]||(o[e][i][t][s]=new this.workerSourceTypes[t]({send:(t,s,i,o,n,r)=>this.actor.send(t,s,i,e,n,r),scheduler:this.actor.scheduler},this.getLayerIndex(e,i),this.getAvailableImages(e,i),this.getAvailableModels(e,i),this.isSpriteLoaded[e][i],void 0,this.brightness,this.worldview)),o[e][i][t][s]}rasterizeImagesWorker(e,t,s){const i=new Map;for(const[s,{image:o,imageVariant:n}]of t.tasks.entries()){const r=this.imageRasterizer.rasterize(n,o,t.scope,e);i.set(s,r);}s(void 0,i);}removeRasterizedImages(e,t,s){this.imageRasterizer.removeImagesFromCacheByIds(t.imageIds,t.scope,e),s();}enforceCacheSizeLimit(t,s){e.fp(s);}getWorkerPerformanceMetrics(e,t,s){s(void 0,void 0);}}return e.fl(self)&&(self.worker=new Me(self)),Me}));
    
    define(["./shared"],(function(e){var t="3.13.0";const i={create:"create",load:"load",fullLoad:"fullLoad"},o={mark(e){performance.mark(e);},measure(e,t,i){performance.measure(e,t,i);}};function s(t){const i=t.name.split("?")[0];return e.a(i)&&i.includes("mapbox-gl.js")?"javascript":e.a(i)&&i.includes("mapbox-gl.css")?"css":e.b(i)?"fontRange":e.c(i)?"sprite":e.i(i)?"style":e.d(i)?"tilejson":"other"}var r,n={},a=function(){if(r)return n;function e(e){return !t(e)}function t(t){return "undefined"==typeof window||"undefined"==typeof document?"not a browser":function(){if(!("Worker"in window&&"Blob"in window&&"URL"in window))return !1;var e,t,i=new Blob([""],{type:"text/javascript"}),o=URL.createObjectURL(i);try{t=new Worker(o),e=!0;}catch(t){e=!1;}return t&&t.terminate(),URL.revokeObjectURL(o),e}()?function(){var e=document.createElement("canvas");e.width=e.height=1;var t=e.getContext("2d");if(!t)return !1;var i=t.getImageData(0,0,1,1);return i&&i.width===e.width}()?(void 0===i[o=t&&t.failIfMajorPerformanceCaveat]&&(i[o]=function(t){var i,o=function(t){var i=document.createElement("canvas"),o=Object.create(e.webGLContextAttributes);return o.failIfMajorPerformanceCaveat=t,i.getContext("webgl2",o)}(t);if(!o)return !1;try{i=o.createShader(o.VERTEX_SHADER);}catch(e){return !1}return !(!i||o.isContextLost())&&(o.shaderSource(i,"void main() {}"),o.compileShader(i),!0===o.getShaderParameter(i,o.COMPILE_STATUS))}(o)),i[o]?document.documentMode?"insufficient ECMAScript 6 support":void 0:"insufficient WebGL2 support"):"insufficient Canvas/getImageData support":"insufficient worker support";var o;}r=1,n.supported=e,n.notSupportedReason=t;var i={};return e.webGLContextAttributes={antialias:!1,alpha:!0,stencil:!0,depth:!0},n}();function l(e,t,i){const o=document.createElement(e);return null!=t&&(o.className=t),i&&i.appendChild(o),o}function c(e,t,i){const o=document.createElementNS("http://www.w3.org/2000/svg",e);for(const e of Object.keys(t))o.setAttributeNS(null,e,String(t[e]));return i&&i.appendChild(o),o}const h="undefined"!=typeof document?document.documentElement&&document.documentElement.style:null,d=h&&void 0!==h.userSelect?"userSelect":"WebkitUserSelect";let u;function _(){h&&d&&(u=h[d],h[d]="none");}function p(){h&&d&&(h[d]=u);}function f(e){e.preventDefault(),e.stopPropagation(),window.removeEventListener("click",f,!0);}function m(){window.addEventListener("click",f,!0),window.setTimeout((()=>{window.removeEventListener("click",f,!0);}),0);}function g(e,t){const i=e.getBoundingClientRect();return x(e,i,t)}function v(e,t){const i=e.getBoundingClientRect(),o=[];for(let s=0;s<t.length;s++)o.push(x(e,i,t[s]));return o}function y(e){return /firefox/i.test(navigator.userAgent)&&/macintosh/i.test(navigator.userAgent)&&2===e.button&&e.ctrlKey?0:e.button}function x(t,i,o){const s=t.offsetWidth===i.width?1:t.offsetWidth/i.width;return new e.P((o.clientX-i.left)*s,(o.clientY-i.top)*s)}const b="01",w="NO_ACCESS_TOKEN";class T{constructor(e,t,i){this._transformRequestFn=e,this._customAccessToken=t,this._silenceAuthErrors=!!i,this._createSkuToken();}_createSkuToken(){const e=function(){let e="";for(let t=0;t<10;t++)e+="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"[Math.floor(62*Math.random())];return {token:["1",b,e].join(""),tokenExpiresAt:Date.now()+432e5}}();this._skuToken=e.token,this._skuTokenExpiresAt=e.tokenExpiresAt;}_isSkuTokenExpired(){return Date.now()>this._skuTokenExpiresAt}transformRequest(e,t){return this._transformRequestFn&&this._transformRequestFn(e,t)||{url:e}}normalizeStyleURL(i,o){if(!e.j(i))return i;const s=S(i);return s.params.push(`sdk=js-${t}`),s.path=`/styles/v1${s.path}`,this._makeAPIURL(s,this._customAccessToken||o)}normalizeGlyphsURL(t,i){if(!e.j(t))return t;const o=S(t);return o.path=`/fonts/v1${o.path}`,this._makeAPIURL(o,this._customAccessToken||i)}normalizeModelURL(t,i){if(!e.j(t))return t;const o=S(t);return o.path=`/models/v1${o.path}`,this._makeAPIURL(o,this._customAccessToken||i)}normalizeSourceURL(t,i,o,s){if(!e.j(t))return t;const r=S(t);return r.path=`/v4/${r.authority}.json`,r.params.push("secure"),o&&r.params.push(`language=${o}`),s&&r.params.push(`worldview=${s}`),this._makeAPIURL(r,this._customAccessToken||i)}normalizeIconsetURL(t,i){const o=S(t);return e.j(t)?(o.path=`/styles/v1${o.path}/iconset.pbf`,this._makeAPIURL(o,this._customAccessToken||i)):I(o)}normalizeSpriteURL(t,i,o,s){const r=S(t);return e.j(t)?(r.path=`/styles/v1${r.path}/sprite${i}${o}`,this._makeAPIURL(r,this._customAccessToken||s)):(r.path+=`${i}${o}`,I(r))}normalizeTileURL(t,i,o){if(this._isSkuTokenExpired()&&this._createSkuToken(),t&&!e.j(t))return t;const s=S(t);s.path=s.path.replace(/(\.(png|jpg)\d*)(?=$)/,`${i||o&&"raster"!==s.authority&&512===o?"@2x":""}${e.l.supported?".webp":"$1"}`),"raster"===s.authority?s.path=`/${e.e.RASTER_URL_PREFIX}${s.path}`:"rasterarrays"===s.authority?s.path=`/${e.e.RASTERARRAYS_URL_PREFIX}${s.path}`:"3dtiles"===s.authority?s.path=`/${e.e.TILES3D_URL_PREFIX}${s.path}`:(s.path=s.path.replace(/^.+\/v4\//,"/"),s.path=`/${e.e.TILE_URL_VERSION}${s.path}`);const r=this._customAccessToken||function(e){for(const t of e){const e=t.match(/^access_token=(.*)$/);if(e)return e[1]}return null}(s.params)||e.e.ACCESS_TOKEN;return e.e.REQUIRE_ACCESS_TOKEN&&r&&this._skuToken&&s.params.push(`sku=${this._skuToken}`),this._makeAPIURL(s,r)}canonicalizeTileURL(t,i){const o=S(t);if(!o.path.match(/^(\/v4\/|\/(raster|rasterarrays)\/v1\/)/)||!o.path.match(/\.[\w]+$/))return t;let s="mapbox://";o.path.match(/^\/raster\/v1\//)?s+=`raster/${o.path.replace(`/${e.e.RASTER_URL_PREFIX}/`,"")}`:o.path.match(/^\/rasterarrays\/v1\//)?s+=`rasterarrays/${o.path.replace(`/${e.e.RASTERARRAYS_URL_PREFIX}/`,"")}`:s+=`tiles/${o.path.replace(`/${e.e.TILE_URL_VERSION}/`,"")}`;let r=o.params;return i&&(r=r.filter((e=>!e.match(/^access_token=/)))),r.length&&(s+=`?${r.join("&")}`),s}canonicalizeTileset(t,i){const o=!!i&&e.j(i),s=[];for(const i of t.tiles||[])e.k(i)?s.push(this.canonicalizeTileURL(i,o)):s.push(i);return s}_makeAPIURL(t,i){const o="See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes",s=S(e.e.API_URL);if(t.protocol=s.protocol,t.authority=s.authority,"http"===t.protocol){const e=t.params.indexOf("secure");e>=0&&t.params.splice(e,1);}if("/"!==s.path&&(t.path=`${s.path}${t.path}`),!e.e.REQUIRE_ACCESS_TOKEN)return I(t);if(i=i||e.e.ACCESS_TOKEN,!this._silenceAuthErrors){if(!i)throw new Error(`An API access token is required to use Mapbox GL. ${o}`);if("s"===i[0])throw new Error(`Use a public access token (pk.*) with Mapbox GL, not a secret access token (sk.*). ${o}`)}return t.params=t.params.filter((e=>-1===e.indexOf("access_token"))),t.params.push(`access_token=${i||""}`),I(t)}}const E=/^(\w+):\/\/([^/?]*)(\/[^?]+)?\??(.+)?/;function S(e){const t=e.match(E);if(!t)throw new Error("Unable to parse URL object");return {protocol:t[1],authority:t[2],path:t[3]||"/",params:t[4]?t[4].split("&"):[]}}function I(e){const t=e.params.length?`?${e.params.join("&")}`:"";return `${e.protocol}://${e.authority}${e.path}${t}`}const C="mapbox.eventData";function R(t){if(!t)return null;const i=t.split(".");if(!i||3!==i.length)return null;try{return JSON.parse(e.m(i[1]))}catch(e){return null}}class D{constructor(e){this.type=e,this.anonId=null,this.eventData={},this.queue=[],this.pendingRequest=null;}getStorageKey(t){const i=R(e.e.ACCESS_TOKEN);let o="";return o=i&&i.u?e.f(i.u):e.e.ACCESS_TOKEN||"",t?`${C}.${t}:${o}`:`${C}:${o}`}fetchEventData(){const t=e.s("localStorage"),i=this.getStorageKey(),o=this.getStorageKey("uuid");if(t)try{const e=localStorage.getItem(i);e&&(this.eventData=JSON.parse(e));const t=localStorage.getItem(o);t&&(this.anonId=t);}catch(t){e.w("Unable to read from LocalStorage");}}saveEventData(){const t=e.s("localStorage"),i=this.getStorageKey(),o=this.getStorageKey("uuid"),s=this.anonId;if(t&&s)try{localStorage.setItem(o,s),Object.keys(this.eventData).length>=1&&localStorage.setItem(i,JSON.stringify(this.eventData));}catch(t){e.w("Unable to write to LocalStorage");}}processRequests(e){}postEvent(t,i,o,s){if(!e.e.EVENTS_URL)return;const r=S(e.e.EVENTS_URL);r.params.push(`access_token=${s||e.e.ACCESS_TOKEN||""}`);const n={event:this.type,created:new Date(t).toISOString()},a=i?e.h(n,i):n,l={url:I(r),headers:{"Content-Type":"text/plain"},body:JSON.stringify([a])};this.pendingRequest=e.p(l,(e=>{this.pendingRequest=null,o(e),this.saveEventData(),this.processRequests(s);}));}queueRequest(e,t){this.queue.push(e),this.processRequests(t);}}const A=new class extends D{constructor(e){super("appUserTurnstile"),this._customAccessToken=e;}postTurnstileEvent(t,i){e.e.EVENTS_URL&&e.e.ACCESS_TOKEN&&Array.isArray(t)&&t.some((t=>e.j(t)||e.k(t)))&&this.queueRequest(Date.now(),i);}processRequests(i){if(this.pendingRequest||0===this.queue.length)return;this.anonId&&this.eventData.lastSuccess&&this.eventData.tokenU||this.fetchEventData();const o=R(e.e.ACCESS_TOKEN),s=o?o.u:e.e.ACCESS_TOKEN;let r=s!==this.eventData.tokenU;e.v(this.anonId)||(this.anonId=e.u(),r=!0);const n=this.queue.shift();if(this.eventData.lastSuccess){const e=new Date(this.eventData.lastSuccess),t=new Date(n),i=(n-this.eventData.lastSuccess)/864e5;r=r||i>=1||i<-1||e.getDate()!==t.getDate();}else r=!0;r?this.postEvent(n,{sdkIdentifier:"mapbox-gl-js",sdkVersion:t,skuId:b,"enabled.telemetry":!1,userId:this.anonId},(e=>{e||(this.eventData.lastSuccess=n,this.eventData.tokenU=s);}),i):this.processRequests();}},L=A.postTurnstileEvent.bind(A),P=new class extends D{constructor(){super("map.load"),this.success={},this.skuToken="";}postMapLoadEvent(t,i,o,s){this.skuToken=i,this.errorCb=s,e.e.EVENTS_URL&&(o||e.e.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},o):this.errorCb(new Error(w)));}processRequests(i){if(this.pendingRequest||0===this.queue.length)return;const{id:o,timestamp:s}=this.queue.shift();o&&this.success[o]||(this.anonId||this.fetchEventData(),e.v(this.anonId)||(this.anonId=e.u()),this.postEvent(s,{sdkIdentifier:"mapbox-gl-js",sdkVersion:t,skuId:b,skuToken:this.skuToken,userId:this.anonId},(e=>{e?this.errorCb(e):o&&(this.success[o]=!0);}),i));}remove(){this.errorCb=null;}},z=P.postMapLoadEvent.bind(P),M=new class extends D{constructor(){super("style.load"),this.eventIdPerMapInstanceMap=new Map,this.mapInstanceIdMap=new WeakMap;}getMapInstanceId(t){let i=this.mapInstanceIdMap.get(t);return i||(i=e.u(),this.mapInstanceIdMap.set(t,i)),i}getEventId(e){const t=this.eventIdPerMapInstanceMap.get(e)||0;return this.eventIdPerMapInstanceMap.set(e,t+1),t}postStyleLoadEvent(t,i){const{map:o,style:s,importedStyles:r}=i;if(!e.e.EVENTS_URL||!t&&!e.e.ACCESS_TOKEN)return;const n=this.getMapInstanceId(o),a={mapInstanceId:n,eventId:this.getEventId(n),style:s};r.length&&(a.importedStyles=r),this.queueRequest({timestamp:Date.now(),payload:a},t);}processRequests(e){if(this.pendingRequest||0===this.queue.length)return;const{timestamp:t,payload:i}=this.queue.shift();this.postEvent(t,i,(()=>{}),e);}},O=M.postStyleLoadEvent.bind(M),F=new class extends D{constructor(){super("gljs.performance");}postPerformanceEvent(t,i){e.e.EVENTS_URL&&(t||e.e.ACCESS_TOKEN)&&this.queueRequest({timestamp:Date.now(),performanceData:i},t);}processRequests(o){if(this.pendingRequest||0===this.queue.length)return;const{timestamp:r,performanceData:n}=this.queue.shift(),a=function(o){const r=performance.getEntriesByType("resource"),n=performance.getEntriesByType("mark"),a=function(e){const t={};if(e)for(const i in e)if("other"!==i)for(const o of e[i]){const e=`${i}ResolveRangeMin`,s=`${i}ResolveRangeMax`,r=`${i}RequestCount`,n=`${i}RequestCachedCount`;t[e]=Math.min(t[e]||1/0,o.startTime),t[s]=Math.max(t[s]||-1/0,o.responseEnd);const a=e=>{void 0===t[e]&&(t[e]=0),++t[e];};void 0!==o.transferSize&&0===o.transferSize&&a(n),a(r);}return t}(function(e,t){const i={};if(e)for(const o of e){const e=t(o);void 0===i[e]&&(i[e]=[]),i[e].push(o);}return i}(r,s)),l=window.devicePixelRatio,c=navigator.connection||navigator.mozConnection||navigator.webkitConnection,h=c?c.effectiveType:void 0,d={counters:[],metadata:[],attributes:[]},u=(e,t,i)=>{null!=i&&e.push({name:t,value:i.toString()});};for(const e in a)u(d.counters,e,a[e]);if(o.interactionRange[0]!==1/0&&o.interactionRange[1]!==-1/0&&(u(d.counters,"interactionRangeMin",o.interactionRange[0]),u(d.counters,"interactionRangeMax",o.interactionRange[1])),n)for(const e of Object.keys(i)){const t=i[e],o=n.find((e=>e.name===t));o&&u(d.counters,t,o.startTime);}return u(d.counters,"visibilityHidden",o.visibilityHidden),u(d.attributes,"style",function(t){if(t)for(const i of t){const t=i.name.split("?")[0];if(e.i(t)){const e=t.split("/").slice(-2);if(2===e.length)return `mapbox://styles/${e[0]}/${e[1]}`}}}(r)),u(d.attributes,"terrainEnabled",o.terrainEnabled?"true":"false"),u(d.attributes,"fogEnabled",o.fogEnabled?"true":"false"),u(d.attributes,"projection",o.projection),u(d.attributes,"zoom",o.zoom),u(d.metadata,"devicePixelRatio",l),u(d.metadata,"connectionEffectiveType",h),u(d.metadata,"navigatorUserAgent",navigator.userAgent),u(d.metadata,"screenWidth",window.screen.width),u(d.metadata,"screenHeight",window.screen.height),u(d.metadata,"windowWidth",window.innerWidth),u(d.metadata,"windowHeight",window.innerHeight),u(d.metadata,"mapWidth",o.width/l),u(d.metadata,"mapHeight",o.height/l),u(d.metadata,"webglRenderer",o.renderer),u(d.metadata,"webglVendor",o.vendor),u(d.metadata,"sdkVersion",t),u(d.metadata,"sdkIdentifier","mapbox-gl-js"),d}(n);for(const e of a.metadata);for(const e of a.counters);for(const e of a.attributes);this.postEvent(r,a,(()=>{}),o);}},B=F.postPerformanceEvent.bind(F),k=new class extends D{constructor(){super("map.auth"),this.success={},this.skuToken="";}getSession(t,i,o,s){if(!e.e.API_URL||!e.e.SESSION_PATH)return;const r=S(e.e.API_URL+e.e.SESSION_PATH);r.params.push(`sku=${i||""}`),r.params.push(`access_token=${s||e.e.ACCESS_TOKEN||""}`);const n={url:I(r),headers:{"Content-Type":"text/plain"}};this.pendingRequest=e.g(n,(e=>{this.pendingRequest=null,o(e),this.saveEventData(),this.processRequests(s);}));}getSessionAPI(t,i,o,s){this.skuToken=i,this.errorCb=s,e.e.SESSION_PATH&&e.e.API_URL&&(o||e.e.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},o):this.errorCb(new Error(w)));}processRequests(e){if(this.pendingRequest||0===this.queue.length)return;const{id:t,timestamp:i}=this.queue.shift();t&&this.success[t]||this.getSession(i,this.skuToken,(e=>{e?this.errorCb(e):t&&(this.success[t]=!0);}),e);}remove(){this.errorCb=null;}},N=k.getSessionAPI.bind(k),U=new Set;function j(e,t){t?U.add(e):U.delete(e);}class V{constructor(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSourceCaches={},this._updatedPaintProps=new Set,this._updatedImages={};}isDirty(){return this._changed}setDirty(){this._changed=!0;}getUpdatedSourceCaches(){return this._updatedSourceCaches}updateSourceCache(e,t){this._updatedSourceCaches[e]=t,this.setDirty();}discardSourceCacheUpdate(e){delete this._updatedSourceCaches[e];}updateLayer(e){const t=e.scope;this._updatedLayers[t]=this._updatedLayers[t]||new Set,this._updatedLayers[t].add(e.id),this.setDirty();}removeLayer(e){const t=e.scope;this._removedLayers[t]=this._removedLayers[t]||{},this._updatedLayers[t]=this._updatedLayers[t]||new Set,this._removedLayers[t][e.id]=e,this._updatedLayers[t].delete(e.id),this._updatedPaintProps.delete(e.fqid),this.setDirty();}getRemovedLayer(e){return this._removedLayers[e.scope]?this._removedLayers[e.scope][e.id]:null}discardLayerRemoval(e){this._removedLayers[e.scope]&&delete this._removedLayers[e.scope][e.id];}getLayerUpdatesByScope(){const e={};for(const t in this._updatedLayers)e[t]=e[t]||{},e[t].updatedIds=Array.from(this._updatedLayers[t].values());for(const t in this._removedLayers)e[t]=e[t]||{},e[t].removedIds=Object.keys(this._removedLayers[t]);return e}getUpdatedPaintProperties(){return this._updatedPaintProps}updatePaintProperties(e){this._updatedPaintProps.add(e.fqid),this.setDirty();}getUpdatedImages(e){return this._updatedImages[e]?Array.from(this._updatedImages[e].values()):[]}updateImage(t,i){this._updatedImages[i]=this._updatedImages[i]||new Set,this._updatedImages[i].add(e.I.toString(t)),this.setDirty();}resetUpdatedImages(e){this._updatedImages[e]&&this._updatedImages[e].clear();}reset(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSourceCaches={},this._updatedPaintProps.clear(),this._updatedImages={};}}function G(e){const{userImage:t}=e;return !!(t&&t.render&&t.render())&&(e.data.replace(new Uint8Array(t.data.buffer)),!0)}class q extends e.E{constructor(t){super(),this.imageProviders=new Map,this.images=new Map,this.updatedImages=new Map,this.callbackDispatchedThisFrame=new Map,this.loaded=new Map,this.requestors=[],this.patterns=new Map,this.patternsInFlight=new Set,this.atlasImage=new Map,this.atlasTexture=new Map,this.dirty=!0,this.spriteFormat=t,"raster"!==t&&e.t()&&(this.imageRasterizerDispatcher=new e.D(e.x(),this,"Image Rasterizer Worker",1));}addScope(t){this.loaded.set(t,!1),this.imageProviders.set(t,new Map),this.images.set(t,new Map),this.updatedImages.set(t,new Set),this.callbackDispatchedThisFrame.set(t,new Set),this.patterns.set(t,new Map),this.atlasImage.set(t,new e.r({width:1,height:1}));}removeScope(e){this.loaded.delete(e),this.imageProviders.delete(e),this.images.delete(e),this.updatedImages.delete(e),this.callbackDispatchedThisFrame.delete(e),this.patterns.delete(e),this.atlasImage.delete(e);const t=this.atlasTexture.get(e);t&&(t.destroy(),this.atlasTexture.delete(e));}addImageProvider(e,t){this.imageProviders.has(t)||this.imageProviders.set(t,new Map),this.imageProviders.get(t).set(e.id,e);}removeImageProvider(e,t){this.imageProviders.has(t)&&this.imageProviders.get(t).delete(e);}getPendingImageProviders(){const e=[];for(const t of this.imageProviders.values())for(const i of t.values())i.hasPendingRequests()&&e.push(i);return e}get imageRasterizer(){return this._imageRasterizer||(this._imageRasterizer=new e.y),this._imageRasterizer}isLoaded(){for(const e of this.loaded.keys())if(!this.loaded.get(e))return !1;return !0}setLoaded(e,t){if(this.loaded.get(t)!==e&&(this.loaded.set(t,e),e)){for(const{ids:e,callback:i}of this.requestors)this._notify(e,t,i);this.requestors=[];}}hasImage(e,t){return !!this.getImage(e,t)}getImage(e,t){return this.images.get(t).get(e.toString())}addImage(e,t,i){this._validate(e,i)&&this.images.get(t).set(e.toString(),i);}_validate(t,i){let o=!0;return this._validateStretch(i.stretchX,i.data&&i.data.width)||(this.fire(new e.z(new Error(`Image "${t.name}" has invalid "stretchX" value`))),o=!1),this._validateStretch(i.stretchY,i.data&&i.data.height)||(this.fire(new e.z(new Error(`Image "${t.name}" has invalid "stretchY" value`))),o=!1),this._validateContent(i.content,i)||(this.fire(new e.z(new Error(`Image "${t.name}" has invalid "content" value`))),o=!1),o}_validateStretch(e,t){if(!e)return !0;let i=0;for(const o of e){if(o[0]<i||o[1]<o[0]||t<o[1])return !1;i=o[1];}return !0}_validateContent(e,t){if(!e)return !0;if(4!==e.length)return !1;if(!t.usvg){if(e[0]<0||t.data.width<e[0])return !1;if(e[1]<0||t.data.height<e[1])return !1;if(e[2]<0||t.data.width<e[2])return !1;if(e[3]<0||t.data.height<e[3])return !1}return !(e[2]<e[0]||e[3]<e[1])}updateImage(e,t,i){const o=this.images.get(t).get(e.toString());i.version=o.version+1,this.images.get(t).set(e.toString(),i),this.updatedImages.get(t).add(e),this.removeFromImageRasterizerCache(e,t);}clearUpdatedImages(e){this.updatedImages.get(e).clear();}removeFromImageRasterizerCache(t,i){"raster"!==this.spriteFormat&&(e.t()?this.imageRasterizerDispatcher.getActor().send("removeRasterizedImages",{imageIds:[t],scope:i}):this.imageRasterizer.removeImagesFromCacheByIds([t],i));}removeImage(e,t){const i=this.images.get(t),o=i.get(e.toString());i.delete(e.toString()),this.patterns.get(t).delete(e.toString()),this.removeFromImageRasterizerCache(e,t),o.userImage&&o.userImage.onRemove&&o.userImage.onRemove();}listImages(t){return Array.from(this.images.get(t).keys()).map((t=>e.I.from(t)))}getImages(e,t,i){const o=[],s=[],r=this.imageProviders.get(t);for(const i of e){if(!i.iconsetId){o.push(i);continue}const e=r.get(i.iconsetId);e&&(this.getImage(i,t)?s.push(i):e.addPendingRequest(i));}if(0===o.length)return void this._notify(s,t,i);let n=!0;const a=!!this.loaded.get(t),l=this.images.get(t);if(!a)for(const e of o)l.has(e.toString())||(n=!1);a||n?this._notify(o,t,i):this.requestors.push({ids:o,scope:t,callback:i});}rasterizeImages(e,t){const i=new Map,{tasks:o,scope:s}=e;for(const[e,t]of o.entries()){const o=this.getImage(t.id,s);o&&i.set(e,{image:o,imageVariant:t});}this._rasterizeImages(s,i,t);}_rasterizeImages(t,i,o){if(e.t())this.imageRasterizerDispatcher.getActor().send("rasterizeImagesWorker",{tasks:i,scope:t},o);else {const e=new Map;for(const[o,{image:s,imageVariant:r}]of i.entries())e.set(o,this.imageRasterizer.rasterize(r,s,t,0));o(void 0,e);}}getUpdatedImages(e){return this.updatedImages.get(e)||new Set}_notify(t,i,o){const s=this.images.get(i),r=new Map;for(const i of t){if(!s.get(i.toString())){if(i.iconsetId)continue;this.fire(new e.A("styleimagemissing",{id:i.name}));}const t=s.get(i.toString());if(!t){e.w(`Image "${i.name}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`);continue}const o={data:t.usvg?null:t.data.clone(),pixelRatio:t.pixelRatio,sdf:t.sdf,usvg:t.usvg,version:t.version,stretchX:t.stretchX,stretchY:t.stretchY,content:t.content,hasRenderCallback:Boolean(t.userImage&&t.userImage.render)};t.usvg&&Object.assign(o,{width:t.icon.usvg_tree.width,height:t.icon.usvg_tree.height}),r.set(e.I.toString(i),o);}o(null,r);}getPixelSize(e){const{width:t,height:i}=this.atlasImage.get(e);return {width:t,height:i}}getPattern(t,i,o){const s=t.toString(),r=this.patterns.get(i),n=r.get(s),a=this.getImage(t,i);if(!a)return null;if(n){if(n.position.version===a.version)return n.position;n.position.version=a.version;}else {if(a.usvg&&!a.data){const r=this.getPatternInFlightId(s,i);if(this.patternsInFlight.has(r))return null;this.patternsInFlight.add(r);const n=new e.B(t).scaleSelf(e.q.devicePixelRatio),l=new Map([[n.toString(),{image:a,imageVariant:n}]]);return this._rasterizeImages(i,l,((e,t)=>this.storePatternImage(n,i,a,o,t))),null}this.storePattern(t,i,a);}return this._updatePatternAtlas(i,o),r.get(s).position}getPatternInFlightId(t,i){return e.C(t,i)}hasPatternsInFlight(){return 0!==this.patternsInFlight.size}storePatternImage(e,t,i,o,s){const r=e.toString(),n=s?s.get(r):void 0;n&&(i.data=n,this.storePattern(e.id,t,i),this._updatePatternAtlas(t,o),this.patternsInFlight.delete(this.getPatternInFlightId(e.id.toString(),t)));}storePattern(t,i,o){const s={w:o.data.width+2*e.F,h:o.data.height+2*e.F,x:0,y:0},r=new e.G(s,o,e.F);this.patterns.get(i).set(t.toString(),{bin:s,position:r});}bind(t,i){const o=t.gl;let s=this.atlasTexture.get(i);s?this.dirty&&(s.update(this.atlasImage.get(i)),this.dirty=!1):(s=new e.T(t,this.atlasImage.get(i),o.RGBA8),this.atlasTexture.set(i,s)),s.bind(o.LINEAR,o.CLAMP_TO_EDGE);}_updatePatternAtlas(t,i){const o=this.patterns.get(t),s=Array.from(o.values()).map((({bin:e})=>e)),{w:r,h:n}=e.H(s),a=this.atlasImage.get(t);a.resize({width:r||1,height:n||1});const l=this.images.get(t);for(const[t,{bin:s,position:r}]of o.entries()){let o=r.padding;const n=s.x+o,c=s.y+o,h=l.get(t).data,d=h.width,u=h.height;o=o>1?o-1:o,e.r.copy(h,a,{x:0,y:0},{x:n,y:c},{width:d,height:u},i),e.r.copy(h,a,{x:0,y:u-o},{x:n,y:c-o},{width:d,height:o},i),e.r.copy(h,a,{x:0,y:0},{x:n,y:c+u},{width:d,height:o},i),e.r.copy(h,a,{x:d-o,y:0},{x:n-o,y:c},{width:o,height:u},i),e.r.copy(h,a,{x:0,y:0},{x:n+d,y:c},{width:o,height:u},i),e.r.copy(h,a,{x:d-o,y:u-o},{x:n-o,y:c-o},{width:o,height:o},i),e.r.copy(h,a,{x:0,y:u-o},{x:n+d,y:c-o},{width:o,height:o},i),e.r.copy(h,a,{x:0,y:0},{x:n+d,y:c+u},{width:o,height:o},i),e.r.copy(h,a,{x:d-o,y:0},{x:n-o,y:c+u},{width:o,height:o},i);}this.dirty=!0;}beginFrame(){for(const e of this.images.keys())this.callbackDispatchedThisFrame.set(e,new Set);}dispatchRenderCallbacks(e,t){const i=this.images.get(t);for(const o of e){if(this.callbackDispatchedThisFrame.get(t).has(o.toString()))continue;this.callbackDispatchedThisFrame.get(t).add(o.toString());const e=i.get(o.toString());G(e)&&this.updateImage(o,t,e);}}}function Z(t){const i=t.key,o=t.value,s=t.valueSpec||{},r=t.objectElementValidators||{},n=t.style,a=t.styleSpec;let l=[];const c=e.J(o);if("object"!==c)return [new e.V(i,o,`object expected, ${c} found`)];for(const t in o){const c=t.split(".")[0];let h;r[c]?h=r[c]:s[c]?h=_e:r["*"]?h=r["*"]:s["*"]&&(h=_e),h?l=l.concat(h({key:(i?`${i}.`:i)+t,value:o[t],valueSpec:s[c]||s["*"],style:n,styleSpec:a,object:o,objectKey:t},o)):l.push(new e.K(i,o[t],`unknown property "${t}"`));}for(const t in s)r[t]||s[t].required&&void 0===s[t].default&&void 0===o[t]&&l.push(new e.V(i,o,`missing required property "${t}"`));return l}function H(t){const i=t.value,o=t.valueSpec,s=t.style,r=t.styleSpec,n=t.key,a=t.arrayElementValidator||_e;if("array"!==e.J(i))return [new e.V(n,i,`array expected, ${e.J(i)} found`)];if(o.length&&i.length!==o.length)return [new e.V(n,i,`array length ${o.length} expected, length ${i.length} found`)];if(o["min-length"]&&i.length<o["min-length"])return [new e.V(n,i,`array length at least ${o["min-length"]} expected, length ${i.length} found`)];let l={type:o.value,values:o.values,minimum:o.minimum,maximum:o.maximum,function:void 0};r.$version<7&&(l.function=o.function),"object"===e.J(o.value)&&(l=o.value);let c=[];for(let e=0;e<i.length;e++)c=c.concat(a({array:i,arrayIndex:e,value:i[e],valueSpec:l,style:s,styleSpec:r,key:`${n}[${e}]`},!0));return c}function W(t){const i=t.key,o=t.value,s=t.valueSpec;let r=e.J(o);if("number"===r&&o!=o&&(r="NaN"),"number"!==r)return [new e.V(i,o,`number expected, ${r} found`)];if("minimum"in s){let r=s.minimum;if("array"===e.J(s.minimum)&&(r=s.minimum[t.arrayIndex]),o<r)return [new e.V(i,o,`${o} is less than the minimum value ${r}`)]}if("maximum"in s){let r=s.maximum;if("array"===e.J(s.maximum)&&(r=s.maximum[t.arrayIndex]),o>r)return [new e.V(i,o,`${o} is greater than the maximum value ${r}`)]}return []}function $(t){const i=t.valueSpec,o=e.M(t.value.type);let s,r,n,a={};const l="categorical"!==o&&void 0===t.value.property,c=!l,h="array"===e.J(t.value.stops)&&"array"===e.J(t.value.stops[0])&&"object"===e.J(t.value.stops[0][0]),d=Z({key:t.key,value:t.value,valueSpec:t.styleSpec.function,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===o)return [new e.V(t.key,t.value,'identity function may not have a "stops" property')];let i=[];const s=t.value;return i=i.concat(H({key:t.key,value:s,valueSpec:t.valueSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:u})),"array"===e.J(s)&&0===s.length&&i.push(new e.V(t.key,s,"array must have at least one stop")),i},default:function(e){return _e({key:e.key,value:e.value,valueSpec:i,style:e.style,styleSpec:e.styleSpec})}}});return "identity"===o&&l&&d.push(new e.V(t.key,t.value,'missing required property "property"')),"identity"===o||t.value.stops||d.push(new e.V(t.key,t.value,'missing required property "stops"')),"exponential"===o&&t.valueSpec.expression&&!e.N(t.valueSpec)&&d.push(new e.V(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(c&&!e.O(t.valueSpec)?d.push(new e.V(t.key,t.value,"property functions not supported")):l&&!e.Q(t.valueSpec)&&d.push(new e.V(t.key,t.value,"zoom functions not supported"))),"categorical"!==o&&!h||void 0!==t.value.property||d.push(new e.V(t.key,t.value,'"property" property is required')),d;function u(t){let o=[];const s=t.value,l=t.key;if("array"!==e.J(s))return [new e.V(l,s,`array expected, ${e.J(s)} found`)];if(2!==s.length)return [new e.V(l,s,`array length 2 expected, length ${s.length} found`)];if(h){if("object"!==e.J(s[0]))return [new e.V(l,s,`object expected, ${e.J(s[0])} found`)];if(void 0===s[0].zoom)return [new e.V(l,s,"object stop key must have zoom")];if(void 0===s[0].value)return [new e.V(l,s,"object stop key must have value")];const i=e.M(s[0].zoom);if("number"!=typeof i)return [new e.V(l,s[0].zoom,"stop zoom values must be numbers")];if(n&&n>i)return [new e.V(l,s[0].zoom,"stop zoom values must appear in ascending order")];i!==n&&(n=i,r=void 0,a={}),o=o.concat(Z({key:`${l}[0]`,value:s[0],valueSpec:{zoom:{}},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:W,value:_}}));}else o=o.concat(_({key:`${l}[0]`,value:s[0],style:t.style,styleSpec:t.styleSpec},s));return e.S(e.U(s[1]))?o.concat([new e.V(`${l}[1]`,s[1],"expressions are not allowed in function stops.")]):o.concat(_e({key:`${l}[1]`,value:s[1],valueSpec:i,style:t.style,styleSpec:t.styleSpec}))}function _(t,n){const l=e.J(t.value),c=e.M(t.value),h=null!==t.value?t.value:n;if(s){if(l!==s)return [new e.V(t.key,h,`${l} stop domain type must match previous stop domain type ${s}`)]}else s=l;if("number"!==l&&"string"!==l&&"boolean"!==l&&"number"!=typeof c&&"string"!=typeof c&&"boolean"!=typeof c)return [new e.V(t.key,h,"stop domain value must be a number, string, or boolean")];if("number"!==l&&"categorical"!==o){let s=`number expected, ${l} found`;return e.O(i)&&void 0===o&&(s+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new e.V(t.key,h,s)]}return "categorical"!==o||"number"!==l||"number"==typeof c&&isFinite(c)&&Math.floor(c)===c?"categorical"!==o&&"number"===l&&"number"==typeof c&&"number"==typeof r&&void 0!==r&&c<r?[new e.V(t.key,h,"stop domain values must appear in ascending order")]:(r=c,"categorical"===o&&c in a?[new e.V(t.key,h,"stop domain values must be unique")]:(a[c]=!0,[])):[new e.V(t.key,h,`integer expected, found ${String(c)}`)]}}function X(t){const i=("property"===t.expressionContext?e.W:e.X)(e.U(t.value),t.valueSpec);if("error"===i.result)return i.value.map((i=>new e.V(`${t.key}${i.key}`,t.value,i.message)));const o=i.value.expression||i.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!o.outputDefined())return [new e.V(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!e.Y(o))return [new e.V(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext)return Y(o,t);if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!e.Z(o,["zoom","feature-state"]))return [new e.V(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!e._(o))return [new e.V(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return []}function Y(t,i){const o=new Set(["zoom","feature-state","pitch","distance-from-center"]);if(i.valueSpec&&i.valueSpec.expression)for(const e of i.valueSpec.expression.parameters)o.delete(e);if(0===o.size)return [];const s=[];return t instanceof e.$&&o.has(t.name)?[new e.V(i.key,i.value,`["${t.name}"] expression is not supported in a filter for a ${i.object.type} layer with id: ${i.object.id}`)]:(t.eachChild((e=>{s.push(...Y(e,i));})),s)}function K(t){const i=t.key,o=t.value,s=t.valueSpec,r=[];return Array.isArray(s.values)?-1===s.values.indexOf(e.M(o))&&r.push(new e.V(i,o,`expected one of [${s.values.join(", ")}], ${JSON.stringify(o)} found`)):-1===Object.keys(s.values).indexOf(e.M(o))&&r.push(new e.V(i,o,`expected one of [${Object.keys(s.values).join(", ")}], ${JSON.stringify(o)} found`)),r}function J(t){return e.a1(e.U(t.value))?X(e.L({},t,{expressionContext:"filter",valueSpec:t.styleSpec[`filter_${t.layerType||"fill"}`]})):Q(t)}function Q(t){const i=t.value,o=t.key;if("array"!==e.J(i))return [new e.V(o,i,`array expected, ${e.J(i)} found`)];const s=t.styleSpec;let r,n=[];if(i.length<1)return [new e.V(o,i,"filter array must have at least 1 element")];switch(n=n.concat(K({key:`${o}[0]`,value:i[0],valueSpec:s.filter_operator,style:t.style,styleSpec:t.styleSpec})),e.M(i[0])){case "<":case "<=":case ">":case ">=":i.length>=2&&"$type"===e.M(i[1])&&n.push(new e.V(o,i,`"$type" cannot be use with operator "${i[0]}"`));case "==":case "!=":3!==i.length&&n.push(new e.V(o,i,`filter array for operator "${i[0]}" must have 3 elements`));case "in":case "!in":i.length>=2&&(r=e.J(i[1]),"string"!==r&&n.push(new e.V(`${o}[1]`,i[1],`string expected, ${r} found`)));for(let a=2;a<i.length;a++)r=e.J(i[a]),"$type"===e.M(i[1])?n=n.concat(K({key:`${o}[${a}]`,value:i[a],valueSpec:s.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==r&&"number"!==r&&"boolean"!==r&&n.push(new e.V(`${o}[${a}]`,i[a],`string, number, or boolean expected, ${r} found`));break;case "any":case "all":case "none":for(let e=1;e<i.length;e++)n=n.concat(Q({key:`${o}[${e}]`,value:i[e],style:t.style,styleSpec:t.styleSpec}));break;case "has":case "!has":r=e.J(i[1]),2!==i.length?n.push(new e.V(o,i,`filter array for "${i[0]}" operator must have 2 elements`)):"string"!==r&&n.push(new e.V(`${o}[1]`,i[1],`string expected, ${r} found`));}return n}function ee(t,i){const o=t.key,s=t.style,r=t.layer,n=t.styleSpec,a=t.value,l=t.objectKey,c=n[`${i}_${t.layerType}`];if(!c)return [];const h=l.match(/^(.*)-use-theme$/);if("paint"===i&&h&&c[h[1]])return e.S(a)?[].concat(_e({key:t.key,value:a,valueSpec:{type:"string",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},style:s,styleSpec:n,expressionContext:"property",propertyType:i,propertyKey:l})):_e({key:o,value:a,valueSpec:{type:"string"},style:s,styleSpec:n});const d=l.match(/^(.*)-transition$/);if("paint"===i&&d&&c[d[1]]&&c[d[1]].transition)return _e({key:o,value:a,valueSpec:n.transition,style:s,styleSpec:n});const u=t.valueSpec||c[l];if(!u)return [new e.K(o,a,`unknown property "${l}"`)];let _;if("string"===e.J(a)&&e.O(u)&&!u.tokens&&(_=/^{([^}]+)}$/.exec(a))){const t=`\`{ "type": "identity", "property": ${_?JSON.stringify(_[1]):'"_"'} }\``;return [new e.V(o,a,`"${l}" does not support interpolation syntax\nUse an identity property function instead: ${t}.`)]}const p=[];if("symbol"===t.layerType)"text-field"!==l||!s||s.glyphs||s.imports||p.push(new e.V(o,a,'use of "text-field" requires a style "glyphs" property')),"text-font"===l&&e.a2(e.U(a))&&"identity"===e.M(a.type)&&p.push(new e.V(o,a,'"text-font" does not support identity functions'));else if("model"===t.layerType&&"paint"===i&&r&&r.layout&&r.layout.hasOwnProperty("model-id")&&e.O(u)&&(e.a3(u)||e.Q(u))){const t=e.W(e.U(a),u),i=t.value.expression||t.value._styleExpression.expression;i&&!e.Z(i,["measure-light"])&&("model-emissive-strength"===l&&e._(i)&&e.Y(i)||p.push(new e.V(o,a,`${l} does not support measure-light expressions when the model layer source is vector tile or GeoJSON.`)));}return p.concat(_e({key:t.key,value:a,valueSpec:u,style:s,styleSpec:n,expressionContext:"property",propertyType:i,propertyKey:l}))}function te(e){return ee(e,"paint")}function ie(e){return ee(e,"layout")}function oe(t){let i=[];const o=t.value,s=t.key,r=t.style,n=t.styleSpec;o.type||o.ref||i.push(new e.V(s,o,'either "type" or "ref" is required'));let a=e.M(o.type);const l=e.M(o.ref);if(o.id){const n=e.M(o.id);for(let a=0;a<t.arrayIndex;a++){const t=r.layers[a];e.M(t.id)===n&&i.push(new e.V(s,o.id,`duplicate layer id "${o.id}", previously used at line ${t.id.__line__}`));}}if("ref"in o){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in o&&i.push(new e.V(s,o[t],`"${t}" is prohibited for ref layers`));})),r.layers.forEach((i=>{e.M(i.id)===l&&(t=i);})),t?t.ref?i.push(new e.V(s,o.ref,"ref cannot reference another ref layer")):a=e.M(t.type):"string"==typeof l&&i.push(new e.V(s,o.ref,`ref layer "${l}" not found`));}else if("background"!==a&&"sky"!==a&&"slot"!==a)if(o.source){const t=r.sources&&r.sources[o.source],n=t&&e.M(t.type);t?"vector"===n&&"raster"===a?i.push(new e.V(s,o.source,`layer "${o.id}" requires a raster source`)):"raster"===n&&"raster"!==a?i.push(new e.V(s,o.source,`layer "${o.id}" requires a vector source`)):"vector"!==n||o["source-layer"]?"raster-dem"===n&&"hillshade"!==a?i.push(new e.V(s,o.source,"raster-dem source can only be used with layer type 'hillshade'.")):"raster-array"!==n||["raster","raster-particle"].includes(a)?"line"===a&&o.paint&&(o.paint["line-gradient"]||o.paint["line-trim-offset"])&&"geojson"===n&&!t.lineMetrics?i.push(new e.V(s,o,`layer "${o.id}" specifies a line-gradient, which requires the GeoJSON source to have \`lineMetrics\` enabled.`)):"raster-particle"===a&&"raster-array"!==n&&i.push(new e.V(s,o.source,`layer "${o.id}" requires a 'raster-array' source.`)):i.push(new e.V(s,o.source,"raster-array source can only be used with layer type 'raster'.")):i.push(new e.V(s,o,`layer "${o.id}" must specify a "source-layer"`)):i.push(new e.V(s,o.source,`source "${o.source}" not found`));}else i.push(new e.V(s,o,'missing required property "source"'));return i=i.concat(Z({key:s,value:o,valueSpec:n.layer,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":()=>[],type:()=>_e({key:`${s}.type`,value:o.type,valueSpec:n.layer.type,style:t.style,styleSpec:t.styleSpec,object:o,objectKey:"type"}),filter:t=>J(e.L({layerType:a},t)),layout:t=>Z({layer:o,key:t.key,value:t.value,valueSpec:{},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>ie(e.L({layerType:a},t))}}),paint:t=>Z({layer:o,key:t.key,value:t.value,valueSpec:{},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>te(e.L({layerType:a,layer:o},t))}})}})),i}function se(t){const i=t.value,o=t.key,s=e.J(i);return "string"!==s?[new e.V(o,i,`string expected, ${s} found`)]:[]}const re={promoteId:function t({key:i,value:o}){if("string"===e.J(o))return se({key:i,value:o});if(Array.isArray(o)){const t=[],s=e.U(o),r=e.X(s);return "error"===r.result&&r.value.forEach((o=>{t.push(new e.V(`${i}${o.key}`,null,`${o.message}`));})),e.Z(r.value.expression,["zoom","heatmap-density","line-progress","raster-value","sky-radial-progress","accumulated","is-supported-script","pitch","distance-from-center","measure-light","raster-particle-speed"])||t.push(new e.V(`${i}`,null,"promoteId expression should be only feature dependent")),t}{const e=[];for(const s in o)e.push(...t({key:`${i}.${s}`,value:o[s]}));return e}}};function ne(t){const i=t.value,o=t.key,s=t.styleSpec,r=t.style;if(!i.type)return [new e.V(o,i,'"type" is required')];const n=e.M(i.type);let a=[];switch(["vector","raster","raster-dem","raster-array"].includes(n)&&(i.url||i.tiles||a.push(new e.K(o,i,'Either "url" or "tiles" is required.'))),n){case "vector":case "raster":case "raster-dem":case "raster-array":return a=a.concat(Z({key:o,value:i,valueSpec:s[`source_${n.replace("-","_")}`],style:t.style,styleSpec:s,objectElementValidators:re})),a;case "geojson":if(a=Z({key:o,value:i,valueSpec:s.source_geojson,style:r,styleSpec:s,objectElementValidators:re}),i.cluster)for(const e in i.clusterProperties){const[t,s]=i.clusterProperties[e],r="string"==typeof t?[t,["accumulated"],["get",e]]:t;a.push(...X({key:`${o}.${e}.map`,value:s,expressionContext:"cluster-map"})),a.push(...X({key:`${o}.${e}.reduce`,value:r,expressionContext:"cluster-reduce"}));}return a;case "video":return Z({key:o,value:i,valueSpec:s.source_video,style:r,styleSpec:s});case "image":return Z({key:o,value:i,valueSpec:s.source_image,style:r,styleSpec:s});case "canvas":return [new e.V(o,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return K({key:`${o}.type`,value:i.type,valueSpec:{values:ae(s)}})}}function ae(e){return e.source.reduce(((t,i)=>{const o=e[i];return "enum"===o.type.type&&(t=t.concat(Object.keys(o.type.values))),t}),[])}function le(t){const i=t.value,o=t.styleSpec,s=o.light,r=t.style;let n=[];const a=e.J(i);if(void 0===i)return n;if("object"!==a)return n=n.concat([new e.V("light",i,`object expected, ${a} found`)]),n;for(const t in i){const a=t.match(/^(.*)-transition$/),l=t.match(/^(.*)-use-theme$/);n=n.concat(l&&s[l[1]]?_e({key:t,value:i[t],valueSpec:{type:"string"},style:r,styleSpec:o}):a&&s[a[1]]&&s[a[1]].transition?_e({key:t,value:i[t],valueSpec:o.transition,style:r,styleSpec:o}):s[t]?_e({key:t,value:i[t],valueSpec:s[t],style:r,styleSpec:o}):[new e.V(t,i[t],`unknown property "${t}"`)]);}return n}function ce(t){const i=t.value;let o=[];if(!i)return o;const s=e.J(i);if("object"!==s)return o=o.concat([new e.V("light-3d",i,`object expected, ${s} found`)]),o;const r=t.styleSpec,n=r["light-3d"],a=t.key,l=t.style,c=t.style.lights;for(const t of ["type","id"])if(!(t in i))return o=o.concat([new e.V("light-3d",i,`missing property ${t} on light`)]),o;if(i.type&&c)for(let s=0;s<t.arrayIndex;s++){const t=e.M(i.type),r=c[s];e.M(r.type)===t&&o.push(new e.V(a,i.id,`duplicate light type "${i.type}", previously defined at line ${r.id.__line__}`));}const h=`properties_light_${i.type}`;if(!(h in r))return o=o.concat([new e.V("light-3d",i,`Invalid light type ${i.type}`)]),o;const d=r[h];for(const s in i)if("properties"===s){const n=i[s],a=e.J(n);if("object"!==a)return o=o.concat([new e.V("properties",n,`object expected, ${a} found`)]),o;for(const a in n){const c=a.match(/^(.*)-transition$/),h=a.match(/^(.*)-use-theme$/);o=o.concat(h&&d[h[1]]?_e({key:s,value:n[a],valueSpec:{type:"string"},style:l,styleSpec:r}):c&&d[c[1]]&&d[c[1]].transition?_e({key:s,value:i[s],valueSpec:r.transition,style:l,styleSpec:r}):d[a]?_e({key:a,value:n[a],valueSpec:d[a],style:l,styleSpec:r}):[new e.K(t.key,n[a],`unknown property "${a}"`)]);}}else o=o.concat(n[s]?_e({key:s,value:i[s],valueSpec:n[s],style:l,styleSpec:r}):[new e.K(s,i[s],`unknown property "${s}"`)]);return o}function he(t){const i=t.value,o=t.key,s=t.style,r=t.styleSpec,n=r.terrain;let a=[];const l=e.J(i);if(void 0===i)return a;if("null"===l)return a;if("object"!==l)return a=a.concat([new e.V("terrain",i,`object expected, ${l} found`)]),a;for(const t in i){const o=t.match(/^(.*)-transition$/),l=t.match(/^(.*)-use-theme$/);a=a.concat(l&&n[l[1]]?_e({key:t,value:i[t],valueSpec:{type:"string"},style:s,styleSpec:r}):o&&n[o[1]]&&n[o[1]].transition?_e({key:t,value:i[t],valueSpec:r.transition,style:s,styleSpec:r}):n[t]?_e({key:t,value:i[t],valueSpec:n[t],style:s,styleSpec:r}):[new e.K(t,i[t],`unknown property "${t}"`)]);}if(i.source){const t=s.sources&&s.sources[i.source],r=t&&e.M(t.type);t?"raster-dem"!==r&&a.push(new e.V(o,i.source,`terrain cannot be used with a source of type ${String(r)}, it only be used with a "raster-dem" source type`)):a.push(new e.V(o,i.source,`source "${i.source}" not found`));}else a.push(new e.V(o,i,'terrain is missing required property "source"'));return a}function de(t){const i=t.value,o=t.style,s=t.styleSpec,r=s.fog;let n=[];const a=e.J(i);if(void 0===i)return n;if("object"!==a)return n=n.concat([new e.V("fog",i,`object expected, ${a} found`)]),n;for(const t in i){const a=t.match(/^(.*)-transition$/),l=t.match(/^(.*)-use-theme$/);n=n.concat(l&&r[l[1]]?_e({key:t,value:i[t],valueSpec:{type:"string"},style:o,styleSpec:s}):a&&r[a[1]]&&r[a[1]].transition?_e({key:t,value:i[t],valueSpec:s.transition,style:o,styleSpec:s}):r[t]?_e({key:t,value:i[t],valueSpec:r[t],style:o,styleSpec:s}):[new e.K(t,i[t],`unknown property "${t}"`)]);}return n}const ue={"*":()=>[],array:H,boolean:function(t){const i=t.value,o=t.key,s=e.J(i);return "boolean"!==s?[new e.V(o,i,`boolean expected, ${s} found`)]:[]},number:W,color:function(t){const i=t.key,o=t.value,s=e.J(o);return "string"!==s?[new e.V(i,o,`color expected, ${s} found`)]:null===e.a0.parseCSSColor(o)?[new e.V(i,o,`color expected, "${o}" found`)]:[]},enum:K,filter:J,function:$,layer:oe,object:Z,source:ne,model:e.a4,light:le,"light-3d":ce,terrain:he,fog:de,string:se,formatted:function(e){return 0===se(e).length?[]:X(e)},resolvedImage:function(e){return 0===se(e).length?[]:X(e)},projection:function(t){const i=t.value,o=t.styleSpec,s=o.projection,r=t.style;let n=[];const a=e.J(i);if("object"===a)for(const e in i)n=n.concat(_e({key:e,value:i[e],valueSpec:s[e],style:r,styleSpec:o}));else "string"!==a&&(n=n.concat([new e.V("projection",i,`object or string expected, ${a} found`)]));return n},import:function(t){const{value:i,styleSpec:o}=t,{data:s,...r}=i;Object.defineProperty(r,"__line__",{value:i.__line__,enumerable:!1});let n=Z(e.L({},t,{value:r,valueSpec:o.import}));return ""===e.M(r.id)&&n.push(new e.V(`${t.key}.id`,r,"import id can't be an empty string")),s&&(n=n.concat(fe(s,o,{key:`${t.key}.data`}))),n},iconset:function(t){const i=t.value,o=t.key,s=t.styleSpec,r=t.style;if(!i.type)return [new e.V(o,i,'"type" is required')];const n=e.M(i.type);let a=[];if(a=a.concat(Z({key:o,value:i,valueSpec:s[`iconset_${n}`],style:r,styleSpec:s})),"source"===n&&i.source){const t=r.sources&&r.sources[i.source],s=t&&e.M(t.type);t?"raster-array"!==s&&a.push(new e.V(o,i.source,`iconset cannot be used with a source of type ${String(s)}, it only be used with a "raster-array" source type`)):a.push(new e.V(o,i.source,`source "${i.source}" not found`));}return a}};function _e(t,i=!1){const o=t.value,s=t.valueSpec,r=t.styleSpec;if(s.expression&&e.a2(e.M(o)))return $(t);if(s.expression&&e.S(e.U(o)))return X(t);if(s.type&&ue[s.type]){const o=ue[s.type](t);return !0===i&&o.length>0&&"array"===e.J(t.value)?X(t):o}return Z(e.L({},t,{valueSpec:s.type?r[s.type]:s}))}function pe(t){const i=t.value,o=t.key,s=se(t);return s.length||(-1===i.indexOf("{fontstack}")&&s.push(new e.V(o,i,'"glyphs" url must include a "{fontstack}" token')),-1===i.indexOf("{range}")&&s.push(new e.V(o,i,'"glyphs" url must include a "{range}" token'))),s}function fe(t,i=e.a5,o={}){return _e({key:o.key||"",value:t,valueSpec:i.$root,styleSpec:i,style:t,objectElementValidators:{glyphs:pe,"*":()=>[]}})}function me(t,i=e.a5){return De(fe(t,i))}const ge=e=>De(ne(e)),ve=e=>De(le(e)),ye=e=>De(ce(e)),xe=e=>De(he(e)),be=e=>De(de(e)),we=t=>De(function(t){const i=t.value,o=t.style,s=t.styleSpec,r=s.snow;let n=[];const a=e.J(i);if(void 0===i)return n;if("object"!==a)return n=n.concat([new e.V("snow",i,`object expected, ${a} found`)]),n;for(const t in i){const a=t.match(/^(.*)-transition$/);n=n.concat(a&&r[a[1]]&&r[a[1]].transition?_e({key:t,value:i[t],valueSpec:s.transition,style:o,styleSpec:s}):r[t]?_e({key:t,value:i[t],valueSpec:r[t],style:o,styleSpec:s}):[new e.K(t,i[t],`unknown property "${t}"`)]);}return n}(t)),Te=t=>De(function(t){const i=t.value,o=t.style,s=t.styleSpec,r=s.rain;let n=[];const a=e.J(i);if(void 0===i)return n;if("object"!==a)return n=n.concat([new e.V("rain",i,`object expected, ${a} found`)]),n;for(const t in i){const a=t.match(/^(.*)-transition$/);n=n.concat(a&&r[a[1]]&&r[a[1]].transition?_e({key:t,value:i[t],valueSpec:s.transition,style:o,styleSpec:s}):r[t]?_e({key:t,value:i[t],valueSpec:r[t],style:o,styleSpec:s}):[new e.K(t,i[t],`unknown property "${t}"`)]);}return n}(t)),Ee=e=>De(oe(e)),Se=e=>De(J(e)),Ie=e=>De(te(e)),Ce=e=>De(ie(e)),Re=t=>De(e.a4(t));function De(e){return e.slice().sort(((e,t)=>e.line&&t.line?e.line-t.line:0))}function Ae(t,i){let o=!1;if(i&&i.length)for(const s of i)s instanceof e.K?e.w(s.message):(t.fire(new e.z(new Error(s.message))),o=!0);return o}let Le;class Pe extends e.E{constructor(t,i="flat"){super(),this._transitionable=new e.a6(Le||(Le=new e.a7({anchor:new e.a8(e.a5.light.anchor),position:new e.a9(e.a5.light.position),color:new e.a8(e.a5.light.color),intensity:new e.a8(e.a5.light.intensity)}))),this.setLight(t,i),this._transitioning=this._transitionable.untransitioned();}getLight(){return this._transitionable.serialize()}setLight(e,t,i={}){this._validate(ve,e,i)||(this._transitionable.setTransitionOrValue(e),this.id=t);}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&Ae(this,t.call(me,e.h({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.a5})))}}let ze=class extends e.E{constructor(t,i,o,s,r){super(),this.scope=o,this._transitionable=new e.a6(new e.a7({source:new e.a8(e.a5.terrain.source),exaggeration:new e.a8(e.a5.terrain.exaggeration)}),o,s),this._transitionable.setTransitionOrValue(t,s),this._transitioning=this._transitionable.untransitioned(),this.drapeRenderMode=i,this.worldview=r;}get(){return this._transitionable.serialize()}set(e,t){this._transitionable.setTransitionOrValue(e,t);}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}getExaggeration(t){return this._transitioning.possiblyEvaluate(new e.aa(t,{worldview:this.worldview})).get("exaggeration")}getAttenuationRange(){if(!this.isZoomDependent())return null;const t=this._transitionable._values.exaggeration;if(!t)return null;const i=t.value.expression;if(!i)return null;let o=-1,s=-1,r=1;for(const t of i.zoomStops)r=i.evaluate(new e.aa(t,{worldview:this.worldview})),r>.01?(o=t,s=-1):s=t;return r<.01&&o>0&&s>o?[o,s]:null}isZoomDependent(){const t=this._transitionable._values.exaggeration;return null!=t&&null!=t.value&&null!=t.value.expression&&t.value.expression instanceof e.ab}};const Me=45,Oe=65,Fe=.05;function Be(t,i,o,s){const r=e.af(Me,Oe,o),[n,a]=ke(t,s);let l=1-Math.min(1,Math.exp((i-n)/(a-n)*-6));return l*=l*l,l=Math.min(1,1.00747*l),l*r*t.alpha}function ke(e,t){const i=.5/Math.tan(.5*t);return [e.range[0]+i,e.range[1]+i]}function Ne(t,i,o,s,r){const n=e.ad([],[i,o,s],r.mercatorFogMatrix);return Be(t,e.ae(n),r.pitch,r._fov)}function Ue(t,i,o,s,r,n,a){const l=[[o,s,0],[r,s,0],[r,n,0],[o,n,0]];let c=Number.MAX_VALUE,h=-Number.MAX_VALUE;for(const t of l){const o=e.ad([],t,i),s=e.ae(o);c=Math.min(c,s),h=Math.max(h,s);}return [Be(t,c,a.pitch,a._fov),Be(t,h,a.pitch,a._fov)]}class je extends e.E{constructor(t,i,o,s){super();const r=new e.a7({range:new e.a8(e.a5.fog.range),color:new e.a8(e.a5.fog.color),"color-use-theme":new e.a8({type:"string","property-type":"data-constant",default:"default"}),"high-color":new e.a8(e.a5.fog["high-color"]),"high-color-use-theme":new e.a8({type:"string","property-type":"data-constant",default:"default"}),"space-color":new e.a8(e.a5.fog["space-color"]),"space-color-use-theme":new e.a8({type:"string","property-type":"data-constant",default:"default"}),"horizon-blend":new e.a8(e.a5.fog["horizon-blend"]),"star-intensity":new e.a8(e.a5.fog["star-intensity"]),"vertical-range":new e.a8(e.a5.fog["vertical-range"])});this._transitionable=new e.a6(r,o,new Map(s)),this.set(t,s),this._transitioning=this._transitionable.untransitioned(),this._transform=i,this.properties=new e.ag(r),this.scope=o;}get state(){const t=this._transform,i="globe"===t.projection.name,o=e.ah(t.zoom),s=this.properties.get("range"),r=[.5,3];return {range:i?[e.ai(r[0],s[0],o),e.ai(r[1],s[1],o)]:s,horizonBlend:this.properties.get("horizon-blend"),alpha:this.properties.get("color").a}}get(){return this._transitionable.serialize()}set(t,i,o={}){if(this._validate(be,t,o))return;const s=e.h({},t);for(const t of Object.keys(e.a5.fog))void 0===s[t]&&(s[t]=e.a5.fog[t].default);this._options=s,this._transitionable.setTransitionOrValue(this._options,i);}getOpacity(t){if(!this._transform.projection.supportsFog)return 0;const i=this.properties&&this.properties.get("color")||1;return ("globe"===this._transform.projection.name?1:e.af(Me,Oe,t))*i.a}getOpacityAtLatLng(t,i){return this._transform.projection.supportsFog?function(t,i,o){const s=e.ac.fromLngLat(i),r=o.elevation?o.elevation.getAtPointOrZero(s):0;return Ne(t,s.x,s.y,r,o)}(this.state,t,i):0}getOpacityForTile(t){if(!this._transform.projection.supportsFog)return [1,1];const i=this._transform.calculateFogTileMatrix(t.toUnwrapped());return Ue(this.state,i,0,0,e.aj,e.aj,this._transform)}getOpacityForBounds(e,t,i,o,s){return this._transform.projection.supportsFog?Ue(this.state,e,t,i,o,s,this._transform):[1,1]}getFovAdjustedRange(e){return this._transform.projection.supportsFog?ke(this.state,e):[0,1]}isVisibleOnFrustum(t){if(!this._transform.projection.supportsFog)return !1;const i=[4,5,6,7];for(const o of i){const i=t.points[o];let s;if(i[2]>=0)s=i;else {const r=t.points[o-4];s=e.ak(r,i,r[2]/(r[2]-i[2]));}if(Ne(this.state,s[0],s[1],0,this._transform)>=Fe)return !0}return !1}updateConfig(e){this._transitionable.setTransitionOrValue(this._options,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&Ae(this,t.call(me,e.h({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.a5})))}}let Ve,Ge,qe,Ze,He=class extends e.E{constructor(t,i,o,s){super();const r=Ve||(Ve=new e.a7({density:new e.a8(e.a5.snow.density),intensity:new e.a8(e.a5.snow.intensity),color:new e.a8(e.a5.snow.color),opacity:new e.a8(e.a5.snow.opacity),vignette:new e.a8(e.a5.snow.vignette),"vignette-color":new e.a8(e.a5.snow["vignette-color"]),"center-thinning":new e.a8(e.a5.snow["center-thinning"]),direction:new e.a8(e.a5.snow.direction),"flake-size":new e.a8(e.a5.snow["flake-size"])}));this._transitionable=new e.a6(r,o,new Map(s)),this.set(t,s),this._transitioning=this._transitionable.untransitioned(),this.properties=new e.ag(r),this.scope=o;}get state(){const t=this.properties.get("opacity"),i=this.properties.get("color"),o=this.properties.get("direction"),s=e.al(o[0]),r=-Math.max(e.al(o[1]),.01),n=[Math.cos(s)*Math.cos(r),Math.sin(s)*Math.cos(r),Math.sin(r)],a=this.properties.get("vignette"),l=this.properties.get("vignette-color");return l.a=a,{density:this.properties.get("density"),intensity:this.properties.get("intensity"),color:new e.am(i.r,i.g,i.b,i.a*t),direction:n,centerThinning:this.properties.get("center-thinning"),flakeSize:this.properties.get("flake-size"),vignetteColor:l}}get(){return this._transitionable.serialize()}set(t,i,o={}){if(this._validate(we,t,o))return;const s=e.h({},t);for(const t of Object.keys(e.a5.snow))void 0===s[t]&&(s[t]=e.a5.snow[t].default);this._options=s,this._transitionable.setTransitionOrValue(this._options,i);}updateConfig(e){this._transitionable.setTransitionOrValue(this._options,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&Ae(this,t.call(me,e.h({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.a5})))}},We=class extends e.E{constructor(t,i,o,s){super();const r=Ge||(Ge=new e.a7({density:new e.a8(e.a5.rain.density),intensity:new e.a8(e.a5.rain.intensity),color:new e.a8(e.a5.rain.color),opacity:new e.a8(e.a5.rain.opacity),vignette:new e.a8(e.a5.rain.vignette),"vignette-color":new e.a8(e.a5.rain["vignette-color"]),"center-thinning":new e.a8(e.a5.rain["center-thinning"]),direction:new e.a8(e.a5.rain.direction),"droplet-size":new e.a8(e.a5.rain["droplet-size"]),"distortion-strength":new e.a8(e.a5.rain["distortion-strength"])}));this._transitionable=new e.a6(r,o,new Map(s)),this.set(t,s),this._transitioning=this._transitionable.untransitioned(),this.properties=new e.ag(r),this.scope=o;}get state(){const t=this.properties.get("opacity"),i=this.properties.get("color"),o=this.properties.get("direction"),s=e.al(o[0]),r=-Math.max(e.al(o[1]),.01),n=[Math.cos(s)*Math.cos(r),Math.sin(s)*Math.cos(r),Math.sin(r)],a=this.properties.get("vignette-color");return a.a=this.properties.get("vignette"),{density:this.properties.get("density"),intensity:this.properties.get("intensity"),color:new e.am(i.r,i.g,i.b,i.a*t),direction:n,centerThinning:this.properties.get("center-thinning"),dropletSize:this.properties.get("droplet-size"),distortionStrength:this.properties.get("distortion-strength"),vignetteColor:a}}get(){return this._transitionable.serialize()}set(t,i,o={}){if(this._validate(Te,t,o))return;const s=e.h({},t);for(const t of Object.keys(e.a5.rain))void 0===s[t]&&(s[t]=e.a5.rain[t].default);this._options=s,this._transitionable.setTransitionOrValue(this._options,i);}updateConfig(e){this._transitionable.setTransitionOrValue(this._options,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&Ae(this,t.call(me,e.h({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.a5})))}};class $e extends e.E{constructor(t,i,o,s){super(),this.scope=o,this._options=t,this.properties=new e.ag(i),this._transitionable=new e.a6(i,o,new Map(s)),this._transitionable.setTransitionOrValue(t.properties),this._transitioning=this._transitionable.untransitioned();}updateConfig(e){this._transitionable.setTransitionOrValue(this._options.properties,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}get(){return this._options.properties=this._transitionable.serialize(),this._options}set(e,t){this._options=e,this._transitionable.setTransitionOrValue(e.properties,t);}shadowsEnabled(){return !!this.properties&&!0===this.properties.get("cast-shadows")}}class Xe{constructor(e,t,i,o){this.screenBounds=e,this.cameraPoint=t,this._screenRaycastCache={},this._cameraRaycastCache={},this.isAboveHorizon=i,this.screenGeometry=this.bufferedScreenGeometry(0),this.screenGeometryMercator=this._bufferedScreenMercator(0,o);}static createFromScreenPoints(t,i){let o,s;if(t instanceof e.P||"number"==typeof t[0]){const r=e.P.convert(t);o=[r],s=i.isPointAboveHorizon(r);}else {const r=e.P.convert(t[0]),n=e.P.convert(t[1]),a=r.add(n)._div(2);o=[r,n],s=e.ao(r,n).every((e=>i.isPointAboveHorizon(e)))&&i.isPointAboveHorizon(a);}return new Xe(o,i.getCameraPoint(),s,i)}isPointQuery(){return 1===this.screenBounds.length}bufferedScreenGeometry(t){return e.ao(this.screenBounds[0],1===this.screenBounds.length?this.screenBounds[0]:this.screenBounds[1],t)}bufferedCameraGeometry(t){const i=this.screenBounds[0],o=1===this.screenBounds.length?this.screenBounds[0].add(new e.P(1,1)):this.screenBounds[1],s=e.ao(i,o,0,!1);return this.cameraPoint.y>o.y&&(this.cameraPoint.x>i.x&&this.cameraPoint.x<o.x?s.splice(3,0,this.cameraPoint):this.cameraPoint.x>=o.x?s[2]=this.cameraPoint:this.cameraPoint.x<=i.x&&(s[3]=this.cameraPoint)),e.ap(s,t)}bufferedCameraGeometryGlobe(t){const i=this.screenBounds[0],o=1===this.screenBounds.length?this.screenBounds[0].add(new e.P(1,1)):this.screenBounds[1],s=e.ao(i,o,t),r=this.cameraPoint.clone();switch(3*((r.y>i.y)+(r.y>o.y))+((r.x>i.x)+(r.x>o.x))){case 0:s[0]=r,s[4]=r.clone();break;case 1:s.splice(1,0,r);break;case 2:s[1]=r;break;case 3:s.splice(4,0,r);break;case 5:s.splice(2,0,r);break;case 6:s[3]=r;break;case 7:s.splice(3,0,r);break;case 8:s[2]=r;}return s}containsTile(t,i,o,s=0){const r=t.queryPadding/i._pixelsPerMercatorPixel+1,n=o?this._bufferedCameraMercator(r,i):this._bufferedScreenMercator(r,i);let a=t.tileID.wrap+(n.unwrapped?s:0);const l=n.polygon.map((i=>e.aq(t.tileTransform,i,a)));if(!e.ar(l,0,0,e.aj,e.aj))return;a=t.tileID.wrap+(this.screenGeometryMercator.unwrapped?s:0);const c=this.screenGeometryMercator.polygon.map((i=>e.as(t.tileTransform,i,a))),h=c.map((t=>new e.P(t[0],t[1]))),d=i.getFreeCameraOptions().position||new e.ac(0,0,0),u=e.as(t.tileTransform,d,a),_=c.map((t=>{const i=e.at(t,t,u);return e.au(i,i),new e.av(u,i)})),p=e.aw(t,1,i.zoom)*i._pixelsPerMercatorPixel;return {queryGeometry:this,tilespaceGeometry:h,tilespaceRays:_,bufferedTilespaceGeometry:l,bufferedTilespaceBounds:(f=e.ax(l),f.min.x=e.ay(f.min.x,0,e.aj),f.min.y=e.ay(f.min.y,0,e.aj),f.max.x=e.ay(f.max.x,0,e.aj),f.max.y=e.ay(f.max.y,0,e.aj),f),tile:t,tileID:t.tileID,pixelToTileUnitsFactor:p};var f;}_bufferedScreenMercator(e,t){const i=Je(e);if(this._screenRaycastCache[i])return this._screenRaycastCache[i];{let o;return o="globe"===t.projection.name?this._projectAndResample(this.bufferedScreenGeometry(e),t):{polygon:this.bufferedScreenGeometry(e).map((e=>t.pointCoordinate3D(e))),unwrapped:!0},this._screenRaycastCache[i]=o,o}}_bufferedCameraMercator(e,t){const i=Je(e);if(this._cameraRaycastCache[i])return this._cameraRaycastCache[i];{let o;return o="globe"===t.projection.name?this._projectAndResample(this.bufferedCameraGeometryGlobe(e),t):{polygon:this.bufferedCameraGeometry(e).map((e=>t.pointCoordinate3D(e))),unwrapped:!0},this._cameraRaycastCache[i]=o,o}}_projectAndResample(t,i){const o=function(t,i){const o=e.az([],i.pixelMatrix,i.globeMatrix),s=[0,-e.aB,0,1],r=[0,e.aB,0,1],n=[0,0,0,1];e.aA(s,s,o),e.aA(r,r,o),e.aA(n,n,o);const a=new e.P(s[0]/s[3],s[1]/s[3]),l=new e.P(r[0]/r[3],r[1]/r[3]),c=e.aC(t,a)&&s[3]<n[3],h=e.aC(t,l)&&r[3]<n[3];if(!c&&!h)return null;const d=function(e,t,i){for(let o=1;o<e.length;o++){const s=Ke(t.pointCoordinate3D(e[o-1]).x),r=Ke(t.pointCoordinate3D(e[o]).x);if(i<0){if(s<r)return {idx:o,t:-s/(r-1-s)}}else if(r<s)return {idx:o,t:(1-s)/(r+1-s)}}return null}(t,i,c?-1:1);if(!d)return null;const{idx:u,t:_}=d;let p=u>1?Ye(t.slice(0,u),i):[],f=u<t.length?Ye(t.slice(u),i):[];p=p.map((t=>new e.P(Ke(t.x),t.y))),f=f.map((t=>new e.P(Ke(t.x),t.y)));const m=[...p];0===m.length&&m.push(f[f.length-1]);const g=e.ai(m[m.length-1].y,(0===f.length?p[0]:f[0]).y,_);let v;return v=c?[new e.P(0,g),new e.P(0,0),new e.P(1,0),new e.P(1,g)]:[new e.P(1,g),new e.P(1,1),new e.P(0,1),new e.P(0,g)],m.push(...v),0===f.length?m.push(p[0]):m.push(...f),{polygon:m.map((t=>new e.ac(t.x,t.y))),unwrapped:!1}}(t,i);if(o)return o;const s=function(t,i){let o=!1,s=-1/0,r=0;for(let e=0;e<t.length-1;e++)t[e].x>s&&(s=t[e].x,r=e);for(let e=0;e<t.length-1;e++){const i=(r+e)%(t.length-1),s=t[i],n=t[i+1];Math.abs(s.x-n.x)>.5&&(s.x<n.x?(s.x+=1,0===i&&(t[t.length-1].x+=1)):(n.x+=1,i+1===t.length-1&&(t[0].x+=1)),o=!0);}const n=e.aD(i.center.lng);return o&&n<Math.abs(n-1)&&t.forEach((e=>{e.x-=1;})),{polygon:t,unwrapped:o}}(Ye(t,i).map((t=>new e.P(Ke(t.x),t.y))),i);return {polygon:s.polygon.map((t=>new e.ac(t.x,t.y))),unwrapped:s.unwrapped}}}function Ye(t,i){return e.aE(t,(e=>{const t=i.pointCoordinate3D(e);e.x=t.x,e.y=t.y;}),1/256)}function Ke(e){return e<0?1+e%1:e%1}function Je(e){return 100*e|0}function Qe(t,i,o,s,r){const n=function(o,s){if(o)return r(o);if(s){if(t.url&&s.tiles&&t.tiles&&delete t.tiles,s.variants){if(!Array.isArray(s.variants))return r(new Error("variants must be an array"));for(const t of s.variants){if(null==t||"object"!=typeof t||t.constructor!==Object)return r(new Error("variant must be an object"));if(!Array.isArray(t.capabilities))return r(new Error("capabilities must be an array"));if(1===t.capabilities.length&&"meshopt"===t.capabilities[0]){s=e.h(s,t);break}}}const o=e.aF(e.h({},s,t),["tilejson","tiles","minzoom","maxzoom","attribution","mapbox_logo","bounds","extra_bounds","scheme","tileSize","encoding","vector_layers","raster_layers","worldview_options","worldview_default","worldview"]);o.tiles=i.canonicalizeTileset(o,t.url),r(null,o);}},a=function(e,t,i){if(!e)return null;if(!t&&!i)return e;i=i||e.worldview_default;const o=Object.values(e.language||{});if(0===o.length)return null;const s=Object.values(e.worldview||{});if(0===s.length)return null;const r=o.every((e=>e===t)),n=s.every((e=>e===i));return r&&n?e:t in(e.language_options||{})||i in(e.worldview_options||{})?null:e.language_options&&e.worldview_options?e:null}(t.data,o,s);return a?e.q.frame((()=>n(null,a))):t.url?e.n(i.transformRequest(i.normalizeSourceURL(t.url,null,o,s),e.R.Source),n):e.q.frame((()=>{const{data:e,...i}=t;n(null,i);}))}function et(t,i){const o=Math.pow(2,i.z),s=Math.floor(e.aD(t.getWest())*o),r=Math.floor(e.aH(t.getNorth())*o),n=Math.ceil(e.aD(t.getEast())*o),a=Math.ceil(e.aH(t.getSouth())*o);return i.x>=s&&i.x<n&&i.y>=r&&i.y<a}class tt{constructor(t,i,o){this.bounds=t?e.aG.convert(this.validateBounds(t)):null,this.minzoom=i||0,this.maxzoom=o||24;}validateBounds(e){return Array.isArray(e)&&4===e.length?[Math.max(-180,e[0]),Math.max(-90,e[1]),Math.min(180,e[2]),Math.min(90,e[3])]:[-180,-90,180,90]}addExtraBounds(t){if(t){this.extraBounds||(this.extraBounds=[]);for(const i of t)this.extraBounds.push(e.aG.convert(this.validateBounds(i)));}}contains(e){if(e.z>this.maxzoom||e.z<this.minzoom)return !1;if(this.bounds&&!et(this.bounds,e))return !1;if(!this.extraBounds)return !0;for(const t of this.extraBounds)if(et(t,e))return !0;return !1}static fromTileJSON(e){if(!e.bounds&&!e.extra_bounds)return null;const t=new tt(e.bounds,e.minzoom,e.maxzoom);return t.addExtraBounds(e.extra_bounds),t}}class it extends e.E{constructor(t,i,o,s){if(super(),this.id=t,this.dispatcher=o,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,e.h(this,e.aF(i,["url","scheme","tileSize","promoteId"])),this._options=e.h({type:"vector"},i),this._collectResourceTiming=!!i.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(s),this._tileWorkers={},this._deduped=new e.aI;}load(t){this._loaded=!1,this.fire(new e.A("dataloading",{dataType:"source"}));const i=Array.isArray(this.map._language)?this.map._language.join():this.map._language,o=this.map.getWorldview();this._tileJSONRequest=Qe(this._options,this.map._requestManager,i,o,((s,r)=>{if(this._tileJSONRequest=null,this._loaded=!0,s)i&&console.warn(`Ensure that your requested language string is a valid BCP-47 code or list of codes. Found: ${i}`),o&&console.warn(`Requested worldview strings must be a valid ISO alpha-2 code. Found: ${o}`),this.fire(new e.z(s));else if(r){if(e.h(this,r),this.hasWorldviews=!!r.worldview_options,r.worldview_default&&(this.worldviewDefault=r.worldview_default),r.vector_layers){this.vectorLayers=r.vector_layers,this.vectorLayerIds=[],this.localizableLayerIds=new Set;for(const e of r.vector_layers)this.vectorLayerIds.push(e.id),r.worldview&&r.worldview[e.source]&&this.localizableLayerIds.add(e.id);}this.tileBounds=tt.fromTileJSON(r),L(r.tiles,this.map._requestManager._customAccessToken),this.fire(new e.A("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.A("data",{dataType:"source",sourceDataType:"content"}));}t&&t(s);}));}loaded(){return this._loaded}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}onAdd(e){this.map=e,this.load();}reload(){this.cancelTileJSONRequest();const t=e.C(this.id,this.scope);this.load((()=>this.map.style.clearSource(t)));}setTiles(e){return this._options.tiles=e,this.reload(),this}setUrl(e){return this.url=e,this._options.url=e,this.reload(),this}onRemove(e){this.cancelTileJSONRequest();}serialize(){return e.h({},this._options)}loadTile(t,i){const o=t.tileID.canonical.url(this.tiles,this.scheme),s=this.map._requestManager.normalizeTileURL(o),r=this.map._requestManager.transformRequest(s,e.R.Tile),n=this.map.style?this.map.style.getLut(this.scope):null,a=n?{image:n.image.clone()}:null,l={request:r,data:void 0,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,lut:a,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,scope:this.scope,pixelRatio:e.q.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,isSymbolTile:t.isSymbolTile,brightness:this.map.style&&this.map.style.getBrightness()||0,extraShadowCaster:t.isExtraShadowCaster,tessellationStep:this.map._tessellationStep,scaleFactor:this.map.getScaleFactor(),worldview:this.map.getWorldview()||this.worldviewDefault};if(this.hasWorldviews&&e.j(o)&&(l.localizableLayerIds=this.localizableLayerIds),l.request.collectResourceTiming=this._collectResourceTiming,t.actor&&"expired"!==t.state)"loading"===t.state?t.reloadCallback=i:t.request=t.actor.send("reloadTile",l,c.bind(this));else if(t.actor=this._tileWorkers[s]=this._tileWorkers[s]||this.dispatcher.getActor(),this.dispatcher.ready)t.request=t.actor.send("loadTile",l,c.bind(this),void 0,!0);else {const i=e.aJ.call({deduped:this._deduped},l,((e,i)=>{e||!i?c.call(this,e):(l.data={cacheControl:i.cacheControl,expires:i.expires,rawData:i.rawData.slice(0)},t.actor&&t.actor.send("loadTile",l,c.bind(this),void 0,!0));}),!0);t.request={cancel:i};}function c(o,s){return delete t.request,t.aborted?i(null):o&&404!==o.status?i(o):(s&&s.resourceTiming&&(t.resourceTiming=s.resourceTiming),this.map._refreshExpiredTiles&&s&&t.setExpiryData(s),t.loadVectorData(s,this.map.painter),e.aK(this.dispatcher),i(null),void(t.reloadCallback&&(this.loadTile(t,t.reloadCallback),t.reloadCallback=null)))}}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.actor&&e.actor.send("abortTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope});}unloadTile(e,t){e.actor&&e.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope}),e.destroy();}hasTransition(){return !1}afterUpdate(){this._tileWorkers={};}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}}class ot extends e.E{constructor(t,i,o,s){super(),this.id=t,this.dispatcher=o,this.setEventedParent(s),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=e.h({type:"raster"},i),e.h(this,e.aF(i,["url","scheme","tileSize"]));}load(t){this._loaded=!1,this.fire(new e.A("dataloading",{dataType:"source"}));const i=this.map.getWorldview();this._tileJSONRequest=Qe(this._options,this.map._requestManager,null,i,((i,o)=>{this._tileJSONRequest=null,this._loaded=!0,i?this.fire(new e.z(i)):o&&(e.h(this,o),o.raster_layers&&(this.rasterLayers=o.raster_layers,this.rasterLayerIds=this.rasterLayers.map((e=>e.id))),this.tileBounds=tt.fromTileJSON(o),L(o.tiles),this.fire(new e.A("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.A("data",{dataType:"source",sourceDataType:"content"}))),t&&t(i);}));}loaded(){return this._loaded}onAdd(e){this.map=e,this.load();}reload(){this.cancelTileJSONRequest();const t=e.C(this.id,this.scope);this.load((()=>this.map.style.clearSource(t)));}setTiles(e){return this._options.tiles=e,this.reload(),this}setUrl(e){return this.url=e,this._options.url=e,this.reload(),this}onRemove(e){this.cancelTileJSONRequest();}serialize(){return e.h({},this._options)}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(t,i){const o=e.q.devicePixelRatio>=2,s=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),o,this.tileSize);t.request=e.o(this.map._requestManager.transformRequest(s,e.R.Tile),((o,s,r,n)=>(delete t.request,t.aborted?(t.state="unloaded",i(null)):o?(t.state="errored",i(o)):s?(this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:r,expires:n}),t.setTexture(s,this.map.painter),t.state="loaded",e.aK(this.dispatcher),void i(null)):i(null))));}abortTile(e,t){e.request&&(e.request.cancel(),delete e.request),t&&t();}unloadTile(t,i){t.texture&&t.texture instanceof e.T?(t.destroy(!0),t.texture&&t.texture instanceof e.T&&this.map.painter.saveTileTexture(t.texture)):t.destroy(),i&&i();}hasTransition(){return !1}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}}class st extends ot{constructor(t,i,o,s){super(t,i,o,s),this.type="raster-array",this.maxzoom=22,this.partial=!0,this._options=e.h({type:"raster-array"},i);}triggerRepaint(e){const t=this.map.painter._terrain,i=this.map.style.getSourceCache(this.id);t&&t.enabled&&i&&t._clearRenderCacheForTile(i.id,e.tileID),this.map.triggerRepaint();}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize),s=this.map._requestManager.transformRequest(o,e.R.Tile),r={request:s,uid:t.uid,tileID:t.tileID,type:this.type,source:this.id,scope:this.scope,partial:this.partial};t.source=this.id,t.scope=this.scope,t.requestParams=s,t.actor||(t.actor=this.dispatcher.getActor());const n=(e,o,s,r)=>{if(delete t.request,t.aborted)return t.state="unloaded",i(null);if(e){if("AbortError"===e.name)return;return t.state="errored",i(e)}if(this.map._refreshExpiredTiles&&o&&t.setExpiryData({cacheControl:s,expires:r}),this.partial)t.state="empty";else {if(!o)return i(null);t.state="loaded",t._isHeaderLoaded=!0,t._mrt=o;}i(null);};t.request=this.partial?t.fetchHeader(void 0,n.bind(this)):t.actor.send("loadTile",r,n.bind(this),void 0,!0);}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.actor&&e.actor.send("abortTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope});}unloadTile(t,i){const o=t.texture;o&&o instanceof e.T?(t.destroy(!0),this.map.painter.saveTileTexture(o)):(t.destroy(),t.flushQueues(),t._isHeaderLoaded=!1,delete t._mrt,delete t.textureDescriptor),t.fbo&&(t.fbo.destroy(),delete t.fbo),delete t.request,delete t.requestParams,delete t.neighboringTiles,t.state="unloaded";}prepareTile(t,i,o){t._isHeaderLoaded&&("empty"!==t.state&&(t.state="reloading"),t.fetchBand(i,o,((i,o)=>{if(i)return t.state="errored",this.fire(new e.z(i)),void this.triggerRepaint(t);o&&(t._isHeaderLoaded=!0,t.setTexture(o,this.map.painter),t.state="loaded",this.triggerRepaint(t));})));}getInitialBand(e){if(!this.rasterLayers)return 0;const t=this.rasterLayers.find((({id:t})=>t===e)),i=t&&t.fields,o=i&&i.bands&&i.bands;return o?o[0]:0}getTextureDescriptor(t,i,o){if(!t)return;const s=i.sourceLayer||this.rasterLayerIds&&this.rasterLayerIds[0];if(!s)return;let r=null;i instanceof e.aN?r=i.paint.get("raster-array-band"):i instanceof e.aO&&(r=i.paint.get("raster-particle-array-band"));const n=r||this.getInitialBand(s);if(null!=n)if(t.textureDescriptor){if(!t.updateNeeded(s,n)||o)return Object.assign({},t.textureDescriptor,{texture:t.texture})}else this.prepareTile(t,s,n);}getImages(t,i){const o=new Map;for(const s of t)for(const t of i){const[i,r]=t.split("/"),n=s.getLayer(i);if(!n)continue;if(!n.hasBand(r)||!n.hasDataForBand(r))continue;const{bytes:a,tileSize:l,buffer:c}=n.getBandView(r),h=l+2*c,d={data:new e.r({width:h,height:h},a),pixelRatio:2,sdf:!1,usvg:!1,version:0};o.set(t,d);}return o}}const rt={vector:it,raster:ot,"raster-dem":class extends ot{constructor(t,i,o,s){super(t,i,o,s),this.type="raster-dem",this.maxzoom=22,this._options=e.h({type:"raster-dem"},i),this.encoding=i.encoding||"mapbox";}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize);function s(e,o){e&&(t.state="errored",i(e)),o&&(t.dem=o,t.dem.onDeserialize(),t.needsHillshadePrepare=!0,t.needsDEMTextureUpload=!0,t.state="loaded",i(null));}t.request=e.o(this.map._requestManager.transformRequest(o,e.R.Tile),function(o,r,n,a){if(delete t.request,t.aborted)t.state="unloaded",i(null);else if(o)t.state="errored",i(o);else if(r){this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:n,expires:a});const i=ImageBitmap&&r instanceof ImageBitmap&&e.t(),o=1-(r.width-e.aL(r.width))/2;o<1||t.neighboringTiles||(t.neighboringTiles=this._getNeighboringTiles(t.tileID));const l=i?r:e.q.getImageData(r,o),c={uid:t.uid,tileID:t.tileID,source:this.id,type:this.type,scope:this.scope,rawImageData:l,encoding:this.encoding,padding:o};t.actor&&"expired"!==t.state||(t.actor=this.dispatcher.getActor(),t.actor.send("loadTile",c,s.bind(this),void 0,!0));}}.bind(this));}_getNeighboringTiles(t){const i=t.canonical,o=Math.pow(2,i.z),s=(i.x-1+o)%o,r=0===i.x?t.wrap-1:t.wrap,n=(i.x+1+o)%o,a=i.x+1===o?t.wrap+1:t.wrap,l={};return l[new e.aM(t.overscaledZ,r,i.z,s,i.y).key]={backfilled:!1},l[new e.aM(t.overscaledZ,a,i.z,n,i.y).key]={backfilled:!1},i.y>0&&(l[new e.aM(t.overscaledZ,r,i.z,s,i.y-1).key]={backfilled:!1},l[new e.aM(t.overscaledZ,t.wrap,i.z,i.x,i.y-1).key]={backfilled:!1},l[new e.aM(t.overscaledZ,a,i.z,n,i.y-1).key]={backfilled:!1}),i.y+1<o&&(l[new e.aM(t.overscaledZ,r,i.z,s,i.y+1).key]={backfilled:!1},l[new e.aM(t.overscaledZ,t.wrap,i.z,i.x,i.y+1).key]={backfilled:!1},l[new e.aM(t.overscaledZ,a,i.z,n,i.y+1).key]={backfilled:!1}),l}},"raster-array":st,geojson:class extends e.E{constructor(t,i,o,s){super(),this.id=t,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._loaded=!1,this.actor=o.getActor(),this.setEventedParent(s),this._data=i.data,this._options=e.h({},i),this._collectResourceTiming=i.collectResourceTiming,void 0!==i.maxzoom&&(this.maxzoom=i.maxzoom),void 0!==i.minzoom&&(this.minzoom=i.minzoom),i.type&&(this.type=i.type),i.attribution&&(this.attribution=i.attribution),this.promoteId=i.promoteId;const r=e.aj/this.tileSize;this.workerOptions=e.h({source:this.id,scope:this.scope,cluster:i.cluster||!1,geojsonVtOptions:{buffer:(void 0!==i.buffer?i.buffer:128)*r,tolerance:(void 0!==i.tolerance?i.tolerance:.375)*r,extent:e.aj,maxZoom:this.maxzoom,lineMetrics:i.lineMetrics||!1,generateId:i.generateId||!1},superclusterOptions:{maxZoom:void 0!==i.clusterMaxZoom?i.clusterMaxZoom:this.maxzoom-1,minPoints:Math.max(2,i.clusterMinPoints||2),extent:e.aj,radius:(void 0!==i.clusterRadius?i.clusterRadius:50)*r,log:!1,generateId:i.generateId||!1},clusterProperties:i.clusterProperties,filter:i.filter,dynamic:i.dynamic},i.workerOptions);}onAdd(e){this.map=e,this.setData(this._data);}setData(e){return this._data=e,this._updateWorkerData(),this}updateData(t){if(!this._options.dynamic)return this.fire(new e.z(new Error("Can't call updateData on a GeoJSON source with dynamic set to false.")));if("string"!=typeof t&&("Feature"===t.type&&(t={type:"FeatureCollection",features:[t]}),"FeatureCollection"!==t.type))return this.fire(new e.z(new Error("Data to update should be a feature or a feature collection.")));if(this._coalesce&&"string"!=typeof t&&"string"!=typeof this._data&&"FeatureCollection"===this._data.type){const e=new Map;for(const t of this._data.features)e.set(t.id,t);for(const i of t.features)e.set(i.id,i);this._data.features=[...e.values()];}else this._data=t;return this._updateWorkerData(!0),this}getClusterExpansionZoom(e,t){return this.actor.send("geojson.getClusterExpansionZoom",{clusterId:e,source:this.id,scope:this.scope},t),this}getClusterChildren(e,t){return this.actor.send("geojson.getClusterChildren",{clusterId:e,source:this.id,scope:this.scope},t),this}getClusterLeaves(e,t,i,o){return this.actor.send("geojson.getClusterLeaves",{source:this.id,scope:this.scope,clusterId:e,limit:t,offset:i},o),this}_updateWorkerData(t=!1){if(this._pendingLoad)return void(this._coalesce=!0);this.fire(new e.A("dataloading",{dataType:"source"})),this._loaded=!1;const i=e.h({append:t},this.workerOptions);i.scope=this.scope;const o=this._data;"string"==typeof o?(i.request=this.map._requestManager.transformRequest(e.q.resolveURL(o),e.R.Source),i.request.collectResourceTiming=this._collectResourceTiming):i.data=JSON.stringify(o),this._pendingLoad=this.actor.send(`${this.type}.loadData`,i,((i,o)=>{if(this._loaded=!0,this._pendingLoad=null,i)this.fire(new e.z(i));else {const i={dataType:"source",sourceDataType:this._metadataFired?"content":"metadata"};this._collectResourceTiming&&o&&o.resourceTiming&&o.resourceTiming[this.id]&&(i.resourceTiming=o.resourceTiming[this.id]),t&&(this._partialReload=!0),this.fire(new e.A("data",i)),this._partialReload=!1,this._metadataFired=!0;}this._coalesce&&(this._updateWorkerData(t),this._coalesce=!1);}));}loaded(){return this._loaded}reload(){const t=e.C(this.id,this.scope);this.map.style.clearSource(t),this._updateWorkerData();}loadTile(t,i){const o=t.actor?"reloadTile":"loadTile";t.actor=this.actor;const s=this.map.style?this.map.style.getLut(this.scope):null,r=s?{image:s.image.clone()}:null,n=this._partialReload,a={type:this.type,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,lut:r,scope:this.scope,pixelRatio:e.q.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,brightness:this.map.style&&this.map.style.getBrightness()||0,extraShadowCaster:t.isExtraShadowCaster,scaleFactor:this.map.getScaleFactor(),partial:n,worldview:this.map.getWorldview()};t.request=this.actor.send(o,a,((e,s)=>n&&!s?(t.state="loaded",i(null)):(delete t.request,t.destroy(),t.aborted?i(null):e?i(e):(t.loadVectorData(s,this.map.painter,"reloadTile"===o),i(null)))),void 0,"loadTile"===o);}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.aborted=!0;}unloadTile(e,t){this.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope}),e.destroy();}onRemove(e){this._pendingLoad&&this._pendingLoad.cancel();}serialize(){return e.h({},this._options,{type:this.type,data:this._data})}hasTransition(){return !1}},video:class extends e.aP{constructor(e,t,i,o){super(e,t,i,o),this.roundZoom=!0,this.type="video",this.options=t;}load(){this._loaded=!1;const t=this.options;this.urls=[];for(const i of t.urls)this.urls.push(this.map._requestManager.transformRequest(i,e.R.Source).url);e.aQ(this.urls,((t,i)=>{this._loaded=!0,t?this.fire(new e.z(t)):i&&(this.video=i,this.video.loop=!0,this.video.setAttribute("playsinline",""),this.video.addEventListener("playing",(()=>{this.map.triggerRepaint();})),this.map&&this.video.play(),this._finishLoading());}));}pause(){this.video&&this.video.pause();}play(){this.video&&this.video.play();}seek(t){if(this.video){const i=this.video.seekable;t<i.start(0)||t>i.end(0)?this.fire(new e.z(new e.V(`sources.${this.id}`,null,`Playback for this video can be set only between the ${i.start(0)} and ${i.end(0)}-second mark.`))):this.video.currentTime=t;}}getVideo(){return this.video}onAdd(e){this.map||(this.map=e,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)));}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const t=this.map.painter.context,i=t.gl;this.texture?this.video.paused||(this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),i.texSubImage2D(i.TEXTURE_2D,0,0,0,i.RGBA,i.UNSIGNED_BYTE,this.video)):(this.texture=new e.T(t,this.video,i.RGBA8),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),this.width=this.video.videoWidth,this.height=this.video.videoHeight),this._prepareData(t);}serialize(){return {type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}},image:e.aP,model:class extends e.E{constructor(e,t,i,o){super(),this.id=e,this.type="model",this.models=[],this._loaded=!1,this._options=t;}load(){const t=[];for(const i in this._options.models){const o=this._options.models[i],s=e.aS(this.map._requestManager.transformRequest(o.uri,e.R.Model).url).then((t=>{if(!t)return;const s=e.aT(t),r=new e.aU(i,o.position,o.orientation,s);r.computeBoundsAndApplyParent(),this.models.push(r);})).catch((t=>{this.fire(new e.z(new Error(`Could not load model ${i} from ${o.uri}: ${t.message}`)));}));t.push(s);}Promise.allSettled(t).then((()=>{this._loaded=!0,this.fire(new e.A("data",{dataType:"source",sourceDataType:"metadata"}));})).catch((t=>{this._loaded=!0,this.fire(new e.z(new Error(`Could not load models: ${t.message}`)));}));}onAdd(e){this.map=e,this.load();}hasTransition(){return !1}loaded(){return this._loaded}getModels(){return this.models}loadTile(e,t){}serialize(){return this._options}},"batched-model":class extends e.E{constructor(e,t,i,o){super(),this.type="batched-model",this.id=e,this.tileSize=512,this._options=t,this.tiles=this._options.tiles,this.maxzoom=t.maxzoom||19,this.minzoom=t.minzoom||0,this.roundZoom=!0,this.usedInConflation=!0,this.dispatcher=i,this.reparseOverscaled=!1,this.scheme="xyz",this._loaded=!1,this.setEventedParent(o);}onAdd(e){this.map=e,this.load();}reload(){this.cancelTileJSONRequest();const t=e.C(this.id,this.scope);this.load((()=>this.map.style.clearSource(t)));}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}load(t){this._loaded=!1,this.fire(new e.A("dataloading",{dataType:"source"}));const i=Array.isArray(this.map._language)?this.map._language.join():this.map._language,o=this.map.getWorldview();this._tileJSONRequest=Qe(this._options,this.map._requestManager,i,o,((s,r)=>{this._tileJSONRequest=null,this._loaded=!0,s?(i&&console.warn(`Ensure that your requested language string is a valid BCP-47 code or list of codes. Found: ${i}`),o&&2!==o.length&&console.warn(`Requested worldview strings must be a valid ISO alpha-2 code. Found: ${o}`),this.fire(new e.z(s))):r&&(e.h(this,r),r.bounds&&(this.tileBounds=new tt(r.bounds,this.minzoom,this.maxzoom)),L(r.tiles,this.map._requestManager._customAccessToken),this.fire(new e.A("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.A("data",{dataType:"source",sourceDataType:"content"}))),t&&t(s);}));}hasTransition(){return !1}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loaded(){return this._loaded}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme)),s={request:this.map._requestManager.transformRequest(o,e.R.Tile),data:void 0,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,scope:this.scope,showCollisionBoxes:this.map.showCollisionBoxes,isSymbolTile:t.isSymbolTile,brightness:this.map.style&&this.map.style.getBrightness()||0,pixelRatio:e.q.devicePixelRatio,promoteId:this.promoteId};if(t.actor&&"expired"!==t.state)if("loading"===t.state)t.reloadCallback=i;else {if(t.buckets){const e=Object.values(t.buckets);for(const t of e)t.dirty=!0;return void(t.state="loaded")}t.request=t.actor.send("reloadTile",s,r.bind(this));}else t.actor=this.dispatcher.getActor(),t.request=t.actor.send("loadTile",s,r.bind(this),void 0,!0);function r(e,o){return t.aborted?i(null):e&&404!==e.status?i(e):(this.map._refreshExpiredTiles&&o&&t.setExpiryData(o),t.loadModelData(o,this.map.painter),t.state="loaded",void i(null))}}serialize(){return e.h({},this._options)}},canvas:class extends e.aP{constructor(t,i,o,s){super(t,i,o,s),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some((e=>!Array.isArray(e)||2!==e.length||e.some((e=>"number"!=typeof e))))||this.fire(new e.z(new e.V(`sources.${t}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new e.z(new e.V(`sources.${t}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new e.z(new e.V(`sources.${t}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof HTMLCanvasElement||this.fire(new e.z(new e.V(`sources.${t}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new e.z(new e.V(`sources.${t}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate;}load(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new e.z(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint();},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1);},this._finishLoading());}getCanvas(){return this.canvas}onAdd(e){this.map=e,this.load(),this.canvas&&this.animate&&this.play();}onRemove(e){this.pause();}prepare(){let t=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,t=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,t=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const i=this.map.painter.context;this.texture?!t&&!this._playing||this.texture instanceof e.aR||this.texture.update(this.canvas,{premultiply:!0}):this.texture=new e.T(i,this.canvas,i.gl.RGBA8,{premultiply:!0}),this._prepareData(i);}serialize(){return {type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const e of [this.canvas.width,this.canvas.height])if(isNaN(e)||e<=0)return !0;return !1}},custom:class extends e.E{constructor(t,i,o,s){super(),this.id=t,this.type="custom",this._dataType="raster",this._dispatcher=o,this._implementation=i,this.setEventedParent(s),this.scheme="xyz",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this._loaded=!1,this.roundZoom=!0,this._implementation||this.fire(new e.z(new Error(`Missing implementation for ${this.id} custom source`))),this._implementation.loadTile||this.fire(new e.z(new Error(`Missing loadTile implementation for ${this.id} custom source`))),this._implementation.bounds&&(this.tileBounds=new tt(this._implementation.bounds,this.minzoom,this.maxzoom)),i.update=this._update.bind(this),i.clearTiles=this._clearTiles.bind(this),i.coveringTiles=this._coveringTiles.bind(this),e.h(this,e.aF(i,["dataType","scheme","minzoom","maxzoom","tileSize","attribution","minTileCacheSize","maxTileCacheSize"]));}serialize(){return e.aF(this,["type","scheme","minzoom","maxzoom","tileSize","attribution"])}load(){this._loaded=!0,this.fire(new e.A("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.A("data",{dataType:"source",sourceDataType:"content"}));}loaded(){return this._loaded}onAdd(t){this.map=t,this._loaded=!1,this.fire(new e.A("dataloading",{dataType:"source"})),this._implementation.onAdd&&this._implementation.onAdd(t),this.load();}onRemove(e){this._implementation.onRemove&&this._implementation.onRemove(e);}hasTile(e){if(this._implementation.hasTile){const{x:t,y:i,z:o}=e.canonical;return this._implementation.hasTile({x:t,y:i,z:o})}return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(e,t){const{x:i,y:o,z:s}=e.tileID.canonical,r=new AbortController;e.request=Promise.resolve(this._implementation.loadTile({x:i,y:o,z:s},{signal:r.signal})).then(function(i){return delete e.request,e.aborted?(e.state="unloaded",t(null)):void 0===i?(e.state="errored",t(null)):null===i?(this.loadTileData(e,{width:this.tileSize,height:this.tileSize,data:null}),e.state="loaded",t(null)):function(e){return e instanceof ImageData||e instanceof HTMLCanvasElement||e instanceof ImageBitmap||e instanceof HTMLImageElement}(i)?(this.loadTileData(e,i),e.state="loaded",void t(null)):(e.state="errored",t(new Error(`Can't infer data type for ${this.id}, only raster data supported at the moment`)))}.bind(this)).catch((i=>{"AbortError"!==i.name&&(e.state="errored",t(i));})),e.request.cancel=()=>r.abort();}loadTileData(e,t){e.setTexture(t,this.map.painter);}unloadTile(t,i){if(t.texture&&t.texture instanceof e.T?(t.destroy(!0),t.texture&&t.texture instanceof e.T&&this.map.painter.saveTileTexture(t.texture)):t.destroy(),this._implementation.unloadTile){const{x:e,y:i,z:o}=t.tileID.canonical;this._implementation.unloadTile({x:e,y:i,z:o});}i&&i();}abortTile(e,t){e.request&&e.request.cancel&&(e.request.cancel(),delete e.request),t&&t();}hasTransition(){return !1}_coveringTiles(){return this.map.transform.coveringTiles({tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,roundZoom:this.roundZoom}).map((e=>({x:e.canonical.x,y:e.canonical.y,z:e.canonical.z})))}_clearTiles(){const t=e.C(this.id,this.scope);this.map.style.clearSource(t);}_update(){this.fire(new e.A("data",{dataType:"source",sourceDataType:"content"}));}}},nt=function(t,i,o,s){const r=new rt[i.type](t,i,o,s);if(r.id!==t)throw new Error(`Expected Source id to be ${t} instead of ${r.id}`);return e.aV(["load","abort","unload","serialize","prepare"],r),r};function at(e,t,i=""){return `${i}:${t.id||""}:${t.layer.id}:${function(e){if("layerId"in e)return `layer:${e.layerId}`;{const{featuresetId:t,importId:i}=e;return `featureset:${t}${i?`:import:${i}`:""}`}}(e.target)}`}function lt(e,t,i,o=""){if(e.uniqueFeatureID){const s=at(e,t,o);if(i.has(s))return !0;i.add(s);}return !1}function ct(e,t,i,o,s=!1){const r=t.sourceCache.transform,n=t.sourceCache.tilesIn(e,t.has3DLayers,s);n.sort(ut);const a=[];for(const e of n){const n=e.tile.queryRenderedFeatures(t,e,i,o,r,s);Object.keys(n).length&&a.push({wrappedTileID:e.tile.tileID.wrapped().key,queryResults:n});}return 0===a.length?{}:function(e){const t={},i={};for(const o of e){const e=o.queryResults,s=o.wrappedTileID,r=i[s]=i[s]||{};for(const i in e){const o=e[i],s=r[i]=r[i]||{},n=t[i]=t[i]||[];for(const e of o)s[e.featureIndex]||(s[e.featureIndex]=!0,n.push(e));}}return t}(a)}function ht(e,t,i,o,s,r){const n={},a=o.queryRenderedSymbols(e),l=[];for(const e of Object.keys(a).map(Number))l.push(s[e]);l.sort(ut);for(const e of l){const o=e.featureIndex.lookupSymbolFeatures(a[e.bucketInstanceId],e.bucketIndex,e.sourceLayerIndex,t,i,r);for(const t in o){const i=n[t]=n[t]||[],s=o[t];s.sort(((t,i)=>{const o=e.featureSortOrder;if(o){const e=o.indexOf(t.featureIndex);return o.indexOf(i.featureIndex)-e}return i.featureIndex-t.featureIndex}));for(const e of s)i.push(e);}}return n}function dt(e,t){const i=e.getRenderableIds().map((t=>e.getTileByID(t))),o=[],s={};for(let e=0;e<i.length;e++){const r=i[e],n=r.tileID.canonical.key;s[n]||(s[n]=!0,r.querySourceFeatures(o,t));}return o}function ut(e,t){const i=e.tileID,o=t.tileID;return i.overscaledZ-o.overscaledZ||i.canonical.y-o.canonical.y||i.wrap-o.wrap||i.canonical.x-o.canonical.x}function _t(e,t){const i={};if(!t)return i;for(const o of e){const e=o.layerIds.map((e=>t.getLayer(e))).filter(Boolean);if(0!==e.length){o.layers=e,o.stateDependentLayerIds&&(o.stateDependentLayers=o.stateDependentLayerIds.map((t=>e.filter((e=>e.id===t))[0])));for(const t of e)i[t.fqid]=o;}}return i}const pt=32,ft=33,mt=new Uint16Array(8184);for(let e=0;e<2046;e++){let t=e+2,i=0,o=0,s=0,r=0,n=0,a=0;for(1&t?s=r=n=pt:i=o=a=pt;(t>>=1)>1;){const e=i+s>>1,l=o+r>>1;1&t?(s=i,r=o,i=n,o=a):(i=s,o=r,s=n,r=a),n=e,a=l;}const l=4*e;mt[l+0]=i,mt[l+1]=o,mt[l+2]=s,mt[l+3]=r;}const gt=new Uint16Array(2178),vt=new Uint8Array(1089),yt=new Uint16Array(1089);function xt(e){return 0===e?-.03125:32===e?.03125:0}const bt=(()=>({type:2,extent:e.aj,loadGeometry:()=>[[new e.P(0,0),new e.P(e.aj+1,0),new e.P(e.aj+1,e.aj+1),new e.P(0,e.aj+1),new e.P(0,0)]]}))();class wt{constructor(t,i,o,s,r,n){this.tileID=t,this.uid=e.a$(),this.uses=0,this.tileSize=i,this.tileZoom=o,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.isRaster=r,s&&s.style&&(this._lastUpdatedBrightness=s.style.getBrightness()),this.expiredRequestCount=0,this.state="loading",s&&s.transform&&(this.projection=s.transform.projection),this.worldview=n;}registerFadeDuration(t){const i=t+this.timeAdded;i<e.q.now()||this.fadeEndTime&&i<this.fadeEndTime||(this.fadeEndTime=i);}wasRequested(){return "errored"===this.state||"loaded"===this.state||"reloading"===this.state}get tileTransform(){return this._tileTransform||(this._tileTransform=e.aW(this.tileID.canonical,this.projection)),this._tileTransform}loadVectorData(t,i,o){if(this.unloadVectorData(),this.state="loaded",t){t.featureIndex&&(this.latestFeatureIndex=t.featureIndex,t.rawTileData?(this.latestRawTileData=t.rawTileData,this.latestFeatureIndex.rawTileData=t.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=t.collisionBoxArray,this.buckets=_t(t.buckets,i.style),this.hasSymbolBuckets=!1;for(const t in this.buckets){const i=this.buckets[t];if(i instanceof e.b1){if(this.hasSymbolBuckets=!0,!o)break;i.justReloaded=!0;}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const t in this.buckets){const i=this.buckets[t];if(i instanceof e.b1&&i.hasRTLText){this.hasRTLText=!0,e.b2();break}}this.queryPadding=0;for(const e in this.buckets){const t=this.buckets[e],o=i.style.getOwnLayer(e);if(!o)continue;const s=o.queryRadius(t);this.queryPadding=Math.max(this.queryPadding,s);}t.imageAtlas&&(this.imageAtlas=t.imageAtlas),t.glyphAtlasImage&&(this.glyphAtlasImage=t.glyphAtlasImage),t.lineAtlas&&(this.lineAtlas=t.lineAtlas),this._lastUpdatedBrightness=t.brightness;}else this.collisionBoxArray=new e.b0;}unloadVectorData(){if(this.hasData()){for(const e in this.buckets)this.buckets[e].destroy();this.buckets={},this.imageAtlas&&(this.imageAtlas=null),this.lineAtlas&&(this.lineAtlas=null),this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.lineAtlasTexture&&this.lineAtlasTexture.destroy(),this._tileBoundsBuffer&&(this._tileBoundsBuffer.destroy(),this._tileBoundsIndexBuffer.destroy(),this._tileBoundsSegments.destroy(),this._tileBoundsBuffer=null),this._tileDebugBuffer&&(this._tileDebugBuffer.destroy(),this._tileDebugSegments.destroy(),this._tileDebugBuffer=null),this._tileDebugIndexBuffer&&(this._tileDebugIndexBuffer.destroy(),this._tileDebugIndexBuffer=null),this._globeTileDebugBorderBuffer&&(this._globeTileDebugBorderBuffer.destroy(),this._globeTileDebugBorderBuffer=null),this._tileDebugTextBuffer&&(this._tileDebugTextBuffer.destroy(),this._tileDebugTextSegments.destroy(),this._tileDebugTextIndexBuffer.destroy(),this._tileDebugTextBuffer=null),this._globeTileDebugTextBuffer&&(this._globeTileDebugTextBuffer.destroy(),this._globeTileDebugTextBuffer=null),this.latestFeatureIndex=null,this.state="unloaded";}}loadModelData(e,t,i){e&&(e.resourceTiming&&(this.resourceTiming=e.resourceTiming),this.buckets=Object.assign({},this.buckets,_t(e.buckets,t.style)),e.featureIndex&&(this.latestFeatureIndex=e.featureIndex));}getBucket(e){return this.buckets[e.fqid]}upload(t){for(const e in this.buckets){const i=this.buckets[e];i.uploadPending()&&i.upload(t);}const i=t.gl,o=this.imageAtlas;o&&!o.uploaded&&(this.imageAtlasTexture=new e.T(t,o.image,i.RGBA8,{useMipmap:!!o.patternPositions.size}),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new e.T(t,this.glyphAtlasImage,i.R8),this.glyphAtlasImage=null),this.lineAtlas&&!this.lineAtlas.uploaded&&(this.lineAtlasTexture=new e.T(t,this.lineAtlas.image,i.R8),this.lineAtlas.uploaded=!0);}prepare(e,t,i){if(this.imageAtlas&&this.imageAtlasTexture&&this.imageAtlas.patchUpdatedImages(e,this.imageAtlasTexture,i),!t||!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData)return;const o=t.style.getBrightness();(this._lastUpdatedBrightness||o)&&(this._lastUpdatedBrightness&&o&&Math.abs(this._lastUpdatedBrightness-o)<.001||(this.updateBuckets(t,this._lastUpdatedBrightness!==o),this._lastUpdatedBrightness=o));}queryRenderedFeatures(t,i,o,s,r,n){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData&&!this.latestFeatureIndex.is3DTile)return {};const a=function(t,i){const o=e.bn([],[.5*t.width,.5*-t.height,1]);return e.bo(o,o,[1,-1,0]),e.az(o,o,t.calculateProjMatrix(i.toUnwrapped())),Float32Array.from(o)}(r,this.tileID);return this.latestFeatureIndex.query(t,{tilespaceGeometry:i,pixelPosMatrix:a,transform:s,availableImages:o,tileTransform:this.tileTransform,worldview:this.worldview})}querySourceFeatures(t,i){const o=this.latestFeatureIndex;if(!o||!o.rawTileData)return;const s=o.loadVTLayers(),r=i?i.sourceLayer:"",n=s._geojsonTileLayer||s[r];if(!n)return;const a=e.b3(i&&i.filter),{z:l,x:c,y:h}=this.tileID.canonical,d={z:l,x:c,y:h};for(let i=0;i<n.length;i++){const s=n.feature(i);if(a.needGeometry){const t=e.b4(s,!0);if(!a.filter(new e.aa(this.tileID.overscaledZ,{worldview:this.worldview}),t,this.tileID.canonical))continue}else if(!a.filter(new e.aa(this.tileID.overscaledZ,{worldview:this.worldview}),s))continue;const u=o.getId(s,r),_=new e.b5(s,l,c,h,u);_.tile=d,t.push(_);}}loaded(){return "loaded"===this.state||"errored"===this.state}hasData(){return "loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return !!this.imageAtlas&&!!this.imageAtlas.patternPositions.size}setExpiryData(t){const i=this.expirationTime;if(t.cacheControl){const i=e.b6(t.cacheControl);i["max-age"]&&(this.expirationTime=Date.now()+1e3*i["max-age"]);}else t.expires&&(this.expirationTime=new Date(t.expires).getTime());if(this.expirationTime){const e=Date.now();let t=!1;if(this.expirationTime>e)t=!1;else if(i)if(this.expirationTime<i)t=!0;else {const o=this.expirationTime-i;o?this.expirationTime=e+Math.max(o,3e4):t=!0;}else t=!0;t?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0;}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}refreshFeatureState(e){this.latestFeatureIndex&&(this.latestFeatureIndex.rawTileData||this.latestFeatureIndex.is3DTile)&&e&&this.updateBuckets(e);}updateBuckets(t,i){if(!this.latestFeatureIndex)return;if(!t.style)return;const o=this.latestFeatureIndex.loadVTLayers(),s=t.style.listImages(),r=t.style.getBrightness();for(const n in this.buckets){if(!t.style.hasLayer(n))continue;const a=this.buckets[n],l=a.layers[0],c=l.sourceLayer||"_geojsonTileLayer",h=o[c],d=t.style.getLayerSourceCache(l);let u={};d&&(u=d._state.getState(c,void 0));const _=this.imageAtlas?Object.fromEntries(this.imageAtlas.patternPositions):{},p=Object.keys(u).length>0&&!i;p&&!a.stateDependentLayers.length&&!i||a.update(u,h,s,_,p?a.stateDependentLayers:a.layers,i,r),(a instanceof e.b7||a instanceof e.b8)&&t._terrain&&t._terrain.enabled&&d&&a.uploadPending()&&t._terrain._clearRenderCacheForTile(d.id,this.tileID);const f=t&&t.style&&t.style.getOwnLayer(n);f&&(this.queryPadding=Math.max(this.queryPadding,f.queryRadius(a)));}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return !this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<e.q.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0;}setHoldDuration(t){this.symbolFadeHoldUntil=e.q.now()+t;}setTexture(t,i){const o=i.context,s=o.gl;this.texture=this.texture||i.getTileTexture(t.width),this.texture&&this.texture instanceof e.T?this.texture.update(t):(this.texture=new e.T(o,t,s.RGBA8,{useMipmap:!0}),this.texture.bind(s.LINEAR,s.CLAMP_TO_EDGE));}setDependencies(e,t){const i={};for(const e of t)i[e]=!0;this.dependencies[e]=i;}hasDependency(e,t){for(const i of e){const e=this.dependencies[i];if(e)for(const i of t)if(e[i])return !0}return !1}clearQueryDebugViz(){}_makeDebugTileBoundsBuffers(t,i){if(!i||"mercator"===i.name||this._tileDebugBuffer)return;const o=e.b9(bt,this.tileID.canonical,this.tileTransform)[0],s=new e.ba,r=new e.bb;for(let e=0;e<o.length;e++){const{x:t,y:i}=o[e];s.emplaceBack(t,i),r.emplaceBack(e);}r.emplaceBack(0),this._tileDebugIndexBuffer=t.createIndexBuffer(r),this._tileDebugBuffer=t.createVertexBuffer(s,e.bc.members),this._tileDebugSegments=e.bd.simpleSegment(0,0,s.length,r.length);}_makeTileBoundsBuffers(t,i){if(this._tileBoundsBuffer||!i||"mercator"===i.name)return;const o=e.b9(bt,this.tileID.canonical,this.tileTransform)[0];let s,r;if(this.isRaster){const t=function(t,i){const o=e.aW(t,i),s=Math.pow(2,t.z);for(let r=0;r<ft;r++)for(let n=0;n<ft;n++){const a=e.aX((t.x+(n+xt(n))/pt)/s),l=e.aY((t.y+(r+xt(r))/pt)/s),c=i.project(a,l),h=r*ft+n;gt[2*h+0]=Math.round((c.x*o.scale-o.x)*e.aj),gt[2*h+1]=Math.round((c.y*o.scale-o.y)*e.aj);}vt.fill(0),yt.fill(0);for(let e=2045;e>=0;e--){const t=4*e,i=mt[t+0],o=mt[t+1],s=mt[t+2],r=mt[t+3],n=i+s>>1,a=o+r>>1,l=n+a-o,c=a+i-n,h=o*ft+i,d=r*ft+s,u=a*ft+n,_=Math.hypot((gt[2*h+0]+gt[2*d+0])/2-gt[2*u+0],(gt[2*h+1]+gt[2*d+1])/2-gt[2*u+1])>=16;vt[u]=vt[u]||(_?1:0),e<1022&&(vt[u]=vt[u]||vt[(o+c>>1)*ft+(i+l>>1)]||vt[(r+c>>1)*ft+(s+l>>1)]);}const r=new e.aZ,n=new e.a_;let a=0;function l(t,i){const o=i*ft+t;return 0===yt[o]&&(r.emplaceBack(gt[2*o+0],gt[2*o+1],t*e.aj/pt,i*e.aj/pt),yt[o]=++a),yt[o]-1}function c(e,t,i,o,s,r){const a=e+i>>1,h=t+o>>1;if(Math.abs(e-s)+Math.abs(t-r)>1&&vt[h*ft+a])c(s,r,e,t,a,h),c(i,o,s,r,a,h);else {const a=l(e,t),c=l(i,o),h=l(s,r);n.emplaceBack(a,c,h);}}return c(0,0,pt,pt,pt,0),c(pt,pt,0,0,0,pt),{vertices:r,indices:n}}(this.tileID.canonical,i);s=t.vertices,r=t.indices;}else {s=new e.aZ,r=new e.a_;for(const{x:e,y:t}of o)s.emplaceBack(e,t,0,0);const t=e.be(s.int16.subarray(0,4*s.length),void 0,4);for(let e=0;e<t.length;e+=3)r.emplaceBack(t[e],t[e+1],t[e+2]);}this._tileBoundsBuffer=t.createVertexBuffer(s,e.bf.members),this._tileBoundsIndexBuffer=t.createIndexBuffer(r),this._tileBoundsSegments=e.bd.simpleSegment(0,0,s.length,r.length);}_makeGlobeTileDebugBuffers(t,i){const o=i.projection;if(!o||"globe"!==o.name||i.freezeTileCoverage)return;const s=this.tileID.canonical,r=e.bg(s,i),n=e.bh(r),a=e.ah(i.zoom);let l;a>0&&(l=e.bi(new Float64Array(16),i.globeMatrix)),this._makeGlobeTileDebugBorderBuffer(t,s,i,n,l,a),this._makeGlobeTileDebugTextBuffer(t,s,i,n,l,a);}_globePoint(t,i,o,s,r,n,a){let l=e.bj(t,i,o);if(n){const r=1<<o.z,c=e.aD(s.center.lng),h=e.aH(s.center.lat),d=(o.x+.5)/r-c;let u=0;d>.5?u=-1:d<-.5&&(u=1);let _=(t/e.aj+o.x)/r+u,p=(i/e.aj+o.y)/r;_=(_-c)*s._pixelsPerMercatorPixel+c,p=(p-h)*s._pixelsPerMercatorPixel+h;const f=[_*s.worldSize,p*s.worldSize,0];e.ad(f,f,n),l=e.bk(l,f,a);}return e.ad(l,l,r)}_makeGlobeTileDebugBorderBuffer(t,i,o,s,r,n){const a=new e.ba,l=new e.bb,c=new e.bl,h=(e,t,h,d,u)=>{const _=(h-e)/(u-1),p=(d-t)/(u-1),f=a.length;for(let h=0;h<u;h++){const d=e+h*_,u=t+h*p;a.emplaceBack(d,u);const m=this._globePoint(d,u,i,o,s,r,n);c.emplaceBack(m[0],m[1],m[2]),l.emplaceBack(f+h);}},d=e.aj;h(0,0,d,0,16),h(d,0,d,d,16),h(d,d,0,d,16),h(0,d,0,0,16),this._tileDebugIndexBuffer=t.createIndexBuffer(l),this._tileDebugBuffer=t.createVertexBuffer(a,e.bc.members),this._globeTileDebugBorderBuffer=t.createVertexBuffer(c,e.bm.members),this._tileDebugSegments=e.bd.simpleSegment(0,0,a.length,l.length);}_makeGlobeTileDebugTextBuffer(t,i,o,s,r,n){const a=e.aj/4,l=new e.ba,c=new e.a_,h=new e.bl,d=25;c.reserve(32),l.reserve(d),h.reserve(d);const u=(e,t)=>d*e+t;for(let e=0;e<d;e++){const t=e*a;for(let e=0;e<d;e++){const c=e*a;l.emplaceBack(c,t);const d=this._globePoint(c,t,i,o,s,r,n);h.emplaceBack(d[0],d[1],d[2]);}}for(let e=0;e<4;e++)for(let t=0;t<4;t++){const i=u(e,t),o=u(e,t+1),s=u(e+1,t),r=u(e+1,t+1);c.emplaceBack(i,o,s),c.emplaceBack(s,o,r);}this._tileDebugTextIndexBuffer=t.createIndexBuffer(c),this._tileDebugTextBuffer=t.createVertexBuffer(l,e.bc.members),this._globeTileDebugTextBuffer=t.createVertexBuffer(h,e.bm.members),this._tileDebugTextSegments=e.bd.simpleSegment(0,0,d,32);}destroy(t=!1){for(const e in this.buckets)this.buckets[e].destroy();this.buckets={},this.imageAtlas&&(this.imageAtlas=null),this.lineAtlas&&(this.lineAtlas=null),this.imageAtlasTexture&&(this.imageAtlasTexture.destroy(),delete this.imageAtlasTexture),this.glyphAtlasTexture&&(this.glyphAtlasTexture.destroy(),delete this.glyphAtlasTexture),this.lineAtlasTexture&&(this.lineAtlasTexture.destroy(),delete this.lineAtlasTexture),this._tileBoundsBuffer&&(this._tileBoundsBuffer.destroy(),this._tileBoundsIndexBuffer.destroy(),this._tileBoundsSegments.destroy(),this._tileBoundsBuffer=null),this._tileDebugBuffer&&(this._tileDebugBuffer.destroy(),this._tileDebugSegments.destroy(),this._tileDebugBuffer=null),this._tileDebugIndexBuffer&&(this._tileDebugIndexBuffer.destroy(),this._tileDebugIndexBuffer=null),this._globeTileDebugBorderBuffer&&(this._globeTileDebugBorderBuffer.destroy(),this._globeTileDebugBorderBuffer=null),this._tileDebugTextBuffer&&(this._tileDebugTextBuffer.destroy(),this._tileDebugTextSegments.destroy(),this._tileDebugTextIndexBuffer.destroy(),this._tileDebugTextBuffer=null),this._globeTileDebugTextBuffer&&(this._globeTileDebugTextBuffer.destroy(),this._globeTileDebugTextBuffer=null),!t&&this.texture&&this.texture instanceof e.T&&(this.texture.destroy(),delete this.texture),this.hillshadeFBO&&(this.hillshadeFBO.destroy(),delete this.hillshadeFBO),this.dem&&delete this.dem,this.neighboringTiles&&delete this.neighboringTiles,this.demTexture&&(this.demTexture.destroy(),delete this.demTexture),this.rasterParticleState&&(this.rasterParticleState.destroy(),delete this.rasterParticleState),this.latestFeatureIndex=null,this.state="unloaded";}}e.bp.setPbf(e.bq);class Tt extends wt{constructor(e,t,i,o,s){super(e,t,i,o,s),this._workQueue=[],this._fetchQueue=[],this._isHeaderLoaded=!1;}getLayers(){return this._mrt?Object.values(this._mrt.layers):[]}getLayer(e){return this._mrt&&this._mrt.getLayer(e)}setTexture(t,i){const o=i.context,s=o.gl;this.texture=this.texture||i.getTileTexture(t.width),this.texture&&this.texture instanceof e.T?this.texture.update(t,{premultiply:!1}):this.texture=new e.T(o,t,s.RGBA8,{premultiply:!1});}flushQueues(){for(;this._workQueue.length;)this._workQueue.pop()();for(;this._fetchQueue.length;)this._fetchQueue.pop()();}fetchHeader(t=16384,i){const o=this._mrt=new e.bp(30),s=Object.assign({},this.requestParams,{headers:{Range:"bytes=0-"+(t-1)}});return this.entireBuffer=null,this.request=e.br(s,((e,s,r,n)=>{if(e)i(e);else try{const e=o.getHeaderLength(s);if(e>t)return void(this.request=this.fetchHeader(e,i));o.parseHeader(s),this._isHeaderLoaded=!0;let a=0;for(const e of Object.values(o.layers))a=Math.max(a,e.dataIndex[e.dataIndex.length-1].lastByte);s.byteLength>=a&&(this.entireBuffer=s),i(null,this.entireBuffer||s,r,n);}catch(e){i(e);}})),this.request}fetchBand(t,i,o){const s=this._mrt;if(!this._isHeaderLoaded||!s)return void o(new Error("Tile header is not ready"));const r=this.actor;if(!r)return void o(new Error("Can't fetch tile band without an actor"));let n;const a=(e,s)=>{n.complete(e,s),e?o(e):(this.updateTextureDescriptor(t,i),o(null,this.textureDescriptor&&this.textureDescriptor.img));},l=(e,t)=>{if(e)return o(e);const i=r.send("decodeRasterArray",{type:"raster-array",source:this.source,scope:this.scope,tileID:this.tileID,uid:this.uid,buffer:t,task:n},a,void 0,!0);this._workQueue.push((()=>{i&&i.cancel(),n.cancel();}));},c=s.getLayer(t);if(!c)return void o(new Error(`Unknown sourceLayer "${t}"`));if(c.hasDataForBand(i))return this.updateTextureDescriptor(t,i),void o(null,this.textureDescriptor?this.textureDescriptor.img:null);const h=c.getDataRange([i]);if(n=s.createDecodingTask(h),!n||n.tasks.length)if(this.flushQueues(),this.entireBuffer)l(null,this.entireBuffer.slice(h.firstByte,h.lastByte+1));else {const t=Object.assign({},this.requestParams,{headers:{Range:`bytes=${h.firstByte}-${h.lastByte}`}}),i=e.br(t,l);this._fetchQueue.push((()=>{i.cancel(),n.cancel();}));}else o(null);}updateNeeded(e,t){return (!this.textureDescriptor||this.textureDescriptor.band!==t||this.textureDescriptor.layer!==e)&&"errored"!==this.state}updateTextureDescriptor(t,i){if(!this._mrt)return;const o=this._mrt.getLayer(t);if(!o||!o.hasBand(i)||!o.hasDataForBand(i))return;const{bytes:s,tileSize:r,buffer:n,offset:a,scale:l}=o.getBandView(i),c=r+2*n,h=new e.r({width:c,height:c},s),d=this.texture;d&&d instanceof e.T&&d.update(h,{premultiply:!1}),this.textureDescriptor={layer:t,band:i,img:h,buffer:n,offset:a,tileSize:r,format:o.pixelFormat,mix:[l,256*l,65536*l,16777216*l]};}}class Et{constructor(e,t){this.max=e,this.onRemove=t,this.reset();}reset(){for(const e in this.data)for(const t of this.data[e])t.timeout&&clearTimeout(t.timeout),this.onRemove(t.value);return this.data={},this.order=[],this}add(e,t,i){const o=e.wrapped().key;void 0===this.data[o]&&(this.data[o]=[]);const s={value:t,timeout:void 0};if(void 0!==i&&(s.timeout=setTimeout((()=>{this.remove(e,s);}),i)),this.data[o].push(s),this.order.push(o),this.order.length>this.max){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e);}return this}has(e){return e.wrapped().key in this.data}getAndRemove(e){return this.has(e)?this._getAndRemoveByKey(e.wrapped().key):null}_getAndRemoveByKey(e){const t=this.data[e].shift();return t.timeout&&clearTimeout(t.timeout),0===this.data[e].length&&delete this.data[e],this.order.splice(this.order.indexOf(e),1),t.value}getByKey(e){const t=this.data[e];return t?t[0].value:null}get(e){return this.has(e)?this.data[e.wrapped().key][0].value:null}remove(e,t){if(!this.has(e))return this;const i=e.wrapped().key,o=void 0===t?0:this.data[i].indexOf(t),s=this.data[i][o];return this.data[i].splice(o,1),s.timeout&&clearTimeout(s.timeout),0===this.data[i].length&&delete this.data[i],this.onRemove(s.value),this.order.splice(this.order.indexOf(i),1),this}setMaxSize(e){for(this.max=e;this.order.length>this.max;){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e);}return this}filter(e){const t=[];for(const i in this.data)for(const o of this.data[i])e(o.value)||t.push(o);for(const e of t)this.remove(e.value.tileID,e);}}class St{constructor(){this.state={},this.stateChanges={},this.deletedStates={};}updateState(t,i,o){const s=String(i);if(this.stateChanges[t]=this.stateChanges[t]||{},this.stateChanges[t][s]=this.stateChanges[t][s]||{},e.h(this.stateChanges[t][s],o),null===this.deletedStates[t]){this.deletedStates[t]={};for(const e in this.state[t])e!==s&&(this.deletedStates[t][e]=null);}else if(this.deletedStates[t]&&null===this.deletedStates[t][s]){this.deletedStates[t][s]={};for(const e in this.state[t][s])o[e]||(this.deletedStates[t][s][e]=null);}else for(const e in o)this.deletedStates[t]&&this.deletedStates[t][s]&&null===this.deletedStates[t][s][e]&&delete this.deletedStates[t][s][e];}removeFeatureState(e,t,i){if(null===this.deletedStates[e])return;const o=String(t);if(this.deletedStates[e]=this.deletedStates[e]||{},i&&void 0!==t)null!==this.deletedStates[e][o]&&(this.deletedStates[e][o]=this.deletedStates[e][o]||{},this.deletedStates[e][o][i]=null);else if(void 0!==t)if(this.stateChanges[e]&&this.stateChanges[e][o])for(i in this.deletedStates[e][o]={},this.stateChanges[e][o])this.deletedStates[e][o][i]=null;else this.deletedStates[e][o]=null;else this.deletedStates[e]=null;}getState(t,i){const o=this.state[t]||{},s=this.stateChanges[t]||{},r=this.deletedStates[t];if(null===r)return {};if(void 0!==i){const t=String(i),n=e.h({},o[t],s[t]);if(r){const e=r[i];if(null===e)return {};for(const t in e)delete n[t];}return n}const n=e.h({},o,s);if(r)for(const e in r)delete n[e];return n}initializeTileState(e,t){e.refreshFeatureState(t);}coalesceChanges(t,i){const o={};for(const t in this.stateChanges){this.state[t]=this.state[t]||{};const i={};for(const o in this.stateChanges[t])this.state[t][o]||(this.state[t][o]={}),e.h(this.state[t][o],this.stateChanges[t][o]),i[o]=this.state[t][o];o[t]=i;}for(const t in this.deletedStates){this.state[t]=this.state[t]||{};const i={};if(null===this.deletedStates[t])for(const e in this.state[t])i[e]={},this.state[t][e]={};else for(const e in this.deletedStates[t]){if(null===this.deletedStates[t][e])this.state[t][e]={};else if(this.state[t][e])for(const i of Object.keys(this.deletedStates[t][e]))delete this.state[t][e][i];i[e]=this.state[t][e];}o[t]=o[t]||{},e.h(o[t],i);}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(o).length)for(const e in t)t[e].refreshFeatureState(i);}}class It extends e.E{constructor(e,t,i){super(),this.id=e,this._onlySymbols=i,t.on("data",(e=>{"source"===e.dataType&&"metadata"===e.sourceDataType&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===e.dataType&&"content"===e.sourceDataType&&(this.reload(),this.transform&&this.update(this.transform));})),t.on("error",(()=>{this._sourceErrored=!0;})),this._source=t,this._tiles={},this._cache=new Et(0,this._unloadTile.bind(this)),this._timers={},this._cacheTimers={},this._minTileCacheSize=t.minTileCacheSize,this._maxTileCacheSize=t.maxTileCacheSize,this._loadedParentTiles={},this.castsShadows=!1,this.tileCoverLift=0,this._coveredTiles={},this._shadowCasterTiles={},this._state=new St,this._isRaster="raster"===this._source.type||"raster-dem"===this._source.type||"raster-array"===this._source.type||"custom"===this._source.type&&"raster"===this._source._dataType;}onAdd(e){this.map=e,this._minTileCacheSize=void 0===this._minTileCacheSize&&e?e._minTileCacheSize:this._minTileCacheSize,this._maxTileCacheSize=void 0===this._maxTileCacheSize&&e?e._maxTileCacheSize:this._maxTileCacheSize;}loaded(){if(this._sourceErrored)return !0;if(!this._sourceLoaded)return !1;if(!this._source.loaded())return !1;for(const e in this._tiles)if(!this._tiles[e].loaded())return !1;return !0}getSource(){return this._source}pause(){this._paused=!0;}resume(){if(!this._paused)return;const e=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,e&&this.reload(),this.transform&&this.update(this.transform);}_loadTile(e,t){return e.isSymbolTile=this._onlySymbols,e.isExtraShadowCaster=this._shadowCasterTiles[e.tileID.key],this._source.loadTile(e,t)}_unloadTile(e){if(this._source.unloadTile)return this._source.unloadTile(e)}_abortTile(e){if(this._source.abortTile)return this._source.abortTile(e)}serialize(){return this._source.serialize()}prepare(e){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const t in this._tiles){const i=this._tiles[t];i.upload(e),i.prepare(this.map.style.imageManager,this.map?this.map.painter:null,this._source.scope);}}getIds(){return Object.values(this._tiles).map((e=>e.tileID)).sort(Ct).map((e=>e.key))}getRenderableIds(t,i){const o=[];for(const e in this._tiles)this._isIdRenderable(+e,t,i)&&o.push(this._tiles[e]);return t?o.sort(((t,i)=>{const o=t.tileID,s=i.tileID,r=new e.P(o.canonical.x,o.canonical.y)._rotate(this.transform.angle),n=new e.P(s.canonical.x,s.canonical.y)._rotate(this.transform.angle);return o.overscaledZ-s.overscaledZ||n.y-r.y||n.x-r.x})).map((e=>e.tileID.key)):o.map((e=>e.tileID)).sort(Ct).map((e=>e.key))}hasRenderableParent(e){const t=this.findLoadedParent(e,0);return !!t&&this._isIdRenderable(t.tileID.key)}_isIdRenderable(e,t,i){return this._tiles[e]&&this._tiles[e].hasData()&&!this._coveredTiles[e]&&(t||!this._tiles[e].holdingForFade())&&(i||!this._shadowCasterTiles[e])}reload(){if(this._paused)this._shouldReloadOnResume=!0;else {this._cache.reset();for(const e in this._tiles)"errored"!==this._tiles[e].state&&this._reloadTile(+e,"reloading");}}_reloadTile(e,t){const i=this._tiles[e];i&&("loading"!==i.state&&(i.state=t),this._loadTile(i,this._tileLoaded.bind(this,i,e,t)));}_tileLoaded(t,i,o,s){if(s)if(t.state="errored",404!==s.status)this._source.fire(new e.z(s,{tile:t}));else {if(this._source.fire(new e.A("data",{dataType:"source",sourceDataType:"error",sourceId:this._source.id,tile:t})),!(t.tileID.key in this._loadedParentTiles))return;if("raster-dem"===this._source.type&&this.usedForTerrain&&this.map.painter.terrain){const e=this.map.painter.terrain;this.update(this.transform,e.getScaledDemTileSize(),!0),e.resetTileLookupCache(this.id);}else this.update(this.transform);}else t.timeAdded=e.q.now(),"expired"===o&&(t.refreshedUponExpiration=!0),this._setTileReloadTimer(i,t),"raster-dem"===this._source.type&&t.dem&&this._backfillDEM(t),this._state.initializeTileState(t,this.map?this.map.painter:null),this._source.fire(new e.A("data",{dataType:"source",tile:t,coord:t.tileID,sourceCacheId:this.id}));}_backfillDEM(e){const t=this.getRenderableIds();for(let o=0;o<t.length;o++){const s=t[o];if(e.neighboringTiles&&e.neighboringTiles[s]){const t=this.getTileByID(s);i(e,t),i(t,e);}}function i(e,t){if(!e.dem||e.dem.borderReady)return;e.needsHillshadePrepare=!0,e.needsDEMTextureUpload=!0;let i=t.tileID.canonical.x-e.tileID.canonical.x;const o=t.tileID.canonical.y-e.tileID.canonical.y,s=Math.pow(2,e.tileID.canonical.z),r=t.tileID.key;0===i&&0===o||Math.abs(o)>1||(Math.abs(i)>1&&(1===Math.abs(i+s)?i+=s:1===Math.abs(i-s)&&(i-=s)),t.dem&&e.dem&&(e.dem.backfillBorder(t.dem,i,o),e.neighboringTiles&&e.neighboringTiles[r]&&(e.neighboringTiles[r].backfilled=!0)));}}getTile(e){return this.getTileByID(e.key)}getTileByID(e){return this._tiles[e]}_retainLoadedChildren(e,t,i,o){for(const s in this._tiles){let r=this._tiles[s];if(o[s]||!r.hasData()||r.tileID.overscaledZ<=t||r.tileID.overscaledZ>i)continue;let n=r.tileID;for(;r&&r.tileID.overscaledZ>t+1;){const e=r.tileID.scaledTo(r.tileID.overscaledZ-1);r=this._tiles[e.key],r&&r.hasData()&&(n=e);}let a=n;for(;a.overscaledZ>t;)if(a=a.scaledTo(a.overscaledZ-1),e[a.key]){o[n.key]=n;break}}}findLoadedParent(e,t){if(e.key in this._loadedParentTiles){const i=this._loadedParentTiles[e.key];return i&&i.tileID.overscaledZ>=t?i:null}for(let i=e.overscaledZ-1;i>=t;i--){const t=e.scaledTo(i),o=this._getLoadedTile(t);if(o)return o}}_getLoadedTile(e){const t=this._tiles[e.key];return t&&t.hasData()?t:this._cache.getByKey(this._source.reparseOverscaled?e.wrapped().key:e.canonical.key)}updateCacheSize(e,t){t=t||this._source.tileSize;const i=Math.ceil(e.width/t)+1,o=Math.ceil(e.height/t)+1,s=Math.floor(i*o*5),r="number"==typeof this._minTileCacheSize?Math.max(this._minTileCacheSize,s):s,n="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,r):r;this._cache.setMaxSize(n);}handleWrapJump(e){const t=Math.round((e-(void 0===this._prevLng?e:this._prevLng))/360);if(this._prevLng=e,t){const e={};for(const i in this._tiles){const o=this._tiles[i];o.tileID=o.tileID.unwrapTo(o.tileID.wrap+t),e[o.tileID.key]=o;}this._tiles=e;for(const e in this._timers)clearTimeout(this._timers[e]),delete this._timers[e];for(const e in this._tiles)this._setTileReloadTimer(+e,this._tiles[e]);}}update(t,i,o,s,r){if(this.transform=t,!this._sourceLoaded||this._paused||this.transform.freezeTileCoverage)return;if(this.usedForTerrain&&!o)return;this.updateCacheSize(t,i),"globe"!==this.transform.projection.name&&this.handleWrapJump(this.transform.center.lng),this._shadowCasterTiles={},this._coveredTiles={};const n="batched-model"===this._source.type;let a,l=this._source.maxzoom;const c=this.map&&this.map.painter?this.map.painter._terrain:null;if(c&&c.sourceCache===this&&c.attenuationRange()){const e=c.attenuationRange()[0],t=Math.floor(e)-Math.log2(c.getDemUpscale());l>t&&(l=t);}if(this.used||this.usedForTerrain){if(this._source.tileID)a=t.getVisibleUnwrappedCoordinates(this._source.tileID).map((t=>new e.aM(t.canonical.z,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y)));else if(0!==this.tileCoverLift){const s=t.clone();s.tileCoverLift=this.tileCoverLift,a=s.coveringTiles({tileSize:i||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:l,roundZoom:this._source.roundZoom&&!o,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain,calculateQuadrantVisibility:n}),this._source.minzoom<=1&&"globe"===t.projection.name&&(a.push(new e.aM(1,0,1,0,0)),a.push(new e.aM(1,0,1,1,0)),a.push(new e.aM(1,0,1,0,1)),a.push(new e.aM(1,0,1,1,1)));}else if(a=t.coveringTiles({tileSize:i||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:l,roundZoom:this._source.roundZoom&&!o,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain,calculateQuadrantVisibility:n}),this._source.hasTile){const e=this._source.hasTile.bind(this._source);a=a.filter((t=>e(t)));}}else a=[];if(a.length>0&&"globe"!==this.transform.projection.name&&!this.usedForTerrain&&!Rt(this._source.type)){const e=t.coveringZoomLevel({tileSize:i||this._source.tileSize,roundZoom:this._source.roundZoom&&!o}),l=Math.min(e,this._source.maxzoom);if(n){const e=t.extendTileCover(a,l);for(const t of e)a.push(t);}else if(r){const e=t.extendTileCover(a,l,this.transform._camera.forward());for(const t of e)a.push(t);}else if(this.castsShadows&&s){const e=t.extendTileCover(a,l,s);for(const t of e)this._shadowCasterTiles[t.key]=!0,a.push(t);}}const h=this._updateRetainedTiles(a);if(Rt(this._source.type)&&0!==a.length){const t={},i={},o=Object.keys(h);for(const s of o){const o=h[s],r=this._tiles[s];if(!r||r.fadeEndTime&&r.fadeEndTime<=e.q.now())continue;const n=this.findLoadedParent(o,Math.max(o.overscaledZ-It.maxOverzooming,this._source.minzoom));n&&(this._addTile(n.tileID),t[n.tileID.key]=n.tileID),i[s]=o;}const s=a[a.length-1].overscaledZ;for(const e in this._tiles){const t=this._tiles[e];if(h[e]||!t.hasData())continue;let o=t.tileID;for(;o.overscaledZ>s;){o=o.scaledTo(o.overscaledZ-1);const s=this._tiles[o.key];if(s&&s.hasData()&&i[o.key]){h[e]=t.tileID;break}}}for(const e in t)h[e]||(this._coveredTiles[e]=!0,h[e]=t[e]);}for(const e in h)this._tiles[e].clearFadeHold();const d=e.bs(this._tiles,h);for(const e of d){const t=this._tiles[e];t.hasSymbolBuckets&&!t.holdingForFade()?t.setHoldDuration(this.map._fadeDuration):t.hasSymbolBuckets&&!t.symbolFadeFinished()||this._removeTile(+e);}this._updateLoadedParentTileCache(),this._onlySymbols&&this._source.afterUpdate&&this._source.afterUpdate();}releaseSymbolFadeTiles(){for(const e in this._tiles)this._tiles[e].holdingForFade()&&this._removeTile(+e);}_updateRetainedTiles(e){const t={};if(0===e.length)return t;const i={},o=e.reduce(((e,t)=>Math.min(e,t.overscaledZ)),1/0),s=e[0].overscaledZ,r=Math.max(s-It.maxOverzooming,this._source.minzoom),n=Math.max(s+It.maxUnderzooming,this._source.minzoom),a={};for(const i of e){const e=this._addTile(i);t[i.key]=i,e.hasData()||o<this._source.maxzoom&&(a[i.key]=i);}this._retainLoadedChildren(a,o,n,t);for(const o of e){let e=this._tiles[o.key];if(e.hasData())continue;if(o.canonical.z>=this._source.maxzoom){const e=o.children(this._source.maxzoom)[0],i=this.getTile(e);if(i&&i.hasData()){t[e.key]=e;continue}}else {const e=o.children(this._source.maxzoom);if(t[e[0].key]&&t[e[1].key]&&t[e[2].key]&&t[e[3].key])continue}let s=e.wasRequested();for(let n=o.overscaledZ-1;n>=r;--n){const r=o.scaledTo(n);if(i[r.key])break;if(i[r.key]=!0,e=this.getTile(r),!e&&s&&(e=this._addTile(r)),e&&(t[r.key]=r,s=e.wasRequested(),e.hasData()))break}}return t}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const e in this._tiles){const t=[];let i,o=this._tiles[e].tileID;for(;o.overscaledZ>0;){if(o.key in this._loadedParentTiles){i=this._loadedParentTiles[o.key];break}t.push(o.key);const e=o.scaledTo(o.overscaledZ-1);if(i=this._getLoadedTile(e),i)break;o=e;}for(const e of t)this._loadedParentTiles[e]=i;}}_addTile(t){let i=this._tiles[t.key];if(i)return !0!==i.isExtraShadowCaster||!!this._shadowCasterTiles[t.key]||this._reloadTile(t.key,"reloading"),i;i=this._cache.getAndRemove(t),i&&(this._setTileReloadTimer(t.key,i),i.tileID=t,this._state.initializeTileState(i,this.map?this.map.painter:null),this._cacheTimers[t.key]&&(clearTimeout(this._cacheTimers[t.key]),delete this._cacheTimers[t.key],this._setTileReloadTimer(t.key,i)));const o=Boolean(i);if(!o){const e=this.map?this.map.painter:null,o=this._source.tileSize*t.overscaleFactor();i="raster-array"===this._source.type?new Tt(t,o,this.transform.tileZoom,e,this._isRaster):new wt(t,o,this.transform.tileZoom,e,this._isRaster,this._source.worldview),this._loadTile(i,this._tileLoaded.bind(this,i,t.key,i.state));}return i.uses++,this._tiles[t.key]=i,o||this._source.fire(new e.A("dataloading",{tile:i,coord:i.tileID,dataType:"source"})),i}_setTileReloadTimer(e,t){e in this._timers&&(clearTimeout(this._timers[e]),delete this._timers[e]);const i=t.getExpiryTimeout();i&&(this._timers[e]=setTimeout((()=>{this._reloadTile(e,"expired"),delete this._timers[e];}),i));}_removeTile(e){const t=this._tiles[e];t&&(t.uses--,delete this._tiles[e],this._timers[e]&&(clearTimeout(this._timers[e]),delete this._timers[e]),t.uses>0||(t.hasData()&&"reloading"!==t.state||"empty"===t.state?this._cache.add(t.tileID,t,t.getExpiryTimeout()):(t.aborted=!0,this._abortTile(t),this._unloadTile(t))));}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const e in this._tiles)this._removeTile(+e);this._source._clear&&this._source._clear(),this._cache.reset(),this.map&&this.usedForTerrain&&this.map.painter.terrain&&this.map.painter.terrain.resetTileLookupCache(this.id);}tilesIn(t,i,o){const s=[],r=this.transform;if(!r)return s;const n="globe"===r.projection.name,a=e.aD(r.center.lng);for(const l in this._tiles){const c=this._tiles[l];if(o&&c.clearQueryDebugViz(),c.holdingForFade())continue;let h;if(n){const t=c.tileID.canonical;if(0===t.z){const i=[Math.abs(e.ay(a,...Dt(t,-1))-a),Math.abs(e.ay(a,...Dt(t,1))-a)];h=[0,2*i.indexOf(Math.min(...i))-1];}else {const i=[Math.abs(e.ay(a,...Dt(t,-1))-a),Math.abs(e.ay(a,...Dt(t,0))-a),Math.abs(e.ay(a,...Dt(t,1))-a)];h=[i.indexOf(Math.min(...i))-1];}}else h=[0];for(const e of h){const o=t.containsTile(c,r,i,e);o&&s.push(o);}}return s}getShadowCasterCoordinates(){return this._getRenderableCoordinates(!1,!0)}getVisibleCoordinates(e){return this._getRenderableCoordinates(e)}_getRenderableCoordinates(e,t){const i=this.getRenderableIds(e,t).map((e=>this._tiles[e].tileID)),o="globe"===this.transform.projection.name;for(const e of i)e.projMatrix=this.transform.calculateProjMatrix(e.toUnwrapped()),e.expandedProjMatrix=o?this.transform.calculateProjMatrix(e.toUnwrapped(),!1,!0):e.projMatrix;return i}sortCoordinatesByDistance(e){const t=e.slice(),i=this.transform._camera.position,o=this.transform._camera.forward(),s={};for(const e of t){const t=1/(1<<e.canonical.z);s[e.key]=((e.canonical.x+.5)*t+e.wrap-i[0])*o[0]+((e.canonical.y+.5)*t-i[1])*o[1]-i[2]*o[2];}return t.sort(((e,t)=>s[e.key]-s[t.key])),t}hasTransition(){if(this._source.hasTransition())return !0;if(Rt(this._source.type))for(const t in this._tiles){const i=this._tiles[t];if(void 0!==i.fadeEndTime&&i.fadeEndTime>=e.q.now())return !0}return !1}setFeatureState(e,t,i){this._state.updateState(e=e||"_geojsonTileLayer",t,i);}removeFeatureState(e,t,i){this._state.removeFeatureState(e=e||"_geojsonTileLayer",t,i);}getFeatureState(e,t){return this._state.getState(e=e||"_geojsonTileLayer",t)}setDependencies(e,t,i){const o=this._tiles[e];o&&o.setDependencies(t,i);}reloadTilesForDependencies(e,t){for(const i in this._tiles)this._tiles[i].hasDependency(e,t)&&this._reloadTile(+i,"reloading");this._cache.filter((i=>!i.hasDependency(e,t)));}_preloadTiles(t,i){if(!this._sourceLoaded){const e=()=>{this._sourceLoaded&&(this._source.off("data",e),this._preloadTiles(t,i));};return void this._source.on("data",e)}const o=new Map,s=Array.isArray(t)?t:[t],r=this.map.painter.terrain,n=this.usedForTerrain&&r?r.getScaledDemTileSize():this._source.tileSize;for(const e of s){const t=e.coveringTiles({tileSize:n,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!this.usedForTerrain,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain});for(const e of t)o.set(e.key,e);this.usedForTerrain&&e.updateElevation(!1);}const a=Array.from(o.values());e.bt(a,((e,t)=>{const i=new wt(e,this._source.tileSize*e.overscaleFactor(),this.transform.tileZoom,this.map.painter,this._isRaster,this._source.worldview);this._loadTile(i,(e=>{"raster-dem"===this._source.type&&i.dem&&this._backfillDEM(i),t(e,i);}));}),i);}}function Ct(e,t){const i=Math.abs(2*e.wrap)-+(e.wrap<0),o=Math.abs(2*t.wrap)-+(t.wrap<0);return e.overscaledZ-t.overscaledZ||o-i||t.canonical.y-e.canonical.y||t.canonical.x-e.canonical.x}function Rt(e){return "raster"===e||"image"===e||"video"===e||"custom"===e}function Dt(e,t){const i=1<<e.z;return [e.x/i+t,(e.x+1)/i+t]}It.maxOverzooming=10,It.maxUnderzooming=3;class At{constructor(e){this.style=e,this.layersGotHidden=!1,this.layers=[];}processLayersChanged(){this.layers=[];const e=!1,t=!1;for(const i in this.style._mergedLayers){const o=this.style._mergedLayers[i];if("fill-extrusion"===o.type||"building"===o.type)this.layers.push({layer:o,visible:e,visibilityChanged:t});else if("model"===o.type){const i=this.style.getLayerSource(o);i&&"batched-model"===i.type&&this.layers.push({layer:o,visible:e,visibilityChanged:t});}}}onNewFrame(e){this.layersGotHidden=!1;for(const t of this.layers){const i=t.layer;let o=!1;"fill-extrusion"===i.type?o=!i.isHidden(e)&&i.paint.get("fill-extrusion-opacity")>0:"building"===i.type?o=!i.isHidden(e)&&i.paint.get("building-opacity")>0:"model"===i.type&&(o=!i.isHidden(e)&&i.paint.get("model-opacity").constantOr(1)>0),this.layersGotHidden=this.layersGotHidden||!o&&t.visible,t.visible=o;}}updateZOffset(e,t){this.currentBuildingBuckets=[];for(const e of this.layers){const i=e.layer,o=this.style.getLayerSourceCache(i);let s=1;"fill-extrusion"===i.type?s=e.visible?i.paint.get("fill-extrusion-vertical-scale"):0:"building"===i.type&&(s=e.visible?i.paint.get("building-vertical-scale"):0);let r=o?o.getTile(t):null;if(!r&&o&&t.canonical.z>o.getSource().minzoom){let e=t.scaledTo(Math.min(o.getSource().maxzoom,t.overscaledZ-1));for(;e.overscaledZ>=o.getSource().minzoom&&(r=o.getTile(e),!r&&0!==e.overscaledZ);)e=e.scaledTo(e.overscaledZ-1);}this.currentBuildingBuckets.push({bucket:r?r.getBucket(i):null,tileID:r?r.tileID:t,verticalScale:s});}e.hasAnyZOffset=!1;let i=!1;for(let o=0;o<e.symbolInstances.length;o++){const s=e.symbolInstances.get(o),r=s.zOffset,n=this._getHeightAtTileOffset(t,s.tileAnchorX,s.tileAnchorY);s.zOffset=n!==Number.NEGATIVE_INFINITY?n:r,i||r===s.zOffset||(i=!0),e.hasAnyZOffset||0===s.zOffset||(e.hasAnyZOffset=!0);}i&&(e.zOffsetBuffersNeedUpload=!0,e.zOffsetSortDirty=!0);}_mapCoordToOverlappingTile(t,i,o,s){let r=i,n=o;if(t.canonical.z!==s.canonical.z){const a=s.canonical,l=1/(1<<t.canonical.z-a.z);r=(i+t.canonical.x*e.aj)*l-a.x*e.aj|0,n=(o+t.canonical.y*e.aj)*l-a.y*e.aj|0;}return {tileX:r,tileY:n}}_getHeightAtTileOffset(e,t,i){let o,s;for(let r=0;r<this.layers.length;++r){const n=this.layers[r].layer;if("fill-extrusion"!==n.type&&"building"!==n.type)continue;const{bucket:a,tileID:l,verticalScale:c}=this.currentBuildingBuckets[r];if(!a)continue;const{tileX:h,tileY:d}=this._mapCoordToOverlappingTile(e,t,i,l),u=a.getHeightAtTileCoord(h,d);u&&void 0!==u.height&&(u.hidden?o=u.height:s=Math.max(u.height*c,s||0));}if(void 0!==s)return s;for(let s=0;s<this.layers.length;++s){const r=this.layers[s];if("model"!==r.layer.type||!r.visible)continue;const{bucket:n,tileID:a}=this.currentBuildingBuckets[s];if(!n)continue;const{tileX:l,tileY:c}=this._mapCoordToOverlappingTile(e,t,i,a),h=n.getHeightAtTileCoord(l,c);if(h&&!h.hidden)return void 0===h.height&&void 0!==o?Math.min(h.maxHeight,o)*h.verticalScale:h.height?h.height*h.verticalScale:Number.NEGATIVE_INFINITY}return this.layersGotHidden?0:Number.NEGATIVE_INFINITY}}function Lt(t,i){const o={};for(const e in t)"ref"!==e&&(o[e]=t[e]);return e.bu.forEach((e=>{e in i&&(o[e]=i[e]);})),o}function Pt(e){e=e.slice();const t=Object.create(null);for(let i=0;i<e.length;i++)t[e[i].id]=e[i];for(let i=0;i<e.length;i++)"ref"in e[i]&&(e[i]=Lt(e[i],t[e[i].ref]));return e}const zt={setStyle:"setStyle",addLayer:"addLayer",removeLayer:"removeLayer",setPaintProperty:"setPaintProperty",setLayoutProperty:"setLayoutProperty",setSlot:"setSlot",setFilter:"setFilter",addSource:"addSource",removeSource:"removeSource",setGeoJSONSourceData:"setGeoJSONSourceData",setLayerZoomRange:"setLayerZoomRange",setLayerProperty:"setLayerProperty",setCenter:"setCenter",setZoom:"setZoom",setBearing:"setBearing",setPitch:"setPitch",setSprite:"setSprite",setGlyphs:"setGlyphs",setTransition:"setTransition",setLight:"setLight",setTerrain:"setTerrain",setFog:"setFog",setSnow:"setSnow",setRain:"setRain",setCamera:"setCamera",setLights:"setLights",setProjection:"setProjection",addImport:"addImport",removeImport:"removeImport",updateImport:"updateImport",addIconset:"addIconset",removeIconset:"removeIconset"};function Mt(e,t,i){i.push({command:zt.addSource,args:[e,t[e]]});}function Ot(e,t,i){t.push({command:zt.removeSource,args:[e]}),i[e]=!0;}function Ft(e,t,i,o){Ot(e,i,o),Mt(e,t,i);}function Bt(t,i,o){let s;for(s in t[o])if(t[o].hasOwnProperty(s)&&"data"!==s&&!e.bv(t[o][s],i[o][s]))return !1;for(s in i[o])if(i[o].hasOwnProperty(s)&&"data"!==s&&!e.bv(t[o][s],i[o][s]))return !1;return !0}function kt(t,i,o,s,r,n){let a;for(a in i=i||{},t=t||{})t.hasOwnProperty(a)&&(e.bv(t[a],i[a])||o.push({command:n,args:[s,a,i[a],r]}));for(a in i)i.hasOwnProperty(a)&&!t.hasOwnProperty(a)&&(e.bv(t[a],i[a])||o.push({command:n,args:[s,a,i[a],r]}));}function Nt(e){return e.id}function Ut(e,t){return e[t.id]=t,e}class jt{constructor(e,t){this.reset(e,t);}reset(e,t){this.points=e||[],this._distances=[0];for(let e=1;e<this.points.length;e++)this._distances[e]=this._distances[e-1]+this.points[e].dist(this.points[e-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(t||0,.5*this.length),this.paddedLength=this.length-2*this.padding;}lerp(t){if(1===this.points.length)return this.points[0];t=e.ay(t,0,1);let i=1,o=this._distances[i];const s=t*this.paddedLength+this.padding;for(;o<s&&i<this._distances.length;)o=this._distances[++i];const r=i-1,n=this._distances[r],a=o-n,l=a>0?(s-n)/a:0;return this.points[r].mult(1-l).add(this.points[i].mult(l))}}class Vt{constructor(e,t,i){const o=this.boxCells=[],s=this.circleCells=[];this.xCellCount=Math.ceil(e/i),this.yCellCount=Math.ceil(t/i);for(let e=0;e<this.xCellCount*this.yCellCount;e++)o.push([]),s.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=e,this.height=t,this.xScale=this.xCellCount/e,this.yScale=this.yCellCount/t,this.boxUid=0,this.circleUid=0;}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(e,t,i,o,s){this._forEachCell(t,i,o,s,this._insertBoxCell,this.boxUid++),this.boxKeys.push(e),this.bboxes.push(t),this.bboxes.push(i),this.bboxes.push(o),this.bboxes.push(s);}insertCircle(e,t,i,o){this._forEachCell(t-o,i-o,t+o,i+o,this._insertCircleCell,this.circleUid++),this.circleKeys.push(e),this.circles.push(t),this.circles.push(i),this.circles.push(o);}_insertBoxCell(e,t,i,o,s,r){this.boxCells[s].push(r);}_insertCircleCell(e,t,i,o,s,r){this.circleCells[s].push(r);}_query(e,t,i,o,s,r){if(i<0||e>this.width||o<0||t>this.height)return !s&&[];const n=[];if(e<=0&&t<=0&&this.width<=i&&this.height<=o){if(s)return !0;for(let e=0;e<this.boxKeys.length;e++)n.push({key:this.boxKeys[e],x1:this.bboxes[4*e],y1:this.bboxes[4*e+1],x2:this.bboxes[4*e+2],y2:this.bboxes[4*e+3]});for(let e=0;e<this.circleKeys.length;e++){const t=this.circles[3*e],i=this.circles[3*e+1],o=this.circles[3*e+2];n.push({key:this.circleKeys[e],x1:t-o,y1:i-o,x2:t+o,y2:i+o});}return r?n.filter(r):n}return this._forEachCell(e,t,i,o,this._queryCell,n,{hitTest:s,seenUids:{box:{},circle:{}}},r),s?n.length>0:n}_queryCircle(e,t,i,o,s){const r=e-i,n=e+i,a=t-i,l=t+i;if(n<0||r>this.width||l<0||a>this.height)return !o&&[];const c=[];return this._forEachCell(r,a,n,l,this._queryCellCircle,c,{hitTest:o,circle:{x:e,y:t,radius:i},seenUids:{box:{},circle:{}}},s),o?c.length>0:c}query(e,t,i,o,s){return this._query(e,t,i,o,!1,s)}hitTest(e,t,i,o,s){return this._query(e,t,i,o,!0,s)}hitTestCircle(e,t,i,o){return this._queryCircle(e,t,i,!0,o)}_queryCell(e,t,i,o,s,r,n,a){const l=n.seenUids,c=this.boxCells[s];if(null!==c){const s=this.bboxes;for(const h of c)if(!l.box[h]){l.box[h]=!0;const c=4*h;if(e<=s[c+2]&&t<=s[c+3]&&i>=s[c+0]&&o>=s[c+1]&&(!a||a(this.boxKeys[h]))){if(n.hitTest)return r.push(!0),!0;r.push({key:this.boxKeys[h],x1:s[c],y1:s[c+1],x2:s[c+2],y2:s[c+3]});}}}const h=this.circleCells[s];if(null!==h){const s=this.circles;for(const c of h)if(!l.circle[c]){l.circle[c]=!0;const h=3*c;if(this._circleAndRectCollide(s[h],s[h+1],s[h+2],e,t,i,o)&&(!a||a(this.circleKeys[c]))){if(n.hitTest)return r.push(!0),!0;{const e=s[h],t=s[h+1],i=s[h+2];r.push({key:this.circleKeys[c],x1:e-i,y1:t-i,x2:e+i,y2:t+i});}}}}}_queryCellCircle(e,t,i,o,s,r,n,a){const l=n.circle,c=n.seenUids,h=this.boxCells[s];if(null!==h){const e=this.bboxes;for(const t of h)if(!c.box[t]){c.box[t]=!0;const i=4*t;if(this._circleAndRectCollide(l.x,l.y,l.radius,e[i+0],e[i+1],e[i+2],e[i+3])&&(!a||a(this.boxKeys[t])))return r.push(!0),!0}}const d=this.circleCells[s];if(null!==d){const e=this.circles;for(const t of d)if(!c.circle[t]){c.circle[t]=!0;const i=3*t;if(this._circlesCollide(e[i],e[i+1],e[i+2],l.x,l.y,l.radius)&&(!a||a(this.circleKeys[t])))return r.push(!0),!0}}}_forEachCell(e,t,i,o,s,r,n,a){const l=this._convertToXCellCoord(e),c=this._convertToYCellCoord(t),h=this._convertToXCellCoord(i),d=this._convertToYCellCoord(o);for(let u=l;u<=h;u++)for(let l=c;l<=d;l++)if(s.call(this,e,t,i,o,this.xCellCount*l+u,r,n,a))return}_convertToXCellCoord(e){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(e*this.xScale)))}_convertToYCellCoord(e){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(e*this.yScale)))}_circlesCollide(e,t,i,o,s,r){const n=o-e,a=s-t,l=i+r;return l*l>n*n+a*a}_circleAndRectCollide(e,t,i,o,s,r,n){const a=(r-o)/2,l=Math.abs(e-(o+a));if(l>a+i)return !1;const c=(n-s)/2,h=Math.abs(t-(s+c));if(h>c+i)return !1;if(l<=a||h<=c)return !0;const d=l-a,u=h-c;return d*d+u*u<=i*i}}const Gt={unknown:0,flipRequired:1,flipNotRequired:2},qt=Math.tan(85*Math.PI/180);function Zt(t,i,o,s,r,n,a){const l=e.bz();if(o)if("globe"===n.name){const t=e.bA(r,i);e.az(l,l,t);}else {const t=e.bB([],a);l[0]=t[0],l[1]=t[1],l[4]=t[2],l[5]=t[3],s||e.by(l,l,r.angle);}else e.az(l,r.labelPlaneMatrix,t);return l}function Ht(e,t,i,o,s,r,n){const a=Zt(e,t,i,o,s,r,n);return "globe"===r.name&&i||(a[2]=a[6]=a[10]=a[14]=0),a}function Wt(t,i,o,s,r,n,a){if(o){if("globe"===n.name){const l=Zt(t,i,o,s,r,n,a);return e.bi(l,l),e.az(l,t,l),l}{const i=e.bw(t),o=e.bx([]);return o[0]=a[0],o[1]=a[1],o[4]=a[2],o[5]=a[3],e.az(i,i,o),s||e.by(i,i,-r.angle),i}}return r.glCoordMatrix}function $t(t,i,o,s){const r=[t,i,o,1];o?e.aA(r,r,s):ri(r,r,s);const n=r[3];return r[0]/=n,r[1]/=n,r[2]/=n,r}function Xt(e,t){return Math.min(.5+e/t*.5,1.5)}function Yt(e,t){const i=e[0]/e[3],o=e[1]/e[3];return i>=-t[0]&&i<=t[0]&&o>=-t[1]&&o<=t[1]}function Kt(t,i,o,s,r,n,a,l,c,h){const d=o.transform,u=s?t.textSizeData:t.iconSizeData,_=e.bH(u,o.transform.zoom),p="globe"===d.projection.name,f=[256/o.width*2+1,256/o.height*2+1],m=s?t.text.dynamicLayoutVertexArray:t.icon.dynamicLayoutVertexArray;m.clear();let g=null;p&&(g=s?t.text.globeExtVertexArray:t.icon.globeExtVertexArray);const v=t.lineVertexArray,y=s?t.text.placedSymbolArray:t.icon.placedSymbolArray,x=o.transform.width/o.transform.height;let b,w=!1;for(let s=0;s<y.length;s++){const p=y.get(s),{numGlyphs:T,writingMode:E}=p;if(E!==e.bI.vertical||w||b===e.bI.horizontal||(w=!0),b=E,(p.hidden||E===e.bI.vertical)&&!w){si(T,m);continue}w=!1;const S=new e.P(p.tileAnchorX,p.tileAnchorY);let{x:I,y:C,z:R}=d.projection.projectTilePoint(S.x,S.y,h.canonical);if(c){const[e,t,i]=c(S);I+=e,C+=t,R+=i;}const D=[I,C,R,1];if(e.aA(D,D,i),!Yt(D,f)){si(T,m);continue}const A=D[3],L=Xt(o.transform.getCameraToCenterDistance(d.projection),A),P=e.bJ(u,_,p),z=a?P/L:P*L,M=$t(I,C,R,r);if(M[3]<=0){si(T,m);continue}let O={};const F=e.al(t.layers[0].layout.get("text-max-angle")),B=Math.cos(F),k=a?null:c,N=ei(p,z,!1,l,i,r,n,t.glyphOffsetArray,v,m,g,M,S,O,x,k,d.projection,h,a,B);w=N.useVertical,k&&N.needsFlipping&&(O={}),(N.notEnoughRoom||w||N.needsFlipping&&ei(p,z,!0,l,i,r,n,t.glyphOffsetArray,v,m,g,M,S,O,x,k,d.projection,h,a,B).notEnoughRoom)&&si(T,m);}s?(t.text.dynamicLayoutVertexBuffer.updateData(m),g&&t.text.globeExtVertexBuffer&&t.text.globeExtVertexBuffer.updateData(g)):(t.icon.dynamicLayoutVertexBuffer.updateData(m),g&&t.icon.globeExtVertexBuffer&&t.icon.globeExtVertexBuffer.updateData(g));}function Jt(e,t,i,o,s,r,n,a,l,c,h,d,u,_,p,f,m){const{lineStartIndex:g,glyphStartIndex:v,segment:y}=a,x=v+a.numGlyphs,b=g+a.lineLength,w=t.getoffsetX(v),T=t.getoffsetX(x-1),E=oi(e*w,i,o,s,r,n,y,g,b,l,c,h,d,u,!0,_,p,f,m);if(!E)return null;const S=oi(e*T,i,o,s,r,n,y,g,b,l,c,h,d,u,!0,_,p,f,m);return S?{first:E,last:S}:null}function Qt(t,i,o,s){return t===e.bI.horizontal&&Math.abs(s)>Math.abs(o)?{useVertical:!0}:t===e.bI.vertical?s>0?{needsFlipping:!0}:null:i!==Gt.unknown&&function(e,t){return 0===e||Math.abs(t/e)>qt}(o,s)?i===Gt.flipRequired?{needsFlipping:!0}:null:o<0?{needsFlipping:!0}:null}function ei(t,i,o,s,r,n,a,l,c,h,d,u,_,p,f,m,g,v,y,x){const b=i/24,w=t.lineOffsetX*b,T=t.lineOffsetY*b,{lineStartIndex:E,glyphStartIndex:S,numGlyphs:I,segment:C,writingMode:R,flipState:D}=t,A=E+t.lineLength,L=t=>{if(d){const[i,o,s]=t.up,r=h.length;e.bK(d,r+0,i,o,s),e.bK(d,r+1,i,o,s),e.bK(d,r+2,i,o,s),e.bK(d,r+3,i,o,s);}const[i,o,s]=t.point;e.bL(h,i,o,s,t.angle);};if(I>1){const e=Jt(b,l,w,T,o,u,_,t,c,n,p,m,!1,g,v,y,x);if(!e)return {notEnoughRoom:!0};if(s&&!o){let[i,o,s]=e.first.point,[r,n,l]=e.last.point;[i,o]=$t(i,o,s,a),[r,n]=$t(r,n,l,a);const c=Qt(R,D,(r-i)*f,n-o);if(t.flipState=c&&c.needsFlipping?Gt.flipRequired:Gt.flipNotRequired,c)return c}L(e.first);for(let e=S+1;e<S+I-1;e++){const t=oi(b*l.getoffsetX(e),w,T,o,u,_,C,E,A,c,n,p,m,!1,!1,g,v,y,x);if(!t)return h.length-=4*(e-S),{notEnoughRoom:!0};L(t);}L(e.last);}else {if(s&&!o){const i=$t(_.x,_.y,0,r),o=E+C+1,s=new e.P(c.getx(o),c.gety(o)),n=$t(s.x,s.y,0,r),a=n[3]>0?n:ii(_,s,i,1,r,void 0,g,v.canonical),l=Qt(R,D,(a[0]-i[0])*f,a[1]-i[1]);if(t.flipState=l&&l.needsFlipping?Gt.flipRequired:Gt.flipNotRequired,l)return l}const i=oi(b*l.getoffsetX(S),w,T,o,u,_,C,E,A,c,n,p,m,!1,!1,g,v,y,x);if(!i)return {notEnoughRoom:!0};L(i);}return {}}function ti(e,t,i,o,s){const{x:r,y:n,z:a}=o.projectTilePoint(e.x,e.y,t);if(!s)return $t(r,n,a,i);const[l,c,h]=s(e);return $t(r+l,n+c,a+h,i)}function ii(t,i,o,s,r,n,a,l){const c=ti(t.sub(i)._unit()._add(t),l,r,a,n);return e.at(c,o,c),e.au(c,c),e.bE(c,o,c,s)}function oi(t,i,o,s,r,n,a,l,c,h,d,u,_,p,f,m,g,v,y){const x=s?t-i:t+i;let b=x>0?1:-1,w=0;s&&(b*=-1,w=Math.PI),b<0&&(w+=Math.PI);let T=l+a+(b>0?0:1)|0,E=r,S=r,I=0,C=0;const R=Math.abs(x),D=[],A=[];let L=n,P=L,z=e.bC([]);const M=()=>ii(P,L,S,R-I+1,d,_,m,g.canonical);for(;I+C<=R;){if(T+=b,T<l||T>=c)return null;if(S=E,P=L,D.push(S),p&&A.push(P),L=new e.P(h.getx(T),h.gety(T)),E=u[T],!E){const e=ti(L,g.canonical,d,m,_);E=e[3]>0?u[T]=e:M();}I+=C;const t=e.at([],E,S),i=e.bD(S,E);if(o&&i>0&&C>0&&e.bG(z,t)/(C*i)<y)return null;C=i,z=t;}f&&_&&(u[T]&&(E=M(),C=e.bD(S,E),z=e.at([],E,S)),u[T]=E);const O=(R-I)/C,F=L.sub(P)._mult(O)._add(P),B=e.bE([],S,z,O);let k=[0,0,1],N=z[0],U=z[1];if(v&&(k=m.upVector(g.canonical,F.x,F.y),0!==k[0]||0!==k[1]||1!==k[2])){const t=[k[2],0,-k[0]],i=e.bF([],k,t);e.au(t,t),e.au(i,i),N=e.bG(z,t),U=e.bG(z,i);}if(o){const t=e.bF([],k,z);e.au(t,t),e.bE(B,B,t,o*b);}const j=w+Math.atan2(U,N);return D.push(B),p&&A.push(F),{point:B,angle:j,path:D,tilePath:A,up:k}}function si(e,t){const i=t.length,o=i+4*e;t.resize(o),t.float32.fill(-1/0,4*i,4*o);}function ri(e,t,i){const o=t[0],s=t[1];return e[0]=i[0]*o+i[4]*s+i[12],e[1]=i[1]*o+i[5]*s+i[13],e[3]=i[3]*o+i[7]*s+i[15],e}const ni=100;class ai{constructor(e,t,i=new Vt(e.width+200,e.height+200,25),o=new Vt(e.width+200,e.height+200,25)){this.transform=e,this.grid=i,this.ignoredGrid=o,this.pitchfactor=Math.cos(e._pitch)*e.cameraToCenterDistance,this.screenRightBoundary=e.width+ni,this.screenBottomBoundary=e.height+ni,this.gridRightBoundary=e.width+200,this.gridBottomBoundary=e.height+200,this.fogState=t;}placeCollisionBox(e,t,i,o,s,r,n,a){let l=i.projectedAnchorX,c=i.projectedAnchorY,h=i.projectedAnchorZ;const d=i.elevation,u=i.tileID,_=e.getProjection();if(d&&u){const[e,t,o]=_.upVector(u.canonical,i.tileAnchorX,i.tileAnchorY),s=_.upVectorScale(u.canonical,this.transform.center.lat,this.transform.worldSize).metersToTile;l+=e*d*s,c+=t*d*s,h+=o*d*s;}const p=this.projectAndGetPerspectiveRatio(n,l,c,h,i.tileID,"globe"===_.name||!!d||this.transform.pitch>0,_),f=r*p.perspectiveRatio,m=(i.x1*t+o.x-i.padding)*f+p.point.x,g=(i.y1*t+o.y-i.padding)*f+p.point.y,v=(i.x2*t+o.x+i.padding)*f+p.point.x,y=(i.y2*t+o.y+i.padding)*f+p.point.y,x=p.perspectiveRatio<=.55||p.occluded;return !this.isInsideGrid(m,g,v,y)||!s&&this.grid.hitTest(m,g,v,y,a)||x?{box:[],offscreen:!1,occluded:p.occluded}:{box:[m,g,v,y],offscreen:this.isOffscreen(m,g,v,y),occluded:!1}}placeCollisionCircles(t,i,o,s,r,n,a,l,c,h,d,u,_,p,f){const m=[],g=this.transform.elevation,v=t.getProjection(),y=g?g.getAtTileOffsetFunc(f,this.transform.center.lat,this.transform.worldSize,v):null,x=new e.P(o.tileAnchorX,o.tileAnchorY);let{x:b,y:w,z:T}=v.projectTilePoint(x.x,x.y,f.canonical);if(y){const[e,t,i]=y(x);b+=e,w+=t,T+=i;}const E="globe"===v.name,S=this.projectAndGetPerspectiveRatio(a,b,w,T,f,E||!!g||this.transform.pitch>0,v),{perspectiveRatio:I}=S,C=(d?n/I:n*I)/e.bO,R=$t(b,w,T,l),D=o.lineOffsetX*C,A=o.lineOffsetY*C,L=e.al(t.layers[0].layout.get("text-max-angle")),P=Math.cos(L),z=S.signedDistanceFromCamera>0?Jt(C,r,D,A,!1,R,x,o,s,l,{},g&&!d?y:null,d&&!!g,v,f,d,P):null;let M=!1,O=!1,F=!0;if(z&&!S.occluded){const t=.5*_*I+p,o=new e.P(-100,-100),s=new e.P(this.screenRightBoundary,this.screenBottomBoundary),r=new jt,{first:n,last:a}=z,l=n.path.length;let d=[];for(let e=l-1;e>=1;e--)d.push(n.path[e]);for(let e=1;e<a.path.length;e++)d.push(a.path[e]);const f=2.5*t;c&&(d=d.map((([e,t,i],o)=>(y&&!E&&(i=y(o<l-1?n.tilePath[l-1-o]:a.tilePath[o-l+2])[2]),$t(e,t,i,c)))),d.some((e=>e[3]<=0))&&(d=[]));let g=[];if(d.length>0){let t=1/0,i=-1/0,r=1/0,n=-1/0;for(const e of d)t=Math.min(t,e[0]),r=Math.min(r,e[1]),i=Math.max(i,e[0]),n=Math.max(n,e[1]);i>=o.x&&t<=s.x&&n>=o.y&&r<=s.y&&(g=[d.map((t=>new e.P(t[0],t[1])))],(t<o.x||i>s.x||r<o.y||n>s.y)&&(g=e.bM(g,o.x,o.y,s.x,s.y)));}for(const e of g){r.reset(e,.25*t);let o=0;o=r.length<=.5*t?1:Math.ceil(r.paddedLength/f)+1;for(let e=0;e<o;e++){const s=e/Math.max(o-1,1),n=r.lerp(s),a=n.x+ni,l=n.y+ni;m.push(a,l,t,0);const c=a-t,d=l-t,_=a+t,p=l+t;if(F=F&&this.isOffscreen(c,d,_,p),O=O||this.isInsideGrid(c,d,_,p),!i&&this.grid.hitTestCircle(a,l,t,u)&&(M=!0,!h))return {circles:[],offscreen:!1,collisionDetected:M,occluded:!1}}}}return {circles:!h&&M||!O?[]:m,offscreen:F,collisionDetected:M,occluded:S.occluded}}queryRenderedSymbols(t){if(0===t.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return {};const i=[];let o=1/0,s=1/0,r=-1/0,n=-1/0;for(const a of t){const t=new e.P(a.x+ni,a.y+ni);o=Math.min(o,t.x),s=Math.min(s,t.y),r=Math.max(r,t.x),n=Math.max(n,t.y),i.push(t);}const a=this.grid.query(o,s,r,n).concat(this.ignoredGrid.query(o,s,r,n)),l={},c={};for(const t of a){const o=t.key;if(void 0===l[o.bucketInstanceId]&&(l[o.bucketInstanceId]={}),l[o.bucketInstanceId][o.featureIndex])continue;const s=[new e.P(t.x1,t.y1),new e.P(t.x2,t.y1),new e.P(t.x2,t.y2),new e.P(t.x1,t.y2)];e.bN(i,s)&&(l[o.bucketInstanceId][o.featureIndex]=!0,void 0===c[o.bucketInstanceId]&&(c[o.bucketInstanceId]=[]),c[o.bucketInstanceId].push(o.featureIndex));}return c}insertCollisionBox(e,t,i,o,s){(t?this.ignoredGrid:this.grid).insert({bucketInstanceId:i,featureIndex:o,collisionGroupID:s},e[0],e[1],e[2],e[3]);}insertCollisionCircles(e,t,i,o,s){const r=t?this.ignoredGrid:this.grid,n={bucketInstanceId:i,featureIndex:o,collisionGroupID:s};for(let t=0;t<e.length;t+=4)r.insertCircle(n,e[t],e[t+1],e[t+2]);}projectAndGetPerspectiveRatio(t,i,o,s,r,n,a){const l=[i,o,s,1];let c=!1;if(s||this.transform.pitch>0){if(e.aA(l,l,t),this.fogState&&r&&"globe"!==a.name){const t=function(t,i,o,s,r,n){const a=n.calculateFogTileMatrix(r),l=[i,o,s];return e.ad(l,l,a),Be(t,e.ae(l),n.pitch,n._fov)}(this.fogState,i,o,s,r.toUnwrapped(),this.transform);c=t>.9;}}else ri(l,l,t);const h=l[3];return {point:new e.P((l[0]/h+1)/2*this.transform.width+ni,(-l[1]/h+1)/2*this.transform.height+ni),perspectiveRatio:Math.min(.5+this.transform.getCameraToCenterDistance(a)/h*.5,1.5),signedDistanceFromCamera:h,occluded:n&&l[2]>h||c}}isOffscreen(e,t,i,o){return i<ni||e>=this.screenRightBoundary||o<ni||t>this.screenBottomBoundary}isInsideGrid(e,t,i,o){return i>=0&&e<this.gridRightBoundary&&o>=0&&t<this.gridBottomBoundary}getViewportMatrix(){const t=e.bx([]);return e.bo(t,t,[-100,-100,0]),t}}function li(t,i,o){const s=i.createTileMatrix(t,t.worldSize,o.toUnwrapped());return e.az(new Float32Array(16),t.projMatrix,s)}function ci(e,t,i){if(t.projection.name===i.projection.name)return e.projMatrix;const o=i.clone();return o.setProjection(t.projection),li(o,t.getProjection(),e)}function hi(e,t,i){return t.name===i.projection.name?e.projMatrix:li(i,t,e)}class di{constructor(e,t,i,o){this.opacity=e?Math.max(0,Math.min(1,e.opacity+(e.placed?t:-t))):o&&i?1:0,this.placed=i;}isHidden(){return 0===this.opacity&&!this.placed}}class ui{constructor(e,t,i,o,s,r=!1){this.text=new di(e?e.text:null,t,i,s),this.icon=new di(e?e.icon:null,t,o,s),this.clipped=r;}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class _i{constructor(e,t,i,o=!1){this.text=e,this.icon=t,this.skipFade=i,this.clipped=o;}}class pi{constructor(){this.invProjMatrix=e.bz(),this.viewportMatrix=e.bz(),this.circles=[];}}class fi{constructor(e,t,i,o,s){this.bucketInstanceId=e,this.featureIndex=t,this.sourceLayerIndex=i,this.bucketIndex=o,this.tileID=s;}}class mi{constructor(e){this.crossSourceCollisions=e,this.maxGroupID=0,this.collisionGroups={};}get(e){if(this.crossSourceCollisions)return {ID:0,predicate:null};if(!this.collisionGroups[e]){const t=++this.maxGroupID;this.collisionGroups[e]={ID:t,predicate:e=>e.collisionGroupID===t};}return this.collisionGroups[e]}}function gi(t,i,o,s,r){const{horizontalAlign:n,verticalAlign:a}=e.bT(t),l=-(n-.5)*i,c=-(a-.5)*o,h=e.bU(t,s);return new e.P(l+h[0]*r,c+h[1]*r)}function vi(t,i,o,s,r){const n=new e.P(t,i);return o&&n._rotate(s?r:-r),n}class yi{constructor(e,t,i,o,s,r){this.transform=e.clone(),this.projection=e.projection.name,this.collisionIndex=new ai(this.transform,s),this.buildingIndex=r,this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=t,this.retainedQueryData={},this.collisionGroups=new mi(i),this.collisionCircleArrays={},this.prevPlacement=o,o&&(o.prevPlacement=void 0),this.placedOrientations={};}getBucketParts(t,i,o,s,r=1){const n=o.getBucket(i),a=o.latestFeatureIndex;if(!n||!a||i.fqid!==n.layerIds[0])return;const l=n.layers[0].layout,c=n.layers[0].paint,h=o.collisionBoxArray,d=Math.pow(2,this.transform.zoom-o.tileID.overscaledZ),u=o.tileSize/e.aj,_=o.tileID.toUnwrapped();this.transform.setProjection(n.projection);const p=(f=o.tileID,m=n.getProjection(),g=this.transform,m.name===this.projection?g.calculateProjMatrix(f.toUnwrapped()):li(g,m,f));var f,m,g;const v="map"===l.get("text-pitch-alignment"),y="map"===l.get("text-rotation-alignment");i.compileFilter(i.options);const x=i.dynamicFilter(),b=i.dynamicFilterNeedsFeature(),w=this.transform.calculatePixelsToTileUnitsMatrix(o),T=Ht(p,o.tileID.canonical,v,y,this.transform,n.getProjection(),w);let E=null;if(v){const t=Wt(p,o.tileID.canonical,v,y,this.transform,n.getProjection(),w);E=e.az([],this.transform.labelPlaneMatrix,t);}let S=null;x&&o.latestFeatureIndex&&(S={unwrappedTileID:_,dynamicFilter:x,dynamicFilterNeedsFeature:b}),this.retainedQueryData[n.bucketInstanceId]=new fi(n.bucketInstanceId,a,n.sourceLayerIndex,n.index,o.tileID);const[I,C]=n.layers[0].layout.get("text-size-scale-range"),R=e.ay(r,I,C),[D,A]=l.get("icon-size-scale-range"),L=e.ay(r,D,A),P={bucket:n,layout:l,paint:c,posMatrix:p,textLabelPlaneMatrix:T,labelToScreenMatrix:E,clippingData:S,scale:d,textPixelRatio:u,holdingForFade:o.holdingForFade(),collisionBoxArray:h,partiallyEvaluatedTextSize:e.bH(n.textSizeData,this.transform.zoom,R),partiallyEvaluatedIconSize:e.bH(n.iconSizeData,this.transform.zoom,L),collisionGroup:this.collisionGroups.get(n.sourceID),latestFeatureIndex:o.latestFeatureIndex};if(s)for(const e of n.sortKeyRanges){const{sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:s}=e;t.push({sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:s,parameters:P});}else t.push({symbolInstanceStart:0,symbolInstanceEnd:n.symbolInstances.length,parameters:P});}attemptAnchorPlacement(e,t,i,o,s,r,n,a,l,c,h,d,u,_,p,f,m,g){const{textOffset0:v,textOffset1:y,crossTileID:x}=d,b=[v,y],w=gi(e,i,o,b,s),T=this.collisionIndex.placeCollisionBox(_,s,t,vi(w.x,w.y,r,n,this.transform.angle),h,a,l,c.predicate);if(f){const e=_.getSymbolInstanceIconSize(g,this.transform.zoom,d.placedIconSymbolIndex);if(0===this.collisionIndex.placeCollisionBox(_,e,f,vi(w.x,w.y,r,n,this.transform.angle),h,a,l,c.predicate).box.length)return}if(T.box.length>0){let t;return this.prevPlacement&&this.prevPlacement.variableOffsets[x]&&this.prevPlacement.placements[x]&&this.prevPlacement.placements[x].text&&(t=this.prevPlacement.variableOffsets[x].anchor),this.variableOffsets[x]={textOffset:b,width:i,height:o,anchor:e,textScale:s,prevAnchor:t},this.markUsedJustification(_,e,d,p),_.allowVerticalPlacement&&(this.markUsedOrientation(_,p,d),this.placedOrientations[x]=p),{shift:w,placedGlyphBoxes:T}}}placeLayerBucketPart(t,i,o,s,r=1){const{bucket:n,layout:a,paint:l,posMatrix:c,textLabelPlaneMatrix:h,labelToScreenMatrix:d,clippingData:u,textPixelRatio:_,holdingForFade:p,collisionBoxArray:f,partiallyEvaluatedTextSize:m,partiallyEvaluatedIconSize:g,collisionGroup:v,latestFeatureIndex:y}=t.parameters,x=a.get("text-optional"),b=a.get("icon-optional"),w=a.get("text-allow-overlap"),T=a.get("icon-allow-overlap"),E="map"===a.get("text-rotation-alignment"),S="map"===a.get("text-pitch-alignment"),I=l.get("symbol-z-offset"),C="sea"===a.get("symbol-elevation-reference"),[R,D]=a.get("text-size-scale-range"),[A,L]=a.get("icon-size-scale-range"),P=e.ay(r,R,D),z=e.ay(r,A,L);this.transform.setProjection(n.projection);let M=w&&(T||!n.hasIconData()||b),O=T&&(w||!n.hasTextData()||x);const F=!I.isConstant();!n.collisionArrays&&f&&n.deserializeCollisionBoxes(f),o&&s&&n.updateCollisionDebugBuffers(this.transform.zoom,f,P,z);const B=(t,s,l)=>{const{crossTileID:f,numVerticalGlyphVertices:R}=t;let D=null;if(u&&u.dynamicFilterNeedsFeature||F){const e=this.retainedQueryData[n.bucketInstanceId];D=y.loadFeature({featureIndex:t.featureIndex,bucketIndex:e.bucketIndex,sourceLayerIndex:e.sourceLayerIndex,layoutVertexArrayOffset:0});}if(u&&!(0,u.dynamicFilter)({zoom:this.transform.zoom,pitch:this.transform.pitch},D,this.retainedQueryData[n.bucketInstanceId].tileID.canonical,new e.P(t.tileAnchorX,t.tileAnchorY),this.transform.calculateDistanceTileData(u.unwrappedTileID)))return this.placements[f]=new _i(!1,!1,!1,!0),void i.add(f);const A=I.evaluate(D,{});if(i.has(f))return;if(p)return void(this.placements[f]=new _i(!1,!1,!1));let L=!1,P=!1,z=!0,B=!1,k=!1,N=null,U={box:null,offscreen:null,occluded:null},j={box:null},V=null,G=null,q=null,Z=0,H=0,W=0;l.textFeatureIndex?Z=l.textFeatureIndex:t.useRuntimeCollisionCircles&&(Z=t.featureIndex),l.verticalTextFeatureIndex&&(H=l.verticalTextFeatureIndex);const $=e=>{e.tileID=this.retainedQueryData[n.bucketInstanceId].tileID;const i=this.transform.elevation;e.elevation=C?A:A+(i?i.getAtTileOffset(e.tileID,e.tileAnchorX,e.tileAnchorY):0),e.elevation+=t.zOffset;},X=l.textBox;if(X){$(X);const i=i=>{let o=e.bI.horizontal;if(n.allowVerticalPlacement&&!i&&this.prevPlacement){const e=this.prevPlacement.placedOrientations[f];e&&(this.placedOrientations[f]=e,o=e,this.markUsedOrientation(n,o,t));}return o},o=(t,i)=>{if(n.allowVerticalPlacement&&R>0&&l.verticalTextBox){for(const o of n.writingModes)if(o===e.bI.vertical?(U=i(),j=U):U=t(),U&&U.box&&U.box.length)break}else U=t();};if(a.get("text-variable-anchor")){let r=a.get("text-variable-anchor");if(this.prevPlacement&&this.prevPlacement.variableOffsets[f]){const e=this.prevPlacement.variableOffsets[f];r.indexOf(e.anchor)>0&&(r=r.filter((t=>t!==e.anchor)),r.unshift(e.anchor));}const h=(e,i,o)=>{const a=n.getSymbolInstanceTextSize(m,t,this.transform.zoom,s),l=(e.x2-e.x1)*a+2*e.padding,h=(e.y2-e.y1)*a+2*e.padding,d=t.hasIconTextFit&&!T?i:null;d&&$(d);let u={box:[],offscreen:!1,occluded:!1};const p=w?2*r.length:r.length;for(let i=0;i<p;++i){const p=this.attemptAnchorPlacement(r[i%r.length],e,l,h,a,E,S,_,c,v,i>=r.length,t,s,n,o,d,m,g);if(p&&(u=p.placedGlyphBoxes,u&&u.box&&u.box.length)){L=!0,N=p.shift;break}}return u};o((()=>h(X,l.iconBox,e.bI.horizontal)),(()=>{const t=l.verticalTextBox;return t&&$(t),n.allowVerticalPlacement&&!(U&&U.box&&U.box.length)&&R>0&&t?h(t,l.verticalIconBox,e.bI.vertical):{box:null,offscreen:null,occluded:null}})),U&&(L=U.box,z=U.offscreen,B=U.occluded);const d=i(!(!U||!U.box));if(!L&&this.prevPlacement){const e=this.prevPlacement.variableOffsets[f];e&&(this.variableOffsets[f]=e,this.markUsedJustification(n,e.anchor,t,d));}}else {const a=(i,o)=>{const a=n.getSymbolInstanceTextSize(m,t,this.transform.zoom,s,r),l=this.collisionIndex.placeCollisionBox(n,a,i,new e.P(0,0),w,_,c,v.predicate);return l&&l.box&&l.box.length&&(this.markUsedOrientation(n,o,t),this.placedOrientations[f]=o),l};o((()=>a(X,e.bI.horizontal)),(()=>{const t=l.verticalTextBox;return n.allowVerticalPlacement&&R>0&&t?($(t),a(t,e.bI.vertical)):{box:null,offscreen:null,occluded:null}})),i(!!(U&&U.box&&U.box.length));}}if(V=U,L=V&&V.box&&V.box.length>0,z=V&&V.offscreen,B=V&&V.occluded,t.useRuntimeCollisionCircles){const i=n.text.placedSymbolArray.get(t.centerJustifiedTextSymbolIndex>=0?t.centerJustifiedTextSymbolIndex:t.verticalPlacedTextSymbolIndex),s=e.bJ(n.textSizeData,m,i),r=a.get("text-padding");G=this.collisionIndex.placeCollisionCircles(n,w,i,n.lineVertexArray,n.glyphOffsetArray,s,c,h,d,o,S,v.predicate,t.collisionCircleDiameter*s/e.bO,r,this.retainedQueryData[n.bucketInstanceId].tileID),L=w||G.circles.length>0&&!G.collisionDetected,z=z&&G.offscreen,B=G.occluded;}if(l.iconFeatureIndex&&(W=l.iconFeatureIndex),l.iconBox){const i=i=>{$(i);const o=t.hasIconTextFit&&N?vi(N.x,N.y,E,S,this.transform.angle):new e.P(0,0),s=n.getSymbolInstanceIconSize(g,this.transform.zoom,t.placedIconSymbolIndex);return this.collisionIndex.placeCollisionBox(n,s,i,o,T,_,c,v.predicate)};j&&j.box&&j.box.length&&l.verticalIconBox?(q=i(l.verticalIconBox),P=q.box.length>0):(q=i(l.iconBox),P=q.box.length>0),z=z&&q.offscreen,k=q.occluded;}const Y=x||0===t.numHorizontalGlyphVertices&&0===R,K=b||0===t.numIconVertices;if(Y||K?K?Y||(P=P&&L):L=P&&L:P=L=P&&L,L&&V&&V.box&&this.collisionIndex.insertCollisionBox(V.box,a.get("text-ignore-placement"),n.bucketInstanceId,j&&j.box&&H?H:Z,v.ID),P&&q&&this.collisionIndex.insertCollisionBox(q.box,a.get("icon-ignore-placement"),n.bucketInstanceId,W,v.ID),G&&(L&&this.collisionIndex.insertCollisionCircles(G.circles,a.get("text-ignore-placement"),n.bucketInstanceId,Z,v.ID),o)){const e=n.bucketInstanceId;let t=this.collisionCircleArrays[e];void 0===t&&(t=this.collisionCircleArrays[e]=new pi);for(let e=0;e<G.circles.length;e+=4)t.circles.push(G.circles[e+0]),t.circles.push(G.circles[e+1]),t.circles.push(G.circles[e+2]),t.circles.push(G.collisionDetected?1:0);}const J="globe"!==n.projection.name;M=M&&(J||!B),O=O&&(J||!k),this.placements[f]=new _i(L||M,P||O,z||n.justReloaded),i.add(f);},k=this.retainedQueryData[n.bucketInstanceId].tileID;if("offset"===n.elevationType&&this.buildingIndex&&this.buildingIndex.updateZOffset(n,k),"road"===n.elevationType&&n.updateRoadElevation(k.canonical),n.updateZOffset(),n.sortFeaturesByY){const t=n.getSortedSymbolIndexes(this.transform.angle);for(let e=t.length-1;e>=0;--e){const i=t[e];B(n.symbolInstances.get(i),i,n.collisionArrays[i]);}n.hasAnyZOffset&&e.w(`${n.layerIds[0]} layer symbol-z-elevate: symbols are not sorted by elevation if symbol-z-order is evaluated to viewport-y`);}else if(n.hasAnyZOffset){const e=n.getSortedIndexesByZOffset();for(let t=0;t<e.length;++t){const i=e[t];B(n.symbolInstances.get(i),i,n.collisionArrays[i]);}}else for(let e=t.symbolInstanceStart;e<t.symbolInstanceEnd;e++)B(n.symbolInstances.get(e),e,n.collisionArrays[e]);if(o&&n.bucketInstanceId in this.collisionCircleArrays){const t=this.collisionCircleArrays[n.bucketInstanceId];e.bi(t.invProjMatrix,c),t.viewportMatrix=this.collisionIndex.getViewportMatrix();}n.justReloaded=!1;}markUsedJustification(t,i,o,s){const{leftJustifiedTextSymbolIndex:r,centerJustifiedTextSymbolIndex:n,rightJustifiedTextSymbolIndex:a,verticalPlacedTextSymbolIndex:l,crossTileID:c}=o,h=e.bV(i),d=s===e.bI.vertical?l:"left"===h?r:"center"===h?n:"right"===h?a:-1;r>=0&&(t.text.placedSymbolArray.get(r).crossTileID=d>=0&&r!==d?0:c),n>=0&&(t.text.placedSymbolArray.get(n).crossTileID=d>=0&&n!==d?0:c),a>=0&&(t.text.placedSymbolArray.get(a).crossTileID=d>=0&&a!==d?0:c),l>=0&&(t.text.placedSymbolArray.get(l).crossTileID=d>=0&&l!==d?0:c);}markUsedOrientation(t,i,o){const s=i===e.bI.horizontal||i===e.bI.horizontalOnly?i:0,r=i===e.bI.vertical?i:0,{leftJustifiedTextSymbolIndex:n,centerJustifiedTextSymbolIndex:a,rightJustifiedTextSymbolIndex:l,verticalPlacedTextSymbolIndex:c}=o,h=t.text.placedSymbolArray;n>=0&&(h.get(n).placedOrientation=s),a>=0&&(h.get(a).placedOrientation=s),l>=0&&(h.get(l).placedOrientation=s),c>=0&&(h.get(c).placedOrientation=r);}commit(e){this.commitTime=e,this.zoomAtLastRecencyCheck=this.transform.zoom;const t=this.prevPlacement;let i=!1;this.prevZoomAdjustment=t?t.zoomAdjustment(this.transform.zoom):0;const o=t?t.symbolFadeChange(e):1,s=t?t.opacities:{},r=t?t.variableOffsets:{},n=t?t.placedOrientations:{};for(const e in this.placements){const t=this.placements[e],r=s[e];r?(this.opacities[e]=new ui(r,o,t.text,t.icon,null,t.clipped),i=i||t.text!==r.text.placed||t.icon!==r.icon.placed):(this.opacities[e]=new ui(null,o,t.text,t.icon,t.skipFade,t.clipped),i=i||t.text||t.icon);}for(const e in s){const t=s[e];if(!this.opacities[e]){const s=new ui(t,o,!1,!1);s.isHidden()||(this.opacities[e]=s,i=i||t.text.placed||t.icon.placed);}}for(const e in r)this.variableOffsets[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.variableOffsets[e]=r[e]);for(const e in n)this.placedOrientations[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.placedOrientations[e]=n[e]);i?this.lastPlacementChangeTime=e:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=t?t.lastPlacementChangeTime:e);}updateLayerOpacities(e,t,i,o){const s=new Set;for(const r of t){const t=r.getBucket(e);t&&r.latestFeatureIndex&&e.fqid===t.layerIds[0]&&(this.updateBucketOpacities(t,s,r,r.collisionBoxArray,i,o,r.tileID,e.scope),"offset"===t.elevationType&&this.buildingIndex&&this.buildingIndex.updateZOffset(t,r.tileID),"road"===t.elevationType&&t.updateRoadElevation(r.tileID.canonical),t.updateZOffset());}}updateBucketOpacities(t,i,o,s,r,n,a,l){t.hasTextData()&&t.text.opacityVertexArray.clear(),t.hasIconData()&&t.icon.opacityVertexArray.clear(),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexArray.clear(),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexArray.clear();const c=t.layers[0].layout,h=t.layers[0].paint,d=!!t.layers[0].dynamicFilter(),u=new ui(null,0,!1,!1,!0),_=c.get("text-allow-overlap"),p=c.get("icon-allow-overlap"),f=c.get("text-variable-anchor"),m="map"===c.get("text-rotation-alignment"),g="map"===c.get("text-pitch-alignment"),v=h.get("symbol-z-offset"),y="sea"===c.get("symbol-elevation-reference"),x=!v.isConstant(),b=new ui(null,0,_&&(p||!t.hasIconData()||c.get("icon-optional")),p&&(_||!t.hasTextData()||c.get("text-optional")),!0);!t.collisionArrays&&s&&(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData())&&t.deserializeCollisionBoxes(s);const w=(e,t,i)=>{for(let o=0;o<t/4;o++)e.opacityVertexArray.emplaceBack(i);};let T=0;n&&t.updateReplacement(a,n);for(let s=0;s<t.symbolInstances.length;s++){const c=t.symbolInstances.get(s),{numHorizontalGlyphVertices:h,numVerticalGlyphVertices:_,crossTileID:p,numIconVertices:E,tileAnchorX:S,tileAnchorY:I}=c;let C=null;const R=this.retainedQueryData[t.bucketInstanceId];x&&c&&R&&(C=o.latestFeatureIndex.loadFeature({featureIndex:c.featureIndex,bucketIndex:R.bucketIndex,sourceLayerIndex:R.sourceLayerIndex,layoutVertexArrayOffset:0}));const D=v.evaluate(C,{}),A=i.has(p);let L=this.opacities[p];A?L=u:L||(L=b,this.opacities[p]=L),i.add(p);const P=h>0||_>0,z=E>0,M=this.placedOrientations[p],O=M===e.bI.vertical,F=M===e.bI.horizontal||M===e.bI.horizontalOnly;!P&&!z||L.isHidden()||T++;let B=!1;if((P||z)&&n)for(const i of t.activeReplacements){if(e.bP(i,r,e.bQ.Symbol,l))continue;if(i.min.x>S||S>i.max.x||i.min.y>I||I>i.max.y)continue;const t=e.bR(S,I,a.canonical,i.footprintTileId.canonical);if(B=e.bS(t,i.footprint),B)break}if(P){const e=B?Di:Ri(L.text);w(t.text,h,O?Di:e),w(t.text,_,F?Di:e);const i=L.text.isHidden(),{leftJustifiedTextSymbolIndex:o,centerJustifiedTextSymbolIndex:s,rightJustifiedTextSymbolIndex:r,verticalPlacedTextSymbolIndex:n}=c,a=t.text.placedSymbolArray,l=i||O?1:0;o>=0&&(a.get(o).hidden=l),s>=0&&(a.get(s).hidden=l),r>=0&&(a.get(r).hidden=l),n>=0&&(a.get(n).hidden=i||F?1:0);const d=this.variableOffsets[p];d&&this.markUsedJustification(t,d.anchor,c,M);const u=this.placedOrientations[p];u&&(this.markUsedJustification(t,"left",c,u),this.markUsedOrientation(t,u,c));}if(z){const e=B?Di:Ri(L.icon),{placedIconSymbolIndex:i,verticalPlacedIconSymbolIndex:o}=c,s=t.icon.placedSymbolArray,r=L.icon.isHidden()?1:0;i>=0&&(w(t.icon,E,O?Di:e),s.get(i).hidden=r),o>=0&&(w(t.icon,c.numVerticalIconVertices,F?Di:e),s.get(o).hidden=r);}if(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData()){const i=t.collisionArrays[s];if(i){let o=new e.P(0,0),s=!0;if(i.textBox||i.verticalTextBox){if(f){const e=this.variableOffsets[p];e?(o=gi(e.anchor,e.width,e.height,e.textOffset,e.textScale),m&&o._rotate(g?this.transform.angle:-this.transform.angle)):s=!1;}d&&(s=!L.clipped),i.textBox&&xi(t.textCollisionBox.collisionVertexArray,L.text.placed,!s||O,D,y,o.x,o.y),i.verticalTextBox&&xi(t.textCollisionBox.collisionVertexArray,L.text.placed,!s||F,D,y,o.x,o.y);}const r=s&&Boolean(!F&&i.verticalIconBox);i.iconBox&&xi(t.iconCollisionBox.collisionVertexArray,L.icon.placed,r,D,y,c.hasIconTextFit?o.x:0,c.hasIconTextFit?o.y:0),i.verticalIconBox&&xi(t.iconCollisionBox.collisionVertexArray,L.icon.placed,!r,D,y,c.hasIconTextFit?o.x:0,c.hasIconTextFit?o.y:0);}}}if(t.fullyClipped=0===T,t.sortFeatures(this.transform.angle),this.retainedQueryData[t.bucketInstanceId]&&(this.retainedQueryData[t.bucketInstanceId].featureSortOrder=t.featureSortOrder),t.hasTextData()&&t.text.opacityVertexBuffer&&t.text.opacityVertexBuffer.updateData(t.text.opacityVertexArray),t.hasIconData()&&t.icon.opacityVertexBuffer&&t.icon.opacityVertexBuffer.updateData(t.icon.opacityVertexArray),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexBuffer&&t.iconCollisionBox.collisionVertexBuffer.updateData(t.iconCollisionBox.collisionVertexArray),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexBuffer&&t.textCollisionBox.collisionVertexBuffer.updateData(t.textCollisionBox.collisionVertexArray),t.bucketInstanceId in this.collisionCircleArrays){const e=this.collisionCircleArrays[t.bucketInstanceId];t.placementInvProjMatrix=e.invProjMatrix,t.placementViewportMatrix=e.viewportMatrix,t.collisionCircleArray=e.circles,delete this.collisionCircleArrays[t.bucketInstanceId];}}symbolFadeChange(e){return 0===this.fadeDuration?1:(e-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(e){return Math.max(0,(this.transform.zoom-e)/1.5)}hasTransitions(e){return this.stale||e-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(e,t){const i=this.zoomAtLastRecencyCheck===t?1-this.zoomAdjustment(t):1;return this.zoomAtLastRecencyCheck=t,this.commitTime+this.fadeDuration*i>e}setStale(){this.stale=!0;}}function xi(e,t,i,o,s,r,n){e.emplaceBack(t?1:0,i?1:0,r||0,n||0,o,s?1:0),e.emplaceBack(t?1:0,i?1:0,r||0,n||0,o,s?1:0),e.emplaceBack(t?1:0,i?1:0,r||0,n||0,o,s?1:0),e.emplaceBack(t?1:0,i?1:0,r||0,n||0,o,s?1:0);}const bi=Math.pow(2,25),wi=Math.pow(2,24),Ti=Math.pow(2,17),Ei=Math.pow(2,16),Si=Math.pow(2,9),Ii=Math.pow(2,8),Ci=Math.pow(2,1);function Ri(e){if(0===e.opacity&&!e.placed)return 0;if(1===e.opacity&&e.placed)return 4294967295;const t=e.placed?1:0,i=Math.floor(127*e.opacity);return i*bi+t*wi+i*Ti+t*Ei+i*Si+t*Ii+i*Ci+t}const Di=0;class Ai{constructor(e){this._sortAcrossTiles="viewport-y"!==e.layout.get("symbol-z-order")&&void 0!==e.layout.get("symbol-sort-key").constantOr(1),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs=new Set,this._bucketParts=[];}continuePlacement(e,t,i,o,s,r){const n=this._bucketParts;for(;this._currentTileIndex<e.length;)if(t.getBucketParts(n,o,e[this._currentTileIndex],this._sortAcrossTiles,r),this._currentTileIndex++,s())return !0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,n.sort(((e,t)=>e.sortKey-t.sortKey)));this._currentPartIndex<n.length;){const e=n[this._currentPartIndex];if(t.placeLayerBucketPart(e,this._seenCrossTileIDs,i,0===e.symbolInstanceStart,r),this._currentPartIndex++,s())return !0}return !1}}class Li{constructor(e,t,i,o,s,r,n,a,l){this.placement=new yi(e,s,r,n,a,l),this._currentPlacementIndex=t.length-1,this._forceFullPlacement=i,this._showCollisionBoxes=o,this._done=!1;}isDone(){return this._done}continuePlacement(t,i,o,s,r){const n=e.q.now(),a=()=>{const t=e.q.now()-n;return !this._forceFullPlacement&&t>2};for(;this._currentPlacementIndex>=0;){const n=i[t[this._currentPlacementIndex]],l=this.placement.collisionIndex.transform.zoom;if("symbol"===n.type&&(!n.minzoom||n.minzoom<=l)&&(!n.maxzoom||n.maxzoom>l)){const t=n,i=t.layout.get("symbol-z-elevate"),l=void 0!==t.layout.get("symbol-sort-key").constantOr(1),c=t.layout.get("symbol-z-order"),h="viewport-y"===c||"auto"===c&&!("viewport-y"!==c&&l),d=t.layout.get("text-allow-overlap")||t.layout.get("icon-allow-overlap")||t.layout.get("text-ignore-placement")||t.layout.get("icon-ignore-placement"),u=h&&d,_=this._inProgressLayer=this._inProgressLayer||new Ai(t),p=e.C(n.source,n.scope);if(_.continuePlacement(i||u?s[p]:o[p],this.placement,this._showCollisionBoxes,n,a,r))return;delete this._inProgressLayer;}this._currentPlacementIndex--;}this._done=!0;}commit(e){return this.placement.commit(e),this.placement}}const Pi=512/e.aj/2;class zi{constructor(t,i,o){this.tileID=t,this.bucketInstanceId=o,this.index=new e.bW(i.length,16,Int32Array),this.keys=[],this.crossTileIDs=[];const s=t.canonical.x*e.aj,r=t.canonical.y*e.aj;for(let e=0;e<i.length;e++){const{key:t,crossTileID:o,tileAnchorX:n,tileAnchorY:a}=i.get(e),l=Math.floor((s+n)*Pi),c=Math.floor((r+a)*Pi);this.index.add(l,c),this.keys.push(t),this.crossTileIDs.push(o);}this.index.finish();}findMatches(t,i,o){const s=this.tileID.canonical.z<i.canonical.z?1:Math.pow(2,this.tileID.canonical.z-i.canonical.z),r=Pi/Math.pow(2,i.canonical.z-this.tileID.canonical.z),n=i.canonical.x*e.aj,a=i.canonical.y*e.aj;for(let e=0;e<t.length;e++){const i=t.get(e);if(i.crossTileID)continue;const{key:l,tileAnchorX:c,tileAnchorY:h}=i,d=Math.floor((n+c)*r),u=Math.floor((a+h)*r),_=this.index.range(d-s,u-s,d+s,u+s).sort(((e,t)=>e-t));for(const e of _){const t=this.crossTileIDs[e];if(this.keys[e]===l&&!o.has(t)){o.add(t),i.crossTileID=t;break}}}}}class Mi{constructor(){this.maxCrossTileID=0;}generate(){return ++this.maxCrossTileID}}class Oi{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0;}handleWrapJump(e){const t=Math.round((e-this.lng)/360);if(0!==t)for(const e in this.indexes){const i=this.indexes[e],o={};for(const e in i){const s=i[e];s.tileID=s.tileID.unwrapTo(s.tileID.wrap+t),o[s.tileID.key]=s;}this.indexes[e]=o;}this.lng=e;}addBucket(e,t,i){if(this.indexes[e.overscaledZ]&&this.indexes[e.overscaledZ][e.key]){if(this.indexes[e.overscaledZ][e.key].bucketInstanceId===t.bucketInstanceId)return !1;this.removeBucketCrossTileIDs(e.overscaledZ,this.indexes[e.overscaledZ][e.key]);}for(let e=0;e<t.symbolInstances.length;e++)t.symbolInstances.get(e).crossTileID=0;this.usedCrossTileIDs[e.overscaledZ]||(this.usedCrossTileIDs[e.overscaledZ]=new Set);const o=this.usedCrossTileIDs[e.overscaledZ];for(const i in this.indexes){const s=this.indexes[i];if(Number(i)>e.overscaledZ)for(const i in s){const r=s[i];r.tileID.isChildOf(e)&&r.findMatches(t.symbolInstances,e,o);}else {const r=s[e.scaledTo(Number(i)).key];r&&r.findMatches(t.symbolInstances,e,o);}}for(let e=0;e<t.symbolInstances.length;e++){const s=t.symbolInstances.get(e);s.crossTileID||(s.crossTileID=i.generate(),o.add(s.crossTileID));}return void 0===this.indexes[e.overscaledZ]&&(this.indexes[e.overscaledZ]={}),this.indexes[e.overscaledZ][e.key]=new zi(e,t.symbolInstances,t.bucketInstanceId),!0}removeBucketCrossTileIDs(e,t){for(const i of t.crossTileIDs)this.usedCrossTileIDs[e].delete(i);}removeStaleBuckets(e){let t=!1;for(const i in this.indexes){const o=this.indexes[i];for(const s in o)e[o[s].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,o[s]),delete o[s],t=!0);}return t}}class Fi{constructor(){this.layerIndexes={},this.crossTileIDs=new Mi,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={};}addLayer(e,t,i,o){let s=this.layerIndexes[e.fqid];void 0===s&&(s=this.layerIndexes[e.fqid]=new Oi);let r=!1;const n={};"globe"!==o.name&&s.handleWrapJump(i);for(const i of t){const t=i.getBucket(e);t&&e.fqid===t.layerIds[0]&&(t.bucketInstanceId||(t.bucketInstanceId=++this.maxBucketInstanceId),s.addBucket(i.tileID,t,this.crossTileIDs)&&(r=!0),n[t.bucketInstanceId]=!0);}return s.removeStaleBuckets(n)&&(r=!0),r}pruneUnusedLayers(e){const t={};e.forEach((e=>{t[e]=!0;}));for(const e in this.layerIndexes)t[e]||delete this.layerIndexes[e];}}const Bi=771;class ki{constructor(e,t,i,o){this.blendFunction=e,this.blendColor=t.toNonPremultipliedRenderColor(null),this.mask=i,this.blendEquation=o;}}ki.Replace=[1,0,1,0],ki.disabled=new ki(ki.Replace,e.am.transparent,[!1,!1,!1,!1]),ki.unblended=new ki(ki.Replace,e.am.transparent,[!0,!0,!0,!0]),ki.alphaBlended=new ki([1,Bi,1,Bi],e.am.transparent,[!0,!0,!0,!0]),ki.alphaBlendedNonPremultiplied=new ki([770,Bi,770,Bi],e.am.transparent,[!0,!0,!0,!0]),ki.multiply=new ki([774,0,774,0],e.am.transparent,[!0,!0,!0,!0]);class Ni{constructor(e,t,i){this.func=e,this.mask=t,this.range=i;}}Ni.ReadOnly=!1,Ni.ReadWrite=!0,Ni.disabled=new Ni(519,Ni.ReadOnly,[0,1]);const Ui=7680;class ji{constructor(e,t,i,o,s,r){this.test=e,this.ref=t,this.mask=i,this.fail=o,this.depthFail=s,this.pass=r;}}ji.disabled=new ji({func:519,mask:0},0,0,Ui,Ui,Ui);const Vi=1029,Gi=2305;class qi{constructor(e,t,i){this.enable=e,this.mode=t,this.frontFace=i;}}function Zi(t,i){const o=e.c1(t,3);e.c3(t,i),e.c7(t,3,o);}function Hi(t,i){const o=e.b_([]);return e.b$(o,o,-i),e.c0(o,o,-t),o}function Wi(t,i){const o=[t[0],t[1],0],s=[i[0],i[1],0];if(e.ae(o)>=1e-15){const t=e.au([],o);e.bY(s,t,e.bG(s,t)),i[0]=s[0],i[1]=s[1];}const r=e.bF([],i,t);if(e.bZ(r)<1e-15)return null;const n=Math.atan2(-r[1],r[0]);return Hi(Math.atan2(Math.sqrt(t[0]*t[0]+t[1]*t[1]),-t[2]),n)}qi.disabled=new qi(!1,Vi,Gi),qi.backCCW=new qi(!0,Vi,Gi),qi.backCW=new qi(!0,Vi,2304),qi.frontCW=new qi(!0,1028,2304),qi.frontCCW=new qi(!0,1028,Gi);class $i{constructor(e,t){this.position=e,this.orientation=t;}get position(){return this._position}set position(t){if(t){const i=t instanceof e.ac?t:new e.ac(t[0],t[1],t[2]);this._renderWorldCopies&&(i.x=e.bX(i.x,0,1)),this._position=i;}else this._position=null;}lookAtPoint(t,i){if(this.orientation=null,!this.position)return;const o=this.position,s=this._elevation?this._elevation.getAtPointOrZero(e.ac.fromLngLat(t)):0,r=e.ac.fromLngLat(t,s),n=[r.x-o.x,r.y-o.y,r.z-o.z];i||(i=[0,0,1]),i[2]=Math.abs(i[2]),this.orientation=Wi(n,i);}setPitchBearing(t,i){this.orientation=Hi(e.al(t),e.al(-i));}}class Xi{constructor(t,i){this._transform=e.bx([]),this.orientation=i,this.position=t;}get mercatorPosition(){const t=this.position;return new e.ac(t[0],t[1],t[2])}get position(){const t=e.c1(this._transform,3);return [t[0],t[1],t[2]]}set position(t){var i;t&&e.c7(this._transform,3,[(i=t)[0],i[1],i[2],1]);}get orientation(){return this._orientation}set orientation(t){this._orientation=t||e.b_([]),t&&Zi(this._transform,this._orientation);}getPitchBearing(){const e=this.forward(),t=this.right();return {bearing:Math.atan2(-t[1],t[0]),pitch:Math.atan2(Math.sqrt(e[0]*e[0]+e[1]*e[1]),-e[2])}}setPitchBearing(e,t){this._orientation=Hi(e,t),Zi(this._transform,this._orientation);}forward(){const t=e.c1(this._transform,2);return [-t[0],-t[1],-t[2]]}up(){const t=e.c1(this._transform,1);return [-t[0],-t[1],-t[2]]}right(){const t=e.c1(this._transform,0);return [t[0],t[1],t[2]]}getCameraToWorld(t,i){const o=new Float64Array(16);return e.bi(o,this.getWorldToCamera(t,i)),o}getCameraToWorldMercator(){return this._transform}getWorldToCameraPosition(t,i,o){const s=this.position;e.bY(s,s,-t);const r=new Float64Array(16);return e.bn(r,[o,o,o]),e.bo(r,r,s),r[10]*=i,r}getWorldToCamera(t,i){const o=new Float64Array(16),s=new Float64Array(4),r=this.position;return e.c2(s,this._orientation),e.bY(r,r,-t),e.c3(o,s),e.bo(o,o,r),o[1]*=-1,o[5]*=-1,o[9]*=-1,o[13]*=-1,o[8]*=i,o[9]*=i,o[10]*=i,o[11]*=i,o}getCameraToClipPerspective(t,i,o,s){const r=new Float64Array(16);return e.c4(r,t,i,o,s),r}getCameraToClipOrthographic(t,i,o,s,r,n){const a=new Float64Array(16);return e.c5(a,t,i,o,s,r,n),a}getDistanceToElevation(t,i=!1){const o=0===t?0:e.c6(t,i?e.aY(this.position[1]):this.position[1]),s=this.forward();return (o-this.position[2])/s[2]}clone(){return new Xi([...this.position],[...this.orientation])}}const Yi={BaseColor:5,MetallicRoughness:6,Normal:7,Occlusion:8,Emission:9,LUT:10,ShadowMap0:11};class Ki{constructor(e=0,t=0,i=0,o=0){if(isNaN(e)||e<0||isNaN(t)||t<0||isNaN(i)||i<0||isNaN(o)||o<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=e,this.bottom=t,this.left=i,this.right=o;}interpolate(t,i,o){return null!=i.top&&null!=t.top&&(this.top=e.ai(t.top,i.top,o)),null!=i.bottom&&null!=t.bottom&&(this.bottom=e.ai(t.bottom,i.bottom,o)),null!=i.left&&null!=t.left&&(this.left=e.ai(t.left,i.left,o)),null!=i.right&&null!=t.right&&(this.right=e.ai(t.right,i.right,o)),this}getCenter(t,i){const o=e.ay((this.left+t-this.right)/2,0,t),s=e.ay((this.top+i-this.bottom)/2,0,i);return new e.P(o,s)}equals(e){return this.top===e.top&&this.bottom===e.bottom&&this.left===e.left&&this.right===e.right}clone(){return new Ki(this.top,this.bottom,this.left,this.right)}toJSON(){return {top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}const Ji=15;class Qi{constructor(t,i,o,s,r,n,a){this.tileSize=512,this._renderWorldCopies=void 0===r||r,this._minZoom=t||0,this._maxZoom=i||22,this._minPitch=o??0,this._maxPitch=s??60,this.setProjection(n),this.setMaxBounds(a),this.width=0,this.height=0,this._center=new e.cd(0,0),this.zoom=0,this.angle=0,this._fov=.6435011087932844,this._pitch=0,this._nearZ=0,this._farZ=0,this._unmodified=!0,this._edgeInsets=new Ki,this._projMatrixCache={},this._alignedProjMatrixCache={},this._fogTileMatrixCache={},this._expandedProjMatrixCache={},this._distanceTileDataCache={},this._camera=new Xi,this._centerAltitude=0,this._averageElevation=0,this.cameraElevationReference="ground",this._pixelsPerMercatorPixel=1,this.globeRadius=0,this.globeCenterInViewSpace=[0,0,0],this._tileCoverLift=0,this.freezeTileCoverage=!1,this._horizonShift=.1,this._orthographicProjectionAtLowPitch=!1,this._allowWorldUnderZoom=!1;}clone(){const e=new Qi(this._minZoom,this._maxZoom,this._minPitch,this.maxPitch,this._renderWorldCopies,this.getProjection(),this.maxBounds);return e._elevation=this._elevation,e._centerAltitude=this._centerAltitude,e._centerAltitudeValidForExaggeration=this._centerAltitudeValidForExaggeration,e.tileSize=this.tileSize,e.mercatorFromTransition=this.mercatorFromTransition,e.width=this.width,e.height=this.height,e.cameraElevationReference=this.cameraElevationReference,e._center=this._center,e._setZoom(this.zoom),e._seaLevelZoom=this._seaLevelZoom,e.angle=this.angle,e._fov=this._fov,e._pitch=this._pitch,e._nearZ=this._nearZ,e._farZ=this._farZ,e._averageElevation=this._averageElevation,e._orthographicProjectionAtLowPitch=this._orthographicProjectionAtLowPitch,e._unmodified=this._unmodified,e._edgeInsets=this._edgeInsets.clone(),e._camera=this._camera.clone(),e._calcMatrices(),e.freezeTileCoverage=this.freezeTileCoverage,e.frustumCorners=this.frustumCorners,e._allowWorldUnderZoom=this._allowWorldUnderZoom,e}get isOrthographic(){return "globe"!==this.projection.name&&this._orthographicProjectionAtLowPitch&&this.pitch<Ji}get elevation(){return this._elevation}set elevation(e){this._elevation!==e&&(this._elevation=e,this._updateCameraOnTerrain(),this._calcMatrices());}get depthOcclusionForSymbolsAndCircles(){return "globe"!==this.projection.name&&!this.isOrthographic}updateElevation(e,t=!1){const i=this._elevation&&this._elevation.exaggeration()!==this._centerAltitudeValidForExaggeration;(null==this._seaLevelZoom||i)&&this._updateCameraOnTerrain(),(e||i)&&this._constrainCamera(t),this._calcMatrices();}getProjection(){return e.aF(this.projection,["name","center","parallels"])}setProjection(t){this.projectionOptions=t||{name:"mercator"};const i=this.projection?this.getProjection():void 0;this.projection=e.ce(this.projectionOptions);const o=this.getProjection(),s=!e.bv(i,o);return s&&this._calcMatrices(),this.mercatorFromTransition=!1,s}setOrthographicProjectionAtLowPitch(e){return this._orthographicProjectionAtLowPitch!==e&&(this._orthographicProjectionAtLowPitch=e,this._calcMatrices(),!0)}setMercatorFromTransition(){const t=this.projection.name;this.mercatorFromTransition=!0,this.projectionOptions={name:"mercator"},this.projection=e.ce({name:"mercator"});const i=t!==this.projection.name;return i&&this._calcMatrices(),i}get minZoom(){return this._minZoom}set minZoom(e){this._minZoom!==e&&(this._minZoom=e,this.zoom=Math.max(this.zoom,e));}get maxZoom(){return this._maxZoom}set maxZoom(e){this._maxZoom!==e&&(this._maxZoom=e,this.zoom=Math.min(this.zoom,e));}get minPitch(){return this._minPitch}set minPitch(e){this._minPitch!==e&&(this._minPitch=e,this.pitch=Math.max(this.pitch,e));}get maxPitch(){return this._maxPitch}set maxPitch(e){this._maxPitch!==e&&(this._maxPitch=e,this.pitch=Math.min(this.pitch,e));}get renderWorldCopies(){return this._renderWorldCopies&&!0===this.projection.supportsWorldCopies}set renderWorldCopies(e){void 0===e?e=!0:null===e&&(e=!1),this._renderWorldCopies=e;}get worldSize(){return this.tileSize*this.scale}get cameraWorldSizeForFog(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get cameraWorldSize(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation,!0),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get pixelsPerMeter(){return this.projection.pixelsPerMeter(this.center.lat,this.worldSize)}get cameraPixelsPerMeter(){return e.c6(1,this.center.lat)*this.cameraWorldSizeForFog}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new e.P(this.width,this.height)}get bearing(){return e.bX(this.rotation,-180,180)}set bearing(e){this.rotation=e;}get rotation(){return -this.angle/Math.PI*180}set rotation(t){const i=-t*Math.PI/180;this.angle!==i&&(this._unmodified=!1,this.angle=i,this._calcMatrices(),this.rotationMatrix=e.cf(),e.cg(this.rotationMatrix,this.rotationMatrix,this.angle));}get pitch(){return this._pitch/Math.PI*180}set pitch(t){const i=e.ay(t,this.minPitch,this.maxPitch)/180*Math.PI;this._pitch!==i&&(this._unmodified=!1,this._pitch=i,this._calcMatrices());}get aspect(){return this.width/this.height}get fov(){return this._fov/Math.PI*180}set fov(t){t=Math.max(.01,Math.min(60,t)),this._fov!==t&&(this._unmodified=!1,this._fov=e.al(t),this._calcMatrices());}get fovX(){return this._fov}get fovY(){const e=1/Math.tan(.5*this.fovX);return 2*Math.atan(1/this.aspect/e)}get averageElevation(){return this._averageElevation}set averageElevation(e){this._averageElevation=e,this._calcFogMatrices(),this._distanceTileDataCache={};}get zoom(){return this._zoom}set zoom(e){const t=Math.min(Math.max(e,this.minZoom),this.maxZoom);this._zoom!==t&&(this._unmodified=!1,this._setZoom(t),this._updateSeaLevelZoom(),this._constrain(),this._calcMatrices());}_setZoom(e){this._zoom=e,this.scale=this.zoomScale(e),this.tileZoom=Math.floor(e),this.zoomFraction=e-this.tileZoom;}get tileCoverLift(){return this._tileCoverLift}set tileCoverLift(e){this._tileCoverLift!==e&&(this._tileCoverLift=e);}_updateCameraOnTerrain(){const e=this.elevation?this.elevation.getAtPoint(this.locationCoordinate(this.center),Number.NEGATIVE_INFINITY):Number.NEGATIVE_INFINITY,t=this.elevation&&e===Number.NEGATIVE_INFINITY&&this.elevation.visibleDemTiles.length>0&&this.elevation.exaggeration()>0&&this._centerAltitudeValidForExaggeration;if(!this._elevation||e===Number.NEGATIVE_INFINITY&&(!t||!this._centerAltitude))return this._centerAltitude=0,this._seaLevelZoom=null,void(this._centerAltitudeValidForExaggeration=void 0);const i=this._elevation;t||this._centerAltitude&&this._centerAltitudeValidForExaggeration&&i.exaggeration()&&this._centerAltitudeValidForExaggeration!==i.exaggeration()?(this._centerAltitude=this._centerAltitude/this._centerAltitudeValidForExaggeration*i.exaggeration(),this._centerAltitudeValidForExaggeration=i.exaggeration()):(this._centerAltitude=e||0,this._centerAltitudeValidForExaggeration=i.exaggeration()),this._updateSeaLevelZoom();}_updateSeaLevelZoom(){if(void 0===this._centerAltitudeValidForExaggeration)return;const e=Math.max(0,(this.pixelsPerMeter*this._centerAltitude+this.cameraToCenterDistance)/this.worldSize);this._seaLevelZoom=this._zoomFromMercatorZ(e);}sampleAverageElevation(){if(!this._elevation)return 0;const t=this._elevation,i=[[.5,.2],[.3,.5],[.5,.5],[.7,.5],[.5,.8]],o=this.horizonLineFromTop();let s=0,r=0;for(let n=0;n<i.length;n++){const a=new e.P(i[n][0]*this.width,o+i[n][1]*(this.height-o)),l=t.pointCoordinate(a);if(!l)continue;const c=1/Math.hypot(l[0]-this._camera.position[0],l[1]-this._camera.position[1]);s+=l[3]*c,r+=c;}return 0===r?NaN:s/r}get center(){return this._center}set center(e){e.lat===this._center.lat&&e.lng===this._center.lng||(this._unmodified=!1,this._center=e,this._terrainEnabled()&&("ground"===this.cameraElevationReference?this._updateCameraOnTerrain():this._updateZoomFromElevation()),this._constrain(),this._calcMatrices());}_updateZoomFromElevation(){if(null==this._seaLevelZoom||!this._elevation)return;const e=this._seaLevelZoom,t=this._elevation.getAtPointOrZero(this.locationCoordinate(this.center)),i=this.pixelsPerMeter/this.worldSize*t,o=this._mercatorZfromZoom(e),s=this._mercatorZfromZoom(this._maxZoom),r=Math.max(o-i,s);this._setZoom(this._zoomFromMercatorZ(r));}get padding(){return this._edgeInsets.toJSON()}set padding(e){this._edgeInsets.equals(e)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,e,1),this._calcMatrices());}computeZoomRelativeTo(t){const i=this.rayIntersectionCoordinate(this.pointRayIntersection(this.centerPoint,t.toAltitude()));let o;o=t.z<this._camera.position[2]?[i.x,i.y,i.z]:[t.x,t.y,t.z];const s=e.ae(e.at([],this._camera.position,o));return e.ay(this._zoomFromMercatorZ(s),this._minZoom,this._maxZoom)}setFreeCameraOptions(t){if(!this.height)return;if(!t.position&&!t.orientation)return;this._updateCameraState();let i=!1;if(t.orientation&&!e.ch(t.orientation,this._camera.orientation)&&(i=this._setCameraOrientation(t.orientation)),t.position){const o=[t.position.x,t.position.y,t.position.z];e.ci(o,this._camera.position)||(this._setCameraPosition(o),i=!0);}i&&(this._updateStateFromCamera(),this.recenterOnTerrain());}getFreeCameraOptions(){this._updateCameraState();const t=this._camera.position,i=new $i;return i.position=new e.ac(t[0],t[1],t[2]),i.orientation=this._camera.orientation,i._elevation=this.elevation,i._renderWorldCopies=this.renderWorldCopies,i}_setCameraOrientation(t){if(!e.cj(t))return !1;e.ck(t,t);const i=e.cl([],[0,0,-1],t),o=e.cl([],[0,-1,0],t);if(o[2]<0)return !1;const s=Wi(i,o);return !!s&&(this._camera.orientation=s,!0)}_setCameraPosition(t){const i=this.zoomScale(this.minZoom)*this.tileSize,o=this.zoomScale(this.maxZoom)*this.tileSize,s=this.cameraToCenterDistance;t[2]=e.ay(t[2],s/o,s/i),this._camera.position=t;}get centerPoint(){return this._edgeInsets.getCenter(this.width,this.height)}get fovAboveCenter(){return this._fov*(.5+this.centerOffset.y/this.height)}isPaddingEqual(e){return this._edgeInsets.equals(e)}interpolatePadding(e,t,i){this._unmodified=!1,this._edgeInsets.interpolate(e,t,i),this._constrain(),this._calcMatrices();}coveringZoomLevel(e){const t=(e.roundZoom?Math.round:Math.floor)(this.zoom+this.scaleZoom(this.tileSize/e.tileSize));return Math.max(0,t)}getVisibleUnwrappedCoordinates(t){const i=[new e.cm(0,t)];if(this.renderWorldCopies){const o=this.pointCoordinate(new e.P(0,0)),s=this.pointCoordinate(new e.P(this.width,0)),r=this.pointCoordinate(new e.P(this.width,this.height)),n=this.pointCoordinate(new e.P(0,this.height)),a=Math.floor(Math.min(o.x,s.x,r.x,n.x)),l=Math.floor(Math.max(o.x,s.x,r.x,n.x)),c=1;for(let o=a-c;o<=l+c;o++)0!==o&&i.push(new e.cm(o,t));}return i}isLODDisabled(e){return (!e||this.pitch<=60)&&this._edgeInsets.top<=this._edgeInsets.bottom&&!this._elevation&&!this.projection.isReprojectedInTileSpace}extendTileCover(t,i,o){let s=[];const r=null!=o,n=!r;if(n&&this.zoom<i)return s;if(r&&0===o[0]&&0===o[1])return s;const a=new Set,l=(t,i,o,r,n)=>{const l=e.cK(i,t,o,r,n);a.has(l)||(s.push(new e.aM(t,i,o,r,n)),a.add(l));};for(let e=0;e<t.length;e++){const s=t[e];if(n&&s.canonical.z!==i)continue;const a=s.canonical,c=s.overscaledZ,h=s.wrap,d=1<<a.z,u=a.x+1<d,_=a.x>0,p=a.y+1<d,f=a.y>0,m=s.wrap-(_?0:1),g=s.wrap+(u?0:1),v=_?a.x-1:d-1,y=u?a.x+1:0;if(r)o[0]<0?(l(c,g,a.z,y,a.y),o[1]<0&&p&&(l(c,h,a.z,a.x,a.y+1),l(c,g,a.z,y,a.y+1)),o[1]>0&&f&&(l(c,h,a.z,a.x,a.y-1),l(c,g,a.z,y,a.y-1))):o[0]>0?(l(c,m,a.z,v,a.y),o[1]<0&&p&&(l(c,h,a.z,a.x,a.y+1),l(c,m,a.z,v,a.y+1)),o[1]>0&&f&&(l(c,h,a.z,a.x,a.y-1),l(c,m,a.z,v,a.y-1))):o[1]<0&&p?l(c,h,a.z,a.x,a.y+1):f&&l(c,h,a.z,a.x,a.y-1);else {const e=s.visibleQuadrants;1&e&&(l(c,m,a.z,v,a.y),f&&(l(c,h,a.z,a.x,a.y-1),l(c,m,a.z,v,a.y-1))),2&e&&(l(c,g,a.z,y,a.y),f&&(l(c,h,a.z,a.x,a.y-1),l(c,g,a.z,y,a.y-1))),4&e&&(l(c,m,a.z,v,a.y),p&&(l(c,h,a.z,a.x,a.y+1),l(c,m,a.z,v,a.y+1))),8&e&&(l(c,g,a.z,y,a.y),p&&(l(c,h,a.z,a.x,a.y+1),l(c,g,a.z,y,a.y+1)));}}const c=[];for(const e of s)s.some((t=>e.isChildOf(t)))||c.push(e);if(s=c.filter((e=>!t.some((t=>!!(e.overscaledZ<i&&t.isChildOf(e))||e.equals(t)||e.isChildOf(t))))),n){const e=1<<i,t="globe"===this.projection.name?this._camera.mercatorPosition:this.pointCoordinate(this.getCameraPoint()),o=[e*t.x,e*t.y],r=4,n=r*r;s=s.filter((e=>{const t=e.canonical.x+.5-o[0],i=e.canonical.y+.5-o[1];return t*t+i*i<n}));}return s}coveringTiles(t){let i=this.coveringZoomLevel(t);const o=i,s=this.elevation&&this.elevation.exaggeration(),r=s&&!t.isTerrainDEM,n="mercator"===this.projection.name;if(void 0!==t.minzoom&&i<t.minzoom)return [];void 0!==t.maxzoom&&i>t.maxzoom&&(i=t.maxzoom);const a=this.locationCoordinate(this.center),l=this.center.lat,c=1<<i,h=[c*a.x,c*a.y,0],d="globe"===this.projection.name,u=!d,_=e.cn.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,i,u),p=d?this._camera.mercatorPosition:this.pointCoordinate(this.getCameraPoint()),f=c*e.c6(1,this.center.lat),m=this._camera.position[2]/e.c6(1,this.center.lat),g=[c*p.x,c*p.y,m*(u?1:f)],v=d||s,y=this.cameraToCenterDistance/t.tileSize*(t.roundZoom?1:.502),x=this.isLODDisabled(!0)?i:0;let b;if(this._elevation&&t.isTerrainDEM)b=1e4*this._elevation.exaggeration();else if(this._elevation){const e=this._elevation.getMinMaxForVisibleTiles();b=e?e.max:this._centerAltitude;}else b=this._centerAltitude;const w=t.isTerrainDEM?-b:this._elevation?this._elevation.getMinElevationBelowMSL():0,T=this.projection.isReprojectedInTileSpace?e.co(this):1,E=t=>{const i=1/4e4,o=new e.ac(t.x+i,t.y,t.z),s=new e.ac(t.x,t.y+i,t.z),r=t.toLngLat(),n=o.toLngLat(),a=s.toLngLat(),l=this.locationCoordinate(r),c=this.locationCoordinate(n),h=this.locationCoordinate(a),d=Math.hypot(c.x-l.x,c.y-l.y),u=Math.hypot(h.x-l.x,h.y-l.y);return Math.sqrt(d*u)*T/i},S=t=>{const i=b,o=w;return {aabb:e.cr(this,c,0,0,0,t,o,i,this.projection),zoom:0,x:0,y:0,minZ:o,maxZ:i,wrap:t,fullyVisible:!1}},I=[];let C=[];const R=i,D=t.reparseOverscaled?o:i,A=(m-this._centerAltitude)*f,L=e=>{if(!this._elevation||!e.tileID||!n)return;const t=this._elevation.getMinMaxForTile(e.tileID),i=e.aabb;t?(i.min[2]=t.min,i.max[2]=t.max,i.center[2]=(i.min[2]+i.max[2])/2):(e.shouldSplit=z(e),e.shouldSplit||(i.min[2]=i.max[2]=i.center[2]=this._centerAltitude));},P=(e,t)=>{if(.707*t<e)return 1;const i=t/e;return i/(1.4144271570014144+(Math.pow(1.1,i-1.4144271570014144+1)-1)/(1.1-1)-1)},z=t=>{if(t.zoom<x)return !0;if(t.zoom===R)return !1;if(null!=t.shouldSplit)return t.shouldSplit;const i=t.aabb.distanceX(g),s=t.aabb.distanceY(g);let a=A,c=1;if(d){a=t.aabb.distanceZ(g);const i=Math.pow(2,t.zoom),o=e.aY((t.y+1)/i),s=e.aY(t.y/i),r=Math.min(Math.max(l,o),s),n=e.cO(r)/e.cO(l);if(c=r===l?1/Math.max(1,this._mercatorScaleRatio-.3):Math.min(1,n/this._mercatorScaleRatio),this.zoom<=e.cL&&t.zoom===R-1&&n>=.9)return !0}else if(r&&(a=t.aabb.distanceZ(g)*f),this.projection.isReprojectedInTileSpace&&o<=5){const i=Math.pow(2,t.zoom),o=E(new e.ac((t.x+.5)/i,(t.y+.5)/i));c=o>.85?1:o;}if(!n){const e=Math.sqrt(i*i+s*s+a*a);let o=(1<<R-t.zoom)*y*c;return o*=P(Math.max(a,A),e),e<o}let u=Number.MAX_VALUE,_=0;const p=t.aabb.getCorners(),m=[];for(const t of p){e.at(m,t,g),d||(r?m[2]*=f:m[2]=A);const i=e.bG(m,this._camera.forward());i<u&&(u=i,_=Math.abs(m[2]));}let v=(1<<R-t.zoom)*y*c;if(v*=P(Math.max(_,A),u),u<v)return !0;const b=t.aabb.closestPoint(h);return b[0]===h[0]&&b[1]===h[1]};if(this.renderWorldCopies)for(let e=1;e<=3;e++)I.push(S(-e)),I.push(S(e));for(I.push(S(0));I.length>0;){const o=I.pop(),s=o.x,a=o.y;let l=o.fullyVisible;const u=()=>"globe"===this.projection.name&&(0===o.y||o.y===(1<<o.zoom)-1);if(!l){let t=v?o.aabb.intersects(_):o.aabb.intersectsFlat(_);if(0===t&&u()){const i=new e.cp(o.zoom,s,a);t=e.cq(this,c,i,!0).intersects(_);}if(0===t)continue;l=2===t;}if(o.zoom!==R&&z(o))for(let t=0;t<4;t++){const i=(s<<1)+t%2,h=(a<<1)+(t>>1),u={aabb:n?o.aabb.quadrant(t):e.cr(this,c,o.zoom+1,i,h,o.wrap,o.minZ,o.maxZ,this.projection),zoom:o.zoom+1,x:i,y:h,wrap:o.wrap,fullyVisible:l,tileID:void 0,shouldSplit:void 0,minZ:o.minZ,maxZ:o.maxZ};r&&!d&&(u.tileID=new e.aM(o.zoom+1===R?D:o.zoom+1,o.wrap,o.zoom+1,i,h),L(u)),I.push(u);}else {const r=o.zoom===R?D:o.zoom;if(t.minzoom&&t.minzoom>r)continue;let n=0;if(!l){let i=v?o.aabb.intersectsPrecise(_):o.aabb.intersectsPreciseFlat(_);if(0===i&&u()){const t=new e.cp(o.zoom,s,a);i=e.cq(this,c,t,!0).intersectsPrecise(_);}if(0===i)continue;if(t.calculateQuadrantVisibility)if(_.containsPoint(o.aabb.center))n=15;else for(let e=0;e<4;e++)0!==o.aabb.quadrant(e).intersects(_)&&(n|=1<<e);}const d=h[0]-(.5+s+(o.wrap<<o.zoom))*(1<<i-o.zoom),p=h[1]-.5-a,f=o.tileID?o.tileID:new e.aM(r,o.wrap,o.zoom,s,a);t.calculateQuadrantVisibility&&(f.visibleQuadrants=n),C.push({tileID:f,distanceSq:d*d+p*p});}}if(this.fogCullDistSq){const i=this.fogCullDistSq,o=this.horizonLineFromTop();C=C.filter((s=>{const r=[0,0,0,1],n=[e.aj,e.aj,0,1],a=this.calculateFogTileMatrix(s.tileID.toUnwrapped());e.aA(r,r,a),e.aA(n,n,a);const l=e.cs([],r,n),c=e.ct([],r,n),h=e.cM(l,c);if(0===h)return !0;let d=!1;const u=this._elevation;if(u&&h>i&&0!==o){const i=this.calculateProjMatrix(s.tileID.toUnwrapped());let r;t.isTerrainDEM||(r=u.getMinMaxForTile(s.tileID)),r||(r={min:w,max:b});const n=e.cu(this.rotation),a=[n[0]*e.aj,n[1]*e.aj,r.max];e.ad(a,a,i),d=(1-a[1])*this.height*.5<o;}return h<i||d}));}return C.sort(((e,t)=>e.distanceSq-t.distanceSq)).map((e=>e.tileID))}resize(e,t){this.width=e,this.height=t,this.pixelsToGLUnits=[2/e,-2/t],this._constrain(),this._calcMatrices();}get unmodified(){return this._unmodified}zoomScale(e){return Math.pow(2,e)}scaleZoom(e){return Math.log(e)/Math.LN2}project(t){const i=e.ay(t.lat,-85.051129,e.cv),o=this.projection.project(t.lng,i);return new e.P(o.x*this.worldSize,o.y*this.worldSize)}unproject(e){return this.projection.unproject(e.x/this.worldSize,e.y/this.worldSize)}get point(){return this.project(this.center)}get pointMerc(){return this.point._div(this.worldSize)}get pixelsPerMeterRatio(){return this.pixelsPerMeter/e.c6(1,this.center.lat)/this.worldSize}setLocationAtPoint(t,i){let o,s;const r=this.centerPoint;if("globe"===this.projection.name){const e=this.worldSize;o=(i.x-r.x)/e,s=(i.y-r.y)/e;}else {const e=this.pointCoordinate(i),t=this.pointCoordinate(r);o=e.x-t.x,s=e.y-t.y;}const n=this.locationCoordinate(t);this.setLocation(new e.ac(n.x-o,n.y-s));}setLocation(e){this.center=this.coordinateLocation(e),this.projection.wrap&&(this.center=this.center.wrap());}locationPoint(e,t){return this.projection.locationPoint(this,e,t)}locationPoint3D(e,t){return this.projection.locationPoint(this,e,t,!0)}pointLocation(e){return this.coordinateLocation(this.pointCoordinate(e))}pointLocation3D(e,t){return this.coordinateLocation(this.pointCoordinate3D(e,t))}locationCoordinate(t,i){const o=i?e.c6(i,t.lat):void 0,s=this.projection.project(t.lng,t.lat);return new e.ac(s.x,s.y,o)}coordinateLocation(e){return this.projection.unproject(e.x,e.y)}pointRayIntersection(t,i){const o=null!=i?i:this._centerAltitude,s=[t.x,t.y,0,1],r=[t.x,t.y,1,1];e.aA(s,s,this.pixelMatrixInverse),e.aA(r,r,this.pixelMatrixInverse);const n=r[3];e.cw(s,s,1/s[3]),e.cw(r,r,1/n);const a=s[2],l=r[2];return {p0:s,p1:r,t:a===l?0:(o-a)/(l-a)}}screenPointToMercatorRay(t){const i=[t.x,t.y,0,1],o=[t.x,t.y,1,1];return e.aA(i,i,this.pixelMatrixInverse),e.aA(o,o,this.pixelMatrixInverse),e.cw(i,i,1/i[3]),e.cw(o,o,1/o[3]),i[2]=e.c6(i[2],this._center.lat)*this.worldSize,o[2]=e.c6(o[2],this._center.lat)*this.worldSize,e.cw(i,i,1/this.worldSize),e.cw(o,o,1/this.worldSize),new e.av([i[0],i[1],i[2]],e.au([],e.at([],o,i)))}rayIntersectionCoordinate(t){const{p0:i,p1:o,t:s}=t,r=e.c6(i[2],this._center.lat),n=e.c6(o[2],this._center.lat);return new e.ac(e.ai(i[0],o[0],s)/this.worldSize,e.ai(i[1],o[1],s)/this.worldSize,e.ai(r,n,s))}pointCoordinate(e,t=this._centerAltitude){return this.projection.pointCoordinate(this,e.x,e.y,t)}pointCoordinate3D(t,i){if(!this.elevation)return this.pointCoordinate(t,i);let o=this.projection.pointCoordinate3D(this,t.x,t.y);if(o)return new e.ac(o[0],o[1],o[2]);let s=0,r=this.horizonLineFromTop();if(t.y>r)return this.pointCoordinate(t,i);const n=.02*r,a=t.clone();for(let t=0;t<10&&r-s>n;t++){a.y=e.ai(s,r,.66);const t=this.projection.pointCoordinate3D(this,a.x,a.y);t?(r=a.y,o=t):s=a.y;}return o?new e.ac(o[0],o[1],o[2]):this.pointCoordinate(t)}isPointAboveHorizon(e){return this.projection.isPointAboveHorizon(this,e)}isPointOnSurface(t){if(t.y<0||t.y>this.height||t.x<0||t.x>this.width)return !1;if(this.elevation||this.zoom>=e.cx)return !this.isPointAboveHorizon(t);const i=this.pointCoordinate(t);return i.y>=0&&i.y<=1}_coordinatePoint(t,i){const o=i&&this.elevation?this.elevation.getAtPointOrZero(t,this._centerAltitude):this._centerAltitude,s=[t.x*this.worldSize,t.y*this.worldSize,o+t.toAltitude(),1];return e.aA(s,s,this.pixelMatrix),s[3]>0?new e.P(s[0]/s[3],s[1]/s[3]):new e.P(Number.MAX_VALUE,Number.MAX_VALUE)}_getBoundsNonRectangular(){const{top:t,left:i}=this._edgeInsets,o=this.height-this._edgeInsets.bottom,s=this.width-this._edgeInsets.right,r=this.pointLocation3D(new e.P(i,t)),n=this.pointLocation3D(new e.P(s,t)),a=this.pointLocation3D(new e.P(s,o)),l=this.pointLocation3D(new e.P(i,o));let c=Math.min(r.lng,n.lng,a.lng,l.lng),h=Math.max(r.lng,n.lng,a.lng,l.lng),d=Math.min(r.lat,n.lat,a.lat,l.lat),u=Math.max(r.lat,n.lat,a.lat,l.lat);const _=Math.pow(2,-this.zoom)/16*270,p="globe"===this.projection.name?1:4,f=(t,i,o,s,r)=>{const n=(t+o)/2,a=(i+s)/2,l=new e.P(n,a),{lng:m,lat:g}=this.pointLocation3D(l),v=Math.max(0,c-m,d-g,m-h,g-u);c=Math.min(c,m),h=Math.max(h,m),d=Math.min(d,g),u=Math.max(u,g),(r<p||v>_)&&(f(t,i,n,a,r+1),f(n,a,o,s,r+1));};if(f(i,t,s,t,1),f(s,t,s,o,1),f(s,o,i,o,1),f(i,o,i,t,1),"globe"===this.projection.name){const[t,i]=e.cy(this);t?(u=90,h=180,c=-180):i&&(d=-90,h=180,c=-180);}return new e.aG(new e.cd(c,d),new e.cd(h,u))}_getBoundsRectangular(t,i){const{top:o,left:s}=this._edgeInsets,r=this.height-this._edgeInsets.bottom,n=this.width-this._edgeInsets.right,a=new e.P(s,o),l=new e.P(n,o),c=new e.P(n,r),h=new e.P(s,r);let d=this.pointCoordinate(a,t),u=this.pointCoordinate(l,t);const _=this.pointCoordinate(c,i),p=this.pointCoordinate(h,i),f=(e,t)=>(t.y-e.y)/(t.x-e.x);return d.y>1&&u.y>=0?d=new e.ac((1-p.y)/f(p,d)+p.x,1):d.y<0&&u.y<=1&&(d=new e.ac(-p.y/f(p,d)+p.x,0)),u.y>1&&d.y>=0?u=new e.ac((1-_.y)/f(_,u)+_.x,1):u.y<0&&d.y<=1&&(u=new e.ac(-_.y/f(_,u)+_.x,0)),(new e.aG).extend(this.coordinateLocation(d)).extend(this.coordinateLocation(u)).extend(this.coordinateLocation(p)).extend(this.coordinateLocation(_))}_getBoundsRectangularTerrain(){const e=this.elevation;if(!e.visibleDemTiles.length||e.isUsingMockSource())return this._getBoundsRectangular(0,0);const t=e.visibleDemTiles.reduce(((e,t)=>{if(t.dem){const i=t.dem.tree;e.min=Math.min(e.min,i.minimums[0]),e.max=Math.max(e.max,i.maximums[0]);}return e}),{min:Number.MAX_VALUE,max:0});return this._getBoundsRectangular(t.min*e.exaggeration(),t.max*e.exaggeration())}getBounds(){return "mercator"===this.projection.name||"equirectangular"===this.projection.name?this._terrainEnabled()?this._getBoundsRectangularTerrain():this._getBoundsRectangular(0,0):this._getBoundsNonRectangular()}horizonLineFromTop(e=!0){const t=this.height/2/Math.tan(this._fov/2)/Math.tan(Math.max(this._pitch,.1))-this.centerOffset.y,i=this.height/2-t*(1-this._horizonShift);return e?Math.max(0,i):i}getMaxBounds(){return this.maxBounds}setMaxBounds(t){this.maxBounds=t,this.minLat=-85.051129,this.maxLat=e.cv,this.minLng=-180,this.maxLng=180,t&&(this.minLat=t.getSouth(),this.maxLat=t.getNorth(),this.minLng=t.getWest(),this.maxLng=t.getEast(),this.maxLng<this.minLng&&(this.maxLng+=360)),this.worldMinX=e.aD(this.minLng)*this.tileSize,this.worldMaxX=e.aD(this.maxLng)*this.tileSize,this.worldMinY=e.aH(this.maxLat)*this.tileSize,this.worldMaxY=e.aH(this.minLat)*this.tileSize,this._constrain();}calculatePosMatrix(e,t){return this.projection.createTileMatrix(this,t,e)}calculateDistanceTileData(t){const i=t.key,o=this._distanceTileDataCache;if(o[i])return o[i];const s=t.canonical,r=1/this.height,n=this.cameraWorldSize,a=n/this.zoomScale(s.z),l=(s.x+Math.pow(2,s.z)*t.wrap)*a,c=s.y*a,h=this.point;h.x*=n/this.worldSize,h.y*=n/this.worldSize;const d=this.angle,u=Math.sin(-d),_=-Math.cos(-d);return o[i]={bearing:[u,_],center:[(h.x-l)*r,(h.y-c)*r],scale:a/e.aj*r},o[i]}calculateFogTileMatrix(t){const i=t.key,o=this._fogTileMatrixCache;if(o[i])return o[i];const s=this.projection.createTileMatrix(this,this.cameraWorldSizeForFog,t);return e.az(s,this.worldToFogMatrix,s),o[i]=new Float32Array(s),o[i]}calculateProjMatrix(t,i=!1,o=!1){const s=t.key;let r;if(r=o?this._expandedProjMatrixCache:i?this._alignedProjMatrixCache:this._projMatrixCache,r[s])return r[s];const n=this.calculatePosMatrix(t,this.worldSize);let a;return a=this.projection.isReprojectedInTileSpace?this.mercatorMatrix:o?this.expandedFarZProjMatrix:i?this.alignedProjMatrix:this.projMatrix,e.az(n,a,n),r[s]=new Float32Array(n),r[s]}calculatePixelsToTileUnitsMatrix(t){const i=t.tileID.key,o=this._pixelsToTileUnitsCache;if(o[i])return o[i];const s=e.cz(t,this);return o[i]=s,o[i]}customLayerMatrix(){return this.mercatorMatrix.slice()}globeToMercatorMatrix(){if("globe"===this.projection.name){const t=1/this.worldSize,i=e.bn([],[t,t,t]);return e.az(i,i,this.globeMatrix),i}}recenterOnTerrain(){if(!this._elevation||"globe"===this.projection.name)return;const t=this._elevation;this._updateCameraState();const i=e.c6(1,this._center.lat)*this.worldSize,o=this._computeCameraPosition(i),s=this._camera.forward(),r=e.c6(1,this._center.lat);o[2]/=r,s[2]/=r,e.au(s,s);const n=t.raycast(o,s,t.exaggeration());if(n){const t=e.bE([],o,s,n),i=new e.ac(t[0],t[1],e.c6(t[2],e.aY(t[1]))),a=(i.z+e.ae([i.x-o[0],i.y-o[1],i.z-o[2]*r]))*this._pixelsPerMercatorPixel;this._seaLevelZoom=this._zoomFromMercatorZ(a),this._centerAltitude=i.toAltitude(),this._center=this.coordinateLocation(i),this._updateZoomFromElevation(),this._constrain(),this._calcMatrices();}}_constrainCamera(t=!1){if(!this._elevation)return;const i=this._elevation,o=e.c6(1,this._center.lat)*this.worldSize,s=this._computeCameraPosition(o),r=i.getAtPointOrZero(new e.ac(...s)),n=this.pixelsPerMeter/this.worldSize*r,a=this._minimumHeightOverTerrain(),l=s[2]-n;if(l<=a)if(l<0||t){const t=this.locationCoordinate(this._center,this._centerAltitude),i=[s[0],s[1],t.z-s[2]],o=e.ae(i);i[2]-=(a-l)/this._pixelsPerMercatorPixel;const r=e.ae(i);if(0===r)return;e.bY(i,i,o/r*this._pixelsPerMercatorPixel),this._camera.position=[s[0],s[1],t.z*this._pixelsPerMercatorPixel-i[2]],this._updateStateFromCamera();}else this._isCameraConstrained=!0;}_constrain(){if(!this.center||!this.width||!this.height||this._constraining)return;this._constraining=!0;const t="globe"===this.projection.name||this.mercatorFromTransition;if(this.projection.isReprojectedInTileSpace||t){const i=this.center;return i.lat=e.ay(i.lat,this.minLat,this.maxLat),(this.maxBounds||!this.renderWorldCopies&&!t)&&(i.lng=e.ay(i.lng,this.minLng,this.maxLng)),this.center=i,void(this._constraining=!1)}const i=this._unmodified,{x:o,y:s}=this.point;let r=0,n=o,a=s;const l=this.width/2,c=this.height/2,h=this.worldMinY*this.scale,d=this.worldMaxY*this.scale;if(s-c<h&&(a=h+c),s+c>d&&(a=d-c),d-h<this.height&&(r=Math.max(r,this.height/(d-h)),a=(d+h)/2),this.maxBounds||!this._renderWorldCopies||!this.projection.wrap){const e=this.worldMinX*this.scale,t=this.worldMaxX*this.scale,i=this.worldSize/2-(e+t)/2;n=(o+i+this.worldSize)%this.worldSize-i,n-l<e&&(n=e+l),n+l>t&&(n=t-l),t-e<this.width&&(r=Math.max(r,this.width/(t-e)),n=(t+e)/2);}n===o&&a===s||this._allowWorldUnderZoom||(this.center=this.unproject(new e.P(n,a))),r&&!this._allowWorldUnderZoom&&(this.zoom+=this.scaleZoom(r)),this._constrainCamera(),this._unmodified=i,this._constraining=!1;}_minZoomForBounds(){let e=Math.max(0,this.scaleZoom(Math.max(0,this.height)/(this.worldMaxY-this.worldMinY)));return this.maxBounds&&(e=Math.max(e,this.scaleZoom(this.width/(this.worldMaxX-this.worldMinX)))),e}_maxCameraBoundsDistance(){return this._mercatorZfromZoom(this._minZoomForBounds())}_calcMatrices(){if(!this.height)return;const t=this.centerOffset,i="globe"===this.projection.name,o=this.pixelsPerMeter;"globe"===this.projection.name&&(this._mercatorScaleRatio=e.c6(1,this.center.lat)/e.c6(1,e.cP));const s=e.cA(this.projection,this.zoom,this.width,this.height,1024);this._pixelsPerMercatorPixel=this.projection.pixelSpaceConversion(this.center.lat,this.worldSize,s),this.cameraToCenterDistance=.5/Math.tan(.5*this._fov)*this.height*this._pixelsPerMercatorPixel,this._updateCameraState(),this._farZ=this.projection.farthestPixelDistance(this),this._nearZ=this.height/50;const r="meters"===this.projection.zAxisUnit?o:1,n=this._camera.getWorldToCamera(this.worldSize,r);let a;const l=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,this._nearZ,this._farZ);if(l[8]=2*-t.x/this.width,l[9]=2*t.y/this.height,this.isOrthographic){let i=.5*this.height/Math.tan(this._fov/2)*1*Math.tan(.5*this._fov),o=i*this.aspect,s=-o,r=-i;o-=t.x,s-=t.x,i+=t.y,r+=t.y,a=this._camera.getCameraToClipOrthographic(s,o,r,i,this._nearZ,this._farZ),((t,i,o,s)=>{for(let r=0;r<16;r++)t[r]=e.ai(i[r],o[r],s);})(a,a,l,e.cN(this.pitch>=Ji?1:this.pitch/Ji));}else a=l;const c=e.cB([],l,n);let h=e.cB([],a,n);if(this.projection.isReprojectedInTileSpace){const t=this.locationCoordinate(this.center),i=e.bx([]);e.bo(i,i,[t.x*this.worldSize,t.y*this.worldSize,0]),e.az(i,i,e.cC(this)),e.bo(i,i,[-t.x*this.worldSize,-t.y*this.worldSize,0]),e.az(h,h,i),e.az(c,c,i),this.inverseAdjustmentMatrix=e.cD(this);}else this.inverseAdjustmentMatrix=[1,0,0,1];if(this.mercatorMatrix=e.cE([],h,[this.worldSize,this.worldSize,this.worldSize/r,1]),this.projMatrix=h,this.invProjMatrix=e.bi(new Float64Array(16),this.projMatrix),i){const i=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,this._nearZ,1/0);i[8]=2*-t.x/this.width,i[9]=2*t.y/this.height,this.expandedFarZProjMatrix=e.cB([],i,n);}else this.expandedFarZProjMatrix=this.projMatrix;const d=e.bi([],a);this.frustumCorners=e.cF.fromInvProjectionMatrix(d,this.horizonLineFromTop(),this.height),this.cameraFrustum=e.cn.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,0,!i);const u=new Float32Array(16);e.bx(u),e.cE(u,u,[1,-1,1]),e.cG(u,u,this._pitch),e.by(u,u,this.angle);const _=e.c4(new Float32Array(16),this._fov,this.width/this.height,this._nearZ,this._farZ);this.starsProjMatrix=e.bw(_);const p=(Math.PI/2-this._pitch)*(this.height/this._fov)*this._horizonShift;_[8]=2*-t.x/this.width,_[9]=2*(t.y+p)/this.height,this.skyboxMatrix=e.az(u,_,u);const f=this.point,m=f.x,g=f.y,v=this.width%2/2,y=this.height%2/2,x=Math.cos(this.angle),b=Math.sin(this.angle),w=m-Math.round(m)+x*v+b*y,T=g-Math.round(g)+x*y+b*v,E=new Float64Array(h);if(e.bo(E,E,[w>.5?w-1:w,T>.5?T-1:T,0]),this.alignedProjMatrix=E,h=e.bz(),e.cE(h,h,[this.width/2,-this.height/2,1]),e.bo(h,h,[1,-1,0]),this.labelPlaneMatrix=h,h=e.bz(),e.cE(h,h,[1,-1,1]),e.bo(h,h,[-1,-1,0]),e.cE(h,h,[2/this.width,2/this.height,1]),this.glCoordMatrix=h,this.pixelMatrix=e.az(new Float64Array(16),this.labelPlaneMatrix,c),this._calcFogMatrices(),this._distanceTileDataCache={},h=e.bi(new Float64Array(16),this.pixelMatrix),!h)throw new Error("failed to invert matrix");if(this.pixelMatrixInverse=h,"globe"===this.projection.name||this.mercatorFromTransition){this.globeMatrix=e.cH(this);const t=[this.globeMatrix[12],this.globeMatrix[13],this.globeMatrix[14]];this.globeCenterInViewSpace=e.ad(t,t,n),this.globeRadius=this.worldSize/2/Math.PI-1;}else this.globeMatrix=h;this._projMatrixCache={},this._alignedProjMatrixCache={},this._pixelsToTileUnitsCache={},this._expandedProjMatrixCache={};}_calcFogMatrices(){this._fogTileMatrixCache={};const t=this.cameraWorldSizeForFog,i=this.cameraPixelsPerMeter,o=this._camera.position,s=1/this.height/this._pixelsPerMercatorPixel,r=[t,t,i];e.bY(r,r,s),e.bY(o,o,-1),e.cI(o,o,r);const n=e.bz();e.bo(n,n,o),e.cE(n,n,r),this.mercatorFogMatrix=n,this.worldToFogMatrix=this._camera.getWorldToCameraPosition(t,i,s);}_computeCameraPosition(e){const t=(e=e||this.pixelsPerMeter)/this.pixelsPerMeter,i=this._camera.forward(),o=this.point,s=this._mercatorZfromZoom(this._seaLevelZoom?this._seaLevelZoom:this._zoom)*t-e/this.worldSize*this._centerAltitude;return [o.x/this.worldSize-i[0]*s,o.y/this.worldSize-i[1]*s,e/this.worldSize*this._centerAltitude-i[2]*s]}_updateCameraState(){this.height&&(this._camera.setPitchBearing(this._pitch,this.angle),this._camera.position=this._computeCameraPosition());}_translateCameraConstrained(t){const i=this._maxCameraBoundsDistance()*Math.cos(this._pitch),o=this._camera.position[2],s=t[2];let r=1;this.projection.wrap&&(this.center=this.center.wrap()),s>0&&(r=Math.min((i-o)/s,1)),this._camera.position=e.bE([],this._camera.position,t,r),this._updateStateFromCamera();}_updateStateFromCamera(){const t=this._camera.position,i=this._camera.forward(),{pitch:o,bearing:s}=this._camera.getPitchBearing(),r=e.c6(this._centerAltitude,this.center.lat)*this._pixelsPerMercatorPixel,n=this._mercatorZfromZoom(this._maxZoom)*Math.cos(e.al(this._maxPitch)),a=Math.max((t[2]-r)/Math.cos(o),n),l=this._zoomFromMercatorZ(a);e.bE(t,t,i,a),this._pitch=e.ay(o,e.al(this.minPitch),e.al(this.maxPitch)),this.angle=e.bX(s,-Math.PI,Math.PI),this._setZoom(e.ay(l,this._minZoom,this._maxZoom)),this._updateSeaLevelZoom(),this._center=this.coordinateLocation(new e.ac(t[0],t[1],t[2])),this._unmodified=!1,this._constrain(),this._calcMatrices();}_worldSizeFromZoom(e){return Math.pow(2,e)*this.tileSize}_mercatorZfromZoom(e){return this.cameraToCenterDistance/this._worldSizeFromZoom(e)}_minimumHeightOverTerrain(){const e=Math.min(null!=this._seaLevelZoom?this._seaLevelZoom:this._zoom,this._maxZoom)+4;return this._mercatorZfromZoom(e)}_zoomFromMercatorZ(e){return this.scaleZoom(this.cameraToCenterDistance/(Math.max(0,e)*this.tileSize))}zoomFromMercatorZAdjusted(t){let i=0,o=e.cx,s=0,r=1/0;for(;o-i>1e-6&&o>i;){const e=i+.5*(o-i),n=this.tileSize*Math.pow(2,e),a=this.getCameraToCenterDistance(this.projection,e,n),l=this.scaleZoom(a/(Math.max(0,t)*this.tileSize)),c=Math.abs(e-l);c<r&&(r=c,s=e),e<l?i=e:o=e;}return s}_terrainEnabled(){return !(!this._elevation||!this.projection.supportsTerrain&&(e.w("Terrain is not yet supported with alternate projections. Use mercator or globe to enable terrain."),1))}anyCornerOffEdge(t,i){const o=Math.min(t.x,i.x),s=Math.max(t.x,i.x),r=Math.min(t.y,i.y),n=Math.max(t.y,i.y);if(r<this.horizonLineFromTop(!1))return !0;if("mercator"!==this.projection.name)return !1;const a=[new e.P(o,r),new e.P(s,n),new e.P(o,n),new e.P(s,r)],l=this.renderWorldCopies?-3:0,c=this.renderWorldCopies?4:1;for(const e of a){const t=this.pointRayIntersection(e);if(t.t<0)return !0;const i=this.rayIntersectionCoordinate(t);if(i.x<l||i.y<0||i.x>c||i.y>1)return !0}return !1}isHorizonVisible(){return this.pitch+e.cJ(this.fovAboveCenter)>88||this.anyCornerOffEdge(new e.P(0,0),new e.P(this.width,this.height))}zoomDeltaToMovement(t,i){const o=e.ae(e.at([],this._camera.position,t)),s=this._zoomFromMercatorZ(o)+i;return o-this._mercatorZfromZoom(s)}getCameraPoint(){if("globe"===this.projection.name){const t=function([t,i,o],s){const r=[t,i,o,1];e.aA(r,r,s);const n=r[3]=Math.max(r[3],1e-6);return r[0]/=n,r[1]/=n,r[2]/=n,r}([this.globeMatrix[12],this.globeMatrix[13],this.globeMatrix[14]],this.pixelMatrix);return new e.P(t[0],t[1])}{const t=Math.tan(this._pitch)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new e.P(0,t))}}getCameraToCenterDistance(t,i=this.zoom,o=this.worldSize){const s=e.cA(t,i,this.width,this.height,1024),r=t.pixelSpaceConversion(this.center.lat,o,s);let n=.5/Math.tan(.5*this._fov)*this.height*r;return this.isOrthographic&&(n=e.ai(1,n,e.cN(this.pitch>=Ji?1:this.pitch/Ji))),n}getWorldToCameraMatrix(){const t=this._camera.getWorldToCamera(this.worldSize,"meters"===this.projection.zAxisUnit?this.pixelsPerMeter:1);return "globe"===this.projection.name&&e.az(t,t,this.globeMatrix),t}getFrustum(t){return e.cn.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,t,"meters"===this.projection.zAxisUnit)}}const eo=(t,i)=>{if(i>0&&t.terrain&&e.w("Cutoff is currently disabled on terrain"),i<=0||t.terrain)return {shouldRenderCutoff:!1,uniformValues:{u_cutoff_params:[0,0,0,1]}};const o=t.transform,s=Math.max(Math.abs(o._zoom-(t.minCutoffZoom-1)),1),r=o.isLODDisabled(!1)?e.af(60,45,o.pitch):e.af(30,15,o.pitch),n=o._farZ-o._nearZ,a=i*o.height,l=((1-(c=r))*o.cameraToCenterDistance+c*(o._farZ+a))*s;var c;return {shouldRenderCutoff:r<1,uniformValues:{u_cutoff_params:[o._nearZ,o._farZ,(l-o._nearZ)/n,(l-a-o._nearZ)/n]}}},to={cascadeCount:2,normalOffset:3,shadowMapResolution:2048};class io{constructor(e,t){this.aabb=e,this.lastCascade=t;}}class oo{add(e,t){const i=this.receivers[e.key];void 0!==i?(i.aabb.min[0]=Math.min(i.aabb.min[0],t.min[0]),i.aabb.min[1]=Math.min(i.aabb.min[1],t.min[1]),i.aabb.min[2]=Math.min(i.aabb.min[2],t.min[2]),i.aabb.max[0]=Math.max(i.aabb.max[0],t.max[0]),i.aabb.max[1]=Math.max(i.aabb.max[1],t.max[1]),i.aabb.max[2]=Math.max(i.aabb.max[2],t.max[2])):this.receivers[e.key]=new io(t,null);}clear(){this.receivers={};}get(e){return this.receivers[e.key]}computeRequiredCascades(t,i,o){const s=e.cW.fromPoints(t.points);let r=0;for(const t in this.receivers){const n=this.receivers[t];if(!n)continue;if(!s.intersectsAabb(n.aabb))continue;n.aabb.min=s.closestPoint(n.aabb.min),n.aabb.max=s.closestPoint(n.aabb.max);const a=n.aabb.getCorners();for(let t=0;t<o.length;t++){let s=!0;for(const r of a){const n=[r[0]*i,r[1]*i,r[2]];if(e.ad(n,n,o[t].matrix),n[0]<-1||n[0]>1||n[1]<-1||n[1]>1){s=!1;break}}if(n.lastCascade=t,r=Math.max(r,t),s)break}}return r+1}}class so{constructor(e){this.painter=e,this._enabled=!1,this._shadowLayerCount=0,this._numCascadesToRender=0,this._cascades=[],this._groundShadowTiles=[],this._receivers=new oo,this._depthMode=new Ni(e.context.gl.LEQUAL,Ni.ReadWrite,[0,1]),this._uniformValues={u_light_matrix_0:new Float32Array(16),u_light_matrix_1:new Float32Array(16),u_shadow_intensity:0,u_fade_range:[0,0],u_shadow_normal_offset:[1,1,1],u_shadow_texel_size:1,u_shadow_map_resolution:1,u_shadow_direction:[0,0,1],u_shadow_bias:[36e-5,.0012,.012],u_shadowmap_0:0,u_shadowmap_1:0},this._forceDisable=!1,this.useNormalOffset=!1,e.tp.registerParameter(this,["Shadows"],"_forceDisable",{label:"forceDisable"},(()=>{this.painter.style.map.triggerRepaint();})),e.tp.registerParameter(to,["Shadows"],"cascadeCount",{min:1,max:2,step:1}),e.tp.registerParameter(to,["Shadows"],"normalOffset",{min:0,max:10,step:.05}),e.tp.registerParameter(to,["Shadows"],"shadowMapResolution",{min:32,max:2048,step:32}),e.tp.registerBinding(this,["Shadows"],"_numCascadesToRender",{readonly:!0,label:"numCascadesToRender"});}destroy(){for(const e of this._cascades)e.texture.destroy(),e.framebuffer.destroy();this._cascades=[];}updateShadowParameters(t,i){const o=this.painter;if(this._enabled=!1,this._shadowLayerCount=0,this._receivers.clear(),!i||!i.properties)return;const s=i.properties.get("shadow-intensity");if(!i.shadowsEnabled()||s<=0)return;if(this._shadowLayerCount=o.style.order.reduce(((e,i)=>{const s=o.style._mergedLayers[i];return e+(s.hasShadowPass()&&!s.isHidden(t.zoom)?1:0)}),0),this._enabled=this._shadowLayerCount>0,!this.enabled)return;const r=o.context,n=to.shadowMapResolution,a=to.shadowMapResolution;if(0===this._cascades.length||to.shadowMapResolution!==this._cascades[0].texture.size[0]){this._cascades=[];for(let t=0;t<to.cascadeCount;++t){const t=o._shadowMapDebug,i=r.gl,s=r.createFramebuffer(n,a,t,"texture"),l=new e.T(r,{width:n,height:a,data:null},i.DEPTH_COMPONENT16);if(s.depthAttachment.set(l.texture),t){const t=new e.T(r,{width:n,height:a,data:null},i.RGBA8);s.colorAttachment.set(t.texture);}this._cascades.push({framebuffer:s,texture:l,matrix:[],far:0,boundingSphereRadius:0,frustum:new e.cn,scale:0});}}this.shadowDirection=no(i);let l=0;if(t.elevation){const e=t.elevation,i=[1e4,-1e4];e.visibleDemTiles.filter((e=>e.dem)).forEach((e=>{const t=e.dem.tree;i[0]=Math.min(i[0],t.minimums[0]),i[1]=Math.max(i[1],t.maximums[0]);})),1e4!==i[0]&&(l=(i[1]-i[0])*e.exaggeration());}const c=1.5*t.cameraToCenterDistance,h=3*c,d=new Float64Array(16);for(let i=0;i<this._cascades.length;++i){const o=this._cascades[i];let s=t.height/50,r=1;1===to.cascadeCount?r=h:0===i?r=c:(s=c,r=h);const[n,a]=lo(t,this.shadowDirection,s,r,to.shadowMapResolution,l);o.scale=t.scale,o.matrix=n,o.boundingSphereRadius=a,e.bi(d,o.matrix),o.frustum=e.cn.fromInvProjectionMatrix(d,1,0,!0),o.far=r;}const u=this._cascades.length-1;this._uniformValues.u_fade_range=[.75*this._cascades[u].far,this._cascades[u].far],this._uniformValues.u_shadow_intensity=s,this._uniformValues.u_shadow_direction=[this.shadowDirection[0],this.shadowDirection[1],this.shadowDirection[2]],this._uniformValues.u_shadow_texel_size=1/to.shadowMapResolution,this._uniformValues.u_shadow_map_resolution=to.shadowMapResolution,this._uniformValues.u_shadowmap_0=Yi.ShadowMap0,this._uniformValues.u_shadowmap_1=Yi.ShadowMap0+1,this._groundShadowTiles=o.transform.coveringTiles({tileSize:512,renderWorldCopies:!0});const _=o.transform.elevation;for(const e of this._groundShadowTiles){let t={min:0,max:0};if(_){const i=_.getMinMaxForTile(e);i&&(t=i);}this.addShadowReceiver(e.toUnwrapped(),t.min,t.max);}}get enabled(){return this._enabled&&!this._forceDisable}set enabled(e){this._enabled=e;}drawShadowPass(t,i){if(!this.enabled)return;const o=this.painter,s=o.context;this._numCascadesToRender=this._receivers.computeRequiredCascades(o.transform.getFrustum(0),o.transform.worldSize,this._cascades),s.viewport.set([0,0,to.shadowMapResolution,to.shadowMapResolution]);for(let r=0;r<this._numCascadesToRender;++r){o.currentShadowCascade=r,s.bindFramebuffer.set(this._cascades[r].framebuffer.framebuffer),s.clear({color:e.am.white,depth:1});for(const e of t.order){const s=t._mergedLayers[e];if(!s.hasShadowPass()||s.isHidden(o.transform.zoom))continue;const r=t.getLayerSourceCache(s),n=r?i[r.id]:void 0;("model"===s.type||n&&n.length)&&o.renderLayer(o,r,s,n);}}o.currentShadowCascade=0;}drawGroundShadows(){if(!this.enabled)return;const e=this.painter,t=e.style,i=e.context,o=i.gl,s=t.directionalLight,r=t.ambientLight;if(!s||!r)return;const n=[],a=eo(e,e.longestCutoffRange);a.shouldRenderCutoff&&n.push("RENDER_CUTOFF"),n.push("RENDER_SHADOWS","DEPTH_TEXTURE"),this.useNormalOffset&&n.push("NORMAL_OFFSET");const l=ao(t,s,r),c=new Ni(o.LEQUAL,Ni.ReadOnly,e.depthRangeFor3D),h=new ji({func:o.EQUAL,mask:255},0,255,o.KEEP,o.KEEP,o.KEEP);for(const t of this._groundShadowTiles){const s=t.toUnwrapped(),r=e.isTileAffectedByFog(t),d=e.getOrCreateProgram("groundShadow",{defines:n,overrideFog:r});this.setupShadows(s,d),e.uploadCommonUniforms(i,d,s,null,a);const u={u_matrix:e.transform.calculateProjMatrix(s),u_ground_shadow_factor:l};d.draw(e,o.TRIANGLES,c,h,ki.multiply,qi.disabled,u,"ground_shadow",e.tileExtentBuffer,e.quadTriangleIndexBuffer,e.tileExtentSegments,null,e.transform.zoom,null,null);}}getShadowPassColorMode(){return this.painter._shadowMapDebug?ki.unblended:ki.disabled}getShadowPassDepthMode(){return this._depthMode}getShadowCastingLayerCount(){return this._shadowLayerCount}calculateShadowPassMatrixFromTile(t){const i=this.painter.transform,o=i.calculatePosMatrix(t,i.worldSize);return e.az(o,this._cascades[this.painter.currentShadowCascade].matrix,o),Float32Array.from(o)}calculateShadowPassMatrixFromMatrix(t){return e.az(t,this._cascades[this.painter.currentShadowCascade].matrix,t),Float32Array.from(t)}setupShadows(t,i,o,s=0){if(!this.enabled)return;const r=this.painter.transform,n=this.painter.context,a=n.gl,l=this._uniformValues,c=new Float64Array(16),h=r.calculatePosMatrix(t,r.worldSize);for(let t=0;t<this._cascades.length;t++)e.az(c,this._cascades[t].matrix,h),l[0===t?"u_light_matrix_0":"u_light_matrix_1"]=Float32Array.from(c),n.activeTexture.set(a.TEXTURE0+Yi.ShadowMap0+t),this._cascades[t].texture.bindExtraParam(a.LINEAR,a.LINEAR,a.CLAMP_TO_EDGE,a.CLAMP_TO_EDGE,a.GREATER);if(this.useNormalOffset=!!o,this.useNormalOffset){const i=e.cU(t.canonical),n=2/r.tileSize*e.aj/to.shadowMapResolution,a=n*this._cascades[0].boundingSphereRadius,c=n*this._cascades[this._cascades.length-1].boundingSphereRadius,h=("vector-tile"===o?1:3)/Math.pow(2,s-t.canonical.z-(1-r.zoom+Math.floor(r.zoom)));l.u_shadow_normal_offset=[i,a*h,c*h],l.u_shadow_bias=[6e-5,.0012,.012];}else l.u_shadow_bias=[36e-5,.0012,.012];i.setShadowUniformValues(n,l);}setupShadowsFromMatrix(t,i,o=!1){if(!this.enabled)return;const s=this.painter.context,r=s.gl,n=this._uniformValues,a=new Float64Array(16);for(let i=0;i<to.cascadeCount;i++)e.az(a,this._cascades[i].matrix,t),n[0===i?"u_light_matrix_0":"u_light_matrix_1"]=Float32Array.from(a),s.activeTexture.set(r.TEXTURE0+Yi.ShadowMap0+i),this._cascades[i].texture.bindExtraParam(r.LINEAR,r.LINEAR,r.CLAMP_TO_EDGE,r.CLAMP_TO_EDGE,r.GREATER);if(this.useNormalOffset=o,o){const e=to.normalOffset;n.u_shadow_normal_offset=[1,e,e],n.u_shadow_bias=[6e-5,.0012,.012];}else n.u_shadow_bias=[36e-5,.0012,.012];i.setShadowUniformValues(s,n);}getShadowUniformValues(){return this._uniformValues}getCurrentCascadeFrustum(){return this._cascades[this.painter.currentShadowCascade].frustum}computeSimplifiedTileShadowVolume(t,i,o,s){if(s[2]>=0)return {};const r=function(t,i,o){const s=o/(1<<t.canonical.z);return new e.cW([t.canonical.x*s+t.wrap*o,t.canonical.y*s+t.wrap*o,0],[(t.canonical.x+1)*s+t.wrap*o,(t.canonical.y+1)*s+t.wrap*o,i])}(t,i,o).getCorners(),n=i/-s[2];s[0]<0?(e.cV(r[0],r[0],[s[0]*n,0,0]),e.cV(r[3],r[3],[s[0]*n,0,0])):s[0]>0&&(e.cV(r[1],r[1],[s[0]*n,0,0]),e.cV(r[2],r[2],[s[0]*n,0,0])),s[1]<0?(e.cV(r[0],r[0],[0,s[1]*n,0]),e.cV(r[1],r[1],[0,s[1]*n,0])):s[1]>0&&(e.cV(r[2],r[2],[0,s[1]*n,0]),e.cV(r[3],r[3],[0,s[1]*n,0]));const a={};return a.vertices=r,a.planes=[ro(r[1],r[0],r[4]),ro(r[2],r[1],r[5]),ro(r[3],r[2],r[6]),ro(r[0],r[3],r[7])],a}addShadowReceiver(t,i,o){this._receivers.add(t,e.cW.fromTileIdAndHeight(t,i,o));}getMaxCascadeForTile(e){const t=this._receivers.get(e);return t&&t.lastCascade?t.lastCascade:0}}function ro(t,i,o){const s=e.at([],o,i),r=e.at([],t,i),n=e.bF([],s,r),a=e.ae(n);return 0===a?[0,0,1,0]:(e.bY(n,n,1/a),[n[0],n[1],n[2],-e.bG(n,i)])}function no(t){const i=t.properties.get("direction"),o=e.cR(i.x,i.y,i.z);o[2]=e.ay(o[2],0,75);const s=e.cT([o[0],o[1],o[2]]);return e.cS(s.x,s.y,s.z)}function ao(t,i,o){const s="none"===i.properties.get("color-use-theme"),r=i.properties.get("color"),n=i.properties.get("intensity"),a=i.properties.get("direction"),l=[a.x,a.y,a.z],c="none"===o.properties.get("color-use-theme"),h=o.properties.get("color"),d=o.properties.get("intensity"),u=Math.max(e.bG([0,0,1],l),0),_=[0,0,0];e.bY(_,h.toPremultipliedRenderColor(c?null:t.getLut(i.scope)).toArray01Linear().slice(0,3),d);const p=[0,0,0];return e.bY(p,r.toPremultipliedRenderColor(s?null:t.getLut(o.scope)).toArray01Linear().slice(0,3),u*n),e.cY([_[0]>0?_[0]/(_[0]+p[0]):0,_[1]>0?_[1]/(_[1]+p[1]):0,_[2]>0?_[2]/(_[2]+p[2]):0])}function lo(t,i,o,s,r,n){const a=t.zoom,l=t.scale,c=t.worldSize,h=1/c,d=t.aspect,u=Math.sqrt(1+d*d)*Math.tan(.5*t.fovX),_=u*u,p=s-o,f=s+o;let m,g;_>p/f?(m=s,g=s*u):(m=.5*f*(1+_),g=.5*Math.sqrt(p*p+2*(s*s+o*o)*_+f*f*_*_));const v=t.projection.pixelsPerMeter(t.center.lat,c),y=t._camera.getCameraToWorldMercator(),x=[0,0,-m*h];e.ad(x,x,y);let b=g*h;const w=t._edgeInsets;if(!(0===w.left&&0===w.top&&0===w.right&&0===w.bottom||w.left===w.right&&w.top===w.bottom)){const i=t._camera.getWorldToCamera(t.worldSize,"meters"===t.projection.zAxisUnit?v:1),r=t._camera.getCameraToClipPerspective(t._fov,t.width/t.height,o,s);r[8]=2*-t.centerOffset.x/t.width,r[9]=2*t.centerOffset.y/t.height;const n=new Float64Array(16);e.cB(n,r,i);const h=new Float64Array(16);e.bi(h,n);const d=e.cn.fromInvProjectionMatrix(h,c,a,!0);for(const i of d.points){const o=((T=i)[0]/=l,T[1]/=l,T[2]=e.c6(T[2],t._center.lat),T);b=Math.max(b,e.bZ(e.cX([],x,o)));}}var T;b*=r/(r-1);const E=Math.acos(i[2]),S=Math.atan2(-i[0],-i[1]),I=new Xi;I.position=x,I.setPitchBearing(E,S);const C=I.getWorldToCamera(c,v),R=b*c,D=Math.min(t._mercatorZfromZoom(17)*c*-2,-2*R),A=I.getCameraToClipOrthographic(-R,R,-R,R,D,(R+n*v)/i[2]),L=new Float64Array(16);e.az(L,A,C);const P=e.cS(Math.floor(1e6*x[0])/1e6*c,Math.floor(1e6*x[1])/1e6*c,0),z=.5*r,M=[0,0,0];e.ad(M,P,L),e.bY(M,M,z);const O=[Math.floor(M[0]),Math.floor(M[1]),Math.floor(M[2])],F=[0,0,0];e.at(F,M,O),e.bY(F,F,-1/z);const B=new Float64Array(16);return e.bx(B),e.bo(B,B,F),e.az(L,B,L),[L,R]}class co extends e.E{constructor(e){super(),this.requestManager=e,this.models={"":{}},this.modelUris={"":{}},this.modelByURL={},this.numModelsLoading={};}loadModel(t,i){return e.aS(this.requestManager.transformRequest(i,e.R.Model).url).then((i=>{if(!i)return;const o=e.aT(i),s=new e.aU(t,void 0,void 0,o);return s.computeBoundsAndApplyParent(),s})).catch((o=>{if(o&&404===o.status)return null;this.fire(new e.z(new Error(`Could not load model ${t} from ${i}: ${o.message}`)));}))}load(t,i,o={forceReload:!1}){this.models[i]||(this.models[i]={});const s=Object.keys(t),r=[],n=[];for(const e of s){const s=t[e];this.hasURLBeenRequested(s)&&!o.forceReload||(this.modelByURL[s]={modelId:e,scope:i},r.push(this.loadModel(e,s)),n.push(e)),this.models[i][e]||(this.models[i][e]={model:null,numReferences:1});}this.numModelsLoading[i]=(this.numModelsLoading[i]||0)+n.length,Promise.allSettled(r).then((t=>{for(let e=0;e<t.length;e++){const{status:o}=t[e];if("rejected"===o)continue;const{value:s}=t[e];this.models[i][n[e]]||(this.models[i][n[e]]={model:null,numReferences:1}),this.models[i][n[e]].model=s;}this.numModelsLoading[i]-=n.length,this.fire(new e.A("data",{dataType:"style"}));})).catch((t=>{this.fire(new e.z(new Error(`Could not load models: ${t.message}`)));}));}isLoaded(){for(const e in this.numModelsLoading)if(this.numModelsLoading[e]>0)return !1;return !0}hasModel(e,t,i={exactIdMatch:!1}){return !!(i.exactIdMatch?this.getModel(e,t):this.getModelByURL(this.modelUris[t][e]))}getModel(e,t){return this.models[t]||(this.models[t]={}),this.models[t][e]?this.models[t][e].model:void 0}getModelByURL(e){if(!e)return null;const t=this.modelByURL[e];return t?this.models[t.scope][t.modelId].model:null}hasModelBeenAdded(e,t){return this.models[t]&&void 0!==this.models[t][e]}getModelURIs(e){return this.modelUris[e]||{}}addModel(e,t,i){this.models[i]||(this.models[i]={}),this.modelUris[i]||(this.modelUris[i]={});const o=this.requestManager.normalizeModelURL(t);if((this.hasModel(e,i,{exactIdMatch:!0})||this.hasModelBeenAdded(e,i))&&this.modelUris[i][e]===o)this.models[i][e].numReferences++;else if(this.hasURLBeenRequested(o)){const{scope:e,modelId:t}=this.modelByURL[o];this.models[e][t].numReferences++;}else this.modelUris[i][e]=o,this.load({[e]:this.modelUris[i][e]},i);}addModelURLs(e,t){this.models[t]||(this.models[t]={}),this.modelUris[t]||(this.modelUris[t]={});const i=this.modelUris[t];for(const t in e)i[t]=this.requestManager.normalizeModelURL(e[t]);}reloadModels(e){this.load(this.modelUris[e],e,{forceReload:!0});}addModelsFromBucket(t,i){this.models[i]||(this.models[i]={}),this.modelUris[i]||(this.modelUris[i]={});const o={};for(const s of t)this.hasModel(s,i,{exactIdMatch:!0})||this.hasURLBeenRequested(s)?this.models[i][s].numReferences++:this.modelUris[i][s]&&!this.hasURLBeenRequested(s)?o[s]=this.modelUris[i][s]:!this.hasURLBeenRequested(s)&&e.cZ(s,!1)&&(this.modelUris[i][s]=this.requestManager.normalizeModelURL(s),o[s]=this.modelUris[i][s]);this.load(o,i);}hasURLBeenRequested(e){return void 0!==this.modelByURL[e]}removeModel(e,t,i=!1){if(this.models[t]&&this.models[t][e]&&(this.models[t][e].numReferences--,0===this.models[t][e].numReferences)){const o=this.modelUris[t][e];i||delete this.modelUris[t][e],delete this.modelByURL[o];const s=this.models[t][e].model;if(!s)return;delete this.models[t][e],s.destroy();}}destroy(){for(const e of Object.keys(this.models))for(const t of Object.keys(this.models[e])){const i=this.models[e][t].model;delete this.models[e][t],i&&i.destroy();}this.models={"":{}},this.modelUris={"":{}},this.modelByURL={},this.numModelsLoading={};}listModels(e){return this.models[e]||(this.models[e]={}),Object.keys(this.models[e])}upload(e,t){this.models[t]||(this.models[t]={});for(const i in this.models[t])this.models[t][i].model&&this.models[t][i].model.upload(e.context);}}const ho=new e.a7({data:new e.a8(e.a5.colorTheme.data)}),uo={"mbx-indoor-active-floorplans":{default:["literal",[]]},"mbx-indoor-underground":{default:["literal",!1]},"mbx-indoor-loaded-levels":{default:["literal",[]]},"mbx-indoor-level-height":{default:["literal",{}]},"mbx-indoor-level-base":{default:["literal",{}]},"mbx-indoor-level-selected":{default:["literal",{}]},"mbx-indoor-level-overlapped":{default:["literal",{}]}};function _o(e){return e=e||{},Object.assign(e,uo)}class po extends e.E{constructor(t){super(),this.mergeFloors=!0,this._scope=void 0,this._queryFeatureSetId=void 0,this._buildingEntryFeatureSetId=void 0,this._selectedFloorplan=void 0,this._indoorData=void 0,this._floorplanStates={},e.aV(["_onLoad","_onMove","_checkFloorplanVisible"],this),this._map=t,this._checkFloorplanVisible(),this._map.on("load",this._onLoad),this._map.on("move",this._onMove);}destroy(){this._map.indoor.off("load",this._onLoad),this._map.indoor.off("move",this._onMove),this._map=void 0;}_onLoad(){this._map.style.forEachFragmentStyle((t=>{t.stylesheet.indoor&&(this._queryFeatureSetId?this.fire(new e.z(new Error("Multiple indoor map styles detected, simultaneous usage is not allowed currently."))):(this._queryFeatureSetId=t.stylesheet.indoor.floorplanFeaturesetId,this._buildingEntryFeatureSetId=t.stylesheet.indoor.buildingFeaturesetId,this._scope=t.scope));})),this._queryFeatureSetId&&this._buildingEntryFeatureSetId&&this._map.addInteraction("mbx-indoor-buildingclick",{type:"click",target:{featuresetId:this._buildingEntryFeatureSetId,importId:this._scope},handler:e=>(e.feature&&e.feature.properties.floorplan&&this.selectFloorplan(e.feature.properties.floorplan),!0)}),this._checkFloorplanVisible();}_onMove(){this._checkFloorplanVisible();}_checkFloorplanVisible(){if(!this._queryFeatureSetId)return;if(!this._map.isStyleLoaded())return;const t=()=>{this._indoorData=void 0,this._selectedFloorplan=void 0,this._map.setConfigProperty(this._scope,"mbx-indoor-underground",!1),this._map.setConfigProperty(this._scope,"mbx-indoor-active-floorplans",["literal",[]]),this.fire(new e.A("floorplangone"));};if(this._map.transform.zoom<13)return void t();const i={target:{featuresetId:this._queryFeatureSetId,importId:this._scope}},o=this._map.transform.width,s=this._map.transform.height,r=o*(2/3),n=s*(2/3),a=.5*(o-r),l=.5*(s-n),c=[new e.P(a,l),new e.P(a+r,l+n)],h=this._map.queryRenderedFeatures(c,i);h.length>0?this._selectedFloorplan&&h[0].properties.id===this._selectedFloorplan.properties.id||(this._selectedFloorplan=h[0],this._floorplanSelected()):t();}_floorplanSelected(){this._indoorData=JSON.parse(this._selectedFloorplan.properties["indoor-data"]),this._indoorData.id=this._selectedFloorplan.properties.id,this._floorplanStates[this._indoorData.id]=this._floorplanStates[this._indoorData.id]||{},this._map.setConfigProperty(this._scope,"mbx-indoor-active-floorplans",["literal",[this._indoorData.id]]);const t=this._floorplanStates[this._indoorData.id].selectedBuilding,i=t?this._indoorData.buildings.find((e=>e.id===t)):this._indoorData.buildings.length>0?this._indoorData.buildings[0]:null,o=this._floorplanStates[this._indoorData.id].selectedLevel,s=this._indoorData.levels.find((e=>e.id===o)),r=this._indoorData.levels.find((e=>!(!i||!i.levels)&&0===Number(e.levelOrder)&&i.levels.includes(e.id))),n=s?s.id:r?r.id:void 0;this.fire(new e.A("floorplanselected",{buildings:this._indoorData.buildings,levels:this._indoorData.levels,selectedLevelId:n})),i&&this._buildingSelected(i,!1),n&&this._levelSelected(n);}_buildingSelected(t,i){if(!t||!t.id)return void console.warn("IndoorManager: Building or building id is undefined");i&&t.extent&&this._map.fitBounds(t.extent,{pitch:this._map.getPitch(),bearing:this._map.getBearing()}),this._floorplanStates[this._indoorData.id].selectedBuilding=t?t.id:void 0;const o=this._indoorData.levels.filter((e=>t.levels.includes(e.id)));this.fire(new e.A("buildingselected",{buildingId:t.id,levels:o}));}_levelSelected(t){const i=this._indoorData.levels.find((e=>e.id===t));i?(this._updateLevels(i,!0),this.fire(new e.A("levelselected",{levelId:i.id}))):console.warn(`IndoorManager: Level with ID ${t} not found in the current floorplan.`);}_updateLevels(e,t){if(!e||!e.id)throw new Error("IndoorManager: Selected level or level ID is undefined");function i(e){const t=e.indexOf("/floor/");if(-1===t)return e;const i=t+7,o=e.indexOf("/",i);return -1===o?e.slice(i):e.slice(i,o)}this._floorplanStates[this._indoorData.id].selectedLevel=e.id;const o=[],s={},r={},n={},a={};for(const t of this._indoorData.levels){if(o.push(t.id),s[t.id]=t.levelOrder>=0?3*Math.abs(t.levelOrder+1):3*Math.abs(t.levelOrder),r[t.id]=t.levelOrder>=0?3*t.levelOrder:0,this.mergeFloors){const o=i(e.id),s=i(t.id);n[t.id]=s===o?"true":"false";}else n[t.id]=t.id===e.id?"true":"false";a[t.id]=t.levelOrder<e.levelOrder?"true":"false";}this._map.setConfigProperty(this._scope,"mbx-indoor-loaded-levels",["literal",o]),this._map.setConfigProperty(this._scope,"mbx-indoor-level-height",["literal",s]),this._map.setConfigProperty(this._scope,"mbx-indoor-level-base",["literal",r]),this._map.setConfigProperty(this._scope,"mbx-indoor-level-selected",["literal",n]),this._map.setConfigProperty(this._scope,"mbx-indoor-level-overlapped",["literal",a]),this._map.setConfigProperty(this._scope,"mbx-indoor-underground",e.levelOrder<0);}selectFloorplan(t){const i={target:{featuresetId:this._queryFeatureSetId,importId:this._scope}},o=[new e.P(0,0),new e.P(this._map.transform.width,this._map.transform.height)],s=this._map.queryRenderedFeatures(o,i);if(s.length>0)for(const e of s)if(JSON.parse(e.properties["indoor-data"]).id===t){this._selectedFloorplan=e,this._floorplanSelected();break}}selectBuilding(e){const t=this._indoorData.buildings.find((t=>t.id===e));this._buildingSelected(t,!0);}selectLevel(e){this._levelSelected(e);}}function fo(t){if(!t.metadata||!t.metadata.content_area)return;const i=e.q.devicePixelRatio,{left:o,top:s,width:r,height:n}=t.metadata.content_area,a=o*i,l=s*i;return [a,l,a+r*i,l+n*i]}function mo(t){if(t)return t.map((([t,i])=>[t*e.q.devicePixelRatio,i*e.q.devicePixelRatio]))}class go{constructor(e,t,i){this.id=e,this.scope=t,this.sourceCache=i,this.pendingRequests=new Set,this.missingRequests=new Set;}addPendingRequest(e){this.missingRequests.has(e.name)||this.pendingRequests.has(e.name)||this.pendingRequests.add(e.name);}hasPendingRequests(){return this.pendingRequests.size>0}resolvePendingRequests(){const t=new Map;if(!this.sourceCache.loaded())return t;const i=this.sourceCache.getVisibleCoordinates();if(0===i.length)return t;const o=this.sourceCache.getSource();if(!(o instanceof st))return t;const s=i.map((e=>this.sourceCache.getTile(e))),r=o.getImages(s,Array.from(this.pendingRequests));for(const[i,o]of r)t.set(e.I.from({name:i,iconsetId:this.id}),o),this.pendingRequests.delete(i);for(const e of this.pendingRequests)this.missingRequests.add(e);return this.pendingRequests.clear(),t}}const vo=(e,t)=>Ae(e,t&&t.filter((e=>"source.canvas"!==e.identifier))),yo=e.aF(zt,["addLayer","removeLayer","setLights","setPaintProperty","setLayoutProperty","setSlot","setFilter","addSource","removeSource","setLayerZoomRange","setLight","setTransition","setGeoJSONSourceData","setTerrain","setFog","setSnow","setRain","setProjection","setCamera","addImport","removeImport","updateImport","addIconset","removeIconset"]),xo=e.aF(zt,["setCenter","setZoom","setBearing","setPitch"]),bo=new Set(["background","sky","slot","custom"]),wo={version:8,layers:[],sources:{}},To={duration:300,delay:0};class Eo extends e.E{constructor(t,i={}){super(),this.map=t,this.scope=i.scope||"",this.globalId=null,this.fragments=[],this.importDepth=i.importDepth||0,this.importsCache=i.importsCache||new Map,this.resolvedImports=i.resolvedImports||new Set,this.transition=e.h({},To),this._buildingIndex=new At(this),this.crossTileSymbolIndex=new Fi,this._mergedOrder=[],this._drapedFirstOrder=[],this._mergedLayers={},this._mergedSourceCaches={},this._mergedOtherSourceCaches={},this._mergedSymbolSourceCaches={},this._clipLayerPresent=!1,this._has3DLayers=!1,this._hasCircleLayers=!1,this._hasSymbolLayers=!1,this._changes=i.styleChanges||new V,this.dispatcher=i.dispatcher?i.dispatcher:new e.D(e.c$(),this),i.imageManager?this.imageManager=i.imageManager:(this.imageManager=new q(this.map._spriteFormat),this.imageManager.setEventedParent(this)),this.imageManager.addScope(this.scope),this.glyphManager=i.glyphManager?i.glyphManager:new e.d0(t._requestManager,i.localFontFamily?e.d1.all:i.localIdeographFontFamily?e.d1.ideographs:e.d1.none,i.localFontFamily||i.localIdeographFontFamily),i.modelManager?this.modelManager=i.modelManager:(this.modelManager=new co(t._requestManager),this.modelManager.setEventedParent(this)),this._layers={},this._sourceCaches={},this._otherSourceCaches={},this._symbolSourceCaches={},this._loaded=!1,this._precompileDone=!1,this._shouldPrecompile=!1,this._availableImages=[],this._availableModels={},this._order=[],this._markersNeedUpdate=!1,this.options=i.configOptions?i.configOptions:new Map,this._configDependentLayers=i.configDependentLayers?i.configDependentLayers:new Set,this._config=i.config,this._styleColorTheme={lut:null,lutLoading:!1,lutLoadingCorrelationID:0,colorTheme:null,colorThemeOverride:i.colorThemeOverride},this._styleColorThemeForScope={},this._initialConfig=i.initialConfig,this.dispatcher.broadcast("setReferrer",e.d2());const o=this;this._rtlTextPluginCallback=Eo.registerForPluginStateChange((t=>{o.dispatcher.broadcast("syncRTLPluginState",{pluginStatus:t.pluginStatus,pluginURL:t.pluginURL},((t,i)=>{if(e.d3(t),i&&i.every((e=>e)))for(const e in o._sourceCaches){const t=o._sourceCaches[e],i=t.getSource().type;"vector"!==i&&"geojson"!==i||t.reload();}}));})),this.on("data",(e=>{if("source"!==e.dataType||"metadata"!==e.sourceDataType)return;const t=this.getOwnSource(e.sourceId);if(t&&t.vectorLayerIds)for(const e in this._layers){const i=this._layers[e];i.source===t.id&&this._validateLayer(i);}}));}load(e){return e?("string"==typeof e?this.loadURL(e):this.loadJSON(e),this):this}_getGlobalId(t){if(!t)return null;if("string"==typeof t){if(e.j(t))return t;const i=e.d4(t);if(!i.startsWith("http"))try{return new URL(i,location.href).toString()}catch(e){return i}return i}return `json://${e.d5(JSON.stringify(t))}`}_diffStyle(t,i,o){this.globalId=this._getGlobalId(t);const s=(e,t)=>{try{t(null,this.setState(e,o));}catch(e){t(e,!1);}};if("string"==typeof t){const o=this.map._requestManager.normalizeStyleURL(t),r=this.map._requestManager.transformRequest(o,e.R.Style);e.n(r,((t,o)=>{t?this.fire(new e.z(t)):o&&s(o,i);}));}else "object"==typeof t&&s(t,i);}loadURL(t,i={}){this.fire(new e.A("dataloading",{dataType:"style"}));const o="boolean"==typeof i.validate?i.validate:!e.j(t);this.globalId=this._getGlobalId(t),t=this.map._requestManager.normalizeStyleURL(t,i.accessToken),this.resolvedImports.add(t);const s=this.importsCache.get(t);if(s)return this._load(s,o);const r=this.map._requestManager.transformRequest(t,e.R.Style);this._request=e.n(r,((i,s)=>{if(this._request=null,i)this.fire(new e.z(i));else if(s)return this.importsCache.set(t,s),this._load(s,o)}));}loadJSON(t,i={}){this.fire(new e.A("dataloading",{dataType:"style"})),this.globalId=this._getGlobalId(t),this._request=e.q.frame((()=>{this._request=null,this._load(t,!1!==i.validate);}));}loadEmpty(){this.fire(new e.A("dataloading",{dataType:"style"})),this._load(wo,!1);}_loadImports(t,i,o){if(this.importDepth>=4)return e.w("Style doesn't support nesting deeper than 5"),Promise.resolve();const s=[];for(const e of t){const t=this._createFragmentStyle(e),r=new Promise((e=>{t.once("style.import.load",e),t.once("error",e);})).then((()=>this.mergeAll()));if(s.push(r),this.resolvedImports.has(e.url)){t.loadEmpty();continue}const n=e.data||this.importsCache.get(e.url);n?(t.loadJSON(n,{validate:i}),this._isInternalStyle(n)&&(t.globalId=null)):e.url?t.loadURL(e.url,{validate:i}):t.loadEmpty();const a={style:t,id:e.id,config:e.config};if(o){const e=this.fragments.findIndex((({id:e})=>e===o));this.fragments=this.fragments.slice(0,e).concat(a).concat(this.fragments.slice(e));}else this.fragments.push(a);}return Promise.allSettled(s)}getImportGlobalIds(e=this,t=new Set){for(const i of e.fragments)i.style.globalId&&t.add(i.style.globalId),this.getImportGlobalIds(i.style,t);return [...t.values()]}_createFragmentStyle(t){const i=this.scope?e.C(t.id,this.scope):t.id;let o;const s=this._initialConfig&&this._initialConfig[i];(t.config||s)&&(o=e.h({},t.config,s));const r=new Eo(this.map,{scope:i,styleChanges:this._changes,importDepth:this.importDepth+1,importsCache:this.importsCache,resolvedImports:new Set(this.resolvedImports),dispatcher:this.dispatcher,imageManager:this.imageManager,glyphManager:this.glyphManager,modelManager:this.modelManager,config:o,configOptions:this.options,colorThemeOverride:t["color-theme"],configDependentLayers:this._configDependentLayers});return r.setEventedParent(this.map,{style:r}),r}_reloadImports(){this.mergeAll(),this._updateMapProjection(),this.updateConfigDependencies(),this.map._triggerCameraUpdate(this.camera),this.dispatcher.broadcast("setLayers",{layers:this._serializeLayers(this._order),scope:this.scope,options:this.options}),this._shouldPrecompile=this.map._precompilePrograms&&this.isRootStyle();}_isInternalStyle(e){return this.isRootStyle()&&(e.fragment||!!e.schema&&!1!==e.fragment)}_load(t,i){const o=t.indoor?_o(t.schema):t.schema;if(this._isInternalStyle(t)){const o=e.h({},wo,{imports:[{id:"basemap",data:t,url:""}]});return void this._load(o,i)}if(this.updateConfig(this._config,o),i&&vo(this,me(t)))return;this._loaded=!0,this.stylesheet=e.d6(t);const s=()=>{for(const e in t.sources)this.addSource(e,t.sources[e],{validate:!1,isInitialLoad:!0});if(t.iconsets)for(const e in t.iconsets)this.addIconset(e,t.iconsets[e]);t.sprite?this._loadIconset(t.sprite):(this.imageManager.setLoaded(!0,this.scope),this.dispatcher.broadcast("spriteLoaded",{scope:this.scope,isLoaded:!0})),this.setGlyphsUrl(t.glyphs);const o=Pt(this.stylesheet.layers);if(this._order=o.map((e=>e.id)),this.stylesheet.light&&e.w("The `light` root property is deprecated, prefer using `lights` with `flat` light type instead."),this.stylesheet.lights)if(1===this.stylesheet.lights.length&&"flat"===this.stylesheet.lights[0].type){const e=this.stylesheet.lights[0];this.light=new Pe(e.properties,e.id);}else this.setLights(this.stylesheet.lights);this.light||(this.light=new Pe(this.stylesheet.light)),this._layers={};for(const t of o){const i=e.db(t,this.scope,this._styleColorTheme.lut,this.options);0!==i.configDependencies.size&&this._configDependentLayers.add(i.fqid),i.setEventedParent(this,{layer:{id:i.id}}),this._layers[i.id]=i;const o=this.getOwnLayerSourceCache(i),s=!!this.directionalLight&&this.directionalLight.shadowsEnabled();o&&i.canCastShadows()&&s&&(o.castsShadows=!0);}this.stylesheet.featuresets&&this.setFeaturesetSelectors(this.stylesheet.featuresets),this.stylesheet.models&&this.addModelURLs(this.stylesheet.models);const s=this.stylesheet.terrain;s&&(this.checkCanvasFingerprintNoise(),this.disableElevatedTerrain||this.terrainSetForDrapingOnly()||this._createTerrain(s,1)),this.stylesheet.fog&&this._createFog(this.stylesheet.fog),this.stylesheet.snow&&this._createSnow(this.stylesheet.snow),this.stylesheet.rain&&this._createRain(this.stylesheet.rain),this.stylesheet.transition&&this.setTransition(this.stylesheet.transition),this.fire(new e.A("data",{dataType:"style"}));const r=this.isRootStyle();t.imports?this._loadImports(t.imports,i).then((()=>{this._reloadImports(),this.fire(new e.A(r?"style.load":"style.import.load"));})).catch((t=>{this.fire(new e.z(new Error("Failed to load imports",t))),this.fire(new e.A(r?"style.load":"style.import.load"));})):(this._reloadImports(),this.fire(new e.A(r?"style.load":"style.import.load")));};this._styleColorTheme.colorTheme=this.stylesheet["color-theme"];const r=this._styleColorTheme.colorThemeOverride?this._styleColorTheme.colorThemeOverride:this._styleColorTheme.colorTheme;if(r){const t=this._evaluateColorThemeData(r);this._loadColorTheme(t).then((()=>{s();})).catch((t=>{e.w(`Couldn't load color theme from the stylesheet: ${t}`),s();}));}else this._styleColorTheme.lut=null,s();}isRootStyle(){return 0===this.importDepth}mergeAll(){let t,i,o,s,r,n,a,l,c,h;const d={};this.terrain&&this.terrain.scope!==this.scope&&delete this.terrain,this.forEachFragmentStyle((e=>{if(e.stylesheet){if(null!=e.light&&(t=e.light),e.stylesheet.lights)for(const t of e.stylesheet.lights)"ambient"===t.type&&null!=e.ambientLight&&(i=e.ambientLight),"directional"===t.type&&null!=e.directionalLight&&(o=e.directionalLight);s=this._prioritizeTerrain(s,e.terrain,e.stylesheet.terrain),e.stylesheet.fog&&null!=e.fog&&(r=e.fog),e.stylesheet.snow&&null!=e.snow&&(n=e.snow),e.stylesheet.rain&&null!=e.rain&&(a=e.rain),null!=e.stylesheet.camera&&(h=e.stylesheet.camera),null!=e.stylesheet.projection&&(l=e.stylesheet.projection),null!=e.stylesheet.transition&&(c=e.stylesheet.transition),d[e.scope]=e._styleColorTheme;}})),this.light=t,this.ambientLight=i,this.directionalLight=o,this.fog=r,this.snow=n,this.rain=a,this._styleColorThemeForScope=d,null===s?delete this.terrain:this.terrain=s,this.camera=h||{"camera-projection":"perspective"},this.projection=l||{name:"mercator"},this.transition=e.h({},To,c),this.mergeSources(),this.mergeLayers();}forEachFragmentStyle(e){const t=i=>{for(const e of i.fragments)t(e.style);e(i);};t(this);}_prioritizeTerrain(e,t,i){const o=e&&0===e.drapeRenderMode;return null===i?t&&0===t.drapeRenderMode?t:o?e:null:null!=t&&(!e||o||t&&1===t.drapeRenderMode)?t:e}mergeTerrain(){let e;this.terrain&&this.terrain.scope!==this.scope&&delete this.terrain,this.forEachFragmentStyle((t=>{e=this._prioritizeTerrain(e,t.terrain,t.stylesheet.terrain);})),null===e?delete this.terrain:this.terrain=e;}mergeProjection(){let e;this.forEachFragmentStyle((t=>{null!=t.stylesheet.projection&&(e=t.stylesheet.projection);})),this.projection=e||{name:"mercator"};}mergeSources(){const t={},i={},o={};this.forEachFragmentStyle((s=>{for(const i in s._sourceCaches){const o=e.C(i,s.scope);t[o]=s._sourceCaches[i];}for(const t in s._otherSourceCaches){const o=e.C(t,s.scope);i[o]=s._otherSourceCaches[t];}for(const t in s._symbolSourceCaches){const i=e.C(t,s.scope);o[i]=s._symbolSourceCaches[t];}})),this._mergedSourceCaches=t,this._mergedOtherSourceCaches=i,this._mergedSymbolSourceCaches=o;}mergeLayers(){const t={},i=[],o={};this._mergedSlots=[],this._has3DLayers=!1,this._hasCircleLayers=!1,this._hasSymbolLayers=!1,this.forEachFragmentStyle((o=>{for(const s of o._order){const r=o._layers[s];if("slot"===r.type){const i=e.d7(s);if(t[i])continue;t[i]=[];}r.slot&&t[r.slot]?t[r.slot].push(r):i.push(r);}})),this._mergedOrder=[];const s=(i=[])=>{for(const r of i)if("slot"===r.type){const i=e.d7(r.id);t[i]&&s(t[i]),this._mergedSlots.push(i);}else {const t=e.C(r.id,r.scope);this._mergedOrder.push(t),o[t]=r,r.is3D(!!this.terrain)&&(this._has3DLayers=!0),"circle"===r.type&&(this._hasCircleLayers=!0),"symbol"===r.type&&(this._hasSymbolLayers=!0),"clip"===r.type&&(this._clipLayerPresent=!0);}};s(i),this._mergedOrder.sort(((e,t)=>{const i=o[e],s=o[t];return i.hasInitialOcclusionOpacityProperties?s.is3D(!!this.terrain)?1:0:i.is3D(!!this.terrain)&&s.hasInitialOcclusionOpacityProperties?-1:0})),this._mergedLayers=o,this.updateDrapeFirstLayers(),this._buildingIndex.processLayersChanged();}terrainSetForDrapingOnly(){return !!this.terrain&&0===this.terrain.drapeRenderMode}getCamera(){return this.stylesheet.camera}setCamera(t){return this.stylesheet.camera=e.h({},this.stylesheet.camera,t),this.camera=this.stylesheet.camera,this}_evaluateColorThemeData(t){return t.data?function(t,i,o,s){const r=e.h({},i);for(const t of Object.keys(e.a5.colorTheme))void 0===r[t]&&(r[t]=e.a5.colorTheme[t].default);const n=new e.a6(ho,t,new Map(o));return n.setTransitionOrValue(r,o),n.untransitioned().possiblyEvaluate(new e.aa(0,{worldview:void 0}))}(this.scope,t,this.options).get("data"):null}_loadColorTheme(t){this._styleColorTheme.lutLoading=!0,this._styleColorTheme.lutLoadingCorrelationID+=1;const i=this._styleColorTheme.lutLoadingCorrelationID;return new Promise(((o,s)=>{const r="data:image/png;base64,";if(!t||0===t.length)return this._styleColorTheme.lut=null,this._styleColorTheme.lutLoading=!1,void o();let n=t;n.startsWith(r)||(n=r+n);const a=e.I.from("mapbox-reserved-lut"),l=new Image;l.src=n,l.onerror=()=>{this._styleColorTheme.lutLoading=!1,s(new Error("Failed to load image data"));},l.onload=()=>{if(this._styleColorTheme.lutLoadingCorrelationID!==i)return void o();this._styleColorTheme.lutLoading=!1;const{width:r,height:n,data:c}=e.q.getImageData(l);if(n>32)return void s(new Error("The height of the image must be less than or equal to 32 pixels."));if(r!==n*n)return void s(new Error("The width of the image must be equal to the height squared."));this.getImage(a)&&this.removeImage(a),this.addImage(a,{data:new e.r({width:r,height:n},c),pixelRatio:1,sdf:!1,usvg:!1,version:0});const h=this.imageManager.getImage(a,this.scope);h?(this._styleColorTheme.lut={image:h.data,data:t},o()):s(new Error("Missing LUT image."));};}))}getLut(e){const t=this._styleColorThemeForScope[e];return t?t.lut:null}setProjection(e){e?this.stylesheet.projection=e:delete this.stylesheet.projection,this.mergeProjection(),this._updateMapProjection();}applyProjectionUpdate(){this._loaded&&(this.dispatcher.broadcast("setProjection",this.map.transform.projectionOptions),this.map.transform.projection.requiresDraping?(this.getTerrain()||this.stylesheet.terrain)&&!this.disableElevatedTerrain||this.setTerrainForDraping():this.terrainSetForDrapingOnly()&&this.setTerrain(null,0));}_updateMapProjection(){this.isRootStyle()&&(this.map._useExplicitProjection?this.applyProjectionUpdate():this.map._prioritizeAndUpdateProjection(null,this.projection));}_loadSprite(t){this._spriteRequest=function(t,i,o){let s,r,n;const a=e.q.devicePixelRatio>1?"@2x":"";let l=e.n(i.transformRequest(i.normalizeSpriteURL(t,a,".json"),e.R.SpriteJSON),((e,t)=>{l=null,n||(n=e,s=t,h());})),c=e.o(i.transformRequest(i.normalizeSpriteURL(t,a,".png"),e.R.SpriteImage),((e,t)=>{c=null,n||(n=e,r=t,h());}));function h(){if(n)o(n);else if(s&&r){const t=e.q.getImageData(r),i={};for(const o in s){const{width:r,height:n,x:a,y:l,sdf:c,pixelRatio:h,stretchX:d,stretchY:u,content:_}=s[o],p=new e.r({width:r,height:n});e.r.copy(t,p,{x:a,y:l},{x:0,y:0},{width:r,height:n},null),i[o]={data:p,pixelRatio:h,sdf:c,stretchX:d,stretchY:u,content:_,usvg:!1};}o(null,i);}}return {cancel(){l&&(l.cancel(),l=null),c&&(c.cancel(),c=null);}}}(t,this.map._requestManager,((t,i)=>{if(this._spriteRequest=null,t)this.fire(new e.z(t));else if(i){const t=new Map;for(const o in i)t.set(e.I.from(o),i[o]);this.addImages(t);}this.imageManager.setLoaded(!0,this.scope),this.dispatcher.broadcast("spriteLoaded",{scope:this.scope,isLoaded:!0}),this.fire(new e.A("data",{dataType:"style"}));}));}addIconset(t,i){if("sprite"===i.type)return void this._loadSprite(i.url);const o=this.getOwnSourceCache(i.source);if(!o)return void this.fire(new e.z(new Error(`Source "${i.source}" as specified by iconset "${t}" does not exist and cannot be used as an iconset source`)));const s=o.getSource();if("raster-array"!==s.type)return void this.fire(new e.z(new Error(`Source "${i.source}" as specified by iconset "${t}" is not a "raster-array" source and cannot be used as an iconset source`)));s.partial=!1;const r=new go(t,this.scope,o);this.imageManager.addImageProvider(r,this.scope);}removeIconset(e){this.imageManager.removeImageProvider(e,this.scope);}_loadIconset(t){if(!e.j(t)&&"icon_set"!==this.map._spriteFormat||"raster"===this.map._spriteFormat)return void this._loadSprite(t);const i="auto"===this.map._spriteFormat;var o,s;this._spriteRequest=(s=(o,s)=>{if(this._spriteRequest=null,o)i?this._loadSprite(t):this.fire(new e.z(o));else if(s){const t=new Map;for(const i in s)t.set(e.I.from(i),s[i]);this.addImages(t);}this.imageManager.setLoaded(!0,this.scope),this.dispatcher.broadcast("spriteLoaded",{scope:this.scope,isLoaded:!0}),this.fire(new e.A("data",{dataType:"style"}));},e.br((o=this.map._requestManager).transformRequest(o.normalizeIconsetURL(t),e.R.Iconset),((t,i)=>{if(t)return void s(t);const o={},r=e.c_(new e.bq(i));for(const t of r.icons){const i={version:1,pixelRatio:e.q.devicePixelRatio,content:fo(t),stretchX:t.metadata?mo(t.metadata.stretch_x_areas):void 0,stretchY:t.metadata?mo(t.metadata.stretch_y_areas):void 0,sdf:!1,usvg:!0,icon:t};o[t.name]=i;}s(null,o);})));}_validateLayer(t){const i=this.getOwnSource(t.source);if(!i)return;const o=t.sourceLayer;o&&("geojson"===i.type||i.vectorLayerIds&&-1===i.vectorLayerIds.indexOf(o))&&this.fire(new e.z(new Error(`Source layer "${o}" does not exist on source "${i.id}" as specified by style layer "${t.id}"`)));}loaded(){if(!this._loaded)return !1;if(Object.keys(this._changes.getUpdatedSourceCaches()).length)return !1;for(const e in this._sourceCaches)if(!this._sourceCaches[e].loaded())return !1;if(!this.imageManager.isLoaded())return !1;if(this.imageManager.hasPatternsInFlight())return !1;if(!this.modelManager.isLoaded())return !1;if(this._styleColorTheme.lutLoading)return !1;for(const{style:e}of this.fragments)if(!e.loaded())return !1;return !0}_serializeImports(){if(this.stylesheet.imports)return this.stylesheet.imports.map(((e,t)=>{const i=this.fragments[t];return i&&i.style&&(e.data=i.style.serialize()),e}))}_serializeSources(){const e={};for(const t in this._sourceCaches){const i=this._sourceCaches[t].getSource();e[i.id]||(e[i.id]=i.serialize());}return e}_serializeLayers(e){const t=[];for(const i of e){const e=this._layers[i];e&&"custom"!==e.type&&t.push(e.serialize());}return t}hasLightTransitions(){return !(!this.light||!this.light.hasTransition())||!(!this.ambientLight||!this.ambientLight.hasTransition())||!(!this.directionalLight||!this.directionalLight.hasTransition())}hasFogTransition(){return !!this.fog&&this.fog.hasTransition()}hasSnowTransition(){return !!this.snow&&this.snow.hasTransition()}hasRainTransition(){return !!this.rain&&this.rain.hasTransition()}hasTransitions(){if(this.hasLightTransitions())return !0;if(this.hasFogTransition())return !0;if(this.hasSnowTransition())return !0;if(this.hasRainTransition())return !0;for(const e in this._sourceCaches)if(this._sourceCaches[e].hasTransition())return !0;for(const e in this._layers)if(this._layers[e].hasTransition())return !0;return !1}get order(){return this.terrain?this._drapedFirstOrder:this._mergedOrder}_getOrder(e){return e?this.order:this._mergedOrder}isLayerDraped(e){return !!this.terrain&&e.isDraped(this.getLayerSourceCache(e))}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading")}_checkLayer(t){const i=this.getOwnLayer(t);if(i)return i;this.fire(new e.z(new Error(`The layer '${t}' does not exist in the map's style.`)));}_checkSource(t){const i=this.getOwnSource(t);if(i)return i;this.fire(new e.z(new Error(`The source '${t}' does not exist in the map's style.`)));}precompilePrograms(e,t){const i=this.map.painter;if(i)for(let o=e.minzoom||0;o<(e.maxzoom||25.5);o++){const o=e.getProgramIds();if(o)for(const s of o){const o=e.getDefaultProgramParams(s,t.zoom,this._styleColorTheme.lut);o&&(i.style=this,this.fog&&(i._fogVisible=!0,o.overrideFog=!0,i.getOrCreateProgram(s,o)),i._fogVisible=!1,o.overrideFog=!1,i.getOrCreateProgram(s,o),(this.stylesheet.terrain||this.stylesheet.projection&&"globe"===this.stylesheet.projection.name)&&(o.overrideRtt=!0,i.getOrCreateProgram(s,o)));}}}update(t){if(!this._loaded)return;this.ambientLight&&this.ambientLight.recalculate(t),this.directionalLight&&this.directionalLight.recalculate(t);const i=this.calculateLightsBrightness();t.brightness=i||0,i!==this._brightness&&(this._brightness=i,this.dispatcher.broadcast("setBrightness",i)),t.worldview!==this._worldview&&(this._worldview=t.worldview,this.dispatcher.broadcast("setWorldview",this._worldview));const o=this._changes.isDirty();let s=!1;if(this._changes.isDirty()){const e=this._changes.getLayerUpdatesByScope();for(const t in e){const{updatedIds:i,removedIds:o}=e[t];(i||o)&&(this._updateWorkerLayers(t,i,o),s=!0);}this.updateSourceCaches(),this._updateTilesForChangedImages(),this.updateLayers(t),this.light&&this.light.updateTransitions(t),this.ambientLight&&this.ambientLight.updateTransitions(t),this.directionalLight&&this.directionalLight.updateTransitions(t),this.fog&&this.fog.updateTransitions(t),this.snow&&this.snow.updateTransitions(t),this.rain&&this.rain.updateTransitions(t),this._changes.reset();}const r={};for(const e in this._mergedSourceCaches){const t=this._mergedSourceCaches[e];r[e]=t.used,t.used=!1,t.tileCoverLift=0;}for(const e of this._mergedOrder){const i=this._mergedLayers[e];if(i.recalculate(t,this._availableImages),!i.isHidden(t.zoom)){const e=this.getLayerSourceCache(i);e&&(e.used=!0,e.tileCoverLift=Math.max(e.tileCoverLift,i.tileCoverLift()));}!this._precompileDone&&this._shouldPrecompile&&("requestIdleCallback"in window?requestIdleCallback((()=>{this.precompilePrograms(i,t);})):this.precompilePrograms(i,t));}this._shouldPrecompile&&(this._precompileDone=!0),this.terrain&&s&&this.mergeLayers();const n=this.imageManager.getPendingImageProviders();for(const e of n)e.sourceCache.used=!0;for(const t in r){const i=this._mergedSourceCaches[t];r[t]!==i.used&&i.getSource().fire(new e.A("data",{sourceDataType:"visibility",dataType:"source",sourceId:i.getSource().id}));}this.light&&this.light.recalculate(t),this.terrain&&this.terrain.recalculate(t),this.fog&&this.fog.recalculate(t),this.snow&&this.snow.recalculate(t),this.rain&&this.rain.recalculate(t),this.z=t.zoom,this._markersNeedUpdate&&(this._updateMarkersOpacity(),this._markersNeedUpdate=!1),this.imageManager.clearUpdatedImages(this.scope),o&&this.fire(new e.A("data",{dataType:"style"}));}updateImageProviders(){const e=this.imageManager.getPendingImageProviders();for(const t of e){const e=t.resolvePendingRequests(),i=this.getFragmentStyle(t.scope);i&&i.addImages(e);}}_updateTilesForChangedImages(){const e={};for(const t in this._mergedSourceCaches){const i=this._mergedSourceCaches[t].getSource().scope;e[i]=e[i]||this._changes.getUpdatedImages(i),0!==e[i].length&&this._mergedSourceCaches[t].reloadTilesForDependencies(["icons","patterns"],e[i]);}for(const t in e)this._changes.resetUpdatedImages(t);}_updateWorkerLayers(e,t,i){const o=this.getFragmentStyle(e);o&&this.dispatcher.broadcast("updateLayers",{layers:t?o._serializeLayers(t):[],scope:e,removedIds:i||[],options:o.options});}setState(t,i){if(this._checkLoaded(),vo(this,me(t)))return !1;(t=e.d6(t)).layers=Pt(t.layers);const o=function(t,i){if(!t)return [{command:zt.setStyle,args:[i]}];let o=[];try{if(!e.bv(t.version,i.version))return [{command:zt.setStyle,args:[i]}];if(e.bv(t.center,i.center)||o.push({command:zt.setCenter,args:[i.center]}),e.bv(t.zoom,i.zoom)||o.push({command:zt.setZoom,args:[i.zoom]}),e.bv(t.bearing,i.bearing)||o.push({command:zt.setBearing,args:[i.bearing]}),e.bv(t.pitch,i.pitch)||o.push({command:zt.setPitch,args:[i.pitch]}),e.bv(t.sprite,i.sprite)||o.push({command:zt.setSprite,args:[i.sprite]}),e.bv(t.glyphs,i.glyphs)||o.push({command:zt.setGlyphs,args:[i.glyphs]}),e.bv(t.imports,i.imports)||function(t=[],i=[],o){i=i||[];const s=(t=t||[]).map(Nt),r=i.map(Nt),n=t.reduce(Ut,{}),a=i.reduce(Ut,{}),l=s.slice();let c,h,d,u;for(c=0,h=0;c<s.length;c++)d=s[c],a.hasOwnProperty(d)?h++:(o.push({command:zt.removeImport,args:[d]}),l.splice(l.indexOf(d,h),1));for(c=0,h=0;c<r.length;c++)d=r[r.length-1-c],l[l.length-1-c]!==d&&(n.hasOwnProperty(d)?(o.push({command:zt.removeImport,args:[d]}),l.splice(l.lastIndexOf(d,l.length-h),1)):h++,u=l[l.length-c],o.push({command:zt.addImport,args:[a[d],u]}),l.splice(l.length-c,0,d));for(const t of i){const i=n[t.id];i&&(delete i.data,e.bv(i,t)||o.push({command:zt.updateImport,args:[t.id,t]}));}}(t.imports,i.imports,o),e.bv(t.transition,i.transition)||o.push({command:zt.setTransition,args:[i.transition]}),e.bv(t.light,i.light)||o.push({command:zt.setLight,args:[i.light]}),e.bv(t.fog,i.fog)||o.push({command:zt.setFog,args:[i.fog]}),e.bv(t.snow,i.snow)||o.push({command:zt.setSnow,args:[i.snow]}),e.bv(t.rain,i.rain)||o.push({command:zt.setRain,args:[i.rain]}),e.bv(t.projection,i.projection)||o.push({command:zt.setProjection,args:[i.projection]}),e.bv(t.lights,i.lights)||o.push({command:zt.setLights,args:[i.lights]}),e.bv(t.camera,i.camera)||o.push({command:zt.setCamera,args:[i.camera]}),e.bv(t.iconsets,i.iconsets)||function(t,i,o){let s;for(s in i=i||{},t=t||{})t.hasOwnProperty(s)&&(i.hasOwnProperty(s)||o.push({command:zt.removeIconset,args:[s]}));for(s in i){if(!i.hasOwnProperty(s))continue;const r=i[s];t.hasOwnProperty(s)?e.bv(t[s],r)||(o.push({command:zt.removeIconset,args:[s]}),o.push({command:zt.addIconset,args:[s,r]})):o.push({command:zt.addIconset,args:[s,r]});}}(t.iconsets,i.iconsets,o),!e.bv(t["color-theme"],i["color-theme"]))return [{command:zt.setStyle,args:[i]}];const s={},r=[];!function(t,i,o,s){let r;for(r in i=i||{},t=t||{})t.hasOwnProperty(r)&&(i.hasOwnProperty(r)||Ot(r,o,s));for(r in i){if(!i.hasOwnProperty(r))continue;const n=i[r];t.hasOwnProperty(r)?e.bv(t[r],n)||("geojson"===t[r].type&&"geojson"===n.type&&Bt(t,i,r)?o.push({command:zt.setGeoJSONSourceData,args:[r,n.data]}):Ft(r,i,o,s)):Mt(r,i,o);}}(t.sources,i.sources,r,s);const n=[];t.layers&&t.layers.forEach((e=>{e.source&&s[e.source]?o.push({command:zt.removeLayer,args:[e.id]}):n.push(e);}));let a=t.terrain;a&&s[a.source]&&(o.push({command:zt.setTerrain,args:[void 0]}),a=void 0),o=o.concat(r),e.bv(a,i.terrain)||o.push({command:zt.setTerrain,args:[i.terrain]}),function(t,i,o){i=i||[];const s=(t=t||[]).map(Nt),r=i.map(Nt),n=t.reduce(Ut,{}),a=i.reduce(Ut,{}),l=s.slice(),c=Object.create(null);let h,d,u,_,p,f,m;for(h=0,d=0;h<s.length;h++)u=s[h],a.hasOwnProperty(u)?d++:(o.push({command:zt.removeLayer,args:[u]}),l.splice(l.indexOf(u,d),1));for(h=0,d=0;h<r.length;h++)u=r[r.length-1-h],l[l.length-1-h]!==u&&(n.hasOwnProperty(u)?(o.push({command:zt.removeLayer,args:[u]}),l.splice(l.lastIndexOf(u,l.length-d),1)):d++,f=l[l.length-h],o.push({command:zt.addLayer,args:[a[u],f]}),l.splice(l.length-h,0,u),c[u]=!0);for(h=0;h<r.length;h++)if(u=r[h],_=n[u],p=a[u],!c[u]&&!e.bv(_,p))if(e.bv(_.source,p.source)&&e.bv(_["source-layer"],p["source-layer"])&&e.bv(_.type,p.type)){for(m in kt(_.layout,p.layout,o,u,null,zt.setLayoutProperty),kt(_.paint,p.paint,o,u,null,zt.setPaintProperty),e.bv(_.slot,p.slot)||o.push({command:zt.setSlot,args:[u,p.slot]}),e.bv(_.filter,p.filter)||o.push({command:zt.setFilter,args:[u,p.filter]}),e.bv(_.minzoom,p.minzoom)&&e.bv(_.maxzoom,p.maxzoom)||o.push({command:zt.setLayerZoomRange,args:[u,p.minzoom,p.maxzoom]}),_)_.hasOwnProperty(m)&&"layout"!==m&&"paint"!==m&&"filter"!==m&&"metadata"!==m&&"minzoom"!==m&&"maxzoom"!==m&&"slot"!==m&&(0===m.indexOf("paint.")?kt(_[m],p[m],o,u,m.slice(6),zt.setPaintProperty):e.bv(_[m],p[m])||o.push({command:zt.setLayerProperty,args:[u,m,p[m]]}));for(m in p)p.hasOwnProperty(m)&&!_.hasOwnProperty(m)&&"layout"!==m&&"paint"!==m&&"filter"!==m&&"metadata"!==m&&"minzoom"!==m&&"maxzoom"!==m&&"slot"!==m&&(0===m.indexOf("paint.")?kt(_[m],p[m],o,u,m.slice(6),zt.setPaintProperty):e.bv(_[m],p[m])||o.push({command:zt.setLayerProperty,args:[u,m,p[m]]}));}else o.push({command:zt.removeLayer,args:[u]}),f=l[l.lastIndexOf(u)+1],o.push({command:zt.addLayer,args:[p,f]});}(n,i.layers,o);}catch(e){console.warn("Unable to compute style diff:",e),o=[{command:zt.setStyle,args:[i]}];}return o}(this.serialize(),t).filter((e=>!(e.command in xo)));if(0===o.length)return !1;const s=o.filter((e=>!(e.command in yo)));if(s.length>0)throw new Error(`Unimplemented: ${s.map((e=>e.command)).join(", ")}.`);const r=[];return o.forEach((e=>{r.push(this[e.command](...e.args));})),i&&Promise.all(r).then(i).catch(i),this.stylesheet=t,this.mergeAll(),this.dispatcher.broadcast("setLayers",{layers:this._serializeLayers(this._order),scope:this.scope,options:this.options}),!0}_updateWorkerImages(){this._availableImages=this.imageManager.listImages(this.scope),this.dispatcher.broadcast("setImages",{scope:this.scope,images:this._availableImages});}_updateWorkerModels(){this._availableModels=this.modelManager.getModelURIs(this.scope),this.dispatcher.broadcast("setModels",{scope:this.scope,models:this._availableModels});}addImages(t){for(const[i,o]of t.entries()){if(this.getImage(i))return this.fire(new e.z(new Error(`An image with the name "${i.name}" already exists.`)));this.imageManager.addImage(i,this.scope,o),this._changes.updateImage(i,this.scope);}return this._updateWorkerImages(),this.fire(new e.A("data",{dataType:"style"})),this}addImage(t,i){return this.getImage(t)?this.fire(new e.z(new Error(`An image with the name "${t.name}" already exists.`))):(this.imageManager.addImage(t,this.scope,i),this._changes.updateImage(t,this.scope),this._updateWorkerImages(),this.fire(new e.A("data",{dataType:"style"})),this)}updateImage(t,i,o=!1){this.imageManager.updateImage(t,this.scope,i),o&&(this._changes.updateImage(t,this.scope),this._updateWorkerImages(),this.fire(new e.A("data",{dataType:"style"})));}getImage(e){return this.imageManager.getImage(e,this.scope)}removeImage(t){return this.getImage(t)?(this.imageManager.removeImage(t,this.scope),this._changes.updateImage(t,this.scope),this._updateWorkerImages(),this.fire(new e.A("data",{dataType:"style"})),this):this.fire(new e.z(new Error("No image with this name exists.")))}listImages(){return this._checkLoaded(),this._availableImages.slice()}addModelURLs(t){return this.modelManager.addModelURLs(t,this.scope),this._updateWorkerModels(),this.fire(new e.A("data",{dataType:"style"})),this}addModel(t,i,o={}){return this._checkLoaded(),this._validate(Re,`models.${t}`,i,null,o)||(this.modelManager.addModel(t,i,this.scope),this.fire(new e.A("data",{dataType:"style"}))),this}hasModel(e){return this.modelManager.hasModel(e,this.scope)}removeModel(t){return this.hasModel(t)?(this.modelManager.removeModel(t,this.scope),this.fire(new e.A("data",{dataType:"style"})),this):this.fire(new e.z(new Error("No model with this ID exists.")))}listModels(){return this._checkLoaded(),this.modelManager.listModels(this.scope)}addSource(t,i,o={}){if(this._checkLoaded(),void 0!==this.getOwnSource(t))throw new Error(`There is already a source with ID "${t}".`);if(!i.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(i).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(i.type)>=0&&this._validate(ge,`sources.${t}`,i,null,o))return;this.map&&this.map._collectResourceTiming&&(i.collectResourceTiming=!0);const s=nt(t,i,this.dispatcher,this);s.scope=this.scope,s.setEventedParent(this,(()=>({isSourceLoaded:this._isSourceCacheLoaded(s.id),source:s.serialize(),sourceId:s.id})));const r=t=>{const i=(t?"symbol:":"other:")+s.id,o=e.C(i,this.scope),r=this._sourceCaches[i]=new It(o,s,t);(t?this._symbolSourceCaches:this._otherSourceCaches)[s.id]=r,r.onAdd(this.map);};r(!1),"vector"!==i.type&&"geojson"!==i.type||r(!0),s.onAdd&&s.onAdd(this.map),o.isInitialLoad||(this.mergeSources(),this._changes.setDirty());}removeSource(t){this._checkLoaded();const i=this.getOwnSource(t);if(!i)throw new Error("There is no source with this ID");for(const i in this._layers)if(this._layers[i].source===t)return this.fire(new e.z(new Error(`Source "${t}" cannot be removed while layer "${i}" is using it.`)));if(this.terrain&&this.terrain.scope===this.scope&&this.terrain.get().source===t)return this.fire(new e.z(new Error(`Source "${t}" cannot be removed while terrain is using it.`)));if(this.stylesheet.iconsets){const i=Object.entries(this.stylesheet.iconsets).find((([e,i])=>"source"===i.type&&i.source===t));if(i)return this.fire(new e.z(new Error(`Source "${t}" cannot be removed while iconset "${i[0]}" is using it.`)))}const o=this.getOwnSourceCaches(t);for(const t of o){const i=e.d7(t.id);delete this._sourceCaches[i],this._changes.discardSourceCacheUpdate(t.id),t.fire(new e.A("data",{sourceDataType:"metadata",dataType:"source",sourceId:t.getSource().id})),t.setEventedParent(null),t.clearTiles();}return delete this._otherSourceCaches[t],delete this._symbolSourceCaches[t],this.mergeSources(),i.setEventedParent(null),i.onRemove&&i.onRemove(this.map),this._changes.setDirty(),this}setGeoJSONSourceData(e,t){this._checkLoaded(),this.getOwnSource(e).setData(t),this._changes.setDirty();}getOwnSource(e){const t=this.getOwnSourceCache(e);return t&&t.getSource()}getOwnSources(){const e=[];for(const t in this._otherSourceCaches){const i=this.getOwnSourceCache(t);i&&e.push(i.getSource());}return e}areTilesLoaded(){const e=this._mergedSourceCaches;for(const t in e){const i=e[t]._tiles;for(const e in i){const t=i[e];if("loaded"!==t.state&&"errored"!==t.state)return !1}}return !0}setLights(t){if(this._checkLoaded(),!t)return delete this.ambientLight,void delete this.directionalLight;const i=this._getTransitionParameters();for(const o of t){if(this._validate(ye,"lights",o))return;switch(o.type){case "ambient":if(this.ambientLight){const e=this.ambientLight;e.set(o),e.updateTransitions(i);}else this.ambientLight=new $e(o,qe||(qe=new e.a7({color:new e.a8(e.a5.properties_light_ambient.color),"color-use-theme":new e.a8({type:"string",default:"default","property-type":"data-constant"}),intensity:new e.a8(e.a5.properties_light_ambient.intensity)})),this.scope,this.options);break;case "directional":if(this.directionalLight){const e=this.directionalLight;e.set(o),e.updateTransitions(i);}else this.directionalLight=new $e(o,Ze||(Ze=new e.a7({direction:new e.an(e.a5.properties_light_directional.direction),color:new e.a8(e.a5.properties_light_directional.color),"color-use-theme":new e.a8({type:"string",default:"default","property-type":"data-constant"}),intensity:new e.a8(e.a5.properties_light_directional.intensity),"cast-shadows":new e.a8(e.a5.properties_light_directional["cast-shadows"]),"shadow-quality":new e.a8(e.a5.properties_light_directional["shadow-quality"]),"shadow-intensity":new e.a8(e.a5.properties_light_directional["shadow-intensity"])})),this.scope,this.options);}}const o=Object.assign(i,{worldview:this.map.getWorldview()}),s=new e.aa(this.z||0,o);this.ambientLight&&this.ambientLight.recalculate(s),this.directionalLight&&this.directionalLight.recalculate(s),this._brightness=this.calculateLightsBrightness(),this.dispatcher.broadcast("setBrightness",this._brightness);}calculateLightsBrightness(){const t=this.directionalLight,i=this.ambientLight;if(!t||!i)return;const o=e=>.2126*(e[0]<=.03928?e[0]/12.92:Math.pow((e[0]+.055)/1.055,2.4))+.7152*(e[1]<=.03928?e[1]/12.92:Math.pow((e[1]+.055)/1.055,2.4))+.0722*(e[2]<=.03928?e[2]/12.92:Math.pow((e[2]+.055)/1.055,2.4)),s=t.properties.get("color").toNonPremultipliedRenderColor(null).toArray01(),r=t.properties.get("intensity"),n=t.properties.get("direction"),a=1-e.cR(n.x,n.y,n.z)[2]/90,l=o(s)*r*a,c=i.properties.get("color").toNonPremultipliedRenderColor(null).toArray01(),h=i.properties.get("intensity"),d=o(c)*h;return Number(((l+d)/2).toFixed(6))}getBrightness(){return this._brightness}getLights(){if(!this.enable3dLights())return null;const e=[];return this.directionalLight&&e.push(this.directionalLight.get()),this.ambientLight&&e.push(this.ambientLight.get()),e}enable3dLights(){return !!this.ambientLight&&!!this.directionalLight}getFragmentStyle(t){if(null==t||""===t&&this.isRootStyle())return this;if(e.d8(t)){const i=e.d9(t),o=this.fragments.find((({id:e})=>e===i));if(!o)return;const s=e.d7(t);return o.style.getFragmentStyle(s)}{const e=this.fragments.find((({id:e})=>e===t));return e?e.style:void 0}}setFeaturesetSelectors(t){if(!t)return;const i={},o=(e,t="")=>`${e}::${t}`;this._featuresetSelectors={};for(const s in t){const r=this._featuresetSelectors[s]=[];for(const n of t[s].selectors){if(n.featureNamespace){const t=this.getOwnLayer(n.layer);if(!t){e.w(`Layer is undefined for selector: ${n.layer}`);continue}const r=o(t.source,t.sourceLayer);if(r in i&&i[r]!==n.featureNamespace){e.w(`"featureNamespace ${n.featureNamespace} of featureset ${s}'s selector is not associated to the same source, skip this selector`);continue}i[r]=n.featureNamespace;}let t;if(n.properties)for(const i in n.properties){const o=e.X(n.properties[i]);"success"===o.result&&(t=t||{},t[i]=o.value);}r.push({layerId:n.layer,namespace:n.featureNamespace,properties:t,uniqueFeatureID:n._uniqueFeatureID});}}}getFeaturesetDescriptors(e){const t=this.getFragmentStyle(e);if(!t||!t.stylesheet.featuresets)return [];const i=[];for(const e in t.stylesheet.featuresets)i.push({featuresetId:e,importId:t.scope?t.scope:void 0});return i}getFeaturesetLayers(t,i){const o=this.getFragmentStyle(i),s=o.stylesheet.featuresets;if(!s||!s[t])return this.fire(new e.z(new Error(`The featureset '${t}' does not exist in the map's style and cannot be queried.`))),[];const r=[];for(const e of s[t].selectors){const t=o.getOwnLayer(e.layer);t&&r.push(t);}return r}getConfigProperty(t,i){const o=this.getFragmentStyle(t);if(!o)return null;const s=e.C(i,o.scope),r=o.options.get(s),n=r?r.value||r.default:null;return n?n.serialize():null}setConfigProperty(t,i,o){const s=this.getFragmentStyle(t);if(!s)return;const r=s.stylesheet.indoor?_o(s.stylesheet.schema):s.stylesheet.schema;if(!r||!r[i])return;const n=e.X(o);if("success"!==n.result)return void vo(this,n.value);const a=n.value.expression,l=e.C(i,s.scope),c=s.options.get(l);if(!c)return;let h;const{minValue:d,maxValue:u,stepValue:_,type:p,values:f}=r[i],m=e.X(r[i].default);"success"===m.result&&(h=m.value.expression),h?(this.options.set(l,Object.assign({},c,{value:a,default:h,minValue:d,maxValue:u,stepValue:_,type:p,values:f})),this.updateConfigDependencies(i)):this.fire(new e.z(new Error(`No schema defined for the config option "${i}" in the "${t}" fragment.`)));}getConfig(t){const i=this.getFragmentStyle(t);if(!i)return null;const o=i.stylesheet.schema;if(!o)return null;const s={};for(const t in o){const o=e.C(t,i.scope),r=i.options.get(o),n=r?r.value||r.default:null;s[t]=n?n.serialize():null;}return s}setConfig(e,t){const i=this.getFragmentStyle(e);i&&(i.updateConfig(t,i.stylesheet.schema),this.updateConfigDependencies());}getSchema(e){const t=this.getFragmentStyle(e);return t?t.stylesheet.schema:null}setSchema(e,t){const i=this.getFragmentStyle(e);i&&(i.stylesheet.schema=t,i.updateConfig(i._config,t),this.updateConfigDependencies());}updateConfig(t,i){if(this._config=t,t||i)if(i)for(const o in i){let s,r;const n=e.X(i[o].default);if("success"===n.result&&(s=n.value.expression),t&&void 0!==t[o]){const i=e.X(t[o]);"success"===i.result&&(r=i.value.expression);}const{minValue:a,maxValue:l,stepValue:c,type:h,values:d}=i[o];if(s){const t=e.C(o,this.scope);this.options.set(t,{default:s,value:r,minValue:a,maxValue:l,stepValue:c,type:h,values:d});}else this.fire(new e.z(new Error(`No schema defined for config option "${o}".`)));}else this.fire(new e.z(new Error("Attempting to set config for a style without schema.")));}updateConfigDependencies(e){for(const t of this._configDependentLayers){const i=this.getLayer(t);if(i){if(e&&!i.configDependencies.has(e))continue;i.possiblyEvaluateVisibility(),this._updateLayer(i);}}this.ambientLight&&this.ambientLight.updateConfig(this.options),this.directionalLight&&this.directionalLight.updateConfig(this.options),this.fog&&this.fog.updateConfig(this.options),this.snow&&this.snow.updateConfig(this.options),this.rain&&this.rain.updateConfig(this.options),this.forEachFragmentStyle((e=>{const t=e._styleColorTheme.colorThemeOverride?e._styleColorTheme.colorThemeOverride:e._styleColorTheme.colorTheme;if(t){const i=e._evaluateColorThemeData(t);(!e._styleColorTheme.lut&&""!==i||e._styleColorTheme.lut&&i!==e._styleColorTheme.lut.data)&&e.setColorTheme(t);}})),this._changes.setDirty();}addLayer(t,i,o={}){this._checkLoaded();const s=t.id;if(this._layers[s])return void this.fire(new e.z(new Error(`Layer with id "${s}" already exists on this map`)));let r;if("custom"===t.type){if(vo(this,e.da(t)))return;r=e.db(t,this.scope,this._styleColorTheme.lut,this.options);}else {if("object"==typeof t.source&&(this.addSource(s,t.source),t=e.d6(t),t=e.h(t,{source:s})),this._validate(Ee,`layers.${s}`,t,{arrayIndex:-1},o))return;r=e.db(t,this.scope,this._styleColorTheme.lut,this.options),this._validateLayer(r),r.setEventedParent(this,{layer:{id:s}});}0!==r.configDependencies.size&&this._configDependentLayers.add(r.fqid);let n=this._order.length;if(i){const t=this._order.indexOf(i);if(-1===t)return void this.fire(new e.z(new Error(`Layer with id "${i}" does not exist on this map.`)));r.slot===this._layers[i].slot?n=t:e.w(`Layer with id "${i}" has a different slot. Layers can only be rearranged within the same slot.`);}this._order.splice(n,0,s),this._layerOrderChanged=!0,this._layers[s]=r;const a=this.getOwnLayerSourceCache(r),l=!!this.directionalLight&&this.directionalLight.shadowsEnabled();a&&r.canCastShadows()&&l&&(a.castsShadows=!0);const c=this._changes.getRemovedLayer(r);if(c&&r.source&&a&&"custom"!==r.type){this._changes.discardLayerRemoval(r);const t=e.C(r.source,r.scope);c.type!==r.type?this._changes.updateSourceCache(t,"clear"):(this._changes.updateSourceCache(t,"reload"),a.pause());}this._updateLayer(r),r.onAdd&&r.onAdd(this.map),r.scope=this.scope,this.mergeLayers();}moveLayer(t,i){this._checkLoaded();const o=this._checkLayer(t);if(!o)return;if(t===i)return;const s=this._order.indexOf(t);this._order.splice(s,1);let r=this._order.length;if(i){const t=this._order.indexOf(i);if(-1===t)return void this.fire(new e.z(new Error(`Layer with id "${i}" does not exist on this map.`)));o.slot===this._layers[i].slot?r=t:e.w(`Layer with id "${i}" has a different slot. Layers can only be rearranged within the same slot.`);}this._order.splice(r,0,t),this._changes.setDirty(),this._layerOrderChanged=!0,this.mergeLayers();}removeLayer(e){this._checkLoaded();const t=this._checkLayer(e);if(!t)return;t.setEventedParent(null);const i=this._order.indexOf(e);this._order.splice(i,1),delete this._layers[e],this._changes.setDirty(),this._layerOrderChanged=!0,this._configDependentLayers.delete(t.fqid),this._changes.removeLayer(t);const o=this.getOwnLayerSourceCache(t);if(o&&o.castsShadows){let e=!1;for(const i in this._layers)if(this._layers[i].source===t.source&&this._layers[i].canCastShadows()){e=!0;break}o.castsShadows=e;}t.onRemove&&t.onRemove(this.map),this.mergeLayers();}getOwnLayer(e){return this._layers[e]}hasLayer(e){return e in this._mergedLayers}hasLayerType(e){for(const t in this._layers)if(this._layers[t].type===e)return !0;return !1}setLayerZoomRange(e,t,i){this._checkLoaded();const o=this._checkLayer(e);o&&(o.minzoom===t&&o.maxzoom===i||(null!=t&&(o.minzoom=t),null!=i&&(o.maxzoom=i),this._updateLayer(o)));}getSlots(){return this._checkLoaded(),this._mergedSlots}setSlot(e,t){this._checkLoaded();const i=this._checkLayer(e);i&&i.slot!==t&&(i.slot=t,this._updateLayer(i));}setFilter(t,i,o={}){this._checkLoaded();const s=this._checkLayer(t);if(s&&!e.bv(s.filter,i))return null==i?(s.filter=void 0,void this._updateLayer(s)):void(this._validate(Se,`layers.${s.id}.filter`,i,{layerType:s.type},o)||(s.filter=e.d6(i),this._updateLayer(s)))}getFilter(t){const i=this._checkLayer(t);if(i)return e.d6(i.filter)}setLayoutProperty(t,i,o,s={}){this._checkLoaded();const r=this._checkLayer(t);if(r&&!e.bv(r.getLayoutProperty(i),o)){if(null!=o&&(!s||!1!==s.validate)&&vo(r,Ce.call(me,{key:`layers.${t}.layout.${i}`,layerType:r.type,objectKey:i,value:o,styleSpec:e.a5,style:{glyphs:!0,sprite:!0}})))return;r.setLayoutProperty(i,o),0!==r.configDependencies.size&&this._configDependentLayers.add(r.fqid),this._updateLayer(r);}}getLayoutProperty(e,t){const i=this._checkLayer(e);if(i)return i.getLayoutProperty(t)}setPaintProperty(t,i,o,s={}){this._checkLoaded();const r=this._checkLayer(t);if(!r)return;if(e.bv(r.getPaintProperty(i),o))return;if(null!=o&&(!s||!1!==s.validate)&&vo(r,Ie.call(me,{key:`layers.${t}.paint.${i}`,layerType:r.type,objectKey:i,value:o,styleSpec:e.a5})))return;const n=r.setPaintProperty(i,o);0!==r.configDependencies.size&&this._configDependentLayers.add(r.fqid),n&&this._updateLayer(r),this._changes.updatePaintProperties(r);}getPaintProperty(e,t){const i=this._checkLayer(e);if(i)return i.getPaintProperty(t)}setFeatureState(t,i){if(this._checkLoaded(),"target"in t){if("featuresetId"in t.target){const{featuresetId:e,importId:o}=t.target,s=this.getFragmentStyle(o),r=s.getFeaturesetLayers(e);for(const{source:e,sourceLayer:o}of r)s.setFeatureState({id:t.id,source:e,sourceLayer:o},i);}else if("layerId"in t.target){const{layerId:e}=t.target,o=this.getLayer(e);this.setFeatureState({id:t.id,source:o.source,sourceLayer:o.sourceLayer},i);}return}const o=t.source,s=t.sourceLayer,r=this._checkSource(o);if(!r)return;const n=r.type;if("geojson"===n&&s)return void this.fire(new e.z(new Error("GeoJSON sources cannot have a sourceLayer parameter.")));if("vector"===n&&!s)return void this.fire(new e.z(new Error("The sourceLayer parameter must be provided for vector source types.")));void 0===t.id&&this.fire(new e.z(new Error("The feature id parameter must be provided.")));const a=this.getOwnSourceCaches(o);for(const e of a)e.setFeatureState(s,t.id,i);}removeFeatureState(t,i){if(this._checkLoaded(),"target"in t){if("featuresetId"in t.target){const{featuresetId:e,importId:o}=t.target,s=this.getFragmentStyle(o),r=s.getFeaturesetLayers(e);for(const{source:e,sourceLayer:o}of r)s.removeFeatureState({id:t.id,source:e,sourceLayer:o},i);}else if("layerId"in t.target){const{layerId:e}=t.target,o=this.getLayer(e);this.removeFeatureState({id:t.id,source:o.source,sourceLayer:o.sourceLayer},i);}return}const o=t.source,s=this._checkSource(o);if(!s)return;const r=s.type,n="vector"===r?t.sourceLayer:void 0;if("vector"===r&&!n)return void this.fire(new e.z(new Error("The sourceLayer parameter must be provided for vector source types.")));if(i&&"string"!=typeof t.id&&"number"!=typeof t.id)return void this.fire(new e.z(new Error("A feature id is required to remove its specific state property.")));const a=this.getOwnSourceCaches(o);for(const e of a)e.removeFeatureState(n,t.id,i);}getFeatureState(t){if(this._checkLoaded(),"target"in t){let i;if("featuresetId"in t.target){const{featuresetId:o,importId:s}=t.target,r=this.getFragmentStyle(s),n=r.getFeaturesetLayers(o);for(const{source:o,sourceLayer:s}of n){const n=r.getFeatureState({id:t.id,source:o,sourceLayer:s});if(n&&!i)i=n;else if(!e.bv(i,n))return void this.fire(new e.z(new Error("The same feature id exists in multiple sources in the featureset, but their feature states are not consistent through the sources.")))}}else if("layerId"in t.target){const{layerId:e}=t.target,o=this.getLayer(e);i=this.getFeatureState({id:t.id,source:o.source,sourceLayer:o.sourceLayer});}return i}const i=t.source,o=t.sourceLayer,s=this._checkSource(i);if(s){if("vector"!==s.type||o)return void 0===t.id&&this.fire(new e.z(new Error("The feature id parameter must be provided."))),this.getOwnSourceCaches(i)[0].getFeatureState(o,t.id);this.fire(new e.z(new Error("The sourceLayer parameter must be provided for vector source types.")));}}setTransition(t){return this.stylesheet.transition=e.h({},this.stylesheet.transition,t),this.transition=this.stylesheet.transition,this}getTransition(){return e.h({},this.stylesheet.transition)}serialize(){this._checkLoaded();const t=this.getTerrain(),i=t&&this.terrain&&this.terrain.scope===this.scope?t:this.stylesheet.terrain;return e.dc({version:this.stylesheet.version,name:this.stylesheet.name,metadata:this.stylesheet.metadata,fragment:this.stylesheet.fragment,iconsets:this.stylesheet.iconsets,imports:this._serializeImports(),schema:this.stylesheet.schema,camera:this.stylesheet.camera,light:this.stylesheet.light,lights:this.stylesheet.lights,terrain:i,fog:this.stylesheet.fog,snow:this.stylesheet.snow,rain:this.stylesheet.rain,center:this.stylesheet.center,"color-theme":this.stylesheet["color-theme"],zoom:this.stylesheet.zoom,bearing:this.stylesheet.bearing,pitch:this.stylesheet.pitch,sprite:this.stylesheet.sprite,glyphs:this.stylesheet.glyphs,transition:this.stylesheet.transition,projection:this.stylesheet.projection,sources:this._serializeSources(),layers:this._serializeLayers(this._order)},(e=>void 0!==e))}_updateFilteredLayers(e){for(const t of Object.values(this._mergedLayers))e(t)&&this._updateLayer(t);}_updateLayer(t){this._changes.updateLayer(t);const i=this.getLayerSourceCache(t),o=e.C(t.source,t.scope),s=this._changes.getUpdatedSourceCaches();t.source&&!s[o]&&i&&"raster"!==i.getSource().type&&(this._changes.updateSourceCache(o,"reload"),i.pause()),t.invalidateCompiledFilter();}_flattenAndSortRenderedFeatures(e){const t=e=>this._mergedLayers[e].is3D(!!this.terrain),i=this.order,o={},s=[];for(let r=i.length-1;r>=0;r--){const n=i[r];if(t(n)){o[n]=r;for(const t of e){const e=t[n];if(e)for(const t of e)s.push(t);}}}s.sort(((e,t)=>t.intersectionZ-e.intersectionZ));const r=[];for(let n=i.length-1;n>=0;n--){const a=i[n];if(t(a))for(let e=s.length-1;e>=0;e--){const t=s[e].feature;if(t.layer&&o[t.layer.id]<n)break;r.push(t),s.pop();}else for(const t of e){const e=t[a];if(e)for(const t of e)r.push(t.feature);}}return r}queryRenderedFeatures(t,i,o){let s;i&&!Array.isArray(i)&&i.filter&&(this._validate(Se,"queryRenderedFeatures.filter",i.filter,null,i),s=e.b3(i.filter));const r={},n=e=>{if(bo.has(e.type))return;const t=this.getOwnLayerSourceCache(e),i=r[t.id]=r[t.id]||{sourceCache:t,layers:{},has3DLayers:!1};e.is3D(!!this.terrain)&&(i.has3DLayers=!0),i.layers[e.fqid]=i.layers[e.fqid]||{styleLayer:e,targets:[]},i.layers[e.fqid].targets.push({filter:s});};if(i&&i.layers){if(!Array.isArray(