<?php
/**
 * Theme functions and definitions.
 *
 * For additional information on potential customization options,
 * read the developers' documentation:
 *
 * https://developers.elementor.com/docs/hello-elementor-theme/
 *
 * @package HelloElementorChild
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'HELLO_ELEMENTOR_CHILD_VERSION', '2.0.0' );

/**
 * Load child theme scripts & styles.
 *
 * @return void
 */
function hello_elementor_child_scripts_styles() {

	wp_enqueue_style(
		'hello-elementor-child-style',
		get_stylesheet_directory_uri() . '/style.css',
		[
			'hello-elementor-theme-style',
		],
		HELLO_ELEMENTOR_CHILD_VERSION
	);

}
add_action( 'wp_enqueue_scripts', 'hello_elementor_child_scripts_styles', 20 );

add_shortcode('date_plus_days', function($atts) {
    $a = shortcode_atts(array(
        'days' => 4,
        'format' => 'd/m/Y',
    ), $atts);
    return date($a['format'], strtotime('+' . intval($a['days']) . ' days'));
});

// ג

add_shortcode('jetengine_phone_link', function($atts = []) {
    // תמשוך את המספר לפי איך שהוא נשמר אצלך
    $phone = get_option('contact-info_phone'); // שם מדויק בטבלת options
    if (!$phone) return '';
    $tel = preg_replace('/\D+/', '', $phone);
    // תוכל להחליף כאן את הטקסט לפני/אחרי המספר איך שבא לך
    return 'Fill out the form below or call us at <a href="tel:' . $tel . '">' . esc_html($phone) . '</a> and schedule your free consultation!';
});


