<?php
/**
 * Custom post types and taxonomies.
 *
 * @package ACE_Theme
 * @since 1.0.0
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Register custom post types and taxonomies.
 *
 * @since 1.0.0
 * @return void
 */
function ace_register_post_types() {
	// Portfolio Projects CPT.
	$labels = array(
		'name'               => __( 'Projects', 'ace-theme' ),
		'singular_name'      => __( 'Project', 'ace-theme' ),
		'menu_name'          => __( 'Portfolio', 'ace-theme' ),
		'add_new'            => __( 'Add New Project', 'ace-theme' ),
		'add_new_item'       => __( 'Add New Project', 'ace-theme' ),
		'edit_item'          => __( 'Edit Project', 'ace-theme' ),
		'new_item'           => __( 'New Project', 'ace-theme' ),
		'view_item'          => __( 'View Project', 'ace-theme' ),
		'search_items'       => __( 'Search Projects', 'ace-theme' ),
		'not_found'          => __( 'No projects found', 'ace-theme' ),
		'not_found_in_trash' => __( 'No projects found in trash', 'ace-theme' ),
	);

	register_post_type( 'ace_project', array(
		'labels'        => $labels,
		'public'        => true,
		'has_archive'   => false,
		'menu_icon'     => 'dashicons-portfolio',
		'supports'      => array( 'title', 'editor', 'thumbnail', 'custom-fields' ),
		'rewrite'       => array( 'slug' => 'project' ),
		'show_in_rest'  => true,
		'menu_position' => 5,
	) );

	// Project Category Taxonomy.
	$tax_labels = array(
		'name'          => __( 'Project Categories', 'ace-theme' ),
		'singular_name' => __( 'Project Category', 'ace-theme' ),
		'search_items'  => __( 'Search Categories', 'ace-theme' ),
		'all_items'     => __( 'All Categories', 'ace-theme' ),
		'edit_item'     => __( 'Edit Category', 'ace-theme' ),
		'update_item'   => __( 'Update Category', 'ace-theme' ),
		'add_new_item'  => __( 'Add New Category', 'ace-theme' ),
		'new_item_name' => __( 'New Category Name', 'ace-theme' ),
		'menu_name'     => __( 'Categories', 'ace-theme' ),
	);

	register_taxonomy( 'project_category', 'ace_project', array(
		'labels'            => $tax_labels,
		'hierarchical'      => true,
		'public'            => true,
		'rewrite'           => array( 'slug' => 'project-category' ),
		'show_in_rest'      => true,
		'show_admin_column' => true,
	) );
}
add_action( 'init', 'ace_register_post_types' );

/**
 * Flush rewrite rules on theme activation.
 *
 * @since 1.0.0
 * @return void
 */
function ace_rewrite_flush() {
	ace_register_post_types();
	flush_rewrite_rules();
}
add_action( 'after_switch_theme', 'ace_rewrite_flush' );
