<?php
/**
 * Enqueue scripts and styles.
 *
 * @package ACE_Theme
 * @since 1.0.0
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Enqueue front-end scripts and styles.
 *
 * @since 1.0.0
 * @return void
 */
function ace_enqueue_scripts() {
	// Google Fonts - preconnect.
	wp_enqueue_style( 'ace-google-fonts-preconnect', 'https://fonts.googleapis.com', array(), null );

	// Google Fonts.
	wp_enqueue_style(
		'ace-google-fonts',
		'https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Playfair+Display:wght@400;700&display=swap',
		array(),
		null
	);

	// Font Awesome (for mega menu icons).
	wp_enqueue_style( 'ace-font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css', array(), '6.5.1' );

	// Main stylesheet.
	wp_enqueue_style( 'ace-main', ACE_THEME_URI . '/assets/css/main.css', array(), ACE_THEME_VERSION );

	// Main script - no jQuery dependency.
	wp_enqueue_script( 'ace-main', ACE_THEME_URI . '/assets/js/main.js', array(), ACE_THEME_VERSION, true );

	// Form handler.
	wp_enqueue_script( 'ace-form-handler', ACE_THEME_URI . '/assets/js/form-handler.js', array(), ACE_THEME_VERSION, true );

	// Localize form handler with AJAX URL and nonce.
	wp_localize_script( 'ace-form-handler', 'aceForm', array(
		'ajaxUrl' => admin_url( 'admin-ajax.php' ),
		'nonce'   => wp_create_nonce( 'ace_lead_form_nonce' ),
	) );

	// Comment reply script (conditional).
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'ace_enqueue_scripts' );

/**
 * Add preconnect resource hint for Google Fonts.
 *
 * @since 1.0.0
 * @param array  $urls          Array of URLs to preconnect.
 * @param string $relation_type The relation type (preconnect, dns-prefetch, etc.).
 * @return array Modified array of URLs.
 */
function ace_preconnect_google_fonts( $urls, $relation_type ) {
	if ( 'preconnect' === $relation_type ) {
		$urls[] = array(
			'href'        => 'https://fonts.gstatic.com',
			'crossorigin' => 'anonymous',
		);
	}
	return $urls;
}
add_filter( 'wp_resource_hints', 'ace_preconnect_google_fonts', 10, 2 );

/**
 * Add defer attribute to theme scripts.
 *
 * @since 1.0.0
 * @param string $tag    The script tag HTML.
 * @param string $handle The script handle.
 * @param string $src    The script source URL.
 * @return string Modified script tag.
 */
function ace_defer_scripts( $tag, $handle, $src ) {
	$defer_handles = array( 'ace-main', 'ace-form-handler' );
	if ( in_array( $handle, $defer_handles, true ) ) {
		return str_replace( ' src', ' defer src', $tag );
	}
	return $tag;
}
add_filter( 'script_loader_tag', 'ace_defer_scripts', 10, 3 );
