<?php
/**
 * Template Name: Contact Page
 * @package ACE_Theme
 */
get_header();
?>

<!-- Hero -->
<section class="page-hero page-hero-sm">
    <div class="page-hero-overlay">
        <div class="container">
            <h1 class="page-hero-title"><?php esc_html_e( 'Contact ACE Design & Build', 'ace-theme' ); ?></h1>
        </div>
    </div>
</section>

<!-- Contact Section -->
<section class="section bg-white">
    <div class="container">
        <div class="contact-grid">
            <!-- Left: Contact Info -->
            <div class="contact-info">
                <h2><?php esc_html_e( 'Get in Touch', 'ace-theme' ); ?></h2>
                <p><?php esc_html_e( 'Ready to start your project? Have questions? We\'d love to hear from you. Fill out the form or reach us directly - we respond within 2 hours during business hours.', 'ace-theme' ); ?></p>

                <div class="contact-details">
                    <div class="contact-detail-item">
                        <?php echo ace_icon( 'map-pin', 22 ); ?>
                        <div>
                            <strong><?php esc_html_e( 'Visit Us', 'ace-theme' ); ?></strong>
                            <a href="https://maps.google.com/?q=<?php echo urlencode( ace_get_address() ); ?>" target="_blank" rel="noopener noreferrer">
                                <?php echo esc_html( ace_get_address() ); ?>
                            </a>
                        </div>
                    </div>
                    <div class="contact-detail-item">
                        <?php echo ace_icon( 'phone', 22 ); ?>
                        <div>
                            <strong><?php esc_html_e( 'Call Us', 'ace-theme' ); ?></strong>
                            <a href="<?php echo esc_url( ace_get_phone_link() ); ?>"><?php echo esc_html( ace_get_phone() ); ?></a>
                        </div>
                    </div>
                    <div class="contact-detail-item">
                        <?php echo ace_icon( 'email', 22 ); ?>
                        <div>
                            <strong><?php esc_html_e( 'Email Us', 'ace-theme' ); ?></strong>
                            <a href="mailto:<?php echo esc_attr( ace_get_email() ); ?>"><?php echo esc_html( ace_get_email() ); ?></a>
                        </div>
                    </div>
                    <div class="contact-detail-item">
                        <?php echo ace_icon( 'clock', 22 ); ?>
                        <div>
                            <strong><?php esc_html_e( 'Business Hours', 'ace-theme' ); ?></strong>
                            <span><?php echo esc_html( ace_get_hours() ); ?></span>
                        </div>
                    </div>
                </div>

                <!-- Google Map -->
                <?php $map_embed = ace_get_option( 'google_maps_embed', '' ); ?>
                <?php if ( $map_embed ) : ?>
                    <div class="contact-map">
                        <?php echo $map_embed; // phpcs:ignore WordPress.Security.EscapeOutput ?>
                    </div>
                <?php else : ?>
                    <div class="contact-map contact-map-placeholder">
                        <?php echo ace_icon( 'map-pin', 48 ); ?>
                        <p><?php esc_html_e( 'Los Angeles, California', 'ace-theme' ); ?></p>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Right: Lead Form -->
            <div class="contact-form-wrapper">
                <?php get_template_part( 'template-parts/lead-form', null, array( 'form_id' => 'contact-lead-form' ) ); ?>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>
