<?php
/**
 * Template Name: Portfolio Page
 * @package ACE_Theme
 */
get_header();
?>

<!-- Hero -->
<section class="page-hero">
    <div class="page-hero-overlay">
        <div class="container">
            <h1 class="page-hero-title"><?php esc_html_e( 'Our Work', 'ace-theme' ); ?></h1>
            <p class="page-hero-subtitle"><?php esc_html_e( 'Browse our portfolio of completed projects across Los Angeles.', 'ace-theme' ); ?></p>
        </div>
    </div>
</section>

<!-- Filterable Gallery -->
<section class="section bg-white">
    <div class="container">
        <!-- Filter Tabs -->
        <div class="portfolio-filters">
            <button class="filter-btn active" data-filter="all"><?php esc_html_e( 'All', 'ace-theme' ); ?></button>
            <?php
            $categories = get_terms( array(
                'taxonomy'   => 'project_category',
                'hide_empty' => true,
            ) );
            if ( ! is_wp_error( $categories ) && ! empty( $categories ) ) :
                foreach ( $categories as $cat ) : ?>
                    <button class="filter-btn" data-filter="<?php echo esc_attr( $cat->slug ); ?>"><?php echo esc_html( $cat->name ); ?></button>
                <?php endforeach;
            else :
                // Show default filter tabs even without posts
                $default_cats = array( 'kitchen', 'bathroom', 'full-home', 'adu', 'additions', 'outdoor', 'pool' );
                $default_labels = array( 'Kitchen', 'Bathroom', 'Full Home', 'ADU', 'Additions', 'Outdoor', 'Pool' );
                foreach ( $default_cats as $i => $slug ) : ?>
                    <button class="filter-btn" data-filter="<?php echo esc_attr( $slug ); ?>"><?php echo esc_html( $default_labels[ $i ] ); ?></button>
                <?php endforeach;
            endif; ?>
        </div>

        <!-- Projects Grid -->
        <div class="portfolio-grid">
            <?php
            $projects = new WP_Query( array(
                'post_type'      => 'ace_project',
                'posts_per_page' => -1,
                'orderby'        => 'date',
                'order'          => 'DESC',
            ) );

            if ( $projects->have_posts() ) :
                while ( $projects->have_posts() ) : $projects->the_post();
                    $cats = get_the_terms( get_the_ID(), 'project_category' );
                    $cat_slugs = array();
                    $cat_name = '';
                    if ( $cats && ! is_wp_error( $cats ) ) {
                        foreach ( $cats as $cat ) {
                            $cat_slugs[] = $cat->slug;
                        }
                        $cat_name = $cats[0]->name;
                    }
                    $location = get_post_meta( get_the_ID(), '_ace_project_location', true );
                    ?>
                    <div class="portfolio-item" data-categories="<?php echo esc_attr( implode( ',', $cat_slugs ) ); ?>">
                        <div class="project-card">
                            <a href="<?php the_permalink(); ?>" class="project-card-link">
                                <div class="project-card-image">
                                    <?php if ( has_post_thumbnail() ) : ?>
                                        <?php the_post_thumbnail( 'ace-portfolio', array( 'loading' => 'lazy' ) ); ?>
                                    <?php else : ?>
                                        <div class="image-placeholder">
                                            <?php echo ace_icon( 'home', 48 ); ?>
                                        </div>
                                    <?php endif; ?>
                                    <div class="project-card-overlay">
                                        <?php if ( $cat_name ) : ?>
                                            <span class="project-category"><?php echo esc_html( $cat_name ); ?></span>
                                        <?php endif; ?>
                                        <h3><?php the_title(); ?></h3>
                                        <?php if ( $location ) : ?>
                                            <span class="project-location"><?php echo ace_icon( 'map-pin', 14 ); ?> <?php echo esc_html( $location ); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                <?php endwhile;
                wp_reset_postdata();
            else :
                // Placeholder projects
                $placeholders = array(
                    array( 'title' => 'Modern Kitchen Transformation', 'cat' => 'Kitchen Remodel', 'location' => 'Beverly Hills, CA' ),
                    array( 'title' => 'Complete Home Renovation', 'cat' => 'Full Home Remodel', 'location' => 'Santa Monica, CA' ),
                    array( 'title' => 'Luxury ADU Build', 'cat' => 'ADU Construction', 'location' => 'Encino, CA' ),
                    array( 'title' => 'Resort-Style Backyard', 'cat' => 'Outdoor Living', 'location' => 'Pacific Palisades, CA' ),
                    array( 'title' => 'Spa-Inspired Bathroom', 'cat' => 'Bathroom Remodel', 'location' => 'Sherman Oaks, CA' ),
                    array( 'title' => 'Custom Swimming Pool', 'cat' => 'Pool Construction', 'location' => 'Bel Air, CA' ),
                );
                foreach ( $placeholders as $p ) : ?>
                    <div class="portfolio-item" data-categories="all">
                        <div class="project-card">
                            <div class="project-card-image">
                                <div class="image-placeholder">
                                    <?php echo ace_icon( 'home', 48 ); ?>
                                </div>
                                <div class="project-card-overlay">
                                    <span class="project-category"><?php echo esc_html( $p['cat'] ); ?></span>
                                    <h3><?php echo esc_html( $p['title'] ); ?></h3>
                                    <span class="project-location"><?php echo ace_icon( 'map-pin', 14 ); ?> <?php echo esc_html( $p['location'] ); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach;
            endif; ?>
        </div>
    </div>
</section>

<!-- CTA -->
<section class="cta-banner bg-navy">
    <div class="container">
        <div class="cta-banner-inner">
            <div class="cta-banner-content">
                <h2><?php esc_html_e( 'Like What You See? Let\'s Talk About Your Project.', 'ace-theme' ); ?></h2>
            </div>
            <div class="cta-banner-actions">
                <a href="<?php echo esc_url( home_url( '/contact/' ) ); ?>" class="btn btn-primary btn-lg"><?php esc_html_e( 'Get Your Free Consultation', 'ace-theme' ); ?></a>
                <a href="<?php echo esc_url( ace_get_phone_link() ); ?>" class="btn btn-ghost btn-lg">
                    <?php echo ace_icon( 'phone', 18 ); ?> <?php echo esc_html( ace_get_phone() ); ?>
                </a>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>
