<?php
/**
 * Single Post Template
 * @package ACE_Theme
 */
get_header();
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'single-post-page' ); ?>>
    <!-- Hero with Featured Image -->
    <?php if ( has_post_thumbnail() ) : ?>
    <div class="single-hero">
        <?php the_post_thumbnail( 'ace-hero', array( 'class' => 'single-hero-image' ) ); ?>
    </div>
    <?php endif; ?>

    <section class="section bg-white">
        <div class="container">
            <div class="blog-layout">
                <div class="blog-main single-content">
                    <!-- Post Meta -->
                    <div class="post-meta">
                        <time datetime="<?php echo esc_attr( get_the_date( 'c' ) ); ?>"><?php echo esc_html( get_the_date() ); ?></time>
                        <?php
                        $cats = get_the_category();
                        if ( $cats ) : ?>
                            <span class="post-category"><?php echo esc_html( $cats[0]->name ); ?></span>
                        <?php endif; ?>
                        <span class="reading-time"><?php echo esc_html( ace_reading_time() ); ?></span>
                    </div>

                    <h1 class="single-title"><?php the_title(); ?></h1>

                    <!-- Post Content -->
                    <div class="entry-content">
                        <?php
                        the_content();

                        wp_link_pages( array(
                            'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'ace-theme' ),
                            'after'  => '</div>',
                        ) );
                        ?>
                    </div>

                    <!-- Share Buttons -->
                    <div class="share-buttons">
                        <span class="share-label"><?php esc_html_e( 'Share this article:', 'ace-theme' ); ?></span>
                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode( get_permalink() ); ?>" target="_blank" rel="noopener noreferrer" class="share-btn share-facebook" aria-label="Share on Facebook">
                            <?php echo ace_icon( 'facebook', 18 ); ?>
                        </a>
                        <a href="https://twitter.com/intent/tweet?url=<?php echo urlencode( get_permalink() ); ?>&text=<?php echo urlencode( get_the_title() ); ?>" target="_blank" rel="noopener noreferrer" class="share-btn share-twitter" aria-label="Share on Twitter">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor"><path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/></svg>
                        </a>
                        <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo urlencode( get_permalink() ); ?>&title=<?php echo urlencode( get_the_title() ); ?>" target="_blank" rel="noopener noreferrer" class="share-btn share-linkedin" aria-label="Share on LinkedIn">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M16 8a6 6 0 0 1 6 6v7h-4v-7a2 2 0 0 0-2-2 2 2 0 0 0-2 2v7h-4v-7a6 6 0 0 1 6-6z"/><rect x="2" y="9" width="4" height="12"/><circle cx="4" cy="4" r="2"/></svg>
                        </a>
                        <a href="mailto:?subject=<?php echo rawurlencode( get_the_title() ); ?>&body=<?php echo rawurlencode( get_permalink() ); ?>" class="share-btn share-email" aria-label="Share via Email">
                            <?php echo ace_icon( 'email', 18 ); ?>
                        </a>
                    </div>

                    <!-- Inline CTA -->
                    <div class="inline-cta">
                        <h3><?php esc_html_e( 'Ready to Start Your Project?', 'ace-theme' ); ?></h3>
                        <p><?php esc_html_e( 'Get a free, no-obligation estimate for your remodeling or construction project.', 'ace-theme' ); ?></p>
                        <a href="<?php echo esc_url( home_url( '/contact/' ) ); ?>" class="btn btn-primary"><?php esc_html_e( 'Get Your Free Consultation', 'ace-theme' ); ?></a>
                    </div>

                    <!-- Related Posts -->
                    <?php
                    $related = new WP_Query( array(
                        'post_type'      => 'post',
                        'posts_per_page' => 3,
                        'post__not_in'   => array( get_the_ID() ),
                        'orderby'        => 'rand',
                    ) );
                    if ( $related->have_posts() ) : ?>
                        <div class="related-posts">
                            <h3><?php esc_html_e( 'Related Articles', 'ace-theme' ); ?></h3>
                            <div class="blog-grid-3col">
                                <?php while ( $related->have_posts() ) : $related->the_post(); ?>
                                    <?php get_template_part( 'template-parts/blog-card' ); ?>
                                <?php endwhile; ?>
                            </div>
                        </div>
                    <?php
                    wp_reset_postdata();
                    endif; ?>
                </div>
                <?php get_sidebar(); ?>
            </div>
        </div>
    </section>
</article>

<?php get_footer(); ?>
