<?php
/**
 * Blog Card Template Part
 *
 * @package ACE_Theme
 */

$categories = get_the_category();
?>
<article class="blog-card">
    <a href="<?php the_permalink(); ?>" class="blog-card-image">
        <?php if ( has_post_thumbnail() ) : ?>
            <?php the_post_thumbnail( 'ace-blog-card', array( 'loading' => 'lazy' ) ); ?>
        <?php else : ?>
            <div class="image-placeholder">
                <?php echo ace_icon( 'home', 48 ); ?>
            </div>
        <?php endif; ?>
        <?php if ( $categories ) : ?>
            <span class="blog-card-category"><?php echo esc_html( $categories[0]->name ); ?></span>
        <?php endif; ?>
    </a>
    <div class="blog-card-content">
        <div class="blog-card-meta">
            <time datetime="<?php echo esc_attr( get_the_date( 'c' ) ); ?>"><?php echo esc_html( get_the_date() ); ?></time>
            <span class="reading-time"><?php echo esc_html( ace_reading_time() ); ?></span>
        </div>
        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
        <p><?php echo esc_html( wp_trim_words( get_the_excerpt(), 18, '...' ) ); ?></p>
        <a href="<?php the_permalink(); ?>" class="link-arrow">
            <?php esc_html_e( 'Read More', 'ace-theme' ); ?> <?php echo ace_icon( 'arrow-right', 14 ); ?>
        </a>
    </div>
</article>
