<?php
/**
 * FAQ Accordion Template Part
 *
 * Expects $args['faqs'] array
 *
 * @package ACE_Theme
 */

$faqs = isset( $args['faqs'] ) ? $args['faqs'] : array();
if ( empty( $faqs ) ) return;
?>
<div class="faq-accordion">
    <?php foreach ( $faqs as $index => $faq ) : ?>
        <div class="faq-item">
            <button class="faq-question" aria-expanded="false" aria-controls="faq-answer-<?php echo intval( $index ); ?>">
                <span><?php echo esc_html( $faq['question'] ); ?></span>
                <?php echo ace_icon( 'chevron-down', 20 ); ?>
            </button>
            <div class="faq-answer" id="faq-answer-<?php echo intval( $index ); ?>" role="region">
                <p><?php echo wp_kses_post( $faq['answer'] ); ?></p>
            </div>
        </div>
    <?php endforeach; ?>
</div>
