<?php
/**
 * Generic Hero Template Part
 *
 * Expects $args: 'title', 'subtitle', 'bg_image' (optional)
 *
 * @package ACE_Theme
 */

$title = isset( $args['title'] ) ? $args['title'] : get_the_title();
$subtitle = isset( $args['subtitle'] ) ? $args['subtitle'] : '';
$bg_image = isset( $args['bg_image'] ) ? $args['bg_image'] : '';
$bg_style = $bg_image ? 'background-image: url(' . esc_url( $bg_image ) . ');' : '';
?>
<section class="page-hero">
    <div class="page-hero-overlay" style="<?php echo esc_attr( $bg_style ); ?>">
        <div class="container">
            <h1 class="page-hero-title"><?php echo esc_html( $title ); ?></h1>
            <?php if ( $subtitle ) : ?>
                <p class="page-hero-subtitle"><?php echo esc_html( $subtitle ); ?></p>
            <?php endif; ?>
        </div>
    </div>
</section>
