<?php
// --- API Key ---
$api_key = "AIzaSyAdHf_kkzw3TvkiaG0dRiaYkEiFJR62ufI";

// === Test 1: Text Only ===
echo "=== Test 1: Text Only ===\n\n";

$url = "https://generativelanguage.googleapis.com/v1beta/models/gemini-2.5-flash:generateContent?key=" . $api_key;
$body = json_encode([
    "contents" => [["parts" => [["text" => "Say hello in 3 words"]]]]
]);

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
$response = curl_exec($ch);
$status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($status === 200) {
    $data = json_decode($response, true);
    $text = $data["candidates"][0]["content"]["parts"][0]["text"];
    echo "API Key works! Response: " . $text . "\n\n";
} else {
    echo "ERROR (status " . $status . "): " . $response . "\n\n";
    die("Fix the API key first.");
}

// === Test 2: Image Generation ===
echo "=== Test 2: Image Generation ===\n\n";

$url2 = "https://generativelanguage.googleapis.com/v1beta/models/gemini-2.5-flash-image:generateContent?key=" . $api_key;
$body2 = json_encode([
    "contents" => [["parts" => [["text" =>
        "A luxurious modern backyard in Los Angeles with infinity pool, outdoor kitchen, fire pit, palm trees. Golden hour, photorealistic."
    ]]]],
    "generationConfig" => [
        "responseModalities" => ["TEXT", "IMAGE"]
    ]
]);

$ch2 = curl_init($url2);
curl_setopt($ch2, CURLOPT_POST, true);
curl_setopt($ch2, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
curl_setopt($ch2, CURLOPT_POSTFIELDS, $body2);
curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch2, CURLOPT_TIMEOUT, 120);
$response2 = curl_exec($ch2);
$status2 = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
curl_close($ch2);

if ($status2 !== 200) {
    echo "ERROR (status " . $status2 . "): " . $response2 . "\n";
    die();
}

$data2 = json_decode($response2, true);
$saved = false;

foreach ($data2["candidates"][0]["content"]["parts"] as $part) {
    if (isset($part["inlineData"])) {
        $image_bytes = base64_decode($part["inlineData"]["data"]);
        file_put_contents(__DIR__ . "/test-result.png", $image_bytes);
        echo "Image saved: C:\\xampp\\htdocs\\ace\\test-result.png\n";
        echo "Open in browser: http://localhost/ace/test-result.png\n";
        $saved = true;
    }
    if (isset($part["text"])) {
        echo "AI said: " . $part["text"] . "\n";
    }
}

if (!$saved) {
    echo "No image returned.\n";
    echo "Raw response:\n" . substr($response2, 0, 500) . "\n";
}

echo "\nDone!\n";