<?php
if (!defined('ABSPATH')) exit;

class ACE_BLP_Admin {

    public function __construct() {
        add_action('admin_menu', array($this, 'add_menu'));
        add_action('admin_init', array($this, 'register_settings'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_assets'));
    }

    public function add_menu() {
        add_menu_page(
            'Backyard LP',
            'Backyard LP',
            'manage_options',
            'ace-backyard-lp',
            array($this, 'render_page'),
            'dashicons-palmtree',
            30
        );
    }

    public function register_settings() {
        register_setting('ace_backyard_lp_group', 'ace_backyard_lp_settings', array(
            'sanitize_callback' => array($this, 'sanitize_settings'),
        ));
    }

    public function sanitize_settings($input) {
        // Sanitize all text fields, preserve arrays
        if (!is_array($input)) return array();

        // WordPress adds magic quotes to $_POST — strip them before sanitizing
        $input = wp_unslash($input);

        // Deep sanitize
        return $this->deep_sanitize($input);
    }

    private function deep_sanitize($data) {
        if (is_array($data)) {
            return array_map(array($this, 'deep_sanitize'), $data);
        }
        if (is_numeric($data)) {
            return $data;
        }
        // Allow basic HTML in certain fields
        return wp_kses_post($data);
    }

    public function enqueue_admin_assets($hook) {
        if ($hook !== 'toplevel_page_ace-backyard-lp') return;

        wp_enqueue_media();
        wp_enqueue_style('ace-blp-admin', ACE_BLP_URL . 'admin/admin-style.css', array(), ACE_BLP_VERSION);
        wp_enqueue_script('ace-blp-admin', ACE_BLP_URL . 'admin/admin-script.js', array('jquery', 'jquery-ui-sortable'), ACE_BLP_VERSION, true);
        wp_localize_script('ace-blp-admin', 'aceBlpAdmin', array(
            'nonce' => wp_create_nonce('ace_blp_admin_nonce'),
        ));
    }

    public function render_page() {
        include ACE_BLP_PATH . 'admin/admin-page.php';
    }
}
