<?php
/**
 * Comments Template
 * @package ACE_Theme
 */
if ( post_password_required() ) {
    return;
}
?>

<div id="comments" class="comments-area">
    <?php if ( have_comments() ) : ?>
        <h2 class="comments-title">
            <?php
            $count = get_comments_number();
            printf( esc_html( _n( '%d Comment', '%d Comments', $count, 'ace-theme' ) ), intval( $count ) );
            ?>
        </h2>

        <ol class="comment-list">
            <?php
            wp_list_comments( array(
                'style'      => 'ol',
                'short_ping' => true,
                'avatar_size' => 50,
            ) );
            ?>
        </ol>

        <?php the_comments_navigation(); ?>
    <?php endif; ?>

    <?php
    comment_form( array(
        'title_reply'        => esc_html__( 'Leave a Comment', 'ace-theme' ),
        'label_submit'       => esc_html__( 'Submit Comment', 'ace-theme' ),
        'class_submit'       => 'btn btn-primary',
        'comment_notes_after' => '',
    ) );
    ?>
</div>
