<?php
/**
 * Footer template for ACE Theme
 *
 * Renders the closing main tag, optional CTA section, 4-column footer,
 * bottom bar with copyright, floating mobile CTA bar, and wp_footer().
 *
 * @package ACE_Theme
 * @since 1.0.0
 */
?>
</main><!-- #main-content -->

<?php
// Final CTA Section (skip on contact and thank-you pages).
if ( ! is_page( array( 'contact', 'thank-you' ) ) && ace_is_section_visible( 'footer_cta' ) ) : ?>
<section class="footer-cta bg-navy" aria-label="<?php esc_attr_e( 'Call to action', 'ace-theme' ); ?>">
	<div class="container">
		<div class="footer-cta-inner">
			<h2><?php echo esc_html( ace_get_option( 'cta_headline', 'Ready to Build Something Extraordinary?' ) ); ?></h2>
			<p><?php echo esc_html( ace_get_option( 'cta_subheadline', 'Schedule your free in-home consultation today. Let\'s turn your vision into reality.' ) ); ?></p>
			<div class="footer-cta-actions">
				<a href="<?php echo esc_url( home_url( '/contact/' ) ); ?>" class="btn btn-primary" data-popup="consultation">
					<?php echo esc_html( ace_get_option( 'cta_button_text', 'Get Your Free Consultation' ) ); ?>
				</a>
				<a href="<?php echo esc_url( ace_get_phone_link() ); ?>" class="btn btn-phone" aria-label="<?php /* translators: %s: phone number */ printf( esc_attr__( 'Call us at %s', 'ace-theme' ), ace_get_phone() ); ?>">
					<?php echo ace_icon( 'phone', 18 ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
					<?php esc_html_e( 'Or Call Us Now: ', 'ace-theme' ); ?>
					<?php echo esc_html( ace_get_phone() ); ?>
				</a>
			</div>
		</div>
	</div>
</section>
<?php endif; ?>

<!-- Site Footer -->
<footer class="site-footer" role="contentinfo">
	<div class="container">
		<div class="footer-grid">

			<!-- Column 1: About -->
			<div class="footer-col footer-about">
				<?php
				$footer_logo_url    = ace_get_logo_white_url();
				$footer_logo_height = intval( get_option( 'ace_logo_white_height', 40 ) );
				$footer_logo_link   = get_option( 'ace_logo_white_link', '#hero' );
				$is_footer_scroll   = ( strpos( $footer_logo_link, '#' ) === 0 );
				?>
				<a href="<?php echo esc_attr( $footer_logo_link ); ?>" class="footer-logo" aria-label="<?php echo esc_attr( ace_get_company_name() ); ?> - <?php esc_attr_e( 'Home', 'ace-theme' ); ?>"<?php if ( $is_footer_scroll ) : ?> data-scroll="true"<?php endif; ?>>
					<?php if ( $footer_logo_url && strpos( $footer_logo_url, 'placeholder' ) === false ) : ?>
						<img src="<?php echo esc_url( $footer_logo_url ); ?>" alt="<?php echo esc_attr( ace_get_company_name() ); ?>" loading="lazy" style="height: <?php echo intval( $footer_logo_height ); ?>px; width: auto;">
					<?php else : ?>
						<span class="footer-logo-text"><?php echo esc_html( ace_get_company_name() ); ?></span>
					<?php endif; ?>
				</a>
				<p class="footer-description">
					<?php echo esc_html( ace_get_option( 'footer_description', 'Los Angeles\' premier design-build firm. 15 years of transforming homes with precision, transparency, and unmatched craftsmanship.' ) ); ?>
				</p>
				<div class="footer-social" aria-label="<?php esc_attr_e( 'Social media links', 'ace-theme' ); ?>">
					<?php
					$social = ace_get_social_links();
					$fa_social = array(
						'facebook'  => 'fa-brands fa-facebook-f',
						'instagram' => 'fa-brands fa-instagram',
						'youtube'   => 'fa-brands fa-youtube',
						'yelp'      => 'fa-brands fa-yelp',
					);
					foreach ( $fa_social as $network => $fa_class ) :
						if ( ! empty( $social[ $network ] ) ) : ?>
							<a href="<?php echo esc_url( $social[ $network ] ); ?>" target="_blank" rel="noopener noreferrer" aria-label="<?php /* translators: %s: social network name */ printf( esc_attr__( 'Follow us on %s', 'ace-theme' ), ucfirst( $network ) ); ?>">
								<?php echo '<i class="' . esc_attr( isset( $fa_social[ $network ] ) ? $fa_social[ $network ] : 'fas fa-globe' ) . '"></i>'; ?>
							</a>
						<?php endif;
					endforeach; ?>
				</div>
			</div>

			<!-- Column 2: Services -->
			<div class="footer-col footer-services">
				<h4><?php esc_html_e( 'Our Services', 'ace-theme' ); ?></h4>
				<ul>
					<?php
					$services = ace_get_services();
					if ( ! empty( $services ) ) :
						foreach ( $services as $service ) : ?>
							<li>
								<a href="<?php echo esc_url( home_url( '/services/' . $service['slug'] . '/' ) ); ?>">
									<?php echo esc_html( $service['title'] ); ?>
								</a>
							</li>
						<?php endforeach;
					endif; ?>
				</ul>
			</div>

			<!-- Column 3: Company -->
			<div class="footer-col footer-company">
				<h4><?php esc_html_e( 'Company', 'ace-theme' ); ?></h4>
				<ul>
					<li><a href="<?php echo esc_url( home_url( '/about/' ) ); ?>"><?php esc_html_e( 'About Us', 'ace-theme' ); ?></a></li>
					<li><a href="<?php echo esc_url( home_url( '/our-work/' ) ); ?>"><?php esc_html_e( 'Our Work', 'ace-theme' ); ?></a></li>
					<li><a href="<?php echo esc_url( home_url( '/blog/' ) ); ?>"><?php esc_html_e( 'Blog', 'ace-theme' ); ?></a></li>
					<li><a href="<?php echo esc_url( home_url( '/contact/' ) ); ?>"><?php esc_html_e( 'Contact', 'ace-theme' ); ?></a></li>
					<li><a href="<?php echo esc_url( home_url( '/privacy-policy/' ) ); ?>"><?php esc_html_e( 'Privacy Policy', 'ace-theme' ); ?></a></li>
					<li><a href="<?php echo esc_url( home_url( '/terms-of-service/' ) ); ?>"><?php esc_html_e( 'Terms of Service', 'ace-theme' ); ?></a></li>
				</ul>
			</div>

			<!-- Column 4: Contact -->
			<div class="footer-col footer-contact">
				<h4><?php esc_html_e( 'Contact Us', 'ace-theme' ); ?></h4>
				<ul class="contact-list">
					<li>
						<?php echo ace_get_icon( 'contact', 'address', 'inline' ); ?>
						<a href="<?php echo esc_url( 'https://maps.google.com/?q=' . rawurlencode( ace_get_address() ) ); ?>" target="_blank" rel="noopener noreferrer">
							<?php echo esc_html( ace_get_address() ); ?>
						</a>
					</li>
					<li>
						<?php echo ace_get_icon( 'contact', 'phone', 'inline' ); ?>
						<a href="<?php echo esc_url( ace_get_phone_link() ); ?>">
							<?php echo esc_html( ace_get_phone() ); ?>
						</a>
					</li>
					<li>
						<?php echo ace_get_icon( 'contact', 'email', 'inline' ); ?>
						<a href="mailto:<?php echo esc_attr( ace_get_email() ); ?>">
							<?php echo esc_html( ace_get_email() ); ?>
						</a>
					</li>
					<li>
						<?php echo ace_get_icon( 'contact', 'hours', 'inline' ); ?>
						<span><?php echo esc_html( ace_get_hours() ); ?></span>
					</li>
				</ul>
			</div>

		</div>
	</div>

	<!-- Footer Bottom Bar -->
	<div class="footer-bottom">
		<?php
		$bottom_logo_url    = get_option( 'ace_logo_white', '' );
		$bottom_logo_height = intval( get_option( 'ace_logo_white_height', 40 ) );
		$bottom_logo_link   = get_option( 'ace_logo_white_link', '#hero' );
		$is_bottom_scroll   = ( strpos( $bottom_logo_link, '#' ) === 0 );
		if ( $bottom_logo_url ) : ?>
		<div class="footer-bottom-logo" style="text-align:center;margin-bottom:20px;padding-top:20px;">
			<a href="<?php echo esc_attr( $bottom_logo_link ); ?>" aria-label="<?php echo esc_attr( ace_get_company_name() ); ?>"<?php if ( $is_bottom_scroll ) : ?> data-scroll="true"<?php endif; ?>>
				<img src="<?php echo esc_url( $bottom_logo_url ); ?>" alt="<?php echo esc_attr( ace_get_company_name() ); ?>" loading="lazy" style="height: <?php echo intval( $bottom_logo_height ); ?>px; width: auto;">
			</a>
		</div>
		<?php endif; ?>
		<div class="container footer-bottom-inner">
			<p>&copy; <?php echo esc_html( gmdate( 'Y' ) ); ?> <?php echo esc_html( ace_get_company_name() ); ?>. <?php esc_html_e( 'All rights reserved. Licensed, Bonded & Insured.', 'ace-theme' ); ?></p>
			<div class="footer-bottom-links">
				<a href="<?php echo esc_url( home_url( '/privacy-policy/' ) ); ?>"><?php esc_html_e( 'Privacy Policy', 'ace-theme' ); ?></a>
				<a href="<?php echo esc_url( home_url( '/terms-of-service/' ) ); ?>"><?php esc_html_e( 'Terms of Service', 'ace-theme' ); ?></a>
			</div>
		</div>
	</div>
</footer>

<!-- Floating Mobile CTA Bar -->
<div class="mobile-cta-bar" aria-label="<?php esc_attr_e( 'Quick actions', 'ace-theme' ); ?>">
	<a href="<?php echo esc_url( ace_get_phone_link() ); ?>" class="mobile-cta-phone" aria-label="<?php /* translators: %s: phone number */ printf( esc_attr__( 'Call us at %s', 'ace-theme' ), ace_get_phone() ); ?>">
		<?php echo ace_icon( 'phone', 20 ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
		<span><?php esc_html_e( 'Call Now', 'ace-theme' ); ?></span>
	</a>
	<a href="<?php echo esc_url( home_url( '/contact/' ) ); ?>" class="mobile-cta-quote" data-popup="consultation">
		<?php esc_html_e( 'Free Quote', 'ace-theme' ); ?>
	</a>
</div>

<button class="back-to-top" id="back-to-top" aria-label="Back to top">
    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"><polyline points="18 15 12 9 6 15"/></svg>
</button>

<!-- Consultation Popup Modal -->
<div class="consultation-popup" id="consultationPopup" aria-hidden="true" role="dialog" aria-modal="true" aria-label="<?php esc_attr_e( 'Request a Free Consultation', 'ace-theme' ); ?>">
	<div class="popup-overlay"></div>
	<div class="popup-content">
		<button class="popup-close" aria-label="<?php esc_attr_e( 'Close', 'ace-theme' ); ?>">&times;</button>
		<?php get_template_part( 'template-parts/lead-form', null, array( 'form_id' => 'popup-lead-form' ) ); ?>
	</div>
</div>

<?php wp_footer(); ?>
</body>
</html>
