<?php
/**
 * ACE Theme functions and definitions
 *
 * @package ACE_Theme
 * @since 1.0.0
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Theme version constant.
define( 'ACE_THEME_VERSION', '1.1.0' );
define( 'ACE_THEME_DIR', get_template_directory() );
define( 'ACE_THEME_URI', get_template_directory_uri() );

/**
 * Include theme files.
 */
require_once ACE_THEME_DIR . '/inc/theme-setup.php';
require_once ACE_THEME_DIR . '/inc/enqueue.php';
require_once ACE_THEME_DIR . '/inc/template-functions.php';
require_once ACE_THEME_DIR . '/inc/custom-post-types.php';
require_once ACE_THEME_DIR . '/inc/schema.php';
require_once ACE_THEME_DIR . '/inc/seo.php';
require_once ACE_THEME_DIR . '/inc/walker-nav-mega.php';
require_once ACE_THEME_DIR . '/inc/service-routing.php';

/**
 * Fix: Remove 'current_page_parent' from Blog nav item on non-blog pages.
 * WordPress incorrectly adds this class when viewing custom rewrite pages.
 */
add_filter( 'nav_menu_css_class', function( $classes, $item ) {
	$blog_page_id = get_option( 'page_for_posts' );
	if ( $blog_page_id && (int) $item->object_id === (int) $blog_page_id ) {
		if ( ! is_home() && ! is_singular( 'post' ) && ! is_category() && ! is_tag() ) {
			$remove = array(
				'current_page_parent',
				'current-menu-parent',
				'current_page_ancestor',
				'current-menu-ancestor',
				'current-page-ancestor',
			);
			$classes = array_diff( $classes, $remove );
		}
	}
	return $classes;
}, 100, 2 );
