<?php
/**
 * Search Form Template
 * @package ACE_Theme
 */
?>
<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
    <label class="screen-reader-text" for="search-field"><?php esc_html_e( 'Search for:', 'ace-theme' ); ?></label>
    <div class="search-input-wrap">
        <input type="search" id="search-field" class="search-field" placeholder="<?php esc_attr_e( 'Search...', 'ace-theme' ); ?>" value="<?php echo get_search_query(); ?>" name="s">
        <button type="submit" class="search-submit" aria-label="<?php esc_attr_e( 'Search', 'ace-theme' ); ?>">
            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="11" cy="11" r="8"/><line x1="21" y1="21" x2="16.65" y2="16.65"/></svg>
        </button>
    </div>
</form>
