<?php
/**
 * Sidebar Template
 * @package ACE_Theme
 */
?>
<aside class="sidebar" role="complementary">
    <!-- Search -->
    <div class="sidebar-widget">
        <h3 class="widget-title"><?php esc_html_e( 'Search', 'ace-theme' ); ?></h3>
        <?php get_search_form(); ?>
    </div>

    <!-- Categories -->
    <div class="sidebar-widget">
        <h3 class="widget-title"><?php esc_html_e( 'Categories', 'ace-theme' ); ?></h3>
        <ul class="category-list">
            <?php wp_list_categories( array(
                'title_li' => '',
                'show_count' => true,
            ) ); ?>
        </ul>
    </div>

    <!-- Recent Posts -->
    <div class="sidebar-widget">
        <h3 class="widget-title"><?php esc_html_e( 'Recent Posts', 'ace-theme' ); ?></h3>
        <ul class="recent-posts-list">
            <?php
            $recent = new WP_Query( array(
                'post_type'      => 'post',
                'posts_per_page' => 5,
            ) );
            if ( $recent->have_posts() ) :
                while ( $recent->have_posts() ) : $recent->the_post(); ?>
                    <li>
                        <a href="<?php the_permalink(); ?>">
                            <?php if ( has_post_thumbnail() ) : ?>
                                <?php the_post_thumbnail( 'thumbnail', array( 'class' => 'recent-thumb', 'loading' => 'lazy' ) ); ?>
                            <?php endif; ?>
                            <div>
                                <span class="recent-title"><?php the_title(); ?></span>
                                <time><?php echo esc_html( get_the_date() ); ?></time>
                            </div>
                        </a>
                    </li>
                <?php endwhile;
                wp_reset_postdata();
            endif; ?>
        </ul>
    </div>

    <!-- CTA Card -->
    <div class="sidebar-cta">
        <h3><?php esc_html_e( 'Free Consultation', 'ace-theme' ); ?></h3>
        <p><?php esc_html_e( 'Ready to start your home improvement project? Get a free estimate today.', 'ace-theme' ); ?></p>
        <a href="<?php echo esc_url( home_url( '/contact/' ) ); ?>" class="btn btn-primary btn-full" data-popup="consultation"><?php esc_html_e( 'Get Started', 'ace-theme' ); ?></a>
        <a href="<?php echo esc_url( ace_get_phone_link() ); ?>" class="btn btn-phone btn-full" style="margin-top: 8px;">
            <?php echo ace_icon( 'phone', 16 ); ?> <?php echo esc_html( ace_get_phone() ); ?>
        </a>
    </div>

    <?php if ( is_active_sidebar( 'blog-sidebar' ) ) : ?>
        <?php dynamic_sidebar( 'blog-sidebar' ); ?>
    <?php endif; ?>
</aside>
