<?php
/**
 * CTA Banner Template Part
 *
 * @package ACE_Theme
 */
?>
<section class="cta-banner bg-navy">
    <div class="container">
        <div class="cta-banner-inner">
            <div class="cta-banner-content">
                <h2><?php echo esc_html( ace_get_option( 'cta_headline', 'Ready to Build Something Extraordinary?' ) ); ?></h2>
                <p><?php echo esc_html( ace_get_option( 'cta_subheadline', 'Schedule your free in-home consultation today. Let\'s turn your vision into reality.' ) ); ?></p>
            </div>
            <div class="cta-banner-actions">
                <a href="<?php echo esc_url( home_url( '/contact/' ) ); ?>" class="btn btn-primary btn-lg" data-popup="consultation">
                    <?php echo esc_html( ace_get_option( 'cta_button_text', 'Get Your Free Consultation' ) ); ?>
                </a>
                <a href="<?php echo esc_url( ace_get_phone_link() ); ?>" class="btn btn-ghost btn-lg">
                    <?php echo ace_icon( 'phone', 18 ); ?>
                    <?php esc_html_e( 'Or Call Us Now: ', 'ace-theme' ); ?><?php echo esc_html( ace_get_phone() ); ?>
                </a>
            </div>
        </div>
    </div>
</section>
