<?php
/**
 * Lead Capture Form Template Part
 *
 * @package ACE_Theme
 */

$current_service = isset( $args['service'] ) ? $args['service'] : '';
$form_id = isset( $args['form_id'] ) ? $args['form_id'] : 'ace-lead-form';
?>
<div class="ace-lead-form-wrapper" id="<?php echo esc_attr( $form_id ); ?>">
    <h3 class="form-title"><?php esc_html_e( 'Request Your Free Consultation', 'ace-theme' ); ?></h3>
    <form class="ace-lead-form" method="post" novalidate>
        <?php wp_nonce_field( 'ace_lead_form_nonce', 'ace_form_nonce' ); ?>
        <input type="hidden" name="action" value="ace_submit_lead">
        <input type="hidden" name="source_page" value="<?php echo esc_attr( get_the_title() ); ?>">
        <input type="hidden" name="source_url" value="<?php echo esc_url( get_permalink() ?: home_url( '/' ) ); ?>">

        <!-- Honeypot -->
        <div class="ace-hp" aria-hidden="true" style="position:absolute;left:-9999px;">
            <label for="website_url">Website</label>
            <input type="text" name="website_url" id="website_url" tabindex="-1" autocomplete="off">
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="<?php echo esc_attr( $form_id ); ?>-name"><?php esc_html_e( 'Full Name', 'ace-theme' ); ?> <span class="required">*</span></label>
                <input type="text" id="<?php echo esc_attr( $form_id ); ?>-name" name="full_name" placeholder="<?php esc_attr_e( 'John Smith', 'ace-theme' ); ?>" required>
                <span class="field-error"></span>
            </div>
            <div class="form-group">
                <label for="<?php echo esc_attr( $form_id ); ?>-phone"><?php esc_html_e( 'Phone Number', 'ace-theme' ); ?> <span class="required">*</span></label>
                <input type="tel" id="<?php echo esc_attr( $form_id ); ?>-phone" name="phone" placeholder="<?php esc_attr_e( '(555) 555-5555', 'ace-theme' ); ?>" required>
                <span class="field-error"></span>
            </div>
        </div>

        <div class="form-group">
            <label for="<?php echo esc_attr( $form_id ); ?>-email"><?php esc_html_e( 'Email Address', 'ace-theme' ); ?></label>
            <input type="email" id="<?php echo esc_attr( $form_id ); ?>-email" name="email" placeholder="<?php esc_attr_e( 'you@email.com', 'ace-theme' ); ?>">
            <span class="field-error"></span>
        </div>

        <div class="form-group">
            <label for="<?php echo esc_attr( $form_id ); ?>-service"><?php esc_html_e( 'Service Interested In', 'ace-theme' ); ?></label>
            <select id="<?php echo esc_attr( $form_id ); ?>-service" name="service">
                <option value=""><?php esc_html_e( 'Select a service...', 'ace-theme' ); ?></option>
                <?php
                $services = ace_get_services();
                foreach ( $services as $service ) :
                    $selected = ( $current_service === $service['slug'] ) ? ' selected' : '';
                    ?>
                    <option value="<?php echo esc_attr( $service['title'] ); ?>"<?php echo $selected; ?>><?php echo esc_html( $service['title'] ); ?></option>
                <?php endforeach; ?>
                <option value="Other / Not Sure"><?php esc_html_e( 'Other / Not Sure', 'ace-theme' ); ?></option>
            </select>
        </div>

        <div class="form-group">
            <label for="<?php echo esc_attr( $form_id ); ?>-message"><?php esc_html_e( 'Tell Us About Your Project', 'ace-theme' ); ?></label>
            <textarea id="<?php echo esc_attr( $form_id ); ?>-message" name="message" rows="4" placeholder="<?php esc_attr_e( 'Briefly describe your project, timeline, and any specific requirements...', 'ace-theme' ); ?>"></textarea>
        </div>

        <div class="contact-method-group">
            <label><?php esc_html_e( 'Preferred Contact Method', 'ace-theme' ); ?></label>
            <div class="contact-method-options">
                <div class="contact-method-option">
                    <input type="radio" name="preferred_contact" id="<?php echo esc_attr( $form_id ); ?>-method-phone" value="phone" checked>
                    <label for="<?php echo esc_attr( $form_id ); ?>-method-phone">
                        <i class="fas fa-phone"></i>
                        <?php esc_html_e( 'Phone', 'ace-theme' ); ?>
                    </label>
                </div>
                <div class="contact-method-option">
                    <input type="radio" name="preferred_contact" id="<?php echo esc_attr( $form_id ); ?>-method-email" value="email">
                    <label for="<?php echo esc_attr( $form_id ); ?>-method-email">
                        <i class="fas fa-envelope"></i>
                        <?php esc_html_e( 'Email', 'ace-theme' ); ?>
                    </label>
                </div>
                <div class="contact-method-option">
                    <input type="radio" name="preferred_contact" id="<?php echo esc_attr( $form_id ); ?>-method-text" value="text">
                    <label for="<?php echo esc_attr( $form_id ); ?>-method-text">
                        <i class="fas fa-comment-sms"></i>
                        <?php esc_html_e( 'Text', 'ace-theme' ); ?>
                    </label>
                </div>
            </div>
        </div>

        <button type="submit" class="form-submit-btn">
            <span class="btn-text"><?php esc_html_e( 'GET MY FREE CONSULTATION', 'ace-theme' ); ?></span>
            <span class="btn-loading" style="display:none;">
                <span class="spinner"></span> <?php esc_html_e( 'Sending...', 'ace-theme' ); ?>
            </span>
        </button>

        <div class="form-message" style="display:none;"></div>

        <p class="form-privacy-note">
            <?php
            printf(
                /* translators: %s: privacy policy link */
                esc_html__( 'By submitting this form, you agree to our %s. We will never share your information.', 'ace-theme' ),
                '<a href="' . esc_url( home_url( '/privacy-policy/' ) ) . '">' . esc_html__( 'Privacy Policy', 'ace-theme' ) . '</a>'
            );
            ?>
        </p>
    </form>
</div>
