<?php
/**
 * FRESH — Homepage Template
 * The Culinary Edge
 */
get_header();
?>

<!-- ===== HERO ===== -->
<section class="hero">
    <div class="hero__lines">
        <span></span><span></span><span></span><span></span><span></span>
    </div>
    <div class="fresh-container">
        <div class="hero__content">
            <div class="hero__badge">
                <span style="width:8px;height:8px;background:var(--fresh-accent);border-radius:50%;display:inline-block;"></span>
                סוכנות שיווק דיגיטלי למסעדות
            </div>
            <h1 class="hero__title">
                המסעדה שלך<br>
                ראויה ל<span class="text-accent">שולחנות מלאים</span>
            </h1>
            <p class="hero__subtitle">
                אנחנו לא סוכנות שיווק גנרית. אנחנו מתמחים רק במסעדות — ויודעים בדיוק איך להפוך ביקורים דיגיטליים להזמנות אמיתיות.
            </p>
            <div class="hero__actions">
                <a href="#contact" class="fresh-btn fresh-btn--primary fresh-btn--large">
                    רוצה תוכנית פעולה →
                </a>
                <a href="#cases" class="fresh-btn fresh-btn--outline fresh-btn--large">
                    ראה תוצאות
                </a>
            </div>
        </div>
    </div>
</section>


<!-- ===== STATS BAR ===== -->
<section class="stats-bar">
    <div class="fresh-container">
        <div class="fresh-grid fresh-grid--4 stagger-children">
            <div class="text-center">
                <div class="stat__number" data-target="150">150+</div>
                <div class="stat__divider"></div>
                <div class="stat__label">מסעדות שעובדות איתנו</div>
            </div>
            <div class="text-center">
                <div class="stat__number">₪3.2M</div>
                <div class="stat__divider"></div>
                <div class="stat__label">הכנסות שנוצרו ללקוחות</div>
            </div>
            <div class="text-center">
                <div class="stat__number">340%</div>
                <div class="stat__divider"></div>
                <div class="stat__label">ROI ממוצע על קמפיינים</div>
            </div>
            <div class="text-center">
                <div class="stat__number">4.9</div>
                <div class="stat__divider"></div>
                <div class="stat__label">דירוג לקוחות (מתוך 5)</div>
            </div>
        </div>
    </div>
</section>


<!-- ===== KNIFE DIVIDER ===== -->
<div class="knife-divider" style="--knife-bg-from: var(--fresh-charcoal); background: var(--fresh-black);"></div>


<!-- ===== SERVICES ===== -->
<section class="fresh-section" id="services">
    <div class="fresh-container">

        <div class="fade-up" style="max-width: 600px; margin-bottom: var(--space-2xl);">
            <span class="fresh-overline">מה אנחנו עושים</span>
            <h2>האקוסיסטם<br>השלם למסעדות</h2>
            <p style="margin-top: var(--space-md);">
                לא עוד ״חבילת שיווק״ גנרית. כל שירות מותאם בדיוק לאתגרים הייחודיים של עולם המסעדנות.
            </p>
        </div>

        <div class="fresh-grid fresh-grid--3 stagger-children">
            <!-- Service 1: Social -->
            <div class="service-card">
                <div class="service-card__icon">📱</div>
                <h3 class="service-card__title">Paid Social</h3>
                <p class="service-card__desc">
                    קמפיינים ממומנים באינסטגרם, פייסבוק וטיקטוק שמביאים לקוחות חדשים. טירגוט גיאוגרפי חכם, קריאייטיב שעוצר סקרול, ואופטימיזציה שוטפת.
                </p>
                <a href="#contact" class="service-card__link">לפרטים נוספים ←</a>
            </div>

            <!-- Service 2: Wolt/10bis -->
            <div class="service-card">
                <div class="service-card__icon">🛵</div>
                <h3 class="service-card__title">אופטימיזציית משלוחים</h3>
                <p class="service-card__desc">
                    Wolt, 10bis, וולט מרקט — אנחנו יודעים לשחק את המשחק. אופטימיזציית תפריט, צילומי מנות, מיצוב, וניהול מבצעים שמעלים את הדירוג ואת ההזמנות.
                </p>
                <a href="#contact" class="service-card__link">לפרטים נוספים ←</a>
            </div>

            <!-- Service 3: CRM -->
            <div class="service-card">
                <div class="service-card__icon">💬</div>
                <h3 class="service-card__title">CRM & Loyalty</h3>
                <p class="service-card__desc">
                    מערכות נאמנות, SMS, אימייל מרקטינג, ו-WhatsApp Business. בניית בסיס לקוחות שחוזרים — בלי לשלם עמלות לאפליקציות צד שלישי.
                </p>
                <a href="#contact" class="service-card__link">לפרטים נוספים ←</a>
            </div>

            <!-- Service 4: Production -->
            <div class="service-card">
                <div class="service-card__icon">🎬</div>
                <h3 class="service-card__title">צילום ופרודקשן</h3>
                <p class="service-card__desc">
                    צילומי אוכל שגורמים לרעב. רילס, סטוריז, טיקטוקים, ותוכן UGC. סטיילינג מקצועי וצוות הפקה שמכיר מטבחים מבפנים.
                </p>
                <a href="#contact" class="service-card__link">לפרטים נוספים ←</a>
            </div>

            <!-- Service 5: SEO -->
            <div class="service-card">
                <div class="service-card__icon">🔍</div>
                <h3 class="service-card__title">SEO & Google</h3>
                <p class="service-card__desc">
                    קידום אורגני, Google Business Profile, ומודעות בגוגל. כשמישהו מחפש ״מסעדה טובה באזור״ — שיגיע אליכם קודם.
                </p>
                <a href="#contact" class="service-card__link">לפרטים נוספים ←</a>
            </div>

            <!-- Service 6: Strategy -->
            <div class="service-card">
                <div class="service-card__icon">📊</div>
                <h3 class="service-card__title">אסטרטגיה ודאטה</h3>
                <p class="service-card__desc">
                    דשבורד מותאם עם KPIs ברורים. אנחנו מודדים כל שקל, כל קליק, כל הזמנה. דוחות חודשיים שקופים עם תובנות שמזיזות את המחט.
                </p>
                <a href="#contact" class="service-card__link">לפרטים נוספים ←</a>
            </div>
        </div>

    </div>
</section>


<!-- ===== ABOUT SPLIT ===== -->
<section class="split-section" id="about">
    <div class="split-section__visual knife-mask">
        <img src="https://images.unsplash.com/photo-1414235077428-338989a2e8c0?w=800&q=80"
             alt="מטבח מסעדה" loading="lazy">
    </div>
    <div class="split-section__content fade-up">
        <span class="fresh-overline">למה FRESH</span>
        <h2>לא סתם עוד סוכנות.<br><span class="text-accent">אנחנו מומחי מסעדות.</span></h2>
        <p style="margin-top: var(--space-lg);">
            הייסוד של FRESH הגיע מתוך תסכול. ראינו סוכנויות שיווק שמנהלות מסעדות כמו שהן מנהלות מרפאות שיניים. אותו טמפלט, אותה גישה, אותן תוצאות בינוניות.
        </p>
        <p style="margin-top: var(--space-md);">
            אנחנו בנינו מודל שונה. כל איש צוות אצלנו מכיר את עולם המסעדנות מבפנים — את הלחצים, את העונתיות, את ההבדל בין יום שלישי ליום שישי. זה לא רק דאטה. זה אינטואיציה.
        </p>
        <p style="margin-top: var(--space-md);">
            <strong style="color: var(--fresh-pure-white);">התוצאה?</strong> לקוחות שמשלמים פחות עמלות לאפליקציות משלוחים, שולטים בבסיס הלקוחות שלהם, ורואים צמיחה אמיתית — לא רק לייקים.
        </p>

        <div style="display: flex; gap: var(--space-xl); margin-top: var(--space-xl);">
            <div>
                <div class="stat__number" style="font-size: var(--text-2xl);">5+</div>
                <div class="stat__label">שנות ניסיון</div>
            </div>
            <div>
                <div class="stat__number" style="font-size: var(--text-2xl);">150+</div>
                <div class="stat__label">מסעדות</div>
            </div>
            <div>
                <div class="stat__number" style="font-size: var(--text-2xl);">12</div>
                <div class="stat__label">אנשי צוות</div>
            </div>
        </div>
    </div>
</section>


<!-- ===== KNIFE DIVIDER ===== -->
<div class="knife-divider knife-divider--reverse" style="--knife-bg-from: var(--fresh-black); background: var(--fresh-charcoal);"></div>


<!-- ===== CASE STUDIES ===== -->
<section class="fresh-section" id="cases" style="background: var(--fresh-charcoal);">
    <div class="fresh-container">

        <div class="fade-up" style="max-width: 600px; margin-bottom: var(--space-2xl);">
            <span class="fresh-overline">תוצאות אמיתיות</span>
            <h2>קייס סטאדי</h2>
            <p style="margin-top: var(--space-md);">
                לא מדברים — מראים. הנה חלק מהמסעדות ששינו כיוון איתנו.
            </p>
        </div>

        <div class="fresh-grid fresh-grid--3 stagger-children">
            <?php
            $cases = new WP_Query([
                'post_type'      => 'fresh_case_study',
                'posts_per_page' => 3,
                'orderby'        => 'date',
                'order'          => 'DESC',
            ]);

            if ( $cases->have_posts() ) :
                while ( $cases->have_posts() ) : $cases->the_post();
                    $metric_num   = get_post_meta( get_the_ID(), '_fresh_metric_number', true );
                    $metric_label = get_post_meta( get_the_ID(), '_fresh_metric_label', true );
                    $terms        = get_the_terms( get_the_ID(), 'case_category' );
                    $cat_name     = $terms ? $terms[0]->name : 'קייס סטאדי';
                    ?>
                    <article class="case-card">
                        <?php if ( has_post_thumbnail() ) : ?>
                            <div class="case-card__image">
                                <img src="<?php echo esc_url( get_the_post_thumbnail_url( get_the_ID(), 'fresh-case' ) ); ?>"
                                     alt="<?php the_title_attribute(); ?>" loading="lazy">
                            </div>
                        <?php endif; ?>
                        <div class="case-card__body">
                            <span class="case-card__category"><?php echo esc_html( $cat_name ); ?></span>
                            <h3 class="case-card__title">
                                <a href="<?php the_permalink(); ?>" style="color: inherit;"><?php the_title(); ?></a>
                            </h3>
                            <p class="case-card__excerpt"><?php the_excerpt(); ?></p>
                            <?php if ( $metric_num ) : ?>
                                <div class="case-card__stat">
                                    <span class="case-card__stat-number"><?php echo esc_html( $metric_num ); ?></span>
                                    <span class="case-card__stat-label"><?php echo esc_html( $metric_label ); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </article>
                    <?php
                endwhile;
                wp_reset_postdata();

            else :
                // Placeholder cards when no case studies exist yet
                $placeholders = [
                    [ 'cat' => 'Paid Social',  'title' => 'ברביס — מבורגר בר', 'desc' => 'הגדלנו את ההזמנות הישירות ב-280% תוך 3 חודשים באמצעות קמפיינים באינסטגרם ואופטימיזציית Wolt.', 'num' => '+280%', 'label' => 'גידול בהזמנות' ],
                    [ 'cat' => 'Wolt & 10bis', 'title' => 'נאנו — אסיאתי', 'desc' => 'הורדנו את התלות ב-Wolt מ-70% ל-35% של סך ההזמנות, והגדלנו את הרווחיות בצורה משמעותית.', 'num' => '-50%', 'label' => 'הורדת תלות באפליקציות' ],
                    [ 'cat' => 'CRM & Loyalty', 'title' => 'קפה לואיז — רשת', 'desc' => 'בנינו מערכת נאמנות ב-WhatsApp שהחזירה 40% מהלקוחות הקיימים תוך חודשיים.', 'num' => '40%', 'label' => 'לקוחות חוזרים' ],
                ];

                foreach ( $placeholders as $case ) : ?>
                    <article class="case-card">
                        <div class="case-card__image" style="background: linear-gradient(135deg, var(--fresh-graphite), var(--fresh-charcoal)); height: 280px; display: flex; align-items: center; justify-content: center; clip-path: polygon(0 0, 100% 0, 100% calc(100% - 30px), 0 100%);">
                            <span style="font-size: 3rem; opacity: 0.3;">🍽️</span>
                        </div>
                        <div class="case-card__body">
                            <span class="case-card__category"><?php echo esc_html( $case['cat'] ); ?></span>
                            <h3 class="case-card__title"><?php echo esc_html( $case['title'] ); ?></h3>
                            <p class="case-card__excerpt"><?php echo esc_html( $case['desc'] ); ?></p>
                            <div class="case-card__stat">
                                <span class="case-card__stat-number"><?php echo esc_html( $case['num'] ); ?></span>
                                <span class="case-card__stat-label"><?php echo esc_html( $case['label'] ); ?></span>
                            </div>
                        </div>
                    </article>
                <?php endforeach;
            endif;
            ?>
        </div>

    </div>
</section>


<!-- ===== PROCESS / WHY US ===== -->
<div class="knife-divider" style="--knife-bg-from: var(--fresh-charcoal); background: var(--fresh-black);"></div>

<section class="fresh-section" id="process">
    <div class="fresh-container">
        <div class="text-center fade-up" style="max-width: 600px; margin: 0 auto var(--space-2xl);">
            <span class="fresh-overline" style="justify-content: center;">איך זה עובד</span>
            <h2>מ-0 לתוצאות<br>ב-4 צעדים</h2>
        </div>

        <div class="fresh-grid fresh-grid--4 stagger-children" style="counter-reset: step;">
            <?php
            $steps = [
                [ 'title' => 'שיחת אסטרטגיה',  'desc' => 'מכירים את העסק, המטרות, הקהל, והאתגרים. חינם, ללא התחייבות.' ],
                [ 'title' => 'תוכנית פעולה',    'desc' => 'בונים תוכנית מותאמת עם ערוצים, לו"ז, תקציב, ו-KPIs ברורים.' ],
                [ 'title' => 'הרצה ואופטימיזציה', 'desc' => 'מריצים קמפיינים, מודדים בזמן אמת, ומשפרים כל שבוע.' ],
                [ 'title' => 'סקייל',            'desc' => 'מה שעובד — מגדילים. מה שלא — מחליפים. צמיחה מתמדת.' ],
            ];

            foreach ( $steps as $i => $step ) : ?>
                <div style="text-align: center;">
                    <div style="
                        width: 64px; height: 64px;
                        display: flex; align-items: center; justify-content: center;
                        font-family: var(--font-display); font-size: var(--text-2xl);
                        color: var(--fresh-accent); margin: 0 auto var(--space-md);
                        border: 2px solid rgba(200,255,0,0.2);
                        clip-path: polygon(0 0, calc(100% - 10px) 0, 100% 10px, 100% 100%, 10px 100%, 0 calc(100% - 10px));
                    "><?php echo $i + 1; ?></div>
                    <h4 style="margin-bottom: var(--space-sm);"><?php echo esc_html( $step['title'] ); ?></h4>
                    <p style="font-size: var(--text-sm);"><?php echo esc_html( $step['desc'] ); ?></p>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>


<!-- ===== MANIFESTO / BIG TEXT ===== -->
<section class="fresh-section knife-section-top knife-section-bottom" style="background: var(--fresh-charcoal); text-align: center;">
    <div class="fresh-container fresh-container--narrow fade-up">
        <h2 class="fresh-display" style="margin-bottom: var(--space-lg);">
            להפסיק לשלם<br>
            <span class="text-accent">עמלות מיותרות.</span><br>
            להתחיל לבנות<br>
            <span class="knife-highlight">קהל לקוחות משלך.</span>
        </h2>
        <a href="#contact" class="fresh-btn fresh-btn--primary fresh-btn--large">
            בואו נתחיל →
        </a>
    </div>
</section>


<?php get_footer(); ?>
