<?php
/**
 * FRESH Manager — Service Icons System
 * 12 professional inline SVG icons for services + custom upload support.
 */
defined( 'ABSPATH' ) || exit;

/**
 * Get all built-in service icon definitions.
 * Each icon: 48x48 viewBox, stroke style, stroke-width="2", currentColor.
 */
function freshm_get_service_icons() {
    return array(

        /* 1. קמפיינים ממומנים — megaphone with target */
        'paid-campaigns' => array(
            'label' => 'קמפיינים ממומנים',
            'svg'   => '<svg viewBox="0 0 48 48" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M36 8L16 16H8a2 2 0 00-2 2v4a2 2 0 002 2h2l4 12h4l-3-12h1l20 8V8z"/><circle cx="38" cy="20" r="6"/><circle cx="38" cy="20" r="2"/><line x1="32" y1="20" x2="34" y2="20"/><line x1="42" y1="20" x2="44" y2="20"/></svg>',
        ),

        /* 2. שיווק באמצעות משפיענים — person with star */
        'influencer-marketing' => array(
            'label' => 'שיווק משפיענים',
            'svg'   => '<svg viewBox="0 0 48 48" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="20" cy="14" r="7"/><path d="M6 38v-4a12 12 0 0124 0v4"/><polygon points="38 6 39.8 11.2 45 11.2 40.8 14.6 42.4 20 38 16.8 33.6 20 35.2 14.6 31 11.2 36.2 11.2"/><path d="M38 24v2"/><path d="M38 30l-2 8h4l-2-8z"/></svg>',
        ),

        /* 3. ניהול רשתות חברתיות — chat bubbles with heart */
        'social-management' => array(
            'label' => 'ניהול סושיאל',
            'svg'   => '<svg viewBox="0 0 48 48" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M6 30V14a4 4 0 014-4h16a4 4 0 014 4v8a4 4 0 01-4 4H14l-8 6z"/><path d="M30 18h8a4 4 0 014 4v8a4 4 0 01-4 4h-2v6l-6-6h-4a4 4 0 01-4-4v-2"/><path d="M16 20c0 0 1.5-2.5 4-2.5s4 2.5 4 5c0 3-4 5.5-4 5.5s-4-2.5-4-5.5c0-2.5 1.5-5 4-5"/></svg>',
        ),

        /* 4. צילום מנות ווידאו — camera with play button */
        'photo-video' => array(
            'label' => 'צילום ווידאו',
            'svg'   => '<svg viewBox="0 0 48 48" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M42 34a4 4 0 01-4 4H10a4 4 0 01-4-4V18a4 4 0 014-4h6l3-4h10l3 4h6a4 4 0 014 4v16z"/><circle cx="24" cy="25" r="7"/><polygon points="22 22 22 28 27 25" fill="none" stroke="currentColor" stroke-width="2"/></svg>',
        ),

        /* 5. מיתוג מסעדות — palette with diamond */
        'branding' => array(
            'label' => 'מיתוג',
            'svg'   => '<svg viewBox="0 0 48 48" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M24 4C13 4 4 13 4 24s9 20 20 20c1.8 0 3.2-1.4 3.2-3.2 0-.8-.3-1.6-.8-2.2-.5-.5-.8-1.2-.8-2 0-1.8 1.4-3.2 3.2-3.2H33c6 0 11-5 11-11C44 12.6 35.2 4 24 4z"/><circle cx="15" cy="17" r="3"/><circle cx="26" cy="13" r="3"/><circle cx="35" cy="19" r="3"/><circle cx="13" cy="27" r="3"/><polygon points="35 32 38 38 41 32 38 29" stroke="currentColor" fill="none"/></svg>',
        ),

        /* 6. עיצוב תפריט דיגיטלי — menu list with QR */
        'menu-design' => array(
            'label' => 'תפריט דיגיטלי',
            'svg'   => '<svg viewBox="0 0 48 48" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="6" y="4" width="22" height="40" rx="2"/><line x1="12" y1="12" x2="22" y2="12"/><line x1="12" y1="18" x2="20" y2="18"/><line x1="12" y1="24" x2="22" y2="24"/><line x1="12" y1="30" x2="18" y2="30"/><rect x="32" y="28" width="4" height="4"/><rect x="38" y="28" width="4" height="4"/><rect x="32" y="34" width="4" height="4"/><rect x="38" y="34" width="4" height="4"/><rect x="32" y="40" width="4" height="4"/><rect x="38" y="40" width="4" height="4"/><rect x="32" y="22" width="10" height="4"/></svg>',
        ),

        /* 7. בניית אתר למסעדה — monitor with fork/knife */
        'website' => array(
            'label' => 'בניית אתר',
            'svg'   => '<svg viewBox="0 0 48 48" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="4" y="6" width="40" height="28" rx="3"/><line x1="4" y1="26" x2="44" y2="26"/><line x1="20" y1="34" x2="16" y2="42"/><line x1="28" y1="34" x2="32" y2="42"/><line x1="14" y1="42" x2="34" y2="42"/><line x1="20" y1="14" x2="20" y2="22"/><path d="M20 14c0 0-3 1-3 4"/><line x1="28" y1="14" x2="28" y2="22"/><path d="M26 14h4v3a2 2 0 01-2 2 2 2 0 01-2-2v-3z"/></svg>',
        ),

        /* 8. אופטימיזציית משלוחים — scooter with growth arrow */
        'delivery-optimization' => array(
            'label' => 'אופטימיזציית משלוחים',
            'svg'   => '<svg viewBox="0 0 48 48" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="36" r="5"/><circle cx="38" cy="36" r="5"/><path d="M17 36h16"/><path d="M12 31v-8h6l5 8"/><path d="M23 23h8l4 8"/><path d="M8 23h4"/><polyline points="30 6 36 6 36 12"/><line x1="24" y1="18" x2="36" y2="6"/></svg>',
        ),

        /* 9. אופטימיזציית הזמנות שולחן — calendar with checkmark */
        'reservation-optimization' => array(
            'label' => 'הזמנות שולחן',
            'svg'   => '<svg viewBox="0 0 48 48" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="6" y="8" width="36" height="34" rx="3"/><line x1="6" y1="18" x2="42" y2="18"/><line x1="16" y1="4" x2="16" y2="12"/><line x1="32" y1="4" x2="32" y2="12"/><polyline points="18 28 22 32 30 24"/><rect x="14" y="24" width="4" height="2" rx="1" fill="none" stroke="none"/></svg>',
        ),

        /* 10. קידום אורגני (SEO) — magnifier with map pin */
        'seo' => array(
            'label' => 'קידום אורגני',
            'svg'   => '<svg viewBox="0 0 48 48" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="20" cy="20" r="12"/><line x1="29" y1="29" x2="42" y2="42"/><path d="M20 12c-2 0-4 2-4 4.5S18 22 20 24s4 5 4 7.5"/><circle cx="20" cy="17" r="2"/></svg>',
        ),

        /* 11. ניהול מוניטין וביקורות — star with shield */
        'reputation' => array(
            'label' => 'ניהול מוניטין',
            'svg'   => '<svg viewBox="0 0 48 48" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M24 4L8 12v12c0 11 16 20 16 20s16-9 16-20V12L24 4z"/><polygon points="24 14 26.5 19 32 19.8 28 23.7 28.9 29.2 24 26.6 19.1 29.2 20 23.7 16 19.8 21.5 19"/></svg>',
        ),

        /* 12. ניהול מועדון לקוחות — card with people */
        'loyalty' => array(
            'label' => 'מועדון לקוחות',
            'svg'   => '<svg viewBox="0 0 48 48" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="4" y="10" width="40" height="28" rx="3"/><line x1="4" y1="20" x2="44" y2="20"/><circle cx="18" cy="30" r="4"/><circle cx="28" cy="30" r="4"/><path d="M10 40a8 8 0 0116 0"/><path d="M22 40a8 8 0 0116 0"/><line x1="34" y1="14" x2="40" y2="14"/></svg>',
        ),

        /* 13. צילום מנות — camera with plate */
        'food-photography' => array(
            'label' => 'צילום מנות',
            'svg'   => '<svg viewBox="0 0 48 48" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="24" cy="26" r="9"/><path d="M24 17v-3"/><path d="M6 38h36"/><path d="M17 26c0-3.9 3.1-7 7-7s7 3.1 7 7"/><circle cx="24" cy="26" r="3"/><rect x="8" y="10" width="32" height="24" rx="3"/><path d="M20 10l2-4h4l2 4"/></svg>',
        ),

        /* 14. צילומי סטילס — frame with landscape */
        'stills-photography' => array(
            'label' => 'צילומי סטילס',
            'svg'   => '<svg viewBox="0 0 48 48" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="4" y="4" width="40" height="40" rx="3"/><rect x="10" y="10" width="28" height="22" rx="2"/><circle cx="24" cy="21" r="6"/><line x1="18" y1="38" x2="30" y2="38"/><circle cx="35" cy="13" r="2"/></svg>',
        ),

        /* 15. צילומי וידאו — video camera */
        'video-production' => array(
            'label' => 'צילומי וידאו',
            'svg'   => '<svg viewBox="0 0 48 48" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="4" y="12" width="28" height="24" rx="3"/><polygon points="32 20 44 13 44 35 32 28"/><circle cx="18" cy="24" r="4"/><line x1="4" y1="18" x2="32" y2="18"/></svg>',
        ),

        /* 16. אנליטיקס ודוחות — bar chart with trend */
        'analytics' => array(
            'label' => 'אנליטיקס ודוחות',
            'svg'   => '<svg viewBox="0 0 48 48" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="6 36 16 24 24 30 36 14 42 18"/><rect x="8" y="38" width="5" height="6" rx="1"/><rect x="17" y="34" width="5" height="10" rx="1"/><rect x="26" y="30" width="5" height="14" rx="1"/><rect x="35" y="26" width="5" height="18" rx="1"/><polyline points="36 14 42 14 42 18"/></svg>',
        ),
    );
}

/**
 * Get a single built-in service icon SVG markup.
 *
 * @param string $key   Icon key (e.g. 'paid-campaigns')
 * @param int    $size  Pixel size (default 48)
 * @return string       Inline SVG wrapped in span, or empty string
 */
function freshm_get_service_icon( $key, $size = 48 ) {
    $icons = freshm_get_service_icons();
    if ( isset( $icons[ $key ] ) ) {
        return '<span class="service-icon" style="width:' . (int) $size . 'px;height:' . (int) $size . 'px;">'
            . $icons[ $key ]['svg']
            . '</span>';
    }
    return '';
}

/**
 * Render a service icon — built-in SVG or custom uploaded image.
 * Used by ALL templates.
 *
 * @param array|string $service  Service data array (with 'icon' and 'custom_icon' keys) or icon key string
 * @param string       $size     'default' (48px), 'small' (24px), 'mini' (20px)
 * @return string                HTML output
 */
function freshm_render_service_icon( $service, $size = 'default' ) {
    $sizes = array( 'default' => 48, 'small' => 24, 'mini' => 20 );
    $px = $sizes[ $size ] ?? 48;
    $class = 'service-icon';
    if ( $size === 'small' ) $class .= ' icon-sm';
    if ( $size === 'mini' )  $class .= ' icon-xs';

    // If passed a full service data array
    if ( is_array( $service ) ) {
        // 1. Check for custom uploaded icon
        if ( ! empty( $service['custom_icon'] ) ) {
            return '<span class="' . $class . '"><img src="' . esc_url( $service['custom_icon'] ) . '" alt="" width="' . $px . '" height="' . $px . '"></span>';
        }
        $key = $service['icon'] ?? '';
    } else {
        $key = $service;
    }

    // 2. Try built-in service icon
    $icons = freshm_get_service_icons();
    if ( isset( $icons[ $key ] ) ) {
        return '<span class="' . $class . '">' . $icons[ $key ]['svg'] . '</span>';
    }

    // 3. Fallback to theme fresh_svg_icon (emoji-based)
    if ( function_exists( 'fresh_svg_icon' ) ) {
        return fresh_svg_icon( $key ?: '◆', $px );
    }

    // 4. Last resort — return text
    return '<span class="' . $class . '">' . esc_html( $key ?: '◆' ) . '</span>';
}

/**
 * Render icon selector for the admin service card.
 * Shows visual preview grid + custom upload option.
 *
 * @param string $name         Field name attribute prefix
 * @param string $current_key  Currently selected icon key
 * @param string $custom_url   Current custom icon URL
 */
function freshm_render_icon_selector( $name, $current_key = '', $custom_url = '' ) {
    $icons = freshm_get_service_icons();
    ?>
    <div class="freshm-icon-selector">
        <label>אייקון שירות</label>
        <div class="freshm-icon-grid">
            <?php foreach ( $icons as $key => $icon ) : ?>
            <label class="freshm-icon-option<?php echo $current_key === $key ? ' selected' : ''; ?>">
                <input type="radio" name="<?php echo esc_attr( $name ); ?>[icon]" value="<?php echo esc_attr( $key ); ?>"
                    <?php checked( $current_key, $key ); ?>>
                <span class="freshm-icon-preview"><?php echo $icon['svg']; ?></span>
                <span class="freshm-icon-label"><?php echo esc_html( $icon['label'] ); ?></span>
            </label>
            <?php endforeach; ?>
        </div>
        <div class="freshm-custom-icon">
            <label class="freshm-icon-option<?php echo ( ! empty( $custom_url ) && empty( $current_key ) ) ? ' selected' : ''; ?>">
                <input type="radio" name="<?php echo esc_attr( $name ); ?>[icon]" value="custom"
                    <?php checked( ! empty( $custom_url ) && ! isset( $icons[ $current_key ] ) ); ?>>
                <span class="freshm-icon-preview freshm-icon-custom-preview">
                    <?php if ( $custom_url ) : ?>
                        <img src="<?php echo esc_url( $custom_url ); ?>" alt="">
                    <?php else : ?>
                        <span style="font-size:20px;">+</span>
                    <?php endif; ?>
                </span>
                <span class="freshm-icon-label">אייקון מותאם</span>
            </label>
            <div class="freshm-image-field freshm-custom-icon-upload" style="margin-top:8px;">
                <input type="hidden" name="<?php echo esc_attr( $name ); ?>[custom_icon]" value="<?php echo esc_attr( $custom_url ); ?>" class="freshm-image-input">
                <button type="button" class="freshm-btn freshm-upload-btn" style="font-size:12px;">📷 העלה אייקון</button>
                <?php if ( $custom_url ) : ?>
                    <button type="button" class="freshm-btn freshm-remove-btn" style="font-size:12px;">✕</button>
                <?php else : ?>
                    <button type="button" class="freshm-btn freshm-remove-btn" style="font-size:12px;display:none;">✕</button>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php
}
