<?php
/**
 * Archive template
 */
get_header();
?>

<section class="page-hero">
  <div class="container">
    <?php fresh_breadcrumb(); ?>
    <h1><?php the_archive_title(); ?></h1>
    <?php if ( get_the_archive_description() ) : ?>
      <p class="subtitle"><?php echo strip_tags( get_the_archive_description() ); ?></p>
    <?php endif; ?>
  </div>
</section>

<section class="archive-listing">
  <div class="container">
    <?php if ( have_posts() ) : ?>

    <?php if ( is_post_type_archive( 'fresh_service' ) ) : ?>
    <!-- Services archive -->
    <div class="services-listing-grid">
      <?php while ( have_posts() ) : the_post();
        $icon = get_post_meta( get_the_ID(), 'service_icon', true ) ?: '🎯';
      ?>
      <a href="<?php the_permalink(); ?>" class="service-listing-card reveal">
        <div class="service-icon"><?php echo $icon; ?></div>
        <h3><?php the_title(); ?></h3>
        <p><?php echo esc_html( get_the_excerpt() ); ?></p>
        <span class="arrow">←</span>
      </a>
      <?php endwhile; ?>
    </div>

    <?php elseif ( is_post_type_archive( 'fresh_case_study' ) ) : ?>
    <!-- Case Studies archive -->
    <div class="portfolio-listing-grid">
      <?php while ( have_posts() ) : the_post();
        $industry    = get_post_meta( get_the_ID(), 'industry', true );
        $main_result = get_post_meta( get_the_ID(), 'main_result', true );
      ?>
      <a href="<?php the_permalink(); ?>" class="portfolio-listing-card reveal">
        <div class="thumb">
          <?php if ( has_post_thumbnail() ) the_post_thumbnail( 'fresh-portfolio' ); ?>
          <div class="overlay">
            <?php if ( $industry ) : ?><span class="tag"><?php echo esc_html( $industry ); ?></span><?php endif; ?>
            <span class="name"><?php the_title(); ?></span>
            <?php if ( $main_result ) : ?><span class="result"><?php echo esc_html( $main_result ); ?></span><?php endif; ?>
          </div>
        </div>
      </a>
      <?php endwhile; ?>
    </div>

    <?php else : ?>
    <!-- Default blog archive -->
    <div class="blog-grid">
      <?php while ( have_posts() ) : the_post(); ?>
      <div class="blog-card reveal">
        <a href="<?php the_permalink(); ?>">
          <div class="thumb">
            <?php if ( has_post_thumbnail() ) the_post_thumbnail( 'fresh-blog' ); ?>
          </div>
        </a>
        <div class="content">
          <?php $cat = get_the_category(); ?>
          <?php if ( $cat ) : ?>
            <div class="category"><?php echo esc_html( $cat[0]->name ); ?></div>
          <?php endif; ?>
          <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
          <p class="excerpt"><?php echo esc_html( get_the_excerpt() ); ?></p>
          <div class="meta">
            <span><?php echo get_the_date(); ?></span>
            <span><?php echo fresh_reading_time(); ?></span>
          </div>
        </div>
      </div>
      <?php endwhile; ?>
    </div>
    <?php endif; ?>

    <!-- Pagination -->
    <div class="pagination">
      <?php echo paginate_links( array( 'prev_text' => '→', 'next_text' => '←' ) ); ?>
    </div>

    <?php else : ?>
    <div style="text-align:center;padding:4rem 0;">
      <h2>לא נמצאו תוצאות</h2>
      <p style="color:var(--text-secondary);margin-top:1rem;">נסו לחפש משהו אחר.</p>
    </div>
    <?php endif; ?>
  </div>
</section>

<?php get_footer(); ?>
