<?php
// Allow Elementor to override footer
if ( function_exists( 'elementor_theme_do_location' ) && elementor_theme_do_location( 'footer' ) ) {
    wp_footer();
    echo '</body></html>';
    return;
}

// Plugin settings
$brand_text = fm( 'footer', 'brand_text', 'הסוכנות שמסעדנים ממליצים עליה. 15 פתרונות דיגיטליים. מותג אחד. FRESH.' );
$phone   = fm( 'global', 'phone', '050-123-4567' );
$email   = fm( 'global', 'email', 'hello@fresh.agency' );
$address = fm( 'global', 'address', 'תל אביב, ישראל' );
$copyright = fm( 'footer', 'copyright', '© {year} FRESH. כל הזכויות שמורות.' );
$copyright = str_replace( '{year}', date( 'Y' ), $copyright );

// Footer links from plugin
$footer_data    = freshm_get_all( 'footer' );
$services_links = isset( $footer_data['freshm_services_links'] ) ? $footer_data['freshm_services_links'] : array();
$company_links  = isset( $footer_data['freshm_company_links'] ) ? $footer_data['freshm_company_links'] : array();

// Social links
$social_fb    = fm( 'global', 'social_facebook', '#' );
$social_ig    = fm( 'global', 'social_instagram', '#' );
$social_tk    = fm( 'global', 'social_tiktok', '#' );
$social_li    = fm( 'global', 'social_linkedin', '#' );
?>

<!-- ========== FOOTER ========== -->
<footer class="footer">
  <div class="container">
    <div class="footer-main">
      <div class="footer-brand">
        <img src="<?php echo esc_url( fresh_logo_url() ); ?>" alt="<?php bloginfo( 'name' ); ?>" class="footer-logo">
        <p><?php echo esc_html( $brand_text ); ?></p>
        <div class="footer-form-wrapper">
          <p class="footer-form-title">שיחה אחת. זה כל מה שצריך.</p>
          <p class="footer-form-sub">השאירו שם וטלפון - ונחזור אליכם תוך שעות.</p>
          <form class="footer-mini-form" id="footerContactForm">
            <div class="footer-form-row">
              <div class="angled-input-wrap">
                <input type="text" name="name" placeholder="שם מלא" required>
              </div>
              <div class="angled-input-wrap">
                <input type="tel" name="phone" placeholder="טלפון" required>
              </div>
              <button type="submit" class="btn-angled"><span class="arrow">←</span> יאללה</button>
            </div>
          </form>
          <div class="footer-form-status" id="footerFormStatus"></div>
        </div>
      </div>

      <div class="footer-col">
        <h4>שירותים</h4>
        <ul>
          <?php if ( ! empty( $services_links ) ) :
            foreach ( $services_links as $link ) :
              if ( empty( $link['text'] ) ) continue;
          ?>
          <li><a href="<?php echo esc_url( home_url( $link['url'] ?? '/services/' ) ); ?>"><?php echo esc_html( $link['text'] ); ?></a></li>
          <?php endforeach;
          else :
            // Auto-generate from plugin services data
            $footer_svcs = freshm_get_services();
            if ( ! empty( $footer_svcs ) ) :
              usort( $footer_svcs, function( $a, $b ) { return ( $a['order'] ?? 0 ) - ( $b['order'] ?? 0 ); } );
              $footer_svcs = array_slice( $footer_svcs, 0, 6 ); // Max 6 in footer
              foreach ( $footer_svcs as $fs ) :
          ?>
          <li><a href="<?php echo esc_url( home_url( '/service/' . $fs['slug'] . '/' ) ); ?>"><?php echo esc_html( $fs['name'] ); ?></a></li>
          <?php endforeach; else : ?>
          <li><a href="<?php echo esc_url( home_url( '/services/' ) ); ?>">שיווק דיגיטלי</a></li>
          <li><a href="<?php echo esc_url( home_url( '/services/' ) ); ?>">סושיאל ותוכן</a></li>
          <li><a href="<?php echo esc_url( home_url( '/services/' ) ); ?>">אופטימיזציית משלוחים</a></li>
          <li><a href="<?php echo esc_url( home_url( '/services/' ) ); ?>">ברנדינג ועיצוב</a></li>
          <li><a href="<?php echo esc_url( home_url( '/services/' ) ); ?>">CRM ואסטרטגיה</a></li>
          <?php endif; endif; ?>
        </ul>
      </div>

      <div class="footer-col">
        <h4>החברה</h4>
        <ul>
          <?php if ( ! empty( $company_links ) ) :
            foreach ( $company_links as $link ) :
              if ( empty( $link['text'] ) ) continue;
          ?>
          <li><a href="<?php echo esc_url( home_url( $link['url'] ?? '/' ) ); ?>"><?php echo esc_html( $link['text'] ); ?></a></li>
          <?php endforeach; else : ?>
          <li><a href="<?php echo esc_url( home_url( '/about/' ) ); ?>">מי אנחנו</a></li>
          <li><a href="<?php echo esc_url( home_url( '/portfolio/' ) ); ?>">הצלחת לקוחות</a></li>
          <?php if ( fm( 'blog_settings', 'enabled', '1' ) === '1' ) :
            $blog_url = get_permalink( get_option( 'page_for_posts' ) ) ?: home_url( '/blog/' ); ?>
          <li><a href="<?php echo esc_url( $blog_url ); ?>">בלוג</a></li>
          <?php endif; ?>
          <li><a href="<?php echo esc_url( home_url( '/contact/' ) ); ?>">צור קשר</a></li>
          <?php endif; ?>
        </ul>
      </div>

      <div class="footer-col">
        <h4>צור קשר</h4>
        <ul>
          <li><a href="tel:+<?php echo preg_replace('/[^0-9]/', '', $phone); ?>"><?php echo esc_html( $phone ); ?></a></li>
          <li><a href="mailto:<?php echo esc_attr( $email ); ?>"><?php echo esc_html( $email ); ?></a></li>
          <li><?php echo esc_html( $address ); ?></li>
        </ul>
      </div>
    </div>

    <?php
    $footer_map_enabled = fm( 'footer', 'map_enabled', '0' );
    $footer_map_embed   = fm( 'footer', 'map_embed', '' );
    if ( $footer_map_enabled === '1' && $footer_map_embed ) :
    ?>
    <div class="footer-map">
      <?php echo wp_kses( $footer_map_embed, array( 'iframe' => array( 'src' => true, 'width' => true, 'height' => true, 'style' => true, 'frameborder' => true, 'allowfullscreen' => true, 'loading' => true, 'referrerpolicy' => true, 'allow' => true ) ) ); ?>
    </div>
    <?php endif; ?>

    <div class="footer-bottom">
      <p><?php echo wp_kses_post( $copyright ); ?></p>
      <div class="footer-social">
        <?php if ( $social_fb && $social_fb !== '#' ) : ?><a href="<?php echo esc_url( $social_fb ); ?>" aria-label="Facebook" target="_blank" rel="noopener"><?php echo fresh_social_svg( 'facebook' ); ?></a><?php endif; ?>
        <?php if ( $social_ig && $social_ig !== '#' ) : ?><a href="<?php echo esc_url( $social_ig ); ?>" aria-label="Instagram" target="_blank" rel="noopener"><?php echo fresh_social_svg( 'instagram' ); ?></a><?php endif; ?>
        <?php if ( $social_tk && $social_tk !== '#' ) : ?><a href="<?php echo esc_url( $social_tk ); ?>" aria-label="TikTok" target="_blank" rel="noopener"><?php echo fresh_social_svg( 'tiktok' ); ?></a><?php endif; ?>
        <?php if ( $social_li && $social_li !== '#' ) : ?><a href="<?php echo esc_url( $social_li ); ?>" aria-label="LinkedIn" target="_blank" rel="noopener"><?php echo fresh_social_svg( 'linkedin' ); ?></a><?php endif; ?>
      </div>
    </div>
  </div>
</footer>

<!-- ========== POPUP CONTACT FORM ========== -->
<div class="popup-overlay" id="popupContact">
  <div class="popup-backdrop"></div>
  <div class="popup-container">
    <button class="popup-close" aria-label="סגור">&times;</button>
    <div class="popup-header">
      <h3><?php echo esc_html( fm( 'contact', 'form_title', 'בואו נדבר' ) ); ?></h3>
      <p><?php echo esc_html( fm( 'contact', 'form_subtitle', '30 שניות של פרטים. שיחה אחת שתשנה את הנוכחות הדיגיטלית של המסעדה שלכם.' ) ); ?></p>
    </div>
    <form class="popup-form" id="popupContactForm">
      <div class="popup-fields">
        <div class="popup-field">
          <input type="text" name="name" required placeholder="שם מלא *">
        </div>
        <div class="popup-field">
          <input type="text" name="restaurant" placeholder="שם המסעדה">
        </div>
        <div class="popup-field">
          <input type="tel" name="phone" required placeholder="טלפון *">
        </div>
        <div class="popup-field">
          <input type="email" name="email" placeholder="אימייל">
        </div>
        <div class="popup-field popup-field-full">
          <textarea name="message" rows="3" placeholder="ספרו לנו בכמה מילים על המסעדה שלכם"></textarea>
        </div>
      </div>
      <button type="submit" class="btn-primary popup-submit"><?php echo esc_html( fm( 'contact', 'form_btn_text', 'רוצה לשמוע עוד ←' ) ); ?></button>
      <div class="popup-status" id="popupStatus"></div>
    </form>
  </div>
</div>

<?php wp_footer(); ?>
</body>
</html>
