<?php
/**
 * Template Name: דף הבית
 * Front page template — All content managed via FRESH Manager plugin
 */
get_header();
$h = 'homepage';
?>

<!-- ========== HERO ========== -->
<section class="hero" id="hero">
  <div class="container">
    <div class="hero-content">
      <div class="hero-badge">
        <span class="dot"></span>
        <?php echo esc_html( fm( $h, 'hero_badge', 'הסוכנות הדיגיטלית #1 למסעדנות' ) ); ?>
      </div>
      <h1>
        <span class="line"><?php echo esc_html( fm( $h, 'hero_title_1', 'המסעדה שלכם מדברת דרך האוכל.' ) ); ?></span>
        <span class="line gold-line"><?php echo esc_html( fm( $h, 'hero_title_2', 'אנחנו נדאג שהעולם ישמע.' ) ); ?></span>
      </h1>
      <p class="hero-text"><?php echo wp_kses_post( nl2br( fm( $h, 'hero_subtitle', 'שיווק דיגיטלי שנבנה סביב המסעדה שלכם - מקמפיינים ממומנים ועד ניהול משלוחים, מועדון לקוחות, מוניטין ותוכן שמביא אנשים לשבת אצלכם.' ) ) ); ?></p>
      <div class="hero-buttons">
        <a href="#" class="btn-primary" data-popup="contact"><?php echo esc_html( fm( $h, 'hero_cta_text', 'בואו נדבר' ) ); ?></a>
        <a href="<?php echo esc_url( fm( $h, 'hero_cta2_url', home_url( '/about/' ) ) ); ?>" class="btn-outline"><?php echo esc_html( fm( $h, 'hero_cta2_text', 'הכירו אותנו' ) ); ?></a>
      </div>
    </div>

    <div class="hero-visual">
      <div class="hero-stats-grid">
        <?php
        $hero_stats_data = freshm_get_all( $h );
        $hero_stats = isset( $hero_stats_data['freshm_hero_stats'] ) ? $hero_stats_data['freshm_hero_stats'] : array();
        if ( ! empty( $hero_stats ) ) :
          $delays = array( '', 'reveal-delay-1', 'reveal-delay-2', 'reveal-delay-3' );
          foreach ( $hero_stats as $i => $stat ) :
        ?>
        <div class="hero-stat reveal <?php echo $delays[ $i ] ?? ''; ?>">
          <div class="number" data-count="<?php echo esc_attr( $stat['number'] ?? '0' ); ?>">0<?php echo esc_html( $stat['suffix'] ?? '' ); ?></div>
          <div class="label"><?php echo esc_html( $stat['label'] ?? '' ); ?></div>
        </div>
        <?php endforeach; else : ?>
        <div class="hero-stat reveal"><div class="number" data-count="50">0+</div><div class="label">מסעדות פעילות</div></div>
        <div class="hero-stat reveal reveal-delay-1"><div class="number" data-count="300">0+</div><div class="label">קמפיינים שהושקו</div></div>
        <div class="hero-stat reveal reveal-delay-2"><div class="number" data-count="98">0%</div><div class="label">שביעות רצון לקוחות</div></div>
        <div class="hero-stat reveal reveal-delay-3"><div class="number" data-count="15">0</div><div class="label">פתרונות דיגיטליים</div></div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</section>

<!-- ========== LOGO BAR ========== -->
<div class="logo-bar">
  <div class="logo-track">
    <?php
    $logo_data = freshm_get_all( $h );
    $logos = isset( $logo_data['freshm_logos'] ) ? $logo_data['freshm_logos'] : array();
    if ( ! empty( $logos ) ) :
      $items = array_merge( $logos, $logos ); // double for marquee
      foreach ( $items as $logo ) :
        if ( ! empty( $logo['image'] ) ) :
    ?>
    <span class="client-logo"><img src="<?php echo esc_url( $logo['image'] ); ?>" alt="<?php echo esc_attr( $logo['name'] ?? '' ); ?>"></span>
    <?php else : ?>
    <span class="client-logo"><?php echo esc_html( $logo['name'] ?? '' ); ?></span>
    <?php endif; endforeach; else :
      $clients = array( 'MESHEK BARZILAY', 'OCD RESTAURANT', 'NORTH ABRAXAS', 'HAACHIM', 'CLARO', 'MASHYA', 'POPINA', 'ROMANO', 'THE BLUE ROOSTER', 'DALIDA' );
      foreach ( array_merge( $clients, $clients ) as $client ) :
    ?>
    <span class="client-logo"><?php echo esc_html( $client ); ?></span>
    <?php endforeach; endif; ?>
  </div>
</div>

<!-- ========== WHAT WE DO ========== -->
<section class="what-we-do" id="about">
  <div class="container">
    <div class="section-label reveal"><?php echo esc_html( fm( $h, 'about_label', 'מה אנחנו עושים' ) ); ?></div>
    <h2 class="section-title reveal reveal-delay-1">
      <?php echo esc_html( fm( $h, 'about_title', 'לא רק משווקים.' ) ); ?><br>
      <span class="gold"><?php echo esc_html( fm( $h, 'about_title_gold', 'בונים מערכת שלמה שמגדילה את המסעדה.' ) ); ?></span>
    </h2>
    <?php
    $hp_data       = freshm_get_all( $h );
    $about_cards   = isset( $hp_data['freshm_about_features'] ) ? $hp_data['freshm_about_features'] : array();
    if ( empty( $about_cards ) ) {
        $about_cards = array(
            array( 'icon' => '📢', 'title' => 'קמפיינים שמביאים סועדים', 'desc' => 'פרסום ממומן ב-Facebook, Instagram, Google ו-TikTok עם מיקוד גיאוגרפי חכם. אנחנו יודעים מתי הלקוח רעב, איפה הוא גר, ומה יגרום לו להזמין - עכשיו.' ),
            array( 'icon' => '⚙️', 'title' => 'תפעול דיגיטלי שמסדר את הבלאגן', 'desc' => 'חיבור בין כל המערכות שלכם - Wolt, 10bis, הזמנות שולחן, מועדון לקוחות, CRM ודוחות. פחות טלפונים, פחות טעויות, יותר שליטה.' ),
            array( 'icon' => '🎬', 'title' => 'תקשורת שמחזירה לקוחות', 'desc' => 'WhatsApp, SMS ומיילים שעובדים בשבילכם ברקע - תזכורות, הטבות ליום הולדת, קמפיינים עונתיים. הלקוחות שכבר אכלו אצלכם? הם השווים ביותר.' ),
            array( 'icon' => '🤝', 'title' => 'שותפות שמובילה לתוצאות', 'desc' => 'אנחנו לא ספקים. אנחנו חלק מהצוות שלכם. יושבים אתכם, מבינים את המטבח, את הקהל ואת המספרים - ומתרגמים את הכל לפעולות דיגיטליות שמייצרות צמיחה.' ),
        );
    }
    ?>
    <div class="whatwedo-grid reveal reveal-delay-2">
      <?php foreach ( $about_cards as $card ) : ?>
      <div class="whatwedo-card">
        <div class="whatwedo-icon"><?php echo fresh_svg_icon( $card['icon'] ?? '📢', 28 ); ?></div>
        <h3><?php echo esc_html( $card['title'] ?? '' ); ?></h3>
        <p><?php echo esc_html( $card['desc'] ?? '' ); ?></p>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<!-- ========== STATS ========== -->
<section class="stats">
  <div class="container">
    <div class="stats-grid">
      <?php
      $homepage_data = freshm_get_all( $h );
      $stats_items = isset( $homepage_data['freshm_stats'] ) ? $homepage_data['freshm_stats'] : array();
      if ( ! empty( $stats_items ) ) :
        foreach ( $stats_items as $stat ) :
      ?>
      <div class="stat-item reveal">
        <div class="stat-number"><?php echo esc_html( $stat['number'] ?? '' ); ?><span><?php echo esc_html( $stat['suffix'] ?? '' ); ?></span></div>
        <div class="stat-label"><?php echo esc_html( $stat['label'] ?? '' ); ?></div>
      </div>
      <?php endforeach; else : ?>
      <div class="stat-item reveal"><div class="stat-number">50<span>+</span></div><div class="stat-label">מסעדות פעילות</div></div>
      <div class="stat-item reveal reveal-delay-1"><div class="stat-number">300<span>+</span></div><div class="stat-label">קמפיינים שהושקו</div></div>
      <div class="stat-item reveal reveal-delay-2"><div class="stat-number">98<span>%</span></div><div class="stat-label">שביעות רצון לקוחות</div></div>
      <div class="stat-item reveal reveal-delay-3"><div class="stat-number">8<span>+</span></div><div class="stat-label">שנות ניסיון בתעשייה</div></div>
      <div class="stat-item reveal"><div class="stat-number">1,000,000<span>+</span></div><div class="stat-label">חשיפות חודשיות</div></div>
      <div class="stat-item reveal reveal-delay-1"><div class="stat-number">15<span></span></div><div class="stat-label">פתרונות דיגיטליים</div></div>
      <?php endif; ?>
    </div>
  </div>
</section>

<!-- ========== SERVICES ========== -->
<section class="services" id="services">
  <div class="container">
    <div class="section-label reveal"><?php echo esc_html( fm( $h, 'services_label', 'השירותים שלנו' ) ); ?></div>
    <h2 class="section-title reveal reveal-delay-1">
      <?php echo esc_html( fm( $h, 'services_title', '15 פתרונות' ) ); ?><br>
      <span class="gold"><?php echo esc_html( fm( $h, 'services_title_gold', 'לצמיחת המסעדה שלך' ) ); ?></span>
    </h2>
    <p class="section-subtitle reveal reveal-delay-2"><?php echo esc_html( fm( $h, 'services_subtitle', 'כל מה שמסעדה צריכה כדי להתבלט, למשוך לקוחות חדשים, ולגדול - במקום אחד.' ) ); ?></p>

    <!-- Category Tabs -->
    <?php
    $plugin_cats = freshm_get_service_cats();
    if ( ! empty( $plugin_cats ) ) :
    ?>
    <div class="services-tabs reveal reveal-delay-3">
      <button class="tab-btn active" data-category="all">הכל</button>
      <?php foreach ( $plugin_cats as $cat ) : ?>
      <button class="tab-btn" data-category="<?php echo esc_attr( $cat['slug'] ); ?>"><?php echo esc_html( $cat['name'] ); ?></button>
      <?php endforeach; ?>
    </div>
    <?php else :
      $wp_cats = get_terms( array( 'taxonomy' => 'service_category', 'hide_empty' => true, 'orderby' => 'term_id' ) );
      if ( ! is_wp_error( $wp_cats ) && ! empty( $wp_cats ) ) :
    ?>
    <div class="services-tabs reveal reveal-delay-3">
      <button class="tab-btn active" data-category="all">הכל</button>
      <?php foreach ( $wp_cats as $cat ) : ?>
      <button class="tab-btn" data-category="<?php echo esc_attr( $cat->slug ); ?>"><?php echo esc_html( $cat->name ); ?></button>
      <?php endforeach; ?>
    </div>
    <?php endif; endif; ?>

    <div class="services-grid">
      <?php
      $plugin_services = freshm_get_services();
      if ( ! empty( $plugin_services ) ) :
        foreach ( $plugin_services as $sv ) :
          $sv_url = home_url( '/service/' . $sv['slug'] . '/' );
      ?>
      <a href="<?php echo esc_url( $sv_url ); ?>" class="service-card" data-category="<?php echo esc_attr( $sv['category'] ); ?>">
        <?php
          if ( function_exists( 'freshm_render_service_icon' ) ) {
              echo freshm_render_service_icon( $sv, 'default' );
          } else {
              echo '<div class="service-icon">' . fresh_svg_icon( $sv['icon'] ?: '◆', 28 ) . '</div>';
          }
        ?>
        <h3><?php echo esc_html( $sv['name'] ); ?></h3>
        <p><?php echo esc_html( wp_trim_words( $sv['excerpt'], 15 ) ); ?></p>
        <span class="arrow">←</span>
      </a>
      <?php endforeach;
      else :
        // Fallback: query CPT
        $services_query = new WP_Query( array(
            'post_type' => 'fresh_service', 'posts_per_page' => -1,
            'orderby' => 'menu_order', 'order' => 'ASC',
        ) );
        if ( $services_query->have_posts() ) :
          while ( $services_query->have_posts() ) : $services_query->the_post();
            $s_icon = get_post_meta( get_the_ID(), 'service_icon', true ) ?: '◆';
            $s_cats = get_the_terms( get_the_ID(), 'service_category' );
            $s_cat_slug = ( $s_cats && ! is_wp_error( $s_cats ) ) ? $s_cats[0]->slug : '';
        ?>
        <a href="<?php the_permalink(); ?>" class="service-card" data-category="<?php echo esc_attr( $s_cat_slug ); ?>">
          <div class="service-icon"><?php echo function_exists('freshm_render_service_icon') ? freshm_render_service_icon( $s_icon, 'small' ) : fresh_svg_icon( $s_icon, 28 ); ?></div>
          <h3><?php the_title(); ?></h3>
          <p><?php echo esc_html( wp_trim_words( get_the_excerpt(), 15 ) ); ?></p>
          <span class="arrow">←</span>
        </a>
        <?php endwhile; wp_reset_postdata();
        else :
          $fallback_services = array(
              array( 'paid-campaigns', 'קמפיינים ממומנים', 'ניהול קמפיינים ב-Facebook, Instagram, Google ו-TikTok' ),
              array( 'influencer-marketing', 'שיווק באמצעות משפיענים', 'חיבור המסעדה שלכם למשפיעני אוכל ולייפסטייל' ),
              array( 'social-management', 'ניהול רשתות חברתיות', 'אסטרטגיית תוכן, עיצוב ופרסום בכל הפלטפורמות' ),
              array( 'photo-video', 'צילום מנות ווידאו', 'צילומי סטילס, ריילס וסרטי תדמית' ),
              array( 'branding', 'מיתוג מסעדות', 'זהות מותגית שנחרטת בזיכרון' ),
              array( 'seo', 'קידום אורגני - SEO', 'דירוג בגוגל מפות וחיפוש אורגני' ),
          );
          foreach ( $fallback_services as $fs ) :
        ?>
        <div class="service-card">
          <div class="service-icon"><?php echo function_exists('freshm_render_service_icon') ? freshm_render_service_icon( $fs[0], 'small' ) : fresh_svg_icon( $fs[0], 28 ); ?></div>
          <h3><?php echo esc_html( $fs[1] ); ?></h3>
          <p><?php echo esc_html( $fs[2] ); ?></p>
        </div>
        <?php endforeach; endif; endif; ?>
    </div>

    <div style="text-align:center;margin-top:3rem;" class="reveal">
      <a href="<?php echo esc_url( home_url( '/services/' ) ); ?>" class="btn-primary">צפו בכל השירותים ←</a>
    </div>
  </div>
</section>

<!-- ========== WHY FRESH ========== -->
<section class="why-fresh" id="why-fresh">
  <div class="container">
    <div class="section-label reveal"><?php echo esc_html( fm( $h, 'why_label', 'למה אנחנו' ) ); ?></div>
    <h2 class="section-title reveal reveal-delay-1">
      <?php echo esc_html( fm( $h, 'why_title', 'למה מסעדות בוחרות' ) ); ?><br>
      <span class="gold"><?php echo esc_html( fm( $h, 'why_title_gold', 'לעבוד איתנו' ) ); ?></span>
    </h2>
    <p class="section-subtitle reveal reveal-delay-2"><?php echo esc_html( fm( $h, 'why_subtitle', 'כי אנחנו לא סוכנות דיגיטל שפשוט גם עובדת עם מסעדות. אנחנו סוכנות שזה כל מה שהיא עושה.' ) ); ?></p>
    <div class="why-fresh-grid">
      <?php
      $why_data = freshm_get_all( $h );
      $why_values = isset( $why_data['freshm_why_values'] ) ? $why_data['freshm_why_values'] : array();
      if ( ! empty( $why_values ) ) :
        foreach ( $why_values as $wi => $wv ) :
      ?>
      <div class="why-fresh-card reveal <?php echo $wi > 0 ? 'reveal-delay-' . min($wi, 3) : ''; ?>">
        <div class="why-fresh-icon"><?php echo fresh_svg_icon( $wv['icon'] ?? '🎯', 28 ); ?></div>
        <h3><?php echo esc_html( $wv['title'] ?? '' ); ?></h3>
        <p><?php echo esc_html( $wv['desc'] ?? '' ); ?></p>
      </div>
      <?php endforeach; else :
        $def_why = array(
            array( '🎯', 'מומחיות בתעשייה', 'אנחנו עובדים אך ורק עם מסעדות ועסקי F&B. מכירים את המונחים, מבינים את האתגרים, יודעים מה ההבדל בין ערב רגיל לערב חג. הידע הזה בא לידי ביטוי בכל החלטה שאנחנו מקבלים.' ),
            array( '📊', 'שקיפות מלאה', 'דוחות ברורים, מספרים אמיתיים, בלי בלבולים. אתם תמיד יודעים לאן הולך התקציב ומה הוא מייצר. אם משהו לא עובד - נגיד את זה ראשונים.' ),
            array( '🚀', 'חדשנות', 'הדיגיטל משתנה כל יום. אנחנו תמיד בחזית - מטכנולוגיות AI ועד טרנדים ב-TikTok. המסעדה שלכם לא תישאר מאחור.' ),
            array( '⚡', 'גמישות', 'אין חבילות סטנדרטיות. כל מסעדה מקבלת תוכנית שמותאמת לגודל, לתקציב ולשלב שבו היא נמצאת. בין אם אתם פותחים עכשיו ובין אם אתם רשת של 20 סניפים.' ),
            array( '🤝', 'שותפות אמיתית', 'אנחנו חלק מהצוות שלכם. כשהמסעדה מלאה - אנחנו שמחים. כשיש בעיה - אנחנו שם. לא סתם ספקים, שותפים לדרך.' ),
            array( '💎', 'תוצאות מדידות', 'כל שקל שאתם משקיעים - אנחנו יודעים בדיוק מה הוא הביא. לידים, הזמנות, ביקורות, כניסות. לא תחושות - מספרים.' ),
        );
        foreach ( $def_why as $wi => $dw ) :
      ?>
      <div class="why-fresh-card reveal <?php echo $wi > 0 ? 'reveal-delay-' . min($wi, 3) : ''; ?>">
        <div class="why-fresh-icon"><?php echo fresh_svg_icon( $dw[0], 28 ); ?></div>
        <h3><?php echo esc_html( $dw[1] ); ?></h3>
        <p><?php echo esc_html( $dw[2] ); ?></p>
      </div>
      <?php endforeach; endif; ?>
    </div>
  </div>
</section>

<!-- ========== REELS VIDEO CAROUSEL ========== -->
<?php
$vc_all     = freshm_get_all( 'video_carousel' );
$vc_videos  = isset( $vc_all['freshm_videos'] ) ? $vc_all['freshm_videos'] : array();
$vc_enabled = fm( 'video_carousel', 'enabled', '1' );

if ( $vc_enabled === '1' && ! empty( $vc_videos ) ) :
?>
<section class="reels-section" id="showreel">
  <div class="container">
    <div class="section-label reveal"><?php echo esc_html( fm( 'video_carousel', 'section_label', 'ראו אותנו בפעולה' ) ); ?></div>
    <h2 class="section-title reveal reveal-delay-1">
      <?php echo esc_html( fm( 'video_carousel', 'section_title', 'גלריית' ) ); ?><br>
      <span class="gold"><?php echo esc_html( fm( 'video_carousel', 'section_title_gold', 'וידאו' ) ); ?></span>
    </h2>
    <p class="section-subtitle reveal reveal-delay-2" style="text-align:center;margin:0 auto 3rem;"><?php echo esc_html( fm( 'video_carousel', 'section_subtitle', 'טעימה קטנה ממה שאנחנו יוצרים. כי אצלנו, כל רילס הוא הזמנה לשבת לאכול.' ) ); ?></p>

    <div class="reels-carousel reveal reveal-delay-3">
      <div class="reels-track">
        <?php foreach ( $vc_videos as $vi => $video ) :
          if ( empty( $video['url'] ) ) continue;
          $v_url   = $video['url'];
          $v_title = $video['title'] ?? '';
          $v_thumb = $video['thumbnail'] ?? '';
          if ( ! $v_thumb ) {
              $v_thumb = fresh_youtube_thumb( $v_url );
          }
          $embed = fresh_embed_url( $v_url );
        ?>
        <div class="reel-card" data-embed="<?php echo esc_url( $embed ); ?>">
          <div class="reel-thumb">
            <?php if ( $v_thumb ) : ?>
              <img src="<?php echo esc_url( $v_thumb ); ?>" alt="<?php echo esc_attr( $v_title ); ?>" loading="lazy">
            <?php else : ?>
              <div class="reel-placeholder">🎬</div>
            <?php endif; ?>
            <div class="reel-play">
              <div class="reel-play-btn">▶</div>
            </div>
          </div>
          <?php if ( $v_title ) : ?>
            <div class="reel-title"><?php echo esc_html( $v_title ); ?></div>
          <?php endif; ?>
        </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
</section>

<!-- Video Lightbox -->
<div class="vc-lightbox" id="vcLightbox">
  <div class="vc-lightbox-overlay"></div>
  <div class="vc-lightbox-content">
    <button class="vc-lightbox-close" aria-label="סגור">✕</button>
    <div class="vc-lightbox-player">
      <iframe id="vcLightboxIframe" src="" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
    </div>
  </div>
</div>
<?php else : ?>
<!-- Fallback: no videos configured -->
<section class="reels-section" id="showreel">
  <div class="container">
    <div class="section-label reveal"><?php echo esc_html( fm( $h, 'videos_label', 'ראו אותנו בפעולה' ) ); ?></div>
    <h2 class="section-title reveal reveal-delay-1">
      <?php echo esc_html( fm( $h, 'videos_title', 'הסרטונים' ) ); ?><br>
      <span class="gold"><?php echo esc_html( fm( $h, 'videos_title_gold', 'שלנו' ) ); ?></span>
    </h2>
    <div class="reels-carousel reveal reveal-delay-2">
      <div class="reels-track">
        <?php for ( $i = 0; $i < 5; $i++ ) : ?>
        <div class="reel-card">
          <div class="reel-thumb">
            <div class="reel-placeholder">🎬</div>
          </div>
        </div>
        <?php endfor; ?>
      </div>
    </div>
  </div>
</section>
<?php endif; ?>

<!-- ========== PORTFOLIO ========== -->
<section class="portfolio" id="portfolio">
  <div class="container">
    <div class="section-label reveal"><?php echo esc_html( fm( $h, 'portfolio_label', 'עבודות נבחרות' ) ); ?></div>
    <h2 class="section-title reveal reveal-delay-1">
      <?php echo esc_html( fm( $h, 'portfolio_title', 'הנה מה שעשינו' ) ); ?><br>
      <span class="gold"><?php echo esc_html( fm( $h, 'portfolio_title_gold', 'ללקוחות שלנו' ) ); ?></span>
    </h2>

    <div class="portfolio-grid">
      <?php
      $p_count = intval( fm( $h, 'portfolio_count', '5' ) ) ?: 5;
      $plugin_stories = freshm_get_stories();
      if ( ! empty( $plugin_stories ) ) :
        $shown = 0;
        foreach ( $plugin_stories as $story ) :
          if ( $shown >= $p_count ) break;
          $story_url = home_url( '/client-success/' . $story['slug'] . '/' );
          $main_result = ! empty( $story['metrics'][0] ) ? $story['metrics'][0]['number'] . ' ' . $story['metrics'][0]['label'] : '';
      ?>
      <a href="<?php echo esc_url( $story_url ); ?>" class="portfolio-card reveal">
        <div class="portfolio-image">
          <?php if ( $story['image'] ) : ?><img src="<?php echo esc_url( $story['image'] ); ?>" alt="<?php echo esc_attr( $story['name'] ); ?>"><?php else : ?><div class="placeholder-img">📸</div><?php endif; ?>
          <?php if ( ! empty( $story['logo'] ) ) : ?>
            <span class="card-logo-badge"><img src="<?php echo esc_url( $story['logo'] ); ?>" alt=""></span>
          <?php endif; ?>
        </div>
        <div class="portfolio-overlay">
          <div class="portfolio-meta"><?php echo esc_html( $story['industry'] ?: 'הצלחת לקוח' ); ?></div>
          <h3><?php echo esc_html( $story['name'] ); ?></h3>
          <?php if ( $main_result ) : ?><p class="portfolio-stat"><?php echo esc_html( $main_result ); ?></p><?php endif; ?>
        </div>
      </a>
      <?php $shown++; endforeach;
      else :
        // Fallback: CPT query
        $portfolio_query = new WP_Query( array(
            'post_type' => 'fresh_case_study', 'posts_per_page' => $p_count,
            'orderby' => 'date', 'order' => 'DESC',
        ) );
        if ( $portfolio_query->have_posts() ) :
          while ( $portfolio_query->have_posts() ) : $portfolio_query->the_post();
            $industry = get_post_meta( get_the_ID(), 'industry', true );
            $main_result = get_post_meta( get_the_ID(), 'main_result', true );
        ?>
        <a href="<?php the_permalink(); ?>" class="portfolio-card reveal">
          <div class="portfolio-image">
            <?php if ( has_post_thumbnail() ) the_post_thumbnail( 'fresh-portfolio' ); else echo '<div class="placeholder-img">📸</div>'; ?>
          </div>
          <div class="portfolio-overlay">
            <div class="portfolio-meta"><?php echo esc_html( $industry ?: 'הצלחת לקוח' ); ?></div>
            <h3><?php the_title(); ?></h3>
            <?php if ( $main_result ) : ?><p class="portfolio-stat"><?php echo esc_html( $main_result ); ?></p><?php endif; ?>
          </div>
        </a>
        <?php endwhile; wp_reset_postdata();
        endif;
      endif;
      if ( empty( $plugin_stories ) && ( ! isset( $portfolio_query ) || ! $portfolio_query->have_posts() ) ) :
        $fallback_portfolio = array(
            array( 'ROMA TLV', 'מסעדה איטלקית', '+280% בהזמנות' ),
            array( 'SAKURA', 'מסעדת סושי', '+450% עוקבים' ),
            array( 'GREEN QUEEN', 'בריאות וטבעוני', '-40% עמלות' ),
            array( 'BURGER NATION', 'המבורגריה', '+180% הכנסות' ),
            array( 'NOIR CAFÉ', 'בית קפה', '+320% לידים' ),
        );
        foreach ( $fallback_portfolio as $fp ) :
      ?>
      <div class="portfolio-card reveal">
        <div class="portfolio-image"><div class="placeholder-img">📸</div></div>
        <div class="portfolio-overlay">
          <div class="portfolio-meta"><?php echo esc_html( $fp[1] ); ?></div>
          <h3><?php echo esc_html( $fp[0] ); ?></h3>
          <p class="portfolio-stat"><?php echo esc_html( $fp[2] ); ?></p>
        </div>
      </div>
      <?php endforeach; endif; ?>
    </div>
  </div>
</section>

<!-- ========== SOCIAL GALLERY ========== -->
<section class="gallery-section" id="gallery">
  <div class="container">
    <div class="section-label reveal"><?php echo esc_html( fm( $h, 'gallery_label', 'דוגמאות תוכן' ) ); ?></div>
    <h2 class="section-title reveal reveal-delay-1"><?php echo esc_html( fm( $h, 'gallery_title', 'תוכן שאנחנו יוצרים' ) ); ?></h2>
    <div class="gallery-grid reveal reveal-delay-2">
      <?php
      $gal_data = freshm_get_all( $h );
      $gallery_items = isset( $gal_data['freshm_gallery_items'] ) ? $gal_data['freshm_gallery_items'] : array();
      if ( ! empty( $gallery_items ) ) :
        foreach ( $gallery_items as $gi ) :
      ?>
      <div class="gallery-item">
        <?php if ( ! empty( $gi['image'] ) ) : ?>
          <img src="<?php echo esc_url( $gi['image'] ); ?>" alt="<?php echo esc_attr( $gi['title'] ?? '' ); ?>" loading="lazy">
        <?php else : ?>
          <div class="gallery-placeholder">📸</div>
        <?php endif; ?>
        <?php if ( ! empty( $gi['type'] ) ) : ?><div class="gallery-badge"><?php echo esc_html( $gi['type'] ); ?></div><?php endif; ?>
      </div>
      <?php endforeach; else :
        for ( $i = 0; $i < 6; $i++ ) :
      ?>
      <div class="gallery-item"><div class="gallery-placeholder">📸</div></div>
      <?php endfor; endif; ?>
    </div>
  </div>
</section>

<!-- ========== TESTIMONIALS ========== -->
<section class="testimonials" id="testimonials">
  <div class="container">
    <div class="section-label reveal"><?php echo esc_html( fm( $h, 'testimonials_label', 'מה הלקוחות אומרים' ) ); ?></div>
    <h2 class="section-title reveal reveal-delay-1">
      <?php echo esc_html( fm( $h, 'testimonials_title', 'התוצאות שלנו מדברות.' ) ); ?><br>
      <span class="gold"><?php echo esc_html( fm( $h, 'testimonials_title_gold', 'הלקוחות שלנו מאשרים.' ) ); ?></span>
    </h2>
    <div class="testimonials-grid">
      <?php
      $test_data = freshm_get_all( $h );
      $testimonials = isset( $test_data['freshm_testimonials'] ) ? $test_data['freshm_testimonials'] : array();
      if ( ! empty( $testimonials ) ) :
        foreach ( $testimonials as $ti => $t ) :
      ?>
      <div class="testimonial-card reveal <?php echo $ti > 0 ? 'reveal-delay-' . min($ti, 3) : ''; ?>">
        <div class="stars"><?php echo fresh_stars_svg( 5 ); ?></div>
        <p><?php echo esc_html( $t['text'] ?? '' ); ?></p>
        <div class="testimonial-author">
          <?php if ( ! empty( $t['image'] ) ) : ?>
            <img src="<?php echo esc_url( $t['image'] ); ?>" alt="" class="author-img" loading="lazy">
          <?php else : ?>
            <div class="author-avatar"><?php echo esc_html( $t['initial'] ?? mb_substr( $t['name'] ?? '', 0, 1 ) ); ?></div>
          <?php endif; ?>
          <div><strong><?php echo esc_html( $t['name'] ?? '' ); ?></strong><br><span><?php echo esc_html( $t['role'] ?? '' ); ?></span></div>
        </div>
      </div>
      <?php endforeach; else :
        $fallback_testimonials = array(
            array( 'text' => 'FRESH שינו את המשחק שלנו. תוך 3 חודשים הכפלנו את ההזמנות האונליין.', 'name' => 'אורי כהן', 'role' => 'בעלים, ROMA TLV', 'init' => 'א' ),
            array( 'text' => 'הצוות מבין את שפת המסעדנות. הם לא צריכים הסברים - הם פשוט יודעים.', 'name' => 'מיכל לוי', 'role' => 'סמנכ"לית שיווק, OCD', 'init' => 'מ' ),
            array( 'text' => 'החזר ההשקעה מטורף. כל שקל שהשקענו בפרסום חזר פי 5.', 'name' => 'דני שמש', 'role' => 'מייסד, SAKURA', 'init' => 'ד' ),
        );
        foreach ( $fallback_testimonials as $fi => $ft ) :
      ?>
      <div class="testimonial-card reveal <?php echo $fi > 0 ? 'reveal-delay-' . $fi : ''; ?>">
        <div class="stars"><?php echo fresh_stars_svg( 5 ); ?></div>
        <p><?php echo esc_html( $ft['text'] ); ?></p>
        <div class="testimonial-author">
          <div class="author-avatar"><?php echo $ft['init']; ?></div>
          <div><strong><?php echo esc_html( $ft['name'] ); ?></strong><br><span><?php echo esc_html( $ft['role'] ); ?></span></div>
        </div>
      </div>
      <?php endforeach; endif; ?>
    </div>
  </div>
</section>

<!-- ========== PROCESS / 4 STEPS ========== -->
<section class="process" id="process">
  <div class="container">
    <div class="process-header">
      <div class="section-label reveal"><?php echo esc_html( fm( $h, 'process_label', 'איך זה עובד' ) ); ?></div>
      <h2 class="section-title reveal reveal-delay-1">
        <?php echo esc_html( fm( $h, 'process_title', '4 צעדים' ) ); ?><br>
        <span class="gold"><?php echo esc_html( fm( $h, 'process_title_gold', 'לצמיחה דיגיטלית' ) ); ?></span>
      </h2>
    </div>
    <div class="process-steps">
      <?php
      $process_data = freshm_get_all( $h );
      $process_steps = isset( $process_data['freshm_process_steps'] ) ? $process_data['freshm_process_steps'] : array();
      if ( ! empty( $process_steps ) ) :
        foreach ( $process_steps as $si => $step ) :
      ?>
      <div class="process-step reveal <?php echo $si > 0 ? 'reveal-delay-' . min($si, 3) : ''; ?>">
        <?php if ( ! empty( $step['icon'] ) ) : ?>
        <div class="step-icon"><?php echo fresh_svg_icon( $step['icon'], 28 ); ?></div>
        <?php endif; ?>
        <div class="step-number"><?php echo esc_html( str_pad( $si + 1, 2, '0', STR_PAD_LEFT ) ); ?></div>
        <h3><?php echo esc_html( $step['title'] ?? '' ); ?></h3>
        <p><?php echo esc_html( $step['desc'] ?? '' ); ?></p>
      </div>
      <?php endforeach; else :
        $def_steps = array(
            array( '📞', 'שיחת היכרות', 'נפגשים, מכירים את המסעדה, מבינים את האתגרים והיעדים שלכם - בלי התחייבות.' ),
            array( '📋', 'בניית אסטרטגיה', 'בונים תוכנית עבודה מותאמת עם יעדים ברורים, לוחות זמנים ו-KPIs.' ),
            array( '🚀', 'ביצוע ויישום', 'מתחילים לעבוד - קמפיינים, תוכן, פלטפורמות - הכל בתיאום מלא אתכם.' ),
            array( '📊', 'מדידה ואופטימיזציה', 'עוקבים אחרי ביצועים, משפרים בזמן אמת, ומדווחים כל חודש.' ),
        );
        foreach ( $def_steps as $si => $ds ) :
      ?>
      <div class="process-step reveal <?php echo $si > 0 ? 'reveal-delay-' . min($si, 3) : ''; ?>">
        <div class="step-icon"><?php echo fresh_svg_icon( $ds[0], 28 ); ?></div>
        <div class="step-number"><?php echo str_pad( $si + 1, 2, '0', STR_PAD_LEFT ); ?></div>
        <h3><?php echo esc_html( $ds[1] ); ?></h3>
        <p><?php echo esc_html( $ds[2] ); ?></p>
      </div>
      <?php endforeach; endif; ?>
    </div>
  </div>
</section>

<!-- ========== CTA ========== -->
<section class="cta" id="contact">
  <div class="container">
    <div class="section-label reveal"><?php echo esc_html( fm( $h, 'cta_label', 'מוכנים להתחיל?' ) ); ?></div>
    <h2 class="reveal reveal-delay-1">
      <?php echo esc_html( fm( $h, 'cta_title', 'בואו נבנה ביחד' ) ); ?><br>
      <span class="gold"><?php echo esc_html( fm( $h, 'cta_title_gold', 'תוכנית צמיחה למסעדה שלכם' ) ); ?></span>
    </h2>
    <p class="section-subtitle reveal reveal-delay-2"><?php echo esc_html( fm( $h, 'cta_subtitle', 'כל מסעדה שונה. ספרו לנו על המקום שלכם ונחזור אליכם עם רעיונות - בלי התחייבות.' ) ); ?></p>
    <div class="cta-buttons reveal reveal-delay-3">
      <a href="#" class="btn-primary" data-popup="contact"><?php echo esc_html( fm( $h, 'cta_btn_text', 'דברו איתנו ←' ) ); ?></a>
      <a href="<?php echo esc_url( fm( $h, 'cta_btn2_url', freshm_whatsapp_url() ) ); ?>" class="btn-outline"><?php echo esc_html( fm( $h, 'cta_btn2_text', 'WhatsApp' ) ); ?></a>
    </div>
  </div>
</section>

<?php get_footer(); ?>
