<!DOCTYPE html>
<html <?php language_attributes(); ?> dir="rtl">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<a class="skip-link" href="#main-content">דלג לתוכן</a>

<!-- Loading Screen -->
<div class="fresh-loader" aria-hidden="true">
  <div class="fresh-loader-logo">
    <img src="<?php echo esc_url( fresh_logo_url() ); ?>" alt="<?php bloginfo( 'name' ); ?>">
  </div>
  <div class="fresh-loader-bar"></div>
</div>

<?php
// Allow Elementor to override header
if ( function_exists( 'elementor_theme_do_location' ) && elementor_theme_do_location( 'header' ) ) {
    return;
}
?>

<!-- ========== NAVIGATION ========== -->
<nav class="nav" id="nav">
  <div class="container">
    <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
      <img src="<?php echo esc_url( fresh_logo_url() ); ?>" alt="<?php bloginfo( 'name' ); ?>" class="nav-logo">
    </a>

    <?php
    if ( has_nav_menu( 'primary' ) ) {
        wp_nav_menu( array(
            'theme_location' => 'primary',
            'container'      => false,
            'menu_class'     => 'nav-links',
            'menu_id'        => 'navLinks',
            'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
            'depth'          => 2,
            'walker'         => new Fresh_Mega_Walker(),
        ) );
    } else {
        fresh_fallback_menu();
    }
    ?>

    <?php
    $nav_social_platforms = array(
        'facebook'  => fm( 'global', 'social_facebook', '' ),
        'instagram' => fm( 'global', 'social_instagram', '' ),
        'tiktok'    => fm( 'global', 'social_tiktok', '' ),
        'linkedin'  => fm( 'global', 'social_linkedin', '' ),
        'youtube'   => fm( 'global', 'social_youtube', '' ),
    );
    $has_nav_social = false;
    foreach ( $nav_social_platforms as $pkey => $purl ) {
        if ( ! empty( $purl ) && fm( 'global', 'social_' . $pkey . '_in_header', '' ) ) {
            $has_nav_social = true;
            break;
        }
    }
    if ( $has_nav_social ) : ?>
    <div class="nav-social">
      <?php foreach ( $nav_social_platforms as $pkey => $purl ) :
        if ( ! empty( $purl ) && fm( 'global', 'social_' . $pkey . '_in_header', '' ) ) : ?>
        <a href="<?php echo esc_url( $purl ); ?>" target="_blank" rel="noopener" class="nav-social-icon" aria-label="<?php echo esc_attr( $pkey ); ?>"><?php echo fresh_social_svg( $pkey ); ?></a>
      <?php endif; endforeach; ?>
    </div>
    <?php endif; ?>

    <a href="#" class="btn-primary nav-cta nav-cta-btn" data-popup="contact"><?php echo esc_html( fm( 'global', 'nav_cta_text', 'דברו איתנו' ) ); ?></a>

    <button class="mobile-toggle" id="mobileToggle" aria-label="תפריט" aria-expanded="false">
      <span></span><span></span><span></span>
    </button>
  </div>
</nav>
<div id="main-content"></div>
