<?php
/**
 * Blog listing (home.php)
 */
get_header();
$bg = 'blog_settings';
?>

<section class="page-hero">
  <div class="container">
    <?php fresh_breadcrumb(); ?>
    <h1><?php echo wp_kses_post( fm( $bg, 'hero_title', 'ה<span class="gold">בלוג</span> של FRESH' ) ); ?></h1>
    <p class="subtitle"><?php echo esc_html( fm( $bg, 'hero_subtitle', 'טיפים, תובנות ומגמות מעולם השיווק הדיגיטלי למסעדות.' ) ); ?></p>
  </div>
</section>

<section class="blog-listing">
  <div class="container">
    <?php if ( have_posts() ) : ?>

    <?php
    // Featured Post (first post)
    if ( ! is_paged() ) :
      the_post();
    ?>
    <div class="blog-featured reveal">
      <a href="<?php the_permalink(); ?>" class="featured-post">
        <div class="thumb">
          <?php if ( has_post_thumbnail() ) the_post_thumbnail( 'fresh-blog-featured' ); ?>
        </div>
        <div class="content">
          <?php $cat = get_the_category(); ?>
          <?php if ( $cat ) : ?>
            <div class="category"><?php echo esc_html( $cat[0]->name ); ?></div>
          <?php endif; ?>
          <h2><?php the_title(); ?></h2>
          <p class="excerpt"><?php echo esc_html( get_the_excerpt() ); ?></p>
          <div class="meta">
            <span><?php echo get_the_date(); ?></span>
            <span>•</span>
            <span><?php echo fresh_reading_time(); ?></span>
          </div>
        </div>
      </a>
    </div>
    <?php endif; ?>

    <!-- Blog Grid -->
    <div class="blog-grid">
      <?php while ( have_posts() ) : the_post(); ?>
      <div class="blog-card reveal">
        <a href="<?php the_permalink(); ?>">
          <div class="thumb">
            <?php if ( has_post_thumbnail() ) the_post_thumbnail( 'fresh-blog' ); ?>
          </div>
        </a>
        <div class="content">
          <?php $cat = get_the_category(); ?>
          <?php if ( $cat ) : ?>
            <div class="category"><?php echo esc_html( $cat[0]->name ); ?></div>
          <?php endif; ?>
          <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
          <p class="excerpt"><?php echo esc_html( get_the_excerpt() ); ?></p>
          <div class="meta">
            <span><?php echo get_the_date(); ?></span>
            <span><?php echo fresh_reading_time(); ?></span>
          </div>
        </div>
      </div>
      <?php endwhile; ?>
    </div>

    <!-- Pagination -->
    <div class="pagination">
      <?php
      echo paginate_links( array(
          'prev_text' => '→',
          'next_text' => '←',
      ) );
      ?>
    </div>

    <?php else : ?>
    <div style="text-align:center;padding:4rem 0;">
      <h2>אין עדיין פוסטים</h2>
      <p style="color:var(--text-secondary);margin-top:1rem;">חזרו בקרוב - תוכן חדש בדרך!</p>
    </div>
    <?php endif; ?>
  </div>
</section>

<?php get_footer(); ?>
