<?php
/**
 * Template Name: מי אנחנו
 * About page — managed via FRESH Manager
 */
get_header();
$g = 'about';
$data = freshm_get_all( $g );
?>

<!-- Hero -->
<section class="page-hero about-hero">
  <div class="container">
    <?php fresh_breadcrumb(); ?>
    <h1>
      <?php echo esc_html( fm( $g, 'story_title', 'הצוות שיודע' ) ); ?>
      <span class="gold"><?php echo esc_html( fm( $g, 'story_title_gold', 'לדבר אוכל' ) ); ?></span>
    </h1>
    <p class="subtitle"><?php echo esc_html( fm( $g, 'hero_subtitle', 'סוכנות השיווק הדיגיטלי שנבנתה מהיסוד עבור עולם המסעדנות' ) ); ?></p>
    <p class="about-story-text reveal reveal-delay-1"><?php echo wp_kses_post( nl2br( fm( $g, 'story_text', "FRESH נולדה מתוך הבנה פשוטה: מסעדות צריכות שיווק שמבין את השפה שלהן.\n\nלא סוכנות גנרית שמתייחסת למסעדה כמו לכל עסק אחר - אלא שותף אמיתי שמכיר את עולם המסעדנות מבפנים, מבין את הלחצים של ערב שישי מלא ושל יום שני ריק, ויודע לתרגם את זה לפעולות דיגיטליות שמביאות תוצאות." ) ) ); ?></p>
    <?php
    $feats = isset( $data['freshm_story_features'] ) ? $data['freshm_story_features'] : array();
    if ( ! empty( $feats ) ) :
    ?>
    <div class="about-features-row reveal reveal-delay-2">
      <?php foreach ( $feats as $feat ) : ?>
      <div class="about-feature-pill">
        <span class="about-feature-dot"></span>
        <strong><?php echo esc_html( $feat['title'] ?? '' ); ?></strong>
      </div>
      <?php endforeach; ?>
    </div>
    <?php else : ?>
    <div class="about-features-row reveal reveal-delay-2">
      <div class="about-feature-pill"><span class="about-feature-dot"></span><strong>מומחיות ייעודית</strong></div>
      <div class="about-feature-pill"><span class="about-feature-dot"></span><strong>תוצאות מדידות</strong></div>
      <div class="about-feature-pill"><span class="about-feature-dot"></span><strong>שותפות אמיתית</strong></div>
    </div>
    <?php endif; ?>
    <?php $story_img = fm( $g, 'story_image', '' ); ?>
    <?php if ( $story_img ) : ?>
    <div class="about-hero-image reveal reveal-delay-3">
      <img src="<?php echo esc_url( $story_img ); ?>" alt="FRESH Story">
    </div>
    <?php endif; ?>
  </div>
</section>

<!-- Values -->
<section class="values-section">
  <div class="container">
    <div class="section-label reveal"><?php echo esc_html( fm( $g, 'values_label', 'הערכים שלנו' ) ); ?></div>
    <h2 class="section-title reveal reveal-delay-1">
      <?php echo esc_html( fm( $g, 'values_title', 'למה' ) ); ?>
      <span class="gold"><?php echo esc_html( fm( $g, 'values_title_gold', 'FRESH' ) ); ?></span>
    </h2>
    <div class="values-grid">
      <?php
      $values = isset( $data['freshm_values'] ) ? $data['freshm_values'] : array();
      if ( ! empty( $values ) ) :
        foreach ( $values as $vi => $val ) :
      ?>
      <div class="value-card reveal <?php echo $vi > 0 ? 'reveal-delay-' . min($vi, 3) : ''; ?>">
        <div class="value-icon"><?php echo fresh_svg_icon( $val['icon'] ?? '🎯', 32 ); ?></div>
        <h3><?php echo esc_html( $val['title'] ?? '' ); ?></h3>
        <p><?php echo esc_html( $val['desc'] ?? '' ); ?></p>
      </div>
      <?php endforeach; else :
        $def_values = array(
            array( '🎯', 'מיקוד', 'אנחנו מתמקדים ב-100% בתעשיית המסעדות. הידע המצטבר שלנו בתחום הוא היתרון שלכם.' ),
            array( '📊', 'שקיפות', 'דוחות ברורים, מספרים אמיתיים, בלי מסכים. אתם תמיד יודעים מה קורה.' ),
            array( '🚀', 'חדשנות', 'תמיד בחזית הטכנולוגיה והטרנדים. מ-AI ועד ה-TikTok הבא.' ),
            array( '⚡', 'איכות', 'כל פרט עובר בקרה. מהתמונה שעולה לפיד ועד הנתון שנכנס לדוח.' ),
            array( '🤝', 'מהירות', 'תגובה מהירה, ביצוע חד, בלי סחבת. כי במסעדנות - כל יום קובע.' ),
            array( '💎', 'יצירתיות', 'רעיונות שלא מפסיקים. קמפיינים, תכנים, זוויות - תמיד חדש, תמיד רלוונטי.' ),
        );
        foreach ( $def_values as $vi => $dv ) :
      ?>
      <div class="value-card reveal <?php echo $vi > 0 ? 'reveal-delay-' . min($vi, 3) : ''; ?>">
        <div class="value-icon"><?php echo fresh_svg_icon( $dv[0], 32 ); ?></div>
        <h3><?php echo esc_html( $dv[1] ); ?></h3>
        <p><?php echo esc_html( $dv[2] ); ?></p>
      </div>
      <?php endforeach; endif; ?>
    </div>
  </div>
</section>

<!-- Team -->
<section class="team-section">
  <div class="container">
    <div class="section-label reveal"><?php echo esc_html( fm( $g, 'team_label', 'הצוות שלנו' ) ); ?></div>
    <h2 class="section-title reveal reveal-delay-1">
      <?php echo esc_html( fm( $g, 'team_title', 'האנשים' ) ); ?>
      <span class="gold"><?php echo esc_html( fm( $g, 'team_title_gold', 'מאחורי הקסם' ) ); ?></span>
    </h2>
    <p class="section-subtitle reveal reveal-delay-2">לחצו על כל אחד מאיתנו כדי להכיר אותנו קצת יותר מקרוב.</p>
    <div class="team-grid">
      <?php
      $team_bios = array();

      // Tier 1: Plugin data
      $plugin_team = function_exists( 'freshm_get_team_members' ) ? freshm_get_team_members() : array();

      if ( ! empty( $plugin_team ) ) :
        foreach ( $plugin_team as $ti => $m ) :
          if ( ( $m['status'] ?? 'publish' ) === 'draft' ) continue;
          $team_bios[] = array(
              'name'  => $m['name'],
              'role'  => $m['role'] ?? '',
              'bio'   => $m['bio'] ?? '',
              'dish'  => $m['favorite_dish'] ?? '',
              'image' => $m['photo'] ?? '',
          );
          $card_idx = count( $team_bios ) - 1;
      ?>
      <div class="team-card reveal" data-member-id="<?php echo $card_idx; ?>" style="cursor:pointer;">
        <div class="team-avatar">
          <?php if ( ! empty( $m['photo'] ) ) : ?>
          <img src="<?php echo esc_url( $m['photo'] ); ?>" alt="<?php echo esc_attr( $m['name'] ); ?>">
          <?php else : ?>
          <div class="avatar-placeholder"><?php echo mb_substr( $m['name'], 0, 1 ); ?></div>
          <?php endif; ?>
        </div>
        <h3><?php echo esc_html( $m['name'] ); ?></h3>
        <?php if ( $m['role'] ) : ?><p class="team-role"><?php echo esc_html( $m['role'] ); ?></p><?php endif; ?>
      </div>
      <?php endforeach;

      // Tier 2: CPT query
      else :
        $team_query = new WP_Query( array( 'post_type' => 'fresh_team', 'posts_per_page' => -1, 'orderby' => 'menu_order', 'order' => 'ASC' ) );
        if ( $team_query->have_posts() ) :
          while ( $team_query->have_posts() ) : $team_query->the_post();
            $role = get_post_meta( get_the_ID(), 'team_role', true );
            $bio  = get_post_meta( get_the_ID(), 'team_bio', true );
            $dish = get_post_meta( get_the_ID(), 'team_favorite_dish', true );
            $thumb = get_the_post_thumbnail_url( get_the_ID(), 'fresh-team' );
            $team_bios[] = array(
                'name'  => get_the_title(),
                'role'  => $role,
                'bio'   => $bio ?: '',
                'dish'  => $dish ?: '',
                'image' => $thumb ?: '',
            );
            $card_idx = count( $team_bios ) - 1;
        ?>
        <div class="team-card reveal" data-member-id="<?php echo $card_idx; ?>" style="cursor:pointer;">
          <div class="team-avatar">
            <?php if ( has_post_thumbnail() ) : the_post_thumbnail( 'fresh-team' ); else : ?>
            <div class="avatar-placeholder"><?php echo mb_substr( get_the_title(), 0, 1 ); ?></div>
            <?php endif; ?>
          </div>
          <h3><?php the_title(); ?></h3>
          <?php if ( $role ) : ?><p class="team-role"><?php echo esc_html( $role ); ?></p><?php endif; ?>
        </div>
        <?php endwhile; wp_reset_postdata();

        // Tier 3: Hardcoded fallback
        else :
          $def_team = array(
              array( 'בר גרשונוביץ', 'מנכ"ל, אסטרטגיה וקמפיינים', "בר הקים את FRESH מתוך אובססיה אחת: להוכיח שמסעדות יכולות לצמוח דיגיטלית בלי לוותר על האותנטיות שלהן. עם ניסיון של למעלה מעשור בשיווק דיגיטלי, הוא מוביל את האסטרטגיה של כל לקוח ועדיין לא מוכן לשחרר את הקמפיינים - כי שם נמצאים הפרטים הקטנים שעושים את ההבדל בין קמפיין בסדר לקמפיין שממלא מסעדה. בר מאמין שעסק טוב נבנה על מספרים ברורים, יחסי אמון ועוד כוס קפה אחת עם הלקוח. מגיע ראשון למשרד, יוצא אחרון, ותמיד עם רשימת רעיונות חדשים.", 'אנטריקוט על הגריל עם חמאת עשבי תיבול ופירה חלק' ),
              array( 'אמיר זרצקי', 'סמנכ"ל ומנהל מכירות', "אמיר הוא האיש שמסעדנים מתקשרים אליו כשהם רוצים להבין מה באמת אפשר לעשות עם הדיגיטל. עם רקע עשיר במכירות ובפיתוח עסקי, אמיר מוביל את תהליך הליווי של לקוחות חדשים - מהשיחה הראשונה ועד שהתוצאות מתחילות לרוץ. הוא יודע להקשיב, לשאול את השאלות הנכונות, ולבנות תוכנית שמתאימה בדיוק לגודל ולשלב של המסעדה. אמיר הוא מהאנשים שאחרי שיחה של 15 דקות אתם מרגישים שהוא מכיר את המסעדה שלכם טוב כמעט כמוכם. זה לא קסם - זה ניסיון.", 'שוק טלה צלוי לאט עם ירקות שורש ורוטב דמי-גלאס' ),
              array( 'אמילי אוטקו', 'סמנכ"לית תוכן', "אמילי אחראית על כל מילה, כל משפט וכל סיפור שיוצא מ-FRESH. היא מובילה את אסטרטגיית התוכן עבור כל הלקוחות - מזווית הצילום ועד הכיתוב של הפוסט, מהסטורי הבוקר ועד הקמפיין העונתי. אמילי מאמינה שתוכן טוב למסעדה לא מתחיל במילים - הוא מתחיל בהבנה של מה גורם לאנשים לבחור מסעדה. היא יודעת לקחת מנה פשוטה ולהפוך אותה לסיפור שאנשים רוצים לשתף. וזה בדיוק מה שמבדיל פוסט שעובר ברקע לפוסט שגורם למישהו להזמין שולחן.", 'פסטה קליו א פפה עם פרמזן מגורר ופלפל שחור טרי' ),
              array( 'טליה אלבז', 'מנהלת סושיאל ושיתופי פעולה עם יוצרי תוכן', "טליה היא מי שגורמת למסעדות להופיע בפיד של האנשים הנכונים - ולא רק כמודעה, אלא כתוכן שאנשים באמת רוצים לראות. היא מנהלת את שיתופי הפעולה עם בלוגרים, יוצרי תוכן וכוכבי רשתות חברתיות, ומובילה את הנוכחות הסושיאלית של לקוחות FRESH. טליה יודעת לבחור את היוצר המתאים, לבנות בריף שמייצר תוכן אותנטי, ולוודא שהתוצאה מביאה תוצאות - לא רק לייקים.", 'סלמון טאטאקי עם אבוקדו, אדממה וטריאקי' ),
              array( 'עדן', 'מנהלת סושיאל', "עדן חיה ונושמת רשתות חברתיות. היא זו שמנהלת את הפידים, הסטוריז והקהילות של מסעדות FRESH ביום-יום. מתזמון פוסטים ועד ניהול תגובות, מסטורי שאלות ועד רילס שמזמינים אינטראקציה - עדן מוודאת שהנוכחות הדיגיטלית של כל מסעדה חיה, פעילה, ועקבית. כי בסושיאל, עקביות היא הסוד.", 'שקשוקה עם פלפלים קלויים, פטה מפוררת ולחם טאבון חם' ),
              array( 'שניר הכוכב', 'צלם וידאו וסטילס', "שניר הוא מי שהופך צלחת אוכל לתמונה שגורמת לאנשים לבלוע רוק. ממש. עם עין חדה לפרטים ויכולת להוציא את הצד הכי מפתה של כל מנה, שניר מוביל את מחלקת הצילום של FRESH - סטילס, וידאו ורילסים שנראים כאילו יצאו מפיד של מסעדת מישלן. הוא מבין שצילום אוכל זה לא רק תאורה וזווית - זה להעביר ריח וטעם דרך מסך.", 'המבורגר כבד אווז עם ג\'אם בצל, צ\'דר מעושן וצ\'יפס בטטה' ),
              array( 'סתיו מלמד', 'מנהלת מערכות משלוחים והזמנות שולחן', "סתיו שולטת בכל מה שקורה מאחורי הקלעים של הפלטפורמות - Wolt, 10bis, Cibus, Tabit, Eatbit ועוד. היא יודעת איך לשפר דירוג, להוריד עמלות, לעדכן תפריטים ולמקסם הזמנות - בלי שהמסעדן צריך לפתוח את האפליקציה. סתיו מנהלת את הפלטפורמות בצורה שכל הזמנה שנכנסת שווה יותר ושכל ביטול נמנע מראש.", 'פיצה מרגריטה עם בצק דק, מוצרלה דה בופלה ובזיליקום טרי' ),
              array( 'נועם כרמי', 'שיפור מוניטין וביקורות', "נועם יודע שביקורת אחת שלילית ב-Google יכולה לעלות למסעדה עשרות לקוחות. ולכן הוא לא משאיר את זה ליד המקרה. הוא בונה אסטרטגיות לאיסוף ביקורות חיוביות, מגיב בצורה מקצועית לכל ביקורת - חיובית ושלילית - ומוודא שהתמונה הכללית של המסעדה ב-Google, ב-TripAdvisor וברשתות החברתיות משקפת את מה שהמסעדה באמת מציעה.", 'ראמן טונקוטסו עם צ\'אשו, ביצה רכה ונורי' ),
              array( 'בר איגל', 'עורכת וידאו ראשית', "בר לוקחת גלם ממסעדה והופכת אותו לתוכן שגורם לאנשים לעצור לגלול. כעורכת הוידאו הראשית של FRESH, היא אחראית על כל רילס, סרטון וקמפיין ויזואלי שיוצא מהמערכת. היא יודעת בדיוק מתי לחתוך, מתי להאט, ואיזה שניה של סירטוט גבינה או שבירת קרום היא זו שתעשה את ההבדל.", 'פונדו שוקולד עם תותים, מרשמלו ובראוניז חמים' ),
              array( 'הילה ארנון', 'מנהלת מחלקת מיתוג ועיצוב', "הילה מובילה את כל מה שקשור לזהות החזותית של מסעדות FRESH - מלוגו ושפה עיצובית ועד תפריט מודפס ואריזות משלוחים. היא מאמינה שמיתוג מסעדה טוב מתחיל בהבנה של מה המסעדה באמת רוצה להגיד - ורק אז עוברים לצבעים, פונטים ועיצוב. הילה יודעת שתפריט מעוצב נכון לא רק נראה טוב - הוא מוכר יותר. היא גם ממש אובססיבית לפרטים. הפיקסל הזה זז שמאלה? היא כבר ראתה.", 'סושי אומקסה עם סלמון להבה, אבוקדו ומיונז כמהין' ),
              array( 'עמית חן', 'ניתוח, דוחות ופיתוח AI', "עמית הוא מי שהופך מספרים לתובנות שמזיזות את העסק קדימה. הוא בונה דשבורדים, מנתח ביצועים ומפתח כלי AI פנימיים שעוזרים ל-FRESH לעבוד חכם יותר. כשקמפיין רץ - עמית יודע להגיד תוך דקות אם הוא עובד, מה צריך לשנות, ואיפה כל שקל הלך. עמית מאמין שאינטואיציה זה נחמד, אבל דאטה זה מה שמנצח. ולכן כל החלטה ב-FRESH נתמכת במספרים אמיתיים - לא בתחושות בטן.", 'חומוס חם עם פול, טחינה גולמית וביצה עלומה' ),
          );
          foreach ( $def_team as $dti => $dt ) :
            $team_bios[] = array(
                'name'  => $dt[0],
                'role'  => $dt[1],
                'bio'   => $dt[2],
                'dish'  => $dt[3],
                'image' => '',
            );
        ?>
        <div class="team-card reveal" data-member-id="<?php echo $dti; ?>" style="cursor:pointer;">
          <div class="team-avatar"><div class="avatar-placeholder"><?php echo mb_substr( $dt[0], 0, 1 ); ?></div></div>
          <h3><?php echo esc_html( $dt[0] ); ?></h3>
          <p class="team-role"><?php echo esc_html( $dt[1] ); ?></p>
        </div>
        <?php endforeach; endif; wp_reset_postdata(); endif; ?>
    </div>
  </div>
</section>

<!-- Map -->
<?php $about_map = fm( 'contact', 'map_embed', '' ); ?>
<?php if ( $about_map ) : ?>
<section class="about-map-section">
  <div class="container">
    <div class="section-label reveal">מיקום</div>
    <h2 class="section-title reveal reveal-delay-1">איפה <span class="gold">אנחנו</span></h2>
    <div class="about-map reveal reveal-delay-2">
      <?php echo wp_kses( $about_map, array( 'iframe' => array( 'src' => true, 'width' => true, 'height' => true, 'style' => true, 'frameborder' => true, 'allowfullscreen' => true, 'loading' => true, 'referrerpolicy' => true, 'allow' => true, 'class' => true ) ) ); ?>
    </div>
  </div>
</section>
<?php endif; ?>

<!-- CTA -->
<section class="cta">
  <div class="container">
    <div class="section-label reveal"><?php echo esc_html( fm( $g, 'cta_label', 'מתעניינים?' ) ); ?></div>
    <h2 class="reveal reveal-delay-1"><?php echo esc_html( fm( $g, 'cta_title', 'בואו נכיר' ) ); ?><br><span class="gold"><?php echo esc_html( fm( $g, 'cta_title_gold', 'פנים אל פנים' ) ); ?></span></h2>
    <p class="section-subtitle reveal reveal-delay-2"><?php echo esc_html( fm( $g, 'cta_subtitle', 'כל מסעדה שונה. ספרו לנו על המקום שלכם ונחזור אליכם עם רעיונות - בלי התחייבות.' ) ); ?></p>
    <div class="cta-buttons reveal reveal-delay-3">
      <a href="#" class="btn-primary" data-popup="contact"><?php echo esc_html( fm( $g, 'cta_btn_text', 'קבעו שיחה ←' ) ); ?></a>
      <a href="<?php echo esc_url( freshm_whatsapp_url() ); ?>" class="btn-outline"><?php echo esc_html( fm( $g, 'cta_btn2_text', 'WhatsApp' ) ); ?></a>
    </div>
  </div>
</section>

<!-- Team Member Modal -->
<div class="team-modal-overlay" id="teamModal">
  <div class="team-modal-backdrop"></div>
  <div class="team-modal">
    <button class="team-modal-close" aria-label="סגור">&times;</button>
    <div class="team-modal-avatar" id="tmAvatar"></div>
    <h3 class="team-modal-name" id="tmName"></h3>
    <p class="team-modal-role" id="tmRole"></p>
    <div class="team-modal-divider"></div>
    <div class="team-modal-bio" id="tmBio"></div>
    <div class="team-modal-dish" id="tmDish"></div>
  </div>
</div>

<script>
(function(){
  var bios = <?php echo wp_json_encode( $team_bios, JSON_UNESCAPED_UNICODE ); ?>;
  var modal = document.getElementById('teamModal');
  if (!modal || !bios.length) return;

  document.querySelectorAll('.team-card[data-member-id]').forEach(function(card){
    card.addEventListener('click', function(){
      var id = parseInt(this.getAttribute('data-member-id'));
      var m = bios[id];
      if (!m) return;
      document.getElementById('tmName').textContent = m.name;
      document.getElementById('tmRole').textContent = m.role;
      var bioHtml = (m.bio || '').split('\n\n').filter(function(p){ return p.trim(); }).map(function(p){ return '<p>' + p.replace(/\n/g, '<br>') + '</p>'; }).join('');
      document.getElementById('tmBio').innerHTML = bioHtml;
      var dishEl = document.getElementById('tmDish');
      if (m.dish) {
        dishEl.innerHTML = '<strong>המנה האהובה:</strong> ' + m.dish;
        dishEl.style.display = '';
      } else {
        dishEl.style.display = 'none';
      }
      var avatarEl = document.getElementById('tmAvatar');
      if (m.image) {
        avatarEl.innerHTML = '<img src="' + m.image + '" alt="">';
      } else {
        avatarEl.innerHTML = '<div class="avatar-placeholder" style="width:80px;height:80px;font-size:2rem;">' + m.name.charAt(0) + '</div>';
      }
      modal.classList.add('open');
      document.body.style.overflow = 'hidden';
    });
  });

  modal.querySelector('.team-modal-backdrop').addEventListener('click', closeModal);
  modal.querySelector('.team-modal-close').addEventListener('click', closeModal);
  document.addEventListener('keydown', function(e){ if (e.key === 'Escape') closeModal(); });

  function closeModal(){
    modal.classList.remove('open');
    document.body.style.overflow = '';
  }
})();
</script>

<?php get_footer(); ?>
