<?php
/**
 * Template Name: צור קשר
 * Contact page — managed via FRESH Manager
 */
get_header();
$g = 'contact';
$data = freshm_get_all( $g );
$phone   = fm( 'global', 'phone', '050-123-4567' );
$email   = fm( 'global', 'email', 'hello@fresh.agency' );
$address = fm( 'global', 'address', 'רוטשילד 45, תל אביב' );
$hours   = fm( 'global', 'hours', 'א׳-ה׳ 09:00-18:00' );
?>

<!-- Hero -->
<section class="page-hero">
  <div class="container">
    <?php fresh_breadcrumb(); ?>
    <h1>
      <?php echo esc_html( fm( $g, 'hero_title', 'בואו' ) ); ?>
      <span class="gold"><?php echo esc_html( fm( $g, 'hero_title_gold', 'נדבר' ) ); ?></span>
    </h1>
    <p class="subtitle"><?php echo esc_html( fm( $g, 'hero_subtitle', 'מוכנים להתחיל? השאירו פרטים ונחזור אליכם תוך 24 שעות.' ) ); ?></p>
  </div>
</section>

<!-- Contact Section — 2 Column Layout -->
<section class="contact-section">
  <div class="container">
    <div class="contact-grid">

      <!-- RIGHT: Form (primary) -->
      <div class="contact-form-wrap reveal">
        <p class="contact-form-intro"><?php echo esc_html( fm( $g, 'form_intro', 'כל מסעדה מצליחה מתחילה משיחה אחת. ספרו לנו קצת על המקום שלכם ומה הייתם רוצים לשפר - ואנחנו נחזור אליכם עם רעיונות ותוכנית ראשונית, בלי התחייבות ובלי שטויות. פשוט שיחה טובה בין אנשים שמבינים מסעדות.' ) ); ?></p>
        <form class="contact-form" id="freshContactForm" method="post" action="">
          <div class="form-row">
            <div class="float-field">
              <input type="text" name="name" id="cf-name" required placeholder=" ">
              <label for="cf-name">שם מלא *</label>
            </div>
            <div class="float-field">
              <input type="text" name="restaurant" id="cf-restaurant" placeholder=" ">
              <label for="cf-restaurant">שם המסעדה</label>
            </div>
          </div>
          <div class="form-row">
            <div class="float-field">
              <input type="tel" name="phone" id="cf-phone" required placeholder=" ">
              <label for="cf-phone">טלפון *</label>
            </div>
            <div class="float-field">
              <input type="email" name="email" id="cf-email" placeholder=" ">
              <label for="cf-email">אימייל</label>
            </div>
          </div>
          <div class="float-field">
            <textarea name="message" id="cf-message" rows="4" placeholder=" "></textarea>
            <label for="cf-message">ספרו לנו על המסעדה ועל מה שאתם מחפשים...</label>
          </div>
          <button type="submit" class="btn-primary" style="width:100%;justify-content:center;">
            <?php echo esc_html( fm( $g, 'form_btn_text', 'רוצה לשמוע עוד ←' ) ); ?>
          </button>
          <div id="formStatus" style="margin-top:1rem;text-align:center;font-size:0.9rem;"></div>
        </form>
      </div>

      <!-- LEFT: Info + Map -->
      <div class="contact-sidebar reveal reveal-delay-1">
        <div class="contact-info-list">
          <?php
          $info_cards = isset( $data['freshm_info_cards'] ) ? $data['freshm_info_cards'] : array();
          if ( ! empty( $info_cards ) ) :
            foreach ( $info_cards as $card ) :
          ?>
          <div class="info-card">
            <div class="info-icon"><?php echo fresh_svg_icon( $card['icon'] ?? '📞', 24 ); ?></div>
            <div class="info-content">
              <h3><?php echo esc_html( $card['title'] ?? '' ); ?></h3>
              <?php if ( ! empty( $card['link'] ) ) : ?>
                <a href="<?php echo esc_url( $card['link'] ); ?>"><?php echo esc_html( $card['value'] ?? '' ); ?></a>
              <?php else : ?>
                <p><?php echo esc_html( $card['value'] ?? '' ); ?></p>
              <?php endif; ?>
            </div>
          </div>
          <?php endforeach; else : ?>
          <div class="info-card">
            <div class="info-icon"><?php echo fresh_svg_icon( '📞', 24 ); ?></div>
            <div class="info-content">
              <h3>טלפון</h3>
              <a href="tel:+<?php echo preg_replace('/[^0-9]/', '', $phone); ?>"><?php echo esc_html( $phone ); ?></a>
            </div>
          </div>
          <div class="info-card">
            <div class="info-icon"><?php echo fresh_svg_icon( '✉️', 24 ); ?></div>
            <div class="info-content">
              <h3>אימייל</h3>
              <a href="mailto:<?php echo esc_attr( $email ); ?>"><?php echo esc_html( $email ); ?></a>
            </div>
          </div>
          <div class="info-card">
            <div class="info-icon"><?php echo fresh_svg_icon( '📍', 24 ); ?></div>
            <div class="info-content">
              <h3>כתובת</h3>
              <p><?php echo esc_html( $address ); ?></p>
            </div>
          </div>
          <div class="info-card">
            <div class="info-icon"><?php echo fresh_svg_icon( '🕐', 24 ); ?></div>
            <div class="info-content">
              <h3>שעות פעילות</h3>
              <p><?php echo esc_html( $hours ); ?></p>
            </div>
          </div>
          <?php endif; ?>
        </div>

        <!-- WhatsApp Button -->
        <a href="<?php echo esc_url( freshm_whatsapp_url() ); ?>" class="contact-whatsapp-btn" target="_blank" rel="noopener">
          <?php echo fresh_social_svg( 'whatsapp' ); ?>
          <span>שלחו הודעה ב-WhatsApp</span>
        </a>

        <!-- Map -->
        <?php $map_embed = fm( $g, 'map_embed', '' ); ?>
        <?php if ( $map_embed ) : ?>
        <div class="contact-sidebar-map">
          <?php echo wp_kses( $map_embed, array( 'iframe' => array( 'src' => true, 'width' => true, 'height' => true, 'style' => true, 'frameborder' => true, 'allowfullscreen' => true, 'loading' => true, 'referrerpolicy' => true, 'allow' => true ) ) ); ?>
        </div>
        <?php else : ?>
        <div class="contact-sidebar-map">
          <div class="map-placeholder">
            <div class="map-icon"><?php echo fresh_svg_icon( '📍', 40 ); ?></div>
            <p><?php echo esc_html( $address ); ?></p>
          </div>
        </div>
        <?php endif; ?>
      </div>

    </div>
  </div>
</section>

<?php get_footer(); ?>
