<?php
/**
 * Template Name: שאלות נפוצות
 * FAQ page with accordion and schema markup
 * Reads FAQ items from freshm_faq option (FRESH Manager plugin)
 */
get_header();

// Read FAQ from wp_options (admin-editable via FRESH Manager > שאלות ותשובות)
$faq_items = get_option( 'freshm_faq', array() );
if ( ! is_array( $faq_items ) || empty( $faq_items ) ) {
    // Fallback if DB is empty
    $faq_items = array(
        array( 'q' => 'כמה עולה לעבוד עם FRESH?', 'a' => 'אין מחירון קבוע - כי כל מסעדה שונה. השיחה הראשונה בחינם ובלי התחייבות.' ),
    );
}

// Strip tags for schema (plain text)
$faq_plain = array();
foreach ( $faq_items as $item ) {
    $faq_plain[] = array( 'q' => $item['q'], 'a' => wp_strip_all_tags( $item['a'] ) );
}
?>

<!-- Hero -->
<section class="page-hero">
  <div class="container">
    <?php fresh_breadcrumb(); ?>
    <h1>
      שאלות
      <span class="gold">ותשובות</span>
    </h1>
    <p class="subtitle">ריכזנו את השאלות שמסעדנים שואלים אותנו הכי הרבה. לא מצאתם תשובה? דברו איתנו.</p>
  </div>
</section>

<!-- FAQ Accordion -->
<section class="faq-section">
  <div class="container">
    <div class="faq-list">
      <?php foreach ( $faq_items as $i => $item ) : ?>
      <div class="faq-item reveal">
        <button class="faq-question" aria-expanded="false" onclick="this.parentElement.classList.toggle('open');this.setAttribute('aria-expanded',this.parentElement.classList.contains('open'))">
          <span><?php echo esc_html( $item['q'] ); ?></span>
          <span class="faq-toggle">+</span>
        </button>
        <div class="faq-answer">
          <p><?php echo wp_kses( $item['a'], array( 'a' => array( 'href' => array(), 'target' => array(), 'rel' => array() ) ) ); ?></p>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<!-- CTA -->
<section class="cta">
  <div class="container">
    <div class="section-label reveal">לא מצאתם תשובה?</div>
    <h2 class="reveal reveal-delay-1">דברו איתנו<br><span class="gold">ונענה על הכל</span></h2>
    <p class="section-subtitle reveal reveal-delay-2">נשמח לענות על כל שאלה נוספת - בטלפון, ב-WhatsApp, או בפגישה אישית.</p>
    <div class="cta-buttons reveal reveal-delay-3">
      <a href="#" class="btn-primary" data-popup="contact">קבעו שיחה ←</a>
      <a href="<?php echo esc_url( freshm_whatsapp_url() ); ?>" class="btn-outline">WhatsApp</a>
    </div>
  </div>
</section>

<!-- FAQ JSON-LD Schema -->
<script type="application/ld+json">
<?php
$faq_schema = array(
    '@context'   => 'https://schema.org',
    '@type'      => 'FAQPage',
    'mainEntity' => array(),
);
foreach ( $faq_plain as $item ) {
    $faq_schema['mainEntity'][] = array(
        '@type' => 'Question',
        'name'  => $item['q'],
        'acceptedAnswer' => array(
            '@type' => 'Answer',
            'text'  => $item['a'],
        ),
    );
}
echo wp_json_encode( $faq_schema, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT );
?>
</script>

<!-- BreadcrumbList Schema -->
<script type="application/ld+json">
<?php
echo wp_json_encode( array(
    '@context' => 'https://schema.org',
    '@type'    => 'BreadcrumbList',
    'itemListElement' => array(
        array( '@type' => 'ListItem', 'position' => 1, 'name' => 'ראשי', 'item' => home_url( '/' ) ),
        array( '@type' => 'ListItem', 'position' => 2, 'name' => 'שאלות ותשובות' ),
    ),
), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT );
?>
</script>

<?php get_footer(); ?>
