<?php
/**
 * Template Name: שירותים
 * Services page — managed via FRESH Manager
 */
get_header();
$g = 'services_settings';
?>

<!-- Hero -->
<section class="page-hero">
  <div class="container">
    <?php fresh_breadcrumb(); ?>
    <h1>
      <?php echo esc_html( fm( $g, 'hero_title', '15 פתרונות' ) ); ?>
      <span class="gold"><?php echo esc_html( fm( $g, 'hero_title_gold', 'לצמיחת המסעדה שלך' ) ); ?></span>
    </h1>
    <p class="subtitle"><?php echo esc_html( fm( $g, 'hero_subtitle', 'כל מה שמסעדה צריכה כדי להתבלט, למשוך לקוחות חדשים, ולגדול - במקום אחד.' ) ); ?></p>
  </div>
</section>

<!-- Services by Category -->
<section class="services-listing">
  <div class="container">
    <?php
    // --- Category tabs: plugin first, WP taxonomy fallback ---
    $plugin_cats = freshm_get_service_cats();
    if ( ! empty( $plugin_cats ) ) :
        usort( $plugin_cats, function( $a, $b ) { return ( $a['order'] ?? 0 ) - ( $b['order'] ?? 0 ); } );
    ?>
    <div class="services-tabs reveal" style="margin-bottom:3rem;">
      <button class="tab-btn active" data-category="all">הכל</button>
      <?php foreach ( $plugin_cats as $pc ) : ?>
      <button class="tab-btn" data-category="<?php echo esc_attr( $pc['slug'] ); ?>"><?php echo esc_html( $pc['name'] ); ?></button>
      <?php endforeach; ?>
    </div>
    <?php else :
        $wp_cats = get_terms( array( 'taxonomy' => 'service_category', 'hide_empty' => true, 'orderby' => 'term_id' ) );
        if ( ! is_wp_error( $wp_cats ) && ! empty( $wp_cats ) ) :
    ?>
    <div class="services-tabs reveal" style="margin-bottom:3rem;">
      <button class="tab-btn active" data-category="all">הכל</button>
      <?php foreach ( $wp_cats as $cat ) : ?>
      <button class="tab-btn" data-category="<?php echo esc_attr( $cat->slug ); ?>"><?php echo esc_html( $cat->name ); ?></button>
      <?php endforeach; ?>
    </div>
    <?php endif; endif; ?>

    <div class="services-grid">
      <?php
      // --- Service cards: plugin first → CPT fallback → hardcoded ---
      $plugin_svcs = freshm_get_services();
      if ( ! empty( $plugin_svcs ) ) :
        usort( $plugin_svcs, function( $a, $b ) { return ( $a['order'] ?? 0 ) - ( $b['order'] ?? 0 ); } );
        foreach ( $plugin_svcs as $sv ) :
      ?>
      <a href="<?php echo esc_url( home_url( '/service/' . $sv['slug'] . '/' ) ); ?>" class="service-card reveal" data-category="<?php echo esc_attr( $sv['category'] ?? '' ); ?>">
        <div class="service-icon"><?php echo function_exists('freshm_render_service_icon') ? freshm_render_service_icon( $sv, 'small' ) : fresh_svg_icon( $sv['icon'] ?? '◆', 28 ); ?></div>
        <h3><?php echo esc_html( $sv['name'] ); ?></h3>
        <p><?php echo esc_html( wp_trim_words( $sv['excerpt'] ?? '', 15 ) ); ?></p>
        <span class="arrow">←</span>
      </a>
      <?php endforeach;
      else :
        $sq = new WP_Query( array(
            'post_type'      => 'fresh_service',
            'posts_per_page' => -1,
            'orderby'        => 'menu_order',
            'order'          => 'ASC',
        ) );
        if ( $sq->have_posts() ) :
          while ( $sq->have_posts() ) : $sq->the_post();
            $icon    = get_post_meta( get_the_ID(), 'service_icon', true ) ?: '◆';
            $cats    = get_the_terms( get_the_ID(), 'service_category' );
            $cat_slug = ( $cats && ! is_wp_error( $cats ) ) ? $cats[0]->slug : '';
        ?>
        <a href="<?php the_permalink(); ?>" class="service-card reveal" data-category="<?php echo esc_attr( $cat_slug ); ?>">
          <div class="service-icon"><?php echo function_exists('freshm_render_service_icon') ? freshm_render_service_icon( $icon, 'small' ) : fresh_svg_icon( $icon, 28 ); ?></div>
          <h3><?php the_title(); ?></h3>
          <p><?php echo esc_html( wp_trim_words( get_the_excerpt(), 15 ) ); ?></p>
          <span class="arrow">←</span>
        </a>
        <?php endwhile; wp_reset_postdata();
        else :
          $fallback = array(
              array( 'paid-campaigns', 'קמפיינים ממומנים', 'ניהול קמפיינים ב-Facebook, Instagram, Google ו-TikTok' ),
              array( 'influencer-marketing', 'שיווק באמצעות משפיענים', 'חיבור המסעדה למשפיעני אוכל ולייפסטייל' ),
              array( 'social-management', 'ניהול רשתות חברתיות', 'אסטרטגיית תוכן, עיצוב ופרסום' ),
              array( 'photo-video', 'צילום מנות ווידאו', 'צילומי סטילס, ריילס וסרטי תדמית' ),
              array( 'branding', 'מיתוג מסעדות', 'זהות מותגית שנחרטת בזיכרון' ),
              array( 'menu-design', 'עיצוב תפריט דיגיטלי', 'תפריט QR, דפוס והתאמה למשלוחים' ),
              array( 'website', 'בניית אתר למסעדה', 'אתר מותאם עם הזמנות, תפריט ו-SEO' ),
              array( 'delivery-optimization', 'אופטימיזציית משלוחים', 'Wolt, 10bis, Cibus - תפריט, תמחור וצילום' ),
              array( 'reservation-optimization', 'אופטימיזציית הזמנות שולחן', 'Tabit, Eatbit, Google Reserve' ),
              array( 'seo', 'קידום אורגני - SEO', 'דירוג בגוגל מפות וחיפוש אורגני' ),
              array( 'reputation', 'ניהול מוניטין וביקורות', 'ביקורות בגוגל, TripAdvisor ורשתות' ),
              array( 'loyalty', 'ניהול מועדון לקוחות', 'מועדון דיגיטלי - נקודות, SMS ואוטומציות' ),
          );
          foreach ( $fallback as $fs ) :
        ?>
        <div class="service-card reveal">
          <div class="service-icon"><?php echo function_exists('freshm_render_service_icon') ? freshm_render_service_icon( $fs[0], 'small' ) : fresh_svg_icon( $fs[0], 28 ); ?></div>
          <h3><?php echo esc_html( $fs[1] ); ?></h3>
          <p><?php echo esc_html( $fs[2] ); ?></p>
        </div>
        <?php endforeach; endif; endif; ?>
    </div>
  </div>
</section>

<!-- CTA -->
<section class="cta">
  <div class="container">
    <div class="section-label reveal"><?php echo esc_html( fm( $g, 'cta_label', 'לא בטוחים מה מתאים לכם?' ) ); ?></div>
    <h2 class="reveal reveal-delay-1"><?php echo esc_html( fm( $g, 'cta_title', 'בואו נבנה' ) ); ?><br><span class="gold"><?php echo esc_html( fm( $g, 'cta_title_gold', 'חבילה מותאמת אישית' ) ); ?></span></h2>
    <p class="section-subtitle reveal reveal-delay-2"><?php echo esc_html( fm( $g, 'cta_subtitle', 'כל מסעדה שונה. ספרו לנו על העסק שלכם ונתאים חבילה שמתאימה בדיוק.' ) ); ?></p>
    <div class="cta-buttons reveal reveal-delay-3">
      <a href="#" class="btn-primary" data-popup="contact"><?php echo esc_html( fm( $g, 'cta_btn_text', 'קבעו שיחה ←' ) ); ?></a>
      <a href="<?php echo esc_url( freshm_whatsapp_url() ); ?>" class="btn-outline"><?php echo esc_html( fm( $g, 'cta_btn2_text', 'WhatsApp' ) ); ?></a>
    </div>
  </div>
</section>

<?php get_footer(); ?>
