<?php
/**
 * Single Blog Post
 */
get_header();
?>

<section class="page-hero">
  <div class="container">
    <?php fresh_breadcrumb(); ?>
    <h1><?php the_title(); ?></h1>
    <div class="subtitle" style="display:flex;align-items:center;justify-content:center;gap:1.5rem;font-size:0.9rem;color:var(--text-muted);">
      <span><?php echo get_the_date(); ?></span>
      <span>•</span>
      <span><?php echo fresh_reading_time(); ?></span>
      <?php $cat = get_the_category(); if ( $cat ) : ?>
        <span>•</span>
        <span style="color:var(--gold);"><?php echo esc_html( $cat[0]->name ); ?></span>
      <?php endif; ?>
    </div>
  </div>
</section>

<section class="single-post-content">
  <div class="container">
    <article class="post-article">
      <?php if ( has_post_thumbnail() ) : ?>
      <div class="post-featured-image">
        <?php the_post_thumbnail( 'large' ); ?>
      </div>
      <?php endif; ?>

      <div class="post-body">
        <?php the_content(); ?>
      </div>

      <!-- Tags -->
      <?php $tags = get_the_tags(); if ( $tags ) : ?>
      <div class="post-tags">
        <?php foreach ( $tags as $tag ) : ?>
          <a href="<?php echo esc_url( get_tag_link( $tag->term_id ) ); ?>">#<?php echo esc_html( $tag->name ); ?></a>
        <?php endforeach; ?>
      </div>
      <?php endif; ?>

      <!-- Share -->
      <div class="post-share">
        <span>שתפו:</span>
        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode( get_permalink() ); ?>" target="_blank" rel="noopener" aria-label="Facebook"><?php echo fresh_social_svg( 'facebook' ); ?></a>
        <a href="https://twitter.com/intent/tweet?url=<?php echo urlencode( get_permalink() ); ?>&text=<?php echo urlencode( get_the_title() ); ?>" target="_blank" rel="noopener" aria-label="Twitter"><?php echo fresh_social_svg( 'twitter' ); ?></a>
        <a href="https://wa.me/?text=<?php echo urlencode( get_the_title() . ' ' . get_permalink() ); ?>" target="_blank" rel="noopener" aria-label="WhatsApp"><?php echo fresh_social_svg( 'whatsapp' ); ?></a>
        <a href="https://www.linkedin.com/shareArticle?url=<?php echo urlencode( get_permalink() ); ?>" target="_blank" rel="noopener" aria-label="LinkedIn"><?php echo fresh_social_svg( 'linkedin' ); ?></a>
      </div>

      <!-- Related Posts -->
      <?php
      $related = new WP_Query( array(
          'post_type'      => 'post',
          'posts_per_page' => 3,
          'post__not_in'   => array( get_the_ID() ),
          'orderby'        => 'rand',
          'category__in'   => wp_get_post_categories( get_the_ID() ),
      ) );
      if ( $related->have_posts() ) :
      ?>
      <div class="related-posts">
        <h2>פוסטים נוספים</h2>
        <div class="related-posts-grid">
          <?php while ( $related->have_posts() ) : $related->the_post(); ?>
          <div class="blog-card">
            <a href="<?php the_permalink(); ?>">
              <div class="thumb">
                <?php if ( has_post_thumbnail() ) the_post_thumbnail( 'fresh-blog' ); ?>
              </div>
            </a>
            <div class="content">
              <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
              <div class="meta">
                <span><?php echo get_the_date(); ?></span>
                <span><?php echo fresh_reading_time(); ?></span>
              </div>
            </div>
          </div>
          <?php endwhile; wp_reset_postdata(); ?>
        </div>
      </div>
      <?php endif; ?>
    </article>

    <!-- Sidebar -->
    <aside class="blog-sidebar">
      <?php if ( is_active_sidebar( 'blog-sidebar' ) ) : ?>
        <?php dynamic_sidebar( 'blog-sidebar' ); ?>
      <?php else : ?>
        <!-- Default sidebar content -->
        <div class="sidebar-card sidebar-cta">
          <h3>רוצים לקדם את המסעדה?</h3>
          <p style="font-size:0.88rem;color:var(--text-secondary);font-weight:300;margin-bottom:1rem;line-height:1.7;">
            שיחת ייעוץ ראשונה ללא עלות. ספרו לנו על העסק שלכם.
          </p>
          <a href="#" class="btn-primary" data-popup="contact" style="width:100%;justify-content:center;">דברו איתנו ←</a>
        </div>

        <div class="sidebar-card">
          <h3>פוסטים אחרונים</h3>
          <ul class="sidebar-nav">
            <?php
            $recent = new WP_Query( array(
                'post_type'      => 'post',
                'posts_per_page' => 5,
                'post__not_in'   => array( get_the_ID() ),
            ) );
            while ( $recent->have_posts() ) : $recent->the_post();
            ?>
            <li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
            <?php endwhile; wp_reset_postdata(); ?>
          </ul>
        </div>
      <?php endif; ?>
    </aside>
  </div>
</section>

<?php get_footer(); ?>
